/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_DATA = 267,
     SQL_DATETIME_INTERVAL_CODE = 268,
     SQL_DATETIME_INTERVAL_PRECISION = 269,
     SQL_DESCRIBE = 270,
     SQL_DESCRIPTOR = 271,
     SQL_DISCONNECT = 272,
     SQL_FOUND = 273,
     SQL_FREE = 274,
     SQL_GO = 275,
     SQL_GOTO = 276,
     SQL_IDENTIFIED = 277,
     SQL_INDICATOR = 278,
     SQL_KEY_MEMBER = 279,
     SQL_LENGTH = 280,
     SQL_LONG = 281,
     SQL_NULLABLE = 282,
     SQL_OCTET_LENGTH = 283,
     SQL_OPEN = 284,
     SQL_OUTPUT = 285,
     SQL_REFERENCE = 286,
     SQL_RETURNED_LENGTH = 287,
     SQL_RETURNED_OCTET_LENGTH = 288,
     SQL_SCALE = 289,
     SQL_SECTION = 290,
     SQL_SHORT = 291,
     SQL_SIGNED = 292,
     SQL_SQL = 293,
     SQL_SQLERROR = 294,
     SQL_SQLPRINT = 295,
     SQL_SQLWARNING = 296,
     SQL_START = 297,
     SQL_STOP = 298,
     SQL_STRUCT = 299,
     SQL_UNSIGNED = 300,
     SQL_VAR = 301,
     SQL_WHENEVER = 302,
     S_ADD = 303,
     S_AND = 304,
     S_ANYTHING = 305,
     S_AUTO = 306,
     S_CONST = 307,
     S_DEC = 308,
     S_DIV = 309,
     S_DOTPOINT = 310,
     S_EQUAL = 311,
     S_EXTERN = 312,
     S_INC = 313,
     S_LSHIFT = 314,
     S_MEMPOINT = 315,
     S_MEMBER = 316,
     S_MOD = 317,
     S_MUL = 318,
     S_NEQUAL = 319,
     S_OR = 320,
     S_REGISTER = 321,
     S_RSHIFT = 322,
     S_STATIC = 323,
     S_SUB = 324,
     S_VOLATILE = 325,
     S_TYPEDEF = 326,
     TYPECAST = 327,
     ABORT_P = 328,
     ABSOLUTE_P = 329,
     ACCESS = 330,
     ACTION = 331,
     ADD_P = 332,
     ADMIN = 333,
     AFTER = 334,
     AGGREGATE = 335,
     ALL = 336,
     ALSO = 337,
     ALTER = 338,
     ALWAYS = 339,
     ANALYSE = 340,
     ANALYZE = 341,
     AND = 342,
     ANY = 343,
     ARRAY = 344,
     AS = 345,
     ASC = 346,
     ASSERTION = 347,
     ASSIGNMENT = 348,
     ASYMMETRIC = 349,
     AT = 350,
     AUTHORIZATION = 351,
     BACKWARD = 352,
     BEFORE = 353,
     BEGIN_P = 354,
     BETWEEN = 355,
     BIGINT = 356,
     BINARY = 357,
     BIT = 358,
     BOOLEAN_P = 359,
     BOTH = 360,
     BY = 361,
     CACHE = 362,
     CALLED = 363,
     CASCADE = 364,
     CASCADED = 365,
     CASE = 366,
     CAST = 367,
     CHAIN = 368,
     CHAR_P = 369,
     CHARACTER = 370,
     CHARACTERISTICS = 371,
     CHECK = 372,
     CHECKPOINT = 373,
     CLASS = 374,
     CLOSE = 375,
     CLUSTER = 376,
     COALESCE = 377,
     COLLATE = 378,
     COLUMN = 379,
     COMMENT = 380,
     COMMIT = 381,
     COMMITTED = 382,
     CONCURRENTLY = 383,
     CONFIGURATION = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONTENT_P = 388,
     CONVERSION_P = 389,
     COPY = 390,
     COST = 391,
     CREATE = 392,
     CREATEDB = 393,
     CREATEROLE = 394,
     CREATEUSER = 395,
     CROSS = 396,
     CSV = 397,
     CURRENT_P = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DICTIONARY = 421,
     DISABLE_P = 422,
     DISCARD = 423,
     DISTINCT = 424,
     DO = 425,
     DOCUMENT_P = 426,
     DOMAIN_P = 427,
     DOUBLE_P = 428,
     DROP = 429,
     EACH = 430,
     ELSE = 431,
     ENABLE_P = 432,
     ENCODING = 433,
     ENCRYPTED = 434,
     END_P = 435,
     ENUM_P = 436,
     ESCAPE = 437,
     EXCEPT = 438,
     EXCLUSIVE = 439,
     EXCLUDING = 440,
     EXECUTE = 441,
     EXISTS = 442,
     EXPLAIN = 443,
     EXTERNAL = 444,
     EXTRACT = 445,
     FALSE_P = 446,
     FAMILY = 447,
     FETCH = 448,
     FIRST_P = 449,
     FLOAT_P = 450,
     FOR = 451,
     FORCE = 452,
     FOREIGN = 453,
     FORWARD = 454,
     FREEZE = 455,
     FROM = 456,
     FULL = 457,
     FUNCTION = 458,
     GET = 459,
     GLOBAL = 460,
     GRANT = 461,
     GRANTED = 462,
     GREATEST = 463,
     GROUP_P = 464,
     HANDLER = 465,
     HAVING = 466,
     HEADER_P = 467,
     HOLD = 468,
     HOUR_P = 469,
     IF_P = 470,
     ILIKE = 471,
     IMMEDIATE = 472,
     IMMUTABLE = 473,
     IMPLICIT_P = 474,
     IN_P = 475,
     INCLUDING = 476,
     INCREMENT = 477,
     INDEX = 478,
     INDEXES = 479,
     INHERIT = 480,
     INHERITS = 481,
     INITIALLY = 482,
     INNER_P = 483,
     INOUT = 484,
     INPUT_P = 485,
     INSENSITIVE = 486,
     INSERT = 487,
     INSTEAD = 488,
     INT_P = 489,
     INTEGER = 490,
     INTERSECT = 491,
     INTERVAL = 492,
     INTO = 493,
     INVOKER = 494,
     IS = 495,
     ISNULL = 496,
     ISOLATION = 497,
     JOIN = 498,
     KEY = 499,
     LANCOMPILER = 500,
     LANGUAGE = 501,
     LARGE_P = 502,
     LAST_P = 503,
     LEADING = 504,
     LEAST = 505,
     LEFT = 506,
     LEVEL = 507,
     LIKE = 508,
     LIMIT = 509,
     LISTEN = 510,
     LOAD = 511,
     LOCAL = 512,
     LOCALTIME = 513,
     LOCALTIMESTAMP = 514,
     LOCATION = 515,
     LOCK_P = 516,
     LOGIN_P = 517,
     MAPPING = 518,
     MATCH = 519,
     MAXVALUE = 520,
     MINUTE_P = 521,
     MINVALUE = 522,
     MODE = 523,
     MONTH_P = 524,
     MOVE = 525,
     NAME_P = 526,
     NAMES = 527,
     NATIONAL = 528,
     NATURAL = 529,
     NCHAR = 530,
     NEW = 531,
     NEXT = 532,
     NO = 533,
     NOCREATEDB = 534,
     NOCREATEROLE = 535,
     NOCREATEUSER = 536,
     NOINHERIT = 537,
     NOLOGIN_P = 538,
     NONE = 539,
     NOSUPERUSER = 540,
     NOT = 541,
     NOTHING = 542,
     NOTIFY = 543,
     NOTNULL = 544,
     NOWAIT = 545,
     NULL_P = 546,
     NULLIF = 547,
     NULLS_P = 548,
     NUMERIC = 549,
     OBJECT_P = 550,
     OF = 551,
     OFF = 552,
     OFFSET = 553,
     OIDS = 554,
     OLD = 555,
     ON = 556,
     ONLY = 557,
     OPERATOR = 558,
     OPTION = 559,
     OR = 560,
     ORDER = 561,
     OUT_P = 562,
     OUTER_P = 563,
     OVERLAPS = 564,
     OVERLAY = 565,
     OWNED = 566,
     OWNER = 567,
     PARSER = 568,
     PARTIAL = 569,
     PASSWORD = 570,
     PLACING = 571,
     PLANS = 572,
     POSITION = 573,
     PRECISION = 574,
     PRESERVE = 575,
     PREPARE = 576,
     PREPARED = 577,
     PRIMARY = 578,
     PRIOR = 579,
     PRIVILEGES = 580,
     PROCEDURAL = 581,
     PROCEDURE = 582,
     QUOTE = 583,
     READ = 584,
     REAL = 585,
     REASSIGN = 586,
     RECHECK = 587,
     REFERENCES = 588,
     REINDEX = 589,
     RELATIVE_P = 590,
     RELEASE = 591,
     RENAME = 592,
     REPEATABLE = 593,
     REPLACE = 594,
     REPLICA = 595,
     RESET = 596,
     RESTART = 597,
     RESTRICT = 598,
     RETURNING = 599,
     RETURNS = 600,
     REVOKE = 601,
     RIGHT = 602,
     ROLE = 603,
     ROLLBACK = 604,
     ROW = 605,
     ROWS = 606,
     RULE = 607,
     SAVEPOINT = 608,
     SCHEMA = 609,
     SCROLL = 610,
     SEARCH = 611,
     SECOND_P = 612,
     SECURITY = 613,
     SELECT = 614,
     SEQUENCE = 615,
     SERIALIZABLE = 616,
     SESSION = 617,
     SESSION_USER = 618,
     SET = 619,
     SETOF = 620,
     SHARE = 621,
     SHOW = 622,
     SIMILAR = 623,
     SIMPLE = 624,
     SMALLINT = 625,
     SOME = 626,
     STABLE = 627,
     STANDALONE_P = 628,
     START = 629,
     STATEMENT = 630,
     STATISTICS = 631,
     STDIN = 632,
     STDOUT = 633,
     STORAGE = 634,
     STRICT_P = 635,
     STRIP_P = 636,
     SUBSTRING = 637,
     SUPERUSER_P = 638,
     SYMMETRIC = 639,
     SYSID = 640,
     SYSTEM_P = 641,
     TABLE = 642,
     TABLESPACE = 643,
     TEMP = 644,
     TEMPLATE = 645,
     TEMPORARY = 646,
     TEXT_P = 647,
     THEN = 648,
     TIME = 649,
     TIMESTAMP = 650,
     TO = 651,
     TRAILING = 652,
     TRANSACTION = 653,
     TREAT = 654,
     TRIGGER = 655,
     TRIM = 656,
     TRUE_P = 657,
     TRUNCATE = 658,
     TRUSTED = 659,
     TYPE_P = 660,
     UNCOMMITTED = 661,
     UNENCRYPTED = 662,
     UNION = 663,
     UNIQUE = 664,
     UNKNOWN = 665,
     UNLISTEN = 666,
     UNTIL = 667,
     UPDATE = 668,
     USER = 669,
     USING = 670,
     VACUUM = 671,
     VALID = 672,
     VALIDATOR = 673,
     VALUE_P = 674,
     VALUES = 675,
     VARCHAR = 676,
     VARYING = 677,
     VERBOSE = 678,
     VERSION_P = 679,
     VIEW = 680,
     VOLATILE = 681,
     WHEN = 682,
     WHERE = 683,
     WHITESPACE_P = 684,
     WITH = 685,
     WITHOUT = 686,
     WORK = 687,
     WRITE = 688,
     XML_P = 689,
     XMLATTRIBUTES = 690,
     XMLCONCAT = 691,
     XMLELEMENT = 692,
     XMLFOREST = 693,
     XMLPARSE = 694,
     XMLPI = 695,
     XMLROOT = 696,
     XMLSERIALIZE = 697,
     YEAR_P = 698,
     YES_P = 699,
     ZONE = 700,
     NULLS_FIRST = 701,
     NULLS_LAST = 702,
     WITH_CASCADED = 703,
     WITH_LOCAL = 704,
     WITH_CHECK = 705,
     IDENT = 706,
     SCONST = 707,
     Op = 708,
     CSTRING = 709,
     CVARIABLE = 710,
     CPP_LINE = 711,
     IP = 712,
     BCONST = 713,
     XCONST = 714,
     DOLCONST = 715,
     ECONST = 716,
     NCONST = 717,
     ICONST = 718,
     PARAM = 719,
     FCONST = 720,
     POSTFIXOP = 721,
     UMINUS = 722
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_DATA 267
#define SQL_DATETIME_INTERVAL_CODE 268
#define SQL_DATETIME_INTERVAL_PRECISION 269
#define SQL_DESCRIBE 270
#define SQL_DESCRIPTOR 271
#define SQL_DISCONNECT 272
#define SQL_FOUND 273
#define SQL_FREE 274
#define SQL_GO 275
#define SQL_GOTO 276
#define SQL_IDENTIFIED 277
#define SQL_INDICATOR 278
#define SQL_KEY_MEMBER 279
#define SQL_LENGTH 280
#define SQL_LONG 281
#define SQL_NULLABLE 282
#define SQL_OCTET_LENGTH 283
#define SQL_OPEN 284
#define SQL_OUTPUT 285
#define SQL_REFERENCE 286
#define SQL_RETURNED_LENGTH 287
#define SQL_RETURNED_OCTET_LENGTH 288
#define SQL_SCALE 289
#define SQL_SECTION 290
#define SQL_SHORT 291
#define SQL_SIGNED 292
#define SQL_SQL 293
#define SQL_SQLERROR 294
#define SQL_SQLPRINT 295
#define SQL_SQLWARNING 296
#define SQL_START 297
#define SQL_STOP 298
#define SQL_STRUCT 299
#define SQL_UNSIGNED 300
#define SQL_VAR 301
#define SQL_WHENEVER 302
#define S_ADD 303
#define S_AND 304
#define S_ANYTHING 305
#define S_AUTO 306
#define S_CONST 307
#define S_DEC 308
#define S_DIV 309
#define S_DOTPOINT 310
#define S_EQUAL 311
#define S_EXTERN 312
#define S_INC 313
#define S_LSHIFT 314
#define S_MEMPOINT 315
#define S_MEMBER 316
#define S_MOD 317
#define S_MUL 318
#define S_NEQUAL 319
#define S_OR 320
#define S_REGISTER 321
#define S_RSHIFT 322
#define S_STATIC 323
#define S_SUB 324
#define S_VOLATILE 325
#define S_TYPEDEF 326
#define TYPECAST 327
#define ABORT_P 328
#define ABSOLUTE_P 329
#define ACCESS 330
#define ACTION 331
#define ADD_P 332
#define ADMIN 333
#define AFTER 334
#define AGGREGATE 335
#define ALL 336
#define ALSO 337
#define ALTER 338
#define ALWAYS 339
#define ANALYSE 340
#define ANALYZE 341
#define AND 342
#define ANY 343
#define ARRAY 344
#define AS 345
#define ASC 346
#define ASSERTION 347
#define ASSIGNMENT 348
#define ASYMMETRIC 349
#define AT 350
#define AUTHORIZATION 351
#define BACKWARD 352
#define BEFORE 353
#define BEGIN_P 354
#define BETWEEN 355
#define BIGINT 356
#define BINARY 357
#define BIT 358
#define BOOLEAN_P 359
#define BOTH 360
#define BY 361
#define CACHE 362
#define CALLED 363
#define CASCADE 364
#define CASCADED 365
#define CASE 366
#define CAST 367
#define CHAIN 368
#define CHAR_P 369
#define CHARACTER 370
#define CHARACTERISTICS 371
#define CHECK 372
#define CHECKPOINT 373
#define CLASS 374
#define CLOSE 375
#define CLUSTER 376
#define COALESCE 377
#define COLLATE 378
#define COLUMN 379
#define COMMENT 380
#define COMMIT 381
#define COMMITTED 382
#define CONCURRENTLY 383
#define CONFIGURATION 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONTENT_P 388
#define CONVERSION_P 389
#define COPY 390
#define COST 391
#define CREATE 392
#define CREATEDB 393
#define CREATEROLE 394
#define CREATEUSER 395
#define CROSS 396
#define CSV 397
#define CURRENT_P 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DICTIONARY 421
#define DISABLE_P 422
#define DISCARD 423
#define DISTINCT 424
#define DO 425
#define DOCUMENT_P 426
#define DOMAIN_P 427
#define DOUBLE_P 428
#define DROP 429
#define EACH 430
#define ELSE 431
#define ENABLE_P 432
#define ENCODING 433
#define ENCRYPTED 434
#define END_P 435
#define ENUM_P 436
#define ESCAPE 437
#define EXCEPT 438
#define EXCLUSIVE 439
#define EXCLUDING 440
#define EXECUTE 441
#define EXISTS 442
#define EXPLAIN 443
#define EXTERNAL 444
#define EXTRACT 445
#define FALSE_P 446
#define FAMILY 447
#define FETCH 448
#define FIRST_P 449
#define FLOAT_P 450
#define FOR 451
#define FORCE 452
#define FOREIGN 453
#define FORWARD 454
#define FREEZE 455
#define FROM 456
#define FULL 457
#define FUNCTION 458
#define GET 459
#define GLOBAL 460
#define GRANT 461
#define GRANTED 462
#define GREATEST 463
#define GROUP_P 464
#define HANDLER 465
#define HAVING 466
#define HEADER_P 467
#define HOLD 468
#define HOUR_P 469
#define IF_P 470
#define ILIKE 471
#define IMMEDIATE 472
#define IMMUTABLE 473
#define IMPLICIT_P 474
#define IN_P 475
#define INCLUDING 476
#define INCREMENT 477
#define INDEX 478
#define INDEXES 479
#define INHERIT 480
#define INHERITS 481
#define INITIALLY 482
#define INNER_P 483
#define INOUT 484
#define INPUT_P 485
#define INSENSITIVE 486
#define INSERT 487
#define INSTEAD 488
#define INT_P 489
#define INTEGER 490
#define INTERSECT 491
#define INTERVAL 492
#define INTO 493
#define INVOKER 494
#define IS 495
#define ISNULL 496
#define ISOLATION 497
#define JOIN 498
#define KEY 499
#define LANCOMPILER 500
#define LANGUAGE 501
#define LARGE_P 502
#define LAST_P 503
#define LEADING 504
#define LEAST 505
#define LEFT 506
#define LEVEL 507
#define LIKE 508
#define LIMIT 509
#define LISTEN 510
#define LOAD 511
#define LOCAL 512
#define LOCALTIME 513
#define LOCALTIMESTAMP 514
#define LOCATION 515
#define LOCK_P 516
#define LOGIN_P 517
#define MAPPING 518
#define MATCH 519
#define MAXVALUE 520
#define MINUTE_P 521
#define MINVALUE 522
#define MODE 523
#define MONTH_P 524
#define MOVE 525
#define NAME_P 526
#define NAMES 527
#define NATIONAL 528
#define NATURAL 529
#define NCHAR 530
#define NEW 531
#define NEXT 532
#define NO 533
#define NOCREATEDB 534
#define NOCREATEROLE 535
#define NOCREATEUSER 536
#define NOINHERIT 537
#define NOLOGIN_P 538
#define NONE 539
#define NOSUPERUSER 540
#define NOT 541
#define NOTHING 542
#define NOTIFY 543
#define NOTNULL 544
#define NOWAIT 545
#define NULL_P 546
#define NULLIF 547
#define NULLS_P 548
#define NUMERIC 549
#define OBJECT_P 550
#define OF 551
#define OFF 552
#define OFFSET 553
#define OIDS 554
#define OLD 555
#define ON 556
#define ONLY 557
#define OPERATOR 558
#define OPTION 559
#define OR 560
#define ORDER 561
#define OUT_P 562
#define OUTER_P 563
#define OVERLAPS 564
#define OVERLAY 565
#define OWNED 566
#define OWNER 567
#define PARSER 568
#define PARTIAL 569
#define PASSWORD 570
#define PLACING 571
#define PLANS 572
#define POSITION 573
#define PRECISION 574
#define PRESERVE 575
#define PREPARE 576
#define PREPARED 577
#define PRIMARY 578
#define PRIOR 579
#define PRIVILEGES 580
#define PROCEDURAL 581
#define PROCEDURE 582
#define QUOTE 583
#define READ 584
#define REAL 585
#define REASSIGN 586
#define RECHECK 587
#define REFERENCES 588
#define REINDEX 589
#define RELATIVE_P 590
#define RELEASE 591
#define RENAME 592
#define REPEATABLE 593
#define REPLACE 594
#define REPLICA 595
#define RESET 596
#define RESTART 597
#define RESTRICT 598
#define RETURNING 599
#define RETURNS 600
#define REVOKE 601
#define RIGHT 602
#define ROLE 603
#define ROLLBACK 604
#define ROW 605
#define ROWS 606
#define RULE 607
#define SAVEPOINT 608
#define SCHEMA 609
#define SCROLL 610
#define SEARCH 611
#define SECOND_P 612
#define SECURITY 613
#define SELECT 614
#define SEQUENCE 615
#define SERIALIZABLE 616
#define SESSION 617
#define SESSION_USER 618
#define SET 619
#define SETOF 620
#define SHARE 621
#define SHOW 622
#define SIMILAR 623
#define SIMPLE 624
#define SMALLINT 625
#define SOME 626
#define STABLE 627
#define STANDALONE_P 628
#define START 629
#define STATEMENT 630
#define STATISTICS 631
#define STDIN 632
#define STDOUT 633
#define STORAGE 634
#define STRICT_P 635
#define STRIP_P 636
#define SUBSTRING 637
#define SUPERUSER_P 638
#define SYMMETRIC 639
#define SYSID 640
#define SYSTEM_P 641
#define TABLE 642
#define TABLESPACE 643
#define TEMP 644
#define TEMPLATE 645
#define TEMPORARY 646
#define TEXT_P 647
#define THEN 648
#define TIME 649
#define TIMESTAMP 650
#define TO 651
#define TRAILING 652
#define TRANSACTION 653
#define TREAT 654
#define TRIGGER 655
#define TRIM 656
#define TRUE_P 657
#define TRUNCATE 658
#define TRUSTED 659
#define TYPE_P 660
#define UNCOMMITTED 661
#define UNENCRYPTED 662
#define UNION 663
#define UNIQUE 664
#define UNKNOWN 665
#define UNLISTEN 666
#define UNTIL 667
#define UPDATE 668
#define USER 669
#define USING 670
#define VACUUM 671
#define VALID 672
#define VALIDATOR 673
#define VALUE_P 674
#define VALUES 675
#define VARCHAR 676
#define VARYING 677
#define VERBOSE 678
#define VERSION_P 679
#define VIEW 680
#define VOLATILE 681
#define WHEN 682
#define WHERE 683
#define WHITESPACE_P 684
#define WITH 685
#define WITHOUT 686
#define WORK 687
#define WRITE 688
#define XML_P 689
#define XMLATTRIBUTES 690
#define XMLCONCAT 691
#define XMLELEMENT 692
#define XMLFOREST 693
#define XMLPARSE 694
#define XMLPI 695
#define XMLROOT 696
#define XMLSERIALIZE 697
#define YEAR_P 698
#define YES_P 699
#define ZONE 700
#define NULLS_FIRST 701
#define NULLS_LAST 702
#define WITH_CASCADED 703
#define WITH_LOCAL 704
#define WITH_CHECK 705
#define IDENT 706
#define SCONST 707
#define Op 708
#define CSTRING 709
#define CVARIABLE 710
#define CPP_LINE 711
#define IP 712
#define BCONST 713
#define XCONST 714
#define DOLCONST 715
#define ECONST 716
#define NCONST 717
#define ICONST 718
#define PARAM 719
#define FCONST 720
#define POSTFIXOP 721
#define UMINUS 722




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			fclose(yyin);
			fclose(yyout);
			if (unlink(output_filename) != 0 && *output_filename != '-')
			        fprintf(stderr, "Could not remove output file %s!\n", output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->lineno), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->lineno), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->lineno), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "Initializer not allowed in typedef command");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "Type %s already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "No multidimensional array support for simple data types");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 372 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1398 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1422 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   72601

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  488
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  565
/* YYNRULES -- Number of rules. */
#define YYNRULES  2240
/* YYNRULES -- Number of states. */
#define YYNSTATES  3862

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   723

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   474,     2,     2,
     479,   480,   472,   470,   486,   471,   481,   473,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   487,   482,
     467,   466,   468,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   477,     2,   478,   475,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   483,     2,   484,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   469,   476,   485
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   240,   242,   244,
     246,   248,   250,   252,   254,   260,   262,   263,   266,   269,
     273,   277,   279,   281,   283,   285,   287,   289,   291,   293,
     295,   297,   301,   305,   308,   311,   314,   317,   321,   325,
     331,   337,   342,   348,   353,   357,   363,   367,   373,   379,
     386,   388,   390,   394,   400,   407,   412,   414,   415,   418,
     419,   421,   423,   425,   427,   429,   431,   434,   438,   442,
     446,   450,   454,   458,   462,   466,   469,   475,   478,   481,
     485,   489,   493,   495,   499,   501,   505,   508,   511,   514,
     516,   518,   520,   522,   524,   526,   528,   530,   532,   534,
     538,   545,   547,   549,   551,   553,   554,   556,   558,   562,
     567,   573,   578,   581,   584,   588,   593,   597,   600,   603,
     605,   610,   612,   614,   616,   618,   620,   623,   626,   629,
     632,   637,   642,   644,   648,   652,   657,   664,   671,   678,
     685,   690,   697,   700,   705,   709,   713,   717,   721,   726,
     731,   735,   739,   743,   747,   751,   755,   760,   765,   769,
     772,   776,   778,   780,   784,   788,   792,   795,   798,   802,
     805,   807,   809,   810,   813,   814,   817,   820,   830,   837,
     839,   841,   843,   845,   847,   850,   851,   853,   855,   859,
     863,   865,   867,   871,   875,   879,   884,   886,   887,   890,
     891,   895,   896,   898,   899,   911,   924,   926,   928,   931,
     934,   937,   940,   941,   943,   944,   946,   950,   952,   954,
     956,   960,   963,   964,   968,   970,   972,   975,   977,   981,
     986,   991,   994,  1000,  1002,  1005,  1008,  1011,  1015,  1018,
    1019,  1022,  1025,  1028,  1031,  1034,  1037,  1041,  1043,  1048,
    1055,  1063,  1075,  1079,  1080,  1084,  1086,  1088,  1091,  1094,
    1095,  1097,  1099,  1102,  1105,  1106,  1110,  1114,  1117,  1119,
    1121,  1124,  1127,  1132,  1133,  1136,  1139,  1142,  1143,  1147,
    1152,  1157,  1158,  1161,  1162,  1167,  1168,  1169,  1177,  1183,
    1187,  1188,  1192,  1194,  1196,  1202,  1207,  1210,  1211,  1214,
    1216,  1219,  1223,  1226,  1229,  1232,  1235,  1239,  1243,  1247,
    1249,  1250,  1256,  1266,  1268,  1269,  1271,  1274,  1277,  1278,
    1281,  1282,  1288,  1296,  1298,  1299,  1306,  1309,  1310,  1314,
    1320,  1335,  1355,  1357,  1359,  1361,  1365,  1371,  1373,  1375,
    1377,  1381,  1382,  1384,  1385,  1387,  1389,  1391,  1395,  1396,
    1398,  1400,  1401,  1404,  1406,  1409,  1411,  1414,  1415,  1418,
    1420,  1423,  1426,  1433,  1442,  1451,  1455,  1461,  1466,  1471,
    1476,  1480,  1488,  1497,  1504,  1511,  1518,  1525,  1529,  1531,
    1535,  1539,  1541,  1543,  1545,  1547,  1549,  1553,  1557,  1561,
    1563,  1567,  1571,  1573,  1577,  1591,  1593,  1597,  1602,  1610,
    1615,  1623,  1626,  1628,  1629,  1632,  1633,  1635,  1636,  1643,
    1652,  1661,  1663,  1667,  1673,  1679,  1687,  1697,  1705,  1715,
    1721,  1728,  1735,  1740,  1742,  1744,  1746,  1748,  1750,  1752,
    1754,  1756,  1760,  1764,  1768,  1772,  1774,  1778,  1780,  1783,
    1786,  1790,  1795,  1801,  1806,  1811,  1815,  1820,  1824,  1828,
    1831,  1836,  1839,  1841,  1843,  1845,  1847,  1850,  1853,  1855,
    1857,  1859,  1862,  1865,  1867,  1870,  1873,  1875,  1877,  1884,
    1892,  1900,  1910,  1919,  1928,  1935,  1945,  1955,  1963,  1974,
    1982,  1991,  2000,  2009,  2018,  2020,  2022,  2024,  2026,  2028,
    2030,  2032,  2034,  2036,  2038,  2040,  2042,  2044,  2046,  2054,
    2062,  2073,  2076,  2078,  2080,  2082,  2086,  2088,  2090,  2092,
    2094,  2096,  2099,  2102,  2105,  2108,  2111,  2114,  2117,  2119,
    2123,  2125,  2128,  2132,  2133,  2135,  2139,  2142,  2149,  2156,
    2160,  2161,  2165,  2166,  2180,  2195,  2197,  2198,  2201,  2202,
    2204,  2208,  2213,  2218,  2225,  2227,  2230,  2231,  2233,  2235,
    2236,  2238,  2240,  2241,  2251,  2259,  2262,  2263,  2267,  2270,
    2272,  2276,  2280,  2284,  2287,  2290,  2292,  2294,  2296,  2298,
    2301,  2303,  2307,  2309,  2311,  2313,  2318,  2324,  2326,  2329,
    2334,  2340,  2342,  2344,  2346,  2348,  2352,  2356,  2359,  2362,
    2365,  2368,  2370,  2373,  2376,  2378,  2381,  2382,  2388,  2390,
    2393,  2395,  2396,  2402,  2410,  2416,  2424,  2432,  2442,  2444,
    2448,  2452,  2456,  2458,  2462,  2474,  2485,  2488,  2489,  2499,
    2502,  2503,  2508,  2513,  2518,  2520,  2522,  2524,  2525,  2533,
    2540,  2547,  2554,  2561,  2569,  2579,  2589,  2596,  2603,  2610,
    2617,  2624,  2633,  2642,  2649,  2656,  2665,  2674,  2683,  2692,
    2694,  2695,  2703,  2710,  2717,  2724,  2731,  2738,  2746,  2753,
    2760,  2767,  2774,  2782,  2792,  2802,  2812,  2819,  2826,  2833,
    2842,  2851,  2852,  2867,  2869,  2871,  2875,  2879,  2881,  2883,
    2885,  2887,  2889,  2891,  2893,  2894,  2896,  2898,  2900,  2902,
    2904,  2906,  2907,  2914,  2923,  2926,  2929,  2932,  2935,  2938,
    2942,  2946,  2949,  2952,  2955,  2958,  2962,  2965,  2971,  2976,
    2980,  2984,  2988,  2990,  2992,  2993,  2997,  3000,  3003,  3005,
    3009,  3012,  3014,  3015,  3024,  3035,  3038,  3042,  3046,  3047,
    3050,  3056,  3060,  3062,  3065,  3069,  3073,  3077,  3081,  3085,
    3089,  3093,  3097,  3102,  3106,  3110,  3112,  3113,  3119,  3124,
    3127,  3128,  3133,  3137,  3143,  3150,  3155,  3162,  3169,  3175,
    3183,  3185,  3186,  3193,  3205,  3217,  3229,  3243,  3253,  3265,
    3276,  3280,  3282,  3287,  3290,  3291,  3296,  3302,  3308,  3311,
    3316,  3318,  3320,  3322,  3323,  3325,  3326,  3328,  3329,  3333,
    3334,  3339,  3341,  3343,  3345,  3347,  3349,  3351,  3353,  3354,
    3360,  3365,  3367,  3369,  3371,  3373,  3377,  3378,  3383,  3392,
    3396,  3397,  3400,  3404,  3407,  3411,  3417,  3419,  3424,  3427,
    3431,  3433,  3436,  3439,  3440,  3447,  3450,  3451,  3457,  3461,
    3462,  3465,  3468,  3471,  3475,  3477,  3481,  3483,  3486,  3488,
    3489,  3497,  3499,  3503,  3505,  3507,  3511,  3517,  3520,  3522,
    3526,  3534,  3535,  3538,  3541,  3544,  3548,  3549,  3552,  3555,
    3557,  3559,  3563,  3567,  3569,  3572,  3577,  3582,  3584,  3586,
    3595,  3597,  3602,  3607,  3612,  3615,  3617,  3618,  3622,  3626,
    3631,  3636,  3641,  3646,  3649,  3651,  3653,  3654,  3656,  3657,
    3659,  3665,  3667,  3668,  3670,  3671,  3675,  3677,  3681,  3686,
    3690,  3695,  3700,  3703,  3706,  3711,  3713,  3714,  3716,  3718,
    3720,  3724,  3725,  3728,  3729,  3731,  3735,  3737,  3738,  3740,
    3743,  3748,  3753,  3756,  3757,  3760,  3764,  3767,  3768,  3772,
    3774,  3776,  3779,  3781,  3784,  3790,  3797,  3803,  3805,  3808,
    3810,  3815,  3819,  3824,  3830,  3835,  3841,  3846,  3852,  3855,
    3860,  3862,  3865,  3868,  3871,  3873,  3875,  3876,  3881,  3884,
    3886,  3889,  3892,  3897,  3899,  3902,  3906,  3908,  3911,  3912,
    3915,  3920,  3925,  3926,  3928,  3932,  3935,  3938,  3942,  3948,
    3955,  3959,  3964,  3965,  3967,  3971,  3975,  3979,  3983,  3987,
    3991,  3993,  3995,  3997,  3999,  4001,  4003,  4005,  4008,  4014,
    4016,  4018,  4020,  4022,  4025,  4029,  4033,  4034,  4036,  4038,
    4040,  4042,  4044,  4047,  4050,  4053,  4056,  4059,  4061,  4065,
    4066,  4068,  4070,  4072,  4074,  4080,  4083,  4085,  4087,  4089,
    4091,  4097,  4100,  4103,  4106,  4108,  4112,  4116,  4119,  4121,
    4122,  4126,  4127,  4133,  4136,  4142,  4145,  4147,  4151,  4155,
    4156,  4158,  4160,  4162,  4164,  4166,  4168,  4172,  4176,  4180,
    4184,  4188,  4192,  4196,  4197,  4199,  4203,  4209,  4212,  4215,
    4219,  4223,  4227,  4231,  4235,  4239,  4243,  4247,  4251,  4255,
    4258,  4261,  4265,  4269,  4272,  4276,  4282,  4287,  4294,  4298,
    4304,  4309,  4316,  4321,  4328,  4334,  4342,  4345,  4349,  4352,
    4357,  4361,  4365,  4370,  4374,  4379,  4383,  4388,  4394,  4401,
    4408,  4416,  4423,  4431,  4438,  4446,  4450,  4455,  4460,  4467,
    4470,  4474,  4479,  4481,  4485,  4488,  4492,  4496,  4500,  4504,
    4508,  4512,  4516,  4520,  4524,  4528,  4531,  4534,  4540,  4547,
    4554,  4562,  4566,  4571,  4573,  4575,  4578,  4583,  4585,  4587,
    4589,  4592,  4595,  4598,  4600,  4604,  4609,  4615,  4621,  4626,
    4628,  4630,  4635,  4637,  4642,  4644,  4649,  4651,  4656,  4658,
    4660,  4662,  4664,  4671,  4676,  4681,  4686,  4691,  4698,  4704,
    4710,  4716,  4721,  4728,  4733,  4738,  4743,  4748,  4754,  4762,
    4770,  4780,  4785,  4792,  4798,  4806,  4814,  4817,  4821,  4825,
    4829,  4834,  4835,  4840,  4842,  4846,  4850,  4852,  4854,  4856,
    4859,  4862,  4863,  4868,  4872,  4878,  4880,  4882,  4884,  4886,
    4888,  4890,  4892,  4894,  4896,  4898,  4900,  4902,  4904,  4906,
    4908,  4913,  4915,  4920,  4922,  4927,  4929,  4932,  4934,  4937,
    4939,  4943,  4947,  4948,  4950,  4954,  4956,  4960,  4964,  4968,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4989,  4993,
    4996,  5000,  5001,  5005,  5009,  5012,  5015,  5017,  5018,  5021,
    5024,  5028,  5031,  5033,  5035,  5039,  5045,  5048,  5050,  5055,
    5058,  5059,  5061,  5062,  5064,  5067,  5070,  5073,  5077,  5083,
    5085,  5088,  5089,  5092,  5094,  5095,  5097,  5099,  5101,  5105,
    5109,  5113,  5115,  5119,  5121,  5123,  5125,  5127,  5129,  5133,
    5135,  5138,  5140,  5144,  5146,  5148,  5150,  5152,  5154,  5156,
    5158,  5161,  5163,  5166,  5170,  5177,  5179,  5181,  5183,  5185,
    5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,  5205,
    5207,  5210,  5212,  5214,  5216,  5218,  5221,  5224,  5226,  5228,
    5230,  5232,  5234,  5236,  5238,  5240,  5243,  5246,  5248,  5250,
    5252,  5254,  5256,  5258,  5260,  5262,  5265,  5271,  5273,  5275,
    5277,  5279,  5285,  5289,  5292,  5295,  5299,  5307,  5309,  5311,
    5313,  5314,  5317,  5320,  5322,  5323,  5325,  5329,  5331,  5334,
    5335,  5338,  5339,  5342,  5343,  5345,  5349,  5354,  5358,  5360,
    5362,  5364,  5367,  5368,  5376,  5380,  5382,  5384,  5386,  5388,
    5391,  5392,  5394,  5398,  5402,  5406,  5410,  5411,  5416,  5422,
    5428,  5429,  5431,  5433,  5435,  5437,  5440,  5443,  5446,  5448,
    5451,  5452,  5460,  5461,  5467,  5468,  5473,  5476,  5479,  5480,
    5483,  5485,  5487,  5489,  5491,  5493,  5495,  5497,  5499,  5501,
    5503,  5505,  5511,  5514,  5516,  5520,  5523,  5526,  5530,  5531,
    5537,  5539,  5540,  5546,  5549,  5552,  5554,  5556,  5558,  5561,
    5564,  5568,  5570,  5573,  5576,  5580,  5584,  5589,  5592,  5594,
    5597,  5599,  5601,  5604,  5607,  5611,  5613,  5615,  5617,  5619,
    5620,  5622,  5626,  5632,  5633,  5636,  5637,  5639,  5642,  5646,
    5649,  5651,  5653,  5655,  5656,  5658,  5660,  5662,  5665,  5668,
    5670,  5672,  5673,  5675,  5677,  5679,  5681,  5684,  5687,  5691,
    5692,  5694,  5697,  5699,  5704,  5709,  5710,  5712,  5715,  5717,
    5719,  5723,  5725,  5727,  5732,  5737,  5742,  5744,  5745,  5749,
    5753,  5758,  5760,  5764,  5768,  5773,  5775,  5779,  5783,  5785,
    5792,  5794,  5798,  5802,  5809,  5811,  5815,  5819,  5821,  5823,
    5825,  5827,  5829,  5831,  5833,  5835,  5837,  5839,  5841,  5843,
    5845,  5847,  5849,  5854,  5859,  5861,  5863,  5868,  5873,  5877,
    5878,  5886,  5888,  5889,  5890,  5898,  5902,  5907,  5911,  5913,
    5915,  5917,  5920,  5924,  5930,  5933,  5939,  5942,  5944,  5946,
    5948,  5950,  5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,
    5968,  5970,  5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,
    5988,  5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,
    6008,  6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,
    6028,  6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,
    6048,  6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,
    6068,  6070,  6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,
    6088,  6090,  6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,
    6108,  6110,  6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,
    6128,  6130,  6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,
    6148,  6150,  6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,
    6168,  6170,  6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,
    6188,  6190,  6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,
    6208,  6210,  6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,
    6228,  6230,  6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,
    6248,  6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,
    6268,  6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,
    6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,
    6308,  6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,
    6328,  6330,  6332,  6334,  6336,  6338,  6340,  6342,  6344,  6346,
    6348,  6350,  6352,  6354,  6356,  6358,  6360,  6362,  6364,  6366,
    6368,  6370,  6372,  6374,  6376,  6378,  6380,  6382,  6384,  6386,
    6388,  6390,  6392,  6394,  6396,  6398,  6400,  6402,  6404,  6406,
    6408,  6410,  6412,  6414,  6416,  6418,  6420,  6422,  6424,  6426,
    6428,  6430,  6432,  6434,  6436,  6438,  6440,  6442,  6444,  6446,
    6448,  6450,  6452,  6454,  6456,  6458,  6460,  6462,  6464,  6466,
    6468,  6470,  6472,  6474,  6476,  6478,  6480,  6482,  6484,  6486,
    6488,  6490,  6492,  6494,  6496,  6498,  6500,  6502,  6504,  6506,
    6508,  6510,  6512,  6514,  6516,  6518,  6520,  6522,  6524,  6526,
    6528,  6530,  6532,  6534,  6536,  6538,  6540,  6542,  6544,  6546,
    6548,  6550,  6552,  6554,  6556,  6558,  6560,  6562,  6564,  6566,
    6568,  6570,  6572,  6574,  6576,  6578,  6580,  6582,  6584,  6586,
    6588,  6590,  6592,  6594,  6596,  6598,  6600,  6602,  6604,  6606,
    6608,  6610,  6612,  6614,  6616,  6618,  6620,  6622,  6624,  6626,
    6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,  6644,  6646,
    6648,  6650,  6652,  6654,  6656,  6658,  6660,  6662,  6664,  6666,
    6668,  6670,  6672,  6674,  6676,  6678,  6680,  6682,  6684,  6686,
    6688,  6690,  6692,  6694,  6696,  6698,  6700,  6702,  6704,  6706,
    6708,  6710,  6712,  6714,  6716,  6718,  6720,  6722,  6724,  6726,
    6728,  6730,  6732,  6734,  6736,  6738,  6740,  6742,  6744,  6746,
    6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,  6764,  6766,
    6768,  6770,  6772,  6774,  6776,  6778,  6780,  6782,  6784,  6786,
    6788,  6790,  6792,  6794,  6796,  6798,  6800,  6802,  6804,  6806,
    6808,  6810,  6812,  6814,  6816,  6818,  6820,  6822,  6824,  6826,
    6828,  6830,  6832,  6834,  6836,  6840,  6842,  6843,  6845,  6848,
    6850,  6853,  6855,  6857,  6860,  6863,  6865,  6867,  6869,  6871,
    6873,  6875,  6878,  6882,  6884,  6887,  6889,  6893,  6895,  6899,
    6901,  6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,
    6921,  6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,
    6941,  6943,  6945,  6947,  6949,  6951,  6953,  6955,  6957,  6959,
    6961,  6963,  6965,  6967,  6969,  6971,  6973,  6975,  6977,  6979,
    6981,  6983,  6985,  6987,  6989,  6991,  6993,  6995,  6997,  6999,
    7001,  7003,  7005,  7007,  7009,  7011,  7013,  7015,  7017,  7019,
    7021
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     489,     0,    -1,   490,    -1,    -1,   490,   491,    -1,  1038,
     492,   493,   482,    -1,  1038,   493,   482,    -1,  1038,   935,
      -1,   940,    -1,  1051,    -1,   456,    -1,   483,    -1,   484,
      -1,    95,   976,    -1,   729,    -1,   730,    -1,   735,    -1,
     686,    -1,   505,    -1,   703,    -1,   704,    -1,   583,    -1,
     530,    -1,   499,    -1,   498,    -1,   738,    -1,   737,    -1,
     500,    -1,   501,    -1,   743,    -1,   528,    -1,   538,    -1,
     740,    -1,   646,    -1,   525,    -1,   539,    -1,   576,    -1,
     611,    -1,   694,    -1,   739,    -1,   734,    -1,   672,    -1,
     504,    -1,   587,    -1,   623,    -1,   629,    -1,   630,    -1,
     494,    -1,   508,    -1,   582,    -1,   548,    -1,   594,    -1,
     597,    -1,   497,    -1,   725,    -1,   757,    -1,   776,    -1,
     613,    -1,   763,    -1,   529,    -1,   612,    -1,   696,    -1,
     507,    -1,   633,    -1,   634,    -1,   635,    -1,   592,    -1,
     502,    -1,   713,    -1,   637,    -1,   596,    -1,   610,    -1,
     503,    -1,   733,    -1,   749,    -1,   755,    -1,   643,    -1,
     649,    -1,   660,    -1,   664,    -1,   758,    -1,   715,    -1,
     724,    -1,   765,    -1,   714,    -1,   752,    -1,   636,    -1,
     698,    -1,   690,    -1,   691,    -1,   689,    -1,   701,    -1,
     650,    -1,   661,    -1,   705,    -1,   779,    -1,   717,    -1,
     642,    -1,   716,    -1,   769,    -1,   742,    -1,   512,    -1,
     522,    -1,   523,    -1,   722,    -1,   992,    -1,   919,    -1,
     933,    -1,   993,    -1,   973,    -1,   990,    -1,   974,    -1,
     934,    -1,   980,    -1,  1001,    -1,   994,    -1,   981,    -1,
    1008,    -1,  1010,    -1,  1004,    -1,   997,    -1,  1011,    -1,
    1014,    -1,  1016,    -1,   137,   348,   917,   495,   496,    -1,
     430,    -1,    -1,   315,   907,    -1,   315,   291,    -1,   179,
     315,   907,    -1,   407,   315,   907,    -1,   383,    -1,   285,
      -1,   225,    -1,   282,    -1,   138,    -1,   279,    -1,   139,
      -1,   280,    -1,   262,    -1,   283,    -1,   130,   254,   909,
      -1,   417,   412,   907,    -1,   414,   894,    -1,   385,   908,
      -1,    78,   894,    -1,   348,   894,    -1,   220,   348,   894,
      -1,   220,   209,   894,    -1,   137,   414,   917,   495,   496,
      -1,    83,   348,   917,   495,   496,    -1,    83,   348,   917,
     524,    -1,    83,   414,   917,   495,   496,    -1,    83,   414,
     917,   524,    -1,   174,   348,   894,    -1,   174,   348,   215,
     187,   894,    -1,   174,   414,   894,    -1,   174,   414,   215,
     187,   894,    -1,   137,   209,   917,   495,   496,    -1,    83,
     209,   917,   506,   414,   894,    -1,    77,    -1,   174,    -1,
     174,   209,   894,    -1,   174,   209,   215,   187,   894,    -1,
     137,   354,   509,    96,   917,   510,    -1,   137,   354,  1024,
     510,    -1,  1024,    -1,    -1,   510,   511,    -1,    -1,   548,
      -1,   664,    -1,   582,    -1,   597,    -1,   649,    -1,   722,
      -1,   364,   513,    -1,   364,   257,   513,    -1,   364,   362,
     513,    -1,   514,   396,   515,    -1,   514,   485,   515,    -1,
     514,   396,   157,    -1,   514,   485,   157,    -1,   514,   201,
     143,    -1,   394,   445,   519,    -1,   398,   720,    -1,   362,
     116,    90,   398,   720,    -1,   272,   520,    -1,   348,   521,
      -1,   362,    96,   521,    -1,   362,    96,   157,    -1,   434,
     304,   853,    -1,  1023,    -1,   514,   481,  1024,    -1,   517,
      -1,   515,   486,   517,    -1,   329,   406,    -1,   329,   127,
      -1,   338,   329,    -1,   361,    -1,   518,    -1,   915,    -1,
    1024,    -1,   402,    -1,   191,    -1,   301,    -1,   297,    -1,
     915,    -1,  1045,    -1,   841,   912,   843,    -1,   841,   479,
     908,   480,   912,   843,    -1,   157,    -1,   257,    -1,   912,
      -1,   157,    -1,    -1,  1024,    -1,   912,    -1,   367,   514,
     987,    -1,   367,   394,   445,   987,    -1,   367,   398,   242,
     252,   987,    -1,   367,   362,    96,   987,    -1,   367,    81,
      -1,   341,   514,    -1,   341,   394,   445,    -1,   341,   398,
     242,   252,    -1,   341,   362,    96,    -1,   341,    81,    -1,
     364,   513,    -1,   523,    -1,   364,   132,   526,   527,    -1,
      81,    -1,   892,    -1,   160,    -1,   217,    -1,   118,    -1,
     168,    81,    -1,   168,   389,    -1,   168,   391,    -1,   168,
     317,    -1,    83,   387,   813,   531,    -1,    83,   223,   813,
     533,    -1,   532,    -1,   531,   486,   532,    -1,    77,   702,
     553,    -1,    83,   702,  1024,   535,    -1,    83,   702,  1024,
     174,   286,   291,    -1,    83,   702,  1024,   364,   286,   291,
      -1,    83,   702,  1024,   364,   376,   908,    -1,    83,   702,
    1024,   364,   379,  1024,    -1,   174,   702,  1024,   536,    -1,
      83,   702,  1024,   405,   820,   537,    -1,    77,   561,    -1,
     174,   131,   895,   536,    -1,   364,   431,   299,    -1,   121,
     301,   895,    -1,   364,   431,   121,    -1,   177,   400,   895,
      -1,   177,    84,   400,   895,    -1,   177,   340,   400,   895,
      -1,   177,   400,    81,    -1,   177,   400,   414,    -1,   167,
     400,   895,    -1,   167,   400,    81,    -1,   167,   400,   414,
      -1,   177,   352,   895,    -1,   177,    84,   352,   895,    -1,
     177,   340,   352,   895,    -1,   167,   352,   895,    -1,   225,
     893,    -1,   278,   225,   893,    -1,   534,    -1,   534,    -1,
     533,   486,   534,    -1,   312,   396,   917,    -1,   364,   388,
     895,    -1,   364,   614,    -1,   341,   614,    -1,   364,   157,
     844,    -1,   174,   157,    -1,   109,    -1,   343,    -1,    -1,
     415,   844,    -1,    -1,   120,   895,    -1,   120,    81,    -1,
     135,   544,   893,   545,   540,   541,   546,   495,   542,    -1,
     135,   780,   396,   541,   495,   542,    -1,   396,    -1,   201,
      -1,   912,    -1,   377,    -1,   378,    -1,   542,   543,    -1,
      -1,   102,    -1,   299,    -1,   163,   736,   912,    -1,   291,
     736,   912,    -1,   142,    -1,   212,    -1,   328,   736,   907,
      -1,   182,   736,   907,    -1,   197,   328,   564,    -1,   197,
     286,   291,   564,    -1,   102,    -1,    -1,   430,   299,    -1,
      -1,   547,   164,   912,    -1,    -1,   415,    -1,    -1,   137,
     549,   387,   893,   479,   550,   480,   571,   572,   573,   574,
      -1,   137,   549,   387,   893,   296,   893,   479,   550,   480,
     572,   573,   574,    -1,   391,    -1,   389,    -1,   257,   391,
      -1,   257,   389,    -1,   205,   391,    -1,   205,   389,    -1,
      -1,   551,    -1,    -1,   552,    -1,   551,   486,   552,    -1,
     553,    -1,   558,    -1,   561,    -1,  1024,   820,   554,    -1,
     554,   555,    -1,    -1,   131,   895,   556,    -1,   556,    -1,
     557,    -1,   286,   291,    -1,   291,    -1,   409,   685,   575,
      -1,   323,   244,   685,   575,    -1,   117,   479,   844,   480,
      -1,   157,   845,    -1,   333,   893,   563,   566,   567,    -1,
     159,    -1,   286,   159,    -1,   227,   160,    -1,   227,   217,
      -1,   253,   893,   559,    -1,   559,   560,    -1,    -1,   221,
     158,    -1,   185,   158,    -1,   221,   132,    -1,   185,   132,
      -1,   221,   224,    -1,   185,   224,    -1,   131,   895,   562,
      -1,   562,    -1,   117,   479,   844,   480,    -1,   409,   479,
     564,   480,   685,   575,    -1,   323,   244,   479,   564,   480,
     685,   575,    -1,   198,   244,   479,   564,   480,   333,   893,
     563,   566,   567,   607,    -1,   479,   564,   480,    -1,    -1,
     564,   486,   565,    -1,   565,    -1,  1024,    -1,   264,   202,
      -1,   264,   314,    -1,    -1,   568,    -1,   569,    -1,   568,
     569,    -1,   569,   568,    -1,    -1,   301,   162,   570,    -1,
     301,   413,   570,    -1,   278,    76,    -1,   343,    -1,   109,
      -1,   364,   157,    -1,   364,   291,    -1,   226,   479,   892,
     480,    -1,    -1,   430,   614,    -1,   430,   299,    -1,   431,
     299,    -1,    -1,   301,   126,   174,    -1,   301,   126,   162,
     351,    -1,   301,   126,   320,   351,    -1,    -1,   388,   895,
      -1,    -1,   415,   223,   388,   895,    -1,    -1,    -1,   137,
     549,   387,   578,    90,   577,   779,    -1,   893,   579,   572,
     573,   574,    -1,   479,   580,   480,    -1,    -1,   580,   486,
     581,    -1,   581,    -1,  1024,    -1,   137,   549,   360,   893,
     584,    -1,    83,   360,   893,   584,    -1,   584,   585,    -1,
      -1,   107,   914,    -1,   150,    -1,   278,   150,    -1,   222,
     586,   914,    -1,   265,   914,    -1,   267,   914,    -1,   278,
     265,    -1,   278,   267,    -1,   311,   106,   640,    -1,   374,
     495,   914,    -1,   342,   495,   914,    -1,   106,    -1,    -1,
     137,   588,   593,   246,   521,    -1,   137,   588,   593,   246,
     521,   210,   589,   590,   591,    -1,   404,    -1,    -1,   895,
      -1,   895,   641,    -1,   418,   589,    -1,    -1,   245,   912,
      -1,    -1,   174,   593,   246,   912,   536,    -1,   174,   593,
     246,   215,   187,   912,   536,    -1,   326,    -1,    -1,   137,
     388,   895,   595,   260,   907,    -1,   312,   895,    -1,    -1,
     174,   388,   895,    -1,   174,   388,   215,   187,   895,    -1,
     137,   400,   895,   598,   599,   301,   893,   601,   186,   327,
     895,   479,   604,   480,    -1,   137,   131,   400,   895,    79,
     599,   301,   893,   606,   607,   196,   175,   350,   186,   327,
     901,   479,   604,   480,    -1,    98,    -1,    79,    -1,   600,
      -1,   600,   305,   600,    -1,   600,   305,   600,   305,   600,
      -1,   232,    -1,   162,    -1,   413,    -1,   196,   602,   603,
      -1,    -1,   175,    -1,    -1,   350,    -1,   375,    -1,   605,
      -1,   604,   486,   605,    -1,    -1,   916,    -1,  1024,    -1,
      -1,   201,   893,    -1,   608,    -1,   608,   609,    -1,   609,
      -1,   609,   608,    -1,    -1,   286,   159,    -1,   159,    -1,
     227,   217,    -1,   227,   160,    -1,   174,   400,   895,   301,
     893,   536,    -1,   174,   400,   215,   187,   895,   301,   893,
     536,    -1,   137,    92,   895,   117,   479,   844,   480,   607,
      -1,   174,    92,   895,    -1,   137,    80,   901,   618,   614,
      -1,   137,    80,   901,   619,    -1,   137,   303,   857,   614,
      -1,   137,   405,   640,   614,    -1,   137,   405,   640,    -1,
     137,   405,   640,    90,   479,   818,   480,    -1,   137,   405,
     640,    90,   181,   479,   622,   480,    -1,   137,   392,   356,
     313,   640,   614,    -1,   137,   392,   356,   166,   640,   614,
      -1,   137,   392,   356,   390,   640,   614,    -1,   137,   392,
     356,   129,   640,   614,    -1,   479,   615,   480,    -1,   616,
      -1,   615,   486,   616,    -1,  1026,   466,   617,    -1,  1026,
      -1,   681,    -1,  1036,    -1,   860,    -1,   915,    -1,   479,
     864,   480,    -1,   479,   472,   480,    -1,   479,   620,   480,
      -1,   621,    -1,   620,   486,   621,    -1,  1045,   466,   617,
      -1,   912,    -1,   622,   486,   912,    -1,   137,   303,   119,
     640,   626,   196,   405,   820,   415,   897,   627,    90,   624,
      -1,   625,    -1,   624,   486,   625,    -1,   303,   908,   693,
     628,    -1,   303,   908,   693,   479,   692,   480,   628,    -1,
     203,   908,   901,   674,    -1,   203,   908,   479,   864,   480,
     901,   674,    -1,   379,   820,    -1,   157,    -1,    -1,   192,
     640,    -1,    -1,   332,    -1,    -1,   137,   303,   192,   640,
     415,   897,    -1,    83,   303,   192,   640,   415,   897,    77,
     624,    -1,    83,   303,   192,   640,   415,   897,   174,   631,
      -1,   632,    -1,   631,   486,   632,    -1,   303,   908,   479,
     864,   480,    -1,   203,   908,   479,   864,   480,    -1,   174,
     303,   119,   640,   415,   897,   536,    -1,   174,   303,   119,
     215,   187,   640,   415,   897,   536,    -1,   174,   303,   192,
     640,   415,   897,   536,    -1,   174,   303,   192,   215,   187,
     640,   415,   897,   536,    -1,   174,   311,   106,   894,   536,
      -1,   331,   311,   106,   894,   396,   895,    -1,   174,   638,
     215,   187,   639,   536,    -1,   174,   638,   639,   536,    -1,
     387,    -1,   360,    -1,   425,    -1,   223,    -1,   405,    -1,
     172,    -1,   134,    -1,   354,    -1,   392,   356,   313,    -1,
     392,   356,   166,    -1,   392,   356,   390,    -1,   392,   356,
     129,    -1,   640,    -1,   639,   486,   640,    -1,  1024,    -1,
    1024,   641,    -1,   481,   898,    -1,   641,   481,   898,    -1,
     403,   786,   892,   536,    -1,   193,   644,   645,   895,   987,
      -1,   193,   644,   895,   987,    -1,   193,   645,   895,   987,
      -1,   193,   895,   987,    -1,   193,   644,   645,   895,    -1,
     193,   644,   895,    -1,   193,   645,   895,    -1,   193,   895,
      -1,   270,   644,   645,   895,    -1,   270,   895,    -1,   277,
      -1,   324,    -1,   194,    -1,   248,    -1,    74,   909,    -1,
     335,   909,    -1,   909,    -1,    81,    -1,   199,    -1,   199,
     909,    -1,   199,    81,    -1,    97,    -1,    97,   909,    -1,
      97,    81,    -1,   220,    -1,   201,    -1,   125,   301,   647,
     895,   240,   648,    -1,   125,   301,    80,   901,   618,   240,
     648,    -1,   125,   301,   203,   901,   674,   240,   648,    -1,
     125,   301,   303,   857,   479,   692,   480,   240,   648,    -1,
     125,   301,   400,   895,   301,   640,   240,   648,    -1,   125,
     301,   352,   895,   301,   640,   240,   648,    -1,   125,   301,
     352,   895,   240,   648,    -1,   125,   301,   303,   119,   640,
     415,   897,   240,   648,    -1,   125,   301,   303,   192,   640,
     415,   897,   240,   648,    -1,   125,   301,   247,   295,   914,
     240,   648,    -1,   125,   301,   112,   479,   820,    90,   820,
     480,   240,   648,    -1,   125,   301,   593,   246,   640,   240,
     648,    -1,   125,   301,   392,   356,   313,   640,   240,   648,
      -1,   125,   301,   392,   356,   166,   640,   240,   648,    -1,
     125,   301,   392,   356,   390,   640,   240,   648,    -1,   125,
     301,   392,   356,   129,   640,   240,   648,    -1,   124,    -1,
     151,    -1,   354,    -1,   223,    -1,   360,    -1,   387,    -1,
     172,    -1,   405,    -1,   425,    -1,   134,    -1,   388,    -1,
     348,    -1,   912,    -1,   291,    -1,   206,   651,   301,   654,
     396,   655,   657,    -1,   346,   651,   301,   654,   201,   655,
     536,    -1,   346,   206,   304,   196,   651,   301,   654,   201,
     655,   536,    -1,    81,   325,    -1,    81,    -1,   652,    -1,
     653,    -1,   652,   486,   653,    -1,   359,    -1,   333,    -1,
     137,    -1,  1024,    -1,   892,    -1,   387,   892,    -1,   360,
     892,    -1,   203,   658,    -1,   151,   894,    -1,   246,   894,
      -1,   354,   894,    -1,   388,   894,    -1,   656,    -1,   655,
     486,   656,    -1,   917,    -1,   209,   917,    -1,   430,   206,
     304,    -1,    -1,   659,    -1,   658,   486,   659,    -1,   901,
     674,    -1,   206,   652,   396,   894,   662,   663,    -1,   346,
     652,   201,   894,   663,   536,    -1,   430,    78,   304,    -1,
      -1,   207,   106,   917,    -1,    -1,   137,   665,   223,   899,
     301,   893,   666,   479,   667,   480,   685,   574,   816,    -1,
     137,   665,   223,   128,   899,   301,   893,   666,   479,   667,
     480,   685,   574,   816,    -1,   409,    -1,    -1,   415,   897,
      -1,    -1,   668,    -1,   667,   486,   668,    -1,  1024,   669,
     670,   671,    -1,   847,   669,   670,   671,    -1,   479,   844,
     480,   669,   670,   671,    -1,   640,    -1,   415,   640,    -1,
      -1,    91,    -1,   165,    -1,    -1,   446,    -1,   447,    -1,
      -1,   137,   673,   203,   901,   674,   345,   680,   682,   685,
      -1,   137,   673,   203,   901,   674,   682,   685,    -1,   305,
     339,    -1,    -1,   479,   675,   480,    -1,   479,   480,    -1,
     676,    -1,   675,   486,   676,    -1,   677,   679,   681,    -1,
     679,   677,   681,    -1,   679,   681,    -1,   677,   681,    -1,
     681,    -1,   220,    -1,   307,    -1,   229,    -1,   220,   307,
      -1,   912,    -1,   912,   486,   912,    -1,  1025,    -1,   681,
      -1,   820,    -1,  1025,   641,   474,   405,    -1,   365,  1025,
     641,   474,   405,    -1,   684,    -1,   682,   684,    -1,   108,
     301,   291,   230,    -1,   345,   291,   301,   291,   230,    -1,
     380,    -1,   218,    -1,   372,    -1,   426,    -1,   189,   358,
     161,    -1,   189,   358,   239,    -1,   358,   161,    -1,   358,
     239,    -1,   136,   914,    -1,   351,   914,    -1,   524,    -1,
      90,   678,    -1,   246,   521,    -1,   683,    -1,   430,   614,
      -1,    -1,    83,   203,   659,   687,   688,    -1,   683,    -1,
     687,   683,    -1,   343,    -1,    -1,   174,   203,   901,   674,
     536,    -1,   174,   203,   215,   187,   901,   674,   536,    -1,
     174,    80,   901,   618,   536,    -1,   174,    80,   215,   187,
     901,   618,   536,    -1,   174,   303,   857,   479,   692,   480,
     536,    -1,   174,   303,   215,   187,   693,   479,   692,   480,
     536,    -1,   820,    -1,   820,   486,   820,    -1,   284,   486,
     820,    -1,   820,   486,   284,    -1,   857,    -1,  1024,   481,
     693,    -1,   137,   112,   479,   820,    90,   820,   480,   430,
     203,   659,   695,    -1,   137,   112,   479,   820,    90,   820,
     480,   431,   203,   695,    -1,    90,    93,    -1,    -1,   174,
     112,   697,   479,   820,    90,   820,   480,   536,    -1,   215,
     187,    -1,    -1,   334,   699,   893,   700,    -1,   334,   386,
     895,   700,    -1,   334,   151,   895,   700,    -1,   223,    -1,
     387,    -1,   197,    -1,    -1,    83,    80,   901,   618,   337,
     396,   895,    -1,    83,   134,   640,   337,   396,   895,    -1,
      83,   151,   896,   337,   396,   896,    -1,    83,   203,   659,
     337,   396,   895,    -1,    83,   209,   917,   337,   396,   917,
      -1,    83,   593,   246,   895,   337,   396,   895,    -1,    83,
     303,   119,   640,   415,   897,   337,   396,   895,    -1,    83,
     303,   192,   640,   415,   897,   337,   396,   895,    -1,    83,
     354,   895,   337,   396,   895,    -1,    83,   387,   813,   337,
     396,   895,    -1,    83,   360,   813,   337,   396,   895,    -1,
      83,   425,   813,   337,   396,   895,    -1,    83,   223,   813,
     337,   396,   895,    -1,    83,   387,   813,   337,   702,   895,
     396,   895,    -1,    83,   400,   895,   301,   813,   337,   396,
     895,    -1,    83,   414,   917,   337,   396,   917,    -1,    83,
     388,   895,   337,   396,   895,    -1,    83,   392,   356,   313,
     640,   337,   396,   895,    -1,    83,   392,   356,   166,   640,
     337,   396,   895,    -1,    83,   392,   356,   390,   640,   337,
     396,   895,    -1,    83,   392,   356,   129,   640,   337,   396,
     895,    -1,   124,    -1,    -1,    83,    80,   901,   618,   364,
     354,   895,    -1,    83,   172,   640,   364,   354,   895,    -1,
      83,   203,   659,   364,   354,   895,    -1,    83,   360,   813,
     364,   354,   895,    -1,    83,   387,   813,   364,   354,   895,
      -1,    83,   405,   640,   364,   354,   895,    -1,    83,    80,
     901,   618,   312,   396,   917,    -1,    83,   134,   640,   312,
     396,   917,    -1,    83,   151,   896,   312,   396,   917,    -1,
      83,   172,   896,   312,   396,   917,    -1,    83,   203,   659,
     312,   396,   917,    -1,    83,   593,   246,   895,   312,   396,
     917,    -1,    83,   303,   693,   479,   692,   480,   312,   396,
     917,    -1,    83,   303,   119,   640,   415,   897,   312,   396,
     917,    -1,    83,   303,   192,   640,   415,   897,   312,   396,
     917,    -1,    83,   354,   895,   312,   396,   917,    -1,    83,
     405,   640,   312,   396,   917,    -1,    83,   388,   895,   312,
     396,   917,    -1,    83,   392,   356,   166,   640,   312,   396,
     917,    -1,    83,   392,   356,   129,   640,   312,   396,   917,
      -1,    -1,   137,   673,   352,   895,    90,   706,   301,   711,
     396,   893,   816,   170,   712,   707,    -1,   287,    -1,   709,
      -1,   479,   708,   480,    -1,   708,   482,   710,    -1,   710,
      -1,   779,    -1,   758,    -1,   769,    -1,   763,    -1,   714,
      -1,   709,    -1,    -1,   359,    -1,   413,    -1,   162,    -1,
     232,    -1,   233,    -1,    82,    -1,    -1,   174,   352,   895,
     301,   893,   536,    -1,   174,   352,   215,   187,   895,   301,
     893,   536,    -1,   288,  1024,    -1,   255,  1024,    -1,   411,
    1024,    -1,   411,   472,    -1,    73,   718,    -1,    99,   718,
     721,    -1,   374,   398,   721,    -1,   126,   718,    -1,   180,
     718,    -1,   349,   718,    -1,   353,  1024,    -1,   336,   353,
    1024,    -1,   336,  1024,    -1,   349,   718,   396,   353,  1024,
      -1,   349,   718,   396,  1024,    -1,   321,   398,   912,    -1,
     126,   322,   912,    -1,   349,   322,   912,    -1,   432,    -1,
     398,    -1,    -1,   242,   252,   516,    -1,   329,   302,    -1,
     329,   433,    -1,   719,    -1,   720,   486,   719,    -1,   720,
     719,    -1,   720,    -1,    -1,   137,   549,   425,   893,   563,
      90,   779,   723,    -1,   137,   305,   339,   549,   425,   893,
     563,    90,   779,   723,    -1,   450,   304,    -1,   448,   117,
     304,    -1,   449,   117,   304,    -1,    -1,   256,   900,    -1,
     137,   151,   896,   430,   726,    -1,   137,   151,   896,    -1,
     727,    -1,   726,   727,    -1,   388,   728,   895,    -1,   388,
     728,   157,    -1,   260,   728,   912,    -1,   260,   728,   157,
      -1,   390,   728,   895,    -1,   390,   728,   157,    -1,   178,
     728,   913,    -1,   178,   728,   157,    -1,   130,   254,   728,
     908,    -1,   312,   728,   895,    -1,   312,   728,   157,    -1,
     466,    -1,    -1,    83,   151,   896,   495,   731,    -1,    83,
     151,   896,   524,    -1,   731,   732,    -1,    -1,   130,   254,
     728,   908,    -1,   174,   151,   896,    -1,   174,   151,   215,
     187,   896,    -1,   137,   172,   640,   736,   820,   554,    -1,
      83,   172,   640,   535,    -1,    83,   172,   640,   174,   286,
     291,    -1,    83,   172,   640,   364,   286,   291,    -1,    83,
     172,   640,    77,   561,    -1,    83,   172,   640,   174,   131,
     895,   536,    -1,    90,    -1,    -1,    83,   392,   356,   166,
     640,   614,    -1,    83,   392,   356,   129,   640,    77,   263,
     196,   894,   430,   639,    -1,    83,   392,   356,   129,   640,
      83,   263,   196,   894,   430,   639,    -1,    83,   392,   356,
     129,   640,    83,   263,   339,   640,   430,   640,    -1,    83,
     392,   356,   129,   640,    83,   263,   196,   894,   339,   640,
     430,   640,    -1,    83,   392,   356,   129,   640,   174,   263,
     196,   894,    -1,    83,   392,   356,   129,   640,   174,   263,
     215,   187,   196,   894,    -1,   137,   626,   134,   640,   196,
     912,   396,   912,   201,   640,    -1,   121,   893,   741,    -1,
     121,    -1,   121,   893,   301,   893,    -1,   415,   899,    -1,
      -1,   416,   746,   747,   745,    -1,   416,   746,   747,   745,
     893,    -1,   416,   746,   747,   745,   743,    -1,   744,   745,
      -1,   744,   745,   893,   748,    -1,    86,    -1,    85,    -1,
     423,    -1,    -1,   202,    -1,    -1,   200,    -1,    -1,   479,
     894,   480,    -1,    -1,   188,   751,   745,   750,    -1,   779,
      -1,   758,    -1,   769,    -1,   763,    -1,   776,    -1,   755,
      -1,   744,    -1,    -1,   321,   979,   754,    90,   753,    -1,
     321,   979,   201,   978,    -1,   779,    -1,   758,    -1,   769,
      -1,   763,    -1,   479,   864,   480,    -1,    -1,   186,   979,
     756,   977,    -1,   137,   549,   387,   578,    90,   186,   979,
     756,    -1,   479,   862,   480,    -1,    -1,   153,   979,    -1,
     153,   321,   979,    -1,   153,    81,    -1,   153,   321,    81,
      -1,   232,   238,   893,   759,   762,    -1,   779,    -1,   479,
     760,   480,   779,    -1,   157,   420,    -1,   760,   486,   761,
      -1,   761,    -1,  1024,   884,    -1,   344,   889,    -1,    -1,
     162,   201,   814,   764,   817,   762,    -1,   415,   806,    -1,
      -1,   261,   786,   892,   766,   768,    -1,   220,   767,   268,
      -1,    -1,    75,   366,    -1,   350,   366,    -1,   350,   184,
      -1,   366,   413,   184,    -1,   366,    -1,   366,   350,   184,
      -1,   184,    -1,    75,   184,    -1,   290,    -1,    -1,   413,
     814,   364,   770,   805,   817,   762,    -1,   771,    -1,   770,
     486,   771,    -1,   772,    -1,   773,    -1,   774,   466,   886,
      -1,   479,   775,   480,   466,   888,    -1,  1024,   884,    -1,
     774,    -1,   775,   486,   774,    -1,   156,   895,   777,   149,
     778,   196,   779,    -1,    -1,   777,   102,    -1,   777,   231,
      -1,   777,   355,    -1,   777,   278,   355,    -1,    -1,   430,
     213,    -1,   431,   213,    -1,   781,    -1,   780,    -1,   479,
     781,   480,    -1,   479,   780,   480,    -1,   783,    -1,   782,
     790,    -1,   782,   789,   799,   794,    -1,   782,   789,   793,
     800,    -1,   783,    -1,   780,    -1,   359,   788,   889,   784,
     805,   816,   797,   798,    -1,   804,    -1,   782,   408,   787,
     782,    -1,   782,   236,   787,   782,    -1,   782,   183,   787,
     782,    -1,   238,   785,    -1,   987,    -1,    -1,   391,   786,
     893,    -1,   389,   786,   893,    -1,   257,   391,   786,   893,
      -1,   257,   389,   786,   893,    -1,   205,   391,   786,   893,
      -1,   205,   389,   786,   893,    -1,   387,   893,    -1,   893,
      -1,   387,    -1,    -1,    81,    -1,    -1,   169,    -1,   169,
     301,   479,   862,   480,    -1,    81,    -1,    -1,   790,    -1,
      -1,   306,   106,   791,    -1,   792,    -1,   791,   486,   792,
      -1,   844,   415,   860,   671,    -1,   844,   670,   671,    -1,
     254,   795,   298,   796,    -1,   298,   796,   254,   795,    -1,
     254,   795,    -1,   298,   796,    -1,   254,   795,   486,   796,
      -1,   793,    -1,    -1,   844,    -1,    81,    -1,   844,    -1,
     209,   106,   862,    -1,    -1,   211,   844,    -1,    -1,   801,
      -1,   196,   329,   302,    -1,   799,    -1,    -1,   802,    -1,
     801,   802,    -1,   196,   413,   803,   768,    -1,   196,   366,
     803,   768,    -1,   296,   894,    -1,    -1,   420,   888,    -1,
     804,   486,   888,    -1,   201,   806,    -1,    -1,   806,   486,
     807,    -1,   807,    -1,   813,    -1,   813,   809,    -1,   815,
      -1,   815,   809,    -1,   815,    90,   479,   818,   480,    -1,
     815,    90,  1024,   479,   818,   480,    -1,   815,  1024,   479,
     818,   480,    -1,   780,    -1,   780,   809,    -1,   808,    -1,
     479,   808,   480,   809,    -1,   479,   808,   480,    -1,   807,
     141,   243,   807,    -1,   807,   810,   243,   807,   812,    -1,
     807,   243,   807,   812,    -1,   807,   274,   810,   243,   807,
      -1,   807,   274,   243,   807,    -1,    90,  1024,   479,   894,
     480,    -1,    90,  1024,    -1,  1024,   479,   894,   480,    -1,
    1024,    -1,   202,   811,    -1,   251,   811,    -1,   347,   811,
      -1,   228,    -1,   308,    -1,    -1,   415,   479,   894,   480,
      -1,   301,   844,    -1,   893,    -1,   893,   472,    -1,   302,
     893,    -1,   302,   479,   893,   480,    -1,   813,    -1,   813,
    1024,    -1,   813,    90,  1024,    -1,   847,    -1,   428,   844,
      -1,    -1,   428,   844,    -1,   428,   143,   296,   895,    -1,
     428,   143,   296,   464,    -1,    -1,   819,    -1,   818,   486,
     819,    -1,  1024,   820,    -1,   823,   821,    -1,   365,   823,
     821,    -1,   823,    89,   477,   908,   478,    -1,   365,   823,
      89,   477,   908,   478,    -1,   477,   478,   821,    -1,   477,
     822,   478,   821,    -1,    -1,   908,    -1,   479,   822,   480,
      -1,   822,   470,   822,    -1,   822,   471,   822,    -1,   822,
     472,   822,    -1,   822,   473,   822,    -1,   822,   474,   822,
      -1,   907,    -1,  1024,    -1,   825,    -1,   840,    -1,   827,
      -1,   829,    -1,   833,    -1,   841,   843,    -1,   841,   479,
     908,   480,   843,    -1,   827,    -1,   830,    -1,   834,    -1,
     840,    -1,  1025,   826,    -1,  1025,   641,   826,    -1,   479,
     862,   480,    -1,    -1,   234,    -1,   235,    -1,   370,    -1,
     101,    -1,   330,    -1,   195,   828,    -1,   173,   319,    -1,
     155,   826,    -1,   154,   826,    -1,   294,   826,    -1,   104,
      -1,   479,   908,   480,    -1,    -1,   831,    -1,   832,    -1,
     831,    -1,   832,    -1,   103,   838,   479,   862,   480,    -1,
     103,   838,    -1,   835,    -1,   836,    -1,   835,    -1,   836,
      -1,   837,   479,   908,   480,   839,    -1,   837,   839,    -1,
     115,   838,    -1,   114,   838,    -1,   421,    -1,   273,   115,
     838,    -1,   273,   114,   838,    -1,   275,   838,    -1,   422,
      -1,    -1,   115,   364,  1024,    -1,    -1,   395,   479,   908,
     480,   842,    -1,   395,   842,    -1,   394,   479,   908,   480,
     842,    -1,   394,   842,    -1,   237,    -1,   430,   394,   445,
      -1,   431,   394,   445,    -1,    -1,   443,    -1,   269,    -1,
     152,    -1,   214,    -1,   266,    -1,   357,    -1,   443,   396,
     269,    -1,   152,   396,   214,    -1,   152,   396,   266,    -1,
     152,   396,   357,    -1,   214,   396,   266,    -1,   266,   396,
     357,    -1,   214,   396,   357,    -1,    -1,   846,    -1,   844,
      72,   820,    -1,   844,    95,   394,   445,   844,    -1,   470,
     844,    -1,   471,   844,    -1,   844,   470,   844,    -1,   844,
     471,   844,    -1,   844,   472,   844,    -1,   844,   473,   844,
      -1,   844,   474,   844,    -1,   844,   475,   844,    -1,   844,
     467,   844,    -1,   844,   468,   844,    -1,   844,   466,   844,
      -1,   844,   859,   844,    -1,   859,   844,    -1,   844,   859,
      -1,   844,    87,   844,    -1,   844,   305,   844,    -1,   286,
     844,    -1,   844,   253,   844,    -1,   844,   253,   844,   182,
     844,    -1,   844,   286,   253,   844,    -1,   844,   286,   253,
     844,   182,   844,    -1,   844,   216,   844,    -1,   844,   216,
     844,   182,   844,    -1,   844,   286,   216,   844,    -1,   844,
     286,   216,   844,   182,   844,    -1,   844,   368,   396,   844,
      -1,   844,   368,   396,   844,   182,   844,    -1,   844,   286,
     368,   396,   844,    -1,   844,   286,   368,   396,   844,   182,
     844,    -1,   844,   241,    -1,   844,   240,   291,    -1,   844,
     289,    -1,   844,   240,   286,   291,    -1,   855,   309,   855,
      -1,   844,   240,   402,    -1,   844,   240,   286,   402,    -1,
     844,   240,   191,    -1,   844,   240,   286,   191,    -1,   844,
     240,   410,    -1,   844,   240,   286,   410,    -1,   844,   240,
     169,   201,   844,    -1,   844,   240,   286,   169,   201,   844,
      -1,   844,   240,   296,   479,   864,   480,    -1,   844,   240,
     286,   296,   479,   864,   480,    -1,   844,   100,   885,   845,
      87,   845,    -1,   844,   286,   100,   885,   845,    87,   845,
      -1,   844,   100,   384,   845,    87,   845,    -1,   844,   286,
     100,   384,   845,    87,   845,    -1,   844,   220,   875,    -1,
     844,   286,   220,   875,    -1,   844,   861,   856,   780,    -1,
     844,   861,   856,   479,   844,   480,    -1,   409,   780,    -1,
     844,   240,   171,    -1,   844,   240,   286,   171,    -1,   846,
      -1,   845,    72,   820,    -1,   471,   845,    -1,   845,   470,
     845,    -1,   845,   471,   845,    -1,   845,   472,   845,    -1,
     845,   473,   845,    -1,   845,   474,   845,    -1,   845,   475,
     845,    -1,   845,   467,   845,    -1,   845,   468,   845,    -1,
     845,   466,   845,    -1,   845,   453,   845,    -1,   859,   845,
      -1,   845,   859,    -1,   845,   240,   169,   201,   845,    -1,
     845,   240,   286,   169,   201,   845,    -1,   845,   240,   296,
     479,   845,   480,    -1,   845,   240,   286,   296,   479,   845,
     480,    -1,   845,   240,   171,    -1,   845,   240,   286,   171,
      -1,   881,    -1,   902,    -1,   464,   884,    -1,   479,   844,
     480,   884,    -1,   876,    -1,   847,    -1,   780,    -1,   187,
     780,    -1,    89,   780,    -1,    89,   866,    -1,   855,    -1,
     901,   479,   480,    -1,   901,   479,   862,   480,    -1,   901,
     479,    81,   862,   480,    -1,   901,   479,   169,   862,   480,
      -1,   901,   479,   472,   480,    -1,   144,    -1,   146,    -1,
     146,   479,   908,   480,    -1,   147,    -1,   147,   479,   908,
     480,    -1,   258,    -1,   258,   479,   908,   480,    -1,   259,
      -1,   259,   479,   908,   480,    -1,   145,    -1,   148,    -1,
     363,    -1,   414,    -1,   112,   479,   844,    90,   820,   480,
      -1,   190,   479,   863,   480,    -1,   310,   479,   868,   480,
      -1,   318,   479,   870,   480,    -1,   382,   479,   871,   480,
      -1,   399,   479,   844,    90,   820,   480,    -1,   401,   479,
     105,   874,   480,    -1,   401,   479,   249,   874,   480,    -1,
     401,   479,   397,   874,   480,    -1,   401,   479,   874,   480,
      -1,   292,   479,   844,   486,   844,   480,    -1,   122,   479,
     862,   480,    -1,   208,   479,   862,   480,    -1,   250,   479,
     862,   480,    -1,   436,   479,   862,   480,    -1,   437,   479,
     271,  1026,   480,    -1,   437,   479,   271,  1026,   486,   850,
     480,    -1,   437,   479,   271,  1026,   486,   862,   480,    -1,
     437,   479,   271,  1026,   486,   850,   486,   862,   480,    -1,
     438,   479,   851,   480,    -1,   439,   479,   853,   844,   854,
     480,    -1,   440,   479,   271,  1026,   480,    -1,   440,   479,
     271,  1026,   486,   844,   480,    -1,   441,   479,   844,   486,
     848,   849,   480,    -1,   424,   844,    -1,   424,   278,   419,
      -1,   486,   373,   444,    -1,   486,   373,   278,    -1,   486,
     373,   278,   419,    -1,    -1,   435,   479,   851,   480,    -1,
     852,    -1,   851,   486,   852,    -1,   844,    90,  1026,    -1,
     844,    -1,   171,    -1,   133,    -1,   320,   429,    -1,   381,
     429,    -1,    -1,   350,   479,   862,   480,    -1,   350,   479,
     480,    -1,   479,   862,   486,   844,   480,    -1,    88,    -1,
     371,    -1,    81,    -1,   453,    -1,   858,    -1,   470,    -1,
     471,    -1,   472,    -1,   474,    -1,   475,    -1,   473,    -1,
     467,    -1,   468,    -1,   466,    -1,   453,    -1,   303,   479,
     693,   480,    -1,   857,    -1,   303,   479,   693,   480,    -1,
     857,    -1,   303,   479,   693,   480,    -1,   253,    -1,   286,
     253,    -1,   216,    -1,   286,   216,    -1,   844,    -1,   862,
     486,   844,    -1,   867,   201,   844,    -1,    -1,   820,    -1,
     864,   486,   820,    -1,   866,    -1,   865,   486,   866,    -1,
     477,   862,   478,    -1,   477,   865,   478,    -1,  1045,    -1,
     443,    -1,   269,    -1,   152,    -1,   214,    -1,   266,    -1,
     357,    -1,   912,    -1,   844,   869,   872,   873,    -1,   844,
     869,   872,    -1,   316,   844,    -1,   845,   220,   845,    -1,
      -1,   844,   872,   873,    -1,   844,   873,   872,    -1,   844,
     872,    -1,   844,   873,    -1,   862,    -1,    -1,   201,   844,
      -1,   196,   844,    -1,   844,   201,   862,    -1,   201,   862,
      -1,   862,    -1,   780,    -1,   479,   862,   480,    -1,   111,
     880,   877,   879,   180,    -1,   877,   878,    -1,   878,    -1,
     427,   844,   393,   844,    -1,   176,   844,    -1,    -1,   844,
      -1,    -1,   891,    -1,   891,   883,    -1,   481,   898,    -1,
     481,   472,    -1,   477,   844,   478,    -1,   477,   844,   487,
     844,   478,    -1,   882,    -1,   883,   882,    -1,    -1,   884,
     882,    -1,    94,    -1,    -1,   844,    -1,   157,    -1,   886,
      -1,   887,   486,   886,    -1,   479,   887,   480,    -1,   889,
     486,   890,    -1,   890,    -1,   844,    90,  1026,    -1,   844,
      -1,   472,    -1,   918,    -1,  1024,    -1,   893,    -1,   892,
     486,   893,    -1,   891,    -1,   891,   883,    -1,   895,    -1,
     894,   486,   895,    -1,  1024,    -1,  1024,    -1,  1024,    -1,
    1026,    -1,  1024,    -1,   912,    -1,  1025,    -1,   891,   883,
      -1,   916,    -1,   824,   912,    -1,   841,   912,   843,    -1,
     841,   479,   908,   480,   912,   843,    -1,   402,    -1,   191,
      -1,   291,    -1,  1041,    -1,   463,    -1,   465,    -1,   458,
      -1,   459,    -1,   452,    -1,   461,    -1,   462,    -1,   460,
      -1,   903,    -1,  1042,    -1,   908,    -1,   471,   908,    -1,
     903,    -1,  1044,    -1,   904,    -1,   910,    -1,   471,   904,
      -1,   471,   903,    -1,   907,    -1,   907,    -1,  1042,    -1,
     903,    -1,   907,    -1,  1042,    -1,   904,    -1,   903,    -1,
     471,   904,    -1,   471,   903,    -1,  1042,    -1,   907,    -1,
     914,    -1,   907,    -1,   904,    -1,   903,    -1,   905,    -1,
     906,    -1,   901,   907,    -1,   901,   479,   862,   480,   907,
      -1,  1042,    -1,  1024,    -1,   300,    -1,   276,    -1,     9,
     396,   920,   927,   928,    -1,     9,   396,   157,    -1,     9,
     929,    -1,   151,   920,    -1,   921,   924,   926,    -1,   922,
     487,   923,   926,   473,   921,   932,    -1,   931,    -1,   907,
      -1,   896,    -1,    -1,  1045,  1044,    -1,   453,   925,    -1,
     923,    -1,    -1,  1024,    -1,  1024,   481,   925,    -1,   457,
      -1,   487,   908,    -1,    -1,    90,   976,    -1,    -1,   414,
     929,    -1,    -1,   930,    -1,   930,   473,   930,    -1,   930,
      22,   106,   930,    -1,   930,   415,   930,    -1,   917,    -1,
     912,    -1,  1044,    -1,   453,  1024,    -1,    -1,   156,   895,
     777,   149,   778,   196,   979,    -1,   186,   217,   978,    -1,
     936,    -1,   947,    -1,   949,    -1,   914,    -1,   486,   914,
      -1,    -1,   843,    -1,   443,   396,   266,    -1,   443,   396,
     357,    -1,   152,   396,   152,    -1,   269,   396,   269,    -1,
      -1,   942,   941,   944,   943,    -1,  1038,    99,   156,    35,
     482,    -1,  1038,   180,   156,    35,   482,    -1,    -1,   945,
      -1,   456,    -1,   949,    -1,   947,    -1,   945,   949,    -1,
     945,   947,    -1,   945,   456,    -1,   949,    -1,   946,   949,
      -1,    -1,    71,   948,   956,   972,  1027,   821,   482,    -1,
      -1,   953,   956,   950,   969,   482,    -1,    -1,   956,   951,
     969,   482,    -1,   959,   482,    -1,   487,   903,    -1,    -1,
     954,   955,    -1,   954,    -1,   955,    -1,    57,    -1,    68,
      -1,    66,    -1,    51,    -1,    52,    -1,    70,    -1,   965,
      -1,   961,    -1,   957,    -1,  1027,   479,   937,   938,   480,
      -1,  1027,   939,    -1,   963,    -1,   181,  1022,   958,    -1,
     181,   958,    -1,   181,  1022,    -1,   483,  1049,   484,    -1,
      -1,   963,   960,   483,   946,   484,    -1,   959,    -1,    -1,
     964,   962,   483,   946,   484,    -1,    44,  1022,    -1,   408,
    1022,    -1,    44,    -1,   408,    -1,   966,    -1,   968,   967,
      -1,    45,    36,    -1,    45,    36,   234,    -1,    45,    -1,
      45,   234,    -1,    45,    26,    -1,    45,    26,   234,    -1,
      45,    26,    26,    -1,    45,    26,    26,   234,    -1,    45,
     114,    -1,    36,    -1,    36,   234,    -1,   234,    -1,    26,
      -1,    26,   234,    -1,    26,    26,    -1,    26,    26,   234,
      -1,     5,    -1,   114,    -1,   173,    -1,    37,    -1,    -1,
     970,    -1,   969,   486,   970,    -1,   972,  1028,   821,   952,
     971,    -1,    -1,   466,  1050,    -1,    -1,   472,    -1,   472,
     472,    -1,   156,   375,  1045,    -1,    17,   975,    -1,   976,
      -1,   143,    -1,    81,    -1,    -1,   896,    -1,   157,    -1,
     931,    -1,   983,   987,    -1,   987,   983,    -1,   983,    -1,
     987,    -1,    -1,   931,    -1,   454,    -1,   895,    -1,   931,
      -1,    19,   895,    -1,    19,    81,    -1,    29,   895,   982,
      -1,    -1,   983,    -1,   415,   988,    -1,   984,    -1,   415,
     986,    16,  1046,    -1,   238,   986,    16,  1046,    -1,    -1,
      38,    -1,   238,  1037,    -1,   985,    -1,   989,    -1,   989,
     486,   988,    -1,   915,    -1,  1041,    -1,    15,   230,   895,
     984,    -1,    15,   991,   895,   984,    -1,    15,   991,   895,
     985,    -1,    30,    -1,    -1,     3,    16,  1046,    -1,   153,
      16,  1046,    -1,   204,    16,  1046,   995,    -1,   996,    -1,
     995,   486,   996,    -1,  1044,   466,  1000,    -1,   364,    16,
    1046,   998,    -1,   999,    -1,   998,   486,   999,    -1,  1000,
     466,   910,    -1,    11,    -1,   204,    16,  1046,   419,   910,
    1002,    -1,  1003,    -1,  1002,   486,  1003,    -1,  1044,   466,
    1007,    -1,   364,    16,  1046,   419,   910,  1005,    -1,  1006,
      -1,  1005,   486,  1006,    -1,  1007,   466,   911,    -1,     8,
      -1,    12,    -1,    13,    -1,    14,    -1,    23,    -1,    24,
      -1,    25,    -1,   271,    -1,    27,    -1,    28,    -1,   319,
      -1,    32,    -1,    33,    -1,    34,    -1,   405,    -1,   364,
       4,   466,  1009,    -1,   364,     4,   396,  1009,    -1,   301,
      -1,   297,    -1,   364,   130,   396,   976,    -1,   364,   130,
     466,   976,    -1,   364,   130,   976,    -1,    -1,   405,  1012,
    1027,   240,   956,   821,  1013,    -1,    31,    -1,    -1,    -1,
      46,  1015,  1026,   240,   956,   821,  1013,    -1,    47,    39,
    1017,    -1,    47,   286,    18,  1017,    -1,    47,    41,  1017,
      -1,    10,    -1,    40,    -1,    43,    -1,    21,   895,    -1,
      20,   396,   895,    -1,   170,   895,   479,  1039,   480,    -1,
     170,     6,    -1,     7,   895,   479,  1039,   480,    -1,     7,
     895,    -1,  1019,    -1,  1020,    -1,     6,    -1,     7,    -1,
       8,    -1,    10,    -1,    11,    -1,    12,    -1,    13,    -1,
      14,    -1,    18,    -1,    20,    -1,    21,    -1,    22,    -1,
      23,    -1,    24,    -1,    25,    -1,    27,    -1,    28,    -1,
      32,    -1,    33,    -1,    34,    -1,    35,    -1,    39,    -1,
      40,    -1,    41,    -1,    43,    -1,     9,    -1,    15,    -1,
      17,    -1,    29,    -1,    46,    -1,    47,    -1,     5,    -1,
      26,    -1,    30,    -1,    36,    -1,    44,    -1,    37,    -1,
      45,    -1,  1026,    -1,  1045,    -1,  1031,    -1,  1033,    -1,
    1034,    -1,  1018,    -1,  1029,    -1,   114,    -1,   420,    -1,
    1045,    -1,  1030,    -1,  1034,    -1,  1018,    -1,  1029,    -1,
     114,    -1,   420,    -1,  1045,    -1,  1030,    -1,  1035,    -1,
    1018,    -1,  1021,    -1,  1029,    -1,  1028,    -1,  1021,    -1,
     114,    -1,   230,    -1,   234,    -1,   408,    -1,   396,    -1,
    1029,    -1,  1031,    -1,  1045,    -1,  1034,    -1,  1035,    -1,
    1019,    -1,  1027,    -1,  1036,    -1,  1032,    -1,  1020,    -1,
      51,    -1,    52,    -1,    57,    -1,    66,    -1,    68,    -1,
      71,    -1,    70,    -1,  1031,    -1,  1032,    -1,   152,    -1,
     214,    -1,   266,    -1,   269,    -1,   357,    -1,   443,    -1,
    1033,    -1,   130,    -1,    73,    -1,    74,    -1,    75,    -1,
      76,    -1,    77,    -1,    78,    -1,    79,    -1,    80,    -1,
      82,    -1,    83,    -1,    84,    -1,    92,    -1,    93,    -1,
      95,    -1,    97,    -1,    98,    -1,    99,    -1,   106,    -1,
     107,    -1,   109,    -1,   110,    -1,   113,    -1,   116,    -1,
     118,    -1,   119,    -1,   120,    -1,   121,    -1,   125,    -1,
     126,    -1,   127,    -1,   128,    -1,   129,    -1,   132,    -1,
     133,    -1,   134,    -1,   135,    -1,   136,    -1,   138,    -1,
     139,    -1,   140,    -1,   142,    -1,   149,    -1,   150,    -1,
     151,    -1,   153,    -1,   156,    -1,   158,    -1,   160,    -1,
     162,    -1,   163,    -1,   164,    -1,   166,    -1,   167,    -1,
     168,    -1,   171,    -1,   172,    -1,   173,    -1,   174,    -1,
     175,    -1,   177,    -1,   178,    -1,   179,    -1,   182,    -1,
     185,    -1,   184,    -1,   186,    -1,   188,    -1,   189,    -1,
     192,    -1,   193,    -1,   194,    -1,   197,    -1,   199,    -1,
     203,    -1,   205,    -1,   207,    -1,   210,    -1,   212,    -1,
     213,    -1,   215,    -1,   217,    -1,   218,    -1,   219,    -1,
     221,    -1,   222,    -1,   223,    -1,   224,    -1,   225,    -1,
     226,    -1,   231,    -1,   232,    -1,   233,    -1,   242,    -1,
     244,    -1,   245,    -1,   246,    -1,   247,    -1,   248,    -1,
     252,    -1,   255,    -1,   256,    -1,   257,    -1,   260,    -1,
     261,    -1,   262,    -1,   263,    -1,   264,    -1,   265,    -1,
     267,    -1,   268,    -1,   270,    -1,   271,    -1,   272,    -1,
     277,    -1,   278,    -1,   279,    -1,   280,    -1,   281,    -1,
     282,    -1,   283,    -1,   285,    -1,   287,    -1,   288,    -1,
     290,    -1,   293,    -1,   295,    -1,   296,    -1,   299,    -1,
     303,    -1,   304,    -1,   311,    -1,   312,    -1,   313,    -1,
     314,    -1,   315,    -1,   317,    -1,   321,    -1,   322,    -1,
     320,    -1,   324,    -1,   325,    -1,   326,    -1,   327,    -1,
     328,    -1,   329,    -1,   331,    -1,   332,    -1,   334,    -1,
     335,    -1,   336,    -1,   337,    -1,   338,    -1,   339,    -1,
     340,    -1,   341,    -1,   342,    -1,   343,    -1,   345,    -1,
     346,    -1,   348,    -1,   349,    -1,   351,    -1,   352,    -1,
     353,    -1,   354,    -1,   355,    -1,   356,    -1,   360,    -1,
     361,    -1,   362,    -1,   364,    -1,   366,    -1,   367,    -1,
     369,    -1,   372,    -1,   373,    -1,   374,    -1,   375,    -1,
     376,    -1,   377,    -1,   378,    -1,   379,    -1,   380,    -1,
     381,    -1,   383,    -1,   386,    -1,   385,    -1,   388,    -1,
     389,    -1,   390,    -1,   391,    -1,   392,    -1,   398,    -1,
     400,    -1,   403,    -1,   404,    -1,   405,    -1,   406,    -1,
     407,    -1,   410,    -1,   411,    -1,   412,    -1,   413,    -1,
     416,    -1,   417,    -1,   418,    -1,   419,    -1,   422,    -1,
     424,    -1,   425,    -1,   426,    -1,   429,    -1,   430,    -1,
     431,    -1,   432,    -1,   433,    -1,   434,    -1,   444,    -1,
     445,    -1,   101,    -1,   103,    -1,   115,    -1,   122,    -1,
     154,    -1,   155,    -1,   187,    -1,   190,    -1,   195,    -1,
     208,    -1,   229,    -1,   235,    -1,   237,    -1,   250,    -1,
     273,    -1,   275,    -1,   284,    -1,   292,    -1,   294,    -1,
     307,    -1,   310,    -1,   318,    -1,   319,    -1,   330,    -1,
     350,    -1,   365,    -1,   370,    -1,   382,    -1,   394,    -1,
     395,    -1,   399,    -1,   401,    -1,   421,    -1,   435,    -1,
     436,    -1,   437,    -1,   438,    -1,   439,    -1,   440,    -1,
     441,    -1,   442,    -1,    96,    -1,   100,    -1,   102,    -1,
     141,    -1,   200,    -1,   202,    -1,   216,    -1,   228,    -1,
     240,    -1,   241,    -1,   243,    -1,   251,    -1,   253,    -1,
     274,    -1,   289,    -1,   308,    -1,   309,    -1,   347,    -1,
     368,    -1,   423,    -1,    81,    -1,    85,    -1,    86,    -1,
      87,    -1,    88,    -1,    89,    -1,    90,    -1,    91,    -1,
      94,    -1,   105,    -1,   111,    -1,   112,    -1,   117,    -1,
     123,    -1,   124,    -1,   131,    -1,   137,    -1,   143,    -1,
     144,    -1,   146,    -1,   147,    -1,   145,    -1,   148,    -1,
     157,    -1,   159,    -1,   165,    -1,   169,    -1,   170,    -1,
     176,    -1,   180,    -1,   183,    -1,   191,    -1,   196,    -1,
     198,    -1,   201,    -1,   206,    -1,   209,    -1,   211,    -1,
     220,    -1,   227,    -1,   236,    -1,   238,    -1,   249,    -1,
     254,    -1,   276,    -1,   286,    -1,   291,    -1,   297,    -1,
     298,    -1,   300,    -1,   301,    -1,   302,    -1,   305,    -1,
     306,    -1,   323,    -1,   333,    -1,   344,    -1,   359,    -1,
     363,    -1,   371,    -1,   384,    -1,   387,    -1,   393,    -1,
     397,    -1,   402,    -1,   409,    -1,   414,    -1,   415,    -1,
     427,    -1,   428,    -1,  1040,    -1,  1037,   486,  1040,    -1,
      42,    -1,    -1,  1049,    -1,  1044,  1043,    -1,  1044,    -1,
    1044,  1043,    -1,  1044,    -1,  1044,    -1,    23,  1044,    -1,
      23,   895,    -1,   455,    -1,   451,    -1,   454,    -1,   895,
      -1,   931,    -1,  1052,    -1,   479,   480,    -1,   479,  1048,
     480,    -1,  1047,    -1,  1048,  1047,    -1,  1050,    -1,  1049,
     486,  1050,    -1,  1048,    -1,   483,  1049,   484,    -1,  1052,
      -1,   479,    -1,   480,    -1,   486,    -1,   482,    -1,   451,
      -1,   454,    -1,   903,    -1,   904,    -1,   907,    -1,   472,
      -1,   470,    -1,   471,    -1,   473,    -1,   474,    -1,   291,
      -1,    48,    -1,    49,    -1,    50,    -1,    51,    -1,    52,
      -1,    53,    -1,    54,    -1,    55,    -1,    56,    -1,    57,
      -1,    58,    -1,    59,    -1,    61,    -1,    60,    -1,    62,
      -1,    63,    -1,    64,    -1,    65,    -1,    66,    -1,    67,
      -1,    68,    -1,    69,    -1,    71,    -1,    70,    -1,     5,
      -1,   181,    -1,   214,    -1,   234,    -1,    26,    -1,   266,
      -1,   269,    -1,   357,    -1,    36,    -1,    37,    -1,    44,
      -1,    45,    -1,   443,    -1,   114,    -1,   195,    -1,   396,
      -1,   408,    -1,   421,    -1,   477,    -1,   478,    -1,   466,
      -1,   487,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   686,   686,   688,   689,   692,   693,   694,   700,   701,
     702,   703,   704,   707,   720,   721,   722,   723,   724,   725,
     726,   727,   728,   729,   730,   731,   732,   733,   734,   735,
     736,   737,   761,   762,   763,   764,   765,   766,   767,   768,
     769,   770,   771,   772,   773,   774,   775,   776,   777,   778,
     779,   780,   781,   782,   783,   784,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   829,   830,   831,   832,
     833,   834,   835,   836,   837,   838,   839,   845,   846,   847,
     848,   849,   850,   851,   852,   853,   859,   869,   873,   881,
     885,   896,   906,   907,   918,   925,   931,   942,   948,   957,
     964,   970,   979,   986,  1007,  1011,  1012,  1021,  1022,  1023,
    1024,  1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,
    1034,  1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1052,
    1063,  1067,  1077,  1080,  1090,  1092,  1102,  1104,  1115,  1125,
    1129,  1130,  1139,  1141,  1152,  1154,  1158,  1159,  1162,  1163,
    1170,  1171,  1172,  1173,  1174,  1175,  1188,  1190,  1192,  1197,
    1199,  1201,  1203,  1205,  1208,  1210,  1212,  1214,  1216,  1218,
    1220,  1222,  1226,  1227,  1231,  1233,  1237,  1238,  1239,  1240,
    1243,  1244,  1245,  1248,  1249,  1250,  1251,  1261,  1262,  1263,
    1265,  1267,  1269,  1273,  1274,  1275,  1278,  1279,  1282,  1284,
    1286,  1288,  1290,  1294,  1296,  1298,  1300,  1302,  1308,  1309,
    1312,  1316,  1318,  1322,  1323,  1329,  1333,  1334,  1335,  1336,
    1346,  1348,  1354,  1355,  1359,  1363,  1366,  1369,  1372,  1375,
    1378,  1381,  1384,  1387,  1390,  1393,  1396,  1399,  1402,  1405,
    1408,  1411,  1414,  1417,  1420,  1423,  1426,  1429,  1432,  1435,
    1438,  1440,  1444,  1445,  1451,  1454,  1456,  1458,  1463,  1464,
    1467,  1468,  1469,  1472,  1473,  1483,  1485,  1489,  1501,  1510,
    1511,  1514,  1515,  1516,  1519,  1520,  1523,  1524,  1525,  1527,
    1529,  1530,  1531,  1533,  1535,  1537,  1542,  1543,  1546,  1547,
    1554,  1557,  1560,  1561,  1571,  1574,  1584,  1585,  1586,  1587,
    1588,  1589,  1590,  1594,  1597,  1599,  1601,  1605,  1606,  1607,
    1610,  1614,  1615,  1618,  1620,  1621,  1635,  1637,  1639,  1641,
    1643,  1645,  1647,  1662,  1663,  1664,  1665,  1668,  1672,  1674,
    1678,  1679,  1680,  1681,  1682,  1683,  1690,  1692,  1696,  1698,
    1700,  1702,  1707,  1708,  1711,  1713,  1717,  1720,  1722,  1728,
    1731,  1732,  1733,  1734,  1735,  1738,  1742,  1746,  1747,  1748,
    1749,  1750,  1753,  1756,  1759,  1760,  1761,  1762,  1765,  1766,
    1767,  1768,  1771,  1772,  1775,  1776,  1785,  1784,  1795,  1801,
    1804,  1807,  1809,  1813,  1824,  1828,  1832,  1833,  1836,  1838,
    1840,  1842,  1844,  1846,  1848,  1850,  1852,  1854,  1856,  1860,
    1861,  1872,  1874,  1879,  1880,  1887,  1888,  1891,  1894,  1896,
    1899,  1902,  1904,  1908,  1909,  1919,  1923,  1924,  1938,  1940,
    1953,  1957,  1964,  1965,  1968,  1970,  1972,  1976,  1977,  1978,
    1981,  1984,  1987,  1988,  1991,  1992,  1995,  1997,  2000,  2003,
    2004,  2007,  2008,  2011,  2012,  2019,  2020,  2028,  2033,  2035,
    2039,  2041,  2045,  2047,  2058,  2066,  2081,  2083,  2085,  2087,
    2089,  2091,  2093,  2095,  2097,  2099,  2101,  2105,  2109,  2110,
    2113,  2114,  2118,  2119,  2120,  2121,  2124,  2125,  2128,  2131,
    2132,  2135,  2138,  2139,  2142,  2149,  2150,  2153,  2155,  2157,
    2159,  2161,  2165,  2166,  2169,  2170,  2173,  2174,  2177,  2181,
    2183,  2187,  2188,  2192,  2194,  2198,  2200,  2204,  2206,  2219,
    2224,  2236,  2238,  2242,  2243,  2244,  2245,  2246,  2247,  2248,
    2249,  2250,  2251,  2252,  2253,  2256,  2258,  2262,  2263,  2266,
    2267,  2276,  2291,  2296,  2301,  2306,  2311,  2316,  2321,  2326,
    2331,  2333,  2337,  2338,  2339,  2340,  2341,  2347,  2353,  2359,
    2360,  2361,  2367,  2368,  2369,  2375,  2378,  2379,  2382,  2384,
    2386,  2388,  2390,  2392,  2394,  2396,  2398,  2400,  2402,  2404,
    2406,  2408,  2410,  2412,  2416,  2417,  2418,  2419,  2420,  2421,
    2422,  2423,  2424,  2425,  2426,  2427,  2430,  2431,  2441,  2445,
    2447,  2451,  2452,  2453,  2456,  2458,  2462,  2463,  2464,  2465,
    2468,  2470,  2472,  2474,  2476,  2478,  2480,  2482,  2486,  2488,
    2492,  2493,  2496,  2501,  2504,  2506,  2510,  2519,  2524,  2528,
    2529,  2532,  2533,  2549,  2552,  2557,  2558,  2561,  2564,  2567,
    2568,  2571,  2573,  2575,  2579,  2580,  2581,  2584,  2585,  2586,
    2589,  2590,  2591,  2594,  2597,  2602,  2603,  2606,  2608,  2612,
    2614,  2618,  2619,  2620,  2621,  2622,  2625,  2626,  2627,  2628,
    2631,  2633,  2637,  2639,  2649,  2651,  2653,  2658,  2660,  2665,
    2667,  2669,  2671,  2673,  2675,  2677,  2679,  2681,  2683,  2685,
    2687,  2689,  2693,  2695,  2697,  2701,  2702,  2706,  2710,  2711,
    2714,  2715,  2728,  2730,  2734,  2736,  2740,  2742,  2746,  2748,
    2750,  2752,  2757,  2759,  2763,  2766,  2771,  2772,  2776,  2780,
    2781,  2791,  2793,  2795,  2799,  2800,  2803,  2804,  2815,  2817,
    2819,  2821,  2823,  2825,  2827,  2829,  2831,  2833,  2835,  2837,
    2839,  2841,  2843,  2845,  2847,  2849,  2851,  2853,  2855,  2859,
    2860,  2870,  2872,  2874,  2876,  2878,  2880,  2890,  2892,  2894,
    2896,  2898,  2900,  2902,  2904,  2906,  2908,  2910,  2912,  2914,
    2916,  2928,  2927,  2937,  2938,  2939,  2943,  2945,  2949,  2950,
    2951,  2952,  2953,  2956,  2957,  2961,  2962,  2963,  2964,  2967,
    2968,  2969,  2972,  2974,  2986,  2990,  2994,  2996,  3009,  3010,
    3011,  3012,  3013,  3014,  3015,  3016,  3017,  3018,  3019,  3020,
    3021,  3022,  3025,  3026,  3027,  3031,  3033,  3034,  3038,  3039,
    3040,  3044,  3045,  3056,  3058,  3067,  3072,  3077,  3083,  3093,
    3105,  3107,  3111,  3113,  3117,  3119,  3121,  3123,  3125,  3127,
    3129,  3131,  3133,  3135,  3137,  3141,  3142,  3153,  3157,  3162,
    3163,  3167,  3177,  3179,  3190,  3197,  3199,  3201,  3203,  3205,
    3209,  3210,  3214,  3219,  3221,  3223,  3225,  3227,  3229,  3234,
    3248,  3250,  3252,  3257,  3258,  3269,  3271,  3273,  3277,  3279,
    3283,  3284,  3287,  3288,  3291,  3292,  3295,  3296,  3299,  3302,
    3313,  3318,  3319,  3320,  3321,  3322,  3323,  3326,  3327,  3330,
    3336,  3345,  3346,  3347,  3348,  3351,  3352,  3355,  3360,  3365,
    3366,  3369,  3370,  3371,  3372,  3382,  3387,  3389,  3391,  3395,
    3397,  3401,  3405,  3406,  3416,  3420,  3421,  3424,  3428,  3431,
    3434,  3435,  3436,  3437,  3438,  3439,  3440,  3441,  3444,  3445,
    3455,  3464,  3465,  3469,  3470,  3474,  3477,  3480,  3483,  3484,
    3493,  3524,  3525,  3526,  3527,  3528,  3532,  3538,  3539,  3549,
    3551,  3555,  3557,  3561,  3563,  3565,  3567,  3571,  3572,  3575,
    3579,  3581,  3583,  3585,  3589,  3594,  3595,  3605,  3607,  3609,
    3611,  3613,  3615,  3617,  3619,  3623,  3624,  3627,  3628,  3631,
    3633,  3635,  3638,  3641,  3642,  3645,  3649,  3650,  3653,  3655,
    3659,  3661,  3663,  3665,  3667,  3671,  3672,  3675,  3676,  3679,
    3689,  3692,  3695,  3698,  3702,  3703,  3707,  3708,  3712,  3713,
    3717,  3719,  3724,  3725,  3728,  3730,  3742,  3743,  3746,  3747,
    3757,  3759,  3761,  3763,  3765,  3767,  3769,  3771,  3773,  3775,
    3777,  3798,  3800,  3802,  3804,  3806,  3808,  3812,  3814,  3816,
    3818,  3822,  3823,  3824,  3825,  3829,  3830,  3840,  3842,  3846,
    3848,  3850,  3852,  3856,  3858,  3860,  3864,  3867,  3868,  3871,
    3872,  3873,  3874,  3877,  3879,  3883,  3896,  3898,  3900,  3902,
    3907,  3913,  3920,  3927,  3928,  3929,  3930,  3931,  3932,  3933,
    3934,  3935,  3938,  3939,  3940,  3941,  3942,  3943,  3945,  3949,
    3950,  3951,  3952,  3955,  3956,  3959,  3960,  3968,  3970,  3972,
    3974,  3976,  3978,  3980,  3982,  3984,  3986,  3988,  3992,  3995,
    4003,  4004,  4007,  4008,  4011,  4015,  4024,  4025,  4028,  4029,
    4032,  4036,  4040,  4042,  4044,  4046,  4048,  4050,  4054,  4057,
    4060,  4063,  4066,  4068,  4070,  4072,  4076,  4080,  4082,  4085,
    4088,  4089,  4090,  4091,  4092,  4093,  4094,  4095,  4096,  4097,
    4098,  4099,  4100,  4101,  4127,  4129,  4131,  4142,  4144,  4146,
    4148,  4150,  4152,  4154,  4156,  4158,  4160,  4162,  4164,  4166,
    4168,  4170,  4172,  4174,  4176,  4178,  4180,  4182,  4184,  4186,
    4188,  4190,  4192,  4194,  4196,  4198,  4200,  4202,  4204,  4206,
    4208,  4219,  4221,  4223,  4225,  4227,  4229,  4231,  4233,  4235,
    4237,  4239,  4241,  4243,  4245,  4247,  4249,  4251,  4253,  4255,
    4257,  4259,  4271,  4273,  4275,  4277,  4279,  4281,  4283,  4285,
    4287,  4289,  4291,  4293,  4295,  4297,  4299,  4301,  4303,  4305,
    4307,  4309,  4311,  4323,  4325,  4327,  4329,  4331,  4333,  4335,
    4337,  4339,  4341,  4343,  4355,  4357,  4359,  4361,  4363,  4365,
    4367,  4369,  4371,  4373,  4375,  4377,  4379,  4381,  4383,  4385,
    4387,  4389,  4391,  4393,  4395,  4397,  4399,  4401,  4404,  4406,
    4408,  4410,  4412,  4414,  4416,  4418,  4420,  4422,  4424,  4426,
    4428,  4430,  4432,  4434,  4436,  4438,  4446,  4448,  4452,  4454,
    4456,  4459,  4462,  4466,  4468,  4472,  4474,  4478,  4479,  4482,
    4483,  4484,  4487,  4489,  4491,  4495,  4496,  4497,  4500,  4501,
    4504,  4505,  4506,  4507,  4508,  4509,  4510,  4511,  4512,  4515,
    4516,  4519,  4520,  4523,  4524,  4525,  4526,  4527,  4528,  4531,
    4533,  4537,  4540,  4543,  4545,  4549,  4550,  4554,  4555,  4561,
    4562,  4563,  4564,  4565,  4566,  4567,  4568,  4572,  4574,  4579,
    4583,  4586,  4589,  4591,  4593,  4595,  4597,  4600,  4603,  4607,
    4611,  4613,  4615,  4619,  4621,  4628,  4632,  4634,  4638,  4642,
    4645,  4648,  4649,  4652,  4653,  4657,  4658,  4659,  4660,  4663,
    4664,  4668,  4669,  4672,  4673,  4677,  4678,  4682,  4683,  4686,
    4694,  4696,  4701,  4703,  4705,  4781,  4782,  4785,  4787,  4791,
    4793,  4797,  4799,  4804,  4805,  4806,  4807,  4808,  4810,  4812,
    4814,  4822,  4824,  4826,  4828,  4830,  4832,  4834,  4836,  4840,
    4841,  4842,  4843,  4844,  4854,  4865,  4876,  4882,  4883,  4886,
    4887,  4890,  4898,  4901,  4909,  4910,  4919,  4928,  4940,  4941,
    4944,  4945,  4946,  4949,  4950,  4951,  4952,  4953,  4956,  4957,
    4960,  4961,  4962,  4963,  4964,  4965,  4966,  4968,  4971,  4973,
    4980,  4996,  4998,  5001,  5003,  5007,  5019,  5035,  5039,  5050,
    5051,  5054,  5066,  5075,  5076,  5079,  5080,  5081,  5084,  5085,
    5088,  5089,  5092,  5093,  5096,  5098,  5100,  5102,  5106,  5113,
    5136,  5168,  5178,  5185,  5222,  5231,  5233,  5234,  5237,  5239,
    5240,  5243,  5244,  5245,  5246,  5247,  5254,  5253,  5263,  5265,
    5267,  5268,  5269,  5272,  5273,  5274,  5275,  5276,  5279,  5280,
    5284,  5283,  5300,  5298,  5313,  5312,  5325,  5331,  5332,  5335,
    5337,  5338,  5341,  5342,  5343,  5344,  5347,  5348,  5351,  5359,
    5376,  5384,  5407,  5505,  5539,  5541,  5543,  5547,  5551,  5550,
    5601,  5603,  5602,  5617,  5623,  5630,  5635,  5638,  5639,  5642,
    5643,  5644,  5645,  5646,  5647,  5648,  5656,  5664,  5667,  5668,
    5669,  5670,  5671,  5672,  5680,  5688,  5689,  5690,  5693,  5694,
    5697,  5699,  5703,  5789,  5790,  5797,  5798,  5799,  5805,  5814,
    5817,  5818,  5819,  5820,  5823,  5824,  5825,  5828,  5829,  5830,
    5831,  5832,  5835,  5837,  5841,  5854,  5861,  5862,  5868,  5870,
    5871,  5874,  5875,  5878,  5885,  5892,  5892,  5894,  5895,  5898,
    5898,  5900,  5910,  5917,  5924,  5931,  5940,  5941,  5953,  5964,
    5975,  5979,  5980,  5983,  5988,  5992,  5993,  5996,  6003,  6010,
    6014,  6015,  6018,  6021,  6025,  6026,  6029,  6036,  6037,  6038,
    6039,  6040,  6041,  6042,  6043,  6044,  6045,  6046,  6047,  6048,
    6049,  6050,  6057,  6058,  6061,  6062,  6069,  6070,  6071,  6078,
    6077,  6094,  6095,  6102,  6101,  6170,  6176,  6182,  6190,  6196,
    6202,  6208,  6214,  6220,  6226,  6232,  6238,  6249,  6250,  6253,
    6254,  6255,  6256,  6257,  6258,  6259,  6260,  6261,  6262,  6263,
    6264,  6265,  6266,  6267,  6268,  6269,  6270,  6271,  6272,  6273,
    6274,  6275,  6276,  6277,  6280,  6281,  6282,  6283,  6284,  6285,
    6289,  6290,  6291,  6292,  6293,  6294,  6295,  6298,  6312,  6313,
    6314,  6315,  6316,  6317,  6318,  6319,  6323,  6324,  6325,  6326,
    6327,  6328,  6329,  6333,  6334,  6335,  6336,  6337,  6338,  6344,
    6345,  6346,  6347,  6348,  6349,  6350,  6351,  6352,  6355,  6356,
    6357,  6358,  6361,  6362,  6363,  6364,  6367,  6368,  6369,  6370,
    6371,  6372,  6373,  6391,  6391,  6393,  6394,  6395,  6396,  6397,
    6398,  6404,  6405,  6408,  6409,  6410,  6411,  6412,  6413,  6414,
    6415,  6416,  6417,  6418,  6419,  6420,  6421,  6422,  6423,  6424,
    6425,  6426,  6427,  6428,  6429,  6430,  6431,  6432,  6433,  6434,
    6435,  6436,  6437,  6438,  6439,  6441,  6442,  6443,  6444,  6445,
    6446,  6447,  6448,  6449,  6450,  6451,  6452,  6454,  6455,  6456,
    6457,  6458,  6459,  6460,  6461,  6462,  6463,  6464,  6465,  6466,
    6467,  6468,  6469,  6470,  6471,  6473,  6474,  6475,  6476,  6477,
    6478,  6479,  6480,  6481,  6482,  6483,  6484,  6485,  6486,  6487,
    6488,  6489,  6491,  6492,  6493,  6494,  6495,  6496,  6497,  6498,
    6499,  6500,  6501,  6502,  6503,  6504,  6505,  6506,  6507,  6508,
    6509,  6510,  6511,  6512,  6513,  6514,  6515,  6516,  6517,  6518,
    6519,  6521,  6522,  6524,  6525,  6526,  6527,  6528,  6529,  6530,
    6531,  6532,  6533,  6534,  6535,  6536,  6537,  6538,  6539,  6540,
    6541,  6542,  6543,  6544,  6545,  6546,  6547,  6548,  6549,  6550,
    6551,  6552,  6553,  6554,  6555,  6556,  6557,  6558,  6559,  6560,
    6561,  6562,  6563,  6564,  6565,  6566,  6567,  6568,  6569,  6570,
    6571,  6572,  6573,  6574,  6575,  6576,  6577,  6578,  6579,  6580,
    6582,  6583,  6584,  6585,  6586,  6587,  6588,  6589,  6590,  6591,
    6592,  6593,  6594,  6595,  6596,  6597,  6598,  6599,  6600,  6601,
    6602,  6603,  6604,  6605,  6606,  6607,  6608,  6609,  6610,  6611,
    6612,  6613,  6614,  6615,  6616,  6617,  6618,  6619,  6620,  6621,
    6622,  6623,  6624,  6625,  6626,  6627,  6628,  6629,  6630,  6631,
    6632,  6634,  6648,  6649,  6653,  6654,  6655,  6656,  6657,  6658,
    6659,  6660,  6661,  6665,  6666,  6667,  6668,  6669,  6670,  6671,
    6672,  6673,  6674,  6675,  6676,  6677,  6678,  6679,  6680,  6681,
    6682,  6683,  6684,  6685,  6688,  6689,  6690,  6691,  6692,  6693,
    6694,  6695,  6696,  6710,  6711,  6712,  6713,  6714,  6715,  6716,
    6717,  6718,  6719,  6720,  6721,  6722,  6723,  6724,  6725,  6726,
    6727,  6728,  6729,  6739,  6740,  6741,  6742,  6743,  6744,  6745,
    6746,  6747,  6748,  6749,  6750,  6751,  6752,  6753,  6754,  6755,
    6756,  6757,  6758,  6759,  6760,  6761,  6762,  6763,  6764,  6765,
    6766,  6767,  6768,  6769,  6770,  6771,  6772,  6773,  6774,  6775,
    6776,  6777,  6778,  6779,  6780,  6781,  6782,  6783,  6784,  6785,
    6786,  6787,  6788,  6789,  6790,  6791,  6792,  6793,  6794,  6795,
    6796,  6797,  6798,  6799,  6800,  6801,  6805,  6806,  6810,  6811,
    6812,  6813,  6814,  6818,  6818,  6821,  6827,  6828,  6831,  6833,
    6838,  6848,  6855,  6856,  6857,  6860,  6892,  6893,  6896,  6898,
    6906,  6907,  6908,  6912,  6913,  6917,  6918,  6921,  6922,  6925,
    6926,  6927,  6928,  6929,  6932,  6933,  6934,  6935,  6936,  6937,
    6938,  6939,  6940,  6941,  6942,  6943,  6944,  6945,  6946,  6947,
    6948,  6949,  6950,  6951,  6952,  6953,  6954,  6955,  6956,  6957,
    6958,  6959,  6960,  6961,  6962,  6963,  6964,  6965,  6966,  6967,
    6968,  6969,  6970,  6971,  6972,  6973,  6974,  6975,  6976,  6977,
    6978,  6979,  6980,  6981,  6982,  6983,  6984,  6985,  6986,  6987,
    6988
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", 
  "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", 
  "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", 
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", 
  "ACCESS", "ACTION", "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", 
  "ALSO", "ALTER", "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", 
  "AS", "ASC", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONCURRENTLY", "CONFIGURATION", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONTENT_P", "CONVERSION_P", "COPY", "COST", "CREATE", 
  "CREATEDB", "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_P", 
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", 
  "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", 
  "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", 
  "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", "DO", "DOCUMENT_P", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", 
  "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", 
  "FALSE_P", "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MAPPING", "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", 
  "MONTH_P", "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", 
  "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", 
  "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", "NOTHING", 
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", 
  "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", 
  "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", 
  "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", 
  "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", 
  "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", 
  "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SUPERUSER_P", 
  "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", 
  "TEMPLATE", "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", 
  "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WITH", "WITHOUT", "WORK", "WRITE", "XML_P", 
  "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPARSE", 
  "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", 
  "NULLS_FIRST", "NULLS_LAST", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ECONST", "NCONST", 
  "ICONST", "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", 
  "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", 
  "'.'", "';'", "'{'", "'}'", "\"=\"", "','", "':'", "$accept", "prog", 
  "statements", "statement", "at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", 
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_name", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "SetResetClause", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "TableLikeOptionList", 
  "TableLikeOption", "TableConstraint", "ConstraintElem", 
  "opt_column_list", "columnList", "columnElem", "key_match", 
  "key_actions", "key_delete", "key_update", "key_action", "OptInherit", 
  "OptWith", "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "CreateAsStmt", "@1", "create_as_target", "OptCreateAs", "CreateAsList", 
  "CreateAsElement", "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", 
  "OptSeqElem", "opt_by", "CreatePLangStmt", "opt_trusted", 
  "handler_name", "opt_validator", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTableSpaceStmt", "OptTableSpaceOwner", 
  "DropTableSpaceStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "enum_val_list", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_opfamily", 
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt", 
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt", 
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt", 
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt", 
  "FetchStmt", "fetch_direction", "from_in", "CommentStmt", 
  "comment_type", "comment_text", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", "IndexStmt", 
  "index_opt_unique", "access_method_clause", "index_params", 
  "index_elem", "opt_class", "opt_asc_desc", "opt_nulls_order", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "PrepareStmt", "PreparableStmt", 
  "prep_type_clause", "ExecuteStmt", "execute_param_clause", 
  "DeallocateStmt", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "returning_clause", "DeleteStmt", "using_clause", 
  "LockStmt", "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "set_clause_list", "set_clause", "single_set_clause", 
  "multiple_set_clause", "set_target", "set_target_list", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "where_or_current_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "opt_type_modifiers", 
  "Numeric", "opt_float", "Bit", "ConstBit", "BitWithLength", 
  "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "row", "sub_type", 
  "all_Op", "MathOp", "qual_Op", "qual_all_Op", "subquery_Op", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "IntConstVar", 
  "AllConstVar", "StringConst", "PosIntStringConst", "NumConst", 
  "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", 
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration", 
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@3", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@4", "var_declaration", "@5", "@6", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@7", "struct_union_type", "@8", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execute_rest", 
  "execstring", "prepared_name", "ECPGFree", "ECPGOpen", "opt_ecpg_using", 
  "ecpg_using", "using_descriptor", "into_descriptor", "opt_sql", 
  "ecpg_into", "using_list", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", "@9", 
  "opt_reference", "ECPGVar", "@10", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "ECPGunreserved_interval", "ECPGunreserved", 
  "ECPGunreserved_con", "col_name_keyword", "type_func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,    61,    60,    62,   721,
      43,    45,    42,    47,    37,    94,   722,    91,    93,    40,
      41,    46,    59,   123,   125,   723,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   488,   489,   490,   490,   491,   491,   491,   491,   491,
     491,   491,   491,   492,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   493,   493,   493,   493,   493,   493,
     493,   493,   493,   493,   494,   495,   495,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   496,
     496,   496,   496,   496,   496,   496,   496,   496,   496,   497,
     498,   499,   500,   501,   502,   502,   503,   503,   504,   505,
     506,   506,   507,   507,   508,   508,   509,   509,   510,   510,
     511,   511,   511,   511,   511,   511,   512,   512,   512,   513,
     513,   513,   513,   513,   513,   513,   513,   513,   513,   513,
     513,   513,   514,   514,   515,   515,   516,   516,   516,   516,
     517,   517,   517,   518,   518,   518,   518,   519,   519,   519,
     519,   519,   519,   520,   520,   520,   521,   521,   522,   522,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   524,
     525,   526,   526,   527,   527,   528,   529,   529,   529,   529,
     530,   530,   531,   531,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   532,   532,   532,   532,   532,   532,   532,   532,
     532,   532,   533,   533,   534,   534,   534,   534,   535,   535,
     536,   536,   536,   537,   537,   538,   538,   539,   539,   540,
     540,   541,   541,   541,   542,   542,   543,   543,   543,   543,
     543,   543,   543,   543,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   548,   549,   549,   549,   549,
     549,   549,   549,   550,   550,   551,   551,   552,   552,   552,
     553,   554,   554,   555,   555,   555,   556,   556,   556,   556,
     556,   556,   556,   557,   557,   557,   557,   558,   559,   559,
     560,   560,   560,   560,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   566,   566,   566,
     567,   567,   567,   567,   567,   568,   569,   570,   570,   570,
     570,   570,   571,   571,   572,   572,   572,   572,   573,   573,
     573,   573,   574,   574,   575,   575,   577,   576,   578,   579,
     579,   580,   580,   581,   582,   583,   584,   584,   585,   585,
     585,   585,   585,   585,   585,   585,   585,   585,   585,   586,
     586,   587,   587,   588,   588,   589,   589,   590,   590,   591,
     591,   592,   592,   593,   593,   594,   595,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   600,   600,   600,
     601,   601,   602,   602,   603,   603,   604,   604,   604,   605,
     605,   606,   606,   607,   607,   607,   607,   607,   608,   608,
     609,   609,   610,   610,   611,   612,   613,   613,   613,   613,
     613,   613,   613,   613,   613,   613,   613,   614,   615,   615,
     616,   616,   617,   617,   617,   617,   618,   618,   619,   620,
     620,   621,   622,   622,   623,   624,   624,   625,   625,   625,
     625,   625,   626,   626,   627,   627,   628,   628,   629,   630,
     630,   631,   631,   632,   632,   633,   633,   634,   634,   635,
     636,   637,   637,   638,   638,   638,   638,   638,   638,   638,
     638,   638,   638,   638,   638,   639,   639,   640,   640,   641,
     641,   642,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   645,   645,   646,   646,
     646,   646,   646,   646,   646,   646,   646,   646,   646,   646,
     646,   646,   646,   646,   647,   647,   647,   647,   647,   647,
     647,   647,   647,   647,   647,   647,   648,   648,   649,   650,
     650,   651,   651,   651,   652,   652,   653,   653,   653,   653,
     654,   654,   654,   654,   654,   654,   654,   654,   655,   655,
     656,   656,   657,   657,   658,   658,   659,   660,   661,   662,
     662,   663,   663,   664,   664,   665,   665,   666,   666,   667,
     667,   668,   668,   668,   669,   669,   669,   670,   670,   670,
     671,   671,   671,   672,   672,   673,   673,   674,   674,   675,
     675,   676,   676,   676,   676,   676,   677,   677,   677,   677,
     678,   678,   679,   680,   681,   681,   681,   682,   682,   683,
     683,   683,   683,   683,   683,   683,   683,   683,   683,   683,
     683,   683,   684,   684,   684,   685,   685,   686,   687,   687,
     688,   688,   689,   689,   690,   690,   691,   691,   692,   692,
     692,   692,   693,   693,   694,   694,   695,   695,   696,   697,
     697,   698,   698,   698,   699,   699,   700,   700,   701,   701,
     701,   701,   701,   701,   701,   701,   701,   701,   701,   701,
     701,   701,   701,   701,   701,   701,   701,   701,   701,   702,
     702,   703,   703,   703,   703,   703,   703,   704,   704,   704,
     704,   704,   704,   704,   704,   704,   704,   704,   704,   704,
     704,   706,   705,   707,   707,   707,   708,   708,   709,   709,
     709,   709,   709,   710,   710,   711,   711,   711,   711,   712,
     712,   712,   713,   713,   714,   715,   716,   716,   717,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   717,   718,   718,   718,   719,   719,   719,   720,   720,
     720,   721,   721,   722,   722,   723,   723,   723,   723,   724,
     725,   725,   726,   726,   727,   727,   727,   727,   727,   727,
     727,   727,   727,   727,   727,   728,   728,   729,   730,   731,
     731,   732,   733,   733,   734,   735,   735,   735,   735,   735,
     736,   736,   737,   738,   738,   738,   738,   738,   738,   739,
     740,   740,   740,   741,   741,   742,   742,   742,   743,   743,
     744,   744,   745,   745,   746,   746,   747,   747,   748,   748,
     749,   750,   750,   750,   750,   750,   750,   751,   751,   752,
     752,   753,   753,   753,   753,   754,   754,   755,   755,   756,
     756,   757,   757,   757,   757,   758,   759,   759,   759,   760,
     760,   761,   762,   762,   763,   764,   764,   765,   766,   766,
     767,   767,   767,   767,   767,   767,   767,   767,   768,   768,
     769,   770,   770,   771,   771,   772,   773,   774,   775,   775,
     776,   777,   777,   777,   777,   777,   778,   778,   778,   779,
     779,   780,   780,   781,   781,   781,   781,   782,   782,   783,
     783,   783,   783,   783,   784,   784,   784,   785,   785,   785,
     785,   785,   785,   785,   785,   786,   786,   787,   787,   788,
     788,   788,   788,   789,   789,   790,   791,   791,   792,   792,
     793,   793,   793,   793,   793,   794,   794,   795,   795,   796,
     797,   797,   798,   798,   799,   799,   800,   800,   801,   801,
     802,   802,   803,   803,   804,   804,   805,   805,   806,   806,
     807,   807,   807,   807,   807,   807,   807,   807,   807,   807,
     807,   808,   808,   808,   808,   808,   808,   809,   809,   809,
     809,   810,   810,   810,   810,   811,   811,   812,   812,   813,
     813,   813,   813,   814,   814,   814,   815,   816,   816,   817,
     817,   817,   817,   818,   818,   819,   820,   820,   820,   820,
     821,   821,   821,   822,   822,   822,   822,   822,   822,   822,
     822,   822,   823,   823,   823,   823,   823,   823,   823,   824,
     824,   824,   824,   825,   825,   826,   826,   827,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   827,   828,   828,
     829,   829,   830,   830,   831,   832,   833,   833,   834,   834,
     835,   836,   837,   837,   837,   837,   837,   837,   838,   838,
     839,   839,   840,   840,   840,   840,   841,   842,   842,   842,
     843,   843,   843,   843,   843,   843,   843,   843,   843,   843,
     843,   843,   843,   843,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   844,   844,   844,   844,   844,
     844,   844,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   845,   845,   845,   845,   845,   845,   845,
     845,   845,   845,   846,   846,   846,   846,   846,   846,   846,
     846,   846,   846,   846,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   847,   847,   847,   847,
     847,   847,   847,   847,   847,   847,   848,   848,   849,   849,
     849,   849,   850,   851,   851,   852,   852,   853,   853,   854,
     854,   854,   855,   855,   855,   856,   856,   856,   857,   857,
     858,   858,   858,   858,   858,   858,   858,   858,   858,   859,
     859,   860,   860,   861,   861,   861,   861,   861,   861,   862,
     862,   863,   863,   864,   864,   865,   865,   866,   866,   867,
     867,   867,   867,   867,   867,   867,   867,   868,   868,   869,
     870,   870,   871,   871,   871,   871,   871,   871,   872,   873,
     874,   874,   874,   875,   875,   876,   877,   877,   878,   879,
     879,   880,   880,   881,   881,   882,   882,   882,   882,   883,
     883,   884,   884,   885,   885,   886,   886,   887,   887,   888,
     889,   889,   890,   890,   890,   891,   891,   892,   892,   893,
     893,   894,   894,   895,   896,   897,   898,   899,   900,   901,
     901,   902,   902,   902,   902,   902,   902,   902,   902,   903,
     904,   905,   906,   907,   907,   907,   907,   908,   908,   909,
     909,   910,   910,   911,   911,   911,   911,   911,   912,   912,
     913,   913,   913,   914,   914,   914,   914,   914,   915,   915,
     916,   916,   916,   916,   916,   916,   916,   916,   917,   918,
     918,   919,   919,   919,   919,   920,   920,   920,   920,   921,
     921,   922,   923,   924,   924,   925,   925,   925,   926,   926,
     927,   927,   928,   928,   929,   929,   929,   929,   930,   930,
     931,   932,   932,   933,   934,   935,   936,   936,   937,   938,
     938,   939,   939,   939,   939,   939,   941,   940,   942,   943,
     944,   944,   944,   945,   945,   945,   945,   945,   946,   946,
     948,   947,   950,   949,   951,   949,   949,   952,   952,   953,
     953,   953,   954,   954,   954,   954,   955,   955,   956,   956,
     956,   956,   956,   956,   957,   957,   957,   958,   960,   959,
     961,   962,   961,   963,   963,   964,   964,   965,   965,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   967,   967,
     967,   967,   967,   967,   967,   967,   967,   967,   968,   968,
     969,   969,   970,   971,   971,   972,   972,   972,   973,   974,
     975,   975,   975,   975,   976,   976,   976,   977,   977,   977,
     977,   977,   978,   978,   979,   979,   980,   980,   981,   982,
     982,   983,   983,   984,   985,   986,   986,   987,   987,   988,
     988,   989,   989,   990,   990,   990,   991,   991,   992,   993,
     994,   995,   995,   996,   997,   998,   998,   999,  1000,  1001,
    1002,  1002,  1003,  1004,  1005,  1005,  1006,  1007,  1007,  1007,
    1007,  1007,  1007,  1007,  1007,  1007,  1007,  1007,  1007,  1007,
    1007,  1007,  1008,  1008,  1009,  1009,  1010,  1010,  1010,  1012,
    1011,  1013,  1013,  1015,  1014,  1016,  1016,  1016,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1018,  1018,  1019,
    1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1019,  1019,  1019,  1019,  1020,  1020,  1020,  1020,  1020,  1020,
    1021,  1021,  1021,  1021,  1021,  1021,  1021,  1022,  1023,  1023,
    1023,  1023,  1023,  1023,  1023,  1023,  1024,  1024,  1024,  1024,
    1024,  1024,  1024,  1025,  1025,  1025,  1025,  1025,  1025,  1026,
    1026,  1026,  1026,  1026,  1026,  1026,  1026,  1026,  1027,  1027,
    1027,  1027,  1028,  1028,  1028,  1028,  1029,  1029,  1029,  1029,
    1029,  1029,  1029,  1030,  1030,  1031,  1031,  1031,  1031,  1031,
    1031,  1032,  1032,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1033,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,  1035,
    1035,  1035,  1035,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,  1036,
    1036,  1036,  1036,  1037,  1037,  1038,  1039,  1039,  1040,  1040,
    1041,  1042,  1043,  1043,  1043,  1044,  1045,  1045,  1046,  1046,
    1047,  1047,  1047,  1048,  1048,  1049,  1049,  1050,  1050,  1051,
    1051,  1051,  1051,  1051,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,
    1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,  1052,
    1052
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     2,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     2,     2,     2,     2,     3,     3,     5,
       5,     4,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     3,
       3,     3,     1,     3,     1,     3,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       6,     1,     1,     1,     1,     0,     1,     1,     3,     4,
       5,     4,     2,     2,     3,     4,     3,     2,     2,     1,
       4,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     4,     4,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     2,     9,     6,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,    11,    12,     1,     1,     2,     2,
       2,     2,     0,     1,     0,     1,     3,     1,     1,     1,
       3,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     2,     0,
       2,     2,     2,     2,     2,     2,     3,     1,     4,     6,
       7,    11,     3,     0,     3,     1,     1,     2,     2,     0,
       1,     1,     2,     2,     0,     3,     3,     2,     1,     1,
       2,     2,     4,     0,     2,     2,     2,     0,     3,     4,
       4,     0,     2,     0,     4,     0,     0,     7,     5,     3,
       0,     3,     1,     1,     5,     4,     2,     0,     2,     1,
       2,     3,     2,     2,     2,     2,     3,     3,     3,     1,
       0,     5,     9,     1,     0,     1,     2,     2,     0,     2,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
      14,    19,     1,     1,     1,     3,     5,     1,     1,     1,
       3,     0,     1,     0,     1,     1,     1,     3,     0,     1,
       1,     0,     2,     1,     2,     1,     2,     0,     2,     1,
       2,     2,     6,     8,     8,     3,     5,     4,     4,     4,
       3,     7,     8,     6,     6,     6,     6,     3,     1,     3,
       3,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       3,     3,     1,     3,    13,     1,     3,     4,     7,     4,
       7,     2,     1,     0,     2,     0,     1,     0,     6,     8,
       8,     1,     3,     5,     5,     7,     9,     7,     9,     5,
       6,     6,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     1,     2,     2,
       3,     4,     5,     4,     4,     3,     4,     3,     3,     2,
       4,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     2,     2,     1,     2,     2,     1,     1,     6,     7,
       7,     9,     8,     8,     6,     9,     9,     7,    10,     7,
       8,     8,     8,     8,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     7,     7,
      10,     2,     1,     1,     1,     3,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     2,     2,     1,     3,
       1,     2,     3,     0,     1,     3,     2,     6,     6,     3,
       0,     3,     0,    13,    14,     1,     0,     2,     0,     1,
       3,     4,     4,     6,     1,     2,     0,     1,     1,     0,
       1,     1,     0,     9,     7,     2,     0,     3,     2,     1,
       3,     3,     3,     2,     2,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     4,     5,     1,     2,     4,
       5,     1,     1,     1,     1,     3,     3,     2,     2,     2,
       2,     1,     2,     2,     1,     2,     0,     5,     1,     2,
       1,     0,     5,     7,     5,     7,     7,     9,     1,     3,
       3,     3,     1,     3,    11,    10,     2,     0,     9,     2,
       0,     4,     4,     4,     1,     1,     1,     0,     7,     6,
       6,     6,     6,     7,     9,     9,     6,     6,     6,     6,
       6,     8,     8,     6,     6,     8,     8,     8,     8,     1,
       0,     7,     6,     6,     6,     6,     6,     7,     6,     6,
       6,     6,     7,     9,     9,     9,     6,     6,     6,     8,
       8,     0,    14,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     8,     2,     2,     2,     2,     2,     3,
       3,     2,     2,     2,     2,     3,     2,     5,     4,     3,
       3,     3,     1,     1,     0,     3,     2,     2,     1,     3,
       2,     1,     0,     8,    10,     2,     3,     3,     0,     2,
       5,     3,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     4,     3,     3,     1,     0,     5,     4,     2,
       0,     4,     3,     5,     6,     4,     6,     6,     5,     7,
       1,     0,     6,    11,    11,    11,    13,     9,    11,    10,
       3,     1,     4,     2,     0,     4,     5,     5,     2,     4,
       1,     1,     1,     0,     1,     0,     1,     0,     3,     0,
       4,     1,     1,     1,     1,     1,     1,     1,     0,     5,
       4,     1,     1,     1,     1,     3,     0,     4,     8,     3,
       0,     2,     3,     2,     3,     5,     1,     4,     2,     3,
       1,     2,     2,     0,     6,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       7,     1,     3,     1,     1,     3,     5,     2,     1,     3,
       7,     0,     2,     2,     2,     3,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     1,     1,     8,
       1,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     4,     3,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     1,     3,     1,     0,     1,     2,
       4,     4,     2,     0,     2,     3,     2,     0,     3,     1,
       1,     2,     1,     2,     5,     6,     5,     1,     2,     1,
       4,     3,     4,     5,     4,     5,     4,     5,     2,     4,
       1,     2,     2,     2,     1,     1,     0,     4,     2,     1,
       2,     2,     4,     1,     2,     3,     1,     2,     0,     2,
       4,     4,     0,     1,     3,     2,     2,     3,     5,     6,
       3,     4,     0,     1,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     2,     5,     1,
       1,     1,     1,     2,     3,     3,     0,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       1,     1,     1,     1,     5,     2,     1,     1,     1,     1,
       5,     2,     2,     2,     1,     3,     3,     2,     1,     0,
       3,     0,     5,     2,     5,     2,     1,     3,     3,     0,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     3,
       3,     3,     3,     0,     1,     3,     5,     2,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       2,     3,     3,     2,     3,     5,     4,     6,     3,     5,
       4,     6,     4,     6,     5,     7,     2,     3,     2,     4,
       3,     3,     4,     3,     4,     3,     4,     5,     6,     6,
       7,     6,     7,     6,     7,     3,     4,     4,     6,     2,
       3,     4,     1,     3,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     3,     4,     5,     5,     4,     1,
       1,     4,     1,     4,     1,     4,     1,     4,     1,     1,
       1,     1,     6,     4,     4,     4,     4,     6,     5,     5,
       5,     4,     6,     4,     4,     4,     4,     5,     7,     7,
       9,     4,     6,     5,     7,     7,     2,     3,     3,     3,
       4,     0,     4,     1,     3,     3,     1,     1,     1,     2,
       2,     0,     4,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     4,     1,     4,     1,     2,     1,     2,     1,
       3,     3,     0,     1,     3,     1,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     3,     2,
       3,     0,     3,     3,     2,     2,     1,     0,     2,     2,
       3,     2,     1,     1,     3,     5,     2,     1,     4,     2,
       0,     1,     0,     1,     2,     2,     2,     3,     5,     1,
       2,     0,     2,     1,     0,     1,     1,     1,     3,     3,
       3,     1,     3,     1,     1,     1,     1,     1,     3,     1,
       2,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     2,     3,     6,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     5,     1,     1,     1,
       1,     5,     3,     2,     2,     3,     7,     1,     1,     1,
       0,     2,     2,     1,     0,     1,     3,     1,     2,     0,
       2,     0,     2,     0,     1,     3,     4,     3,     1,     1,
       1,     2,     0,     7,     3,     1,     1,     1,     1,     2,
       0,     1,     3,     3,     3,     3,     0,     4,     5,     5,
       0,     1,     1,     1,     1,     2,     2,     2,     1,     2,
       0,     7,     0,     5,     0,     4,     2,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     2,     1,     3,     2,     2,     3,     0,     5,
       1,     0,     5,     2,     2,     1,     1,     1,     2,     2,
       3,     1,     2,     2,     3,     3,     4,     2,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     0,
       1,     3,     5,     0,     2,     0,     1,     2,     3,     2,
       1,     1,     1,     0,     1,     1,     1,     2,     2,     1,
       1,     0,     1,     1,     1,     1,     2,     2,     3,     0,
       1,     2,     1,     4,     4,     0,     1,     2,     1,     1,
       3,     1,     1,     4,     4,     4,     1,     0,     3,     3,
       4,     1,     3,     3,     4,     1,     3,     3,     1,     6,
       1,     3,     3,     6,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     4,     1,     1,     4,     4,     3,     0,
       7,     1,     0,     0,     7,     3,     4,     3,     1,     1,
       1,     2,     3,     5,     2,     5,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     0,     1,     2,     1,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     2,     1,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2219,  2223,  2227,  2228,  2155,  2229,
    2230,  2195,  2196,  2197,  2198,  2199,  2200,  2201,  2202,  2203,
    2204,  2205,  2206,  2208,  2207,  2209,  2210,  2211,  2212,  2213,
    2214,  2215,  2216,  2218,  2217,  2232,  2220,  2233,  2221,  2222,
    2224,  2225,  2194,  2226,  2234,  2235,  2236,  2231,  2184,  1443,
    2185,    10,  1446,  1444,  1445,  1439,  1440,  2239,  2190,  2191,
    2189,  2192,  2193,  2237,  2238,  2180,  2181,  2183,    11,    12,
    2182,  2240,     4,  2186,  2187,  2188,     8,  1526,  1599,     9,
    2179,  1599,     0,  1709,  1710,  1711,     0,  1712,  1713,  1714,
    1715,  1716,  1647,  1613,  1717,     0,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1725,     0,  1726,  1727,  1728,  1729,  1598,
    1730,  1731,  1732,  1733,  1575,  1581,  1693,     0,  1555,  1556,
    1552,  1554,  1553,  1557,  1540,   824,   434,   891,   890,     0,
    2063,   824,  2064,  2022,  2065,  2023,  2024,   235,     0,   881,
    2025,     0,   824,   307,   322,  2066,  1490,     0,  2026,  2027,
       0,     0,     0,   434,   824,     0,     0,  2028,   908,  2029,
       0,  2030,  2067,  2068,     0,     0,  2031,  2069,  2070,  2032,
       0,  2033,  2034,  2071,  2072,  2073,  2035,  2074,  2075,     0,
       0,   996,     0,  2036,  2076,  2037,  2038,     0,  2077,  2039,
    2040,  2041,  2078,  2079,  2042,  2043,  2044,     0,  2045,     0,
       0,     0,     0,     0,  2080,   824,  2046,     0,  1002,     0,
    2047,     0,  2081,  2048,     0,  2049,  2050,  2051,  2052,  2053,
     996,  1689,  1576,     0,     0,   895,     0,  2054,  2082,  2055,
    2056,  2057,  2058,  2059,  2060,  2061,  2062,  2166,  2167,     0,
       0,     0,    47,    53,    24,    23,    27,    28,    67,    72,
      42,    18,    62,    48,   101,   102,   103,    34,    30,    59,
      22,    31,    35,    50,    36,    49,    21,    43,    66,    51,
      70,    52,    71,    37,    60,    57,    44,    45,    46,    63,
      64,    65,    86,    69,    97,    76,    33,    77,    92,    78,
      93,    79,    41,    17,    90,    88,    89,    38,    61,    87,
      91,    19,    20,    94,    68,    84,    81,    98,    96,   104,
      82,    54,    14,    15,    73,    40,    16,    26,    25,    39,
      32,   100,    29,   893,    74,    85,    75,    55,    80,    58,
      83,    99,    56,    95,   970,   969,  1004,   973,   980,   106,
     107,   112,     7,  1515,  1516,  1517,  1599,  1550,  1551,  1544,
    1560,  1570,  1559,  1563,  1571,  1558,  1577,     0,   109,   111,
     113,   116,   110,   105,   108,   115,   120,   114,   119,   117,
     118,   121,   122,   123,  1781,  1173,  1779,  1780,  1778,  1532,
       0,  1599,  1534,  1533,     0,  1734,  1735,  1736,  1737,  1738,
    1739,  1786,  1787,  1788,  1789,  1790,  1792,  1791,  1803,  1804,
    1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,
    1815,  1816,  1817,  1818,  1819,  1820,  1821,  1822,  1823,  1824,
    1761,  1825,  1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,
    1834,  1802,  1835,  1836,  1837,  1838,  1839,  1840,  1841,  1842,
    1843,  1844,  1845,  1846,  1795,  1847,  1848,  1849,  1850,  1851,
    1852,  1853,  1854,  1855,  1856,  1857,  1858,  1859,  1860,  1861,
    1862,  1863,  1864,  1865,  1867,  1866,  1868,  1869,  1870,  1871,
    1872,  1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,
    1796,  1882,  1883,  1884,  1885,  1886,  1887,  1888,  1889,  1890,
    1891,  1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,
    1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,
    1797,  1911,  1912,  1798,  1913,  1914,  1915,  1916,  1917,  1918,
    1919,  1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,
    1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,  1938,
    1941,  1939,  1940,  1942,  1943,  1944,  1945,  1946,  1947,  1948,
    1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,
    1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,
    1969,  1799,  1970,  1971,  1972,  1973,  1974,  1975,  1976,  1977,
    1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
    1989,  1988,  1990,  1991,  1992,  1993,  1994,  1490,  1995,  1996,
    1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,  2006,
    2007,  2008,  2009,  1762,  2010,  2011,  2012,  2013,  2014,  2015,
    2016,  2017,  2018,  2019,  1800,  2020,  2021,  2165,  1458,  1509,
    1508,  1483,  1504,  1759,  1707,  1708,  1478,  1760,  1757,  1793,
    1794,  1801,  1758,  1459,  2161,  1756,  1646,     0,     0,  1612,
    1611,  1615,  1614,  1616,  1609,  1610,  1424,  1510,  1627,  1626,
    1423,  1629,  1740,  1741,  1742,  1743,  1745,  1744,  1746,  2083,
    2084,  2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,
    2094,  1771,  2095,  2096,  2097,  2098,  2099,  2100,  2101,  2104,
    2102,  2103,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,
    2113,  2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,
    1772,  1773,  2123,  2124,  2125,  2126,  2127,  2128,  2129,  2130,
    2131,  2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,
    2141,  2142,  2143,  2144,  2145,  1775,  2146,  2147,  1774,  2148,
    2149,  2150,  2151,  2152,  1785,  1770,  1573,  1747,  1782,  1769,
    1776,  1777,  1784,  1783,  1583,  1579,  1587,  1582,     0,     0,
       0,     0,  1599,   823,   822,   808,     0,     0,     0,     0,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,   832,   286,
     285,  1480,  1479,  1419,   884,  1415,  1416,   434,     0,   811,
     306,     0,     0,     0,     0,     0,     0,     0,   512,     0,
       0,     0,     0,     0,     0,     0,   167,     0,   317,   316,
       0,     0,   423,     0,   645,     0,     0,   434,     0,     0,
       0,  1489,  1488,  1484,  1494,     0,  1487,  1756,     0,   923,
    1939,  1624,  1625,   921,  1980,   961,     0,   236,   239,   237,
     238,     0,     0,   730,   539,     0,   538,     0,     0,   536,
       0,     0,     0,     0,   540,   534,   533,     0,     0,     0,
     537,     0,   535,     0,     0,   812,     0,  1565,  1566,  1883,
     920,   907,   893,  1804,   569,   573,   564,   570,   577,   576,
     565,   562,   563,  1951,     0,     0,     0,   559,  1447,  1449,
     568,  1448,     0,   612,   618,   617,   616,     0,   613,   614,
     619,     0,   805,   839,  1428,   995,     0,     0,   561,   804,
    1995,   916,     0,     0,   734,     0,   735,     0,  1966,   816,
     227,  1754,  1972,  2050,  1995,  1755,   223,  1752,   192,  1753,
    1749,  1750,  1751,  1748,     0,     0,   613,     0,   813,   814,
    1001,   999,     0,     0,     0,     0,  1835,  1904,   215,  1962,
    1972,  2050,  1995,  2019,   176,     0,   222,  1972,  2050,  1995,
       0,   832,     0,     0,  1574,   807,   806,     0,  1073,     0,
    1069,   894,   897,     0,  1034,   978,     0,   824,     0,     6,
     892,   888,   998,   998,     0,   998,     0,   974,     0,  1542,
    1570,  1549,  1605,  1546,     0,     0,  1595,  1591,  1588,  1596,
    1597,  1590,  1578,  1162,  1163,  1164,  1161,  1165,  1160,     0,
    1521,  1562,  1527,     0,  1537,  1536,  1535,  2168,  2169,  1648,
    1482,  1501,     0,     0,     0,     0,     0,  1635,  1628,  1630,
    1632,  1585,  1584,  1580,     0,     0,  1698,     0,     0,  1699,
    1700,     0,  1695,  1697,     0,  1605,     0,     0,  1759,  1767,
    1429,  1760,  1757,  1765,  1756,     0,   547,   126,     0,     0,
     547,     0,     0,     0,     0,  1827,  1871,  1328,  1338,  1336,
    1337,  1330,  1331,  1332,  1335,  1333,  1334,     0,   722,  1329,
       0,   126,     0,     0,   407,     0,     0,     0,     0,     0,
     126,     0,     0,     0,     0,     0,   828,   831,   809,     0,
       0,  1399,  1420,     0,     0,   880,     0,     0,   594,   603,
     595,   600,     0,   597,     0,     0,   605,     0,   596,   598,
     599,   604,     0,     0,   601,   602,     0,     0,   820,   309,
       0,     0,     0,     0,     0,   841,   871,   321,   320,   126,
     319,   318,     0,     0,     0,   665,   126,     0,   169,   437,
       0,     0,   480,   126,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1493,  1499,     0,  1491,  1649,   924,   922,
    1608,     0,   936,  1882,     0,   475,     0,     0,  1882,   862,
    1882,     0,  1882,   162,  1421,     0,     0,     0,     0,     0,
    1882,   154,  1882,     0,  1882,   438,     0,  1882,     0,  1882,
     156,     0,  1882,   282,   545,     0,     0,  2173,  2177,     0,
    2175,  2170,  1564,  1623,  1622,  1514,     0,  1621,     0,   566,
     575,   574,   572,   571,   567,  1450,     0,   557,   558,  1635,
    1638,   555,     0,   611,     0,     0,     0,     0,   939,  1417,
       0,   819,     0,     0,     0,     0,   737,   737,   737,   815,
     226,   224,     0,     0,     0,     0,     0,   821,     0,     0,
       0,  2022,  2023,  1127,  1392,     0,  1761,  2024,  2025,  1269,
    1278,  1270,  1272,  1279,  2026,  2027,  1859,  2028,  2029,  1436,
    2030,  2031,  1117,  2033,  2034,  2035,  1274,  1276,  2036,  2037,
       0,  1437,  2039,  2040,  1931,  2042,  2043,  2045,  2046,  1280,
    2048,  2049,  2050,  2051,  2052,  2053,  1435,     0,  1281,  2054,
    2056,  2057,  2058,  2059,  2060,  2061,  1339,  1441,  1442,  1401,
       0,     0,  1414,     0,  1259,     0,  1109,  1110,  1132,  1133,
    1111,  1138,  1139,  1151,  1112,     0,  1413,  1174,  1258,  1263,
       0,  1257,  1253,   986,  1411,  1393,     0,  1254,  1472,  1471,
    1473,  1474,  1470,  1431,  1438,  1477,  2161,     0,     0,     0,
       0,     0,  1688,   231,     0,   232,  1972,   177,   214,   187,
     213,   188,   217,   216,     0,  1825,   178,     0,   185,     0,
       0,     0,     0,     0,     0,     0,   218,   810,   282,     0,
       0,  1071,     0,  1074,     0,  1070,   896,   893,  1406,  1405,
    1407,     0,   972,   971,     5,   899,   997,     0,     0,     0,
       0,     0,     0,     0,  1027,  1016,  1024,  1028,  1035,  1605,
    1606,     0,  1600,     0,  1599,  1599,  1593,  1592,  1589,     0,
       0,     0,     0,     0,     0,  1464,  1463,  1518,  1520,  1467,
       0,     0,  1503,     0,  1507,  1505,  1635,  1643,  1635,  1644,
    1645,  1636,  1468,  1469,  1641,     0,  1631,  1639,  1642,  1586,
    1599,  1706,     0,  1701,  1704,     0,  1696,     0,  1430,     0,
       0,     0,     0,     0,   548,     0,     0,     0,   125,   860,
     229,   858,     0,     0,     0,   865,     0,     0,     0,     0,
     692,     0,     0,     0,     0,     0,     0,   693,   691,   694,
     701,   708,   711,     0,   636,   160,   161,     0,     0,     0,
       0,     0,     0,   241,   272,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,   405,   760,   760,     0,     0,
     760,     0,     0,     0,   760,     0,   240,   242,   271,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     153,     0,     0,  1528,     0,   826,   827,     0,   830,     0,
    1396,  1395,  1426,  1400,   882,   883,  1427,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   292,   293,   126,   291,     0,     0,   477,     0,  1120,
    1149,  1149,  1149,  1116,  1116,  1129,  1118,  1156,     0,  1149,
    1116,  1121,     0,  1119,  1159,  1159,  1144,     0,  1092,  1102,
    1104,  1105,  1130,  1131,  1106,  1136,  1137,  1103,  1173,  1766,
    1116,  1768,  1764,  1763,     0,     0,   870,     0,     0,   513,
       0,     0,   478,     0,     0,     0,   165,     0,     0,     0,
       0,     0,     0,   443,   442,     0,     0,   479,     0,   407,
       0,   400,   363,     0,     0,  1833,     0,     0,     0,  1497,
    1492,  1495,     0,  1485,  1499,   962,   966,   963,     0,   964,
       0,  1082,     0,   282,   729,     0,     0,     0,   282,     0,
       0,  1882,     0,  1882,     0,     0,     0,   282,     0,     0,
       0,     0,   544,   542,   541,   543,     0,     0,     0,     0,
     282,     0,   280,   281,     0,   532,  2171,     0,     0,  2174,
    1567,     0,  1349,     0,   917,  1619,  1620,   322,     0,     0,
     900,   906,   902,   904,   903,   905,   901,   556,   553,   554,
       0,  1637,  2153,  2159,     0,  1650,  1651,     0,  1846,  1876,
    1898,  1967,  1970,     0,  1990,     0,   620,   640,   615,     0,
       0,   933,   926,     0,     0,   949,   560,   910,  1353,     0,
       0,     0,   736,   733,   732,   731,   225,   193,     0,     0,
     642,  1966,   818,     0,     0,  1261,  1262,  1148,  1135,  1391,
       0,     0,  1143,  1142,     0,     0,     0,     0,  1125,  1124,
    1123,  1260,  1352,     0,  1122,     0,     0,     0,     0,  1149,
    1149,  1147,  1193,     0,  1126,     0,     0,  1371,     0,  1377,
       0,     0,     0,  1155,     0,  1153,     0,     0,  1229,     0,
       0,     0,     0,     0,     0,  1255,  1177,  1178,  1762,  1259,
    1349,     0,  1432,     0,     0,  1141,     0,  1173,     0,     0,
       0,     0,  1404,  1347,     0,     0,  1206,  1345,     0,  1208,
       0,     0,     0,  1339,  1338,  1336,  1337,  1330,  1331,  1332,
    1335,  1333,  1334,  1343,  1190,     0,     0,  1189,  1635,     0,
    1037,   985,  1394,     0,  1475,     0,  2160,  2162,  1685,  1684,
    1683,  1682,  1658,     0,  1654,  1655,     0,  1686,  1687,   233,
     234,   230,     0,   190,   189,     0,   211,   212,   184,     0,
     207,   208,  1318,  1317,   191,   183,   181,   204,   206,   205,
     203,   179,   194,   200,   201,   202,   182,   180,   221,   219,
       0,   551,  1599,     0,  1075,     0,  1037,   951,   953,   954,
       0,  1401,   885,  1409,     0,     0,   889,   978,   983,   977,
     982,  1005,  1006,   659,   981,     0,  1033,  1033,  1018,  1012,
    1017,  1013,  1019,  1026,   976,  1015,   975,     0,  1029,     0,
    1607,  1545,  1605,  1092,  1599,  1538,  1599,  1594,  1524,  1167,
    1168,  1169,  1170,  1172,  1171,  1525,  1522,  1166,  1523,  1466,
    1465,     0,     0,     0,  1500,     0,  1481,  1506,     0,     0,
    1092,  2156,  1702,  2156,  1092,     0,     0,     0,     0,     0,
       0,     0,   549,     0,     0,     0,   228,   857,     0,     0,
       0,     0,     0,   868,   357,     0,   279,     0,     0,     0,
       0,     0,     0,   699,     0,     0,     0,     0,   700,   697,
     698,  1967,   710,   709,   707,   676,   678,   677,     0,   668,
       0,   669,     0,     0,   675,   684,   682,     0,     0,     0,
       0,   277,     0,   276,     0,     0,     0,     0,     0,   718,
     723,     0,     0,   135,   137,     0,     0,   133,   139,   136,
     138,   134,   140,   132,     0,     0,   131,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,   409,   420,     0,
       0,     0,     0,   126,   126,   406,   759,   252,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   269,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,   199,   825,   829,  1397,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   308,   290,   289,     0,   295,     0,   499,
    1763,   476,     0,  1092,     0,     0,     0,  1086,  1162,  1161,
    1160,     0,  1107,  1116,  1113,     0,     0,   856,   856,   856,
     856,   856,   840,   842,   332,   158,     0,     0,     0,   488,
     491,     0,   124,   169,   322,     0,   168,   170,   172,   173,
     174,   171,   175,   436,     0,     0,     0,     0,     0,   448,
     447,   449,     0,   444,     0,     0,   149,   404,   396,     0,
     324,   387,     0,     0,   421,     0,     0,     0,     0,   781,
       0,  1498,     0,     0,     0,     0,   965,     0,  1047,   935,
    1039,  1049,  1040,  1042,  1076,  1419,     0,     0,   933,     0,
     714,     0,   863,     0,   712,   163,  1422,     0,     0,     0,
       0,     0,     0,   529,   155,     0,   282,   439,     0,   282,
     157,     0,   431,   282,   546,  2172,  2178,  2176,   919,     0,
    1617,  1618,     0,   961,   552,     0,     0,  2158,  1451,     0,
    1452,     0,     0,   624,   623,   634,   625,   626,   622,   621,
     627,     0,     0,   642,   928,     0,   930,  1401,     0,   925,
       0,   946,     0,   944,     0,  1418,   948,   937,   915,     0,
     909,   912,   914,   913,   911,     0,     0,   613,     0,     0,
     282,   817,     0,     0,     0,  1355,     0,     0,  1390,  1387,
       0,     0,     0,     0,     0,  1362,  1363,  1364,  1361,  1365,
    1360,     0,     0,  1366,  1359,     0,     0,     0,     0,     0,
    1146,  1145,     0,     0,     0,     0,     0,     0,  1232,  1263,
       0,     0,  1323,     0,  1349,  1376,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1349,  1382,     0,     0,
       0,  1316,     0,  1313,     0,     0,     0,  1402,  1401,     0,
       0,     0,     0,  1433,  1175,  1191,  1412,     0,  1403,     0,
       0,  1198,     0,  1383,  1225,     0,  1230,  1213,     0,  1207,
       0,  1211,  1215,  1194,  1404,  1348,     0,  1346,     0,     0,
    1192,     0,  1187,  1185,  1186,  1179,  1180,  1181,  1182,  1183,
    1184,  1188,  1327,  1325,  1326,     0,     0,     0,  1210,  1877,
    1904,     0,   996,   996,   984,   994,  1410,     0,  1078,     0,
       0,     0,  1264,     0,  2164,  2163,     0,     0,     0,     0,
       0,  1173,     0,   220,  1092,  1072,   958,     0,     0,  1082,
       0,   957,   887,   886,  1408,     0,     0,   657,   658,     0,
     662,  1025,     0,   949,   949,     0,     0,     0,  1543,  1601,
    1548,  1569,  1539,  1572,  1519,  1561,     0,  1502,  1633,  1640,
    1692,     0,  2157,     0,     0,   497,   496,     0,     0,     0,
     768,   739,   550,   769,   740,     0,   859,     0,     0,     0,
       0,     0,   282,   866,   278,   867,   762,   770,     0,   695,
     696,   771,   741,     0,   763,   679,  1116,   667,     0,     0,
     674,     0,   673,  1116,  1116,   742,   159,   274,   750,   275,
     273,     0,  1425,     0,     0,     0,     0,   145,     0,     0,
       0,     0,   128,   127,   146,   144,     0,   143,     0,   776,
     746,   748,   764,   408,   419,     0,   412,   413,   410,   414,
     415,     0,     0,     0,   244,     0,     0,   255,   268,   263,
     264,   262,   282,   282,     0,     0,     0,     0,   265,   260,
     261,   257,   270,   747,     0,   765,   256,   254,     0,   243,
     778,   754,     0,     0,     0,     0,     0,     0,     0,   872,
       0,     0,     0,   777,   766,   753,   749,     0,     0,   197,
     196,   198,     0,     0,     0,     0,     0,     0,     0,     0,
     607,   584,   606,     0,     0,     0,     0,     0,     0,     0,
     578,   311,   288,   498,     0,     0,     0,     0,  1087,     0,
       0,  1092,     0,     0,  1100,  1093,  1101,     0,     0,     0,
    1114,     0,   856,   855,     0,     0,     0,     0,     0,   843,
     864,     0,   518,   487,     0,     0,   363,   164,     0,     0,
     435,   486,   484,   483,   485,     0,     0,     0,     0,  1083,
       0,     0,     0,     0,     0,     0,   323,   325,   327,   328,
     329,     0,   402,   403,     0,     0,   391,     0,   365,   366,
       0,     0,     0,     0,   648,     0,     0,     0,   706,   704,
     687,     0,  1496,  1490,   967,   968,     0,   978,     0,  1049,
       0,  1048,  1060,     0,     0,  1066,  1064,     0,  1066,     0,
    1066,     0,  1041,     0,  1043,  1060,  1420,     0,     0,  1079,
     934,   282,     0,   282,     0,   282,     0,   282,     0,   282,
       0,   802,     0,   472,   282,   531,  1350,     0,     0,  1634,
    2154,  1659,  1660,     0,  1652,  1653,     0,     0,   633,   628,
     630,     0,   637,     0,     0,   931,   932,   947,   940,   942,
     941,     0,     0,   938,  1354,   530,     0,   282,     0,   638,
    1000,  1357,  1358,     0,     0,     0,     0,  1386,     0,     0,
    1293,  1271,  1273,  1115,  1283,     0,  1128,  1294,  1295,  1275,
    1277,     0,  1340,     0,     0,  1284,  1234,     0,     0,     0,
       0,  1339,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1246,  1245,  1285,  1322,     0,     0,  1374,  1375,  1286,
    1157,  1158,  1159,  1159,     0,     0,  1381,     0,     0,     0,
    1291,  1296,     0,     0,  1301,     0,  1321,     0,     0,  1256,
    1350,  1150,  1151,     0,     0,     0,     0,     0,     0,     0,
       0,  1231,  1214,  1209,     0,  1212,  1216,     0,     0,     0,
       0,  1200,  1226,  1196,     0,     0,  1202,     0,  1227,   996,
     996,   996,   996,   993,     0,     0,  1036,     0,  1021,     0,
       0,  1268,  1265,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1675,  1676,  1678,  1679,  1680,  1674,  1677,  1681,  1663,  1664,
       0,  1656,  1657,   186,     0,   209,   195,  1692,     0,     0,
     952,   933,   955,   898,  1007,     0,  1341,   662,   660,   661,
    1009,  1032,  1031,  1030,  1010,  1014,  1011,     0,  1603,  1529,
    1691,  1694,  1705,  1703,  1541,   767,   738,   761,   856,     0,
     356,     0,     0,     0,   869,   689,     0,  1116,   670,   671,
     672,     0,     0,     0,     0,     0,     0,     0,   720,     0,
     721,   719,   141,   129,   148,   147,   130,   142,   411,   416,
     418,   417,   332,     0,     0,     0,   245,   253,   250,   266,
     258,   267,   259,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   772,   743,  1398,   579,     0,   580,
     587,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     589,   312,   126,     0,   296,   300,   871,   871,     0,   301,
     871,   297,   871,   294,   500,     0,  1931,  1331,   501,   492,
     494,   495,   493,   467,     0,     0,     0,  1090,     0,     0,
       0,     0,     0,     0,  1092,  1173,     0,     0,   851,  1460,
    1461,   850,  1462,   847,   846,   854,   853,   845,   844,   849,
     848,     0,     0,     0,   343,     0,     0,   337,     0,     0,
     706,   331,   334,   335,     0,   489,   490,     0,   322,     0,
     451,   445,     0,   502,   481,     0,  1085,   920,   397,   324,
     349,   383,     0,   399,     0,   385,   384,   386,     0,   393,
     362,     0,   838,   428,   425,     0,   648,     0,     0,   702,
     680,   703,     0,   683,     0,   688,   664,     0,  1512,   960,
    1513,  1051,  1058,     0,  1038,     0,  1065,  1061,     0,  1062,
       0,     0,  1063,     0,     0,  1058,     0,     0,     0,   715,
       0,   713,     0,   525,     0,   527,     0,   716,   282,   282,
     432,     0,   400,   966,     0,     0,   635,   631,     0,     0,
     608,   639,   927,   929,   945,   943,     0,   609,   641,  1356,
    1134,     0,  1389,  1385,     0,  1351,     0,  1369,  1368,  1233,
    1370,     0,  1251,     0,     0,  1244,  1243,  1241,  1242,  1235,
    1236,  1237,  1238,  1239,  1240,  1379,  1378,  1372,  1373,  1154,
    1152,     0,  1288,  1289,  1290,  1380,  1297,     0,  1315,  1314,
       0,     0,     0,  1303,     0,     0,  1311,  1324,  1140,  1173,
    1176,     0,     0,  1199,  1384,  1217,     0,     0,     0,  1195,
       0,     0,     0,     0,  1204,  1340,     0,     0,     0,     0,
       0,     0,   988,   987,  1077,     0,  1023,  1266,  1267,  1476,
       0,     0,     0,  1690,     0,   959,   950,     0,  1008,  1547,
       0,  1602,     0,   358,     0,     0,   706,   690,     0,   685,
       0,     0,     0,     0,     0,   519,   505,     0,     0,   520,
     521,     0,     0,     0,   330,     0,     0,     0,     0,   284,
     751,     0,     0,     0,     0,     0,   780,   758,   779,   756,
     755,   757,   752,     0,     0,     0,     0,   583,   593,   591,
     590,   592,   582,   295,     0,     0,     0,     0,     0,     0,
       0,   469,     0,     0,   474,   463,   465,     0,     0,     0,
    1088,  1094,  1095,  1096,  1097,  1098,  1099,  1091,  1108,   461,
     852,     0,     0,   341,   345,   346,   344,   336,   706,   363,
     395,     0,     0,     0,   453,     0,     0,   482,     0,  1084,
     918,     0,   347,     0,   387,   326,   401,   403,     0,     0,
     398,   364,     0,     0,     0,   833,     0,   430,   426,     0,
       0,   647,     0,     0,   706,   705,   797,   798,   795,   796,
       0,     0,  1486,  1050,     0,     0,  1052,     0,     0,  1054,
    1056,     0,     0,     0,     0,     0,  1423,  1265,  1081,  1080,
     282,   282,   282,   282,   803,   473,     0,     0,     0,  1661,
    1662,     0,   629,     0,  1388,  1282,  1292,  1367,     0,     0,
    1252,     0,     0,  1287,  2055,     0,     0,  1319,  1320,  1302,
       0,  1917,  1306,     0,     0,  1434,  1223,  1221,  1218,     0,
    1219,     0,     0,  1201,  1197,     0,  1203,  1228,   992,   991,
     990,   989,     0,     0,   979,  1665,     0,  1453,  1457,  1454,
    1666,  1173,   956,     0,  1604,   861,     0,   706,   395,   686,
     774,   744,     0,     0,   511,     0,     0,     0,     0,   775,
     745,   773,   246,   247,   248,   249,     0,   251,     0,     0,
       0,   877,     0,     0,   585,   586,   581,   287,   310,   298,
     303,     0,   304,   299,   302,   471,   470,   468,   464,   466,
    1089,     0,   727,     0,   467,     0,     0,   333,   395,   369,
       0,   338,     0,   838,   324,   452,     0,     0,   446,   503,
     387,     0,     0,   348,     0,   391,     0,   388,     0,   392,
       0,     0,   835,   427,     0,   422,     0,     0,     0,     0,
     649,   656,   656,   681,   663,     0,  1511,     0,  1059,  1068,
       0,  1055,  1053,  1044,     0,  1046,   728,   526,   528,   717,
       0,   632,   282,  1247,     0,     0,     0,     0,  1298,     0,
    1299,  1304,  1307,     0,  1305,  1220,  1224,  1222,  1205,  1020,
    1022,  1456,  1455,   210,  1342,     0,   395,   359,     0,     0,
     517,   506,     0,     0,   522,   283,     0,     0,     0,     0,
       0,   588,   305,   727,     0,   725,   462,     0,   340,   339,
       0,   374,     0,   515,   834,   454,   455,   450,     0,   391,
     353,   351,   355,   352,   350,   354,     0,   393,   389,   390,
     836,   837,   429,   879,     0,     0,   706,     0,     0,   654,
     659,   659,  1078,  1057,     0,  1045,   610,  1248,     0,  1249,
       0,     0,  1309,  1308,   363,   360,     0,   509,   516,     0,
     507,     0,     0,   873,     0,   874,   875,   878,   724,   726,
       0,   367,   368,     0,   342,   370,   371,     0,     0,     0,
       0,   393,   382,   314,   706,   656,   393,   650,   655,   662,
     662,     0,  1067,  1250,  1312,  1300,  1310,   369,     0,     0,
     524,   523,     0,     0,     0,     0,     0,   372,     0,   373,
     394,   514,     0,   458,   315,   393,   659,  1078,   652,   651,
     801,   374,     0,   517,   876,     0,   379,     0,   378,     0,
     375,   376,   504,     0,   456,     0,   459,   460,  1078,   662,
     643,   800,   799,     0,   467,   510,   508,     0,   377,   380,
     381,   440,     0,     0,   644,   653,   783,   794,   782,   784,
     792,   789,   791,   790,   788,   361,     0,   457,     0,     0,
     793,   787,   978,   969,     0,     0,   785,   794,   458,   786,
       0,   441
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    72,   240,   241,   242,  1489,  2091,   243,
     244,   245,   246,   247,   248,   249,   250,   251,  1518,   252,
     253,  1157,  1646,  2206,   254,  2016,   965,  1921,  2143,  1922,
    1923,  1908,  1379,  1381,   255,  1490,  1510,   257,  1374,  1901,
     258,   259,   260,  1546,  1547,  1523,  1548,  1495,  1715,  3557,
     261,   262,  2166,  1593,  2672,  3083,   801,  1590,  3072,  3073,
     263,  1643,  2725,  2726,  2727,  2728,  2700,  3131,  3132,  3133,
    2729,  3422,  3603,  2730,  2024,  2233,  2737,  2738,  3691,  3754,
    3755,  3756,  3810,  3424,  2736,  3159,  3430,  3591,   264,  2722,
    1660,  2231,  2731,  2732,   265,   266,  1535,  2105,  2595,   267,
     827,  3163,  3437,  3615,   268,   785,   269,  1648,   270,   271,
    1655,  2222,  2223,  3415,  3596,  3697,  3813,  3814,  3584,  3384,
    3385,  3386,   272,   273,   274,   275,  2063,  2198,  2199,  3088,
    1480,  1597,  2168,  2169,  3142,   276,  3335,  3336,   828,  3759,
    3740,   277,   278,  3339,  3340,   279,   280,   281,   282,   283,
     874,  1213,  1214,  1484,   284,   285,   895,   896,   286,  1137,
    2661,   287,   288,   907,  2337,   909,  1755,  2808,  2809,  3220,
    2304,  1071,   289,   290,  2313,  2340,   291,   829,  3168,  3619,
    3620,  3720,  2500,  2980,   292,   830,  1514,  2050,  2051,  2052,
    3169,  2053,  3172,  2054,  2748,  2749,  2750,  3176,   293,  1512,
    2044,   294,   295,   296,  2068,  1087,   297,  3685,   298,  1187,
     299,   927,  1773,   300,  2108,   301,   302,   303,  2751,  3838,
    3849,  3850,  3851,  3450,  3823,   304,  3840,   306,   307,   308,
     788,  1106,  1107,  1108,   309,  3435,   310,   311,  2192,  2193,
    2694,   312,   313,  2017,  2536,   314,   315,   316,  1637,   317,
     318,   319,   320,  1115,   321,   322,   323,   991,   982,  1407,
    1946,   324,  1730,   882,   325,  2330,  1254,   326,  1227,   327,
    3841,  1761,  2315,  2316,  2319,  3842,  1681,   330,  1765,  2324,
    2327,  3843,  1936,  1937,  1938,  1939,  1940,  2487,   332,  1181,
    2245,  3844,  1334,   335,   336,   337,  1880,  2464,   916,  1417,
     952,   996,   997,  1951,  1952,  1424,  1966,  1959,  1961,  3306,
    3524,  1425,  1964,  1426,  1427,  2503,   338,  2468,  2249,  2250,
    2251,  2761,  2771,  3187,  3459,  2252,   979,  2253,  2938,  2258,
    2718,  2719,  2055,  2177,  2683,  1618,  1335,  1619,  2184,  1336,
    1804,  1621,  1337,  1338,  1339,  1624,  1340,  1341,  1342,  1343,
    1788,  1845,  1344,  1345,  1823,  1020,  1722,  2377,  1347,  1348,
    3276,  3504,  3495,  2402,  2403,  1914,  3272,  1349,  2455,  1873,
    1089,  1350,  3090,  1875,  2397,  2361,  2006,  2344,  1786,  2362,
    2375,  2854,  2381,  2386,  2877,  2878,  2398,  2424,  1351,  2348,
    2349,  2838,  1790,  1352,  1111,  1112,  1835,  2420,  1410,  1411,
     984,  1353,  1354,  1355,  1756,   980,  3455,  1194,   652,  2571,
    1571,  1575,   913,  1356,  1357,  1358,  1359,  1360,  1361,  1362,
     899,   900,  2299,  3530,  2662,  3111,  1463,  1924,  1363,   630,
     795,   339,   833,   834,   835,  1173,  1174,  1670,  1673,  1452,
    1996,   631,   632,   842,  3452,   340,   341,   342,   343,  1448,
    1992,  1021,    76,    81,    77,  1022,   380,   381,  1974,   344,
     762,  1975,  1429,  1002,  2988,   346,   347,   348,   349,   350,
     877,   351,  1004,   352,  1005,   353,   354,   355,   356,  1012,
     357,  1431,  1432,  3321,  1433,   358,   359,   654,   655,  1724,
    1225,   880,   360,   361,  1038,  1039,  1040,  1240,  1740,  1241,
    1466,  1467,   362,   648,   363,   364,   365,  1745,  1746,   366,
    1894,  1895,  1896,   367,  2801,  2802,   368,  2958,  2959,  2960,
     369,  1890,   370,   371,   973,  2991,   372,   758,   373,  1052,
     633,   634,   635,  1059,   746,   938,   796,  1060,   747,   748,
     749,   637,   638,   639,   640,   641,   642,  1063,   753,  1741,
      78,  2521,  1742,  1364,  1365,  1886,  1366,   645,  1029,  1217,
    1218,  2522,  1220,    79,  1221
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3378
static const int yypact[] =
{
   -3378,   350, 12022, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, 18066, -3378,
   -3378, 42041,   611, -3378, -3378, -3378, 39312, -3378, -3378, -3378,
   -3378, -3378,   193, 46993, -3378, 57330, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, 61371, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, 42944,   206, -3378,   254, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378,   315,  3759, -3378, -3378, 49243,
   -3378,   237, -3378, -3378, -3378, -3378, -3378, -3378, 57779, 55534,
   -3378,   354,   672,    67, 11393, -3378, 40683, 48343, -3378, -3378,
   61820,   503,   108,  8415,   315, 16708, 50143, -3378,  1315, -3378,
   37010, -3378, -3378, -3378,   714, 52840, -3378, -3378, -3378, -3378,
     512, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, 61371,
    2114,   394, 37476, -3378, -3378, -3378, -3378, 61371, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, 50593, -3378,   662,
     536, 62269, 62718, 52391, -3378,   789, -3378, 61371,   871, 41592,
   -3378, 63167, -3378, -3378,   578, -3378, -3378, -3378, -3378, -3378,
     394, -3378, 42944, 35159, 53738,   834,   692, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,   610,
   18426,   982, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378,   766, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,  1327, -3378,    27,  1655,   822, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, 71698,  1042, -3378, -3378,
   -3378,  1021, -3378,   929, -3378, -3378, -3378,  1302, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378,    70, -3378, -3378, -3378, -3378,
    1484, 42492, -3378, -3378, 51043, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, 39769, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378,   113, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, 61371, 61371, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378,  1158, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,   180,  1350, -3378, -3378, 42944,  1806,
    1806,  1591, 71698, -3378, -3378, -3378, 43394, 61371, 61371, 61371,
   43394, 61371, 53738, 33312, -3378, 61371, 61371, 53738, 53738, 61371,
    1235, 61371, 61371, 61371, 53738,  1373, -3378,  1599,    73, -3378,
   -3378, -3378, -3378,   903,   407, -3378, -3378,  5290,  2114, -3378,
   -3378, 55534,  1246, 43394, 61371,  1170,  1245, 61371, -3378, 61371,
     454, 61371,   792,  1517,  1331, 61371, 61371, 61371, -3378, -3378,
    1346, 61371, -3378, 61371, -3378, 61371,   851,  1357,  1519,  1483,
     425, -3378, -3378, -3378,  1272,  1243, -3378,  1287, 51043, -3378,
   49693, -3378, -3378, -3378,   888, -3378, 53738, -3378, -3378, -3378,
   -3378, 43844, 61371,  1530, -3378, 63616, -3378, 44294, 64065, -3378,
     811,  1654, 64514, 64963, -3378, -3378, -3378, 65412,  1420, 65861,
   -3378, 66310, -3378,  1521, 66759, -3378, 13847, -3378,  1311,   984,
    1322, -3378,   766,  1112, -3378,   107,    26,   396, -3378, -3378,
      78,   116,   125,  1112,  -125, 55983, 61371,  1574, -3378, -3378,
   -3378, -3378, 51043,  1494, -3378, -3378, -3378,  1531,   -82, -3378,
   -3378, 55534, -3378, -3378, -3378, -3378, 55534,  1089, -3378, -3378,
    2114,    -7,  1729, 61371, -3378, 61371, -3378, 55534, 61371, -3378,
   -3378, -3378,  1746,  1405,  1611, -3378,  1386, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,  1581,  1596,    15,  2114,  1509, -3378,
   -3378,  1640, 21195,   -75, 51043, 38403, 54187, 70351,   998, 40683,
   67208,  1523,    73,  1624, -3378,   423, -3378,  1899,  1560,  1731,
      64,    73, 55534, 72147, -3378, -3378, -3378, 30582, 67657,  1697,
    1592, -3378,  1874, 21670, -3378,  1598,  1615,   315,  1637, -3378,
   -3378, 55534,  2048,  2048,  2029,  2048,   958,   976,   692, -3378,
   -3378, -3378,  1674, -3378,  1675,  1696, -3378,   225,  1957, -3378,
   -3378, -3378, -3378,  1799,  1809,  1811,  1813, -3378,  1814,  1487,
   -3378, -3378, -3378,  2018, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378,  2124,  2115, 40683, 40683,  1808,    54,   197, -3378, -3378,
   -3378,  1991, -3378, -3378,  1992, 61371, -3378,  1844, 61371, -3378,
   -3378, 68106, -3378, -3378,  1806,  1674,   903,  1768,  1551, -3378,
   -3378,  1666,  1767, -3378,  1839,   515,  1770,  1354,   179,  1940,
     327,  3117,  1794,   124,    19, 61371, 61371, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378,  1807, -3378, -3378,
    1774,   686,  1008,    -5,   449,  1360,  1058,   683,  1958,   399,
    1183,  1950, 61371,  1815,  2038,   444, -3378,   368, -3378, 24520,
   34253, -3378,   903, 55534, 61371, -3378, 43394,  1832, -3378, -3378,
   -3378, -3378, 43394, -3378,  2020,  2528, -3378, 61371, -3378, -3378,
   -3378, -3378,  1960, 61371, -3378, -3378,  2088, 61371, -3378,  1911,
    1629,  1863,  2229, 47444, 61371,  1926,  2275, -3378, -3378,  1938,
   -3378, -3378, 61371, 61371,  1891,   809,  1938,  2281,  2283,  2068,
     703,  1369,    80,  1938, 55534, 55534, 55534,  2136, 61371, 68555,
   43394, 61371, 41140, -3378,  1900,  1272, -3378, -3378, -3378, -3378,
   -3378,   904,  1975,  2205,  1768, -3378,  2211,  1923,  2216, -3378,
    2218,  1794,  2219,  1921, -3378, 69004, 69453,  2225,  1935, 61371,
    2231,  1921,  2232,  2119,  2235, -3378,   741,  2237,  2126,  2238,
    1921,   790,  2242,    58, -3378, 15538, 13847, -3378, 16117,  1202,
   -3378, -3378, -3378, -3378, -3378, -3378, 24520,   133,  1231, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, 61371,  1574,  1574,   118,
   -3378, -3378,   522, -3378, 54636, 61371, 55085,    17,   -16, -3378,
   61371, -3378,   984, 47444,  2326, 61371,  2240,  2240,  2240, -3378,
   -3378, -3378,  2189, 61371,  2246, 54636, 61371, -3378, 69902,  1964,
    1119,  2182,  1756, -3378, 24520,  1965,   506,   506,  1966, -3378,
   -3378,  1971,  1972, -3378,  1464,  1464,  2134,  1977,  1980, -3378,
    1823,  1983, -3378,  2200,  1914,  1984,  1985,  1987,  1543,   506,
   24520, -3378,  1998,  1464,  1999,  2000,  2004,  2217,  2010, -3378,
    2245,  2011,  2055,  2101,  2012,  2022, -3378,  1977, -3378,   255,
    2023,  2033,  2035,  2042,  2050,  2051, -3378, -3378, -3378, -3378,
   24520, 24520, -3378, 22145, -3378,  2114, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378,    56, -3378,  1978,  9157, -3378, -3378,  2161,
   24520, -3378, -3378,    -8, -3378,   903,  1902, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378,   132,  1179,  1179,   146,
   49243, 49243, -3378, -3378,   708,  2049,   233, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, 40226,  2418, -3378,  1649,   368,   191,
    2390, 35612, 36078,  1574,  1574,  2285, -3378, -3378,   105,  2298,
   55534, -3378, 61371, -3378, 31933, -3378, -3378,   766, -3378, 10952,
   -3378,   880, -3378, -3378, -3378,  2072, -3378,   610,   610, 24520,
     610,   624, 22620, 24520,  2358,   785,  2359, -3378, -3378,  1674,
    2085,  1088, -3378, 51493, 71249, 71249,  2324, -3378, -3378,    77,
      39,  2203,  2295,   891,  1380, -3378, -3378, -3378,  2082, -3378,
    2414, 49243,  2157, 40683, -3378, -3378,  2534, -3378,  2534, -3378,
   -3378, -3378, -3378, -3378, -3378,  2562, -3378,  2093, -3378, -3378,
   71698,  2102, 61371, -3378,  2103,  2106, -3378, 72147,   903, 34706,
     837,  2193,  2204, 42944,  2118,  2207,  2209, 70351, -3378, -3378,
   -3378, -3378,   749,  1071,   509, -3378,  2212,  2300,  1487,  2259,
   -3378,  2226,  2228,  2334,  1487,   685, 70800, -3378, -3378, -3378,
   -3378, -3378,  3180, 19794, -3378, -3378, -3378,  2230,  2214,  2233,
    2236,  1891,   -46,  2150, -3378,  2224,  2234, 45194, 33782,  6211,
   -3378,  2250,  2252,  2260,  2287,  2047,   103,  2535,  2357,   -18,
    1411,   115, 55534,  2445,    79,   566,  2185, -3378, -3378,  2278,
    2279, 61371, 61371, 61371, 61371, 53738,  2280,  2327,  2286,  6211,
   -3378,  2290,  1095, -3378,  1091, -3378, -3378,    73, -3378,  3904,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378,  1768, 47444,  1794,
    1487, 61371, 61371,  2208,   654,   804,  2387, 61371,  2451,  2395,
      42, -3378, -3378,  1938, -3378, 34706,  1891, -3378,  2220, -3378,
    2276,  2276,  2276,  2223,  2223,  2239, -3378, -3378,  1543,  2276,
    2223, -3378, 48794, -3378,   919,  1003, -3378,  2618,    86, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,   222, -3378,
    1399, -3378, -3378, -3378,  2633,   731, -3378, 47444,  6211,  2559,
    2302, 42944, -3378,  2297,  6211, 61371,   756, 61371,  2465, 61371,
   61371, 61371, 61371, -3378, -3378,   134,     5, -3378,  6211, -3378,
    2636,   -68,  2255, 40683,  2540, 61371,  2436,  1794,  2649, -3378,
   -3378,  2264,  -125, -3378,  1900, -3378,  1286, -3378,  2385, -3378,
   27830,  2319, 43394,   122, -3378, 47444, 61371, 43394,   122, 61371,
   61371,  2561,  2335,  2564,  2337, 33782, 45194,   106, 61371, 61371,
   55534, 61371, -3378, -3378, -3378, -3378, 61371, 55534, 61371,  2568,
     122, 61371, -3378, -3378, 61371, -3378, -3378, 16028,  1404, -3378,
   -3378, 13847, 10952,  1166, -3378,  1574,  1158,   817, 61371, 51043,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378,  1574, -3378, -3378,
    2733,  2270, -3378,   132,  -125,  2271, -3378,  2293, 61371, 43394,
   61371, 61371, 55534, 55534, 61371,  2366,  2049,   746, -3378,  2343,
   31484,  2421, -3378,   634, 55534,  2476, -3378, -3378, -3378,  1257,
     114,   489, -3378, -3378, -3378, -3378, -3378, -3378, 52840,  2566,
      18, 61371, -3378, 24520, 23095, -3378, -3378, -3378,  2291, 10952,
    2345, 24520, -3378, -3378, 24520,  -125,  -125, 24520, -3378, -3378,
   -3378, -3378,   626,  -125, -3378, 24520, 24520,  -125,  -125,  2276,
    2276, -3378,  4103, 24520, -3378, 33782, 24520, 25945, 19318, 24520,
    2380,  2381,  -125, -3378,  -125, -3378, 24520, 20720, -3378, 24520,
    2505, 24520,   191,  2507, 24520,   903,  2708,  2708,   692,    12,
    4805,  2303, -3378,  2417,  -125, -3378,  -125,   606, 47444, 24520,
   42944,  2389,   111, 24520,  2305,  1275, -3378, 24520,   805, -3378,
    2307, 24520,  2392,   110, 24520, 24520, 24520, 24520, 24520, 24520,
   24520, 24520, 24520, -3378, 26420,   152,   -85,   844, 45643, 21195,
    2589, -3378,  2032, 18842, -3378, 51043, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378,  -125,  2308, -3378,  2329, -3378, -3378, -3378,
   -3378, -3378,  2418, -3378, -3378,  2398, -3378, -3378, -3378,  2152,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378,  2316, -3378, -3378, -3378, -3378, -3378,  2316, -3378, -3378,
    1574, -3378, 71698,  2313, -3378, 61371,    16, -3378, -3378, -3378,
    2339, -3378, 53289, -3378, 21670, 61371, -3378, -3378,  2570, -3378,
   -3378,  2321, -3378,  7861,  2570,  2512,  2521,  2521, -3378,   -62,
   10952,  2567, 10952, -3378, -3378, -3378, -3378,   964, -3378,  1107,
   -3378, -3378,  1674,  2341, 17160, -3378, 17613, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378,  1487,  2340,  2787, -3378, 40683, -3378, -3378, 51043,  2348,
    2341, 13847, -3378, 13847,  2341,  2344,  1266,  2427,  2429,  2472,
   61371, 61371, -3378, 42944, 61371, 61371, -3378,  2698,  2350, 61371,
    2587,  2590,  2360, -3378, -3378, 61371, -3378,  2546, 24520,  2547,
   61371, 61371,  2550, -3378,   826, 61371, 61371,  2544, -3378, -3378,
   -3378, 61371, -3378, -3378, -3378,  2539, -3378, -3378, 48794, -3378,
    1270, -3378, 47894, 44744, -3378, -3378,   330, 61371, 61371, 61371,
   61371, -3378, 61371, -3378,   946, 61371, 61371,  2361,  2370,  2365,
   -3378, 61371,  2608, -3378, -3378,  2549,    65, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,  1053, 61371, -3378,  -125,  2554, 61371,
    2453, -3378, 61371, 61371, 61371, 61371,  1487, -3378,  2764,  1487,
    1487,   925,  2766,  1938,  1938, -3378, -3378, -3378, 61371, 61371,
   61371, 61371, 56432, 61371, 61371,   586,   936, 61371, 56881, -3378,
   55534, 61371, 61371, 61371,   165,  1184, 61371, 61371,   205,   -37,
    2536,  2537,  2541, 61371, 61371, 61371, -3378, 61371,  2480,  2481,
      97,  2552, -3378, -3378, -3378, -3378, 24520,  2642,  2793,  2645,
    2647,  2473,  2474, 45194,  1046, 61371, 61371, 61371, 61371, 61371,
   61371,  2650,  1046, -3378, -3378, -3378,  1629, -3378,  1297, -3378,
    2425, -3378, 24520,    94, 47444,  2415, 29648, -3378,  2497, -3378,
    2498,  -125, -3378,  1545, -3378,   134,  2648,  2430,  2430,  2430,
    2430,  2430,   731, -3378, -3378, -3378,  2707, 61371,  1309, -3378,
    2438, 55534, -3378, -3378,  2008, 52840, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,  1232,  1891,  1891,  1891,  1891, -3378,
   -3378, -3378,  2604,  2602,  2433, 61371, -3378,  2047,  2728, 55534,
   51942,  1341, 61371,  2827,  2709,  2114,  2619, 55534,  2988, -3378,
   41140, -3378,  2454,  2716,  2717,  2735, -3378, 27370, 58228,  2447,
    1728, -3378, 58228, 58677, -3378,   903,  2457, 23570,  2421,  1768,
   -3378,  2847, -3378,  1794, -3378,  1921, -3378, 61371, 61371, 61371,
   61371,  2459,  2462, -3378,  1921,  2638,   122, -3378,  2640,   122,
    1921,  2114, -3378,    58, -3378, -3378, -3378, -3378, -3378, 24520,
   -3378, -3378,  2556, -3378, -3378, 51043,  1287, -3378, -3378,  1287,
   -3378,  1287,  2933,  1921,  2463, -3378,  1921,  1921,  2049,  2049,
    1921, 59126,  2867,  2740, -3378,  1312, -3378, -3378, 21195, -3378,
      96, -3378,   203,   912,  2680, -3378, -3378, -3378, -3378, 47444,
   -3378, -3378, -3378, -3378, -3378, 61371,  2652,  2464, 59126,  2848,
     122, -3378,  1319,  1066,  1109, -3378, 24520, 24520,   123, -3378,
    9513,  1335,  2475,  2477,  1343, -3378, -3378, -3378, -3378, -3378,
   -3378,  2478,  2755, -3378, -3378,  2482,  1348,  1396,  2485,  2486,
   -3378, -3378,  4143,  2488,  9749,  2489, 25945,  1428, -3378, -3378,
   25945,  2490, -3378,  1403,  9001,  2487,  2492,  2516,  2529,  2500,
    2502, 10092, 24045, 24520, 24045, 24045, 10374,  2487,  2503,  1407,
   42944, 10635,  1424, -3378, 24520, 42944,  4494, -3378, -3378, 24520,
   61371,  2504,  2506, -3378, -3378,  4103, -3378,  2532, -3378, 25945,
   25945,  3552, 22145, -3378, -3378,  2777, -3378, -3378,  1851, -3378,
    2508, -3378, -3378,  6177,   145, 24520,  2305, 24520,  2593, 33782,
    3289, 24520,   269,  2120,  2120,   172,   172,    92,    92,    92,
    1382,   844, -3378, -3378, -3378,  2514,  2010, 24520, -3378,  1548,
    1657, 55534,  4688,  5919, -3378, -3378, -3378, 27830,  2557, 24520,
   24520,  2517, -3378,  1447, -3378, -3378,   245,  2933,  -125,    73,
    -125,   606, 36544, -3378,  2341, -3378, -3378,  1458, 31933,  2319,
   21670,   903, -3378, -3378, -3378,  1460, 24520, -3378, -3378,  2664,
    1333, -3378, 61371,  2476,  2476, 24520, 24520, 22620, -3378, -3378,
    2518, -3378, -3378, -3378, -3378, -3378,  2522, -3378, -3378, -3378,
    2975,  2530,  2525,  2533,  2526, -3378, -3378, 61371, 61371, 61371,
   -3378, -3378, -3378, -3378, -3378,  2761, -3378, 24520,   128,  2538,
    2542, 61371,   122, -3378, 10952, -3378, -3378, -3378,  2786, -3378,
   -3378, -3378, -3378,  2727, -3378, -3378,  1399, -3378, 44744, 47894,
   -3378, 47894, -3378,  1399,  1038, -3378,  1921, -3378, -3378, -3378,
   -3378,  1110, -3378,   623, 47444,  2710, 46094,  1921,  1112,  1232,
   61371, 61371, -3378, -3378,  1921, -3378,  1232,  1921,  1232, -3378,
   -3378, -3378, -3378, -3378, -3378,  1487, -3378, -3378, -3378, -3378,
   -3378, 61371,  1487,  1487, -3378, 47444,   235, -3378, -3378, -3378,
   -3378, -3378,   122,   122, 61371, 61371, 61371, 61371, -3378, -3378,
   -3378, -3378, -3378, -3378,  2623, -3378, -3378, -3378,   760, -3378,
   -3378, -3378,  2760,  2762,  2765,  2635,  2637,  2639,  2643, -3378,
    2646,  2651,  2653, -3378, -3378, -3378, -3378, 61371, 61371, -3378,
   -3378, -3378,  7140,  1046, 47444,  1046,  1046, 61371, 61371,  2558,
   -3378, -3378, -3378,  2789,  2792,  2794,  2796,  2801,  2804,  1046,
   -3378,   121,  1943, -3378,   888, 32842,  4840,  2569, -3378,  2565,
    -125,  2341, 30122,  1699, -3378, -3378, -3378,   699,  2783,  2573,
   -3378,  2753,  2430, -3378,   557,   707, 59575, 60024, 60473, -3378,
    1314,  2655, -3378, -3378, 42944, 32842,  2255,   756,  2718,   886,
   -3378, -3378, -3378, -3378, -3378, 55534,   134,  2114,  1471, -3378,
   47444, 51043,   610,  2577, 55534,  2578,  2575, -3378, -3378, -3378,
   -3378,  1480, -3378, 47444,    82,  2769,  2768,  1514, -3378, -3378,
     610, 61371,  2674, 55534,  2656,  2114, 40683, 46544,  2679, -3378,
   -3378,  2771, -3378, 61371, -3378, -3378, 31031, 29199,  1728,  2594,
   61371, -3378,  2596, 27830,  2830,  2772, -3378, 27830,  2772,  1439,
    2772,  2833, -3378, 32382, -3378,  2600,  1074, 18842,  2785, 10952,
   -3378,   122, 47444,   122,  2667,   122,  2668,   122, 45194,   122,
   55534, -3378, 55534, -3378,   122, -3378, 10952, 55534,   949, -3378,
   -3378,  2598, -3378,  2620, -3378, -3378, 43394, 61371,   806, -3378,
   -3378,  2781, -3378,   610, 61371,   903,  2601, -3378, -3378, -3378,
   -3378,  2905,  2906, -3378, -3378, -3378, 54636,   117, 61371, -3378,
   -3378, -3378, -3378,  2614,  1528, 10778, 24520, -3378,  2912, 47444,
   -3378, -3378, -3378, -3378, -3378, 24520, -3378, -3378, -3378, -3378,
   -3378, 24520, -3378, 24520,  2892, -3378,  3030, 47444, 25945,  1198,
    1999, 26895, 25945, 25945, 25945, 25945, 25945, 25945, 25945, 25945,
   25945, -3378,   328, -3378, -3378, 24520, 24520,  2907,  2892, -3378,
   -3378, -3378,  1685,  1685, 47444,  2624,  2487,  2626,  2627, 24520,
   -3378, -3378,  1535, 42944, -3378, 24520,  7338,  1537,  2686,   903,
    5295, -3378,  2996,  2114, 24520,   827,  1715, 24520,  1561, 24520,
    2914, -3378, -3378, -3378,  2634, -3378, -3378, 47444, 24520, 25945,
   25945,  6463, -3378,  7208, 24520,  2641,  7525, 22145, -3378,   394,
     394,   394,   394, -3378, 55534, 55534,  2447, 24520,  2909,  1569,
    1571, -3378,  1232, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,  2630, -3378,
    2660, -3378, -3378,   368,  2661, -3378, -3378,  2975,  2662, 61371,
   -3378,  2421, -3378, -3378, -3378,  2663, -3378,  1333, -3378, -3378,
   -3378,  1921, -3378, -3378, -3378, -3378, -3378,  2659,  2677, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,  2430,  5326,
   -3378, 61371, 61371,  1573, -3378, -3378,  2889,  1059, -3378, -3378,
   -3378,  2722,  2744,  2749,   377,   502,  2750,  2751, -3378,  2752,
   -3378, -3378, -3378, -3378,  1921,  1921, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378,   561,   497, 47444, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, 61371,  2953,   426,  1276, 61371, 61371, 61371,
   61371, 61371, 61371, 61371, -3378, -3378, -3378, -3378,  2670, -3378,
   -3378,  2913,  2915,  2916,  1046,  1046,  1046,  1046,  1046,  1046,
   -3378, -3378,  1938,  2965, -3378, -3378,  2275,  2275,  1043, -3378,
    2275, -3378,  2275, -3378, -3378,  2425,  2663,  1380, -3378, -3378,
   -3378, -3378, -3378,   601,  -125,  1736,  2676, -3378,  1150, 30122,
   30122, 30122, 30122, 30122,  2341,   606, 55534,  -125, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378,  2673, 61371, 25945, -3378,   930,   148, -3378,  2917, 55534,
    2729, -3378, -3378, -3378, 47444, -3378, -3378,  3067,   817, 55534,
    2964,  2857,  1586, -3378, -3378, 61371, -3378,  1322, -3378, 51942,
   -3378,  2939, 51942, -3378, 61371, -3378, -3378, -3378,  3041,  2780,
   -3378, 61371,  1108,  2756,  1770,  2114,  2656, 61371,  2692, -3378,
    2687, -3378,  3108, -3378,  1891, -3378, -3378,   669,  2726, -3378,
   -3378, 58228,  2696, 61371,  1728, 27830, -3378, -3378,  1477, -3378,
   27830,  2937, -3378, 27830, 61371,  2703, 61371,  1607, 38853, -3378,
    2711, -3378, 61371, -3378, 61371, -3378,  2712, -3378,   122,   122,
   -3378,  3093,  2714,  1286,  1287,   245, -3378, -3378,  2982, 59126,
   -3378, -3378, -3378, -3378, -3378, -3378,  2994, -3378, -3378, -3378,
   -3378, 24520, 10952, -3378,  2719, 10952,  5731, 10952,  2907, -3378,
    2052,  2999, -3378,   593,  2723,   328,  2052,   301,   301,   140,
     140,   100,   100,   100,  3030, 10952, 10952, -3378, -3378, -3378,
   -3378,  2721, -3378, -3378, -3378,  2487, -3378, 24995, -3378, -3378,
    2774,  2775,  2725, -3378, 24520, 25470,  2724, -3378, -3378,   606,
    2708, 25945, 25945,  1291, -3378,   317, 24520, 47444,  1616,  1291,
    1877,  2001, 24520, 24520,  8225,   259, 24520,  5863, 55534, 55534,
   55534, 55534, -3378, -3378, 10952,  3091,  2997, -3378, -3378, -3378,
     245,  2461,  2114, -3378,   692, -3378, -3378, 33782, -3378, -3378,
   13847, -3378,  -125, -3378,  1619,  1627,  2729, -3378,  2802, -3378,
   61371, 61371,  -125,  -125, 47444,  2731, -3378,  -125,  -125,  2732,
   -3378, 61371, 61371, 61371,  1314,  2918,  2920,  -125, 61371,  2797,
   -3378, 61371, 61371, 61371, 61371,  3026, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378,  2974,  1046,  1046,  1046, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,  2114,  2114,  1232,  2924, 61371,  2114,
    1232, -3378,  1036,  3060, -3378,  2993,   664,  2745,  3021,  3024,
   -3378, -3378,  1834,  1834, -3378, -3378, -3378, -3378, -3378,  3027,
   -3378, 24520,   130,  2052, -3378, -3378, -3378, -3378,  2729,  2255,
    2814,  2816,   610,   -50,  3057,  3047,   134, -3378,  2114, -3378,
   -3378,  2757,  1050,  2767,  1341, -3378, -3378, -3378,   772, 61371,
   -3378, -3378,  3118,  3119,  2936, -3378, 61371,  2998,  2118,  3040,
    2770, -3378, 28290,  2114,  2679, -3378, -3378, -3378, -3378, -3378,
    2851, 61371, -3378, -3378, 61371,  1650, -3378, 24520,  2782, -3378,
   -3378, 27830,  1477,  1652, 61371,  1670, 47444, -3378, -3378, -3378,
     122,   122,   122,   122, -3378, -3378,  2728, 61371,  3054, -3378,
   -3378,  2947, -3378, 59126, 10952, -3378, -3378, -3378, 25945,  3053,
   -3378,  2784, 25945, -3378,  2788,  1713,  1714, -3378, -3378, -3378,
    6490,  2837, 10952,  2886,  2795, -3378,  1563,  1563,   317,  1716,
   -3378, 25945, 25945,  1291,  1291, 24520,  1291, -3378, -3378, -3378,
   -3378, -3378, 24520, 24520, -3378, -3378,  1380, -3378, -3378, -3378,
   -3378,   606, -3378,  2805, -3378, -3378,  2927,  2729,  2814, -3378,
   -3378, -3378, 28750, 33782, -3378,   377,  2790,  2803,   502, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, 24520, -3378,   876,   -78,
    2832,  1921,  3068,  1046, -3378, -3378, -3378,  1943, -3378, -3378,
   -3378, 61371,  2800, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, 43394,  3186, 55534,   601,  6534,  2990, -3378,  2814,  3028,
    3071, -3378, 61371,  1108, 51942, -3378,  1080,  2963, -3378, -3378,
    1341,  1131,  1195, -3378, 55534,  2768,  2940, -3378,  2945, -3378,
    3000,  3001, -3378, -3378,  2114, -3378, 61371, 28290, 24520,  1744,
   -3378, 60922, 20243, -3378, -3378, 55534, -3378,  1759, -3378, 10952,
   61371, -3378, -3378, -3378,  1764, -3378, -3378, -3378, -3378, -3378,
     610, -3378,   117,   589, 25945, 25945,   218, 24520, -3378, 24520,
   -3378, -3378, -3378,   400, -3378, -3378,  1563,  1563,  1291,  2487,
   10952, -3378, -3378, -3378, -3378, 55534,  2814, -3378, 47444,  1794,
     347, -3378, 47444, 47444, -3378, 10952, 61371, 61371, 61371, 61371,
   61371, -3378,  2800,  3186,  3205, -3378, -3378,  3104, -3378, -3378,
     101,  3002,  2923,  3109, -3378, -3378, -3378, -3378, 61371,  2768,
   -3378, -3378, -3378, -3378, -3378, -3378,  1776,  2780, -3378, -3378,
   -3378, -3378, -3378, -3378,  1780,  6587,  2729, 28290, 61371, -3378,
     955,   955,  2557, -3378,  1788, -3378, -3378,   589,   253, -3378,
    1790,  1802,  2883, -3378,  2255, -3378,  1846, -3378, -3378, 45194,
   -3378,  1849,  1853,  2822,  2882,  2822, -3378,  1921, -3378, -3378,
    3138, -3378, -3378,   119, -3378,  3013,  3016, 61371, 61371,  3229,
    2841,  2780, -3378, -3378,  2729, 60922,  2780, -3378, -3378,  1333,
    1333,  3151, -3378, -3378, -3378, -3378, -3378,  3028, 43394,  2844,
   -3378, -3378, 61371,  2977,   102,   102,  2919, -3378,  3166, -3378,
   -3378, -3378,   377, 37943, -3378,  2780,   955,  2557, -3378, -3378,
     189,  3002,  1794,  3004, -3378,  3144, -3378,  3255, -3378,   137,
   -3378, -3378,  2731,  1873, -3378,  2159, -3378,  1130,  2557,  1333,
   -3378, -3378, -3378,  1549,   601, -3378, -3378,  3007, -3378, -3378,
   -3378, -3378, 37943, 24520, -3378, -3378, -3378,    87, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, 43394, -3378,  1892,  1612,
   -3378, -3378,  1651,  1615,  2858,  1232, -3378,    87, 37943, -3378,
    1908, -3378
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3378, -3378, -3378, -3378, -3378,  3098, -3378, -1062,  -312, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378,  1138, -3378, -3378,  -127,  1216,  1953, -3378,   866,
   -3378, -3378, -3378, -1341, -3378,   618,   402, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378,  1225, -3378,  -993,   745, -1177, -3378,
   -3378, -3378, -3378,  1187,   -17, -3378, -3378, -3378, -3378, -3378,
   -1584,  -139,   208, -3378,   207,  1247,   326, -3378,   -35, -3378,
   -3378, -3378, -3378,  -133,   828, -2616, -2449,   204,  -407,  -430,
    -381,  -376,  -405, -3378, -3183, -3322, -2541, -2435, -3378, -3378,
     584, -3378, -3378,   228, -1579, -3378,  1724, -3378, -3378, -3378,
   -3378,   -51, -3378, -3378, -3378,   -42, -3378, -3378, -3378, -1578,
   -3378,  1203, -2612, -3378, -3378, -3378,  -471,  -442, -3378, -3377,
       7,     9, -3378, -3378, -3378, -3378, -1091, -3378,   691,   694,
   -1026, -3378, -3378,   722, -3378, -3378,  -395,  -145,  1762, -3378,
    -401, -3378, -3378, -3378,  -144, -3378, -3378, -3378, -3378, -3378,
   -3378, -1704,  -670, -1585, -3378, -3378,  3221,  -560, -3378, -3378,
   -1924, -1570, -3378,  -164,   845,  2160, -1234, -2286,   186, -3378,
   -3378, -1727, -3378, -3378, -3378,  1094, -1557, -3378,   242,  -208,
    -307, -2940, -2941, -2879, -3378, -3378, -1187, -3378,   854,  1362,
   -3378,  1361, -3378, -1923,   247,  -912, -2638, -3013, -3378, -3378,
   -3378, -3378, -3378, -3378, -1679, -1503, -3378,  -266, -3378, -3378,
   -3378, -3378,   533, -3378,   159, -3378, -3378, -3378, -3378, -3378,
   -3378,  -403,  -436, -3378, -3378, -3378,   670, -3378, -3378, -3378,
    1118, -1099,  -911,  2452, -1555,  -171, -3378, -3378, -3378,  1233,
   -2039, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -1323, -3378,
   -3378, -3378, -3378, -3378, -3378,  1482,  3268,  -756, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378,  2199,   281, -3378,
     -58, -3378, -3378,   616, -2150,   -44, -3378, -3378, -3378, -3378,
    -522,   -43, -3378,   943, -3378, -3378, -1855, -3378,  2206,  1139,
     223,   -72,   -21,  -238,   560,   659, -3378, -3378,  -199,  1148,
   -3378, -3378, -3378, -3378,   939,  2013, -3378,   932,  -330, -3378,
   -3378,  2019, -3378, -3378,  2016,  1488, -3378,  1501,   977, -2186,
    1199, -2157,   678,  -617,   -12,  -176,  2605, -3378, -2825,   966,
   -2934,   311,  2842, -1864, -2427, -1458, -3378, -3378, -1160,  3326,
   -3378, -3378, -3378,  4584,  5642, -3378, -3378,  6089,  7077, -3378,
   -1115,   558,  7115,  2835, -1267, -1610, 11790,  -322,  1210, -1631,
   -3378, -3378, -3378,  -186,   568,  1632, -3378,  1174, -3378,  -758,
   -3378, 13035,   968, -3378, -1200, -3378, -1237, -3378, -1718, -3378,
   -3378, -3378, -3378, -3378, -1865, -2700,  -480,  1029, -3378, -3378,
    1122, -3378, -3378, -3378, -1068, -1000, -1799,  1037, -1823, -3378,
    -987,  1155,  1595,  7074,  -914,   957,  -848,  8020,  -143, -2016,
   -1365, -1022, -3378,  -738, -3378,  9943,   158, -3378, -3378,    -2,
    1168,  -810, -1846, -3378,   -32, -3378,  -881, -1001, -2654,  1506,
   -3378, -3378,  2880,   729, -3378,  2309, -3378,  1250,  1812, -3378,
   -3378,  1490,  -868,   -23, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,  2056,   109,
   -3378,   -54, -3378, -3378, -3378, -3378, -3378,  3140,  -306, -3378,
    2615,  -305, -3378, -3378, -3378, -3378, -3378, -3378, -3378, -3378,
   -3378,  2063,  1522, -3378,  2440, -3378, -3378, -3378,   -36, -3378,
    2244,  -138, -3378, -3378, -3378, -1095,  1201,  2468,  -874,  -839,
    1499, -3378, -3378, -3378, -3378, -3378, -3378, -3378,  1200, -3378,
   -3378,  1022,  1205, -3378, -3378,   286, -3378, -3378,   198,   295,
   -3378,  2143, -3378, -3378, -3378,   545, -3378, -3378, -3378,  -575,
    9117,   230,  -102,   -81,   168, -3378,  3092,  7735,  -745,    22,
    2084,  5716, 11683,   -95,   -77,  -123,    95,  1294, -2347, -3378,
    3135,  1515,  1223,  -952, 10009,  1779,  4570,    -9,  -774, -1084,
    2311,  -697, -1691, -3378,  3522
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1994
static const short yytable[] =
{
      75,   986,  1248,   831,  1688,   826,   333,  2283,  1568,   843,
    1193,  1428,   744,  1044,  1201,  1088,  1769,  2272,  2182,   751,
     328,   972,  2305,  1210,   345,  2070,  1723,   383,  1057,  1529,
    2287,  1779,  1072,   745,   329,   331,  1464,   752,  1559,   945,
     999,  1000,  1375,  1904,  1573,  2183,  1825,  2476,   978,  2254,
    2573,  1388,  2827,   744,   629,  1154,  1478,   334,  1398,   921,
     751,  2758,  2207,  1642,  1177,  1141,  2345,  2208,  2209,   378,
     653,  1657,   378,  1229,   745,  1231,  2210,  1233,   752,   941,
    2486,  1524,   964,  1234,   628,  1468,   941,  1638,   941,  2211,
    3137,  2212,  3003,   786,  1644,  2772,  2774,  1065,  3318,  1068,
     375,  1658,  1198,   375,  3141,   378,   653,   940,  2780,  2510,
    3175,   873,  1099,  1184,   940,  1596,   940,  3410,  2012,  1191,
     744,  2494,   802,   836,  1798,  1799,  1228,   751,  1242,  2560,
    2562,  1396,  1725,  1841,  1719,  1032,  2520,   837,  1447,  1146,
    2524,   745,  2491,  1814,   832,   752,   378,  1666,   914,  2695,
    2696,  2697,  2698,  1162,  2173,  1885,  1461,  1892,  1683,  1511,
      74,  1792,  1793,  1465,  1848,  1454,  1455,  1712,   333,   800,
    1656,  1843,  2857,   376,  1759,  2175,   376,  3257,   628,  1219,
    1369,  2702,   328,  2677,  1811,  1053,  2224,  1851,  1230,   847,
     382, -1328,  2271,   943,  1252,  -978,   329,   331, -1328,  2115,
     943,  1515,   943,  2106,  1763,  2418,  1041,  3687,  -978,   376,
     992,  3806,  2857,   378,  1712,  1712,  1266,  2467,   985,   334,
    2018,  1931,  1013,   646,  2649,  2339,  1712,  2106,  2229,  1978,
    1878,  1712,   754,  2452,  2019,  1461,  2505,  2413,  2670,  2418,
    2453,  3605,   755,  2164,  1848,  2018,  2229,  3121,  -978,   151,
     376,  1436,  2785,  2943,  2787,  3098,  1492,  2944,  2945,  2946,
    3463,  3677,  3465,   993, -1873,  2456,  -978,  1851,  2947,  2948,
    2949,  3821,  2950,  2951,  2580,  2637,   151,  2952,  2953,  2954,
    2817,  3784,  2632,  3707,  1014,  -313,  2626,  3123,  2633,  1568,
    2857,  1979,  1458,   759,  3829,   760,  2219,   942,  1516,  2836,
    2638,  2020,  1239,  3751,   942,  1982,   942,  3406,   374,  2678,
    -978,   374,  2373,  3538,  1245,  1104, -1900,   376,  -978,   170,
     756,  1367,  2234,   878,  1912,  2857,  2020,  1026,  3092,  1384,
     627,  1519,  1533,   994,  2111,  1236,  1015,   378,    55,  1016,
   -1344,  1848,  2062,  1980,   374, -1817,   170, -1344,  1825,  1902,
       3,  1697,  3678,  1493, -1916,  1882,  1520,  1250,  3092,  1534,
    1521,  1028,  1913, -1942,  1851,  1572,  2220,  1583,   375,  1852,
   -1144,  1239,   378,  2857,  2178,   187,   208,  3761,  1577,  2634,
    3807,  3155,  2112,  1522,  1579,   374,  1910,  2819,  1726,  1848,
     974,  1368,  2149,   787,  2457,  3588,  1983,  1757,  1738,  1739,
    2857,  1713,  1105,   375,  1246,  1525,  1526,  1771,  1690,  3033,
    1573,  2230,  1851,  2581,  1042,  3752,  3586,  3699,  1780, -1116,
    -978,  3127,  3822,   647,  2506,   848,  2021,  1017,  3830,  3594,
    2061,  3624,  1667,  1641,  1981,   995,  1014,   226,  2165,  3407,
     757,   376,  1641,  1798,  1799,  3808,   208,  3845,  1713,  1713,
    1814,  2021,   374,  3128,   831,  2116,  1055,  1000,  2859,  1437,
    1713,  1517,  2818,  3129,  2627,  1713,  3809,  2117,  2144,  1456,
    1764,  2564,  1253,   208,  2659,  2121,   376,  1232,  1879,  1476,
    2238, -1328,  1639,  1640,  2225,  1853,  1792,  1793,  1015,  1854,
    1025,  2179,  1412,  2859,  1811,  2419,  1760,   849,  1664,   850,
     224,  1246,  2488,  2650,  1690,  2171,  2260,   226, -1873,  1855,
    1856,  2264,  2022,  1018,  1881,  2118,  2955,  2635,  2815,  1718,
    2273,  2860,  1857,  2454,  3666,  1692,  1694,   224,  1033,  2919,
    3634,  2167,  3785,  2282,   226,  1844,  3071,  2022,  3487,  3130,
     761,  2859,  2636,  1494,  1714,  1263,   239,  2221,  1037,  1019,
    2347,  2147,  3324,  3325,  1928,  1929,  2860, -1994,  1859,  1641,
   -1900,  1641,   627,  2176,  2956,  1893,   239,  1872,  2859,  2820,
      55,  2176,  1860,   627,   836,  2870,   374,  3184,   894,  1017,
    3332,  3188,  1465,  2342,  2343,  1997,  1034,   627,   837, -1817,
    2173,  1764,  1690,   239,  2351,   832,  1074,  2354, -1916,  3034,
    2043,  1093,  1095,  3219,  2860,  2366,  2367, -1942,  1101,  2899,
    1104,   374,  2867,  2868,  2869,  2870,  2254,  2033,  2383,  2385,
    2967, -1149,  3352,  2038,  1390,  1067,  1069,   384,  1170,  2399,
   -1344,  2291,  2962,  1719, -1875,   763,  3009,  1862,  3010, -1424,
    3035,  3061,  3062,  2236,  1869,  1870,  1871,  1872,  2532,    49,
    2957,  1942,   627,  3107,  2028,   797,   744,    52,    53,    54,
      55,  2857,    56,   751,  1145,  2180,  2028,  2972,  1444,   764,
     978,  2861,  3392,  3393,  3394,  3395,  3396,   745,  3732,  3738,
    3333,   752,  3721,  2473,  2862,  2863,  2864,   923,  2865,  2866,
    2867,  2868,  2869,  2870,  2370,  2371,   256,  1105,  3729,  2150,
    3014,  2181,  1179,  3766,   846,  3337,  2861, -1144,  1113,  2320,
   -1144,  1556,  1189,   763,  3108, -1144, -1144, -1144,  2026,  2862,
    2863,  2864,  1863,  2865,  2866,  2867,  2868,  2869,  2870,  3057,
     902,  3059,  3060,  3773, -1144,  1864,  1865,  1866,  1572,  1867,
    1868,  1869,  1870,  1871,  1872,  3070,  1565,   764,   305,   378,
     911,  3795,  3089,   378,  2861,  1136,  3334,  1064,  2178,   924,
    3381,  1064,  3489,  1557,  3490,  3353,  1138,  2407, -1994, -1994,
    1088,  2865,  2866,  2867,  2868,  2869,  2870,  1171,  2355,  3769,
    3770,   915,  3089,  3346,   375,  1167, -1069,  1867,  1868,  1869,
    1870,  1871,  1872,  3589,  1064,  2029,   628,  3015,  2865,  2866,
    2867,  2868,  2869,  2870,  3598,  3338,  3175, -1116,  1483,  1797,
   -1116,  1483,  1551, -1069,  1573,  1028, -1116,  3097,  2321,  1391,
    1014,  3316,  1114,  3381,  3173,  3796,  3739,  1481,  3382, -1994,
    1377,  3446,  1649,  1386,   941,  1180,  2254,   941,  2308,  2309,
    2356,  2265,  1064,  1147,  3733,  1148,  2039,  3345,  1064,  1552,
    2274,   627,  1482,   376,  1567,  3819,  1224,   376,   256,    55,
    2280,  2186,   940,  2030,  3113,   940,  2018,   894,  1899,  1650,
    1702,  2965,  1015,  3347,    75,  2179,  3348,  1566, -1875,  1028,
    2019,  2128,  2129,  2130,  2131,  2335,  2290,  3383,  1251,  3491,
    3798,  3799,  2357,  2204,  2154,  2358,  2200,  3771,  2294,  2857,
    2303,  3447,  2306,  2307,  1263,  2434,  2310,  1703,  1392,  2187,
     305,  2151,  2152,  1979,  3281,  1267,  1848,  2161,   628,  1372,
    2123,  1405,   925,   926,  2040,  1900,  1380,  1382,  1787,  3572,
    1195,  1028,   653,  2156,  3606,  3016,  2925,  1088,  2614,  1851,
    3835,  1744,  2256,  1064,  2259,   628,  3607,  2020,   943,  2263,
    3383,   943,   950,  1955,  2062,  2155,   628,   628, -1149,  3322,
    3017, -1149,  2205,  1017,   378,  1980, -1149, -1149, -1149,   208,
    2157,  3007,  3820,   922,  1064,  1690,   971,   627,  2564,  2215,
    2216,  2217,  2218,  2359,  2322, -1149,  2615,  2549,   374,  3238,
    1956,  2188,   374,  3834,   798,  1399,  1553,  2124,  1464,  3456,
    2323,   629,   629,  1196,  3460,  1709,  1675,  3462,   744,    49,
     908,  1072,   627,  3258,   810,   751,  1651,    52,    53,    54,
      55,  2435,   810,  2690,  3453,  2436,  1197,   202,  3448,   745,
     226,   628,   628,   752,    74,  1462,   981,  1957,  2639,  1422,
     951,  2602,  2603,  2189,  2284,  1641,  2497,  1468,   946,  2180,
    1487,  1675,   942,  1676,  1704,   942,  1981,  1088,  2437,  2865,
    2866,  2867,  2868,  2869,  2870,  2550,   812,  2859,   376,  2360,
     763,  2570,  2021,  1554,   812,  2598,  2783,   237,    49,  3216,
     238,   627,  3449,  1423,  1855,  1856,    52,    53,    54,   239,
    3404,  2483,  3608,  1652,   119,   986,   794,  2495,  3213,  2791,
    1064,   378,  2793,  3667,   764,  2416,  2795,  1064,  1594,  3206,
    2514,   947,   123,  1064,  3315,  3229,  1488,  2158,  3777,  2190,
    2498,  2191,  3682,  2207,  2711,  2712,  2713,  2714,  2208,  2209,
    2860,  1705,  2254,  1859,  1633,  1677,  2254,  2210,   628,  3816,
    3367,  3368,  3369,  3370,  3371,  3372,  2834,  3405,  2062,  2007,
    2211,  3441,  2212,  3689,  1421,  1378,  1736,  1986,  2022,    49,
    1987,  1064,   627,  2829,  2000,  1000,  3763,    52,    53,    54,
    1732,   983, -1003,  2438,  2008,  1762,  2312,  1446,  3816,  1710,
    1677,  1150,  1678,  1151,  1733,  1734,  3471,   763,  3472,   990,
    2599,  2124,  2600,  2886,  2159,  1446,  3575,  3642,   818, -1915,
     819,  2009,  2025,   374,  3816,   376,   818,   334,   819,   628,
    2566,  1164,  1422,    75,    75,  2593,    75,  1064,  2596,  2597,
    3794,   764,  2908,  2577,  2518,  3797,   334,  1678,  2026,  1224,
   -1003,  3735,  1690,  2781,  -322,  3601,  3218,  2584,  1165,  1641,
    3397,  2587,    49,   765,  1633,   627,  1164,  2136,  1988,  1785,
      52,    53,    54,  3576,  3818,  2776,  1423,  1841,  1519,  1679,
     799,  1536,  2821,  3700,  1077,  1064,  1801,  1537,  1572,  2939,
    2940,  3602,   875,  3139, -1003,  3631,  1166,  1078,  1079,  1080,
    2861,  1081,  1082,  1083,  1084,  1085,  1086,  1521,  2616,  3701,
     888,  1064,  3219,  2862,  2863,  2864,  1828,  2865,  2866,  2867,
    2868,  2869,  2870,  1842,  1679,  1538,  3676,  1006,   998,   889,
    1522,  1166,  1839,  1847,  1867,  1868,  1869,  1870,  1871,  1872,
    1531,  1064,  1064,   948,  1064,  2822,  2195,  3703,  1007,  3377,
    1956,   744,  2202,   628,  1897,  1898,  2617,  2660,  1008,   237,
     374,  1064,   238,   628,  2582,  1532,  2226,   653,   653,  1820,
    1821,  1539,  1382,  3704,  1884,  3702,   752,  2027,  1540,  2023,
    1943,  1541,  1690,  1848,   941,  3004,  1944,  3241,  1727,  3242,
    1549,  3378,   377,    74,    74,   377,    74,  1957,  1911,  2132,
    1109,   744,   628,   941,  1110,  1462,  1851,  1728,   751,  1462,
    1462,  1852,   940,   151, -1915,  1550,  1947,  1947,  1822,  1947,
     127,   128,   745,  2107,  2690,  3171,   752,  2138,   377,  1542,
    1064,   940, -1568,  1064,  1064,  1994,  1009,  1729,   936,  3705,
    2140,   629,  3012,  2407,   378,   378,   378,   970,   653,  2141,
    3695,  3121,  2139,  1820,  1821,  3037,  3038,  1536,  1223,   627,
    3564,  3565,  3566,  1537,  2425,  3122,  2426,  3013,  1653,   377,
      49,   628,  2142,   627,  1848,  3696,   375,   375,    52,    53,
      54,   378,  1543,   170,   989,  3529,  2427,  1654,   378,  1491,
    1633,  3123,  3354,  3124,   378,  1010,  1888,  1851,   943, -1915,
    1889,  1538,  1824, -1915,  3243,  2663,  2664,  2665,  2666,  2667,
    2668,  3355,   375,  1530,  3244,  3398,  1519,   943,    49,  2004,
    2857,   627,  1560,  1003,  1633,    49,    52,    53,    54,  2256,
    -978,  1854,  3011,    52,    53,    54,   377,  1797,  1633,  2013,
    1558,  2799,   986,  -978,   202,  1521,     8,  1539,   376,   376,
     376,  1855,  1856,  3328,  1540,  2106,  1011,  1541,  1797,   744,
    2013,  3125,  2113,  2262,  2831,  1446,   751,  1487,  2628,  1446,
    1446,  1109,  2289, -1430,  2254,  1110,  3432,  3433,  3434,  2254,
     745,  2428,  2254,  -978,   752,   376,  2429,   627,  2963,  1633,
    1971,  2430,   376,  1037,  1972,    55,  3693,  3197,   376,  3438,
    1859,  -978,   942,   894,  1043,  1542,  2170,  2832,  2292,  2508,
     208,  1097,  3226,  1972,  1860,  2833,  1784,  2784,   239,  2786,
    3126,   942,  1990,  1633,  3199,  3127,  3201, -1416,  3203,  1054,
    3205, -1416,  3207,  1488,  2336,  3259,  3260,  3210,  2764,  1102,
    3099,  3100,  3101,  3102,  3103,  -978,  2484,  1000,  1633,  3534,
    3391,  1382,   378,  -978,  1103,  2857,  1152,  3128,  1543,  3681,
     377,  2765,  1140,  3156,   224,  1144,  2288,  3129,  2858,  1143,
    3227,   226,  2289,  1168,  2981,  2892,  1446,  1809,  1810,  2248,
    2897,   628,  1446,   374,   374,   374,  1485,  2766,  2859,  3505,
    1155,  1064,  1519,  1064,  3091,   377,  1633,  2431,  1064,  2765,
    3288,  1088,  3190,   774,    49,  2432,  1720,  1633,  1721,  3265,
    2768,  1486,    52,    53,    54,   202,  2109,  1544,  2334,  2114,
     374,  1521,  1160,  2122,  3091,  2766,  1169,   374,  1573,  1153,
     239,   151,  2331,   374,  3028,    75,  2243,  2244,  1487,    75,
    2767,  3030,  3031,  3130,  1545,  1172,  2332,  2333,  2768,  2256,
    1175,  2860,  3024,  3025,  1094,  -978,   376,  2328,  1446,   985,
    1064,  2976,   627,  2329,  1863,  1186,  2526,  2407,   744,   334,
    2557,  2769,  2329,  3375,  3376,   751,  2558,  3379,  1139,  3380,
    1199,  1867,  1868,  1869,  1870,  1871,  1872,  1211,  3022,   745,
    2363,  2734,  2735,   752,  1064,  1064,  1206,  2673,  3457,  2978,
    2979,   170,  1064,  2674,  1488,  1064,  2770,  2857,  1064,  2703,
    1774,  1775,  2813,  2364,   876,  2704,  1064,  1064,  2814,  2830,
     628,  1226,  3282,  2859,  1064,  2289,  1906,  1064,  1064,  1064,
    1064,  3621,  1239,  1045,  3533,  2840,  1046,  1064,  1064,  1243,
    1064,  2289,  1064,  2843,  2770,  1064,  1047,  1048,  2847,  2289,
    2254,  2407,  1244,  2423,  2289,  1255,  3836,   187,  -977,  1633,
    1064,   378,  1260,    55,  1064,    56,  1049,  2690,  1064,  1050,
    1261,  -977,  1064,  1262,  3683,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,  1064,  1568,  1064,  2860,  1263,  1247,  2764,
    1064,   374,  2534,  1249,  1064,    74,  2848,  2481,  1797,    74,
    1483,  2861,  2289,  2874,  1258,  1264,  1607,  2891,  2286,  2289,
    1721,  -977,  3458,  2289,  2862,  2863,  2864,  1265,  2865,  2866,
    2867,  2868,  2869,  2870,  2894,  1268,  1907,   628,   208,  -977,
    2895,   744,  2885,  1249,  2887,  2888, -1116,  2976,   751, -1116,
    2512,  3663,  2512,   378, -1116, -1116, -1116,  2942,  1389,  1249,
    2765,  3029,   745,  2289,  1401,  1064,   752,  2929,  2968,  2930,
    2973,  1269,   627,  1797,  2969,   376,  1690,  2976,  1415,  2857,
      55,  3144,    56,  -977,   375,  2859,  2766,  3145,  1444,  2200,
    3153,  -977,   224,   629,  3511,   378,  3154,   378,  1387,   226,
    1077,  2767,  3743,  1395,  3745,  1028,  1051,  1948,  1950,  2768,
    1954,  2982,  2983,  1078,  1079,  1080,  3621,  1081,  1082,  1083,
    1084,  1085,  1086,   628,  3160,  1393,   375,  1462,   375,    75,
    3161,    75,  2769, -1766,   378,  1394,  1591,  1592,  3230,   986,
    3373, -1766, -1766, -1766,  2289,  3266,  2861,  3273,  2860,  1064,
    2910,  3267,  2911,  3274,  1797,  2256,  2013,   376,  3837,  2256,
   -1766,  3474,  3475,  2865,  2866,  2867,  2868,  2869,  2870,  1633,
    3670,  3284,  2912,  1633,  1633,  3074,  2931,  2289,  2932,  3307,
    3509,  3308,   377,  3326,  2856,  2289,   377,  2289,  2872,  3161,
    3779,  1404,  1235,  -977,  1405,  2709,  3417,  3496,  1072,   376,
    1574,   376,  3418,  2857,  1406,  2770,  1949,  1949,  1412,  1949,
     374,    49,  2583,  3445,   627,  3075,  3621,  3467,  3512,    52,
      53,    54,  3856,  2289,  3857,  1413,  3510,  2905,  2906,  3536,
     237,    49,  2329,   238,   627,  3161,  3076,  3537,   376,    52,
      53,    54,    55,  3161,    56,  1820,  1821,  2859, -1768,  1414,
    1444,  1659,  1661,  1662,  2857,  3077, -1768, -1768, -1768,  1416,
    3628,  1412,  3633,  -970,  1594,  1419,  1690,  1064,  3145,   806,
    3078,  1418,  2913,  1420,  1633, -1768,  1430,  2914,  3268,  1446,
    3635,  3189,   628,  3192,  2096,  3079,  3145,  1446,  1434,    74,
     628,    74,   374,  1064,   628,  1633,  3388,  3389,  2861,  3099,
    3100,  3101,  3102,  3103,  2684,  2984,  2985,  3104,  1787,  1435,
    2860,  2862,  2863,  2864,   986,  2865,  2866,  2867,  2868,  2869,
    2870,  1438,  1848,  3648,  3650,  1439,  3655,  2097,  1450,  3649,
    2289,  1249,  2329,  2742,   374,  1440,   374,  1441, -1149,  1442,
    1443, -1149,  2710,   810,  1451,  1851, -1149, -1149, -1149, -1764,
    1852,  1453,  1249,  1456,  3716,  1469,  2757, -1764, -1764, -1764,
    3717,  -646,  1470,   628,  3080, -1149,  1457,  1459,  1064,  3723,
    1472,  2859,  3081,   374,  3725,  1690, -1764,  1479,  1064,  2794,
    3145,  1483,  1496,  2915,  1446,  1528,  3762,  1446,  1446,  1555,
    3764,  2916,  1764,  2934,  2935,   812,  3717,   377,  3772,  2098,
    3774,  3082,  1028,  1513,  1690, -1129,  2895,  1073, -1129,   628,
    1064,  1091,  3775, -1129, -1129, -1129,  1527,  1561,  2289,  1100,
    1564, -1763,  2859,  3636,  3637,  3638,  3639,  1563,   744, -1763,
   -1763, -1763,  1803,   744,  2860,   751,  3101,  3102,  3103,  1064,
     751,  1578,  2099,  2708,  2100,  1580,  1585,  1149, -1763,   745,
    1633,  1156,  3659,   752,   745,  2101,  3778,  3532,   752,  3780,
    2861,  1163,  2329,  3781,  1587,  2329,  1853,  1064,  1064,  2329,
    1854,  1589,  1595,  2862,  2863,  2864,  1598,  2865,  2866,  2867,
    2868,  2869,  2870,  3831,    49,  2860,  1635,  1933,  2102,  3832,
    1855,  1856,    52,    53,    54,  1636, -1156,  1064,  1488, -1156,
    1641,  1064,  3855,  1857, -1156, -1156, -1156,  1645,  2289,  -166,
    1647,  1883,  1663,  1064,  1064,  1064,  1064,  1672,  3861,  2103,
    1680,   378,  1682, -1156,  3832,  1064,   378,   818,  1684,   819,
    1064,  1839,  1685,  1686,   377,  1687,  1689,  1690,   821,  1859,
    1064,  1064,  1695,  1064,  1696,  2423,  1770,   824,  1698,  1699,
    1700,  2104,  1701,  1860,  1706,  1708,  1064,  1707,  1064,  1711,
      49,  3736,  1064,   627,  2928,  3741,  3742,  1772,    52,    53,
      54,  1776,  1778,  1783,  1791,  1794,  2248,  2256,  1064,  3731,
    1795,  1796,  2256,  1800,  2861,  2256,   239,  1846,  1064,  1802,
    1064,  1064,  1805,  1806,  1807,  3726,  1808,  2862,  2863,  2864,
    1876,  2865,  2866,  2867,  2868,  2869,  2870,  1813,  1815,  1816,
    1462,  1064,  3737,  1817, -1430,  1820,  1821,  1064,  1862,  1818,
    1819,  1826, -1430, -1430, -1430,   376,  1064,  1064,  1064,  2119,
     376,  1827,  1829,  3558,  3559,  2861,  3561, -1159,  1905,  1109,
   -1159, -1430,  1830,  1110,  1831, -1159, -1159, -1159,  2862,  2863,
    2864,  1832,  2865,  2866,  2867,  2868,  2869,  2870,  1064,  1833,
    1834,  1820,  1821,  1915,  1822,  1764,  3240,  1930,  1932,  3245,
    3246,  3247,  3248,  3249,  3250,  3251,  3252,  3253,  3254,  1633,
    1633,  1945,  1633, -1159,  1421,  1967, -1159,  1970,  1977,  1088,
    1984, -1159, -1159, -1159,  1985,  1633,    49,  1633,  1991,   627,
    1993,  1995,  1461,  1863,    52,    53,    54,  3023,  1998,  1999,
    1824,  2001, -1709,  3147,  3026,  2003,  3027, -1994, -1994,  2010,
    1867,  1868,  1869,  1870,  1871,  1872,  1633,  3290,  3291,  2013,
    2011,  2032,   744,  2014,    49,  2015,  3627,   627,  2031,   751,
     831,    49,    52,    53,    54,  3825,  3627,  2034,  3180,    52,
      53,    54,  2035,   745,  2036,  2037,  2057,   752,  2058,  2059,
     374,  2480,  2060,  3848, -1120,   374,  2064, -1120,  3833,  2065,
    1446,  2095, -1120, -1120, -1120,  1633,  2092,  1581,  2093,  2066,
    3148,   628, -1118,   628,   628, -1118,  2094,  2276,  2110,  2106,
   -1118, -1118, -1118,  3114,  2279,  3085,  1633,   628,  3162, -1121,
    2120,  2125, -1121,  1462,  2126,  2127,  2133, -1121, -1121, -1121,
    2684,  2134,  2135,  3560,  3179,  3143,  2137,  2153,  2160,   986,
    3706,  2162,  3110,   628,  2163,   378,  1633, -1119,  1787,  2172,
   -1119,   334,  1797,  1462,  2256, -1119, -1119, -1119,  2174,  1249,
    1249,  1633,  2185,  3170,  1382,   628,   808,  2197,  1803,   334,
    1582,  2325,  2201,  2256,  1633,  2214,  2228,   377,   377,   377,
    3298,  3299,  3300,  3301,  2232,   334,  2235,  2237,  1633,  2239,
    2246,  3222,  2248,   628,   628,  2240,  2248,  2257,  2267,  2295,
    2268,  2269,  2270,  1446,  1064,  2281,  2296,  2301,  1064,  2302,
    1446,  1446,  2311,  2314,   377,  2318,  2326,  2338,  1064,  2745,
    2346,   377,  2347,  1633,  2387,  2388,  2400,   377,  2405,  1633,
    1848,  2410,  3724,  2417,  2422,  1088,  2439,  1497,  2441,  2409,
    2467,   744,   334,  2485,  2477,  2478,  2479,  1064,   751,   376,
      49,  3403,  2482,   627,  3669,  2490,   993,  2496,    52,    53,
      54,    55,   745,    56,  2501,  1498,   752,  2502,  2176,  1444,
    2515,  2507,  2516,  2527,  2525,  2528,  2529,  1064,  2535,  2537,
    1633,  2539,  3747,  1446,  2540,  2465,  1064,  2543,  2545,  2541,
    2241,  2548,  1064,  1072,  1064,  2553,  2555,  2574,  1633,  1064,
    2575,  2576,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  2578,  1446,  2579,  2588,  1064,  1064,  1499,  2586,
    2594,  3279,  2601,  2640,  2641,  1633,  2647,  2648,  2642,  2256,
    1064,  2651,  2653,  2654,   378,  2655,  1064,  2656,  2657,  2658,
    2669,  2675,  2680,  2687,  2688,  1064,  2693,  1500,  1064,  2493,
    1064,   628,  2692,  2701,  2705,  2715,  1839,  2716,  1633,  1064,
    1064,  1064,  2717,    49,  2721,  1064,   627,  2740,  1064,  2741,
    2743,    52,    53,    54,    55,  2746,    56,  2753,  1064,  2754,
    2755,  2756,  3526,  2763,   374,   377,  2777,  2782,  2788,  2790,
    3309,  2792,  2789,  2797,  1892,  2811,  3713,  2339,  2823,  2806,
    1246,  3719,  3719,  2826,  2828,  2841,  2845,  2842,  2844,  3506,
    3507,  2880,  2846,  2352,  2353,  2849,  2850,  2975,  2852,  2855,
    2873,  2365,  2879,  2289,  2881,  2368,  2369,  2904,  2909,  2256,
    2882,  1077,  2883,  2890,  2902,  2937,  2903,  2917,   376,  2924,
    2389,  2379,  2390,  2927,  1078,  1079,  1080,  2941,  1081,  1082,
    1083,  1084,  1085,  1086,  2989,  2987,  2990,  3744,  2994,  3746,
    2992,  1721,  2411,  2993,  2412,  2998,  3005,  3001,  3006,  3043,
     202,  3002,  3019,  3044,  1503,  3045,  1633,  2378,  3046,  3064,
    1504,  3047,  3065,  3048,  3066,  3049,  3067,  1505,  3063,  3050,
    3802,  3068,  3051,  1487,  3069,  3095,  3094,  3052,  3768,  3053,
    2458,  1507,  1987,  3105,  3106,  3815,  3149,  3138,  3151,  1508,
    3134,  3152,   628,   628,   628,   628,   628,   628,  3157,  3158,
    3165,  3167,  3177,  3185,  3181,  3183,  3193,  2622,  2745,  3196,
    3186,  3198,  3202,  3204,  3214,  3221,  3215,  1879,  3791,  3224,
    3225,  1784,  3233,  2876,  3815,  3719,  1497,  2684,  2684,  2684,
    2684,  2684,  2857,  2875,  3262,  1509,  3263,  3264,  3854,  3174,
    3275,  1843,  3804,  3287,  1064,  3286,  3310,  1077,  3305,  3327,
    3815,  3295,    55,   374,  1498,  1633,  3311,  3329,  3314,  3374,
    1078,  1079,  1080,  3439,  1081,  1082,  1083,  1084,  1085,  1086,
    3330,  3312,  3317,  3320,   377,  3331,  3341,  3342,  3343,  3351,
    3363,  2203,  3401,  3364,  3390,  3365,  3366,  3412,  2706,  3174,
    3414,  3408,  3416,   628,  2248,  3423,  3643,  3428,  3429,  2248,
    3646,  3442,  2248,  3443,  3436,  3454,  1064,  1499,   636,  3451,
    3461,  1064,  3464,  3476,  1064,   656,  2723,   660,  3481,  3656,
    3657,  3470,  3473,  3477,  2744,  3483,   660,  3522,  2745,  3485,
    3488,  3493,  3492,  3497,  3498,  3499,  1500,  3539,  3523,  3552,
    3503,  3553,  3556,  3562,  3563,  3571,  1497,  3545,  3548,  3577,
    3382,   656,  1064,  3580,  3581,  1497,   377,  3582,  3583,  3590,
     660,  3592,  3595,  3597,  2746,  3610,  3611,  3600,   656,   660,
    3612,  3616,   660,  3614,  1498,  1990,  3604,  3625,   660,  3617,
    3640,  3641,   660,  1498,  3644,  2585,  3652,   910,  1064,  3653,
    3665,  3630,  3679,  3645,  3680,  1064,  1064,  3647,   377,  3672,
     377,   912,  1064,  1064,   660,  3654,  3684,  1064,  1633,   919,
    3531,  3407,  3673,  1064,  1064,  3664,  3161,  1064,  1497,   660,
    3698,  3708,  3690,   929,  3692,   910,  3709,  1499,  3749,   949,
    3750,  3758,  3776,  3753,  3710,  3711,  1499,   377,  1714,  3528,
     628,  3757,  3782,  3783,  3786,   976,  1498,  3788,    75,  3792,
    3793,  3800,  3727,  3728,  3803,  1633,  1500,  3805,  3784,   202,
    3827,  3828,  3785,  2747,  3846,  1500,  3738,  3858,   988,  1504,
    3593,  2707,  3568,  3569,  2685,  1927,  1505,  3573,  2966,  2689,
    2629,  3036,  1487,  2671,  2746,  2604,  3567,  3421,  3344,  3425,
    1507,  1848,   628,   628,   628,  3431,  3000,  3587,  1508,  1499,
    3801,  3824,   628,   628,  3570,  3789,  1849,   628,  3574,  3787,
    3811,  3211,  3426,  2227,  1851,  3613,  3599,  3860,  2691,  1852,
    3847,   334,  1064,  3579,  3578,  3135,  3084,  3812,  1500,  3136,
    3671,  2196,  3826,   917,  3674,  3482,  1758,  2812,  3440,  3714,
    3767,  3623,  3008,  2559,  1509,  2561,   628,  3748,  2933,  3444,
    3839,  3859,  3694,  1397,  2492,  2699,   881,  1731,  3420,  1501,
    3223,  2970,  2798,  1064,  1735,  2974,  3478,  2489,  1965,  2986,
    2248,   628,  1968,  1963,  2936,  2504,  2759,  3191,  1064,   202,
    3632,  1182,  1064,  1503,  1502,  2971,  3419,  1633,   202,  1504,
    3278,  3730,  1503,  3269,  2404,  2922,  1505,  2977,  1504,  3527,
    2837,  2920,  1487,  2816,  2466,  1505,   660,  1031,    74,  1064,
    1507,  1506,  3178,  1064,  1674,  2517,  2242,  1001,  1508,  1507,
    2752,  1976,  1969,  1222,  2509,  1477,  1767,  1508,  2519,  2961,
    3479,  2804,  1064,  1064,  1460,  1853,  1064,  2805,  3525,  1854,
    3480,  1891,  3313,  1064,  1064,  1023,  2530,  1973,  2523,  2800,
    2533,   202,  2297,  2042,    80,  1503,  1717,     0,     0,  1855,
    1856,  1504,     0,  1064,  1509,     0,     0,  2547,  1505,     0,
       0,  2551,  1857,  1509,  1487,     0,     0,  1064,     0,     0,
    2379,     0,  1507,     0,  2379,     0,     0,     0,     0,     0,
    1508,   628,     0,  2565,     0,  2567,     0,     0,  3179,     0,
       0,     0,  1064,     0,     0,  1858,     0,     0,  1859,     0,
       0,     0,  3712,     0,     0,     0,  2378,     0,     0,     0,
    2378,     0,  1860,  2379,  2379,     0,     0,     0,  2589,  3853,
       0,     0,     0,     0,     0,     0,  1509,     0,  1064,  1064,
       0,     0,   628,     0,     0,     0,     0,     0,     0,   334,
       0,     0,     0,     0,  1848,     0,     0,     0,     0,  2378,
    2378,     0,  2630,     0,     0,  1064,  1064,     0,  1064,  2643,
    1064,  2645,     0,     0,     0,     0,     0,  1851,  2964,     0,
       0,     0,  1852,     0,     0,     0,     0,  1862,     0,  1633,
       0,     0,     0,  1633,  1633,     0,     0,     0,     0,     0,
       0,     0,  3140,     0,     0,     0,     0,     0,     0,     0,
       0,  3150,     0,     0,  3662,     0,     0,     0,     0,   656,
       0,     0,     0,     0,   377,     0,     0,     0,     0,   377,
    3166,     0,     0,     0,     0,     0,     0,     0,  1064,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1633,     0,     0,     0,  2907,     0,     0,     0,     0,   660,
     660,     0,  1863,     0,     0,     0,     0,  3208,     0,  3209,
       0,     0,     0,     0,  3212,  1864,  1865,  1866,     0,  1867,
    1868,  1869,  1870,  1871,  1872,     0,     0,     0, -1994,  1064,
       0,     0,  1854,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1249,  1064,     0,     0,     0,     0,     0,
       0,     0,  1855,  1856,     0,     0,     0,     0,     0,     0,
       0,     0,   334,     0,     0, -1994,     0,     0,     0,     0,
       0,     0,     0,  1884,     0,     0,  3852,  2810,     0,     0,
       0,     0,     0,  1064,  1064,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   334,  1064,     0,   766,
       0,  1859,     0,     0,  2810,     0,     0,     0,  3096,  1064,
    2685,     0,     0,  3309,     0,  1860,     0,     0,     0,  1066,
     656,  1070,     0,   636,     0,  1090,     0,   636,   660,     0,
       0,   660,     0,   660,  1066,   636,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3302,  3303,   767,     0,     0,   660,     0,     0,   656,
       0,  1066,     0,   636,     0,     0,     0,   636,  1158,   660,
     768,     0,     0,   660,     0,  1066,     0,   636,     0,     0,
   -1994,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     660,   769,   660,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   660,     0,     0,   656,     0,     0,
     660,     0,     0,     0,   660,   660,     0,     0,     0,   660,
       0,   660,   770,   660,     0,     0,  1066,     0,   771,     0,
       0,     0,     0,     0,     0,     0,  1848,     0,  1628,     0,
       0,     0,   772,     0,     0,  1617,     0,   660,   660,     0,
       0,  1849,     0,     0,   660,     0,     0,     0,   377,  1851,
       0,     0,     0,     0,  1852,  1863,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   660,     0,   660,     0,     0,
    1259,     0,  1867,  1868,  1869,  1870,  1871,  1872,     0,     0,
       0,     0,  2379,  2995,     0,  2379,  2379,  2379,  2379,  2379,
    2379,  2379,  2379,  2379,  2379,     0,   660,   656,     0,     0,
       0,  1383,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   773,  3399,     0,     0,     0,     0,  2378,     0,
    1403,  2378,  2378,  2378,  2378,  2378,  2378,  2378,  2378,  2378,
    2378,     0,     0,     0,     0,   774,  3409,     0,  1628,     0,
       0,     0,     0,  2379,  2379,  1768,  3413,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   775,     0,     0,
       0,     0,     0,   776,     0,     0,     0,     0,     0,   777,
    1853,     0,     0,     0,  1854,   636,   636,     0,     0,  2378,
    2378,     0,     0,     0,     0,     0,     0,   660,     0,     0,
     660,     0,     0,   660,  1855,  1856,   778,   779,     0,     0,
       0,   780,     0,  3054,     0,     0,     0,  1857,     0,   781,
       0,     0,     0,     0,   782,     0,     0,  1066,  1066,     0,
       0,     0,     0,   783,     0,  1848,     0,     0,     0,     0,
       0,     0,     0,     0,   784,     0,     0,   377,     0,     0,
    1858,     0,     0,  1859,   660,     0,     0,     0,  1851,     0,
       0,     0,     0,  1852,     0,     0,  1576,  1860,     0,  1861,
       0,     0,     0,     0,     0,  1848,     0,     0,     0,   660,
       0,     0,  1909,     0,     0,   660,     0,     0,     0,   660,
    1849,     0,     0,     0,     0,     0,   660,     0,  1851,     0,
       0,     0,     0,  1852,  1066,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3518,  3519,  3520,  3521,     0,
    1066,  1576,  3387,   660,  1671,     0,     0,  2685,  2685,  2685,
    2685,  2685,  1862,     0,     0,  3400,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1066,  1066,     0,
       0,   660,     0,     0,     0,     0,     0,  2379,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3217,  1628,     0,     0,     0,     0,  1853,
       0,  1768,     0,  1854,     0,     0,     0,     0,   660,     0,
       0,     0,     0,  2378,  3228,     0,     0,   660,   910,     0,
       0,     0,   660,  1855,  1856,     0,     0,   660,  1628,     0,
       0,     0,     0,     0,     0,  1777,  1857,  1863,   660,  1853,
    1782,     0,  1628,  1854,     0,     0,     0,     0,     0,  2069,
    1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,
       0,     0,  2145,  1855,  1856,     0,     0,     0,     0,  1858,
       0,  2146,  1859,     0,     0,     0,  1857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1860,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,     0,     0,     0,
    2148,     0,     0,     0,     0,     0,     0,     0,     0,  1858,
    1628,     0,  1859,     0,     0,     0,     0,  1768,     0,     0,
       0,     0,     0,     0,     0,     0,  1860,  1628,  1861,     0,
       0,     0,     0,     0,     0,  2379,  2379,     0,     0,     0,
       0,     0,   656,   656,     0,     0,     0,     0,     0,  1620,
       0,  1862,  1628,     0,     0,     0,  1383,     0,     0,  2194,
       0,     0,     0,  1925,  1925,     0,     0,     0,     0,     0,
    3535,  2378,  2378,     0,  1934,     0,  1941,     0,     0,     0,
    3542,  3543,     0,     0,     0,  3546,  3547,     0,     0,     0,
       0,  1862,     0,     0,     0,  3554,     0,     0,     0,     0,
    1628,     0,     0,     0,     0,     0,     0,  2261,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,     0,  2069,     0,
    3686,     0,     0,   656,     0,   636,     0,     0,     0,     0,
       0,     0,     0,  3356,     0,  3358,  1863,     0,     0,     0,
       0,  1249,     0,     0,   660,     0,  1848,     0,     0,  1864,
    1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,  1620,
       0,  1849,  3722,     0,     0,     0,     0,     0,     0,  1851,
       0,     0,     0,     0,  1852,     0,  1863,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1864,
    1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,     0,
    1090,     0,  3734,     0,     0,     0,     0,     0,     0,  2851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1066,  1066,  1066,  1066,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   644,     0,     0,     0,
       0,     0,  2379,   657,     0,     0,  2379,     0,     0,     0,
       0,     0,     0,  1066,  1066,     0,     0,     0,     0,  1066,
       0,     0,     0,  1628,     0,  2379,  2379,     0,     0,     0,
    2414,     0,     0,     0,     0,     0,     0,     0,  2378,   657,
       0,     0,  2378,     0,     0,     0,     0,     0,     0,     0,
    1853,     0,     0,     0,  1854,     0,   657,   657,     0,     0,
       0,  2378,  2378,     0,     0,  2810,   657,     0,     0,     0,
     644,     0,     0,     0,  1855,  1856,     0,   636,     0,   660,
       0,  1066,  1066,  1066,  1066,     0,     0,  1857,     0,     0,
     644,     0,   644,     0,     0,  1383,     0,  1576,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   657,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   656,     0,
    1858,   660,   660,  1859,     0,     0,     0,  1090,     0,     0,
     660,   660,     0,   660,     0,     0,     0,  1860,   660,  1861,
     660,     0,     0,  1066,     0,  1620,  1066,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2379,  2379,
     660,   660,     0,     0,     0, -1991,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3540,     0,     0,  1620,
     660,     0,   660,   660,     0,     0,   660,  3549,     0,  3551,
       0,     0,  2317,  1620,  2378,  2378,     0,     0,     0,     0,
       0,     0,  1862,     0,     0,     0,     0,     0,     0,     0,
     910, -1991,     0,  2341,     0,     0,     0,  1848,     0,     0,
       0,     0,     0,  1628, -1991,     0,     0,  1628,  1628, -1991,
       0,     0,  1849,     0, -1991,     0,     0, -1991,     0, -1991,
    1851,     0,     0,     0,  1620,  1852,     0,  1090,     0,     0,
       0,     0,  1848,     0,     0,     0,     0,     0,     0,     0,
       0,  1620,     0,     0, -1991,     0,     0,  1849,     0,     0,
       0,     0,     0,     0,     0,  1851,     0,     0,  1620,     0,
    1852,     0, -1991,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,     0,     0,   657,     0,     0,     0,     0,     0,
    1864,  1865,  1866,  1620,  1867,  1868,  1869,  1870,  1871,  1872,
       0,     0,     0,     0,     0,     0,     0,   660,     0,     0,
    2898,     0,     0,     0,     0,     0, -1991,     0,  1628,  2810,
       0,     0,     0,     0, -1991,  2069,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
       0,  1620,     0,     0,     0,     0,  2679,     0,     0,     0,
       0,  1853,  1620,     0,     0,  1854,     0,  1941,     0,     0,
       0,     0, -1991,     0,     0,     0,     0,   660,     0,     0,
       0,     0,     0,     0,     0,  1855,  1856,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1853,     0,  1857,     0,
    1854,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   915,     0,     0,     0,     0,
    1855,  1856,     0,     0,     0,     0,     0,   636,     0,     0,
     660,  1858,     0,  1857,  1859,     0, -1991,     0,     0,     0,
       0,     0,   636,   660,     0,     0,   636,   656,  1860,     0,
    1861,   660,     0,     0,     0,     0, -1991,   660,     0,     0,
       0,     0,   660,   636,     0,     0,  1858,   636,   660,  1859,
       0,     0,     0,   660,     0,     0, -1991, -1991, -1991,     0,
       0,     0,     0,  1860,     0,  1861,     0,     0,     0,   636,
     660,   636,   660,     0,   660,     0,     0,  2572,  2572,     0,
       0,     0,     0,   660,  1628, -1991,     0,   657, -1991, -1991,
   -1991,  2824,     0,  1862,  1620,     0,     0,   660,     0,     0,
       0,   660,     0,     0,   636,   660,   660,   660,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2605,  2606,   660,   660,   660,   660,  2613,     0,  1862,   660,
     660,     0,     0,   660,   660,   660,     0,     0,   636,   660,
       0,     0,     0,     0,     0,   636,   660,   636,     0,   660,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1066,  1066,  1066,
    1066,  1066,  1066,     0,     0,     0,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2686,     0,
       0,  1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,
    1872,     0,     0,     0,     0,  2408,     0,     0,     0,  2572,
       0,     0,     0,  1863,     0,     0,     0,   910,     0,     0,
       0,     0,     0,     0,     0,     0,  1864,  1865,  1866,     0,
    1867,  1868,  1869,  1870,  1871,  1872,     0,  2720,     0,     0,
    3093,     0,  2733,     0,  2739,     0,     0,     0,     0,     0,
       0,     0,  1671,     0,     0,     0,     0,     0,     0,     0,
    2762,     0,     0,     0,  2762,  2775,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1066,
    2572,  1066,  2572,     0,     0,     0,     0,  1848,   644,     0,
    1116,     0,     0,     0,  1620,     0,     0,     0,  1620,  1620,
       0,     0,  1849,     0,     0,     0,     0,   660,     0,     0,
    1851,     0,     0,  1628,  1628,  1852,  1628,     0,  1848,     0,
       0,     0,  1117,   636,     0,     0,     0,  1176,   657,  1628,
     657,  1628,     0,  1849,  1118,     0,  3018,     0,  3021,     0,
       0,  1851,     0,     0,  1119,     0,  1852,   660,     0,     0,
     636,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1628,  1120,     0,     0,     0,     0,     0,  3032,     0,   657,
       0,     0,     0,   644,     0,   644,     0,   644,     0,     0,
       0,     0,  1121,   644,   644,     0,     0,     0,     0,     0,
       0,     0,   657,     0,     0,     0,     0,     0,     0,  1620,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1628,
     644,     0,     0,  1122,     0,     0,  3058,     0,     0,     0,
    1620,     0,  2901,     0,     0,     0,     0,     0,     0,     0,
    1628,  1853,     0,  1123,     0,  1854,     0,   644,     0,     0,
       0,     0,     0,     0,   657,   657,     0,     0,   644,   644,
       0,  1090,     0,     0,     0,  1855,  1856,  1124,     0,     0,
    1628,     0,  1853,     0,     0,     0,  1854,     0,  1857,     0,
       0,     0,     0,     0,     0,  1628,     0,     0,     0,     0,
       0,     0,  3146,     0,     0,     0,  1855,  1856,  1628,     0,
       0,     0,     0,     0,  1925,  3032,     0,     0,     0,  1857,
    1941,  1858,  1628,     0,  1859,     0,     0,     0,     0,   644,
       0,     0,     0,  1125,   660,     0,     0,     0,  1860,     0,
    1861,     0,     0,   644,   644,     0,     0,     0,     0,     0,
       0,     0,  1858,     0,     0,  1859,   774,  1628,     0,   636,
     660,   660,     0,  1628,  3200,     0,     0,     0,     0,  1860,
    2069,  1861,     0,  2739,     0,     0,     0,     0,  1126,     0,
       0,     0,  1127,     0,  1128,     0,     0,     0,     0,     0,
    1129,     0,     0,     0,     0,  1620,     0,     0,     0,     0,
       0,     0,     0,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,   660,   660,  1628,     0,     0,  1130,  1131,     0,
       0,  3234,  1132,     0,     0,     0,     0,     0,     0,     0,
    1133,     0,  1628,  1066,  1862,  1134,     0,     0,     0,  3239,
       0,     0,     0,     0,     0,     0,   660,   660,   660,   660,
     644,     0,     0,     0,     0,  1135,     0,     0,     0,  1628,
       0,     0,     0,     0,     0,     0,  3261,  1622,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   636,
     660,     0,     0,     0,     0,     0,     0,     0,  1863,  2572,
    2572,     0,  1628,     0,     0,     0,     0,     0,     0,  1768,
       0,  1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,
    1872,     0,     0,     0,  2686,  3277,     0,     0,     0,  1863,
       0,   644,     0,     0,     0,     0,     0,     0,   660,   660,
     660,     0,  1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,
    1871,  1872,     0,  1848,     0,     0,  3323,     0,     0,  1743,
       0,     0,  1747,   660,     0,     0,     0,     0,  1849,     0,
       0,     0,   657,     0,     0,     0,  1851,     0,     0,     0,
     750,  1852,     0,   660,     0,     0,     0,  1622,  1383,     0,
       0,     0,     0,     0,     0,   656,     0,     0,   660,  2762,
       0,     0,  3182,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3195,     0,     0,     0,     0,
    1628,   750,     0,     0,     0,     0,     0,  3349,     0,     0,
       0,     0,     0,     0,  1620,  1620,     0,  1620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   636,
    1620,     0,  1620,     0,     0,   644,  2317,     0,     0,     0,
       0,     0,     0,     0,     0,   644,     0,     0,   939,     0,
     636,     0,     0,     0,     0,   939,     0,   939,     0,     0,
       0,  1620,     0,     0,     0,  1848,  1887,     0,   750,     0,
     657,   657,     0,     0,     0,     0,     0,  1853,     0,     0,
    1849,  1854,     0,     0,   644,     0,     0,   644,  1851,     0,
       0,   644,   644,  1852,     0,     0,     0,     0,     0,  1628,
       0,  1855,  1856,     0,     0,     0,  3411,     0,     0,     0,
    1620,     0,     0,     0,  1857,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1620,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1858,     0,     0,
    1859,   657,     0,   644,     0,     0,     0,     0,     0,     0,
       0,  1620,     0,     0,  1860,     0,  1861,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1620,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1993,     0,     0,  1620,
       0,  1941,     0,  1622,     0,     0,     0,     0,   644,     0,
       0,     0,     0,  1620,   644,     0,     0,     0,     0,  1853,
       0,     0,     0,  1854,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2739,  2739,     0,     0,  1622,     0,  1862,
       0,     0, -1993,  1855,  1856,     0,     0,     0,  1620,     0,
       0,  1622,     0,     0,  1620, -1993,  1857,     0,     0,     0,
   -1993,     0,  1628,     0,     0, -1993,     0,     0, -1993,  1768,
   -1993,     0,     0,     0,     0,   660,     0,     0,     0,   636,
     660,   636,   660,   660,   660,   660,     0,     0,     0,  1858,
     644,     0,  1859,     0,     0, -1993,     0,     0,     0,     0,
       0,     0,  1622,     0,     0,  1620,  1860,     0,  1861,  1628,
       0,     0,     0, -1993,     0,     0,  3544,     0,     0,  1622,
       0,     0,     0,  1620,  1863,     0,     0,     0,     0,     0,
       0,  2686,  2686,  2686,  2686,  2686,  1622,  1864,  1865,  1866,
       0,  1867,  1868,  1869,  1870,  1871,  1872,     0,     0,     0,
    1620,  3486,     0,     0,   660,     0,     0, -1993,     0,     0,
       0,  1622,     0,     0,     0, -1993,     0,     0,     0,     0,
       0,  1862,     0,   644,     0,     0,     0,  2720,     0,     0,
       0,  2605,   644,  1620,  2605,     0,  3427,     0,     0,  1848,
       0,     0,     0,  2739,     0,     0,     0,     0,     0,  2572,
       0,     0,     0, -1993,     0,     0,     0,     0,     0,  1622,
       0,     0,  1851,  2762,     0,   660,     0,  1852,     0,     0,
    1622,     0,     0,     0,     0,     0,  2720,     0,  3466,  2071,
     660,     0,     0,     0,  2572,     0,  2572,     0,     0,   657,
       0,  1628,     0,     0,     0,     0,   915,     0,  3146,     0,
       0,   636,     0,  1887,  2300,     0,  1863,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1993,     0,  1864,
    1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,     0,
       0,  2072,     0,  3517,     0,     0,     0, -1993,     0,  2073,
    2074,     0,     0,     0,     0,     0,     0,     0,     0,  2918,
       0,  1620,     0,     0,     0,   644,   644, -1993, -1993, -1993,
       0,     0,   644,   644,     0,     0,     0,   644,   644,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2075,     0,   644, -1994,   644,     0, -1993,  1854,     0, -1993,
   -1993, -1993,     0,     0,     0,     0,     0,     0,     0,  1090,
       0,     0,     0,     0,   644,     0,   644,  1855,  1856,     0,
       0,     0,   636,   660,     0,     0,     0,     0,     0,     0,
   -1994,  2076,  1622,   636,   660,   636,  2077,     0,     0,     0,
    3555,     0,     0,   660,   660,  1066,   660,     0,  1743,     0,
       0,     0,     0,     0,     0,  2475,     0,     0,     0,     0,
    1620,     0,     0,  2300,     0,     0,  1859,     0,     0,     0,
    2739,     0,     0,  2078,   750,     0,     0,     0,     0,   644,
    1860,     0,  1061,     0,     0,     0,  1061,     0,     0,     0,
    2079,  2080,     0,  2081,  2082,     0,  2083,     0,     0,     0,
       0,     0,     0,  1628,     0,     0,     0,  1628,  1628,     0,
    1768,     0,     0,     0,  1768,  1768,     0,     0,     0,  1061,
       0,   660,     0,     0,     0,     0,  2084,     0,   660,     0,
       0,     0,     0,     0,  3622,  1848,     0,     0,     0,     0,
       0,     0,     0,  3626,     0, -1994,   660,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3466,     0,  1851,  2085,
       0,   644,  1848,  1852,     0,   644,     0,  1061,   657,  3427,
       0,     0,     0,  1061,  1628,   636,     0,  1849,     0,     0,
       0,  2069,     0,     0,     0,  1851,     0,     0,     0,     0,
    1852,     0,     0,     0,  2086,     0,  2087,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1848,     0,     0,     0,
       0,     0,     0,  1620,     0,     0,     0,     0,  2088,     0,
       0,  1849,     0,     0,     0,  2089,     0,     0,  2090,  1851,
    1863,     0,  1622,     0,  1852,  1090,  1622,  1622,     0,     0,
       0,     0,     0,     0,     0,  3292,     0,  1867,  1868,  1869,
    1870,  1871,  1872,     0,     0,     0,     0,   644,     0,  1848,
    1620,     0,     0,  2739,     0,     0,   644,     0,  1061,   644,
     644,     0,     0,   939,  1849,     0,   939,     0,     0, -1994,
       0,     0,  1851,  1854,  2572,     0,  2605,  1852,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1061,
       0,     0,     0,  1855,  1856,     0,  1853,     0,  1066,  3622,
    1854,     0,     0,  1066,  1066,     0, -1994,     0,     0,     0,
       0,     0,   660,     0,   644,     0,     0,     0,     0,     0,
    1855,  1856,   644,     0,     0,     0,   644,  1622,     0,     0,
       0,     0,     0,  1857,     0,     0,   644,     0,     0,     0,
    1853,   644,  1859,     0,  1854,     0,     0,     0,  1622,     0,
       0,     0,     0,     0,     0,     0,  1860,     0,  1066,  1066,
    1066,  1066,   660,     0,  1855,  1856,  1858,     0,     0,  1859,
       0,     0,     0,     0,     0,  1623,     0,  1857,     0,     0,
     660,     0,  1620,  1860,     0,  1861,     0,     0,     0,     0,
       0,     0,     0,  1853,     0,   644,     0,  1854,     0,  3622,
    1066,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1858,     0,     0,  1859,     0,  1061,   750,  1855,  1856,     0,
       0, -1994,  1061,     0,     0,     0,     0,  1860,  1061,  1861,
    1857,     0,     0,     0,     0,     0,     0,     0,     0,   660,
    1066,   644,     0,     0,     0,     0,     0,  1066,  1862,  1631,
       0,     0,     0,     0,     0,   657,  1743,     0,     0,  2803,
       0,  1747,     0,  1858,  1066,     0,  1859,     0,     0,     0,
       0,     0,     0,     0,     0,  3817,  1061,     0,     0,     0,
    1860,     0,  1861,     0,     0,  1623,     0,     0,     0,     0,
       0,     0,  1862,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,  1863,     0,     0,     0,
       0,     0,     0,     0,  3817,     0,     0,     0,     0,     0,
       0,     0,     0,  1867,  1868,  1869,  1870,  1871,  1872,     0,
       0,     0,  1061,  1863,     0,     0,     0,     0,     0,     0,
    3817,     0,     0,     0,     0,  1862,  1864,  1865,  1866,     0,
    1867,  1868,  1869,  1870,  1871,  1872,     0,     0,     0,  1631,
    3651,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
    1061,     0,     0,     0,  1620,     0,     0,     0,  1620,  1620,
    1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,
       0,     0,     0,     0,  3688,     0,  1061,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1863,     0,     0,     0,     0,     0,  1061,  1061,  2300,  1061,
     644,     0,   644,  1864,  1865,  1866,     0,  1867,  1868,  1869,
    1870,  1871,  1872,     0,     0,  1620,  1061,  3765,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1623,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1061,     0,     0,  1061,  1061,
       0,     0,  1622,  1622,     0,  1622,     0,     0,   644,     0,
       0,     0,     0,     0,     0,  1623,     0,     0,  1622,     0,
    1622,     0,     0,     0,     0,   644,     0,     0,     0,  1623,
       0,     0,   644,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1622,
       0,     0,     0,     0,     0,  1631,     0,     0,     0,   750,
       0,     0,     0,   939,     0,     0,     0,     0,     0,     0,
       0,     0,  1848,   793,     0,     0,     0,     0,     0,     0,
    1623,     0,   939,   644,     0,   644,   644,  1849,     0,  1631,
       0,     0,  1625,     0,     0,  1851,     0,  1623,  1622,   644,
    1852,     0,     0,  1631,     0,   644,     0,     0,     0,     0,
     644,     0,   644,     0,  1623,     0,     0,     0,     0,  1622,
       0,     0,     0,     0,   644,   644,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   644,     0,     0,     0,  1623,
    1848,     0,     0,     0,     0,     0,     0,   644,     0,  1622,
       0,   657,     0,     0,  1631,     0,     0,     0,   793,     0,
       0,     0,     0,  1851,  1622,     0,     0,     0,  1852,     0,
       0,  1631,     0,     0,     0,   644,   644,  1622,     0,     0,
       0,     0,     0,     0,     0,     0,   657,  1623,  1631,     0,
       0,  1622,     0,     0,     0,     0,     0,     0,  1623,     0,
       0,     0,  1625,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,     0,  1853,   750,     0,     0,
    1854,     0,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,     0,  1622,     0,     0,     0,     0,     0,     0,     0,
    1855,  1856,     0,     0,     0,     0,     0,     0,     0,     0,
    3293,     0,     0,  1857,     0,     0,  1061,     0,  1061,     0,
       0,  1631,     0,  1061,     0,     0,     0,     0,     0,     0,
    1848,     0,  1631,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622, -1994,  1849,  1858,     0,  1854,  1859,
       0,     0,     0,  1851,     0,     0,     0,     0,  1852,     0,
       0,  1622,     0,  1860,     0,  1861,     0,     0,  1855,  1856,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1994,     0,     0,     0,  1061,     0,     0,  1622,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1623,     0,     0,     0,     0,     0,     0,  1859,     0,  1061,
    1061,  1622,     0,     0,     0,     0,     0,  1061,  1862,     0,
    1061,  1860,     0,  1061,     0,     0,     0,     0,     0,     0,
       0,  1061,  1061,     0,     0,     0,     0,     0,     0,  1061,
       0,     0,  1061,  1061,  1061,  1061,     0,     0,     0,     0,
       0,     0,  1061,  1061,     0,  1061,     0,  1061,     0,     0,
    1061,     0,     0,     0,  1853,     0,     0,     0,  1854,     0,
       0,     0,     0,     0,  1631,  1061,   750,     0,  1625,  1061,
       0,     0,     0,  1061,     0,     0, -1994,  1061,  1855,  1856,
    1061,  1061,  1061,  1061,  1061,  1061,  1061,  1061,  1061,     0,
    1061,  1857,     0,  1863,     0,  1061,     0,  1848,     0,  1061,
       0,     0,  1625,     0,     0,     0,  1864,  1865,  1866,     0,
    1867,  1868,  1869,  1870,  1871,  1872,  1625,     0,  3056,  1622,
    1851,     0,     0,     0,  1858,  1852,     0,  1859,     0,     0,
       0,     0,     0,     0,   644,   644,   644,   644,   644,   644,
       0,  1860,     0,  1861,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3270,     0,
    1061,  1863,     0,     0,   644,     0,     0,  1625,     0,   644,
     644,   644,   644,   644,     0,     0,     0,   644,  1867,  1868,
    1869,  1870,  1871,  1872,  1625,     0,     0,     0,     0,     0,
    1623,     0,     0,     0,  1623,  1623,     0,     0,     0,     0,
       0,  1625,     0,     0,     0,     0,  1862,  3296,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1622,  3271,
       0,     0,     0,     0,     0,     0,  1625,     0,     0,   750,
       0,     0,     0,     0,     0,   644,     0,     0,     0,     0,
       0, -1994,     0,     0,  1061,  1854,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,  1855,  1856,     0,  1631,  1631,
       0,     0,     0,     0,  1625,     0,     0,     0, -1994,     0,
       0,     0,     0,     0,  2803,  1625,     0,     0,     0,     0,
       0,  1863,     0,     0,     0,  1623,     0,     0,     0,     0,
       0,     0,     0,     0,  1864,  1865,  1866,     0,  1867,  1868,
    1869,  1870,  1871,  1872,  1859,     0,  1623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1860,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1056,     0,     0,     0,  1056,     0,   793,     0,     0,     0,
       0,   793,   793,     0,     0,     0,     0,     0,   793,     0,
       0,     0,  1061,     0,     0,     0,     0,     0,     0,  1631,
       0,  1622,     0,     0,     0,   793,     0,  1056,     0,     0,
       0,  2300,   644,     0,     0,     0,     0,     0,  1061,     0,
    1631,     0,   644, -1994,     0,     0,     0,     0,     0,     0,
       0,     0,   644,   644,     0,     0,     0,   644,   644,     0,
       0,     0,     0,     0,     0,     0,     0,   644,  1622,     0,
     793,     0,     0,     0,     0,  1056,     0,     0,     0,     0,
       0,  1056,     0,  1848,   644,   644,   644,  1625,     0,     0,
       0,     0,     0,     0,   644,   644,     0,     0,  1849,   644,
       0,     0,  2497,     0,     0,     0,  1851,     0,     0,     0,
       0,  1852,     0,  1061,     0,     0,     0,     0,     0,     0,
       0,  1623,     0,  1061,     0,     0,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,   793,     0,     0,   644,     0,
     793,     0,     0,     0,     0,  1867,  1868,  1869,  1870,  1871,
    1872,   793,     0,     0,     0,  1061,     0,     0,     0,     0,
       0,     0,     0,   644,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2498,     0,     0,     0,
     793,     0,     0,     0,  1061,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1631,   793,     0,     0,     0,
    1622,   793,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1061,  1061,     0,   793,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1853,     0,     0,
       0,  1854,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1061,     0,     0,     0,  1061,     0,     0,     0,
       0,  1855,  1856,     0,     0,     0,     0,     0,  1061,  1061,
    1061,  1061,     0,     0,  1857,   659,   750,     0,     0,     0,
    1061,   750,     0,     0,   661,  1061,     0,     0,     0,     0,
       0,     0,     0,   644,     0,  1061,  1061,  1625,  1061,     0,
       0,  1625,  1625,     0,     0,     0,     0,  1858,     0,     0,
    1859,  1061,     0,  1061,     0,     0,     0,  1061,   790,     0,
       0,     0,     0,     0,  1860,     0,  1861,   841,     0,     0,
     845,     0,     0,  1061,     0,     0,   841,     0,     0,     0,
     897,     0,     0,  1061,   644,  1061,  1061,   793,     0,     0,
    1056,     0,     0,     0,     0,     0,  1056,     0,     0,     0,
    1623,  1623,   918,  1623,     0,     0,  1061,     0,     0,     0,
       0,     0,  1061,     0,     0,     0,  1623,   841,  1623,     0,
    1626,  1061,  1061,  1061,     0,     0,     0,     0,     0,  1862,
       0,     0,     0,     0,     0,     0,     0,     0,   793,   793,
     793,     0,  1625,     0,  1056,     0,     0,  1623,     0,     0,
       0,     0,  1622,  1061,     0,     0,  1622,  1622,  1627,     0,
       0,     0,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,  1631,  2499,  1631,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,  1631,     0,     0,     0,  1623,  1848,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1863,     0,     0,  1623,   793,     0,
    1851,  1631,     0,  1622,     0,  1852,     0,  1864,  1865,  1866,
    1626,  1867,  1868,  1869,  1870,  1871,  1872,     0,     0,   793,
       0,     0,     0,     0,     0,     0,     0,  1623,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1623,   644,     0,     0,     0,     0,  1627,     0,
    1631,     0,     0,     0,     0,  1623,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1623,
       0,  1631,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   644,     0,  1027,     0,     0,  3515,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1625,     0,
     750,  1631,     0,     0,  1623,     0,     0,     0,   644,     0,
    1623,     0,     0,     0,     0,     0,  1631,     0,     0,     0,
       0, -1994,     0,     0,     0,  1854,     0,     0,     0,  1631,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1631,     0,  1855,  1856,     0,     0,     0,
       0,     0,     0,     0,   793,     0,     0,     0, -1994,  1061,
       0,  1623,     0,  1061,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1061,     0,   851,     0,     0,  1631,  1623,
       0,     0,     0,     0,  1631,     0,     0,   852,     0,     0,
       0,     0,     0,     0,  1859,     0,     0,     0,     0,     0,
       0,     0,  1061,     0,     0,     0,  1623,   853,  1860,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   854,
       0,     0,  1061,     0,     0,  1631,  1626,     0,     0,  1623,
       0,  1061,     0,     0,     0,     0,   855,  1061,     0,  1061,
       0,     0,     0,  1631,  1061,     0,     0,  1061,  1061,  1061,
    1061,  1061,  1061,  1061,  1061,  1061,  1061,   856,     0,     0,
    1626,  1061,  1061, -1994,  1627,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,  1626,  1061,     0,     0,     0,   750,
       0,  1061,     0,     0,     0,     0,   793,     0,   857,     0,
    1061,     0,     0,  1061,   858,  1061,     0,     0,  1627,   793,
       0,     0,     0,  1631,  1061,  1061,  1061,     0,   859,     0,
    1061,     0,  1627,  1061,     0,     0,     0,  1625,  1625,     0,
    1625,     0,     0,  1061,     0,  1626,     0,     0,     0,     0,
       0,     0,     0,  1625,     0,  1625,     0,  1035,  1036,     0,
       0,     0,  1626,     0,     0,     0,     0,  1623,  1863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1626,
       0,     0,     0,  1627,  1625,  1867,  1868,  1869,  1870,  1871,
    1872,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1627,     0,     0,     0,  1626,     0,     0,     0,   860,     0,
       0,     0,     0,     0,     0,     0,   861,  1627,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   774,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,  1631,  1627,     0,  2255,     0,  1056,     0,     0,     0,
       0,  1056,  1626,   862,  1625,     0,     0,   863,     0,   864,
       0,     0,     0,  1626,   793,   865,  1623,     0,     0,     0,
       0,   793,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1625,     0,  1092,     0,     0,  1096,
    1627,  1098,   866,   867,     0,     0,     0,   868,     0,  1625,
       0,  1627,     0,     0,     0,   869,     0,     0,     0,     0,
     870,     0,  1625,  1056,  1142,     0,   793,   793,     0,   871,
       0,     0,     0,     0,     0,     0,  1625,  1159,   793,  1061,
     872,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,     0,     0,     0,     0,  1027,     0,
     841,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1625,  1185,     0,     0,     0,     0,  1625,  1630,     0,
       0,     0,     0,  1203,     0,     0,     0,  1205,     0,  1208,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1061,     0,     0,     0,     0,  1061,     0,     0,  1061,
       0,     0,     0,     0,     0,  1237,  1238,     0,     0,     0,
       0,     0,  1027,     0,     0,  1626,     0,     0,  1625,  1623,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1256,     0,  1257,  1625,  1061,     0,     0,
       0,     0,   793,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1625,  1027,     0,  1623,     0,     0,     0,
       0,     0,     0,  1061,     0,     0,     0,     0,  1630,     0,
    1061,  1061,     0,     0,     0,     0,     0,  1061,  1061,     0,
       0,     0,  1061,  1631,     0,     0,  1625,     0,  1061,  1061,
       0,     0,  1061,     0,     0,     0,   793,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1631,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1471,     0,     0,  1473,     0,
       0,  1475,     0,  1848,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1849,     0,
       0,     0,     0,     0,     0,     0,  1851,     0,     0,     0,
       0,  1852,     0,     0,     0,     0,     0,     0,  1623,     0,
       0,     0,     0,     0,     0,     0,     0,  1061,     0,     0,
       0,     0,  1562,     0,  1625,  1626,     0,     0,     0,  1626,
    1626,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1584,     0,     0,
       0,     0,     0,  1586,     0,     0,     0,  1588,  1061,     0,
       0,     0,     0,  1627,  1634,     0,     0,  1627,  1627,     0,
       0,     0,     0,  1061,     0,     0,     0,  1061,     0,     0,
       0,     0,  1631,     0,     0,     0,     0,     0,     0,     0,
       0,  1668,     0,     0,   793,     0,     0,  2875,     0,     0,
       0,     0,  2876,     0,  1061,     0,     0,     0,  1061,     0,
       0,     0,     0,     0,  1630,     0,     0,  1853,     0,     0,
       0,  1854,     0,  1625,     0,     0,     0,  1061,  1061,  1848,
    1626,  1061,     0,     0,     0,     0,     0,     0,  1061,  1061,
       0,  1855,  1856,     0,  1849,     0,     0,  1850,  2056,     0,
       0,  1626,  1851,     0,  1857,     0,  1737,  1852,  1061,     0,
       0,     0,  1630,     0,     0,     0,     0,     0,  1627,     0,
    1766,     0,  1061,     0,     0,   793,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1858,     0,  1627,
    1859,     0,     0,     0,     0,     0,     0,  1061,     0,     0,
       0,     0,     0,   793,  1860,     0,  1861,     0,     0,     0,
    1623,   793,     0,  1630,  1623,  1623,     0,     0,     0,   937,
       0,  2255,     0,     0,     0,     0,   937,     0,   937,     0,
    1630,     0,     0,  1061,  1061,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1061,  1061,     0,  1061,     0,  1061,     0,     0,     0,  1862,
       0,     0,  1630,  1853,     0,     0,  1625,  1854,     0,     0,
       0,  1623,     0,     0,  1631,     0,     0,     0,  1631,  1631,
       0,     0,     0,     0,     0,     0,     0,  1855,  1856,     0,
       0,     0,     0,     0,     0,     0,  1626,     0,     0,     0,
    1857,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1630,     0,     0,  1625,     0,     0,     0,     0,     0,     0,
       0,  1630,     0,  1061,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1858,  1627,     0,  1859,     0,     0,     0,
       0,     0,     0,     0,  1863,  1631,     0,     0,     0,     0,
    1860,     0,  1861,     0,     0,     0,     0,  1864,  1865,  1866,
       0,  1867,  1868,  1869,  1870,  1871,  1872,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2002,     0,  1061,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1862,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   793,     0,     0,     0,     0,
       0,  2255,     0,     0,     0,     0,     0,     0,  1061,  1061,
       0,     0,     0,     0,     0,  1625,     0,     0,     0,     0,
       0,     0,  1061,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1061,     0,     0,     0,     0,     0,
       0,     0,     0,  1630,     0,  1848,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1849,     0,     0,  2839,     0,     0,     0,     0,  1851,     0,
    1863,     0,     0,  1852,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1864,  1865,  1866,     0,  1867,  1868,  1869,
    1870,  1871,  1872,     0,     0,  1626,  1626,     0,  1626,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1626,     0,  1626,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2213,     0,     0,
       0,     0,     0,  1627,  1627,     0,  1627,     0,     0,     0,
       0,     0,  1626,     0,     0,     0,     0,     0,     0,  1627,
       0,  1627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2266,     0,     0,     0,     0,     0,     0,     0,     0,  2275,
    1627,  2277,     0,     0,     0,     0,  2278,     0,     0,  1853,
       0,  1626,     0,  1854,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2293,   841,
       0,     0,  1626,  1855,  1856,     0,     0,  1625,     0,     0,
       0,  1625,  1625,     0,     0,     0,  1857,     0,     0,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1626,  2556,     0,     0,     0,  2056,  2563,   793,
    1627,     0,     0,     0,     0,     0,     0,  1626,   793,  1858,
       0,     0,  1859,     0,     0,     0,     0,     0,     0,     0,
    1626,     0,     0,     0,     0,     0,  1860,   793,  1861,     0,
    1627,  1848,     0,     0,  1626,     0,     0,     0,  1625,     0,
       0,     0,     0,     0,     0,  1627,  1849,  2255,     0,     0,
       0,  2255,     0,     0,  1851,     0,     0,     0,  1627,  1852,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1626,
       0,     0,  1627,     0,   793,  1626,   793,     0,     0,     0,
       0,   793,     0,     0,     0,     0,     0,     0,     0,     0,
    1056,  1862,     0,  1058,     0,     0,     0,  1058,  1630,     0,
       0,     0,     0,     0,     0,     0,     0,  1627,     0,     0,
     793,     0,     0,  1627,     0,  2474,     0,     0,     0,  1630,
       0,     0,     0,     0,     0,     0,  1626,     0,     0,     0,
    1058,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1626,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,     0,     0,     0,     0,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,  1626,     0,     0,     0,  1853,  1863,     0,  1058,  1854,
       0,     0,  1627,     0,  1058,     0,     0,     0,     0,  1864,
    1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,  1855,
    1856,     0,     0,     0,  1626,     0,     0,     0,     0,  1627,
       0,     0,  1857,     0,     0,     0,     0,     0,   793,   793,
       0,     0,     0,     0,     0,     0,     0,     0,  1027,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2531,  1627,     0,     0,  1858,     0,     0,  1859,  2538,
       0,     0,     0,     0,     0,  2542,     0,     0,     0,     0,
    2546,     0,  1860,     0,  1861,     0,  2552,     0,     0,     0,
       0,  2554,     0,     0,  1630,  2853,     0,     0,     0,  1058,
       0,     0,     0,     0,   937,     0,     0,   937,     0,     0,
    2568,     0,  2569,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   643,     0,     0,     0,     0,
    1058,     0,     0,   898,     0,     0,     0,     0,     0,     0,
       0,     0,  1626,  2590,  2591,  2592,     0,  1862,     0,     0,
       0,     0,     0,     0,     0,   898,     0,     0,     0,     0,
    2607,  2608,  2611,  2612,     0,     0,     0,  2618,  2621,     0,
       0,  2623,  2624,  2625,     0,     0,     0,  2631,     0,     0,
    1627,     0,     0,     0,  2644,     0,     0,  2646,     0,     0,
       0,     0,     0,     0,  1848,     0,     0,     0,     0,   901,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1849,
     793,     0,  2884,     0,     0,     0,     0,  1851,     0,   643,
       0,   901,  1852,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1863,   793,     0,     0,     0,     0,     0,     0,
       0,  1626,     0,   793,     0,  1864,  1865,  1866,     0,  1867,
    1868,  1869,  1870,  1871,  1872,     0,  1058,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,     0,     0,  1058,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1627,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2255,
    1629,     0,     0,     0,  2255,     0,     0,  2255,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,  2056,  2563,     0,  2563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1853,  1630,
       0,  1630,  1854,     0,     0,  1027,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1855,  1856,     0,     0,     0,     0,     0,     0,
    1630,     0,     0,  1058,     0,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2825,     0,     0,     0,     0,
       0,     0,     0,     0,  1626,     0,     0,     0,     0,     0,
    1629,     0,   793,   793,   793,   793,     0,     0,  1858,     0,
       0,  1859,     0,     0,     0,     0,     0,     0,     0,  1630,
       0,  1058,     0,     0,     0,  1860,     0,  1861,     0,     0,
       0,     0,  1627,     0,     0,     0,     0,     0,     0,     0,
    2563,  1626,     0,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2563,     0,     0,     0,     0,     0,  1848,  1058,  1058,  1627,
    1058,     0,     0,     0,     0,  1630,     0,     0,     0,     0,
    1862,  1849,     0,     0,     0,     0,     0,  1058,  1630,  1851,
       0,     0,     0,     0,  1852,     0,     0,     0,     0,     0,
       0,     0,  2563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1056,  1630,     0,     0,
       0,     0,     0,  1630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2255,  1058,     0,     0,  1058,
    1058,     0,     0,  1626,     0,  1863,     0,     0,  2996,  2997,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,  1865,
    1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,     0,     0,
       0,     0,     0,     0,  1630,  2889,     0,     0,     0,     0,
       0,  1627,     0,     0,     0,     0,     0,     0,     0,     0,
    1853,     0,  1630,     0,  1854,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,   937,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1855,  1856,  1056,     0,     0,  1630,
       0,     0,     0,   937,     0,     0,     0,  1857,     0,     0,
    1629,     0,     0,     0,  3039,  3040,  3041,  3042,     0,     0,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
       0,     0,  1630,     0,     0,  1056,     0,   793,     0,     0,
    1858,     0,     0,  1859,     0,     0,     0,     0,  3055,     0,
       0,     0,     0,     0,     0,     0,     0,  1860,   793,  1861,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1056,     0,     0,     0,  1629,     0,     0,     0,   793,
       0,     0,     0,     0,     0,     0,     0,  1848,     0,     0,
       0,     0,  1629,     0,     0,     0,  3116,  3118,  3120,     0,
       0,     0,  1849,     0,     0,  2893,     0,     0,     0,  1629,
    1851,     0,     0,     0,     0,  1852,     0,     0,     0,   793,
       0,   841,  1862,     0,     0,  1626,     0,     0,     0,  1626,
    1626,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
       0,  3164,     0,     0,     0,     0,     0,     0,     0,     0,
    1630,     0,     0,     0,     0,     0,   841,     0,     0,     0,
       0,     0,     0,  1627,     0,     0,     0,  1627,  1627,     0,
       0,  1056,     0,     0,     0,     0,     0,  1058,     0,  1058,
       0,     0,  1629,     0,  1058,     0,     0,   643,     0,     0,
       0,     0,     0,  1629,     0,     0,  1626,     0,     0,    73,
       0,     0,     0,     0,     0,     0,   898,  1863,   898,     0,
     898,     0,     0,     0,     0,     0,   898,   898,     0,     0,
    1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,
    1848,  1853,  1056,     0,  1627,  1854,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1849,  1058,  1056,     0,  1630,
       0,     0,     0,  1851,     0,  1855,  1856,     0,  1852,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1857,     0,
       0,     0,   901,     0,   901,     0,   901,     0,     0,     0,
    1058,  1058,   901,   901,     0,     0,  1056,     0,  1058,     0,
       0,  1058,     0,     0,  1058,     0,     0,     0,     0,     0,
    1056,  1858,  1058,  1058,  1859,     0,     0,     0,     0,   643,
    1058,     0,  1056,  1058,  1058,  1058,  1058,     0,  1860,     0,
    1861,     0,     0,  1058,  1058,     0,  1058,     0,  1058,     0,
       0,  1058,     0,     0,     0,     0,   643,     0,     0,     0,
       0,     0,  1445,     0,     0,  1629,  1058,   643,   643,     0,
    1058,     0,     0,     0,  1058,     0,     0,     0,  1058,     0,
    1445,  1058,  1058,  1058,  1058,  1058,  1058,  1058,  1058,  1058,
       0,  1058,     0,     0,  1853,     0,  1058,     0,  1854,     0,
    1058,     0,     0,  1862,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1855,  1856,
       0,     0,  1630,     0,  1848,     0,     0,     0,  1449,     0,
       0,  1857,     0,     0,     0,     0,     0,     0,     0,  1849,
       0,     0,   643,   643,     0,     0,  1449,  1851,     0,     0,
       0,     0,  1852,     0,     0,     0,     0,     0,     0,     0,
       0,  1058,     0,  3350,  1858,     0,     0,  1859,  3357,  1630,
    3359,  3360,  3361,  3362,     0,     0,     0,     0,     0,     0,
       0,  1860,     0,  1861,     0,     0,     0,     0,  1863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1864,  1865,  1866,     0,  1867,  1868,  1869,  1870,  1871,
    1872,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3402,     0,     0,  1058,  1862,     0,     0,   643,
       0,     0,     0,     0,     0,     0,     0,     0,    73,    73,
       0,    73,     0,     0,     0,  1629,     0,     0,  1853,  1629,
    1629,  3231,  1854,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1855,  1856,     0,     0,     0,     0,     0,     0,
       0,  1630,     0,     0,     0,  1857,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3469,     0,
     643,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1863,     0,     0,     0,     0,     0,     0,  1858,     0,
       0,  1859,     0,     0,  1864,  1865,  1866,     0,  1867,  1868,
    1869,  1870,  1871,  1872,     0,  1860,     0,  1861,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1058,
       0,  1629,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1445,     0,     0,     0,  1445,  1445,     0,     0,     0,     0,
       0,     0,     0,     0,   643,     0,     0,     0,     0,     0,
       0,  3541,     0,     0,   643,     0,     0,     0,     0,     0,
       0,     0,  3550,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1989,     0,     0,
       0,     0,     0,   643,     0,     0,  1449,     0,     0,     0,
    1449,  1449,     0,  1630,     0,  1863,  1058,  1630,  1630,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1864,  1865,
    1866,     0,  1867,  1868,  1869,  1870,  1871,  1872,     0,     0,
       0,     0,     0,     0,     0,  1058,     0,     0,     0,     0,
       0,  1445,     0,     0,     0,     0,  1629,  1445,     0,  3609,
       0,     0,     0,     0,     0,     0,  3164,     0,     0,     0,
       0,     0,   643,  1058,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,   803,  1630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   804,     0,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,     0,     0,   805,     0,  1449,     0,  1058,
    1058,  1058,  1058,  1449,     0,     0,     0,     0,     0,     0,
       0,  1058,     0,  1445,   806,     0,  1058,  -513,     0,     0,
       0,     0,     0,     0,     0,     0,  1058,  1058,     0,  1058,
       0,     0,     0,     0,   807,     0,     0,     0,     0,     0,
     808,     0,  1058,     0,  1058,     0,     0,     0,  1058,     0,
       0,     0,     0,     0,     0,   809,     0,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,  1058,  1058,     0,  1449,
       0,     0,     0,     0,     0,     0,  -666,     0,   810,     0,
       0,     0,   811,     0,     0,     0,     0,  1058,     0,     0,
       0,     0,     0,  1058,     0,   898,  -646,     0,     0,     0,
       0,     0,  1058,  1058,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -424,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     812,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
      73,     0,     0,     0,    73,     0,     0,     0,     0,     0,
       0,     0,   643,     0,     0,  1629,  1629,     0,  1629,     0,
       0,   901,     0,     0,     0,     0,     0,  2298,     0,     0,
       0,  1629,     0,  1629,     0,     0,   813,     0,   814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3760,  -424,
       0,     0,  1629,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   898,   898,
       0,   815,     0,     0,     0,  -666,   898,   816,     0,     0,
     898,   898,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   898,     0,   898,     0,     0,
       0,  1629,     0,     0,     0,     0,     0,  3790,     0,     0,
       0,   817,   818,     0,   819,   820,     0,   898,     0,   898,
       0,     0,  1629,   821,     0,     0,     0,   822,   823,     0,
       0,     0,   824,     0,   901,   901,     0,   825,     0,     0,
       0,   643,   901,     0,     0,     0,   901,   901,     0,     0,
       0,     0,  1629,     0,     0,     0,     0,     0,     0,     0,
       0,   901,     0,   901,     0,     0,  2298,  1629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1629,     0,     0,   901,     0,   901,     0,     0,     0,     0,
       0,     0,     0,     0,  1629,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1058,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,  1629,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   643,     0,
       0,     0,     0,  1058,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1445,     0,     0,     0,     0,     0,
       0,     0,  1445,     0,    73,     0,    73,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,  1629,     0,     0,     0,
       0,     0,  1058,     0,     0,     0,     0,     0,  1058,     0,
    1058,     0,     0,     0,  1629,  1058,     0,     0,  1058,  1058,
    1058,  1058,  1058,  1058,  1058,  1058,  1058,  1058,     0,     0,
       0,     0,  1058,  1058,     0,     0,     0,     0,     0,     0,
    1449,  1629,     0,     0,   643,     0,  1058,     0,  1449,     0,
       0,     0,  1058,     0,     0,     0,     0,     0,     0,     0,
       0,  1058,     0,     0,  1058,     0,  1058,     4,     0,     0,
     898,     0,     0,     0,  1629,  1058,  1058,  1058,     0,  1445,
       0,  1058,  1445,  1445,  1058,     0,     0,     0,     5,     0,
       0,     0,     0,     0,  1058,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,     0,   901,     0,     0,     0,
       0,     0,     0,     0,     0,  1449,     0,     0,  1449,  1449,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   898,
       0,     0,     0,     0,   898,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1629,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   643,     0,     0,     0,     0,     0,     0,
       0,   643,     0,     0,     0,   643,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   901,     0,     0,     0,     0,
     901,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,     0,     0,     0,
    1058,     0,     0,     0,   643,     0,     0,     0,     0,     0,
       0,  1629,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    40,     0,
     643,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1058,     0,     0,     0,     0,  1058,     0,     0,
    1058,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1058,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,  1058,  1058,     0,     0,     0,     0,     0,  1058,  1058,
       0,     0,     0,  1058,  1629,     0,     0,     0,     0,  1058,
    1058,     0,     0,  1058,     0,     0,     0,     0,    44,     0,
       0,  2298,     0,   898,     0,  1445,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,  1062,
       0,  1629,     0,  1062,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,     0,    48,    49,     0,    50,     0,    51,     0,
       0,     0,    52,    53,    54,    55,  1062,    56,    57,   901,
       0,  1449,    58,    59,    60,    61,    62,     0,     0,    63,
      64,    65,    66,     0,    67,    68,    69,     0,    70,    71,
       0,     0,     0,     0,     0,     0,     0,     0,  1058,     0,
       0,   898,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1062,     0,     0,     0,  1445,     0,
    1062,     0,     0,     0,     0,  1445,  1445,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1058,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,     0,     0,  1058,     0,
       0,     0,     0,  1629,     0,     0,     0,   901,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1449,  1058,     0,     0,     0,  1058,
       0,  1449,  1449,     0,     0,     0,     0,     0,  1445,     0,
       0,     0,     0,   898,     0,   898,     0,     0,  1058,  1058,
       0,     0,  1058,     0,     0,  1062,     0,  3109,     0,  1058,
    1058,     0,     0,     0,     0,     0,     0,     0,  1445,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1058,
       0,     0,   643,     0,   643,   643,  1062,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,     0,   643,     0,
       0,     0,     0,     0,  1449,     0,     0,     0,     0,   901,
       0,   901,     0,     0,     0,     0,     0,     0,  1058,     0,
       0,     0,     0,  3112,   643,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1449,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   643,     0,     0,     0,
       0,     0,     0,     0,  1058,  1058,     0,     0,     0,     0,
       0,     0,  1346,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   643,   643,     0,     0,     0,     0,
       0,  1058,  1058,     0,  1058,     0,  1058,     0,     0,     0,
       0,     0,     0,  1409,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1629,     0,     0,     0,  1629,
    1629,     0,  1062,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,     0,     0,     0,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,  1058,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,     0,     0,  1629,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1058,     0,     0,     0,  1569,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
    1058,     0,   643,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3319,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1058,
    1058,     0,     0,     0,     0,     0,     0,  1062,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1058,     0,     0,     0,     0,
       0,     0,     0,  1062,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,  1062,     0,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1989,     0,     0,  1062,     0,     0,     0,   898,     0,     0,
       0,     0,   898,   898,   898,   898,   898,     0,     0,     0,
     898,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1789,     0,     0,     0,     0,     0,
       0,     0,     0,   643,   643,   643,   643,   643,   643,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1062,   901,     0,  1062,  1062,     0,   901,   901,
     901,   901,   901,     0,     0,     0,   901,     0,     0,     0,
    1836,  1837,     0,  1840,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1632,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   643,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1953,
    1632,     0,  1960,  1962,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2298,     0,     0,     0,     0,     0,
       0,  1632,     0,    73,     0,   898,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   898,   898,     0,  1632,     0,
     898,   898,     0,     0,     0,     0,     0,     0,     0,     0,
     898,     0,     0,     0,     0,  1632,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,   643,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   901,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   901,   901,     0,     0,     0,   901,   901,     0,     0,
       0,     0,     0,     0,     0,     0,   901,     0,     0,     0,
       0,     0,     0,  1062,     0,  1062,     0,     0,  1632,     0,
    1062,     0,     0,   643,   643,   643,     0,     0,     0,  1632,
       0,     0,     0,   643,   643,     0,     0,     0,   643,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   643,     0,     0,
       0,     0,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   643,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1062,  1062,     0,  3661,
       0,     0,     0,     0,  1062,     0,     0,  1062,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,  1062,  1062,
       0,     0,     0,     0,     0,     0,  1062,     0,     0,  1062,
    1062,  1062,  1062,     0,     0,     0,     0,     0,     0,  1062,
    1062,     0,  1062,     0,  1062,     0,     0,  1062,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,  1062,     0,     0,     0,  1062,     0,     0,     0,
    1062,     0,     0,     0,  1062,     0,     0,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,     0,  1062,     0,     0,
       0,     0,  1062,     0,     0,     0,  1062,     0,     0,     0,
       0,     0,   643,     0,     0,     0,     0,     0,     0,     0,
       0,  2350,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2372,     0,     0,  2374,     0,     0,  2384,
       0,     0,     0,     0,     0,     0,  2391,  2396,     0,     0,
       0,  2401,     0,   643,  2406,     0,     0,  1062,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2415,
       0,     0,     0,  2421,     0,     0,     0,  2433,     0,     0,
       0,  2440,     0,     0,  2442,  2443,  2444,  2445,  2446,  2447,
    2448,  2449,  2450,     0,  2451,     0,     0,     0,     0,  1346,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,     0,     0,  1409,  1632,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2544,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,  1062,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,  2652,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,  2676,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1632,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,  1062,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,     0,     0,  2779,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
       0,    38,     0,  1062,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,  1062,  1062,  1062,  2796,
       0,    39,     0,     0,     0,     0,     0,  1062,     0,     0,
       0,     0,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1062,  1062,     0,  1062,     0,     0,  1346,     0,
       0,     0,     0,    40,     0,     0,    41,     0,  1062,     0,
    1062,     0,     0,     0,  1062,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2835,    42,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,  1062,  1062,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1062,     0,     0,     0,     0,     0,  1062,
       0,     0,  2396,     0,  2396,  2396,     0,     0,  1062,  1062,
    1062,     0,     0,     0,  2896,     0,     0,     0,     0,  2900,
       0,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,     0,  2921,     0,  2923,     0,     0,
       0,  2926,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1632,  1632,    44,  1632,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,  1632,     0,  1632,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1409,     0,     0,     0,     0,     0,  1953,     0,  1632,     0,
      47,     0,     0,     0,     0,  1962,  1962,  1960,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,    53,    54,
      55,     0,    56,    57,     0,     0,     0,    58,    59,    60,
      61,    62,     0,     0,    63,    64,  1215,  2999,     0,     0,
    1216,     0,     0,     0,    71,     0,     0,  1632,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1874,     0,     0,     0,     0,     0,     0,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1632,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1632,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1874,     0,  1062,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,     0,  1632,     0,     0,     0,     0,
       0,  1632,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,  1632,     0,     0,     0,     0,     0,  1062,     0,
       0,     0,     0,     0,  1062,     0,  1062,     0,     0,     0,
    1632,  1062,     0,     0,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,     0,     0,     0,     0,  1062,  1062,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,  1062,     0,     0,     0,     0,     0,  1062,     0,
       0,     0,     0,     0,     0,     0,     0,  1062,     0,     0,
    1062,     0,  1062,     0,     0,     0,     0,     0,     0,     0,
    1632,  1062,  1062,  1062,  1874,     0,     0,  1062,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,  3232,     0,     0,     0,
       0,     0,     0,     0,     0,  3235,     0,     0,     0,     0,
       0,  3236,     0,  3237,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3255,  3256,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2401,     0,     0,     0,     0,
       0,     0,     0,     0,  3280,     0,     0,  3283,     0,  3285,
       0,     0,     0,     0,     0,     0,     0,     0,  3289,     0,
       0,     0,     0,     0,  3294,     0,     0,  3297,  1632,     0,
       0,     0,     0,     0,     0,     0,     0,  3304,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1874,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,     0,     0,     0,  1874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1874,     0,     0,
       0,     0,  2380,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1062,     0,
       0,  1874,  1874,  1062,     0,  1874,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1874,     0,  1062,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,  1062,  1062,     0,
       0,     0,     0,     0,  1062,  1062,     0,     0,     0,  1062,
    1632,     0,     0,     0,     0,  1062,  1062,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,     0,     0,  1874,     0,
       0,     0,     0,     0,     0,  1874,     0,  1874,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1632,     0,     0,
       0,  3484,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3500,  3502,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3508,     0,     0,     0,
       0,     0,  3513,  3514,  1062,     0,  3516,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,  1062,     0,     0,     0,     0,  1632,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,     0,     0,     0,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3585,     0,     0,  1062,  1062,     0,     0,  1062,     0,
       0,     0,     0,     0,     0,  1062,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,     0,  3629,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1062,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,  1062,     0,     0,     0,  3658,     0,     0,     0,     0,
       0,     0,     0,  3660,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1062,  1062,     0,
    1062,     0,  1062,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3675,     0,     0,     0,
       0,  1632,     0,     0,     0,  1632,  1632,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1874,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1062,     0,     0,     0,     0,     0,     0,  1874,  3715,  1874,
       0,  2380,  2871,     0,     0,  2380,     0,     0,     0,  1874,
       0,     0,  1632,     0,     0,     0,  1874,     0,     0,     0,
       0,  1874,     0,     0,     0,     0,  1874,  2401,     0,     0,
       0,  1874,     0,     0,     0,     0,     0,     0,     0,     0,
    1874,     0,     0,     0,  2380,  2380,  1874,     0,     0,     0,
       0,  1062,     0,     0,     0,     0,     0,     0,  1874,     0,
       0,     0,     0,     0,     0,  1874,  1062,  1874,  1874,  1874,
    1874,  1874,  1874,  1874,  1874,  1874,  1874,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1062,  1062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1062,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1062,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,  1874,
       0,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1874,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1874,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,  1874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    42,
       0,  1874,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1874,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2871,     0,  2380,     0,    43,  2380,  2380,  2380,  2380,
    2380,  2380,  2380,  2380,  2380,  2380,     0,  2871,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1874,     0,     0,    44,  1874,     0,     0,     0,     0,
    2871,  2871,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,  2380,  2380,  1874,     0,  1874,    46,
       0,  1874,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,     0,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1215,  1716,     0,
       0,     0,     0,     0,     0,    71,     0,     0,     0,     0,
       0,     0,     0,     4,  1874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     0,     0,     0,     0,
       0,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,  2380,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,  1874,     0,     0,
    1874,  1874,  1874,     0,     0,  2871,     0,     0,     0,     0,
    2871,  2871,  2871,  2871,  2871,  2871,  2871,  2871,  2871,  2871,
    1874,  1874,     0,     0,    40,     0,     0,    41,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,  1874,  2380,  2380,  1874,    42,
    1874,     0,     0,     0,  1874,  2871,  2871,     0,     0,  1874,
       0,    38,  1874,     0,     0,     0,     0,     0,     0,  1874,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    40,     0,    43,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,  2871,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,    43,     0,     0,     0,     0,    48,
      49,     0,    50,     0,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,    57,     0,     0,     0,    58,    59,
      60,    61,    62,     0,     0,    63,    64,  1215,  2285,     0,
       0,     0,     0,    44,     0,    71,     0,     0,     0,  1874,
       0,     0,     0,  2380,     0,    45,     0,  2380,     0,     0,
       0,     0,     0,     0,     0,  1874,     0,  1874,    46,     0,
       0,  2871,  2871,  1874,     0,     0,  2380,  2380,  1874,  1874,
       0,  1874,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,     0,     0,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,    53,    54,
      55,     0,    56,    57,     0,     0,     0,    58,    59,    60,
      61,    62,     0,     0,    63,    64,  1215,     0,     0,     0,
       0,     0,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1874,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1874,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2871,  2380,
    2380,  2871,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2871,  2871,  1874,     0,  1874,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1874,     0,     0,   662,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,   663,   102,   103,   388,   664,     0,
     105,   106,   107,   108,   665,   666,     0,   110,   111,   112,
    1874,   113,   667,   668,   389,   390,     0,     0,     0,   391,
     392,     0,  2871,  2871,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,   669,
     406,   407,   408,   670,   671,   672,   673,   674,   675,   676,
     409,   410,   677,   411,   130,   412,   413,   414,   132,   133,
     134,   135,     0,   678,   415,   416,     0,   417,   418,   679,
     680,   419,   681,   136,   421,   682,   422,   423,   424,   425,
     140,   683,   684,   426,   427,   428,   429,   430,   431,   685,
     432,   433,   434,   435,   436,   686,   437,   438,   439,   145,
     440,   687,   688,   689,   690,   691,   692,   441,   442,   443,
     444,   445,   148,   149,   446,   693,   447,   694,   448,     0,
     449,   450,   451,   695,   452,   453,   454,   696,   697,   455,
     456,   457,   458,   459,   698,   460,   461,   462,   699,     0,
     463,   700,   464,   465,   466,   157,   467,   468,   159,   701,
     469,   470,   471,   161,   702,   472,   703,   473,   162,   704,
     163,   474,     0,   475,   705,   476,   166,   706,   477,   707,
     478,   479,   480,   481,   167,   482,   483,   484,   708,   485,
     486,   487,   488,   489,   490,   709,   168,   169,   710,   491,
     492,   493,   711,   171,   712,   172,   713,     0,   173,   174,
     494,   175,   495,   496,   497,   498,   499,   714,   176,   177,
     500,   178,   715,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,   184,   185,   716,   517,   518,   519,   520,   521,
     522,   523,   186,   524,   717,   525,   526,   188,   527,   718,
     189,   528,   190,   529,   530,   719,   720,   531,   721,   722,
     723,   532,   533,   724,   725,   191,   192,   193,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,   726,   543,   544,   545,   546,   547,   548,   198,   549,
     550,   727,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,   728,   561,   562,   204,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,   729,   572,   573,
     574,   730,   575,   210,   576,   577,   212,   578,   213,   731,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,   732,   590,   591,   733,   592,   593,   594,   595,
     596,   734,   216,   217,   735,   736,   598,   218,   599,   219,
     737,   600,   601,   602,   603,   604,   738,   739,   605,   606,
     607,   608,   740,   741,   609,   610,   611,   612,     0,   227,
     614,   228,   615,   616,   617,   742,   743,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,     0,     0,     0,    83,    84,    85,     0,
      87,    88,    89,    90,    91,     0,     0,     0,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,     0,
       0,   876,   105,   106,   107,   108,     0,   109,     0,   110,
     111,   112,     0,   113,   114,   115,     0,     0,     0,     0,
       0,   118,   119,     0,     0,     0,     0,   120,     0,     0,
       0,     0,     0,     0,     0,     0,   121,     0,   122,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   130,     0,     0,     0,
     132,   133,   134,   135,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   136,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   148,   149,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,     0,     0,     0,     0,     0,   157,     0,     0,
     159,     0,     0,     0,     0,   161,     0,     0,     0,     0,
     162,     0,   163,     0,     0,     0,     0,     0,   166,     0,
       0,     0,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   168,   169,
       0,     0,     0,     0,     0,   171,     0,   172,     0,     0,
     173,   174,     0,   175,     0,     0,     0,     0,     0,     0,
     176,   177,     0,   178,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,   185,     0,     0,     0,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,   188,
       0,     0,   189,     0,   190,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   191,   192,   193,
     194,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     198,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
     206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,   212,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   216,   217,     0,     0,     0,   218,
       0,   219,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,     0,   228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   229,   230,   231,   232,   233,
     234,   235,   236,     0,     0,     0,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,     0,    83,
      84,    85,     0,    87,    88,    89,    90,    91,     0,     0,
       0,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,     0,     0,  2511,   105,   106,   107,   108,     0,
     109,     0,   110,   111,   112,     0,   113,   114,   115,     0,
       0,     0,     0,     0,   118,   119,     0,     0,     0,     0,
     120,     0,     0,     0,     0,     0,     0,     0,     0,   121,
       0,   122,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   130,
       0,     0,     0,   132,   133,   134,   135,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   136,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   148,   149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,     0,     0,     0,
     157,     0,     0,   159,     0,     0,     0,     0,   161,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   168,   169,     0,     0,     0,     0,     0,   171,     0,
     172,     0,     0,   173,   174,     0,   175,     0,     0,     0,
       0,     0,     0,   176,   177,     0,   178,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   183,   184,   185,     0,
       0,     0,     0,     0,     0,     0,     0,   186,     0,     0,
       0,     0,   188,     0,     0,   189,     0,   190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     191,   192,   193,   194,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   198,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,   206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   216,   217,     0,
       0,     0,   218,     0,   219,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,   230,
     231,   232,   233,   234,   235,   236,     0,     0,     0,     0,
       0,     0,     0,     0,   237,     0,     0,   238,     0,    82,
       0,     0,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,     0,    93,    94,    95,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   104,     0,  2513,   105,   106,
     107,   108,     0,   109,     0,   110,   111,   112,     0,   113,
     114,   115,   116,   117,     0,     0,     0,   118,   119,     0,
       0,     0,     0,   120,     0,     0,     0,     0,     0,     0,
       0,     0,   121,     0,   122,     0,   123,   124,     0,   125,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   126,
       0,   127,   128,     0,     0,     0,     0,     0,     0,     0,
       0,   129,   130,     0,     0,   131,   132,   133,   134,   135,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,     0,   137,     0,   138,   139,   140,     0,
       0,   141,   142,     0,     0,     0,     0,     0,     0,     0,
       0,   143,     0,   144,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   146,     0,   147,
     148,   149,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
     153,     0,     0,     0,     0,     0,   154,   155,     0,     0,
       0,     0,   156,   157,   158,     0,   159,     0,     0,   160,
       0,   161,     0,     0,     0,     0,   162,     0,   163,     0,
     164,     0,   165,     0,   166,     0,     0,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,     0,     0,   170,     0,
       0,   171,     0,   172,     0,     0,   173,   174,     0,   175,
       0,     0,     0,     0,     0,     0,   176,   177,     0,   178,
       0,   179,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,     0,     0,   182,     0,     0,   183,
     184,   185,     0,     0,     0,     0,     0,     0,     0,     0,
     186,     0,     0,     0,   187,   188,     0,     0,   189,     0,
     190,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   191,   192,   193,   194,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,   197,     0,     0,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,   202,     0,     0,
       0,     0,   203,   204,     0,   205,   206,     0,     0,   207,
       0,     0,     0,     0,     0,   208,     0,     0,     0,    82,
     209,   210,     0,   211,   212,    86,   213,     0,     0,     0,
     214,    92,     0,    93,     0,    95,     0,     0,   215,     0,
       0,     0,     0,     0,     0,   104,     0,     0,     0,     0,
     216,   217,     0,     0,     0,   218,     0,   219,     0,   220,
       0,   221,   116,   117,   222,     0,     0,   223,     0,   224,
       0,     0,   225,     0,     0,     0,   226,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   125,
       0,   229,   230,   231,   232,   233,   234,   235,   236,   126,
       0,   127,   128,     0,     0,     0,     0,   237,     0,     0,
     238,     0,     0,     0,     0,   987,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   137,   239,   138,   139,     0,     0,
       0,   141,   142,     0,     0,     0,     0,     0,     0,     0,
       0,   143,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   146,     0,   147,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
     153,     0,     0,     0,     0,     0,   154,     0,     0,     0,
       0,     0,   156,     0,   158,     0,     0,     0,     0,   160,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,   165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   170,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   179,   180,     0,     0,     0,     0,   181,     0,     0,
       0,     0,     0,     0,     0,     0,   182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   199,     0,     0,
     200,     0,   201,     0,     0,     0,     0,   202,     0,     0,
       0,     0,   203,     0,     0,   205,     0,     0,     0,   207,
       0,     0,     0,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,   211,     0,     0,     0,     0,     0,     0,
     214,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,   221,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,     0,     0,   226,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,   239,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,  2469,   406,   407,   408,     0,     0,     0,
       0,  1270,     0,     0,   409,   410,     0,   411,   130,   412,
     413,   414,   132,  1271,   134,  1272,  1273,     0,   415,   416,
       0,   417,   418,  1274,  1275,   419,  1276,  1277,   421,     0,
     422,   423,   424,   425,  1278,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,   145,   440,     0,  1279,  1280,  1281,  1282,
    1283,   441,   442,   443,   444,   445,  1284,  1285,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,  2470,     0,   455,   456,  1286,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,  1287,
     467,   468,  1288,  1289,   469,   470,   471,  1290,     0,   472,
       0,   473,   162,     0,   163,   474,     0,   475,     0,   476,
    1291,     0,   477,     0,   478,   479,   480,   481,   167,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
     168,   169,     0,   491,   492,   493,  1292,  1293,     0,  1294,
       0,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,     0,  1295,   177,   500,   178,     0,   501,   502,   503,
    1296,  1297,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1298,   184,  1299,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,  1300,   525,
     526,   188,   527,  1301,  1302,   528,  1303,   529,   530,     0,
       0,   531,   792,     0,     0,  1304,   533,     0,     0,   191,
     192,   193,  1305,   534,   535,   536,   537,   538,     0,   539,
    1306,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,  1307,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,   204,
     563,   564,  1308,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,  1309,   575,   210,   576,   577,
     212,   578,  1310,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,  1311,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,  1312,  1313,     0,     0,
     598,  1314,   599,  1315,  1316,   600,   601,   602,   603,   604,
       0,  1317,   605,   606,   607,   608,  1318,     0,   609,   610,
     611,   612,   613,  1319,   614,   228,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,  1320,  1321,
    1322,  1323,  1324,  1325,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1326,   238,   627,     0,     0,
    1327,  1328,    52,    53,    54,    55,  1329,    56,     0,     0,
       0,     0,  1330,  1331,  2471,     0,     0,     0,     0,     0,
       0,  1333,  2472,   662,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,   663,   102,   103,   388,   664,     0,
     105,   106,   107,   108,   665,   666,     0,   110,   111,   112,
       0,   113,   667,   668,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,  1270,     0,     0,
     409,   410,     0,   411,   130,   412,   413,   414,   132,  1271,
     134,  1272,  1273,     0,   415,   416,     0,   417,   418,  1274,
    1275,   419,  1276,  1277,   421,     0,   422,   423,   424,   425,
    1278,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,   145,
     440,     0,  1279,  1280,  1281,  1282,  1283,   441,   442,   443,
     444,   445,  1284,  1285,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,  1286,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,  1287,   467,   468,  1288,  1289,
     469,   470,   471,  1290,     0,   472,     0,   473,   162,     0,
     163,   474,     0,   475,     0,   476,  1291,     0,   477,     0,
     478,   479,   480,   481,   167,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,   168,   169,     0,   491,
     492,   493,  1292,  1293,     0,  1294,     0,     0,   173,   174,
     494,   175,   495,   496,   497,   498,   499,     0,  1295,   177,
     500,   178,     0,   501,   502,   503,  1296,  1297,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,  1298,   184,  1299,   791,   517,   518,   519,   520,   521,
     522,   523,   186,   524,  1300,   525,   526,   188,   527,  1301,
    1302,   528,  1303,   529,   530,     0,     0,   531,   792,     0,
       0,  1304,   533,     0,     0,   191,   192,   193,  1305,   534,
     535,   536,   537,   538,     0,   539,  1306,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,  1307,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,   204,   563,   564,  1308,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,  1309,   575,   210,   576,   577,   212,   578,  1310,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
    1311,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,  1312,  1313,     0,     0,   598,  1314,   599,  1315,
    1316,   600,   601,   602,   603,   604,     0,  1317,   605,   606,
     607,   608,  1318,     0,   609,   610,   611,   612,   613,  1319,
     614,   228,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,  1320,  1321,  1322,  1323,  1324,  1325,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
      49,  1326,   238,   627,     0,     0,  1327,  1328,    52,    53,
      54,    55,  1329,    56,     0,     0,     0,     0,  1330,  1331,
       0,     0,     0,     0,     0,     0,     0,  1333,  2382,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,  2045,   485,   486,   487,   488,   489,
     490,     0,   168,  2046,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,  2047,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  2048,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,  2049,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,  3718,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1416,     0,     0,     0, -1416,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,  1271,   134,  1272,  1273,  2392,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,  2393,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,  2394,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,  1300,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,  2395,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,   178,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,  1300,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,  1304,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1309,   575,
     210,   576,   577,   212,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,  1317,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,   613,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1326,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,  1330,  1331,  1332,     0,     0,
       0,     0,     0,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,  1271,   134,  1272,  1273,     0,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,  1408,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,  1300,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,     0,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,   178,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,  1300,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,  1304,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,   208,   572,   573,   574,  1309,   575,
     210,   576,   577,   212,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,  1317,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,  1838,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1326,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,  1330,  1331,     0,     0,     0,
       0,     0,     0,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,  1958,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,  1271,   134,  1272,  1273,     0,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,  1300,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,     0,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,   178,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,  1300,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,  1304,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1309,   575,
     210,   576,   577,   212,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,  1317,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,   613,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1326,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,  1330,  1331,     0,     0,     0,
       0,     0,  1784,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,  1271,   134,  1272,  1273,     0,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,  2778,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,  1300,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,     0,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,  2393,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,   178,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,  1300,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,  1304,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1309,   575,
     210,   576,   577,   212,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,  1317,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,   613,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1326,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,  1330,  1331,     0,     0,     0,
       0,     0,     0,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,  1271,   134,  1272,  1273,     0,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,  1300,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,     0,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,   178,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,  1300,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,  1304,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1309,   575,
     210,   576,   577,   212,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,  1317,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,   613,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
    3494,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1326,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,  1330,  1331,     0,     0,     0,
       0,     0,     0,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,  1271,   134,  1272,  1273,     0,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,  3501,   519,
     520,   521,   522,   523,   186,   524,  1300,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,     0,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,   132,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,   167,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,   178,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,  1304,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1309,   575,
     210,   576,   577,   212,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,   613,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,  1326,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,     0,  2376,     0,     0,     0,
       0,     0,     0,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,  1270,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
       0,  1271,   134,  1272,  1273,     0,   415,   416,     0,   417,
     418,  1274,  1275,   419,  1276,  1277,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,  1284,  1285,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,  1286,   458,   459,     0,   460,   461,   462,
       0,     0,     0,     0,   464,   465,   466,  1287,   467,   468,
    1288,  1289,   469,   470,   471,  1290,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,  1292,  1293,     0,  1294,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,     0,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,  1298,   184,  1299,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,   188,
     527,  1301,  1302,   528,  1303,   529,   530,     0,     0,   531,
     792,     0,     0,  1304,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
    1307,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
    1308,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,     0,   578,
    1310,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,  1312,  1313,     0,     0,   598,  1314,
     599,  1315,  1316,   600,   601,   602,   603,   604,     0,  1317,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,  1319,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,    49,  1326,   238,   627,     0,     0,  1327,  1328,
      52,    53,    54,    55,  1329,    56,     0,     0,     0,     0,
    1330,  1331,     0,     0,     0,     0,     0,     0,     0,  1333,
     662,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,   663,   102,   103,   388,   664,     0,   105,   106,   107,
     108,   665,   666,     0,   110,   111,   112,     0,   113,   667,
     668,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,  1270,     0,     0,   409,   410,     0,
     411,   130,   412,   413,   414,     0,  1271,   134,  1272,  1273,
       0,   415,   416,     0,   417,   418,  1274,  1275,   419,  1276,
    1277,   421,     0,   422,   423,   424,   425,  1278,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,   145,   440,     0,  1279,
    1280,  1281,  1282,  1283,   441,   442,   443,   444,   445,  1284,
    1285,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,  1286,   458,
     459,     0,   460,   461,   462,     0,     0,     0,     0,   464,
     465,   466,  1287,   467,   468,  1288,  1289,   469,   470,   471,
    1290,     0,   472,     0,   473,   162,     0,   163,   474,     0,
     475,     0,   476,  1291,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,   168,   169,     0,   491,   492,   493,  1292,
    1293,     0,  1294,     0,     0,   173,   174,   494,   175,   495,
     496,   497,   498,   499,     0,  1295,   177,   500,     0,     0,
     501,   502,   503,  1296,  1297,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,  1298,   184,
    1299,   791,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,   188,   527,  1301,  1302,   528,  1303,
     529,   530,     0,     0,   531,   792,     0,     0,     0,   533,
       0,     0,   191,   192,   193,  1305,   534,   535,   536,   537,
     538,     0,   539,  1306,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,  1307,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,   204,   563,   564,  1308,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,  1309,   575,
     210,   576,   577,     0,   578,  1310,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,  1311,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,  1312,
    1313,     0,     0,   598,  1314,   599,  1315,  1316,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,  1318,
       0,   609,   610,   611,   612,   613,  1319,   614,   228,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,  1320,  1321,  1322,  1323,  1324,  1325,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,    49,     0,   238,
     627,     0,     0,  1327,  1328,    52,    53,    54,    55,  1329,
      56,     0,     0,     0,     0,     0,  2376,     0,     0,     0,
       0,     0,     0,     0,  1333,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,     0,   415,   416,     0,   417,
     418,     0,  1275,   419,   420,   136,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
    1288,     0,   469,   470,   471,   161,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,   184,   185,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,   188,
     527,     0,  1302,   528,   190,   529,   530,     0,     0,   531,
     792,     0,   977,   532,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,   208,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,  1314,
     599,  1315,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
    1838,   227,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,  2247,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,     0,   415,   416,     0,   417,
     418,     0,  1275,   419,   420,   136,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
    1288,     0,   469,   470,   471,   161,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,   184,   185,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,   188,
     527,     0,  1302,   528,   190,   529,   530,     0,     0,   531,
     792,     0,   977,   532,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,  1314,
     599,  1315,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,   227,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,  2247,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,     0,   415,   416,     0,   417,
     418,     0,  1275,   419,   420,   136,   421,     0,   422,   423,
     424,   425,  1278,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,  1279,  1280,  1281,  1282,  1283,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
    1288,     0,   469,   470,   471,   161,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,  1291,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
    1295,   177,   500,   178,     0,   501,   502,   503,  1296,  1297,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,   184,   185,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,   188,
     527,     0,  1302,   528,   190,   529,   530,     0,     0,   531,
     792,     0,     0,   532,   533,     0,     0,   191,   192,   193,
    1305,   534,   535,   536,   537,   538,     0,   539,  1306,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,  1309,   575,   210,   576,   577,   212,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,  1311,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,  1314,
     599,  1315,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,  1318,     0,   609,   610,   611,   612,
     613,   227,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,  1320,  1321,  1322,  1323,
    1324,  1325,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   662,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,  3618,
      96,    97,    98,    99,   100,   101,   663,   102,   103,   388,
     664,     0,   105,   106,   107,   108,   665,   666,     0,   110,
     111,   112,     0,   113,   667,   668,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,   130,   412,   413,   414,
     132,   133,   134,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,   145,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
     162,     0,   163,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,   167,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,   168,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
     173,   174,   494,   175,   495,   496,   497,   498,   499,     0,
     176,   177,   500,   178,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,   184,   185,   791,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,   188,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
     792,     0,     0,   532,   533,     0,     0,   191,   192,   193,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,   204,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,   212,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,   228,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,  3668,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,  2760,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
   -1047,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0, -1047,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0, -1047,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494, -1047,   495,   496,   497,   498,   499,     0,   176,
   -1047,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183, -1047,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562, -1047,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,  1412,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
      49,     0,   238,   627,     0,     0,     0,     0,    52,    53,
      54,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2681,  2682,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,     0,   238,   627,     0,     0,
       0,     0,    52,    53,    54,    55,     0,     0,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,  2682,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,   791,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,   792,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,  1400,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
     208,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,  1838,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,   627,     0,     0,     0,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     239,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,   208,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,  1838,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,   239,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,  1935,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   662,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,  3194,    96,    97,    98,    99,   100,   101,   663,   102,
     103,   388,   664,     0,   105,   106,   107,   108,   665,   666,
       0,   110,   111,   112,     0,   113,   667,   668,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,   669,   406,   407,   408,   670,   671,   672,
     673,   674,   675,   676,   409,   410,   677,   411,   130,   412,
     413,   414,   132,  1599,   134,  1600,  1273,   678,   415,   416,
       0,   417,   418,   679,   680,   419,  1601,  1602,   421,   682,
     422,   423,   424,   425,     0,   683,   684,   426,   427,   428,
     429,   430,   431,   685,   432,   433,   434,   435,   436,   686,
     437,   438,   439,   145,   440,   687,   688,   689,   690,   691,
     692,   441,   442,   443,   444,   445,  1603,  1604,   446,   693,
     447,   694,   448,     0,   449,   450,   451,   695,   452,   453,
     454,   696,   697,   455,   456,  1286,   458,   459,   698,   460,
     461,   462,   699,     0,   463,   700,   464,   465,   466,     0,
     467,   468,     0,   701,   469,   470,   471,  1605,   702,   472,
     703,   473,   162,   704,   163,   474,     0,   475,   705,   476,
       0,   706,   477,   707,   478,   479,   480,   481,   167,   482,
     483,   484,   708,   485,   486,   487,   488,   489,   490,   709,
     168,     0,     0,   491,   492,   493,  1292,  1606,   712,  1607,
     713,     0,   173,   174,   494,   175,   495,   496,   497,   498,
     499,   714,     0,   177,   500,   178,   715,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,  1608,   184,  1609,   716,   517,
     518,   519,   520,   521,   522,   523,     0,   524,   717,   525,
     526,   188,   527,   718,     0,   528,  1610,   529,   530,   719,
     720,   531,   721,   722,   723,  3086,   533,   724,   725,     0,
     192,   193,     0,   534,   535,   536,   537,   538,     0,   539,
       0,     0,   540,   541,   542,   726,   543,   544,   545,   546,
     547,   548,  1611,   549,   550,   727,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   728,   561,   562,   204,
     563,   564,     0,   565,   566,   567,   568,   569,   570,   571,
       0,   729,   572,   573,   574,   730,   575,  2048,   576,   577,
     212,   578,  1613,   731,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,     0,   589,   732,   590,   591,   733,
     592,   593,   594,   595,   596,   734,  1614,  1615,     0,   736,
     598,     0,   599,     0,   737,   600,   601,   602,   603,   604,
       0,   739,   605,   606,   607,   608,   740,   741,   609,   610,
     611,   612,     0,  1616,   614,   228,   615,   616,   617,   742,
     743,   618,   619,   620,   621,   622,   623,     0,     0,     0,
       0,     0,     0,     0,     0,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,  1077,   238,   627,     0,     0,
       0,     0,    52,    53,    54,    55,     0,    56,  1078,  1079,
    1080,     0,  1081,  3087,  1083,  1084,  1085,  1086,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,  1075,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,  1076,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,  1077,   238,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1078,  1079,
    1080,     0,  1081,  1082,  1083,  1084,  1085,  1086,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,  1077,   238,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1078,  1079,
    1080,     0,  1081,  1082,  1083,  1084,  1085,  1086,   662,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,   663,
     102,   103,   388,   664,     0,   105,   106,   107,   108,   665,
     666,     0,   110,   111,   112,     0,   113,   667,   668,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,   669,   406,   407,   408,   670,   671,
     672,   673,   674,   675,   676,   409,   410,   677,   411,   130,
     412,   413,   414,   132,   133,   134,   135,     0,   678,   415,
     416,     0,   417,   418,   679,   680,   419,   681,   136,   421,
     682,   422,   423,   424,   425,   140,   683,   684,   426,   427,
     428,   429,   430,   431,   685,   432,   433,   434,   435,   436,
     686,   437,   438,   439,   145,   440,   687,   688,   689,   690,
     691,   692,   441,   442,   443,   444,   445,   148,   149,   446,
     693,   447,   694,   448,     0,   449,   450,   451,   695,   452,
     453,   454,   696,   697,   455,   456,   457,   458,   459,   698,
     460,   461,   462,   699,     0,   463,   700,   464,   465,   466,
     157,   467,   468,   159,   701,   469,   470,   471,   161,   702,
     472,   703,   473,   162,   704,   163,   474,     0,   475,   705,
     476,   166,   706,   477,   707,   478,   479,   480,   481,   167,
     482,   483,   484,   708,   485,   486,   487,   488,   489,   490,
     709,   168,   169,   710,   491,   492,   493,   711,   171,   712,
     172,   713,     0,   173,   174,   494,   175,   495,   496,   497,
     498,   499,   714,   176,   177,   500,   178,   715,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,   184,   185,   716,
     517,   518,   519,   520,   521,   522,   523,   186,   524,   717,
     525,   526,   188,   527,   718,   189,   528,   190,   529,   530,
     719,   720,   531,   721,   722,   723,   532,   533,   724,   725,
     191,   192,   193,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,   726,   543,   544,   545,
     546,   547,   548,   198,   549,   550,   727,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   728,   561,   562,
     204,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,   729,   572,   573,   574,   730,   575,   210,   576,
     577,   212,   578,   213,   731,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,   732,   590,   591,
     733,   592,   593,   594,   595,   596,   734,   216,   217,   735,
     736,   598,   218,   599,   219,   737,   600,   601,   602,   603,
     604,   738,   739,   605,   606,   607,   608,   740,   741,   609,
     610,   611,   612,     0,   227,   614,   228,   615,   616,   617,
     742,   743,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,     0,     0,
       0,   662,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,  1570,    96,    97,    98,    99,
     100,   101,   663,   102,   103,   388,   664,     0,   105,   106,
     107,   108,   665,   666,     0,   110,   111,   112,     0,   113,
     667,   668,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,   130,   412,   413,   414,   132,  1599,   134,  1600,
    1273,     0,   415,   416,     0,   417,   418,     0,     0,   419,
    1601,  1602,   421,     0,   422,   423,   424,   425,     0,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,   145,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
    1603,  1604,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,  1286,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,     0,   467,   468,     0,     0,   469,   470,
     471,  1605,     0,   472,     0,   473,   162,     0,   163,   474,
       0,   475,     0,   476,     0,     0,   477,     0,   478,   479,
     480,   481,   167,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,   168,     0,     0,   491,   492,   493,
    1292,  1606,     0,  1607,     0,     0,   173,   174,   494,   175,
     495,   496,   497,   498,   499,     0,     0,   177,   500,   178,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,  1608,
     184,  1609,     0,   517,   518,   519,   520,   521,   522,   523,
       0,   524,     0,   525,   526,   188,   527,     0,     0,   528,
    1610,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,     0,   192,   193,     0,   534,   535,   536,
     537,   538,     0,   539,     0,     0,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,  1611,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,   204,   563,   564,     0,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,  1612,   576,   577,   212,   578,  1613,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,     0,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
    1614,  1615,     0,     0,   598,     0,   599,     0,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,     0,  1616,   614,   228,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,     0,     0,     0,     0,     0,     0,     0,     0,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,     0,     0,     0,     0,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,  2005,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,     0,     0,     0,     0,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,   975,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,  1916,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,  1917,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,  1918,
       0,   531,     0,  1919,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,  1920,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,     0,   238,   627,     0,     0,
       0,     0,    52,    53,    54,    55,     0,    56,     0,     0,
       0,     0,     0,  1444,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,  1926,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,  1917,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,  1918,     0,   531,     0,  1919,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
    1920,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
      49,     0,   238,   627,     0,     0,     0,     0,    52,    53,
      54,    55,     0,    56,     0,     0,     0,     0,     0,  1444,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,  1917,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,  1918,     0,   531,     0,  1919,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,  1920,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,    49,     0,   238,   627,
       0,     0,     0,     0,    52,    53,    54,    55,     0,    56,
       0,     0,     0,     0,     0,  1444,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   883,   400,   401,   402,   403,   404,
     405,   884,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   885,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   886,   161,     0,   472,     0,   887,
       0,   888,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
     889,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   890,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   891,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   892,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   893,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,   627,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,   894,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     883,   400,   401,   402,   403,   404,   405,   884,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   885,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     886,   161,     0,   472,     0,   887,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   890,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   891,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     892,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   893,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,   627,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,   894,   662,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,   663,
     102,   103,   388,   664,     0,   105,   106,   107,   108,   665,
     666,     0,   110,   111,   112,     0,   113,   667,   668,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,   130,
     412,   413,   414,   132,   133,   134,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,   145,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,   162,     0,   163,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,   167,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,   168,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,   173,   174,   494,   175,   495,   496,   497,
     498,   499,     0,   176,   177,   500,   178,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,   184,   185,   791,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,   188,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,   792,     0,     0,   532,   533,     0,     0,
     191,   192,   193,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
     204,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,   212,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,   228,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,    49,     0,   238,   627,     0,
       0,  1327,  1328,    52,    53,    54,    55,     0,    56,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
     651,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,  1370,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,  1371,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3468,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,   597,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,    49,     0,   238,   627,     0,     0,
       0,     0,    52,    53,    54,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,  1030,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,    49,     0,   238,   627,     0,     0,     0,     0,    52,
      53,    54,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,  1903,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,    49,     0,
     238,   627,     0,     0,     0,     0,    52,    53,    54,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,    49,     0,   238,   627,     0,
       0,     0,     0,    52,    53,    54,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,     0,   953,  1669,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,   954,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   931,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   955,     0,   956,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   957,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   958,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     959,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   960,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   961,   217,     0,     0,
     962,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   935,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   963,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
       0,    87,    88,    89,    90,    91,     0,     0,     0,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
       0,     0,     0,   105,   106,   107,   108,     0,   109,     0,
     110,   111,   112, -1530,   113,   114,   115,     0,     0,     0,
       0,     0,   118,   119,     0,     0,     0,     0,   120,     0,
       0,     0,     0,     0,     0,     0,     0,   121,     0,   122,
       0,   123,   124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   130,     0,     0,
       0,   132,   133,   134,   135,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,     0,     0,     0,     0,     0,   157,     0,
       0,   159,     0,     0,     0,     0,   161,     0,     0,     0,
       0,   162,     0,   163,     0,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   168,
     169,     0,     0,     0,     0,     0,   171,     0,   172,     0,
       0,   173,   174,     0,   175,     0,     0,     0,     0,     0,
       0,   176,   177,     0,   178,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   183,   184,   185,     0,     0,     0,
       0,     0,     0,     0,     0,   186,     0,     0,     0,     0,
     188,     0,     0,   189,     0,   190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   191,   192,
     193,   194,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,   206,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,   212,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   216,   217,     0,     0,     0,
     218,     0,   219,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,     0,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   229,   230,   231,   232,
     233,   234,   235,   236,     0,     0,     0,     0,     0,     0,
       0,     0,   237,     0,     0,   238,     0,   379,    83,    84,
      85,     0,    87,    88,    89,    90,    91,     0,     0,     0,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,   109,
       0,   110,   111,   112, -1531,   113,   114,   115,     0,     0,
       0,     0,     0,   118,   119,     0,     0,     0,     0,   120,
       0,     0,     0,     0,     0,     0,     0,     0,   121,     0,
     122,     0,   123,   124,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   130,     0,
       0,     0,   132,   133,   134,   135,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   136,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   148,   149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,     0,     0,     0,     0,     0,   157,
       0,     0,   159,     0,     0,     0,     0,   161,     0,     0,
       0,     0,   162,     0,   163,     0,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     168,   169,     0,     0,     0,     0,     0,   171,     0,   172,
       0,     0,   173,   174,     0,   175,     0,     0,     0,     0,
       0,     0,   176,   177,     0,   178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,   185,     0,     0,
       0,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       0,   188,     0,     0,   189,     0,   190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   191,
     192,   193,   194,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   198,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,   206,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,   217,     0,     0,
       0,   218,     0,   219,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   229,   230,   231,
     232,   233,   234,   235,   236,     0,     0,     0,     0,     0,
       0,     0,     0,   237,     0,     0,   238,     0,  1024,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,   669,   406,   407,   408,   670,
     671,   672,   673,   674,   675,   676,   409,   410,   677,   411,
     130,   412,   413,   414,   132,   133,   134,   135,     0,   678,
     415,   416,     0,   417,   418,   679,   680,   419,   681,   136,
     421,   682,   422,   423,   424,   425,   140,   683,   684,   426,
     427,   428,   429,   430,   431,   685,   432,   433,   434,   435,
     436,   686,   437,   438,   439,   145,   440,   687,   688,   689,
     690,   691,   692,   441,   442,   443,   444,   445,   148,   149,
     446,   693,   447,   694,   448,     0,   449,   450,   451,   695,
     452,   453,   454,   696,   697,   455,   456,   457,   458,   459,
     698,   460,   461,   462,   699,     0,   463,   700,   464,   465,
     466,   157,   467,   468,   159,   701,   469,   470,   471,   161,
     702,   472,   703,   473,   162,   704,   163,   474,     0,   475,
     705,   476,   166,   706,   477,   707,   478,   479,   480,   481,
     167,   482,   483,   484,   708,   485,   486,   487,   488,   489,
     490,   709,   168,   169,   710,   491,   492,   493,   711,   171,
     712,   172,   713,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,   714,   176,   177,   500,   178,   715,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,   184,   185,
     716,   517,   518,   519,   520,   521,   522,   523,   186,   524,
     717,   525,   526,   188,   527,   718,   189,   528,   190,   529,
     530,   719,   720,   531,   721,   722,   723,   532,   533,   724,
     725,   191,   192,   193,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,   726,   543,   544,
     545,   546,   547,   548,   198,   549,   550,   727,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,   728,   561,
     562,   204,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,   729,   572,   573,   574,   730,   575,   210,
     576,   577,   212,   578,   213,   731,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,   732,   590,
     591,   733,   592,   593,   594,   595,   596,   734,   216,   217,
     735,   736,   598,   218,   599,   219,   737,   600,   601,   602,
     603,   604,   738,   739,   605,   606,   607,   608,   740,   741,
     609,   610,   611,   612,     0,   227,   614,   228,   615,   616,
     617,   742,   743,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,   133,   134,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,   176,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,   184,   185,
     791,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,   188,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,   792,     0,     0,   532,   533,     0,
       0,   191,   192,   193,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,   212,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,   133,   134,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,  1183,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,   176,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,   184,   185,
     791,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,   188,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,   792,     0,     0,   532,   533,     0,
       0,   191,   192,   193,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,   212,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,   133,   134,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,  1190,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,   176,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,   184,   185,
     791,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,   188,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,   792,     0,     0,   532,   533,     0,
       0,   191,   192,   193,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,   212,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,  2045,   485,   486,   487,   488,   489,
     490,     0,   168,  2046,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,  2047,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  2048,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,     0,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,  2067,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,     0,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  1612,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,  1461,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,  2459,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
    2460,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,   791,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,   792,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
    2461,   592,  2462,   594,  2463,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,     0,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,  3020,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,     0,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  1612,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,     0,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   188,   527,  2037,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,     0,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  2048,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,   649,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,   650,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
     651,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,     0,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,     0,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  1612,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,     0,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,     0,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,  2048,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,   838,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,   839,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   840,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,   662,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
     663,   102,   103,   388,   664,     0,   105,   106,   107,   108,
     665,   666,     0,   110,   111,   112,     0,   113,   667,   668,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
     130,   412,   413,   414,   132,  1599,   134,  1600,  1273,     0,
     415,   416,     0,   417,   418,     0,     0,   419,  1601,  1602,
     421,     0,   422,   423,   424,   425,     0,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,   145,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,  1603,  1604,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,  1286,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,     0,   467,   468,     0,     0,   469,   470,   471,  1605,
       0,   472,     0,   473,   162,     0,   163,   474,     0,   475,
       0,   476,     0,     0,   477,     0,   478,   479,   480,   481,
     167,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,   168,     0,     0,   491,   492,   493,  1292,  1606,
       0,  1607,     0,     0,   173,   174,   494,   175,   495,   496,
     497,   498,   499,     0,     0,   177,   500,   178,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,  1608,   184,  1609,
       0,   517,   518,   519,   520,   521,   522,   523,     0,   524,
       0,   525,   526,   188,   527,     0,     0,   528,  1610,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,     0,   192,   193,     0,   534,   535,   536,   537,   538,
       0,   539,     0,     0,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,  1611,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,   204,   563,   564,     0,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,     0,
     576,   577,   212,   578,  1613,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,     0,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,  1614,  1615,
       0,     0,   598,     0,   599,     0,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,     0,  1616,   614,   228,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,     0,
       0,     0,     0,     0,     0,     0,     0,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
     651,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,  1178,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     879,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   920,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,   627,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   398,   399,   400,   401,
     402,   403,   404,   405,   669,   406,   407,   408,   670,   671,
     672,   673,   674,   675,   676,   409,   410,   677,   411,   130,
     412,   413,   414,   132,   133,   134,   135,     0,   678,   415,
     416,     0,   417,   418,   679,   680,   419,     0,   136,   421,
     682,   422,   423,   424,   425,   140,   683,   684,   426,   427,
     428,   429,   430,   431,   685,   432,   433,   434,   435,   436,
     686,   437,   438,   439,   145,   440,   687,   688,   689,   690,
     691,   692,   441,   442,   443,     0,   445,   148,   149,   446,
     693,   447,   694,   448,     0,   449,   450,   451,   695,   452,
     453,   454,   696,   697,   455,   456,   457,   458,   459,   698,
     460,   461,   462,   699,     0,   463,   700,   464,   465,   466,
     157,   467,   468,   159,   701,   469,   470,   471,   161,   702,
     472,   703,   473,   162,   704,   163,   474,     0,   475,   705,
     476,   166,   706,   477,   707,   478,   479,     0,   481,   167,
     482,   483,   484,   708,   485,   486,   487,   488,   489,   490,
     709,   168,   169,     0,   491,   492,   493,     0,   171,   712,
     172,   713,     0,   173,   174,   494,   175,   495,   496,   497,
     498,   499,   714,   176,   177,   500,   178,   715,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,     0,
     511,   512,     0,   514,   515,   516,   183,   184,   185,   716,
     517,   518,   519,   520,   521,   522,   523,   186,   524,   717,
     525,   526,   188,   527,   718,   189,   528,   190,   529,   530,
     719,   720,   531,   721,   722,   723,   532,   533,   724,   725,
     191,   192,   193,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,   726,   543,   544,   545,
     546,   547,   548,   198,   549,   550,   727,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,   728,   561,   562,
     204,   563,   564,   206,   565,   566,   567,   568,   569,   570,
       0,     0,   729,   572,   573,   574,   730,   575,   210,   576,
     577,   212,   578,   213,   731,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,   732,   590,   591,
     733,   592,   593,   594,   595,   596,   734,   216,   217,     0,
     736,   598,   218,   599,   219,   737,   600,   601,   602,   603,
     604,     0,   739,   605,   606,   607,   608,   740,   741,   609,
     610,   611,   612,     0,   227,   614,   228,   615,   616,   617,
     742,   743,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,     0,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,  2018,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,  2019,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
    2020,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,  2724,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,  2021,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,  2022,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,   903,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,   904,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,   944,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,   905,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
     906,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   903,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,   904,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,   905,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,   906,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,   127,   128,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,   791,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,   792,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,   791,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,   792,     0,
     977,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,  1373,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,   791,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,   792,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,  1748,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,  1749,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,  1750,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,   791,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,   792,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
    1751,   569,   570,   571,     0,     0,  1752,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,  1753,  1754,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,   904,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,   905,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,   906,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
     791,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,   792,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,   888,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,   889,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,  2609,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,  2610,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,  2619,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,  2620,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,   658,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
     789,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,  2760,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   420,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,   431,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     574,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   216,   217,     0,     0,   598,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   613,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,  2773,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,  2807,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,  3115,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,  3117,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,   481,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
    3119,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,   481,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,  3718,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   844,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,   481,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   928,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,   930,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,     0,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   931,   136,   421,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,     0,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     516,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   563,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
     932,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   933,   217,     0,     0,   934,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   935,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,   966,   406,
     407,   408,     0,     0,     0,     0,     0,     0,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   931,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,     0,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   967,
       0,   575,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   968,   217,     0,     0,   969,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   935,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,    83,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,  1188,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,   429,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
    1192,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,  1200,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,  1202,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,  1204,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,   567,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   420,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,   431,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,  1207,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   516,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   563,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,   574,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   216,   217,     0,     0,   598,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   613,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   623,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   420,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
     431,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,  1209,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   516,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   563,   564,
     206,   565,   566,   567,   568,   569,   570,   571,     0,     0,
     572,   573,   574,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   216,   217,     0,     0,   598,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     613,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   623,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,   385,    87,
      88,    89,    90,    91,   386,     0,   387,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,   388,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   389,   390,     0,     0,     0,
     391,   392,     0,     0,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,   394,     0,   395,     0,   396,
     397,     0,   398,   399,   400,   401,   402,   403,   404,   405,
       0,   406,   407,   408,     0,     0,     0,     0,     0,     0,
       0,   409,   410,     0,   411,     0,   412,   413,   414,     0,
     133,     0,   135,     0,     0,   415,   416,     0,   417,   418,
       0,     0,   419,   420,   136,   421,     0,   422,   423,   424,
     425,   140,     0,     0,   426,   427,   428,   429,   430,   431,
       0,   432,   433,   434,   435,   436,     0,   437,   438,   439,
       0,   440,     0,     0,     0,     0,     0,     0,   441,   442,
     443,   444,   445,   148,   149,   446,     0,   447,     0,   448,
       0,   449,   450,   451,     0,   452,   453,   454,     0,     0,
     455,   456,   457,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   464,   465,   466,   157,   467,   468,   159,
       0,   469,   470,   471,   161,     0,   472,     0,   473,     0,
       0,     0,   474,     0,   475,     0,   476,   166,     0,   477,
       0,   478,   479,   480,  1212,     0,   482,   483,   484,     0,
     485,   486,   487,   488,   489,   490,     0,     0,   169,     0,
     491,   492,   493,     0,   171,     0,   172,     0,     0,     0,
       0,   494,     0,   495,   496,   497,   498,   499,     0,   176,
       0,   500,     0,     0,   501,   502,   503,     0,     0,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   183,     0,   185,     0,   517,   518,   519,   520,
     521,   522,   523,   186,   524,     0,   525,   526,     0,   527,
       0,   189,   528,   190,   529,   530,     0,     0,   531,     0,
       0,     0,   532,   533,     0,     0,   191,     0,     0,   194,
     534,   535,   536,   537,   538,     0,   539,   195,   196,   540,
     541,   542,     0,   543,   544,   545,   546,   547,   548,   198,
     549,   550,     0,   551,   552,   553,   554,   555,   556,   557,
     558,   559,   560,     0,   561,   562,     0,   563,   564,   206,
     565,   566,   567,   568,   569,   570,   571,     0,     0,   572,
     573,   574,     0,   575,   210,   576,   577,     0,   578,   213,
       0,   579,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   215,   589,     0,   590,   591,     0,   592,   593,   594,
     595,   596,     0,   216,   217,     0,     0,   598,   218,   599,
     219,     0,   600,   601,   602,   603,   604,     0,     0,   605,
     606,   607,   608,     0,     0,   609,   610,   611,   612,   613,
     227,   614,     0,   615,   616,   617,     0,     0,   618,   619,
     620,   621,   622,   623,   229,   230,   231,   232,   233,   234,
     235,   236,   624,   625,   626,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,   385,    87,    88,
      89,    90,    91,   386,     0,   387,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,   388,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   389,   390,     0,     0,     0,   391,
     392,     0,     0,     0,     0,   393,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,   395,     0,   396,   397,
       0,   398,   399,   400,   401,   402,   403,   404,   405,     0,
     406,   407,   408,     0,     0,     0,     0,     0,     0,     0,
     409,   410,     0,   411,  1384,   412,   413,   414,     0,   133,
       0,   135,     0,     0,   415,   416,     0,   417,   418,     0,
       0,   419,   931,   136,  1385,     0,   422,   423,   424,   425,
     140,     0,     0,   426,   427,   428,   429,   430,     0,     0,
     432,   433,   434,   435,   436,     0,   437,   438,   439,     0,
     440,     0,     0,     0,     0,     0,     0,   441,   442,   443,
     444,   445,   148,   149,   446,     0,   447,     0,   448,     0,
     449,   450,   451,     0,   452,   453,   454,     0,     0,   455,
     456,   457,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,   464,   465,   466,   157,   467,   468,   159,     0,
     469,   470,   471,   161,     0,   472,     0,   473,     0,     0,
       0,   474,     0,   475,     0,   476,   166,     0,   477,     0,
     478,   479,   480,   481,     0,   482,   483,   484,     0,   485,
     486,   487,   488,   489,   490,     0,     0,   169,     0,   491,
     492,   493,     0,   171,     0,   172,     0,     0,     0,     0,
     494,     0,   495,   496,   497,   498,   499,     0,   176,     0,
     500,     0,     0,   501,   502,   503,     0,     0,   504,   505,
     506,   507,   508,   509,   510,   511,   512,   513,   514,   515,
     958,   183,     0,   185,     0,   517,   518,   519,   520,   521,
     522,   523,   186,   524,     0,   525,   526,     0,   527,     0,
     189,   528,   190,   529,   530,     0,     0,   531,     0,     0,
       0,   532,   533,     0,     0,   191,     0,     0,   194,   534,
     535,   536,   537,   538,     0,   539,   195,   196,   540,   541,
     542,     0,   543,   544,   545,   546,   547,   548,   198,   549,
     550,     0,   551,   552,   553,   554,   555,   556,   557,   558,
     559,   560,     0,   561,   562,     0,   959,   564,   206,   565,
     566,   567,   568,   569,   570,   571,     0,     0,   572,   573,
    1376,     0,   575,   210,   576,   577,     0,   578,   213,     0,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     215,   589,     0,   590,   591,     0,   592,   593,   594,   595,
     596,     0,   961,   217,     0,     0,   962,   218,   599,   219,
       0,   600,   601,   602,   603,   604,     0,     0,   605,   606,
     607,   608,     0,     0,   609,   610,   611,   612,   935,   227,
     614,     0,   615,   616,   617,     0,     0,   618,   619,   620,
     621,   622,   963,   229,   230,   231,   232,   233,   234,   235,
     236,   624,   625,   626,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,   385,    87,    88,    89,
      90,    91,   386,     0,   387,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,   388,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   389,   390,     0,     0,     0,   391,   392,
       0,     0,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,   395,     0,   396,   397,     0,
     398,   399,   400,   401,   402,   403,   404,   405,     0,   406,
     407,   408,     0,     0,     0,     0,     0,  1402,     0,   409,
     410,     0,   411,     0,   412,   413,   414,     0,   133,     0,
     135,     0,     0,   415,   416,     0,   417,   418,     0,     0,
     419,   420,   136,   421,     0,   422,   423,   424,   425,   140,
       0,     0,   426,   427,   428,   429,   430,   431,     0,   432,
     433,   434,   435,   436,     0,   437,   438,   439,     0,   440,
       0,     0,     0,     0,     0,     0,   441,   442,   443,   444,
     445,   148,   149,   446,     0,   447,     0,   448,     0,   449,
     450,   451,     0,   452,   453,   454,     0,     0,   455,   456,
     457,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   464,   465,   466,   157,   467,   468,   159,     0,   469,
     470,   471,   161,     0,   472,     0,   473,     0,     0,     0,
     474,     0,   475,     0,   476,   166,     0,   477,     0,   478,
     479,   480,   481,     0,   482,   483,   484,     0,   485,   486,
     487,   488,   489,   490,     0,     0,   169,     0,   491,   492,
     493,     0,   171,     0,   172,     0,     0,     0,     0,   494,
       0,   495,   496,   497,   498,   499,     0,   176,     0,   500,
       0,     0,   501,   502,   503,     0,     0,   504,   505,   506,
     507,   508,   509,   510,   511,   512,   513,   514,   515,   516,
     183,     0,   185,     0,   517,   518,   519,   520,   521,   522,
     523,   186,   524,     0,   525,   526,     0,   527,     0,   189,
     528,   190,   529,   530,     0,     0,   531,     0,     0,     0,
     532,   533,     0,     0,   191,     0,     0,   194,   534,   535,
     536,   537,   538,     0,   539,   195,   196,   540,   541,   542,
       0,   543,   544,   545,   546,   547,   548,   198,   549,   550,
       0,   551,   552,   553,   554,   555,   556,   557,   558,   559,
     560,     0,   561,   562,     0,   563,   564,   206,   565,   566,
     567,   568,   569,   570,   571,     0,     0,   572,   573,   574,
       0,     0,   210,   576,   577,     0,   578,   213,     0,   579,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   215,
     589,     0,   590,   591,     0,   592,   593,   594,   595,   596,
       0,   216,   217,     0,     0,   598,   218,   599,   219,     0,
     600,   601,   602,   603,   604,     0,     0,   605,   606,   607,
     608,     0,     0,   609,   610,   611,   612,   613,   227,   614,
       0,   615,   616,   617,     0,     0,   618,   619,   620,   621,
     622,   623,   229,   230,   231,   232,   233,   234,   235,   236,
     624,   625,   626,     0,     0,     0,     0,     0,   237,     0,
       0,   238,  1474,    84,    85,   385,    87,    88,    89,    90,
      91,   386,     0,   387,    94,     0,    96,    97,    98,    99,
     100,   101,     0,   102,   103,   388,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   389,   390,     0,     0,     0,   391,   392,     0,
       0,     0,     0,   393,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,   395,     0,   396,   397,     0,   398,
     399,   400,   401,   402,   403,   404,   405,     0,   406,   407,
     408,     0,     0,     0,     0,     0,     0,     0,   409,   410,
       0,   411,     0,   412,   413,   414,     0,   133,     0,   135,
       0,     0,   415,   416,     0,   417,   418,     0,     0,   419,
     420,   136,   421,     0,   422,   423,   424,   425,   140,     0,
       0,   426,   427,   428,   429,   430,   431,     0,   432,   433,
     434,   435,   436,     0,   437,   438,   439,     0,   440,     0,
       0,     0,     0,     0,     0,   441,   442,   443,   444,   445,
     148,   149,   446,     0,   447,     0,   448,     0,   449,   450,
     451,     0,   452,   453,   454,     0,     0,   455,   456,   457,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
     464,   465,   466,   157,   467,   468,   159,     0,   469,   470,
     471,   161,     0,   472,     0,   473,     0,     0,     0,   474,
       0,   475,     0,   476,   166,     0,   477,     0,   478,   479,
     480,   481,     0,   482,   483,   484,     0,   485,   486,   487,
     488,   489,   490,     0,     0,   169,     0,   491,   492,   493,
       0,   171,     0,   172,     0,     0,     0,     0,   494,     0,
     495,   496,   497,   498,   499,     0,   176,     0,   500,     0,
       0,   501,   502,   503,     0,     0,   504,   505,   506,   507,
     508,   509,   510,   511,   512,   513,   514,   515,   516,   183,
       0,   185,     0,   517,   518,   519,   520,   521,   522,   523,
     186,   524,     0,   525,   526,     0,   527,     0,   189,   528,
     190,   529,   530,     0,     0,   531,     0,     0,     0,   532,
     533,     0,     0,   191,     0,     0,   194,   534,   535,   536,
     537,   538,     0,   539,   195,   196,   540,   541,   542,     0,
     543,   544,   545,   546,   547,   548,   198,   549,   550,     0,
     551,   552,   553,   554,   555,   556,   557,   558,   559,   560,
       0,   561,   562,     0,   563,   564,   206,   565,   566,   567,
     568,   569,   570,   571,     0,     0,   572,   573,   574,     0,
     575,   210,   576,   577,     0,   578,   213,     0,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   215,   589,
       0,   590,   591,     0,   592,   593,   594,   595,   596,     0,
     216,   217,     0,     0,   598,   218,   599,   219,     0,   600,
     601,   602,   603,   604,     0,     0,   605,   606,   607,   608,
       0,     0,   609,   610,   611,   612,   613,   227,   614,     0,
     615,   616,   617,     0,     0,   618,   619,   620,   621,   622,
     623,   229,   230,   231,   232,   233,   234,   235,   236,   624,
     625,   626,     0,     0,     0,     0,     0,   237,     0,     0,
     238,    83,    84,    85,   385,    87,    88,    89,    90,    91,
     386,     0,   387,    94,     0,    96,    97,    98,    99,   100,
     101,     0,   102,   103,   388,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   389,   390,     0,     0,     0,   391,   392,     0,     0,
       0,     0,   393,     0,     0,     0,     0,     0,     0,     0,
       0,   394,     0,   395,     0,   396,   397,     0,   398,   399,
     400,   401,   402,   403,   404,   405,     0,   406,   407,   408,
       0,     0,     0,     0,     0,     0,     0,   409,   410,     0,
     411,     0,   412,   413,   414,     0,   133,     0,   135,     0,
       0,   415,   416,     0,   417,   418,     0,     0,   419,   420,
     136,   421,     0,   422,   423,   424,   425,   140,     0,     0,
     426,   427,   428,  1665,   430,   431,     0,   432,   433,   434,
     435,   436,     0,   437,   438,   439,     0,   440,     0,     0,
       0,     0,     0,     0,   441,   442,   443,   444,   445,   148,
     149,   446,     0,   447,     0,   448,     0,   449,   450,   451,
       0,   452,   453,   454,     0,     0,   455,   456,   457,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,   464,
     465,   466,   157,   467,   468,   159,     0,   469,   470,   471,
     161,     0,   472,     0,   473,     0,     0,     0,   474,     0,
     475,     0,   476,   166,     0,   477,     0,   478,   479,   480,
     481,     0,   482,   483,   484,     0,   485,   486,   487,   488,
     489,   490,     0,     0,   169,     0,   491,   492,   493,     0,
     171,     0,   172,     0,     0,     0,     0,   494,     0,   495,
     496,   497,   498,   499,     0,   176,     0,   500,     0,     0,
     501,   502,   503,     0,     0,   504,   505,   506,   507,   508,
     509,   510,   511,   512,   513,   514,   515,   516,   183,     0,
     185,     0,   517,   518,   519,   520,   521,   522,   523,   186,
     524,     0,   525,   526,     0,   527,     0,   189,   528,   190,
     529,   530,     0,     0,   531,     0,     0,     0,   532,   533,
       0,     0,   191,     0,     0,   194,   534,   535,   536,   537,
     538,     0,   539,   195,   196,   540,   541,   542,     0,   543,
     544,   545,   546,   547,   548,   198,   549,   550,     0,   551,
     552,   553,   554,   555,   556,   557,   558,   559,   560,     0,
     561,   562,     0,   563,   564,   206,   565,   566,   567,   568,
     569,   570,   571,     0,     0,   572,   573,   574,     0,   575,
     210,   576,   577,     0,   578,   213,     0,   579,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   215,   589,     0,
     590,   591,     0,   592,   593,   594,   595,   596,     0,   216,
     217,     0,     0,   598,   218,   599,   219,     0,   600,   601,
     602,   603,   604,     0,     0,   605,   606,   607,   608,     0,
       0,   609,   610,   611,   612,   613,   227,   614,     0,   615,
     616,   617,     0,     0,   618,   619,   620,   621,   622,   623,
     229,   230,   231,   232,   233,   234,   235,   236,   624,   625,
     626,     0,     0,     0,     0,     0,   237,     0,     0,   238,
      83,    84,    85,   385,    87,    88,    89,    90,    91,   386,
       0,   387,    94,     0,    96,    97,    98,    99,   100,   101,
       0,   102,   103,   388,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     389,   390,     0,     0,     0,   391,   392,     0,     0,     0,
       0,   393,     0,     0,     0,     0,     0,     0,     0,     0,
     394,     0,   395,     0,   396,   397,     0,   398,   399,   400,
     401,   402,   403,   404,   405,     0,   406,   407,   408,     0,
       0,     0,     0,     0,     0,     0,   409,   410,     0,   411,
       0,   412,   413,   414,     0,   133,     0,   135,     0,     0,
     415,   416,     0,   417,   418,     0,     0,   419,   420,   136,
     421,     0,   422,   423,   424,   425,   140,     0,     0,   426,
     427,   428,   429,   430,   431,     0,   432,   433,   434,   435,
     436,     0,   437,   438,   439,     0,   440,     0,     0,     0,
       0,     0,     0,   441,   442,   443,   444,   445,   148,   149,
     446,     0,   447,     0,   448,     0,   449,   450,   451,     0,
     452,   453,   454,     0,     0,   455,   456,   457,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,   464,   465,
     466,   157,   467,   468,   159,     0,   469,   470,   471,   161,
       0,   472,     0,   473,     0,     0,     0,   474,     0,   475,
       0,   476,   166,     0,   477,     0,   478,   479,   480,  1691,
       0,   482,   483,   484,     0,   485,   486,   487,   488,   489,
     490,     0,     0,   169,     0,   491,   492,   493,     0,   171,
       0,   172,     0,     0,     0,     0,   494,     0,   495,   496,
     497,   498,   499,     0,   176,     0,   500,     0,     0,   501,
     502,   503,     0,     0,   504,   505,   506,   507,   508,   509,
     510,   511,   512,   513,   514,   515,   516,   183,     0,   185,
       0,   517,   518,   519,   520,   521,   522,   523,   186,   524,
       0,   525,   526,     0,   527,     0,   189,   528,   190,   529,
     530,     0,     0,   531,     0,     0,     0,   532,   533,     0,
       0,   191,     0,     0,   194,   534,   535,   536,   537,   538,
       0,   539,   195,   196,   540,   541,   542,     0,   543,   544,
     545,   546,   547,   548,   198,   549,   550,     0,   551,   552,
     553,   554,   555,   556,   557,   558,   559,   560,     0,   561,
     562,     0,   563,   564,   206,   565,   566,   567,   568,   569,
     570,   571,     0,     0,   572,   573,   574,     0,   575,   210,
     576,   577,     0,   578,   213,     0,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   215,   589,     0,   590,
     591,     0,   592,   593,   594,   595,   596,     0,   216,   217,
       0,     0,   598,   218,   599,   219,     0,   600,   601,   602,
     603,   604,     0,     0,   605,   606,   607,   608,     0,     0,
     609,   610,   611,   612,   613,   227,   614,     0,   615,   616,
     617,     0,     0,   618,   619,   620,   621,   622,   623,   229,
     230,   231,   232,   233,   234,   235,   236,   624,   625,   626,
       0,     0,     0,     0,     0,   237,     0,     0,   238,    83,
      84,    85,   385,    87,    88,    89,    90,    91,   386,     0,
     387,    94,     0,    96,    97,    98,    99,   100,   101,     0,
     102,   103,   388,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   389,
     390,     0,     0,     0,   391,   392,     0,     0,     0,     0,
     393,     0,     0,     0,     0,     0,     0,     0,     0,   394,
       0,   395,     0,   396,   397,     0,   398,   399,   400,   401,
     402,   403,   404,   405,     0,   406,   407,   408,     0,     0,
       0,     0,     0,     0,     0,   409,   410,     0,   411,     0,
     412,   413,   414,     0,   133,     0,   135,     0,     0,   415,
     416,     0,   417,   418,     0,     0,   419,   420,   136,   421,
       0,   422,   423,   424,   425,   140,     0,     0,   426,   427,
     428,   429,   430,   431,     0,   432,   433,   434,   435,   436,
       0,   437,   438,   439,     0,   440,     0,     0,     0,     0,
       0,     0,   441,   442,   443,   444,   445,   148,   149,   446,
       0,   447,     0,   448,     0,   449,   450,   451,     0,   452,
     453,   454,     0,     0,   455,   456,   457,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   464,   465,   466,
     157,   467,   468,   159,     0,   469,   470,   471,   161,     0,
     472,     0,   473,     0,     0,     0,   474,     0,   475,     0,
     476,   166,     0,   477,     0,   478,   479,   480,  1693,     0,
     482,   483,   484,     0,   485,   486,   487,   488,   489,   490,
       0,     0,   169,     0,   491,   492,   493,     0,   171,     0,
     172,     0,     0,     0,     0,   494,     0,   495,   496,   497,
     498,   499,     0,   176,     0,   500,     0,     0,   501,   502,
     503,     0,     0,   504,   505,   506,   507,   508,   509,   510,
     511,   512,   513,   514,   515,   516,   183,     0,   185,     0,
     517,   518,   519,   520,   521,   522,   523,   186,   524,     0,
     525,   526,     0,   527,     0,   189,   528,   190,   529,   530,
       0,     0,   531,     0,     0,     0,   532,   533,     0,     0,
     191,     0,     0,   194,   534,   535,   536,   537,   538,     0,
     539,   195,   196,   540,   541,   542,     0,   543,   544,   545,
     546,   547,   548,   198,   549,   550,     0,   551,   552,   553,
     554,   555,   556,   557,   558,   559,   560,     0,   561,   562,
       0,   563,   564,   206,   565,   566,   567,   568,   569,   570,
     571,     0,     0,   572,   573,   574,     0,   575,   210,   576,
     577,     0,   578,   213,     0,   579,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   215,   589,     0,   590,   591,
       0,   592,   593,   594,   595,   596,     0,   216,   217,     0,
       0,   598,   218,   599,   219,     0,   600,   601,   602,   603,
     604,     0,     0,   605,   606,   607,   608,     0,     0,   609,
     610,   611,   612,   613,   227,   614,     0,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   229,   230,
     231,   232,   233,   234,   235,   236,   624,   625,   626,     0,
       0,     0,     0,     0,   237,     0,     0,   238,    83,    84,
      85,   385,    87,    88,    89,    90,    91,   386,     0,   387,
      94,     0,    96,    97,    98,    99,   100,   101,     0,   102,
     103,   388,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   389,   390,
       0,     0,     0,   391,   392,     0,     0,     0,     0,   393,
       0,     0,     0,     0,     0,     0,     0,     0,   394,     0,
     395,     0,   396,   397,     0,   398,   399,   400,   401,   402,
     403,   404,   405,     0,   406,   407,   408,     0,     0,     0,
       0,     0,     0,     0,   409,   410,     0,   411,     0,   412,
     413,   414,     0,   133,     0,   135,     0,     0,   415,   416,
       0,   417,   418,     0,     0,   419,   420,   136,   421,     0,
     422,   423,   424,   425,   140,     0,     0,   426,   427,   428,
     429,   430,   431,     0,   432,   433,   434,   435,   436,     0,
     437,   438,   439,     0,   440,     0,     0,     0,     0,     0,
       0,   441,   442,   443,   444,   445,   148,   149,   446,     0,
     447,     0,   448,     0,   449,   450,   451,     0,   452,   453,
     454,     0,     0,   455,   456,   457,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,   464,   465,   466,   157,
     467,   468,   159,     0,   469,   470,   471,   161,     0,   472,
       0,   473,     0,     0,     0,   474,     0,   475,     0,   476,
     166,     0,   477,     0,   478,   479,   480,   481,     0,   482,
     483,   484,     0,   485,   486,   487,   488,   489,   490,     0,
       0,   169,     0,   491,   492,   493,     0,   171,     0,   172,
       0,     0,     0,     0,   494,     0,   495,   496,   497,   498,
     499,     0,   176,     0,   500,     0,     0,   501,   502,   503,
       0,     0,   504,   505,   506,   507,   508,   509,   510,   511,
     512,   513,   514,   515,   516,   183,     0,   185,     0,   517,
     518,   519,   520,   521,   522,   523,   186,   524,     0,   525,
     526,     0,   527,     0,   189,   528,   190,   529,   530,     0,
       0,   531,     0,     0,     0,   532,   533,     0,     0,   191,
       0,     0,   194,   534,   535,   536,   537,   538,     0,   539,
     195,   196,   540,   541,   542,     0,   543,   544,   545,   546,
     547,   548,   198,   549,   550,     0,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,     0,   561,   562,     0,
     563,   564,   206,   565,   566,  1781,   568,   569,   570,   571,
       0,     0,   572,   573,   574,     0,   575,   210,   576,   577,
       0,   578,   213,     0,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   215,   589,     0,   590,   591,     0,
     592,   593,   594,   595,   596,     0,   216,   217,     0,     0,
     598,   218,   599,   219,     0,   600,   601,   602,   603,   604,
       0,     0,   605,   606,   607,   608,     0,     0,   609,   610,
     611,   612,   613,   227,   614,     0,   615,   616,   617,     0,
       0,   618,   619,   620,   621,   622,   623,   229,   230,   231,
     232,   233,   234,   235,   236,   624,   625,   626,     0,     0,
       0,     0,     0,   237,     0,     0,   238,    83,    84,    85,
     385,    87,    88,    89,    90,    91,   386,     0,   387,    94,
       0,    96,    97,    98,    99,   100,   101,     0,   102,   103,
     388,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   389,   390,     0,
       0,     0,   391,   392,     0,     0,     0,     0,   393,     0,
       0,     0,     0,     0,     0,     0,     0,   394,     0,   395,
       0,   396,   397,     0,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,     0,     0,     0,
       0,     0,     0,   409,   410,     0,   411,     0,   412,   413,
     414,     0,   133,     0,   135,     0,     0,   415,   416,     0,
     417,   418,     0,     0,   419,   931,   136,   421,     0,   422,
     423,   424,   425,   140,     0,     0,   426,   427,   428,   429,
     430,     0,     0,   432,   433,   434,   435,   436,     0,   437,
     438,   439,     0,   440,     0,     0,     0,     0,     0,     0,
     441,   442,   443,   444,   445,   148,   149,   446,     0,   447,
       0,   448,     0,   449,   450,   451,     0,   452,   453,   454,
       0,     0,   455,   456,   457,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   464,   465,   466,   157,   467,
     468,   159,     0,   469,   470,   471,   161,     0,   472,     0,
     473,     0,     0,     0,   474,     0,   475,     0,   476,   166,
       0,   477,     0,   478,   479,   480,   481,     0,   482,   483,
     484,     0,   485,   486,   487,   488,   489,   490,     0,     0,
     169,     0,   491,   492,   493,     0,   171,     0,   172,     0,
       0,     0,     0,   494,     0,   495,   496,   497,   498,   499,
       0,   176,     0,   500,     0,     0,   501,   502,   503,     0,
       0,   504,   505,   506,   507,   508,   509,   510,   511,   512,
     513,   514,   515,   958,   183,     0,   185,     0,   517,   518,
     519,   520,   521,   522,   523,   186,   524,     0,   525,   526,
       0,   527,     0,   189,   528,   190,   529,   530,     0,     0,
     531,     0,     0,     0,   532,   533,     0,     0,   191,     0,
       0,   194,   534,   535,   536,   537,   538,     0,   539,   195,
     196,   540,   541,   542,     0,   543,   544,   545,   546,   547,
     548,   198,   549,   550,     0,   551,   552,   553,   554,   555,
     556,   557,   558,   559,   560,     0,   561,   562,     0,   959,
     564,   206,   565,   566,   567,   568,   569,   570,   571,     0,
       0,   572,   573,  1376,     0,   575,   210,   576,   577,     0,
     578,   213,     0,   579,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   215,   589,     0,   590,   591,     0,   592,
     593,   594,   595,   596,     0,   961,   217,     0,     0,   962,
     218,   599,   219,     0,   600,   601,   602,   603,   604,     0,
       0,   605,   606,   607,   608,     0,     0,   609,   610,   611,
     612,   935,   227,   614,     0,   615,   616,   617,     0,     0,
     618,   619,   620,   621,   622,   963,   229,   230,   231,   232,
     233,   234,   235,   236,   624,   625,   626,     0,     0,     0,
       0,     0,   237,     0,     0,   238,    83,    84,    85,   385,
      87,    88,    89,    90,    91,   386,     0,   387,    94,     0,
      96,    97,    98,    99,   100,   101,     0,   102,   103,   388,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   389,   390,     0,     0,
       0,   391,   392,     0,     0,     0,     0,   393,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,   395,     0,
     396,   397,     0,   398,   399,   400,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,     0,     0,     0,     0,
       0,     0,   409,   410,     0,   411,     0,   412,   413,   414,
       0,   133,     0,   135,     0,     0,   415,   416,     0,   417,
     418,     0,     0,   419,   931,   136,   421,     0,   422,   423,
     424,   425,   140,     0,     0,   426,   427,   428,   429,   430,
       0,     0,   432,   433,   434,   435,   436,     0,   437,   438,
     439,     0,   440,     0,     0,     0,     0,     0,     0,   441,
     442,   443,   444,   445,   148,   149,   446,     0,   447,     0,
     448,     0,   449,   450,   451,     0,   452,   453,   454,     0,
       0,   455,   456,   457,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,   464,   465,   466,   157,   467,   468,
     159,     0,   469,   470,   471,   161,     0,   472,     0,   473,
       0,     0,     0,   474,     0,   475,     0,   476,   166,     0,
     477,     0,   478,   479,   480,   481,     0,   482,   483,   484,
       0,   485,   486,   487,   488,   489,   490,     0,     0,   169,
       0,   491,   492,   493,     0,   171,     0,   172,     0,     0,
       0,     0,   494,     0,   495,   496,   497,   498,   499,     0,
     176,     0,   500,     0,     0,   501,   502,   503,     0,     0,
     504,   505,   506,   507,   508,   509,   510,   511,   512,   513,
     514,   515,   958,   183,     0,   185,     0,   517,   518,   519,
     520,   521,   522,   523,   186,   524,     0,   525,   526,     0,
     527,     0,   189,   528,   190,   529,   530,     0,     0,   531,
       0,     0,     0,   532,   533,     0,     0,   191,     0,     0,
     194,   534,   535,   536,   537,   538,     0,   539,   195,   196,
     540,   541,   542,     0,   543,   544,   545,   546,   547,   548,
     198,   549,   550,     0,   551,   552,   553,   554,   555,   556,
     557,   558,   559,   560,     0,   561,   562,     0,   959,   564,
     206,   565,   566,   567,  2041,   569,   570,   571,     0,     0,
     572,   573,  1376,     0,   575,   210,   576,   577,     0,   578,
     213,     0,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   215,   589,     0,   590,   591,     0,   592,   593,
     594,   595,   596,     0,   961,   217,     0,     0,   962,   218,
     599,   219,     0,   600,   601,   602,   603,   604,     0,     0,
     605,   606,   607,   608,     0,     0,   609,   610,   611,   612,
     935,   227,   614,     0,   615,   616,   617,     0,     0,   618,
     619,   620,   621,   622,   963,   229,   230,   231,   232,   233,
     234,   235,   236,   624,   625,   626,     0,     0,     0,     0,
       0,   237,     0,     0,   238,    83,    84,    85,     0,    87,
      88,    89,    90,    91,     0,     0,     0,    94,     0,    96,
      97,    98,    99,   100,   101,     0,   102,   103,     0,     0,
       0,   105,   106,   107,   108,     0,   109,     0,   110,   111,
     112,     0,   113,   114,   115,     0,     0,     0,     0,     0,
     118,   119,     0,     0,     0,     0,   120,     0,     0,     0,
       0,     0,     0,     0,     0,   121,     0,   122,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   130,     0,     0,     0,   132,
     133,   134,   135,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   136,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   148,   149,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,     0,     0,     0,     0,     0,   157,     0,     0,   159,
       0,     0,     0,     0,   161,     0,     0,     0,     0,   162,
       0,   163,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   168,   169,     0,
       0,     0,     0,     0,   171,     0,   172,     0,     0,   173,
     174,     0,   175,     0,     0,     0,     0,     0,     0,   176,
     177,     0,   178,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   183,   184,   185,     0,     0,     0,     0,     0,
       0,     0,     0,   186,     0,     0,     0,     0,   188,     0,
       0,   189,     0,   190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,   206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,   217,     0,     0,     0,   218,     0,
     219,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,   230,   231,   232,   233,   234,
     235,   236,     0,     0,     0,     0,     0,     0,     0,     0,
     237,     0,     0,   238,    83,    84,    85,     0,    87,    88,
      89,    90,    91,     0,     0,     0,    94,     0,    96,    97,
      98,    99,   100,   101,     0,   102,   103,     0,     0,     0,
     105,   106,   107,   108,     0,   109,     0,   110,   111,   112,
       0,   113,   114,   115,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   130,     0,     0,     0,   132,   133,
     134,   135,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   136,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   148,   149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
       0,     0,     0,     0,     0,   157,     0,     0,   159,     0,
       0,     0,     0,   161,     0,     0,     0,     0,   162,     0,
     163,     0,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   168,   169,     0,     0,
       0,     0,     0,   171,     0,   172,     0,     0,   173,   174,
       0,   175,     0,     0,     0,     0,     0,     0,   176,   177,
       0,   178,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   183,   184,   185,     0,     0,     0,     0,     0,     0,
       0,     0,   186,     0,     0,     0,     0,   188,     0,     0,
     189,     0,   190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   191,   192,   193,   194,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   198,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,   206,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   210,     0,     0,   212,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,   217,     0,     0,     0,   218,     0,   219,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   229,   230,   231,   232,   233,   234,   235,
     236,     0,     0,     0,     0,     0,     0,     0,     0,   237,
       0,     0,   238,    83,    84,    85,     0,    87,    88,    89,
      90,    91,     0,     0,     0,    94,     0,    96,    97,    98,
      99,   100,   101,     0,   102,   103,     0,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   130,     0,     0,     0,   132,   133,   134,
     135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   136,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   157,     0,     0,   159,     0,     0,
       0,     0,   161,     0,     0,     0,     0,   162,     0,   163,
       0,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   168,   169,     0,     0,     0,
       0,     0,   171,     0,   172,     0,     0,   173,   174,     0,
     175,     0,     0,     0,     0,     0,     0,   176,   177,     0,
     178,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     183,   184,   185,     0,     0,     0,     0,     0,     0,     0,
       0,   186,     0,     0,     0,     0,   188,     0,     0,   189,
       0,   190,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   191,   192,   193,   194,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   198,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   204,     0,     0,   206,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   216,   217,     0,     0,     0,   218,     0,   219,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   229,   230,   231,   232,   233,   234,   235,   236,
       0,     0,     0,     0,     0,     0,     0,     0,   237,     0,
       0,   238
};

static const short yycheck[] =
{
       2,   239,   916,   146,  1191,   144,    78,  1711,  1107,   147,
     858,   998,   114,   758,   862,   773,  1253,  1696,  1628,   114,
      78,   220,  1749,   871,    78,  1528,  1226,    81,   766,  1091,
    1721,  1265,   770,   114,    78,    78,  1037,   114,  1100,   203,
     346,   346,   956,  1384,  1112,  1630,  1313,  1893,   224,  1680,
    2066,   962,  2338,   155,    86,   813,  1056,    78,   972,   197,
     155,  2247,  1646,  1154,   838,   803,  1784,  1646,  1646,    78,
      93,  1162,    81,   883,   155,   885,  1646,   887,   155,   202,
    1935,  1074,   209,   893,    86,  1037,   209,  1149,   211,  1646,
    2706,  1646,  2541,   129,  1156,  2252,  2253,   767,  2977,   769,
      78,  1163,   860,    81,  2716,   114,   129,   202,  2258,  1973,
    2748,   153,   782,   851,   209,  1141,   211,  3130,  1483,   857,
     222,  1944,   143,   146,  1284,  1285,   882,   222,   902,  2052,
    2053,   970,  1227,  1333,  1218,    22,  2000,   146,  1019,   809,
    2004,   222,  1941,  1303,   146,   222,   155,  1169,   180,  2188,
    2189,  2190,  2191,   823,  1612,    23,    38,    11,  1184,  1071,
       2,  1276,  1277,  1037,    72,  1033,  1034,   109,   240,   102,
      90,   115,    72,    78,   157,    89,    81,  2877,   180,   876,
     954,  2197,   240,    89,  1299,   760,   181,    95,    81,    81,
      81,    81,  1695,   202,   201,   183,   240,   240,    88,    84,
     209,    77,   211,   124,   220,    94,    26,  3584,   196,   114,
     183,   109,    72,   222,   109,   109,   201,   201,   239,   240,
     117,  1398,   152,    30,   127,   207,   109,   124,   296,   152,
     238,   109,    26,    81,   131,    38,   298,  1847,  2162,    94,
      88,  3424,    36,   201,    72,   117,   296,   117,   236,   162,
     155,    26,  2268,     8,  2270,  2682,    77,    12,    13,    14,
    3194,   339,  3196,   236,   238,   350,   254,    95,    23,    24,
      25,    82,    27,    28,   209,   312,   162,    32,    33,    34,
     184,   162,    77,  3605,   214,   164,   121,   157,    83,  1388,
      72,   214,   238,    39,   157,    41,   162,   202,   174,   176,
     337,   198,   238,   202,   209,   266,   211,   159,    78,  2173,
     298,    81,  1815,  3326,   396,   242,   238,   222,   306,   232,
     114,   396,  1663,   155,   133,    72,   198,   381,  2675,    96,
     455,   312,   337,   306,   352,   895,   266,   346,   463,   269,
      81,    72,   388,   266,   114,   238,   232,    88,  1615,   116,
       0,  1199,   430,   174,   238,  1355,   337,   917,  2705,   364,
     341,   384,   171,   238,    95,  1110,   232,  1125,   346,   100,
     115,   238,   381,    72,   152,   288,   359,  3699,  1116,   174,
     278,   299,   400,   364,  1122,   155,  1387,   184,  1227,    72,
     222,   466,  1579,   156,   479,  3408,   357,  1245,  1237,  1238,
      72,   343,   329,   381,   486,  1075,  1076,  1255,   486,   174,
    1478,   479,    95,   348,   234,   314,   286,  3600,  1266,    89,
     408,   291,   233,   230,   486,   317,   323,   357,   291,   479,
    1521,  3444,  1170,   479,   357,   408,   214,   420,   396,   291,
     234,   346,   479,  1603,  1604,   343,   359,  3824,   343,   343,
    1610,   323,   222,   323,   597,   340,   762,   762,   240,   234,
     343,   337,   366,   333,   299,   343,   364,   352,  1567,   415,
     486,  2056,   479,   359,  2153,   396,   381,    81,   486,  1054,
    1667,   371,  1152,  1153,   479,   216,  1601,  1602,   266,   220,
     381,   269,   480,   240,  1609,   384,   479,   389,  1168,   391,
     413,   486,   486,   406,   486,  1596,  1683,   420,   482,   240,
     241,  1688,   409,   443,  1353,   400,   271,   312,  2317,  1216,
    1697,   303,   253,   371,  3537,  1195,  1196,   413,   415,   384,
    3464,  1593,   413,  1710,   420,   479,   415,   409,  3238,   409,
     286,   240,   337,   364,   486,   481,   479,   413,   415,   479,
     427,  1577,  3001,  3002,  1393,  1394,   303,   240,   289,   479,
     482,   479,   455,   477,   319,   419,   479,   475,   240,   366,
     463,   477,   303,   455,   597,   475,   346,  2763,   471,   357,
     203,  2767,  1456,  1783,  1784,  1453,   473,   455,   597,   482,
    2048,   486,   486,   479,  1794,   597,   772,  1797,   482,   364,
    1512,   777,   778,   486,   303,  1805,  1806,   482,   784,  2408,
     242,   381,   472,   473,   474,   475,  2247,  1498,  1818,  1819,
    2484,   115,   196,  1504,   201,   768,   769,    16,   203,  1829,
     371,  1726,  2478,  1717,   238,   398,  2559,   368,  2561,   312,
     405,  2657,  2658,  1665,   472,   473,   474,   475,  2013,   452,
     405,  1407,   455,  2692,   157,   301,   758,   460,   461,   462,
     463,    72,   465,   758,   807,   443,   157,  2490,   471,   432,
     846,   453,  3099,  3100,  3101,  3102,  3103,   758,   278,   332,
     303,   758,  3622,  1883,   466,   467,   468,   151,   470,   471,
     472,   473,   474,   475,  1809,  1810,    78,   329,   480,  1580,
      77,   479,   840,  3716,   201,   203,   453,   452,   301,    75,
     455,   312,   855,   398,   157,   460,   461,   462,   157,   466,
     467,   468,   453,   470,   471,   472,   473,   474,   475,  2653,
      16,  2655,  2656,   480,   479,   466,   467,   468,  1483,   470,
     471,   472,   473,   474,   475,  2669,   302,   432,    78,   758,
     238,  3764,  2675,   762,   453,   797,   379,   766,   152,   223,
     159,   770,   169,   364,   171,   339,   798,  1835,   467,   468,
    1528,   470,   471,   472,   473,   474,   475,   352,   152,  3720,
    3721,   387,  2705,   286,   762,   827,   337,   470,   471,   472,
     473,   474,   475,  3409,   803,   286,   798,   174,   470,   471,
     472,   473,   474,   475,  3416,   303,  3444,   477,   481,   479,
     480,   481,   129,   364,  1882,   838,   486,  2681,   184,   396,
     214,  2971,   415,   159,  2747,  3765,   479,   312,   227,   240,
     957,   162,   129,   960,   957,   844,  2467,   960,  1752,  1753,
     214,  1689,   851,   389,   444,   391,   161,   286,   857,   166,
    1698,   455,   337,   758,   486,  3796,   879,   762,   240,   463,
    1708,   130,   957,   354,   157,   960,   117,   471,   160,   166,
     129,  2481,   266,   376,   876,   269,   379,   433,   482,   902,
     131,  1551,  1552,  1553,  1554,   396,  1725,   286,   920,   296,
    3769,  3770,   266,   137,   240,   269,  1641,  3722,  1737,    72,
    1748,   232,  1750,  1751,   481,   100,  1754,   166,   485,   178,
     240,  1581,  1582,   214,    87,   947,    72,  1587,   920,   955,
     354,   472,   386,   387,   239,   217,   958,   959,   422,  3378,
     119,   954,   955,   129,   162,   312,  2439,  1695,   352,    95,
    3819,   419,  1680,   952,  1682,   947,   174,   198,   957,  1687,
     286,   960,    81,   329,   388,   301,   958,   959,   452,  2998,
     337,   455,   206,   357,   973,   266,   460,   461,   462,   359,
     166,  2556,  3797,   311,   983,   486,   398,   455,  2563,  1649,
    1650,  1651,  1652,   357,   350,   479,   400,   161,   758,  2854,
     366,   260,   762,  3818,   322,   973,   313,   431,  1999,  3185,
     366,  1033,  1034,   192,  3190,   215,   102,  3193,  1110,   452,
     165,  1749,   455,  2878,   205,  1110,   313,   460,   461,   462,
     463,   216,   205,  2183,  3181,   220,   215,   341,   359,  1110,
     420,  1033,  1034,  1110,   876,  1037,   202,   413,  2129,   254,
     169,  2103,  2104,   312,  1714,   479,    91,  1999,   203,   443,
     364,   102,   957,   149,   313,   960,   357,  1815,   253,   470,
     471,   472,   473,   474,   475,   239,   257,   240,   973,   443,
     398,  2064,   323,   390,   257,   150,  2263,   451,   452,  2806,
     454,   455,   413,   298,   240,   241,   460,   461,   462,   479,
     160,  1930,   320,   390,    52,  1333,   139,  1945,   149,  2276,
    1109,  1110,  2279,  3538,   432,  1850,  2283,  1116,  1140,  2788,
    1991,   322,    70,  1122,  2969,  2833,   430,   313,  3734,   388,
     165,   390,  3571,  2707,  2215,  2216,  2217,  2218,  2707,  2707,
     303,   390,  2763,   289,  1143,   231,  2767,  2707,  1140,  3793,
    3064,  3065,  3066,  3067,  3068,  3069,  2346,   217,   388,   312,
    2707,  3167,  2707,  3588,   196,   157,  1228,   266,   409,   452,
     269,  1170,   455,  2340,  1470,  1470,  3707,   460,   461,   462,
    1228,   479,   196,   368,   337,  1247,   430,  1019,  3832,  1211,
     231,   389,   278,   391,  1228,  1228,  3202,   398,  3204,   423,
     265,   431,   267,  2393,   390,  1037,   160,  3483,   389,   201,
     391,   364,   131,   973,  3858,  1110,   389,  1228,   391,  1211,
    2058,   360,   254,  1215,  1216,  2096,  1218,  1226,  2099,  2100,
    3761,   432,  2422,  2071,  1998,  3766,  1247,   278,   157,  1252,
     254,  3666,   486,  2259,   425,   185,   430,  2085,   387,   479,
    3104,  2089,   452,   125,  1253,   455,   360,  1559,   357,  1270,
     460,   461,   462,   217,  3795,  2255,   298,  2457,   312,   355,
     142,    77,   350,   132,   453,  1274,  1287,    83,  2013,  2469,
    2470,   221,   154,   387,   298,  3461,   425,   466,   467,   468,
     453,   470,   471,   472,   473,   474,   475,   341,   352,   158,
     201,  1300,   486,   466,   467,   468,  1317,   470,   471,   472,
     473,   474,   475,  1335,   355,   121,   430,     5,   486,   220,
     364,   425,  1333,  1345,   470,   471,   472,   473,   474,   475,
     312,  1330,  1331,   205,  1333,   413,  1638,   132,    26,   286,
     366,  1433,  1644,  1335,  1370,  1371,   400,   291,    36,   451,
    1110,  1350,   454,  1345,   291,   337,  1658,  1370,  1371,   430,
     431,   167,  1384,   158,  1356,   224,  1433,   286,   174,  1492,
     480,   177,   486,    72,  1487,  2542,   486,   169,   137,   171,
     312,   328,    78,  1215,  1216,    81,  1218,   413,  1387,  1555,
     477,  1483,  1384,  1506,   481,  1387,    95,   156,  1483,  1391,
    1392,   100,  1487,   162,   396,   337,  1417,  1418,   479,  1420,
      85,    86,  1483,  1536,  2564,  2746,  1483,   312,   114,   225,
    1419,  1506,   483,  1422,  1423,  1451,   114,   186,   202,   224,
     329,  1453,   312,  2491,  1433,  1434,  1435,   211,  1451,   338,
     350,   117,   337,   430,   431,  2612,  2613,    77,   454,   455,
    3364,  3365,  3366,    83,   169,   131,   171,   337,    79,   155,
     452,  1453,   361,   455,    72,   375,  1434,  1435,   460,   461,
     462,  1470,   278,   232,   482,  3311,   191,    98,  1477,  1067,
    1479,   157,   196,   159,  1483,   173,   297,    95,  1487,   481,
     301,   121,   479,   485,   286,  2155,  2156,  2157,  2158,  2159,
    2160,   215,  1470,  1091,   296,  3105,   312,  1506,   452,  1477,
      72,   455,  1100,   482,  1513,   452,   460,   461,   462,  2247,
     183,   220,   474,   460,   461,   462,   222,   479,  1527,   481,
     337,  2295,  1760,   196,   341,   341,    42,   167,  1433,  1434,
    1435,   240,   241,   474,   174,   124,   234,   177,   479,  1641,
     481,   227,   131,  1686,   478,  1387,  1641,   364,   364,  1391,
    1392,   477,   486,   479,  3185,   481,   448,   449,   450,  3190,
    1641,   286,  3193,   236,  1641,  1470,   291,   455,  2479,  1578,
     482,   296,  1477,   415,   486,   463,  3592,  2777,  1483,  3164,
     289,   254,  1487,   471,   234,   225,  1595,   478,  1727,   482,
     359,   356,  2826,   486,   303,   486,   477,  2267,   479,  2269,
     286,  1506,  1444,  1612,  2781,   291,  2783,   477,  2785,    18,
    2787,   481,  2789,   430,  1778,  2882,  2883,  2794,   141,   246,
     470,   471,   472,   473,   474,   298,  1932,  1932,  1637,  3320,
     480,  1663,  1641,   306,    35,    72,   119,   323,   278,  3563,
     346,   202,   396,  2734,   413,   400,   480,   333,   220,   479,
    2827,   420,   486,   134,  2502,  2400,  1498,   114,   115,  1680,
    2405,  1663,  1504,  1433,  1434,  1435,   312,   228,   240,  3279,
     339,  1680,   312,  1682,  2675,   381,  1685,   402,  1687,   202,
    2917,  2439,   243,   326,   452,   410,   484,  1696,   486,  2889,
     251,   337,   460,   461,   462,   341,  1537,   337,  1770,  1540,
    1470,   341,   356,  1544,  2705,   228,   223,  1477,  2776,   192,
     479,   162,  1770,  1483,  2595,  1717,   430,   431,   364,  1721,
     243,  2602,  2603,   409,   364,   453,  1770,  1770,   251,  2467,
     487,   303,  2580,  2581,   777,   408,  1641,   480,  1580,  1760,
    1749,  2499,   455,   486,   453,   215,   480,  2815,  1850,  1770,
     480,   274,   486,  3076,  3077,  1850,   486,  3080,   801,  3082,
     106,   470,   471,   472,   473,   474,   475,   246,  2578,  1850,
    1802,   430,   431,  1850,  1783,  1784,   356,   480,   301,   446,
     447,   232,  1791,   486,   430,  1794,   347,    72,  1797,   480,
    1257,  1258,   480,  1802,   483,   486,  1805,  1806,   486,   480,
    1802,   479,    87,   240,  1813,   486,   157,  1816,  1817,  1818,
    1819,  3442,   238,     7,  3317,   480,    10,  1826,  1827,   325,
    1829,   486,  1831,   480,   347,  1834,    20,    21,   480,   486,
    3461,  2899,   301,  1854,   486,   106,   287,   288,   183,  1848,
    1849,  1850,    96,   463,  1853,   465,    40,  3007,  1857,    43,
     445,   196,  1861,   242,  3581,  1864,  1865,  1866,  1867,  1868,
    1869,  1870,  1871,  1872,  2963,  1874,   303,   481,   911,   141,
    1879,  1641,  2015,   916,  1883,  1717,   480,  1909,   479,  1721,
     481,   453,   486,   480,   927,   304,   237,   480,   484,   486,
     486,   236,   415,   486,   466,   467,   468,   301,   470,   471,
     472,   473,   474,   475,   480,   396,   257,  1909,   359,   254,
     486,  2013,  2392,   956,  2394,  2395,   452,  2675,  2013,   455,
    1974,  3531,  1976,  1932,   460,   461,   462,   480,   304,   972,
     202,  2601,  2013,   486,   977,  1944,  2013,   389,   480,   391,
     480,   301,   455,   479,   486,  1850,   486,  2705,   991,    72,
     463,   480,   465,   298,  1932,   240,   228,   486,   471,  2704,
     480,   306,   413,  1995,    87,  1974,   486,  1976,   445,   420,
     453,   243,  3676,   242,  3678,  1998,   170,  1417,  1418,   251,
    1420,  2503,  2504,   466,   467,   468,  3617,   470,   471,   472,
     473,   474,   475,  1995,   480,    96,  1974,  1999,  1976,  2001,
     486,  2003,   274,   452,  2013,   445,   377,   378,   480,  2247,
    3072,   460,   461,   462,   486,   480,   453,   480,   303,  2028,
     169,   486,   171,   486,   479,  2763,   481,  1932,   479,  2767,
     479,  3208,  3209,   470,   471,   472,   473,   474,   475,  2048,
    3543,   480,   191,  2052,  2053,   102,   389,   486,   391,   480,
    3287,   480,   758,   480,  2376,   486,   762,   486,  2380,   486,
    3739,   364,   894,   408,   472,  2204,   480,  3267,  2806,  1974,
    1113,  1976,   486,    72,   200,   347,  1417,  1418,   480,  1420,
    1850,   452,  2084,  3174,   455,   142,  3717,   480,    87,   460,
     461,   462,   480,   486,   482,   480,   480,  2419,  2420,   480,
     451,   452,   486,   454,   455,   486,   163,   480,  2013,   460,
     461,   462,   463,   486,   465,   430,   431,   240,   452,   482,
     471,  1164,  1165,  1166,    72,   182,   460,   461,   462,    81,
     480,   480,   480,   482,  2166,   106,   486,  2146,   486,   131,
     197,   993,   291,   995,  2153,   479,   472,   296,  2893,  1991,
     480,  2768,  2154,  2770,   107,   212,   486,  1999,   483,  2001,
    2162,  2003,  1932,  2172,  2166,  2174,   430,   431,   453,   470,
     471,   472,   473,   474,  2176,  2505,  2506,   478,   422,   483,
     303,   466,   467,   468,  2422,   470,   471,   472,   473,   474,
     475,   234,    72,   480,   480,   396,   480,   150,   180,   486,
     486,  1244,   486,  2235,  1974,   396,  1976,   396,   452,   396,
     396,   455,  2214,   205,    90,    95,   460,   461,   462,   452,
     100,   106,  1265,   415,   480,   234,  2247,   460,   461,   462,
     486,   223,   240,  2235,   291,   479,  1035,  1036,  2247,   480,
     396,   240,   299,  2013,   480,   486,   479,   479,  2257,  2281,
     486,   481,   312,   402,  2096,   481,   480,  2099,  2100,   301,
     480,   410,   486,  2462,  2463,   257,   486,   973,   480,   222,
     480,   328,  2295,   479,   486,   452,   486,   771,   455,  2281,
    2289,   775,   480,   460,   461,   462,   479,   337,   486,   783,
     252,   452,   240,  3470,  3471,  3472,  3473,   482,  2400,   460,
     461,   462,   479,  2405,   303,  2400,   472,   473,   474,  2318,
    2405,   479,   265,   305,   267,   295,   356,   811,   479,  2400,
    2329,   815,  3522,  2400,  2405,   278,   480,  3314,  2405,   480,
     453,   825,   486,   480,   246,   486,   216,  2346,  2347,   486,
     220,   430,   479,   466,   467,   468,   117,   470,   471,   472,
     473,   474,   475,   480,   452,   303,   430,  1400,   311,   486,
     240,   241,   460,   461,   462,    90,   452,  2376,   430,   455,
     479,  2380,   480,   253,   460,   461,   462,    96,   486,    96,
     312,   479,   246,  2392,  2393,  2394,  2395,   487,   480,   342,
     415,  2400,   187,   479,   486,  2404,  2405,   389,   187,   391,
    2409,  2422,   479,   187,  1110,   187,   187,   486,   400,   289,
    2419,  2420,   187,  2422,   479,  2436,    90,   409,   187,   187,
     301,   374,   187,   303,   187,   187,  2435,   301,  2437,   187,
     452,  3668,  2441,   455,  2455,  3672,  3673,   197,   460,   461,
     462,   252,   196,   479,   479,   479,  2467,  3185,  2457,  3649,
     479,   479,  3190,   319,   453,  3193,   479,   479,  2467,   479,
    2469,  2470,   479,   479,   479,  3642,   479,   466,   467,   468,
     309,   470,   471,   472,   473,   474,   475,   479,   479,   479,
    2482,  2490,  3669,   479,   452,   430,   431,  2496,   368,   479,
     479,   479,   460,   461,   462,  2400,  2505,  2506,  2507,  1542,
    2405,   479,   479,  3351,  3352,   453,  3354,   452,    90,   477,
     455,   479,   479,   481,   479,   460,   461,   462,   466,   467,
     468,   479,   470,   471,   472,   473,   474,   475,  2537,   479,
     479,   430,   431,   143,   479,   486,  2858,   252,   240,  2861,
    2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,  2870,  2558,
    2559,   479,  2561,   452,   196,   196,   455,   472,   234,  3317,
     357,   460,   461,   462,   269,  2574,   452,  2576,   486,   455,
     156,   414,    38,   453,   460,   461,   462,  2579,    16,   486,
     479,   479,   479,  2721,  2586,   479,  2588,   467,   468,   396,
     470,   471,   472,   473,   474,   475,  2605,  2919,  2920,   481,
     396,   301,  2704,   396,   452,   396,  3454,   455,   396,  2704,
    2753,   452,   460,   461,   462,  3802,  3464,   358,  2756,   460,
     461,   462,   396,  2704,   396,   291,   396,  2704,   414,   396,
    2400,   479,   396,  3833,   452,  2405,   486,   455,   479,   415,
    2482,   354,   460,   461,   462,  2654,   396,   119,   396,   415,
    2722,  2653,   452,  2655,  2656,   455,   396,  1700,   301,   124,
     460,   461,   462,  2695,  1707,  2674,  2675,  2669,  2740,   452,
     225,   486,   455,  2675,   396,   396,   396,   460,   461,   462,
    2682,   354,   396,  3353,  2756,  2717,   396,   479,   301,  2927,
    3604,   240,  2694,  2695,   299,  2704,  2705,   452,   422,   479,
     455,  2722,   479,  2705,  3442,   460,   461,   462,    90,  1752,
    1753,  2720,    79,  2745,  2746,  2717,   157,   415,   479,  2740,
     192,  1764,   425,  3461,  2733,   260,    90,  1433,  1434,  1435,
    2929,  2930,  2931,  2932,   479,  2756,   196,   301,  2747,    90,
     355,  2813,  2763,  2745,  2746,   481,  2767,   428,   187,    16,
     415,   187,   415,  2595,  2763,   187,   486,   486,  2767,   466,
    2602,  2603,   396,   420,  1470,   344,   290,   201,  2777,    90,
     479,  1477,   427,  2782,   394,   394,   271,  1483,   271,  2788,
      72,   364,  3630,   394,   479,  3543,   479,   108,   396,   486,
     201,  2893,  2813,   480,   486,   466,   398,  2806,  2893,  2704,
     452,  3123,   486,   455,  3542,   466,   236,   486,   460,   461,
     462,   463,  2893,   465,   302,   136,  2893,   296,   477,   471,
     480,   254,    35,   396,   480,   396,   354,  2836,   130,   479,
    2839,   244,  3680,  2675,   244,  1878,  2845,   291,   291,   479,
    1672,   291,  2851,  3581,  2853,   301,   307,   486,  2857,  2858,
     480,   486,  2861,  2862,  2863,  2864,  2865,  2866,  2867,  2868,
    2869,  2870,   254,  2705,   315,   412,  2875,  2876,   189,   315,
     106,  2903,   106,   337,   337,  2884,   396,   396,   337,  3617,
    2889,   329,   240,    90,  2893,   240,  2895,   240,   415,   415,
     240,   466,   477,   396,   396,  2904,   466,   218,  2907,  1942,
    2909,  2903,   254,   196,   466,   301,  2927,   305,  2917,  2918,
    2919,  2920,   479,   452,   186,  2924,   455,    90,  2927,   210,
     301,   460,   461,   462,   463,   246,   465,   473,  2937,   213,
     213,   196,   471,   486,  2704,  1641,   479,    90,   479,   301,
    2942,   301,   480,   387,    11,    78,  3616,   207,   268,   486,
     486,  3621,  3622,   301,   106,   480,   201,   480,   480,  3281,
    3282,   445,   480,  1795,  1796,   480,   480,   303,   480,   480,
     480,  1803,   480,   486,   445,  1807,  1808,   445,   201,  3717,
     480,   453,   480,   480,   480,   428,   480,   479,  2893,   396,
    1822,  1817,  1824,   479,   466,   467,   468,   480,   470,   471,
     472,   473,   474,   475,   482,   487,    31,  3677,   482,  3679,
     480,   486,  1844,   480,  1846,   254,   230,   479,   291,   396,
     341,   479,   312,   263,   345,   263,  3035,  1817,   263,   240,
     351,   396,   240,   396,   240,   396,   240,   358,   480,   396,
    3778,   240,   396,   364,   240,   480,   477,   396,  3718,   396,
    1876,   372,   269,   480,   301,  3793,   479,   339,   480,   380,
     405,   486,  3064,  3065,  3066,  3067,  3068,  3069,   299,   301,
     396,   415,   301,   243,   480,   479,   243,  2120,    90,   479,
     308,   296,   415,   415,   486,   304,   466,   486,  3758,   184,
     184,   477,   180,   201,  3832,  3765,   108,  3099,  3100,  3101,
    3102,  3103,    72,   196,   480,   426,   480,   480,  3846,   430,
     424,   115,  3782,   479,  3123,   201,   486,   453,   209,   230,
    3858,   480,   463,  2893,   136,  3134,   466,   405,   466,   164,
     466,   467,   468,  3165,   470,   471,   472,   473,   474,   475,
     396,   480,   479,   466,  1850,   396,   396,   396,   396,   196,
     480,  1645,   479,   240,   478,   240,   240,    90,  2201,   430,
     196,   244,   305,  3165,  3185,   226,  3488,   126,   388,  3190,
    3492,   479,  3193,   486,   418,   479,  3185,   189,    86,   453,
     243,  3190,   479,    90,  3193,    93,  2229,    95,   206,  3511,
    3512,   480,   480,   479,  2237,   201,   104,   106,    90,   480,
     201,   480,   479,   429,   429,   480,   218,   405,   211,   291,
     486,   291,   415,   187,   240,   291,   108,   486,   486,   159,
     227,   129,  3231,   478,   203,   108,  1932,   203,   201,   415,
     138,   415,   175,   186,   246,   117,   117,   480,   146,   147,
     304,   201,   150,   245,   136,  3087,   479,   396,   156,   479,
     196,   304,   160,   136,   201,  2087,   419,   165,  3267,   373,
     333,   479,   430,   479,   196,  3274,  3275,   479,  1974,   479,
    1976,   179,  3281,  3282,   182,   480,    90,  3286,  3287,   187,
    3312,   291,   479,  3292,  3293,   480,   486,  3296,   108,   197,
     327,   351,   264,   201,   223,   203,   351,   189,    93,   207,
     196,   192,   419,   301,   304,   304,   189,  2013,   486,  3311,
    3312,   388,   430,   175,   301,   223,   136,   301,  3320,    90,
     479,   170,  3644,  3645,   480,  3334,   218,   350,   162,   341,
     186,    76,   413,   345,   327,   218,   332,   479,   240,   351,
    3412,  2203,  3374,  3375,  2176,  1392,   358,  3379,  2482,  2181,
    2125,  2606,   364,  2166,   246,  2108,  3373,  3149,  3032,  3152,
     372,    72,  3364,  3365,  3366,  3161,  2538,  3402,   380,   189,
    3777,  3801,  3374,  3375,  3376,  3756,    87,  3379,  3380,  3755,
    3785,  2797,  3154,  1659,    95,  3436,  3418,  3858,  2185,   100,
    3832,  3412,  3401,  3386,  3385,  2704,  2674,  3792,   218,  2705,
    3545,  1639,  3803,   182,  3548,  3219,  1246,  2313,  3166,  3617,
    3717,  3443,  2558,  2052,   426,  2053,  3418,  3683,  2461,  3172,
    3823,  3857,  3593,   971,  1942,  2192,   158,  1228,  3147,   312,
    2814,  2488,  2293,  3442,  1228,  2496,  3213,  1936,  1425,  2507,
    3461,  3443,  1426,  1424,  2467,  1957,  2247,  2769,  3457,   341,
    3462,   846,  3461,   345,   337,  2489,  3145,  3466,   341,   351,
    2902,  3647,   345,  2895,  1832,  2436,   358,  2499,   351,  3311,
    2348,  2434,   364,  2318,  1879,   358,   384,   597,  3320,  3488,
     372,   364,  2753,  3492,  1175,  1995,  1674,   347,   380,   372,
    2240,  1435,  1429,   878,  1972,  1055,  1252,   380,  1999,  2477,
    3214,  2301,  3511,  3512,  1036,   216,  3515,  2302,  3310,   220,
    3215,  1368,  2967,  3522,  3523,   380,  2010,  1433,  2003,  2296,
    2014,   341,  1743,   343,     2,   345,  1215,    -1,    -1,   240,
     241,   351,    -1,  3542,   426,    -1,    -1,  2031,   358,    -1,
      -1,  2035,   253,   426,   364,    -1,    -1,  3556,    -1,    -1,
    2376,    -1,   372,    -1,  2380,    -1,    -1,    -1,    -1,    -1,
     380,  3563,    -1,  2057,    -1,  2059,    -1,    -1,  3640,    -1,
      -1,    -1,  3581,    -1,    -1,   286,    -1,    -1,   289,    -1,
      -1,    -1,  3614,    -1,    -1,    -1,  2376,    -1,    -1,    -1,
    2380,    -1,   303,  2419,  2420,    -1,    -1,    -1,  2092,  3837,
      -1,    -1,    -1,    -1,    -1,    -1,   426,    -1,  3617,  3618,
      -1,    -1,  3614,    -1,    -1,    -1,    -1,    -1,    -1,  3640,
      -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,  2419,
    2420,    -1,  2126,    -1,    -1,  3644,  3645,    -1,  3647,  2133,
    3649,  2135,    -1,    -1,    -1,    -1,    -1,    95,  2480,    -1,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   368,    -1,  3668,
      -1,    -1,    -1,  3672,  3673,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2724,    -1,    -1,  3526,    -1,    -1,    -1,    -1,   597,
      -1,    -1,    -1,    -1,  2400,    -1,    -1,    -1,    -1,  2405,
    2743,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3717,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3739,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   647,
     648,    -1,   453,    -1,    -1,    -1,    -1,  2790,    -1,  2792,
      -1,    -1,    -1,    -1,  2797,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,    -1,    -1,   216,  3778,
      -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2826,  3793,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3823,    -1,    -1,   253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3815,    -1,    -1,  3837,  2311,    -1,    -1,
      -1,    -1,    -1,  3832,  3833,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3857,  3846,    -1,    80,
      -1,   289,    -1,    -1,  2338,    -1,    -1,    -1,  2680,  3858,
    2682,    -1,    -1,  3855,    -1,   303,    -1,    -1,    -1,   767,
     768,   769,    -1,   771,    -1,   773,    -1,   775,   776,    -1,
      -1,   779,    -1,   781,   782,   783,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2934,  2935,   134,    -1,    -1,   804,    -1,    -1,   807,
      -1,   809,    -1,   811,    -1,    -1,    -1,   815,   816,   817,
     151,    -1,    -1,   821,    -1,   823,    -1,   825,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     838,   172,   840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   852,    -1,    -1,   855,    -1,    -1,
     858,    -1,    -1,    -1,   862,   863,    -1,    -1,    -1,   867,
      -1,   869,   203,   871,    -1,    -1,   874,    -1,   209,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,  1143,    -1,
      -1,    -1,   223,    -1,    -1,  1143,    -1,   895,   896,    -1,
      -1,    87,    -1,    -1,   902,    -1,    -1,    -1,  2704,    95,
      -1,    -1,    -1,    -1,   100,   453,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   923,    -1,   925,    -1,    -1,
     928,    -1,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,    -1,  2858,  2527,    -1,  2861,  2862,  2863,  2864,  2865,
    2866,  2867,  2868,  2869,  2870,    -1,   954,   955,    -1,    -1,
      -1,   959,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   303,  3106,    -1,    -1,    -1,    -1,  2858,    -1,
     978,  2861,  2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,
    2870,    -1,    -1,    -1,    -1,   326,  3129,    -1,  1253,    -1,
      -1,    -1,    -1,  2919,  2920,  1253,  3139,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,    -1,    -1,
      -1,    -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,   360,
     216,    -1,    -1,    -1,   220,  1033,  1034,    -1,    -1,  2919,
    2920,    -1,    -1,    -1,    -1,    -1,    -1,  1045,    -1,    -1,
    1048,    -1,    -1,  1051,   240,   241,   387,   388,    -1,    -1,
      -1,   392,    -1,  2647,    -1,    -1,    -1,   253,    -1,   400,
      -1,    -1,    -1,    -1,   405,    -1,    -1,  1075,  1076,    -1,
      -1,    -1,    -1,   414,    -1,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   425,    -1,    -1,  2893,    -1,    -1,
     286,    -1,    -1,   289,  1102,    -1,    -1,    -1,    95,    -1,
      -1,    -1,    -1,   100,    -1,    -1,  1114,   303,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,  1127,
      -1,    -1,  1387,    -1,    -1,  1133,    -1,    -1,    -1,  1137,
      87,    -1,    -1,    -1,    -1,    -1,  1144,    -1,    95,    -1,
      -1,    -1,    -1,   100,  1152,  1153,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3298,  3299,  3300,  3301,    -1,
    1168,  1169,  3094,  1171,  1172,    -1,    -1,  3099,  3100,  3101,
    3102,  3103,   368,    -1,    -1,  3107,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1195,  1196,    -1,
      -1,  1199,    -1,    -1,    -1,    -1,    -1,  3123,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2807,  1479,    -1,    -1,    -1,    -1,   216,
      -1,  1479,    -1,   220,    -1,    -1,    -1,    -1,  1236,    -1,
      -1,    -1,    -1,  3123,  2828,    -1,    -1,  1245,  1246,    -1,
      -1,    -1,  1250,   240,   241,    -1,    -1,  1255,  1513,    -1,
      -1,    -1,    -1,    -1,    -1,  1263,   253,   453,  1266,   216,
    1268,    -1,  1527,   220,    -1,    -1,    -1,    -1,    -1,  1527,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      -1,    -1,   478,   240,   241,    -1,    -1,    -1,    -1,   286,
      -1,   487,   289,    -1,    -1,    -1,   253,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,    -1,    -1,
      -1,    -1,    -1,  1578,    -1,    -1,    -1,    -1,    -1,    -1,
    1578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,
    1595,    -1,   289,    -1,    -1,    -1,    -1,  1595,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   303,  1612,   305,    -1,
      -1,    -1,    -1,    -1,    -1,  3281,  3282,    -1,    -1,    -1,
      -1,    -1,  1370,  1371,    -1,    -1,    -1,    -1,    -1,  1143,
      -1,   368,  1637,    -1,    -1,    -1,  1384,    -1,    -1,  1637,
      -1,    -1,    -1,  1391,  1392,    -1,    -1,    -1,    -1,    -1,
    3322,  3281,  3282,    -1,  1402,    -1,  1404,    -1,    -1,    -1,
    3332,  3333,    -1,    -1,    -1,  3337,  3338,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,  3347,    -1,    -1,    -1,    -1,
    1685,    -1,    -1,    -1,    -1,    -1,    -1,  1685,    -1,    -1,
      -1,  1696,    -1,    -1,    -1,    -1,    -1,    -1,  1696,    -1,
    3583,    -1,    -1,  1451,    -1,  1453,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3047,    -1,  3049,   453,    -1,    -1,    -1,
      -1,  3604,    -1,    -1,  1472,    -1,    72,    -1,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,  1253,
      -1,    87,  3625,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      -1,    -1,    -1,    -1,   100,    -1,   453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,    -1,
    1528,    -1,  3665,    -1,    -1,    -1,    -1,    -1,    -1,   486,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1551,  1552,  1553,  1554,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,  3488,    93,    -1,    -1,  3492,    -1,    -1,    -1,
      -1,    -1,    -1,  1581,  1582,    -1,    -1,    -1,    -1,  1587,
      -1,    -1,    -1,  1848,    -1,  3511,  3512,    -1,    -1,    -1,
    1848,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3488,   129,
      -1,    -1,  3492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,   146,   147,    -1,    -1,
      -1,  3511,  3512,    -1,    -1,  3219,   156,    -1,    -1,    -1,
     160,    -1,    -1,    -1,   240,   241,    -1,  1645,    -1,  1647,
      -1,  1649,  1650,  1651,  1652,    -1,    -1,   253,    -1,    -1,
     180,    -1,   182,    -1,    -1,  1663,    -1,  1665,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1686,    -1,
     286,  1689,  1690,   289,    -1,    -1,    -1,  1695,    -1,    -1,
    1698,  1699,    -1,  1701,    -1,    -1,    -1,   303,  1706,   305,
    1708,    -1,    -1,  1711,    -1,  1479,  1714,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3644,  3645,
    1728,  1729,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3330,    -1,    -1,  1513,
    1748,    -1,  1750,  1751,    -1,    -1,  1754,  3341,    -1,  3343,
      -1,    -1,  1760,  1527,  3644,  3645,    -1,    -1,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1778,   183,    -1,  1781,    -1,    -1,    -1,    72,    -1,    -1,
      -1,    -1,    -1,  2048,   196,    -1,    -1,  2052,  2053,   201,
      -1,    -1,    87,    -1,   206,    -1,    -1,   209,    -1,   211,
      95,    -1,    -1,    -1,  1578,   100,    -1,  1815,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1595,    -1,    -1,   236,    -1,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,  1612,    -1,
     100,    -1,   254,    -1,    -1,    -1,    -1,   453,    -1,    -1,
      -1,    -1,    -1,    -1,   384,    -1,    -1,    -1,    -1,    -1,
     466,   467,   468,  1637,   470,   471,   472,   473,   474,   475,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1885,    -1,    -1,
     486,    -1,    -1,    -1,    -1,    -1,   298,    -1,  2153,  3483,
      -1,    -1,    -1,    -1,   306,  2153,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2174,
      -1,  1685,    -1,    -1,    -1,    -1,  2174,    -1,    -1,    -1,
      -1,   216,  1696,    -1,    -1,   220,    -1,  1935,    -1,    -1,
      -1,    -1,   344,    -1,    -1,    -1,    -1,  1945,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   240,   241,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,   253,    -1,
     220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,
     240,   241,    -1,    -1,    -1,    -1,    -1,  1995,    -1,    -1,
    1998,   286,    -1,   253,   289,    -1,   408,    -1,    -1,    -1,
      -1,    -1,  2010,  2011,    -1,    -1,  2014,  2015,   303,    -1,
     305,  2019,    -1,    -1,    -1,    -1,   428,  2025,    -1,    -1,
      -1,    -1,  2030,  2031,    -1,    -1,   286,  2035,  2036,   289,
      -1,    -1,    -1,  2041,    -1,    -1,   448,   449,   450,    -1,
      -1,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,  2057,
    2058,  2059,  2060,    -1,  2062,    -1,    -1,  2065,  2066,    -1,
      -1,    -1,    -1,  2071,  2329,   477,    -1,   597,   480,   481,
     482,  2329,    -1,   368,  1848,    -1,    -1,  2085,    -1,    -1,
      -1,  2089,    -1,    -1,  2092,  2093,  2094,  2095,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2108,  2109,  2110,  2111,  2112,  2113,  2114,    -1,   368,  2117,
    2118,    -1,    -1,  2121,  2122,  2123,    -1,    -1,  2126,  2127,
      -1,    -1,    -1,    -1,    -1,  2133,  2134,  2135,    -1,  2137,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2155,  2156,  2157,
    2158,  2159,  2160,    -1,    -1,    -1,    -1,    -1,   453,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2176,    -1,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,   480,    -1,    -1,    -1,  2197,
      -1,    -1,    -1,   453,    -1,    -1,    -1,  2205,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,  2225,    -1,    -1,
     480,    -1,  2230,    -1,  2232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2240,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2248,    -1,    -1,    -1,  2252,  2253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2267,
    2268,  2269,  2270,    -1,    -1,    -1,    -1,    72,   798,    -1,
      80,    -1,    -1,    -1,  2048,    -1,    -1,    -1,  2052,  2053,
      -1,    -1,    87,    -1,    -1,    -1,    -1,  2295,    -1,    -1,
      95,    -1,    -1,  2558,  2559,   100,  2561,    -1,    72,    -1,
      -1,    -1,   112,  2311,    -1,    -1,    -1,   837,   838,  2574,
     840,  2576,    -1,    87,   124,    -1,  2574,    -1,  2576,    -1,
      -1,    95,    -1,    -1,   134,    -1,   100,  2335,    -1,    -1,
    2338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2605,   151,    -1,    -1,    -1,    -1,    -1,  2605,    -1,   879,
      -1,    -1,    -1,   883,    -1,   885,    -1,   887,    -1,    -1,
      -1,    -1,   172,   893,   894,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   902,    -1,    -1,    -1,    -1,    -1,    -1,  2153,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2654,
     920,    -1,    -1,   203,    -1,    -1,  2654,    -1,    -1,    -1,
    2174,    -1,  2410,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2675,   216,    -1,   223,    -1,   220,    -1,   947,    -1,    -1,
      -1,    -1,    -1,    -1,   954,   955,    -1,    -1,   958,   959,
      -1,  2439,    -1,    -1,    -1,   240,   241,   247,    -1,    -1,
    2705,    -1,   216,    -1,    -1,    -1,   220,    -1,   253,    -1,
      -1,    -1,    -1,    -1,    -1,  2720,    -1,    -1,    -1,    -1,
      -1,    -1,  2720,    -1,    -1,    -1,   240,   241,  2733,    -1,
      -1,    -1,    -1,    -1,  2482,  2733,    -1,    -1,    -1,   253,
    2488,   286,  2747,    -1,   289,    -1,    -1,    -1,    -1,  1019,
      -1,    -1,    -1,   303,  2502,    -1,    -1,    -1,   303,    -1,
     305,    -1,    -1,  1033,  1034,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   286,    -1,    -1,   289,   326,  2782,    -1,  2527,
    2528,  2529,    -1,  2788,  2782,    -1,    -1,    -1,    -1,   303,
    2788,   305,    -1,  2541,    -1,    -1,    -1,    -1,   348,    -1,
      -1,    -1,   352,    -1,   354,    -1,    -1,    -1,    -1,    -1,
     360,    -1,    -1,    -1,    -1,  2329,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2580,  2581,  2839,    -1,    -1,   387,   388,    -1,
      -1,  2839,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     400,    -1,  2857,  2601,   368,   405,    -1,    -1,    -1,  2857,
      -1,    -1,    -1,    -1,    -1,    -1,  2614,  2615,  2616,  2617,
    1140,    -1,    -1,    -1,    -1,   425,    -1,    -1,    -1,  2884,
      -1,    -1,    -1,    -1,    -1,    -1,  2884,  1143,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2647,
    2648,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   453,  2657,
    2658,    -1,  2917,    -1,    -1,    -1,    -1,    -1,    -1,  2917,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,  2682,   480,    -1,    -1,    -1,   453,
      -1,  1211,    -1,    -1,    -1,    -1,    -1,    -1,  2696,  2697,
    2698,    -1,   466,   467,   468,    -1,   470,   471,   472,   473,
     474,   475,    -1,    72,    -1,    -1,   480,    -1,    -1,  1239,
      -1,    -1,  1242,  2721,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,  1252,    -1,    -1,    -1,    95,    -1,    -1,    -1,
     114,   100,    -1,  2741,    -1,    -1,    -1,  1253,  2746,    -1,
      -1,    -1,    -1,    -1,    -1,  2753,    -1,    -1,  2756,  2757,
      -1,    -1,  2760,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2773,    -1,    -1,    -1,    -1,
    3035,   155,    -1,    -1,    -1,    -1,    -1,  3035,    -1,    -1,
      -1,    -1,    -1,    -1,  2558,  2559,    -1,  2561,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2807,
    2574,    -1,  2576,    -1,    -1,  1335,  2814,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1345,    -1,    -1,   202,    -1,
    2828,    -1,    -1,    -1,    -1,   209,    -1,   211,    -1,    -1,
      -1,  2605,    -1,    -1,    -1,    72,  1366,    -1,   222,    -1,
    1370,  1371,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,
      87,   220,    -1,    -1,  1384,    -1,    -1,  1387,    95,    -1,
      -1,  1391,  1392,   100,    -1,    -1,    -1,    -1,    -1,  3134,
      -1,   240,   241,    -1,    -1,    -1,  3134,    -1,    -1,    -1,
    2654,    -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2675,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,
     289,  1451,    -1,  1453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2705,    -1,    -1,   303,    -1,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2720,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   137,    -1,    -1,  2733,
      -1,  2969,    -1,  1479,    -1,    -1,    -1,    -1,  1498,    -1,
      -1,    -1,    -1,  2747,  1504,    -1,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3001,  3002,    -1,    -1,  1513,    -1,   368,
      -1,    -1,   183,   240,   241,    -1,    -1,    -1,  2782,    -1,
      -1,  1527,    -1,    -1,  2788,   196,   253,    -1,    -1,    -1,
     201,    -1,  3287,    -1,    -1,   206,    -1,    -1,   209,  3287,
     211,    -1,    -1,    -1,    -1,  3043,    -1,    -1,    -1,  3047,
    3048,  3049,  3050,  3051,  3052,  3053,    -1,    -1,    -1,   286,
    1580,    -1,   289,    -1,    -1,   236,    -1,    -1,    -1,    -1,
      -1,    -1,  1578,    -1,    -1,  2839,   303,    -1,   305,  3334,
      -1,    -1,    -1,   254,    -1,    -1,  3334,    -1,    -1,  1595,
      -1,    -1,    -1,  2857,   453,    -1,    -1,    -1,    -1,    -1,
      -1,  3099,  3100,  3101,  3102,  3103,  1612,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,    -1,    -1,    -1,
    2884,   480,    -1,    -1,  3122,    -1,    -1,   298,    -1,    -1,
      -1,  1637,    -1,    -1,    -1,   306,    -1,    -1,    -1,    -1,
      -1,   368,    -1,  1663,    -1,    -1,    -1,  3145,    -1,    -1,
      -1,  3149,  1672,  2917,  3152,    -1,  3154,    -1,    -1,    72,
      -1,    -1,    -1,  3161,    -1,    -1,    -1,    -1,    -1,  3167,
      -1,    -1,    -1,   344,    -1,    -1,    -1,    -1,    -1,  1685,
      -1,    -1,    95,  3181,    -1,  3183,    -1,   100,    -1,    -1,
    1696,    -1,    -1,    -1,    -1,    -1,  3194,    -1,  3196,    78,
    3198,    -1,    -1,    -1,  3202,    -1,  3204,    -1,    -1,  1729,
      -1,  3466,    -1,    -1,    -1,    -1,   387,    -1,  3466,    -1,
      -1,  3219,    -1,  1743,  1744,    -1,   453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,    -1,
      -1,   130,    -1,   480,    -1,    -1,    -1,   428,    -1,   138,
     139,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   182,
      -1,  3035,    -1,    -1,    -1,  1795,  1796,   448,   449,   450,
      -1,    -1,  1802,  1803,    -1,    -1,    -1,  1807,  1808,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     179,    -1,  1822,   216,  1824,    -1,   477,   220,    -1,   480,
     481,   482,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3317,
      -1,    -1,    -1,    -1,  1844,    -1,  1846,   240,   241,    -1,
      -1,    -1,  3330,  3331,    -1,    -1,    -1,    -1,    -1,    -1,
     253,   220,  1848,  3341,  3342,  3343,   225,    -1,    -1,    -1,
    3348,    -1,    -1,  3351,  3352,  3353,  3354,    -1,  1878,    -1,
      -1,    -1,    -1,    -1,    -1,  1885,    -1,    -1,    -1,    -1,
    3134,    -1,    -1,  1893,    -1,    -1,   289,    -1,    -1,    -1,
    3378,    -1,    -1,   262,   758,    -1,    -1,    -1,    -1,  1909,
     303,    -1,   766,    -1,    -1,    -1,   770,    -1,    -1,    -1,
     279,   280,    -1,   282,   283,    -1,   285,    -1,    -1,    -1,
      -1,    -1,    -1,  3668,    -1,    -1,    -1,  3672,  3673,    -1,
    3668,    -1,    -1,    -1,  3672,  3673,    -1,    -1,    -1,   803,
      -1,  3429,    -1,    -1,    -1,    -1,   315,    -1,  3436,    -1,
      -1,    -1,    -1,    -1,  3442,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3451,    -1,   368,  3454,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3464,    -1,    95,   348,
      -1,  1991,    72,   100,    -1,  1995,    -1,   851,  1998,  3477,
      -1,    -1,    -1,   857,  3739,  3483,    -1,    87,    -1,    -1,
      -1,  3739,    -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,
     100,    -1,    -1,    -1,   383,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,
      -1,    -1,    -1,  3287,    -1,    -1,    -1,    -1,   407,    -1,
      -1,    87,    -1,    -1,    -1,   414,    -1,    -1,   417,    95,
     453,    -1,  2048,    -1,   100,  3543,  2052,  2053,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,   470,   471,   472,
     473,   474,   475,    -1,    -1,    -1,    -1,  2087,    -1,    72,
    3334,    -1,    -1,  3571,    -1,    -1,  2096,    -1,   952,  2099,
    2100,    -1,    -1,   957,    87,    -1,   960,    -1,    -1,   216,
      -1,    -1,    95,   220,  3592,    -1,  3594,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   983,
      -1,    -1,    -1,   240,   241,    -1,   216,    -1,  3616,  3617,
     220,    -1,    -1,  3621,  3622,    -1,   253,    -1,    -1,    -1,
      -1,    -1,  3630,    -1,  2154,    -1,    -1,    -1,    -1,    -1,
     240,   241,  2162,    -1,    -1,    -1,  2166,  2153,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,  2176,    -1,    -1,    -1,
     216,  2181,   289,    -1,   220,    -1,    -1,    -1,  2174,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,  3676,  3677,
    3678,  3679,  3680,    -1,   240,   241,   286,    -1,    -1,   289,
      -1,    -1,    -1,    -1,    -1,  1143,    -1,   253,    -1,    -1,
    3698,    -1,  3466,   303,    -1,   305,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   216,    -1,  2235,    -1,   220,    -1,  3717,
    3718,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     286,    -1,    -1,   289,    -1,  1109,  1110,   240,   241,    -1,
      -1,   368,  1116,    -1,    -1,    -1,    -1,   303,  1122,   305,
     253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3757,
    3758,  2281,    -1,    -1,    -1,    -1,    -1,  3765,   368,  1143,
      -1,    -1,    -1,    -1,    -1,  2295,  2296,    -1,    -1,  2299,
      -1,  2301,    -1,   286,  3782,    -1,   289,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3793,  1170,    -1,    -1,    -1,
     303,    -1,   305,    -1,    -1,  1253,    -1,    -1,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2329,    -1,    -1,   453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3832,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   470,   471,   472,   473,   474,   475,    -1,
      -1,    -1,  1226,   453,    -1,    -1,    -1,    -1,    -1,    -1,
    3858,    -1,    -1,    -1,    -1,   368,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,    -1,    -1,    -1,  1253,
     480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   453,    -1,    -1,
    1274,    -1,    -1,    -1,  3668,    -1,    -1,    -1,  3672,  3673,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      -1,    -1,    -1,    -1,   480,    -1,  1300,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     453,    -1,    -1,    -1,    -1,    -1,  1330,  1331,  2478,  1333,
    2480,    -1,  2482,   466,   467,   468,    -1,   470,   471,   472,
     473,   474,   475,    -1,    -1,  3739,  1350,   480,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1479,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1419,    -1,    -1,  1422,  1423,
      -1,    -1,  2558,  2559,    -1,  2561,    -1,    -1,  2578,    -1,
      -1,    -1,    -1,    -1,    -1,  1513,    -1,    -1,  2574,    -1,
    2576,    -1,    -1,    -1,    -1,  2595,    -1,    -1,    -1,  1527,
      -1,    -1,  2602,  2603,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2605,
      -1,    -1,    -1,    -1,    -1,  1479,    -1,    -1,    -1,  1483,
      -1,    -1,    -1,  1487,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,   139,    -1,    -1,    -1,    -1,    -1,    -1,
    1578,    -1,  1506,  2653,    -1,  2655,  2656,    87,    -1,  1513,
      -1,    -1,  1143,    -1,    -1,    95,    -1,  1595,  2654,  2669,
     100,    -1,    -1,  1527,    -1,  2675,    -1,    -1,    -1,    -1,
    2680,    -1,  2682,    -1,  1612,    -1,    -1,    -1,    -1,  2675,
      -1,    -1,    -1,    -1,  2694,  2695,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2705,    -1,    -1,    -1,  1637,
      72,    -1,    -1,    -1,    -1,    -1,    -1,  2717,    -1,  2705,
      -1,  2721,    -1,    -1,  1578,    -1,    -1,    -1,   224,    -1,
      -1,    -1,    -1,    95,  2720,    -1,    -1,    -1,   100,    -1,
      -1,  1595,    -1,    -1,    -1,  2745,  2746,  2733,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2756,  1685,  1612,    -1,
      -1,  2747,    -1,    -1,    -1,    -1,    -1,    -1,  1696,    -1,
      -1,    -1,  1253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1637,    -1,    -1,   216,  1641,    -1,    -1,
     220,    -1,    -1,    -1,    -1,    -1,  2782,    -1,    -1,    -1,
      -1,    -1,  2788,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     240,   241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,    -1,    -1,   253,    -1,    -1,  1680,    -1,  1682,    -1,
      -1,  1685,    -1,  1687,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,  1696,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2839,   216,    87,   286,    -1,   220,   289,
      -1,    -1,    -1,    95,    -1,    -1,    -1,    -1,   100,    -1,
      -1,  2857,    -1,   303,    -1,   305,    -1,    -1,   240,   241,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   253,    -1,    -1,    -1,  1749,    -1,    -1,  2884,    -1,
      -1,    -1,    -1,  2903,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1848,    -1,    -1,    -1,    -1,    -1,    -1,   289,    -1,  1783,
    1784,  2917,    -1,    -1,    -1,    -1,    -1,  1791,   368,    -1,
    1794,   303,    -1,  1797,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1805,  1806,    -1,    -1,    -1,    -1,    -1,    -1,  1813,
      -1,    -1,  1816,  1817,  1818,  1819,    -1,    -1,    -1,    -1,
      -1,    -1,  1826,  1827,    -1,  1829,    -1,  1831,    -1,    -1,
    1834,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,  1848,  1849,  1850,    -1,  1479,  1853,
      -1,    -1,    -1,  1857,    -1,    -1,   368,  1861,   240,   241,
    1864,  1865,  1866,  1867,  1868,  1869,  1870,  1871,  1872,    -1,
    1874,   253,    -1,   453,    -1,  1879,    -1,    72,    -1,  1883,
      -1,    -1,  1513,    -1,    -1,    -1,   466,   467,   468,    -1,
     470,   471,   472,   473,   474,   475,  1527,    -1,   478,  3035,
      95,    -1,    -1,    -1,   286,   100,    -1,   289,    -1,    -1,
      -1,    -1,    -1,    -1,  3064,  3065,  3066,  3067,  3068,  3069,
      -1,   303,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,    -1,
    1944,   453,    -1,    -1,  3094,    -1,    -1,  1578,    -1,  3099,
    3100,  3101,  3102,  3103,    -1,    -1,    -1,  3107,   470,   471,
     472,   473,   474,   475,  1595,    -1,    -1,    -1,    -1,    -1,
    2048,    -1,    -1,    -1,  2052,  2053,    -1,    -1,    -1,    -1,
      -1,  1612,    -1,    -1,    -1,    -1,   368,   182,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3134,   381,
      -1,    -1,    -1,    -1,    -1,    -1,  1637,    -1,    -1,  2013,
      -1,    -1,    -1,    -1,    -1,  3165,    -1,    -1,    -1,    -1,
      -1,   216,    -1,    -1,  2028,   220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2048,   240,   241,    -1,  2052,  2053,
      -1,    -1,    -1,    -1,  1685,    -1,    -1,    -1,   253,    -1,
      -1,    -1,    -1,    -1,  3214,  1696,    -1,    -1,    -1,    -1,
      -1,   453,    -1,    -1,    -1,  2153,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,   289,    -1,  2174,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   303,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     766,    -1,    -1,    -1,   770,    -1,   772,    -1,    -1,    -1,
      -1,   777,   778,    -1,    -1,    -1,    -1,    -1,   784,    -1,
      -1,    -1,  2146,    -1,    -1,    -1,    -1,    -1,    -1,  2153,
      -1,  3287,    -1,    -1,    -1,   801,    -1,   803,    -1,    -1,
      -1,  3311,  3312,    -1,    -1,    -1,    -1,    -1,  2172,    -1,
    2174,    -1,  3322,   368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3332,  3333,    -1,    -1,    -1,  3337,  3338,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3347,  3334,    -1,
     846,    -1,    -1,    -1,    -1,   851,    -1,    -1,    -1,    -1,
      -1,   857,    -1,    72,  3364,  3365,  3366,  1848,    -1,    -1,
      -1,    -1,    -1,    -1,  3374,  3375,    -1,    -1,    87,  3379,
      -1,    -1,    91,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      -1,   100,    -1,  2247,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2329,    -1,  2257,    -1,    -1,    -1,    -1,   453,    -1,
      -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,  3418,    -1,
     916,    -1,    -1,    -1,    -1,   470,   471,   472,   473,   474,
     475,   927,    -1,    -1,    -1,  2289,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3443,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,
     956,    -1,    -1,    -1,  2318,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2329,   972,    -1,    -1,    -1,
    3466,   977,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2346,  2347,    -1,   991,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2376,    -1,    -1,    -1,  2380,    -1,    -1,    -1,
      -1,   240,   241,    -1,    -1,    -1,    -1,    -1,  2392,  2393,
    2394,  2395,    -1,    -1,   253,    95,  2400,    -1,    -1,    -1,
    2404,  2405,    -1,    -1,   104,  2409,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3563,    -1,  2419,  2420,  2048,  2422,    -1,
      -1,  2052,  2053,    -1,    -1,    -1,    -1,   286,    -1,    -1,
     289,  2435,    -1,  2437,    -1,    -1,    -1,  2441,   138,    -1,
      -1,    -1,    -1,    -1,   303,    -1,   305,   147,    -1,    -1,
     150,    -1,    -1,  2457,    -1,    -1,   156,    -1,    -1,    -1,
     160,    -1,    -1,  2467,  3614,  2469,  2470,  1113,    -1,    -1,
    1116,    -1,    -1,    -1,    -1,    -1,  1122,    -1,    -1,    -1,
    2558,  2559,   182,  2561,    -1,    -1,  2490,    -1,    -1,    -1,
      -1,    -1,  2496,    -1,    -1,    -1,  2574,   197,  2576,    -1,
    1143,  2505,  2506,  2507,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1164,  1165,
    1166,    -1,  2153,    -1,  1170,    -1,    -1,  2605,    -1,    -1,
      -1,    -1,  3668,  2537,    -1,    -1,  3672,  3673,  1143,    -1,
      -1,    -1,    -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2558,  2559,   415,  2561,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2574,    -1,  2576,    -1,    -1,    -1,  2654,    72,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   453,    -1,    -1,  2675,  1244,    -1,
      95,  2605,    -1,  3739,    -1,   100,    -1,   466,   467,   468,
    1253,   470,   471,   472,   473,   474,   475,    -1,    -1,  1265,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2705,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2720,  3793,    -1,    -1,    -1,    -1,  1253,    -1,
    2654,    -1,    -1,    -1,    -1,  2733,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2747,
      -1,  2675,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3832,    -1,   384,    -1,    -1,   182,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2329,    -1,
    2704,  2705,    -1,    -1,  2782,    -1,    -1,    -1,  3858,    -1,
    2788,    -1,    -1,    -1,    -1,    -1,  2720,    -1,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,  2733,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2747,    -1,   240,   241,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1400,    -1,    -1,    -1,   253,  2763,
      -1,  2839,    -1,  2767,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2777,    -1,    80,    -1,    -1,  2782,  2857,
      -1,    -1,    -1,    -1,  2788,    -1,    -1,    92,    -1,    -1,
      -1,    -1,    -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2806,    -1,    -1,    -1,  2884,   112,   303,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
      -1,    -1,  2836,    -1,    -1,  2839,  1479,    -1,    -1,  2917,
      -1,  2845,    -1,    -1,    -1,    -1,   151,  2851,    -1,  2853,
      -1,    -1,    -1,  2857,  2858,    -1,    -1,  2861,  2862,  2863,
    2864,  2865,  2866,  2867,  2868,  2869,  2870,   172,    -1,    -1,
    1513,  2875,  2876,   368,  1479,    -1,    -1,    -1,    -1,    -1,
    2884,    -1,    -1,    -1,  1527,  2889,    -1,    -1,    -1,  2893,
      -1,  2895,    -1,    -1,    -1,    -1,  1542,    -1,   203,    -1,
    2904,    -1,    -1,  2907,   209,  2909,    -1,    -1,  1513,  1555,
      -1,    -1,    -1,  2917,  2918,  2919,  2920,    -1,   223,    -1,
    2924,    -1,  1527,  2927,    -1,    -1,    -1,  2558,  2559,    -1,
    2561,    -1,    -1,  2937,    -1,  1578,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2574,    -1,  2576,    -1,   647,   648,    -1,
      -1,    -1,  1595,    -1,    -1,    -1,    -1,  3035,   453,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1612,
      -1,    -1,    -1,  1578,  2605,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1595,    -1,    -1,    -1,  1637,    -1,    -1,    -1,   303,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   311,  1612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   326,    -1,  2654,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3035,  1637,    -1,  1680,    -1,  1682,    -1,    -1,    -1,
      -1,  1687,  1685,   348,  2675,    -1,    -1,   352,    -1,   354,
      -1,    -1,    -1,  1696,  1700,   360,  3134,    -1,    -1,    -1,
      -1,  1707,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2705,    -1,   776,    -1,    -1,   779,
    1685,   781,   387,   388,    -1,    -1,    -1,   392,    -1,  2720,
      -1,  1696,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,
     405,    -1,  2733,  1749,   804,    -1,  1752,  1753,    -1,   414,
      -1,    -1,    -1,    -1,    -1,    -1,  2747,   817,  1764,  3123,
     425,   821,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   838,    -1,
     840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2782,   852,    -1,    -1,    -1,    -1,  2788,  1143,    -1,
      -1,    -1,    -1,   863,    -1,    -1,    -1,   867,    -1,   869,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3185,    -1,    -1,    -1,    -1,  3190,    -1,    -1,  3193,
      -1,    -1,    -1,    -1,    -1,   895,   896,    -1,    -1,    -1,
      -1,    -1,   902,    -1,    -1,  1848,    -1,    -1,  2839,  3287,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   923,    -1,   925,  2857,  3231,    -1,    -1,
      -1,    -1,  1878,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1848,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2884,   954,    -1,  3334,    -1,    -1,    -1,
      -1,    -1,    -1,  3267,    -1,    -1,    -1,    -1,  1253,    -1,
    3274,  3275,    -1,    -1,    -1,    -1,    -1,  3281,  3282,    -1,
      -1,    -1,  3286,  3287,    -1,    -1,  2917,    -1,  3292,  3293,
      -1,    -1,  3296,    -1,    -1,    -1,  1942,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3334,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1045,    -1,    -1,  1048,    -1,
      -1,  1051,    -1,    72,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,  3466,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3401,    -1,    -1,
      -1,    -1,  1102,    -1,  3035,  2048,    -1,    -1,    -1,  2052,
    2053,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1127,    -1,    -1,
      -1,    -1,    -1,  1133,    -1,    -1,    -1,  1137,  3442,    -1,
      -1,    -1,    -1,  2048,  1144,    -1,    -1,  2052,  2053,    -1,
      -1,    -1,    -1,  3457,    -1,    -1,    -1,  3461,    -1,    -1,
      -1,    -1,  3466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1171,    -1,    -1,  2120,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,  3488,    -1,    -1,    -1,  3492,    -1,
      -1,    -1,    -1,    -1,  1479,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,  3134,    -1,    -1,    -1,  3511,  3512,    72,
    2153,  3515,    -1,    -1,    -1,    -1,    -1,    -1,  3522,  3523,
      -1,   240,   241,    -1,    87,    -1,    -1,    90,  1513,    -1,
      -1,  2174,    95,    -1,   253,    -1,  1236,   100,  3542,    -1,
      -1,    -1,  1527,    -1,    -1,    -1,    -1,    -1,  2153,    -1,
    1250,    -1,  3556,    -1,    -1,  2201,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,  2174,
     289,    -1,    -1,    -1,    -1,    -1,    -1,  3581,    -1,    -1,
      -1,    -1,    -1,  2229,   303,    -1,   305,    -1,    -1,    -1,
    3668,  2237,    -1,  1578,  3672,  3673,    -1,    -1,    -1,   202,
      -1,  2247,    -1,    -1,    -1,    -1,   209,    -1,   211,    -1,
    1595,    -1,    -1,  3617,  3618,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3644,  3645,    -1,  3647,    -1,  3649,    -1,    -1,    -1,   368,
      -1,    -1,  1637,   216,    -1,    -1,  3287,   220,    -1,    -1,
      -1,  3739,    -1,    -1,  3668,    -1,    -1,    -1,  3672,  3673,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,   241,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2329,    -1,    -1,    -1,
     253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1685,    -1,    -1,  3334,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1696,    -1,  3717,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   286,  2329,    -1,   289,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   453,  3739,    -1,    -1,    -1,    -1,
     303,    -1,   305,    -1,    -1,    -1,    -1,   466,   467,   468,
      -1,   470,   471,   472,   473,   474,   475,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1472,    -1,  3778,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3793,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2461,    -1,    -1,    -1,    -1,
      -1,  2467,    -1,    -1,    -1,    -1,    -1,    -1,  3832,  3833,
      -1,    -1,    -1,    -1,    -1,  3466,    -1,    -1,    -1,    -1,
      -1,    -1,  3846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3858,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1848,    -1,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    -1,    -1,    90,    -1,    -1,    -1,    -1,    95,    -1,
     453,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   466,   467,   468,    -1,   470,   471,   472,
     473,   474,   475,    -1,    -1,  2558,  2559,    -1,  2561,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2574,    -1,  2576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1647,    -1,    -1,
      -1,    -1,    -1,  2558,  2559,    -1,  2561,    -1,    -1,    -1,
      -1,    -1,  2605,    -1,    -1,    -1,    -1,    -1,    -1,  2574,
      -1,  2576,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1690,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1699,
    2605,  1701,    -1,    -1,    -1,    -1,  1706,    -1,    -1,   216,
      -1,  2654,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1728,  1729,
      -1,    -1,  2675,   240,   241,    -1,    -1,  3668,    -1,    -1,
      -1,  3672,  3673,    -1,    -1,    -1,   253,    -1,    -1,  2654,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2705,  2048,    -1,    -1,    -1,  2052,  2053,  2715,
    2675,    -1,    -1,    -1,    -1,    -1,    -1,  2720,  2724,   286,
      -1,    -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2733,    -1,    -1,    -1,    -1,    -1,   303,  2743,   305,    -1,
    2705,    72,    -1,    -1,  2747,    -1,    -1,    -1,  3739,    -1,
      -1,    -1,    -1,    -1,    -1,  2720,    87,  2763,    -1,    -1,
      -1,  2767,    -1,    -1,    95,    -1,    -1,    -1,  2733,   100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2782,
      -1,    -1,  2747,    -1,  2790,  2788,  2792,    -1,    -1,    -1,
      -1,  2797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2806,   368,    -1,   766,    -1,    -1,    -1,   770,  2153,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2782,    -1,    -1,
    2826,    -1,    -1,  2788,    -1,  1885,    -1,    -1,    -1,  2174,
      -1,    -1,    -1,    -1,    -1,    -1,  2839,    -1,    -1,    -1,
     803,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2857,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     2,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2839,    -1,    -1,    -1,    -1,    -1,
      -1,  2884,    -1,    -1,    -1,   216,   453,    -1,   851,   220,
      -1,    -1,  2857,    -1,   857,    -1,    -1,    -1,    -1,   466,
     467,   468,    -1,   470,   471,   472,   473,   474,   475,   240,
     241,    -1,    -1,    -1,  2917,    -1,    -1,    -1,    -1,  2884,
      -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,  2934,  2935,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1998,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2011,  2917,    -1,    -1,   286,    -1,    -1,   289,  2019,
      -1,    -1,    -1,    -1,    -1,  2025,    -1,    -1,    -1,    -1,
    2030,    -1,   303,    -1,   305,    -1,  2036,    -1,    -1,    -1,
      -1,  2041,    -1,    -1,  2329,   316,    -1,    -1,    -1,   952,
      -1,    -1,    -1,    -1,   957,    -1,    -1,   960,    -1,    -1,
    2060,    -1,  2062,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
     983,    -1,    -1,   160,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3035,  2093,  2094,  2095,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,
    2110,  2111,  2112,  2113,    -1,    -1,    -1,  2117,  2118,    -1,
      -1,  2121,  2122,  2123,    -1,    -1,    -1,  2127,    -1,    -1,
    3035,    -1,    -1,    -1,  2134,    -1,    -1,  2137,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,   160,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
    3106,    -1,    90,    -1,    -1,    -1,    -1,    95,    -1,   180,
      -1,   182,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   453,  3129,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3134,    -1,  3139,    -1,   466,   467,   468,    -1,   470,
     471,   472,   473,   474,   475,    -1,  1109,    -1,    -1,    -1,
      -1,    -1,    -1,  1116,    -1,    -1,    -1,    -1,    -1,  1122,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3134,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3185,
    1143,    -1,    -1,    -1,  3190,    -1,    -1,  3193,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1170,    -1,    -1,
      -1,    -1,    -1,  2558,  2559,    -1,  2561,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,  2574,
      -1,  2576,   220,    -1,    -1,  2295,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,
    2605,    -1,    -1,  1226,    -1,   253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2335,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3287,    -1,    -1,    -1,    -1,    -1,
    1253,    -1,  3298,  3299,  3300,  3301,    -1,    -1,   286,    -1,
      -1,   289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2654,
      -1,  1274,    -1,    -1,    -1,   303,    -1,   305,    -1,    -1,
      -1,    -1,  3287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2675,  3334,    -1,    -1,    -1,    -1,    -1,  1300,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2705,    -1,    -1,    -1,    -1,    -1,    72,  1330,  1331,  3334,
    1333,    -1,    -1,    -1,    -1,  2720,    -1,    -1,    -1,    -1,
     368,    87,    -1,    -1,    -1,    -1,    -1,  1350,  2733,    95,
      -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3442,  2782,    -1,    -1,
      -1,    -1,    -1,  2788,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3461,  1419,    -1,    -1,  1422,
    1423,    -1,    -1,  3466,    -1,   453,    -1,    -1,  2528,  2529,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
     468,    -1,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,    -1,    -1,    -1,  2839,   201,    -1,    -1,    -1,    -1,
      -1,  3466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     216,    -1,  2857,    -1,   220,    -1,  1479,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1487,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   240,   241,  3542,    -1,    -1,  2884,
      -1,    -1,    -1,  1506,    -1,    -1,    -1,   253,    -1,    -1,
    1513,    -1,    -1,    -1,  2614,  2615,  2616,  2617,    -1,    -1,
      -1,    -1,    -1,    -1,  1527,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2917,    -1,    -1,  3581,    -1,  3583,    -1,    -1,
     286,    -1,    -1,   289,    -1,    -1,    -1,    -1,  2648,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   303,  3604,   305,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3617,    -1,    -1,    -1,  1578,    -1,    -1,    -1,  3625,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,
      -1,    -1,  1595,    -1,    -1,    -1,  2696,  2697,  2698,    -1,
      -1,    -1,    87,    -1,    -1,    90,    -1,    -1,    -1,  1612,
      95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,  3665,
      -1,  2721,   368,    -1,    -1,  3668,    -1,    -1,    -1,  3672,
    3673,    -1,    -1,    -1,  1637,    -1,    -1,    -1,    -1,    -1,
      -1,  2741,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3035,    -1,    -1,    -1,    -1,    -1,  2756,    -1,    -1,    -1,
      -1,    -1,    -1,  3668,    -1,    -1,    -1,  3672,  3673,    -1,
      -1,  3717,    -1,    -1,    -1,    -1,    -1,  1680,    -1,  1682,
      -1,    -1,  1685,    -1,  1687,    -1,    -1,   798,    -1,    -1,
      -1,    -1,    -1,  1696,    -1,    -1,  3739,    -1,    -1,   876,
      -1,    -1,    -1,    -1,    -1,    -1,   883,   453,   885,    -1,
     887,    -1,    -1,    -1,    -1,    -1,   893,   894,    -1,    -1,
     466,   467,   468,    -1,   470,   471,   472,   473,   474,   475,
      72,   216,  3778,    -1,  3739,   220,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    87,  1749,  3793,    -1,  3134,
      -1,    -1,    -1,    95,    -1,   240,   241,    -1,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,
      -1,    -1,   883,    -1,   885,    -1,   887,    -1,    -1,    -1,
    1783,  1784,   893,   894,    -1,    -1,  3832,    -1,  1791,    -1,
      -1,  1794,    -1,    -1,  1797,    -1,    -1,    -1,    -1,    -1,
    3846,   286,  1805,  1806,   289,    -1,    -1,    -1,    -1,   920,
    1813,    -1,  3858,  1816,  1817,  1818,  1819,    -1,   303,    -1,
     305,    -1,    -1,  1826,  1827,    -1,  1829,    -1,  1831,    -1,
      -1,  1834,    -1,    -1,    -1,    -1,   947,    -1,    -1,    -1,
      -1,    -1,  1019,    -1,    -1,  1848,  1849,   958,   959,    -1,
    1853,    -1,    -1,    -1,  1857,    -1,    -1,    -1,  1861,    -1,
    1037,  1864,  1865,  1866,  1867,  1868,  1869,  1870,  1871,  1872,
      -1,  1874,    -1,    -1,   216,    -1,  1879,    -1,   220,    -1,
    1883,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,   241,
      -1,    -1,  3287,    -1,    72,    -1,    -1,    -1,  1019,    -1,
      -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      -1,    -1,  1033,  1034,    -1,    -1,  1037,    95,    -1,    -1,
      -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1944,    -1,  3043,   286,    -1,    -1,   289,  3048,  3334,
    3050,  3051,  3052,  3053,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   303,    -1,   305,    -1,    -1,    -1,    -1,   453,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   466,   467,   468,    -1,   470,   471,   472,   473,   474,
     475,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3122,    -1,    -1,  2028,   368,    -1,    -1,  1140,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1215,  1216,
      -1,  1218,    -1,    -1,    -1,  2048,    -1,    -1,   216,  2052,
    2053,   393,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   240,   241,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3466,    -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3198,    -1,
    1211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   453,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,
      -1,   289,    -1,    -1,   466,   467,   468,    -1,   470,   471,
     472,   473,   474,   475,    -1,   303,    -1,   305,    -1,    -1,
      -1,    -1,    -1,  2146,    -1,    -1,    -1,    -1,    -1,    -1,
    2153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2172,
      -1,  2174,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1387,    -1,    -1,    -1,  1391,  1392,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1335,    -1,    -1,    -1,    -1,    -1,
      -1,  3331,    -1,    -1,  1345,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3342,    -1,  2247,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1444,    -1,    -1,
      -1,    -1,    -1,  1384,    -1,    -1,  1387,    -1,    -1,    -1,
    1391,  1392,    -1,  3668,    -1,   453,  2289,  3672,  3673,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   466,   467,
     468,    -1,   470,   471,   472,   473,   474,   475,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2318,    -1,    -1,    -1,    -1,
      -1,  1498,    -1,    -1,    -1,    -1,  2329,  1504,    -1,  3429,
      -1,    -1,    -1,    -1,    -1,    -1,  3436,    -1,    -1,    -1,
      -1,    -1,  1453,  2346,  2347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    80,  3739,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2376,    -1,    -1,    -1,  2380,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,  1498,    -1,  2392,
    2393,  2394,  2395,  1504,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2404,    -1,  1580,   131,    -1,  2409,   134,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2419,  2420,    -1,  2422,
      -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,
     157,    -1,  2435,    -1,  2437,    -1,    -1,    -1,  2441,    -1,
      -1,    -1,    -1,    -1,    -1,   172,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2457,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2467,    -1,  2469,  2470,    -1,  1580,
      -1,    -1,    -1,    -1,    -1,    -1,   203,    -1,   205,    -1,
      -1,    -1,   209,    -1,    -1,    -1,    -1,  2490,    -1,    -1,
      -1,    -1,    -1,  2496,    -1,  1672,   223,    -1,    -1,    -1,
      -1,    -1,  2505,  2506,  2507,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   246,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     257,    -1,    -1,    -1,  2537,    -1,    -1,    -1,    -1,    -1,
    1717,    -1,    -1,    -1,  1721,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1663,    -1,    -1,  2558,  2559,    -1,  2561,    -1,
      -1,  1672,    -1,    -1,    -1,    -1,    -1,  1744,    -1,    -1,
      -1,  2574,    -1,  2576,    -1,    -1,   303,    -1,   305,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3698,   326,
      -1,    -1,  2605,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1795,  1796,
      -1,   348,    -1,    -1,    -1,   352,  1803,   354,    -1,    -1,
    1807,  1808,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1822,    -1,  1824,    -1,    -1,
      -1,  2654,    -1,    -1,    -1,    -1,    -1,  3757,    -1,    -1,
      -1,   388,   389,    -1,   391,   392,    -1,  1844,    -1,  1846,
      -1,    -1,  2675,   400,    -1,    -1,    -1,   404,   405,    -1,
      -1,    -1,   409,    -1,  1795,  1796,    -1,   414,    -1,    -1,
      -1,  1802,  1803,    -1,    -1,    -1,  1807,  1808,    -1,    -1,
      -1,    -1,  2705,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1822,    -1,  1824,    -1,    -1,  1893,  2720,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2733,    -1,    -1,  1844,    -1,  1846,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2747,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2763,    -1,    -1,    -1,  2767,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2777,    -1,    -1,    -1,    -1,  2782,
      -1,    -1,    -1,    -1,    -1,  2788,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1909,    -1,
      -1,    -1,    -1,  2806,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1991,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1999,    -1,  2001,    -1,  2003,    -1,    -1,    -1,
      -1,    -1,    -1,  2836,    -1,    -1,  2839,    -1,    -1,    -1,
      -1,    -1,  2845,    -1,    -1,    -1,    -1,    -1,  2851,    -1,
    2853,    -1,    -1,    -1,  2857,  2858,    -1,    -1,  2861,  2862,
    2863,  2864,  2865,  2866,  2867,  2868,  2869,  2870,    -1,    -1,
      -1,    -1,  2875,  2876,    -1,    -1,    -1,    -1,    -1,    -1,
    1991,  2884,    -1,    -1,  1995,    -1,  2889,    -1,  1999,    -1,
      -1,    -1,  2895,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2904,    -1,    -1,  2907,    -1,  2909,     5,    -1,    -1,
    2087,    -1,    -1,    -1,  2917,  2918,  2919,  2920,    -1,  2096,
      -1,  2924,  2099,  2100,  2927,    -1,    -1,    -1,    26,    -1,
      -1,    -1,    -1,    -1,  2937,    -1,    -1,    -1,    36,    37,
      -1,    -1,    -1,    -1,    42,    -1,    44,    45,    -1,    -1,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    -1,    -1,  2087,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2096,    -1,    -1,  2099,  2100,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2176,
      -1,    -1,    -1,    -1,  2181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2154,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2162,    -1,    -1,    -1,  2166,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2176,    -1,    -1,    -1,    -1,
    2181,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,    -1,
    3123,    -1,    -1,    -1,  2235,    -1,    -1,    -1,    -1,    -1,
      -1,  3134,    -1,    -1,    -1,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   266,    -1,
    2281,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3185,    -1,    -1,    -1,    -1,  3190,    -1,    -1,
    3193,    -1,    -1,   291,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   357,
      -1,    -1,    -1,    -1,  3267,    -1,    -1,    -1,    -1,    -1,
      -1,  3274,  3275,    -1,    -1,    -1,    -1,    -1,  3281,  3282,
      -1,    -1,    -1,  3286,  3287,    -1,    -1,    -1,    -1,  3292,
    3293,    -1,    -1,  3296,    -1,    -1,    -1,    -1,   396,    -1,
      -1,  2478,    -1,  2480,    -1,  2482,    -1,    -1,    -1,    -1,
     408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   421,    -1,    -1,    -1,    -1,    -1,   766,
      -1,  3334,    -1,   770,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   443,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   451,   452,    -1,   454,    -1,   456,    -1,
      -1,    -1,   460,   461,   462,   463,   803,   465,   466,  2480,
      -1,  2482,   470,   471,   472,   473,   474,    -1,    -1,   477,
     478,   479,   480,    -1,   482,   483,   484,    -1,   486,   487,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3401,    -1,
      -1,  2578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   851,    -1,    -1,    -1,  2595,    -1,
     857,    -1,    -1,    -1,    -1,  2602,  2603,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3442,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3457,    -1,    -1,    -1,  3461,    -1,
      -1,    -1,    -1,  3466,    -1,    -1,    -1,  2578,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2595,  3488,    -1,    -1,    -1,  3492,
      -1,  2602,  2603,    -1,    -1,    -1,    -1,    -1,  2675,    -1,
      -1,    -1,    -1,  2680,    -1,  2682,    -1,    -1,  3511,  3512,
      -1,    -1,  3515,    -1,    -1,   952,    -1,  2694,    -1,  3522,
    3523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3542,
      -1,    -1,  2653,    -1,  2655,  2656,   983,    -1,    -1,    -1,
      -1,    -1,    -1,  3556,    -1,    -1,    -1,    -1,  2669,    -1,
      -1,    -1,    -1,    -1,  2675,    -1,    -1,    -1,    -1,  2680,
      -1,  2682,    -1,    -1,    -1,    -1,    -1,    -1,  3581,    -1,
      -1,    -1,    -1,  2694,  2695,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2705,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2717,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3617,  3618,    -1,    -1,    -1,    -1,
      -1,    -1,   952,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2745,  2746,    -1,    -1,    -1,    -1,
      -1,  3644,  3645,    -1,  3647,    -1,  3649,    -1,    -1,    -1,
      -1,    -1,    -1,   983,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3668,    -1,    -1,    -1,  3672,
    3673,    -1,  1109,    -1,    -1,    -1,    -1,    -1,    -1,  1116,
      -1,    -1,    -1,    -1,    -1,  1122,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1143,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3717,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1170,    -1,    -1,  3739,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3778,    -1,    -1,    -1,  1109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1226,
    3793,    -1,  2903,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2987,    -1,    -1,    -1,    -1,    -1,  1253,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3832,
    3833,    -1,    -1,    -1,    -1,    -1,    -1,  1274,    -1,    -1,
      -1,    -1,    -1,  3846,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3858,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1300,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1330,  1331,    -1,  1333,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3087,    -1,    -1,  1350,    -1,    -1,    -1,  3094,    -1,    -1,
      -1,    -1,  3099,  3100,  3101,  3102,  3103,    -1,    -1,    -1,
    3107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3064,  3065,  3066,  3067,  3068,  3069,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1300,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1419,  3094,    -1,  1422,  1423,    -1,  3099,  3100,
    3101,  3102,  3103,    -1,    -1,    -1,  3107,    -1,    -1,    -1,
    1330,  1331,    -1,  1333,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1479,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1513,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1419,
    1527,    -1,  1422,  1423,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3311,    -1,    -1,    -1,    -1,    -1,
      -1,  1578,    -1,  3320,    -1,  3322,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3332,  3333,    -1,  1595,    -1,
    3337,  3338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3347,    -1,    -1,    -1,    -1,  1612,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1637,  3312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3332,  3333,    -1,    -1,    -1,  3337,  3338,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3347,    -1,    -1,    -1,
      -1,    -1,    -1,  1680,    -1,  1682,    -1,    -1,  1685,    -1,
    1687,    -1,    -1,  3364,  3365,  3366,    -1,    -1,    -1,  1696,
      -1,    -1,    -1,  3374,  3375,    -1,    -1,    -1,  3379,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3418,    -1,    -1,
      -1,    -1,  1749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1783,  1784,    -1,  3526,
      -1,    -1,    -1,    -1,  1791,    -1,    -1,  1794,    -1,    -1,
    1797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1805,  1806,
      -1,    -1,    -1,    -1,    -1,    -1,  1813,    -1,    -1,  1816,
    1817,  1818,  1819,    -1,    -1,    -1,    -1,    -1,    -1,  1826,
    1827,    -1,  1829,    -1,  1831,    -1,    -1,  1834,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1848,  1849,    -1,    -1,    -1,  1853,    -1,    -1,    -1,
    1857,    -1,    -1,    -1,  1861,    -1,    -1,  1864,  1865,  1866,
    1867,  1868,  1869,  1870,  1871,  1872,    -1,  1874,    -1,    -1,
      -1,    -1,  1879,    -1,    -1,    -1,  1883,    -1,    -1,    -1,
      -1,    -1,  3563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1791,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1813,    -1,    -1,  1816,    -1,    -1,  1819,
      -1,    -1,    -1,    -1,    -1,    -1,  1826,  1827,    -1,    -1,
      -1,  1831,    -1,  3614,  1834,    -1,    -1,  1944,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1849,
      -1,    -1,    -1,  1853,    -1,    -1,    -1,  1857,    -1,    -1,
      -1,  1861,    -1,    -1,  1864,  1865,  1866,  1867,  1868,  1869,
    1870,  1871,  1872,    -1,  1874,    -1,    -1,    -1,    -1,  1879,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2028,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2048,    -1,    -1,  1944,  2052,  2053,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2028,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2146,
      -1,    -1,    -1,    -1,    -1,    -1,  2153,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,  2172,    -1,  2174,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,    -1,
      -1,    44,    45,    -1,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2247,    -1,    -1,    -1,    -1,    -1,  2146,    -1,    -1,    -1,
    2257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   114,  2172,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2289,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,  2346,
    2347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   195,    -1,    -1,    -1,    -1,  2257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2376,
      -1,   214,    -1,  2380,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2392,  2393,  2394,  2395,  2289,
      -1,   234,    -1,    -1,    -1,    -1,    -1,  2404,    -1,    -1,
      -1,    -1,  2409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2419,  2420,    -1,  2422,    -1,    -1,  2318,    -1,
      -1,    -1,    -1,   266,    -1,    -1,   269,    -1,  2435,    -1,
    2437,    -1,    -1,    -1,  2441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2347,   291,    -1,
    2457,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2467,    -1,  2469,  2470,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2490,    -1,    -1,    -1,    -1,    -1,  2496,
      -1,    -1,  2392,    -1,  2394,  2395,    -1,    -1,  2505,  2506,
    2507,    -1,    -1,    -1,  2404,    -1,    -1,    -1,    -1,  2409,
      -1,    -1,    -1,    -1,   357,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2537,    -1,    -1,    -1,    -1,  2435,    -1,  2437,    -1,    -1,
      -1,  2441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2558,  2559,   396,  2561,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   408,    -1,  2574,    -1,  2576,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2490,    -1,    -1,    -1,    -1,    -1,  2496,    -1,  2605,    -1,
     443,    -1,    -1,    -1,    -1,  2505,  2506,  2507,   451,   452,
      -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,   474,    -1,    -1,   477,   478,   479,  2537,    -1,    -1,
     483,    -1,    -1,    -1,   487,    -1,    -1,  2654,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2675,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1346,    -1,    -1,    -1,    -1,    -1,    -1,  2705,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2720,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2733,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1409,    -1,  2763,    -1,    -1,    -1,
    2767,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2777,    -1,    -1,    -1,    -1,  2782,    -1,    -1,    -1,    -1,
      -1,  2788,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2806,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2836,
      -1,    -1,  2839,    -1,    -1,    -1,    -1,    -1,  2845,    -1,
      -1,    -1,    -1,    -1,  2851,    -1,  2853,    -1,    -1,    -1,
    2857,  2858,    -1,    -1,  2861,  2862,  2863,  2864,  2865,  2866,
    2867,  2868,  2869,  2870,    -1,    -1,    -1,    -1,  2875,  2876,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2884,    -1,    -1,
      -1,    -1,  2889,    -1,    -1,    -1,    -1,    -1,  2895,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2904,    -1,    -1,
    2907,    -1,  2909,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2917,  2918,  2919,  2920,  1569,    -1,    -1,  2924,    -1,    -1,
    2927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2937,    -1,    -1,    -1,    -1,    -1,  2836,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2845,    -1,    -1,    -1,    -1,
      -1,  2851,    -1,  2853,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2875,  2876,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2895,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2904,    -1,    -1,  2907,    -1,  2909,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2918,    -1,
      -1,    -1,    -1,    -1,  2924,    -1,    -1,  2927,  3035,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2937,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1722,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3123,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3134,    -1,    -1,
      -1,    -1,    -1,    -1,  1789,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1812,    -1,    -1,
      -1,    -1,  1817,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3185,    -1,
      -1,  1836,  1837,  3190,    -1,  1840,  3193,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1877,    -1,  3231,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3267,    -1,    -1,    -1,    -1,    -1,    -1,  3274,  3275,    -1,
      -1,    -1,    -1,    -1,  3281,  3282,    -1,    -1,    -1,  3286,
    3287,    -1,    -1,    -1,    -1,  3292,  3293,    -1,    -1,  3296,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1953,    -1,
      -1,    -1,    -1,    -1,    -1,  1960,    -1,  1962,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3334,    -1,    -1,
      -1,  3231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3274,  3275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3286,    -1,    -1,    -1,
      -1,    -1,  3292,  3293,  3401,    -1,  3296,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3457,    -1,    -1,    -1,  3461,    -1,    -1,    -1,    -1,  3466,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3488,    -1,    -1,    -1,  3492,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3401,    -1,    -1,  3511,  3512,    -1,    -1,  3515,    -1,
      -1,    -1,    -1,    -1,    -1,  3522,  3523,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3542,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3556,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3457,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3581,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3617,  3618,    -1,    -1,    -1,  3515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3523,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3644,  3645,    -1,
    3647,    -1,  3649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3556,    -1,    -1,    -1,
      -1,  3668,    -1,    -1,    -1,  3672,  3673,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2350,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3717,    -1,    -1,    -1,    -1,    -1,    -1,  2372,  3618,  2374,
      -1,  2376,  2377,    -1,    -1,  2380,    -1,    -1,    -1,  2384,
      -1,    -1,  3739,    -1,    -1,    -1,  2391,    -1,    -1,    -1,
      -1,  2396,    -1,    -1,    -1,    -1,  2401,  3647,    -1,    -1,
      -1,  2406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2415,    -1,    -1,    -1,  2419,  2420,  2421,    -1,    -1,    -1,
      -1,  3778,    -1,    -1,    -1,    -1,    -1,    -1,  2433,    -1,
      -1,    -1,    -1,    -1,    -1,  2440,  3793,  2442,  2443,  2444,
    2445,  2446,  2447,  2448,  2449,  2450,  2451,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3832,  3833,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3846,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3858,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,  2544,
      -1,    -1,    44,    45,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2652,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   266,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,  2779,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,
      -1,  2796,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2835,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2856,    -1,  2858,    -1,   357,  2861,  2862,  2863,  2864,
    2865,  2866,  2867,  2868,  2869,  2870,    -1,  2872,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2896,    -1,    -1,   396,  2900,    -1,    -1,    -1,    -1,
    2905,  2906,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2919,  2920,  2921,    -1,  2923,   421,
      -1,  2926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,   474,    -1,    -1,   477,   478,   479,   480,    -1,
      -1,    -1,    -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,  2999,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    37,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    -1,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    36,    37,    -1,    -1,    -1,  3123,    -1,
      -1,    44,    45,    -1,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   234,    -1,    -1,    -1,    -1,  3232,    -1,    -1,
    3235,  3236,  3237,    -1,    -1,  3240,    -1,    -1,    -1,    -1,
    3245,  3246,  3247,  3248,  3249,  3250,  3251,  3252,  3253,  3254,
    3255,  3256,    -1,    -1,   266,    -1,    -1,   269,   181,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   195,    -1,    -1,  3280,  3281,  3282,  3283,   291,
    3285,    -1,    -1,    -1,  3289,  3290,  3291,    -1,    -1,  3294,
      -1,   214,  3297,    -1,    -1,    -1,    -1,    -1,    -1,  3304,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   266,    -1,   357,   269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   291,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   396,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,  3403,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   421,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   443,    -1,    -1,   357,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,   474,    -1,    -1,   477,   478,   479,   480,    -1,
      -1,    -1,    -1,   396,    -1,   487,    -1,    -1,    -1,  3484,
      -1,    -1,    -1,  3488,    -1,   408,    -1,  3492,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3500,    -1,  3502,   421,    -1,
      -1,  3506,  3507,  3508,    -1,    -1,  3511,  3512,  3513,  3514,
      -1,  3516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,   452,
      -1,   454,    -1,    -1,    -1,    -1,    -1,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,   474,    -1,    -1,   477,   478,   479,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   487,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3585,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3629,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3643,  3644,
    3645,  3646,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3656,  3657,  3658,    -1,  3660,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3675,    -1,    -1,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
    3715,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,  3727,  3728,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,    -1,   105,   106,   107,    -1,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,    -1,
     182,   183,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   201,
     202,   203,    -1,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,   215,   216,   217,   218,   219,   220,   221,
     222,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,   236,   237,   238,    -1,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,    -1,    -1,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,    -1,   317,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,    -1,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,   417,   418,   419,    -1,   421,
     422,   423,   424,   425,   426,   427,   428,   429,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,
      -1,    -1,   454,    -1,    -1,    -1,     6,     7,     8,    -1,
      10,    11,    12,    13,    14,    -1,    -1,    -1,    18,    -1,
      20,    21,    22,    23,    24,    25,    -1,    27,    28,    -1,
      -1,   483,    32,    33,    34,    35,    -1,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    -1,    -1,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    -1,    -1,    -1,
     100,   101,   102,   103,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,
      -1,    -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   154,   155,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   181,    -1,    -1,    -1,    -1,    -1,   187,    -1,    -1,
     190,    -1,    -1,    -1,    -1,   195,    -1,    -1,    -1,    -1,
     200,    -1,   202,    -1,    -1,    -1,    -1,    -1,   208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   216,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   228,   229,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
     240,   241,    -1,   243,    -1,    -1,    -1,    -1,    -1,    -1,
     250,   251,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,   289,
      -1,    -1,   292,    -1,   294,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,   308,   309,
     310,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   318,   319,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,    -1,    -1,
     350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   365,    -1,    -1,   368,    -1,
     370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   394,   395,    -1,    -1,    -1,   399,
      -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,   408,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   421,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   435,   436,   437,   438,   439,
     440,   441,   442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,    -1,    -1,    -1,    -1,     6,
       7,     8,    -1,    10,    11,    12,    13,    14,    -1,    -1,
      -1,    18,    -1,    20,    21,    22,    23,    24,    25,    -1,
      27,    28,    -1,    -1,   484,    32,    33,    34,    35,    -1,
      37,    -1,    39,    40,    41,    -1,    43,    44,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      -1,    68,    -1,    70,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      -1,    -1,    -1,   100,   101,   102,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
     187,    -1,    -1,   190,    -1,    -1,    -1,    -1,   195,    -1,
      -1,    -1,    -1,   200,    -1,   202,    -1,    -1,    -1,    -1,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   228,   229,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,   240,   241,    -1,   243,    -1,    -1,    -1,
      -1,    -1,    -1,   250,   251,    -1,   253,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,
      -1,    -1,   289,    -1,    -1,   292,    -1,   294,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     307,   308,   309,   310,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   318,   319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   330,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     347,    -1,    -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   365,    -1,
      -1,   368,    -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   394,   395,    -1,
      -1,    -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,
      -1,   408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   421,    -1,   423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,
     437,   438,   439,   440,   441,   442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,     3,
      -1,    -1,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    -1,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    -1,    27,    28,    29,    -1,   484,    32,    33,
      34,    35,    -1,    37,    -1,    39,    40,    41,    -1,    43,
      44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,
      -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,
      -1,    85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    -1,    99,   100,   101,   102,   103,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,    -1,   118,    -1,   120,   121,   122,    -1,
      -1,   125,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   135,    -1,   137,    -1,    -1,    -1,   141,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,
     154,   155,   156,    -1,    -1,    -1,    -1,    -1,   162,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,
     174,    -1,    -1,    -1,    -1,    -1,   180,   181,    -1,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,    -1,   193,
      -1,   195,    -1,    -1,    -1,    -1,   200,    -1,   202,    -1,
     204,    -1,   206,    -1,   208,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   228,   229,    -1,    -1,   232,    -1,
      -1,   235,    -1,   237,    -1,    -1,   240,   241,    -1,   243,
      -1,    -1,    -1,    -1,    -1,    -1,   250,   251,    -1,   253,
      -1,   255,   256,    -1,    -1,    -1,    -1,   261,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   270,    -1,    -1,   273,
     274,   275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     284,    -1,    -1,    -1,   288,   289,    -1,    -1,   292,    -1,
     294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   307,   308,   309,   310,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   318,   319,    -1,   321,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   330,   331,    -1,    -1,
     334,    -1,   336,    -1,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,   346,   347,    -1,   349,   350,    -1,    -1,   353,
      -1,    -1,    -1,    -1,    -1,   359,    -1,    -1,    -1,     3,
     364,   365,    -1,   367,   368,     9,   370,    -1,    -1,    -1,
     374,    15,    -1,    17,    -1,    19,    -1,    -1,   382,    -1,
      -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,
     394,   395,    -1,    -1,    -1,   399,    -1,   401,    -1,   403,
      -1,   405,    46,    47,   408,    -1,    -1,   411,    -1,   413,
      -1,    -1,   416,    -1,    -1,    -1,   420,   421,    -1,   423,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      -1,   435,   436,   437,   438,   439,   440,   441,   442,    83,
      -1,    85,    86,    -1,    -1,    -1,    -1,   451,    -1,    -1,
     454,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   118,   479,   120,   121,    -1,    -1,
      -1,   125,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   135,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,    -1,    -1,    -1,   162,    -1,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,    -1,
     174,    -1,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,
      -1,    -1,   186,    -1,   188,    -1,    -1,    -1,    -1,   193,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     204,    -1,   206,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   255,   256,    -1,    -1,    -1,    -1,   261,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   270,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   321,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   331,    -1,    -1,
     334,    -1,   336,    -1,    -1,    -1,    -1,   341,    -1,    -1,
      -1,    -1,   346,    -1,    -1,   349,    -1,    -1,    -1,   353,
      -1,    -1,    -1,    -1,    -1,   359,    -1,    -1,    -1,    -1,
     364,    -1,    -1,   367,    -1,    -1,    -1,    -1,    -1,    -1,
     374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,
      -1,   405,    -1,    -1,    -1,    -1,    -1,   411,    -1,   413,
      -1,    -1,   416,    -1,    -1,    -1,   420,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      -1,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,   479,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    92,    93,    -1,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,    -1,   106,   107,
      -1,   109,   110,   111,   112,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,   141,   142,    -1,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,    -1,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
     228,   229,    -1,   231,   232,   233,   234,   235,    -1,   237,
      -1,    -1,   240,   241,   242,   243,   244,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
     308,   309,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,   402,   403,   404,   405,   406,   407,
      -1,   409,   410,   411,   412,   413,   414,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,   453,   454,   455,    -1,    -1,
     458,   459,   460,   461,   462,   463,   464,   465,    -1,    -1,
      -1,    -1,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      92,    93,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,    -1,   106,   107,    -1,   109,   110,   111,
     112,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,    -1,   138,   139,   140,   141,
     142,    -1,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,   167,   168,    -1,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,    -1,    -1,
     182,    -1,   184,   185,   186,   187,   188,   189,   190,   191,
     192,   193,   194,   195,    -1,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,
     212,   213,   214,   215,   216,   217,   218,   219,    -1,   221,
     222,   223,   224,   225,   226,    -1,   228,   229,    -1,   231,
     232,   233,   234,   235,    -1,   237,    -1,    -1,   240,   241,
     242,   243,   244,   245,   246,   247,   248,    -1,   250,   251,
     252,   253,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,   304,    -1,    -1,   307,   308,   309,   310,   311,
     312,   313,   314,   315,    -1,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,    -1,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,    -1,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,   370,    -1,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,    -1,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,   394,   395,    -1,    -1,   398,   399,   400,   401,
     402,   403,   404,   405,   406,   407,    -1,   409,   410,   411,
     412,   413,   414,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,    -1,   429,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,
     452,   453,   454,   455,    -1,    -1,   458,   459,   460,   461,
     462,   463,   464,   465,    -1,    -1,    -1,    -1,   470,   471,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      -1,    17,    18,    -1,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    -1,    39,    40,    41,    -1,    43,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      66,    -1,    68,    -1,    70,    71,    -1,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,    -1,
     106,   107,    -1,   109,   110,    -1,    -1,   113,   114,   115,
     116,    -1,   118,   119,   120,   121,    -1,    -1,    -1,   125,
     126,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
     136,    -1,   138,   139,   140,   141,   142,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,   167,   168,    -1,    -1,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,   185,
     186,    -1,   188,   189,    -1,    -1,   192,   193,   194,   195,
      -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,   207,    -1,    -1,   210,    -1,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,    -1,   228,   229,    -1,   231,   232,   233,   234,   235,
      -1,   237,    -1,    -1,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,    -1,   251,   252,   253,    -1,   255,
     256,   257,    -1,    -1,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,   279,   280,   281,   282,   283,    -1,   285,
      -1,   287,   288,   289,   290,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,    -1,    -1,    -1,   303,   304,    -1,
      -1,   307,   308,   309,    -1,   311,   312,   313,   314,   315,
      -1,   317,    -1,    -1,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,    -1,   351,   352,   353,   354,   355,
     356,   357,    -1,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,   368,   369,   370,    -1,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,    -1,   403,   404,   405,
     406,   407,    -1,    -1,   410,   411,   412,   413,    -1,    -1,
     416,   417,   418,   419,    -1,   421,   422,   423,   424,   425,
     426,    -1,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   443,   444,   445,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,   454,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    -1,
      17,    18,    -1,    20,    21,    22,    23,    24,    25,    -1,
      27,    28,    29,    -1,   480,    32,    33,    34,    35,    -1,
      -1,    -1,    39,    40,    41,    -1,    43,    -1,    -1,    46,
      47,    -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,
      -1,    68,    -1,    70,    71,    -1,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    92,    93,    -1,    95,    -1,
      97,    98,    99,    -1,   101,    -1,   103,    -1,    -1,   106,
     107,    -1,   109,   110,    -1,    -1,   113,   114,   115,   116,
      -1,   118,   119,   120,   121,   122,    -1,    -1,   125,   126,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,   136,
      -1,   138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
     167,   168,    -1,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,    -1,    -1,   182,    -1,   184,   185,   186,
     187,   188,   189,   190,    -1,   192,   193,   194,   195,    -1,
     197,    -1,   199,    -1,    -1,    -1,   203,    -1,   205,    -1,
     207,   208,    -1,   210,    -1,   212,   213,   214,   215,    -1,
     217,   218,   219,    -1,   221,   222,   223,   224,   225,   226,
      -1,    -1,   229,    -1,   231,   232,   233,    -1,   235,    -1,
     237,    -1,    -1,    -1,    -1,   242,    -1,   244,   245,   246,
     247,   248,    -1,   250,    -1,   252,    -1,    -1,   255,   256,
     257,    -1,    -1,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,    -1,   275,    -1,
     277,   278,   279,   280,   281,   282,   283,   284,   285,    -1,
     287,   288,    -1,   290,    -1,   292,   293,   294,   295,   296,
      -1,    -1,   299,    -1,    -1,    -1,   303,   304,    -1,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,    -1,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,    -1,   345,   346,
      -1,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,    -1,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,   372,   373,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   383,    -1,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,   394,   395,    -1,
      -1,   398,   399,   400,   401,    -1,   403,   404,   405,   406,
     407,    -1,    -1,   410,   411,   412,   413,    -1,   415,   416,
     417,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,   430,   431,   432,   433,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,   444,   445,    -1,
      -1,    -1,    -1,    -1,   451,    -1,    -1,   454,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     477,    -1,    -1,    -1,   481,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,   201,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,   397,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,   409,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,   409,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,   409,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,
      -1,    -1,   477,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,   201,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,   409,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,   409,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,   470,   471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,   182,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,   216,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,    -1,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,   453,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,    -1,   471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
      -1,   101,   102,   103,   104,    -1,   106,   107,    -1,   109,
     110,   111,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,    -1,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,    -1,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,   234,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,   402,   403,   404,   405,   406,   407,    -1,   409,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,   452,   453,   454,   455,    -1,    -1,   458,   459,
     460,   461,   462,   463,   464,   465,    -1,    -1,    -1,    -1,
     470,   471,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   479,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    -1,    17,    18,    -1,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    -1,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    66,    -1,    68,    -1,    70,    71,    -1,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    92,    93,    -1,
      95,    96,    97,    98,    99,    -1,   101,   102,   103,   104,
      -1,   106,   107,    -1,   109,   110,   111,   112,   113,   114,
     115,   116,    -1,   118,   119,   120,   121,   122,    -1,    -1,
     125,   126,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,   136,    -1,   138,   139,   140,   141,   142,    -1,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,   167,   168,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,    -1,    -1,    -1,    -1,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,    -1,   197,    -1,   199,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,    -1,   210,    -1,   212,   213,   214,
     215,    -1,   217,   218,   219,    -1,   221,   222,   223,   224,
     225,   226,    -1,   228,   229,    -1,   231,   232,   233,   234,
     235,    -1,   237,    -1,    -1,   240,   241,   242,   243,   244,
     245,   246,   247,   248,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,    -1,   304,
      -1,    -1,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,    -1,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,    -1,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,   394,
     395,    -1,    -1,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,    -1,    -1,   410,   411,   412,   413,   414,
      -1,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,    -1,    -1,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,    -1,    -1,    -1,    -1,    -1,   451,   452,    -1,   454,
     455,    -1,    -1,   458,   459,   460,   461,   462,   463,   464,
     465,    -1,    -1,    -1,    -1,    -1,   471,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   479,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,    -1,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,    -1,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,    -1,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,   289,
     290,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,    -1,   403,   404,   405,   406,   407,    -1,    -1,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,   479,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,    -1,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,    -1,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,   289,
     290,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,   302,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,    -1,   403,   404,   405,   406,   407,    -1,    -1,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,   479,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,    -1,    -1,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,    -1,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,   289,
     290,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,    -1,   403,   404,   405,   406,   407,    -1,    -1,
     410,   411,   412,   413,   414,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    -1,    17,    18,   479,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    -1,    39,
      40,    41,    -1,    43,    44,    45,    46,    47,    -1,    -1,
      -1,    51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,
      70,    71,    -1,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    92,    93,    -1,    95,    96,    97,    98,    99,
     100,   101,   102,   103,    -1,    -1,   106,   107,    -1,   109,
     110,    -1,    -1,   113,   114,   115,   116,    -1,   118,   119,
     120,   121,   122,    -1,    -1,   125,   126,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,   136,    -1,   138,   139,
     140,   141,   142,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,   167,   168,    -1,
      -1,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
      -1,    -1,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,    -1,   192,   193,   194,   195,    -1,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,
     210,    -1,   212,   213,   214,   215,   216,   217,   218,   219,
      -1,   221,   222,   223,   224,   225,   226,    -1,   228,   229,
      -1,   231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,    -1,   255,   256,   257,    -1,    -1,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,    -1,   287,   288,   289,
     290,    -1,   292,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,   304,    -1,    -1,   307,   308,   309,
     310,   311,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,    -1,    -1,
     360,   361,   362,    -1,   364,   365,   366,   367,   368,   369,
     370,    -1,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,    -1,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,   394,   395,    -1,    -1,   398,   399,
     400,   401,    -1,   403,   404,   405,   406,   407,    -1,    -1,
     410,   411,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,    -1,   429,
     430,   431,   432,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,
      -1,   451,    -1,    -1,   454,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    -1,    17,    18,    -1,    20,
      21,    22,    23,    24,    25,    -1,    27,    28,    29,   479,
      -1,    32,    33,    34,    35,    -1,    -1,    -1,    39,    40,
      41,    -1,    43,    -1,    -1,    46,    47,    -1,    -1,    -1,
      51,    52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,
      71,    -1,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    92,    93,    -1,    95,    -1,    97,    98,    99,    -1,
     101,    -1,   103,    -1,    -1,   106,   107,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    -1,   118,   119,   120,
     121,   122,    -1,    -1,   125,   126,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,   136,    -1,   138,   139,   140,
     141,   142,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,   167,   168,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,    -1,
      -1,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
      -1,   192,   193,   194,   195,    -1,   197,    -1,   199,    -1,
      -1,   202,   203,    -1,   205,    -1,   207,   208,    -1,   210,
      -1,   212,   213,   214,   215,    -1,   217,   218,   219,    -1,
     221,   222,   223,   224,   225,   226,    -1,   228,   229,    -1,
     231,   232,   233,    -1,   235,    -1,   237,    -1,    -1,    -1,
      -1,   242,   243,   244,   245,   246,   247,   248,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,    -1,    -1,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,   277,   278,   279,   280,
     281,   282,   283,   284,   285,    -1,   287,   288,    -1,   290,
      -1,   292,   293,   294,   295,   296,    -1,    -1,   299,    -1,
      -1,    -1,   303,   304,    -1,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,    -1,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,    -1,    -1,   360,
     361,   362,    -1,   364,   365,   366,   367,    -1,   369,   370,
      -1,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,    -1,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,   394,   395,    -1,    -1,   398,   399,   400,
     401,    -1,   403,   404,   405,   406,   407,    -1,    -1,   410,
     411,   412,   413,    -1,    -1,   416,   417,   418,   419,   420,
     421,   422,    -1,   424,   425,   426,    -1,    -1,   429,   430,
     431,   432,   433,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,
     451,    -1,    -1,   454,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    -1,    17,    18,    -1,    20,    21,
      22,    23,    24,    25,    -1,    27,    28,    29,    -1,   480,
      32,    33,    34,    35,    -1,    -1,    -1,    39,    40,    41,
      -1,    43,    -1,    -1,    46,    47,    -1,    -1,    -1,    51,
      52,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    -1,    68,    -1,    70,    71,
      -1,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    93,    -1,    95,    -1,    97,    98,    99,    -1,   101,
      -1,   103,    -1,    -1,   106,   107,    -1,   109,   110,    -1,
      -1,   113,   114,   115,   116,    -1,   118,   119,   120,   121,
     122,    -1,    -1,   125,   126,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,   136,    -1,   138,   139,   140,    -1,
     142,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,   167,   168,    -1,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,    -1,    -1,
     182,    -1,   184,   185,   186,   187,   188,   189,   190,    -1,
     192,   193,   194,   195,    -1,   197,    -1,   199,    -1,    -1,
      -1,   203,    -1,   205,    -1,   207,   208,    -1,   210,    -1,
     212,   213,   214,   215,    -1,   217,   218,   219,    -1,   221,
     222,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,   233,    -1,   235,    -1,   237,    -1,    -1,    -1,    -1,
     242,    -1,   244,   245,   246,   247,   248,    -1,   250,    -1,
     252,    -1,    -1,   255,   256,   257,    -1,    -1,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,    -1,   275,    -1,   277,   278,   279,   280,   281,
     282,   283,   284,   285,    -1,   287,   288,    -1,   290,    -1,
     292,   293,   294,   295,   296,    -1,    -1,   299,    -1,    -1,
      -1,   303,   304,    -1,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,    -1,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,    -1,   345,   346,    -1,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,    -1,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
     372,   373,   374,   375,   376,   377,   378,   379,   380,   381,
     382,   383,    -1,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,   394,   395,    -1,    -1,   398,   399,   400,   401,
      -1,   403,   404,   405,   406,   407,    -1,    -1,   410,   411,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,    -1,   424,   425,   426,    -1,    -1,   429,   430,   431,
     432,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,   444,   445,    -1,    -1,    -1,    -1,    -1,   451,
     452,    -1,   454,   455,    -1,    -1,    -1,    -1,   460,   461,
     462,   463,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   478,   479,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,    -1,    20,    21,    22,    23,    24,    25,    -1,    27,
      28,    29,    -1,    -1,    32,    33,    34,    35,    -1,    -1,
      -1,    39,    40,    41,    -1,    43,    -1,    -1,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    -1,    95,    -1,    97,
      98,    99,    -1,   101,    -1,   103,    -1,    -1,   106,   107,
      -1,   109,   110,    -1,    -1,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,    -1,   192,   193,   194,   195,    -1,   197,
      -1,   199,    -1,    -1,    -1,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,   233,    -1,   235,    -1,   237,
      -1,    -1,    -1,    -1,   242,    -1,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,    -1,    -1,   255,   256,   257,
      -1,    -1,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,    -1,   275,    -1,   277,
     278,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,    -1,   290,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,    -1,    -1,    -1,   303,   304,    -1,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,    -1,   345,   346,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,    -1,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,   394,   395,    -1,    -1,
     398,   399,   400,   401,    -1,   403,   404,   405,   406,   407,
      -1,    -1,   410,   411,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,    -1,   424,   425,   426,    -1,
      -1,   429,   430,   431,   432,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,   444,   445,    -1,    -1,
      -1,    -1,    -1,   451,   452,    -1,   454,   455,    -1,    -1,
      -1,    -1,   460,   461,   462,   463,    -1,    -1,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    -1,    17,
      18,   479,    20,    21,    22,    23,    24,    25,    -1,    27,
      28,    29,    -1,    -1,    32,    33,    34,    35,    -1,    -1,
      -1,    39,    40,    41,    -1,    43,    -1,    -1,    46,    47,
      -1,    -1,    -1,    51,    52,    -1,    -1,    -1,    -1,    57,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      68,    -1,    70,    71,    -1,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    -1,    95,    -1,    97,
      98,    99,    -1,   101,    -1,   103,    -1,    -1,   106,   107,
      -1,   109,   110,    -1,    -1,   113,   114,   115,   116,    -1,
     118,   119,   120,   121,   122,    -1,    -1,   125,   126,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,    -1,
     138,   139,   140,    -1,   142,    -1,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,   167,
     168,    -1,    -1,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,    -1,    -1,   182,    -1,   184,   185,   186,   187,
     188,   189,   190,    -1,   192,   193,   194,   195,    -1,   197,
      -1,   199,    -1,    -1,    -1,   203,    -1,   205,    -1,   207,
     208,    -1,   210,    -1,   212,   213,   214,   215,    -1,   217,
     218,   219,    -1,   221,   222,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,   233,    -1,   235,    -1,   237,
      -1,    -1,    -1,    -1,   242,    -1,   244,   245,   246,   247,
     248,    -1,   250,    -1,   252,    -1,    -1,   255,   256,   257,
      -1,    -1,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,    -1,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,    -1,   290,    -1,   292,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,   304,    -1,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,   321,   322,    -1,   324,   325, 