#!/usr/local/bin/perl
#
# cafPage.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package cafPage;

# Page attributes :
# _system => system datas onlys for display or test;
# _hidden => hidden data
# _data   => data elements
# statuslist => 
# _list1 => list elemens (array)
# list1count => 
# _list2 => list elemens (array)
# list2count => 
# checkfields => array of hash;
# _debug => 
#	errortext => array
#	errors    => number

sub new {
	my $class = shift;
	my $class = ref($class) || $class;

	my $self = shift;

	$self = { _system => {}, _hidden => {}, _data => {} } unless ($self);
	bless $self, $class;
}

sub _hiddenvar {
	my $self = shift;
	my $attr = shift;
	if (@_) { $self->{_hidden}->{$attr} = shift; }
	$self->{_hidden}->{$attr};
}

sub _monitorvar {
	my $self = shift;
	my $attr = shift;
	if (@_) { $self->{__monitoring__}->{$attr} = shift; }
	$self->{__monitoring__}->{$attr};
}

sub _systemvar {
	my $self = shift;
	my $attr = shift;
	if (@_) { $self->{_system}->{$attr} = shift; }
	$self->{_system}->{$attr};
}

sub _datavar {
	my $self = shift;
	my $attr = shift;
	if (@_) { $self->{_data}->{$attr} = shift; }
	$self->{_data}->{$attr};
}

sub deletevar {
	my $self = shift;
	my $cat  = shift; # _system/_hidden/_data
	my $attr = shift;
	delete $self->{$cat}->{$attr};
}

sub displaypage {
	die "malformed page (no displaypage procedure)";
}
 
sub startpage {
	die "malformed page (no startpage procedure)";
}

sub attribute {
	my $self = shift;
	my $attrname = shift;
 
	(@_) ? $self->{$attrname}=shift : $self->{$attrname};
}
 
sub _attribute {
	my $self = shift;
	my $attrname = shift;
	my $subattr = shift;
 
	(@_) ? $self->{$attrname}{$subattr} = shift : $self->{$attrname}{$subattr};
}

sub _initmeth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	my $objectidname = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	if ($actiondetail =~ /^v/) {
		my $meth_name = "meth_$actiondetail";
		if ($self->$meth_name($cgi, $dbh, $conf)) {
			if ($actiondetail eq 'vdrop') {
				$self->_hiddenvar ("_actiondetail", 'search');
				return ($self->meth_search($cgi, $dbh, $conf));
			}
			$actiondetail = $self->_hiddenvar ("_actiondetail", 'edit');
		}
#		else { $self->{_system}{noselect} = 1; }
		$actiondetail =~ s/^v//;
		$self->_hiddenvar ("_actiondetail", $actiondetail)
	}
#	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
#	else { $self->{userid} = $cgi->param("_objectid") unless ($self->{userid}); }
}

sub _getnavinfo {
	my $self = shift;
	my $table = shift;
	my $cond = shift;
	my $isobject = shift;

        my $cgi =  $self->{_system}{_cgi};
        my $dbh =  $self->{_system}{_dbh};
        my $conf =  $self->{_system}{_conf};

        my $rowscount = $dbh->tablerowscount($table, $cond, $isobject);

        my $maxlistdisplay = $conf->maxlistdisplay();
 
        my $lastrow = 1;
	if ($rowscount > $maxlistdisplay) {
        	my $actiondetail = $self->_hiddenvar ("_actiondetail");
        	$lastrow = $cgi->param("_lastrow") || 1;
 
		if ($actiondetail eq "search") { $lastrow = 1; }
        	elsif ($actiondetail eq "top") { $lastrow = 1; }
        	elsif ($actiondetail eq "bottom") { $lastrow = $rowscount - $maxlistdisplay + 3; }
        	elsif ($actiondetail eq "prev") { $lastrow -= (($maxlistdisplay - 1) * 2); }
        	elsif ($actiondetail eq "refresh") { $lastrow -= ($maxlistdisplay - 1); }
# nothing to do        	elsif ($actiondetail eq "next") { }
 
#        	if (($rowscount - $lastrow) < $maxlistdisplay) { $lastrow = $rowscount - $maxlistdisplay + 1; }
		$lastrow--;
        	if ($lastrow < 1) { $lastrow = 1; }
	} 

        $self->_hiddenvar("_lastrow", $lastrow);
        $self->_hiddenvar("_rowscount", $rowscount);

	return ($rowscount, $lastrow, $maxlistdisplay);
}

sub _setnavinfo {
	my $self = shift;
	my $list = shift;

        my $conf =  $self->{_system}{_conf};

        my $lastrow = $self->_hiddenvar("_lastrow");
        my $rowscount = $self->_hiddenvar("_rowscount");
        my $maxlistdisplay = $conf->maxlistdisplay();

	$self->{_button} = {};
	if ($rowscount > $maxlistdisplay) {
		if ($lastrow < $rowscount) { $self->{_buttons}{$list . "bottom"} = 1; $self->{_buttons}{$list . "next"} = 1;}
		if ($lastrow > $maxlistdisplay) { $self->{_buttons}{$list . "top"} = 1; $self->{_buttons}{$list . "prev"} = 1; }
	}
}

sub _getcheckfields {
	my $self = shift;
	my $cgi = shift;
	my $checkfields = shift;

	$self->{_checkfields} = $checkfields;
	foreach my $fld (@{$checkfields}) {
		$self->_datavar($fld->{fName}, $cgi->param($fld->{fName}));
	}
}

sub _getmyfields {
	my $self = shift;

	my $checkfields = $self->{_checkfields};
	my $ret = {};
	my $fld;
	foreach $fld (@{$checkfields}) { $ret->{$fld->{fName}} = $self->_datavar($fld->{fName}); }
	$ret->{currentuser} = $self->_hiddenvar("_userid");
	return $ret;
}

sub _getobjectids {
	my $self = shift;
	my @objectids = @_;

	my $dbh = $self->{_system}{_dbh};

#	my %fields;
#	my $count = 0;
#
#	foreach my $field (@_) {
#		if ($self->_datavar($field)) {
#			push @objectids, $self->_datavar("$field");
#			$fields{$self->_datavar("$field")} = $field;
#			$count++}
#	}

	return undef unless ($#objectids >= 0);

	my $query = $dbh->newquery( { id => \@objectids, } );
	$query->sobject();

	return ($dbh->hexecfetchall($query));
}

sub _getmyobjectids {
	my $self = shift;
	my $dbh = $self->{_system}{_dbh};

	my @objectids;
	my %fields;
	my $count = 0;

	foreach my $field (@_) {
		if ($self->_datavar($field)) {
			push @objectids, $self->_datavar($field);
			$fields{$self->_datavar($field)} = $field;
			$count++;
		}
	}

	return undef unless ($count);

	my $query = $dbh->newquery( { id => \@objectids, } );
	$query->sobject();

	my $rows = $dbh->hexecfetchall($query);

	foreach my $row (@{$rows}) { $self->_datavar($fields{$row->{id}} . "_name", $row->{name}); }

	$rows;
}

sub _getenvvars {
	my $self = shift;
	my $dbh = shift;

	my $objectid = shift;

	unless ($objectid) {
		$objectid = $self->_datavar("object_id");
	}

	my $query = $dbh->newquery({object_id => $objectid});
	$query->sgetmyenvvars();
	

	return $dbh->hexecfetchall($query);
}

sub _getmyenvvars {
	shift->_getenvvars(@_);
}

sub _updateenvvars {
	my $self =shift;
	my $dbh = $self->{_system}{_dbh};
	my $cgi = $self->{_system}{_cgi};

	my $varname;
	my $varvalues = [];

	my $i = 0;
	while ($varname = $cgi->param("varname$i")) {
		push @$varvalues, { varname => $varname, varvalue => $cgi->param("varvalue$i"), vartype => $cgi->param("vartype$i")|| "env" };
		$i++;
	}
	$dbh->updateenvvars($self->_datavar("object_id"), $varvalues);
}

sub _getattributes {
	my $self = shift;
	my $dbh = shift;

	my $attrdef = shift;

	unless ($attrdef) {
		$attrdef->{object_id} = $self->_datavar("object_id");
		$attrdef->{objtype} = $self->_datavar("type");
		if ($attrdef->{objtype} eq "flow") { $attrdef->{attrobjtype} = $self->_datavar("flowtype"); }
		else { $attrdef->{attrobjtype} = $attrdef->{objtype}; }
		if ($attrdef->{attrobjtype} eq "simple") { $attrdef->{attrobjtype} = $attrdef->{objtype}; }
		$attrdef->{protocolid} = $self->_datavar("protocolid");
		$attrdef->{driverid} = $self->_datavar("driverid");
	}

	$dbh->getmyattributes($attrdef);
}

sub _getmyattributes {
	my $self = shift;
	$self->{_attributeslist} = $self->_getattributes(@_);
=cut
	my $dbh = shift;

	my $attrdef = shift;

	unless ($attrdef) {
		$attrdef->{object_id} = $self->_datavar("object_id");
		$attrdef->{objtype} = $self->_datavar("type");
		$attrdef->{protocolid} = $self->_datavar("protocolid");
		$attrdef->{driverid} = $self->_datavar("driverid");
	}

	$self->{_attributeslist} = $dbh->getmyattributes($attrdef);
=cut
}

sub _updateattributes {
	my $self =shift;
	my $dbh = $self->{_system}{_dbh};
	my $cgi = $self->{_system}{_cgi};

	my $attrdefid;
	my $attrvalues = {};
	my $attrval;                                                                                                                          

	my $i = 0;
#	while ($attrdefid = $cgi->param("attrdefid$i")) { $attrvalues->{$attrdefid} = $cgi->param("attrvalue$i"); $i++}
	while ($attrdefid = $cgi->param("attrdefid$i")) {
		$attrval = $cgi->param("attrvalue$i");
		$attrvalues->{$attrdefid} = $attrval if ($attrval || (length($attrval) > 0));
		$i++
	}
	$dbh->updateattributes($self->_datavar("object_id"), $attrvalues);
}

sub _translate {
	my $self = shift;
	my $phrase = shift;

	my $ret;

	eval {
		$ret = $self->{_system}->{_translate}->translate($phrase);
	};
	if ($@) { $ret = $phrase; }
	return $ret
}

sub checkquotes {
	my $self = shift;
	my $p = shift;

	$p =~ s/"/&quot;/g;
	$p =~ s/'/&squot;/g;

	$p
}

sub totextarea {
	my $self = shift;
	my $p = shift;

	$p =~ s/\r\n/\n/g;
	$p =~ s/\r/\n/g;
	$p =~ s/\n/<BR>/g;
	$p;
}

sub nltobr {
	my $self = shift;
	my $p = shift;

	$p =~ s/\r\n/\n/g;
	$p =~ s/\r/\n/g;
	$p =~ s/\n/<BR>/g;

	$p
}

#Flow and subflow

sub getmymapping {
	my $self = shift;
	my $subflow_id = shift;
	my $cgi = shift;
	my $dbh = shift;

	my @mapping;
	my $scriptid;
	for (my $i = 0; my $outgofield_id = $cgi->param("outgofield_id_$i"); $i++) {
		my $formula = $cgi->param("formula_$i");
		my $parsedformula = cafUtils->parseformula($formula);
		push @mapping, {
			subflow_id => $subflow_id,
			outgofield_id => $outgofield_id,
			incomfield_id => $cgi->param("incomfield_id_$i") || 0,
			script_id => $cgi->param("script_id_$i"),
			formula => $formula,
			pformula => $parsedformula->{text},
		};
	}
	if ($#mapping >= 0) { return \@mapping; }
	else { return undef; }
}

sub getmyconnectors {
	my $self = shift;
	my $objectid = shift;
	my $cgi = shift;
	my $dbh = shift;

	my @connectors;
	my $connectorid;
	my $i;
	for ($i = 0; my $connectorid = $cgi->param("child_id_$i"); $i++) {
		push @connectors, { parent_id => $objectid, child_id => $connectorid };
	}
	$i += 2;
	for (; my $connectorid = $cgi->param("child_id_$i"); $i++) {
		push @connectors, { parent_id => $objectid, child_id => $connectorid };
	}
	if ($#connectors >= 0) { return \@connectors; }
	else { return undef; }
}

sub getmyscripts {
	my $self = shift;
	my $objectid = shift;
	my $cgi = shift;
	my $dbh = shift;

	my @scripts;
	my $scriptid;
	for (my $i = 0; my $step = $cgi->param("step_$i"); $i++) {
		next unless ($scriptid = $cgi->param("script_id_$i"));
		push @scripts, {step => $step, object_id => $objectid, script_id => $scriptid, usedfor => $cgi->param("usedfor_$i") };
	}
	if ($#scripts >= 0) { return \@scripts; }
	else { return undef; }
}

sub getmysubflows {
	my $self = shift;
	my $cgi = shift;
	
#	my @flds = qw((object_id flow_id container_id floworder flowdirection flowmethod dependant direct));

	my @incomflows;
	my @outgoflows;
	my $containerid;
	my $subflows;
	
	for (my $i = 0;  $containerid = $cgi->param("i" . "container_id_$i"); $i++) {
		push @incomflows, {
			object_id       => $cgi->param("i" . "object_id_$i"),
			name            => $cgi->param("i" . "name_$i"),
			objectlabel     => $cgi->param("i" . "objectlabel_$i"),
			type            => 'subflow',
			status          => $cgi->param("i" . "status_$i"),
			flow_id         => $cgi->param("object_id"),
			parent_id       => $cgi->param("object_id"),
			container_id    => $containerid,
			floworder       => $cgi->param("i" . "floworder_$i"),
			flowdirection   => 'incom',
			flowmethod      => $cgi->param("i" . "flowmethod_$i"),
			dependant       => $cgi->param("i" . "dependant_$i"),
			direct          => $cgi->param("i" . "direct_$i"),
			onoutgoerr      => $cgi->param("i" . "onoutgoerr_$i"),
			keepalive       => $cgi->param("i" . "keepalive_$i") || 'no',
			mailonerr       => $cgi->param("i" . "mailonerr_$i"),
			mailonsucc      => $cgi->param("i" . "mailonsucc_$i"),
			currentuser     => $self->_hiddenvar("_userid"),
			
		};

	}

	for (my $i = 0;  $containerid = $cgi->param("o" . "container_id_$i"); $i++) {
		push @outgoflows, {
			object_id       => $cgi->param("o" . "object_id_$i"),
			name            => $cgi->param("o" . "name_$i"),
			objectlabel     => $cgi->param("o" . "objectlabel_$i"),
			type            => 'subflow',
			status          => $cgi->param("o" . "status_$i"),
			flow_id         => $cgi->param("object_id"),
			parent_id       => $cgi->param("object_id"),
			container_id    => $containerid,
			floworder       => $cgi->param("o" . "floworder_$i"),
			flowdirection   => 'outgo',
			flowmethod      => $cgi->param("o" . "flowmethod_$i"),
			dependant       => $cgi->param("o" . "dependant_$i"),
			direct          => $cgi->param("o" . "direct_$i"),
			onoutgoerr      => $cgi->param("o" . "onoutgoerr_$i") || 'default',
			keepalive       => $cgi->param("o" . "keepalive_$i") || 'no',
			mailonerr       => $cgi->param("o" . "mailonerr_$i"),
			mailonsucc      => $cgi->param("o" . "mailonsucc_$i"),
			currentuser     => $self->_hiddenvar("_userid"),
		};
	}

	if ($#incomflows >= 0) { $subflows->{incom} = \@incomflows; }
	if ($#outgoflows >= 0) { $subflows->{outgo} = \@outgoflows; }

	if (($#incomflows >= 0) or ($#outgoflows >= 0)) { return $subflows; }
	return undef;
}

#Import functions 

sub initImportVars {
	my $self = shift;
	my $dbh = shift;
	my $connector = shift;
	my $container = shift;

	my $query = $dbh->newquery({object_id => $connector->{userid}});
	$query->suserslist();
	my $userid = $dbh->hexecfetchrownop($query, 1);
	$query = $dbh->newquery({object_id => $connector->{parent_id}});
	$query->sserverlist();
	my $server = $dbh->hexecfetchrownop($query, 1);

	my $db = { connector => $connector, user => $userid, _ATTRS => {}, server => $server};

	# Get connectors attributes
	my $attrlist = $self->_getmyattributes($dbh); # connector attributes
	
	foreach my $attr (@$attrlist) {
#		$self->_datavar($attr->{attrdefid}, $attr->{attrvalue});
		$db->{_ATTRS}{$attr->{attrdefid}} = $attr->{attrvalue};
	}

	#Get containers attributes
	if ($container->{object_id}) {
		my $contattrscriteria = { object_id => $container->{object_id},
			objtype => 'container',
			protocolid => $connector->{protocolid},
			driverid => $connector->{driverid}
		};

		my $containerattrs =  $self->_getattributes($dbh, $contattrscriteria);
	
		foreach my $attr (@$containerattrs) {
#		$self->_datavar($attr->{attrdefid}, $attr->{attrvalue});
			$db->{_ATTRS}{$attr->{attrdefid}} = $attr->{attrvalue};
		}
	}

	return $db;
}

sub listExternalContainers {
	my $self = shift;
	my $db = shift;
	my $conf = shift;
	my $connector = shift;
	my $container = shift;

	#Get the field list
#	my $db = $self->initImportVars($dbh, $connector);
	$db->{_FLOWDIR} = $conf->flowdir();
	my $drvclass = "caf$connector->{driverid}";
=cut
	eval "require connectors::$drvclass"; #load connectordriver/protocol;

	if ($@) {
		cafDbg->pusherror("30001; Error while loading connectors::$drvclass : $@");
		return undef;
	}
=cut

	my $drv = refDBI->ExtConnect($db);
	my $extcontainer;
	eval { $extcontainer = $drv->listtables(undef, $container->{ externalname }); };

	if ($@) {
		cafDbg->pusherror("30001; Error while calling listtable connectors::$drvclass for $container->{ externalname } : $@");
		die $@;
	}

	return wantarray ? ($extcontainer, $drv) : $extcontainer;
}

sub describeContainer {
	my $self = shift;
	my $dbh = shift;
	my $conf = shift;
	my $connector = shift;
	my $container = shift;

	#Get the field list
	my $query;
	my $db = $self->initImportVars($dbh, $connector, $container);
	my ($extcontainer, $drv) = $self->listExternalContainers($db, $conf, $connector, $container);

	my $describe_list;
	eval {
		$describe_list = $drv->describe($container->{ externalname }, $container->{ externalschema }, $container->{ externaltype });
	};

	if ($@) {
		cafDbg->pusherror("30001; Error while calling  describe $drv for $container->{ externalname } : $@");
	}
	my $pos = 0;
	foreach my $fld (@{$describe_list}) {
		$fld->{ name } =~ s/[^[:alnum:]]/_/g;
		$fld->{ name } = "Unnamed____" unless ($fld->{ name });
		$fld->{ name } = "A_" . $fld->{ name } unless ($fld->{ name } =~ /^[[:alpha:]]/);
		$fld->{type} = 'field';
		$fld->{comments} = $fld->{Remarks};
		$fld->{localfield} = 'no';
		$fld->{fieldpos} = $pos unless(defined($fld->{fieldpos}));
		$fld->{fieldorder} = ($pos + 1) * 10 unless(defined($fld->{fieldorder}));
		$pos++;
		$fld->{status} = 'online';
		$fld->{currentuser} = $self->_hiddenvar("_userid");
	}
	if ($container->{object_id}) {
		foreach my $fld (@{$describe_list}) {
			$query = $dbh->newquery({ name => $fld->{externalname}, parent_id => $container->{object_id} });
			$query->sfieldlist();
			my $fld_oid = $dbh->hexecfetchrownop($query);
			if ($fld_oid) {
				$fld->{object_id} = $fld_oid->{object_id};
				$fld->{name} = $fld_oid->{name};
				if ($fld_oid->{comments}) {
					$fld->{Remarks} = "$fld_oid->{comments}";
				}
				$fld->{objectlabel} = $fld_oid->{objectlabel} if ($fld_oid->{objectlabel});
				$fld->{dataformat} = $fld_oid->{dataformat};
				$fld->{staus} = $fld_oid->{staus} if ($fld_oid->{staus});
				$fld->{fieldorder} = $fld_oid->{fieldorder} if ($fld_oid->{fieldorder});
			}
		}
	}
	return $describe_list;
}

sub getSelectedContainer {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;

	my $container;
	my $containerid;
	my $query;
	if ($containerid = $cgi->param("_selectedoid")) {
		$query = $dbh->newquery({ object_id => $containerid });
		$query->scontainerlist();
		$container = $dbh->hexecfetchrownop($query, 1);
	}
	$container->{ name } = $cgi->param("_selectedname");
	$container->{ name } =~ s/[^[:alnum:]]/_/g;
	$container->{ name } = "Unnamed____" unless ($container->{ name });
	$container->{ name } = "A_" . $container->{ name } unless ($container->{ name } =~ /^[[:alpha:]]/);
	$container->{ externalname } = $cgi->param("_selectedexternalname");
	$container->{ externalschema } = $cgi->param("_selectedowner");
	$container->{ externaltype } = $cgi->param("_selectedtype");
	$container->{ flowdirection } = "inout";
	$container->{ type } = "container";
	$container->{ status } = "online";
	$container->{ remarks } = $cgi->param("_selectedremarks");
	$container->{ comments } = $cgi->param("_selectedremarks");
	$self->{_container} = $container;
}

sub getContainerData {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;

	my $container = {
		object_id       => $cgi->param("containerid"),
		name            => $cgi->param("containername"),
		externalname    => $cgi->param("containerexternalname"),
		remarks         => $cgi->param("containerremarks"),
		schema          => $cgi->param("containerowner"),
		externaltype    => $cgi->param("containertype"),
		type            => 'container',
		flowdirection   => 'inout',
		status          => 'online',
		currentuser     => $self->_hiddenvar("_userid"),
	};
	if ($container->{object_id}) {
		my $query = $dbh->newquery({object_id => $container->{object_id}});
		$query->scontainerlist();
		my $initialcontainer = $dbh->hexecfetchrownop($query);
		$initialcontainer->{name} = $container->{name};
		$initialcontainer->{externalname} = $container->{externalname};
		$initialcontainer->{comments} = $container->{remarks};
		$initialcontainer->{currentuser} = $self->_hiddenvar("_userid");
		return $initialcontainer;
	}
	return $container;
}

sub getFieldsData {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;

	my @pagefields = qw(datalength datascale datatypeid defaultvalue fieldorder keyposition name nullable object_id remarks);
	my @fields;

	my $i = -1;
	while (1) {
		$i++;
		my $field = { externalname => $cgi->param("externalname_$i") };
		last unless $field->{externalname};
		next unless ($cgi->param("checked_$i"));
		foreach my $fname (@pagefields) {
			$field->{$fname} = $cgi->param($fname . "_$i");
		}
		$field->{comments} = $field->{remarks};
		$field->{type} = 'field';
		$field->{localfield} = 'no';
		$field->{status} = 'online';
		$field->{currentuser} = $self->_hiddenvar("_userid");
 		push @fields, $field;
	}
	return \@fields;
=cut
#		if ($updateexisting and $field->{object_id}) {
#			my $query = newquery({object_id => $field->{object_id}});
#			$query->sfieldlist();
#			my $initialfield = $dbh->hexecfetchrownop();
#			$field->{comments} = $field->{comments} }
=cut
}

sub createContainer {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $container = shift;

	$container->{object_id} = $dbh->nextseq("objects");
	$container->{id} = $container->{object_id};

	my $query = $dbh->newquery($container);
	my $ret;
	$query->iobject();
        if (($ret = $dbh->executefinish($query)) > 0) {
		$query->icontainer();
		if (($ret = $dbh->executefinish($query)) > 0) {
			#$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }
 
	if ($ret and ($ret > 0)) { return $container->{object_id}; }
	else { return ($ret); }
}

sub updateContainer {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $container = shift;

	my $query = $dbh->newquery($container);
	my $ret;
	$query->uobject();
        if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ucontainer();
		if (($ret = $dbh->executefinish($query)) > 0) {
			#$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }
 
	return ($ret);
}

sub createField {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $field = shift;

	$field->{object_id} = $dbh->nextseq("objects");
	$field->{id} = $field->{object_id};

	my $query = $dbh->newquery($field);
	my $ret;
	$query->iobject();
        if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ifield();
		if (($ret = $dbh->executefinish($query)) > 0) {
			#$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }
 
	return ($ret);
}

sub updateField {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $field = shift;

	$field->{type} = 'field';
	my $query = $dbh->newquery($field);
	my $ret;
	$query->uobject();
        if (($ret = $dbh->executefinish($query)) > 0) {
		$query->ufield();
		if (($ret = $dbh->executefinish($query)) > 0) {
			#$dbh->commit();
		}
		else { $dbh->rollback(); }
	}
	else { $dbh->rollback(); }
 
	return ($ret);
	
}

sub checkredirect {
	my $self = shift;
	if (my $otherpage = $self->{_system}{_redirect}) {
		eval "require $otherpage";
		die "$@" if ($@);
		my $otherattrs = {};
		$otherattrs->{_system} = $self->{_system};
		$otherattrs->{_hidden} = $self->{_hidden};
		$otherattrs->{currentuser} = $self->{currentuser};
		$otherattrs->{_hidden}{_currpage}    = $otherpage;
		$otherattrs->{_hidden}{_curraction}  = "search";
		$otherattrs->{_hidden}{_actiondetail}  = "search";
		$otherattrs->{_debug} = $self->{_debug};
		my $other = $otherpage->new($otherattrs);
		$other->_hiddenvar("_currpage", $otherpage);
		$other->_hiddenvar("_curraction", "search");
		$other->_hiddenvar("_actiondetail", "search");
		eval { $other->startpage(); };
		if ($@ and (cafDbg->geterrorn() < 0)) {
			cafDbg->pusherror("Error while executing startpae " . $@);
		}
		$other->displaypage();
	}
	else { $self->displaypage(); }
}

# Connection page
package conPage;

@conPage::ISA = ("cafPage");

sub startpage {
	my $self = shift;
	$self->_systemvar("_userid", $self->_hiddenvar("_userid")) unless ($self->_datavar("_userid"));
	$self->deletevar ("_hidden", "_userid");
	$self->deletevar ("_hidden", "_sessionid");
	$self->_hiddenvar ("_pagetype", "CONNECT");

	$self->_hiddenvar ("_curraction", undef);
	$self->_hiddenvar ("_actiondetail", undef);
}

package mainPage;

@mainPage::ISA = ("cafPage");

sub startpage {
	my $self = shift;
#	$self->_datavar("_userid", $self->_hiddenvar("_userid")) unless ($self->_datavar("_userid"));
	$self->_hiddenvar ("_pagetype", "NORMAL");

	$self->_hiddenvar ("_curraction", undef);
	$self->_hiddenvar ("_actiondetail", undef);
}

1;
