#!/usr/local/bin/perl
#
# initialdb.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package geninitialdb;


	
	my @seqs = ();
	my @rseqs = ();
	my @qseqs = ();
	my @tables = ();
	my @rtables = ();
	my @qtables = ();

sub processlisttables {
	open DBCONTENT, "<listtables.txt";
	while (<DBCONTENT>) {
		chomp;
		my @line = split (/	/);
		if ($line[1] eq "seq") {
			if (($line[0] eq "RQ") or ($line[0] eq "REF")) { push @rseqs, $line[2]; }
			elsif (($line[0] eq "RQ") or ($line[0] eq "QUEUE")) { push @rseqs, $line[2]; }
			push @seqs, $line[2];
		}
		if ($line[1] eq "table") {
			if (($line[0] eq "RQ") or ($line[0] eq "REF")) { push @rtables, $line[2]; }
			elsif (($line[0] eq "RQ") or ($line[0] eq "QUEUE")) { push @qtables, $line[2]; }
			push @tables, $line[2];
		}
	}
	
	close DBCONTENT;
}

sub geninitialdb {
	processlisttables();
	my $dumpopt = "--attribute-inserts --no-quotes --no-owner --no-reconnect --schema-only --no-acl";
	foreach my $obj (@seqs, @tables) {
		unlink ("$obj.sql");
		system ("pg_dump $dumpopt --table=$obj --file=$obj.sql cafeterraq");
		unless (-f "$obj.sql") {
			system ("pg_dump $dumpopt --table=$obj --file=$obj.sql cafeterra");
		}
	}
	
}


sub initializedb {
	my @args = @ARGV;
	print join(" - ", @args), "\n";
}

sub Question {
	my ($question, $answer) = (shift, shift);

	print "$question [$answer] : ";
	my $ans = <STDIN>;
	chomp $ans;
	return $answer unless ($ans);
	return $ans;
}

sub YesNo {
	my ($question, $answer) = (shift, shift);
	while (1) {
		my $ans = Question($question . " (YES/NO)", $answer);
		$ans = uc($ans);
		if (($ans eq "YES") or ($ans eq "Y")) { return "yes"; }
		elsif (($ans eq "NO") or ($ans eq "N")) { return "no"; }
		print "\n";
	}
}

sub Usage {
	die "Usage initialize install {Q|R} dbname aliphepw [contextid]\n";
}

if ($ARGV[0] eq "install") {
	if ($#ARGV < 1) {
		Usage ();
	}

	my $mode = uc($ARGV[1]);

	my $dwd;
	my $dbdsn;
	my $dbname = "cafeterra";
	my $dbuser = "aliphe";
	my $dbpw = "aliphe";
	my $contextid = ($mode eq "Q") ? "default" : "";

	use Cwd;
	my $cwd = Cwd::getcwd();
	chdir "..";
	my $dwd = Cwd::getcwd();
	chdir ($cwd);
	$dwd = Question("Cafeterra Programs Directory", $dwd);

	if ($mode eq "Q") { $dbname = "cafeterraq"; }
	$dbname = Question("Database Name", $dbname);

	$dbuser = Question("User Name", $dbuser);

	$dbpw = Question("User Password", $dbpw);

	$dbdsn = "dbi:Pg:dbname=$dbname;host=localhost;port=5432";
	$dbdsn = Question("DBI DSN", $dbdsn);

	if ($mode eq "Q") { $contextid = Question("Context Id", $contextid); }

	my $createdb = YesNo("Create Database", "no");

	my $installperlmod = YesNo("Install Necessary Perl Modules", "no");

	if ($createdb eq "yes") {
		system("createuser --createdb --adduser --pwprompt $dbuser");
		system("createdb --encoding=UNICODE --username=$dbuser $dbname");
	}


	my $confdir = ($mode eq "Q") ? $contextid : "cgi";

	my $readmode = $/;
	open IN, "<conf.pm.tpl";
	undef $/;
	my $content = <IN>;
	close IN;
	$content =~ s/my \$refdsn = "dbi:Pg:dbname=cafeterraq;host=localhost;port=5432";/my \$refdsn = "$dbdsn";/;
	$content =~ s/my \$refuser = "aliphe";/my \$refuser = "$dbuser";/;
	$content =~ s/my \$refpass = "aliphe";/my \$refpass = "$dbpw";/;
	$content =~ s/my \$basedir    = "\/home\/app\/cafeterra";/my \$basedir = "$dwd";/;
	$content =~ s/my \$contextid  = "default";/my \$contextid = "$contextid";/;
	open OUT, ">$confdir/conf.pm";
	print OUT $content;
	close OUT;

	open IN, "<index.pm.tpl";
	$content = <IN>;
	close IN;

	$content =~ s/use default::conf;/use $confdir::conf;/;
	$content =~ s/CTXTCFG/conf/g if ($mode eq "R");

	open OUT, ">$confdir/index.pm";
	print OUT $content;
	close OUT;

	processlisttables();
	my @listobjs;
	if ($mode eq "Q") { @listobjs = (@qseqs, @qtables)); }
	elsif ($mode eq "R") { @listobjs = (@rseqs, @rtables)); }
	foreach my $obj (@listobjs) {
		system("psql -f $obj.sql -q -d $ARGV[1] -U aliphe");
	}
	foreach my $dfile (qw(d_cafusers d_context d_attrdef d_driver d_protocol d_datatype)) {
		system("psql -f $dfile.sql -q -d $ARGV[1] -U aliphe");
	}

	if ($installperlmod eq "yes") {
		system("perl -MCPAN -e 'install MyBundle.pm");
		system("perl -MCPAN -e 'install MyBundle.pm");
		system("perl -MCPAN -e 'install MyBundle.pm");
	}
}
elsif ($ARGV[0] eq "generate") {
	geninitialdb();
}
else { Usage(); }

