function finddiff {
	dir1=$1
	dir=$2
	file=$3
	pat=$4
	exclude=$5
	if [ -d $file ] ; then
		for f in $file/*; do
			n=`basename $f`
			[ "$n" == "CVS" ] && n='*'
			[ "$n" != '*' ] && finddiff $dir1 $dir $f "$pat" "$exclude"
		done
	else 
		doit=0
		if [ ! -z "$pat" ] ; then
			echo $file | egrep "$pat" >/dev/null 2>&1
			[ $? -eq 0 ] && doit=1
		fi
		if [ ! -z "$exclude" ] && [ $doit -eq 1 ]; then
			echo $file | egrep "$exclude" > /dev/null 2>&1
			[ $? -eq 0 ] && doit=0
		fi
#		if [ -f $dir/$file ]; then
#			echo "HEHE $doit -eq 1 -a -f $dir/$file"
#		else 
#			echo "HOHO $doit -eq 1 -a -f $dir/$file ($PWD)"
#		fi
		if [ $doit -eq 1 -a -f $dir/$file ] ; then
			diff -q $file $dir/$file
			if [ $? -ne 0 ] ; then
				ls -l $dir1/$file $dir/$file
				if [ $f -nt $dir/$file ] ; then
					echo SUGGEST /bin/cp -f $dir1/$f $dir/$file
				else
					echo MAYBE /bin/cp -f $dir/$file $dir1/$f
				fi
			fi
		else
			if [ $doit -eq 1 ]; then
				echo "$dir/$file does not exists"
				echo SUGGEST /bin/cp -f $dir1/$f $dir/$file
			fi
		fi
	fi
}

argcnt=$#
if [ $argcnt -lt 2 ] || [ ! -d $1 ] || [ ! -d $2 ] ; then
	echo "Usage $0 dir1 dir2 [pattern [exclude]]";
else
	dir1=$1
	dir2=$2
	pat=$3
	dir1=`echo $dir1 | sed "s/\/$//"`
	dir2=`echo $dir2 | sed "s/\/$//"`
	exclude=$4
	[ -z "$pat" ] && pat='\.p[lm]$|\.tpl$'

	cd $dir1
	echo "

Now in $dir1
====================================
"
	for f in * ; do
		n=`basename $f`
		[ "$n" == "CVS" ] && n='*'
		[ "$n" != '*' ] && finddiff $dir1 $dir2 $f "$pat" "$exclude"
#		finddiff $dir1 $dir2 $f "$pat" "$exclude" 
	done

#	cd $dir2
#	echo "

#Now in $dir2
#====================================
#"
#
#	for f in * ; do
#		finddiff $dir2 $dir1 $f '\.p[lm]$'
#	done
fi
