#!/usr/local/bin/perl
#
# cafPg 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdGeneric;
 
@ISA = ("refDBI");
use strict;

use DBI;

sub NewConnection {
	my $class = shift;
	$class = ref($class) || $class;
	my $db = shift;

	my $dbh;

	my $dbdsn = $db->{dbidsn} || $db->{connector}{dbidsn};

	unless ($dbdsn) {
		die "Unknown Database You must supply the dbidsn for this Driver";
	}

#	print STDERR "connecting to $dbdsn with $db->{user}{username}, $db->{user}{password} AutoCommit => $db->{_ATTRS}{AutoCommit}, RaiseError => $db->{_ATTRS}{RaiseError}, PrintError => $db->{_ATTRS}{PrintError} ";
	my $drvAttrs = { AutoCommit => $db->{_ATTRS}{AutoCommit}, RaiseError => $db->{_ATTRS}{RaiseError}, PrintError => $db->{_ATTRS}{PrintError} };
	my $otherAttrs = eval $db->{_ATTRS}{GENERIC_OTHERS} if ($db->{_ATTRS}{GENERIC_OTHERS});
	$otherAttrs = {} unless ($otherAttrs);

	foreach my $attr (keys %$otherAttrs) { $drvAttrs->{$attr} = $otherAttrs->{$attr} }

	eval {
		$dbh = DBI->connect($dbdsn, $db->{user}{username}, $db->{user}{password}, $drvAttrs); #$db->{_ATTRS});
	};

	die "cafdGeneric->connect $dbdsn : $@" . join(" - ", %$db) if ($@ || (! $dbh));

	$db->{dbidsn} = $dbdsn;
	my $self = { dbh => $dbh, db => $db, };

	bless $self, $class;
}

sub generatechartodate {
	my $self = shift;
	my $col = shift;
 
	return ":c_$col->{name}";
}
 
sub generatedatetochar {
	my $self = shift;
	my $col = shift;
 
	return $col->{externalname};
}

sub sysdatefunc {
	return ("now()");
}

sub todatefunc {
	return ("to_timestamp");
}

1;
