#!/usr/local/bin/perl
#
# cafProto 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafProto;
 
@ISA = (refDBI);
use Cwd;
use File::stat;
use File::Temp;
use IO::File;
use IO::Handle;
use IO::Scalar;
use Fcntl ':mode'; 
use strict;



=cut
	_tempdir => Flowdir/temp
	_mailqueue => FLOWDIR/_mailq
	_smtpqueue => FLOWDIR/_smtpq
	_imapqueue => FLOWDIR/_imapq/folder
	_ftpqueue  => FLOWDIR/_ftpq
=cut

sub NewProtocol {
	my $class = shift;
	my $db = shift;

	$class = ref($class) || $class;

	my $self = { _CWD => Cwd::getcwd(), _FLOWDIR => $db->{_FLOWDIR}, _DIR => $db->{_ATTRS}{DIRECTORY}, db => $db };
#	print "<BR>$self->{_FLOWDIR}, $self->{_DIR}\n";

	bless $self, $class;

	$self->_init();

	$self;
}

sub gettemporaryfile {
	my $self = shift;
	my $suffix = shift || ".tmp";
	my $open = shift; # undef | ioh | fh
	my $binmode = shift;
	my $tempdir = shift || "tmp";

	my $class = ref($self);

	my ($fh, $fn);
	my $cwd = Cwd->getcwd();
	chdir  $self->{_FLOWDIR};
	mkdir $tempdir unless ($tempdir);
	chdir $tempdir;
	eval {
		($fh, $fn) = File::Temp::tempfile(DIR=> Cwd->getcwd(), UNLINK => 0, SUFFIX => $suffix || ".tmp");
	};
	if ($@) { my $e = $@; chdir $cwd; cafDbg->pushstackdump(1); die "$class : gettempfile failed $e"; }

	chdir $cwd;

	if ($open && $binmode) { binmode($fh); }
	if ($open eq 'fh') { return ($fh, $fn); }
	elsif ($open eq 'ioh') { return (IO::Handle->new_from_fd(fileno($fh), "w"), $fn); }
	else { close $fh; return $fn; }
}

sub protocommit {
	my $self = shift;
	my $sourcefile = shift;
	my $destfile = shift;

	
	my $cwd = Cwd->getcwd();
	chdir  $self->_dir();

	my ($sioh, $dioh);

	$sioh = IO::File->new($sourcefile, "r");
	$dioh = IO::File->new($destfile, "w");

	chdir $cwd;

	binmode $sioh;
	binmode $dioh;

	my $nreads;
	my $nwrite = 0;
	my $in;
	while ($nreads = $sioh->read($in, 1024)) { $nwrite = $dioh->write($in, $nreads); }
	close $sioh;
	close $dioh;

}

sub protorollback {
        my $self = shift;
        my $tempf = shift;
 
        unlink ($tempf) if ($tempf and (-f $tempf));
}

sub _dir {
        my $self = shift;
 
        if (@_) { $self->{_DIR} = shift; }
        $self->{_DIR};
}

sub listtables {
	my $self = shift;
	my $dir = shift || $self->_dir();
	my $pattern = shift;

	my $dieerror = undef;
	my $cwd = Cwd::getcwd();
	chdir $dir ? $dir : $cwd;

	$pattern =~ s/%/.*/g;
	$pattern =~ s/_/./g;

	my @rows;
	my $i = -1;
	if (opendir(DIRH, ".")) {
		my @files = readdir(DIRH);
		foreach my $file (@files) {
			if ($file =~ /$pattern/) {
				my $sf = stat ($file);
				my $mode;
				{
					no strict 'subs';
					$mode = $sf->mode & S_IFREG;
				}
				if ($mode) {
					my $uid = $sf->uid;
					my $usrn;
					eval { $usrn = getpwuid($uid); };
					$! = "";
					$usrn = $uid unless $usrn;
					$i++;
					my $remarks = "Created on : " . cafUtils->datetime1($sf->ctime); # creation date
					$remarks .= " / Last modified on " . cafUtils->datetime1($sf->mtime); # Modif Time
					$remarks .= " / File Size " . $sf->size; # Table Size
					$rows[$i] = {
						externalname => $file, #Table Name
						name       => $file,
						Type       => "FILE", # Table Type
						Owner      => $usrn, 
						Remarks    => $remarks
					}
				}
			}
		}
	}
	else { eval { cafDbg->pushstackdump(1); }; $dieerror = "20001;" . ref($self) . "::listtable can't open directory $dir"; }
	
	chdir $cwd;
	if ($dieerror) { die $dieerror; }
	if ($#rows > -1) { return (\@rows); }
	return (undef);

}

sub describe {
	my $self = shift;
	my $class = ref($self);
	return [
		{		name          => "col",
				externalname  => "col0",
				datatypeid    => 'VARCHAR',
				datalength    => 100,
				fieldorder    => 10,
				Remarks       => "Generated by $class",
				keyposition   => 1,
		}
	];
}

sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return $col->{externalname};
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{externalname};
}
		
sub generateselect {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#select statement generated by $class\n\nSELECT ";
	my $sep = "";
	my $where = "WHERE ";
	my $chunk;
	my $wsep = "";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		next unless ($col->{status} eq "online");
		$chunk = "$sep" . generatedatetochar($col) . "\@$col->{name}";
		$query .= $chunk;
		$sep = ", ";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\tfrom $container->{externalname}\n\t$where";
}

sub generateupdate {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#update statement generated by $class\n\nUPDATE $container->{externalname} set ";
	my $sep = "";
	my $where = " WHERE ";
	my $chunk;
	my $wsep = "";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		next unless ($col->{status} eq "online");
		$chunk = "$sep$col->{externalname} = " . generatechartodate($col);
		$query .= $chunk;
		$sep = ", ";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\t$where";
}

sub generatedelete {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#delete statement generated by $class\n\nDELETE from $container->{externalname}";
	my $sep = "";
	my $where = "WHERE ";
	my $chunk;
	my $wsep = "";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		next unless ($col->{status} eq "online");

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\t$where";
}

sub generateinsert {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#insert statement generated by $class\n\nINSERT INTO $container->{externalname} (";
	my $sep = "";
	my $values = " VALUES ( ";
	my $chunk;
	my $vsep = "";
	my $qlen = 0;
	my $vlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		next unless ($col->{status} eq "online");
		$chunk = "$sep$col->{externalname}";
		$query .= $chunk;
		$sep = ", ";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		if ($col->{keyposition}) {
			$chunk = "$vsep:c_$col->{name}";
			$values .= $chunk;
			$vlen += length($chunk);
			if ($vlen > 50) { $values .= "\n\t\t"; $vlen = 10; }
			$vsep = ", ";
		}
	}

	return "$query\n\t$values";
}


sub generatecreate {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;
	my $class = ref($self) || $self;

	my %datatypeconv = map { $_{stdname} => $_{datatypeid} } @$datatypes;

	my $query = "#THIS COMMAND IS NOT SUPPORTED IN THIS CONTEXT
#CREATE TABLE statement generated by $class\n\nCREATE TABLE $container->{externalname} (";

	return "$query";
}

sub generatedrop {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;
	my $class = ref($self) || $self;

	my $query = "#THIS COMMAND IS NOT SUPPORTED IN THIS CONTEXT
#DROP TABLE statement generated by $class

DROP TABLE $container->{externalname}";
	return $query;
}

sub generatetruncate {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;
	my $class = ref($self) || $self;

	my $query = "#THIS COMMAND IS NOT SUPPORTED IN THIS CONTEXT
#TRUNCATE TABLE statement generated by $class

TRUNCATE TABLE $container->{externalname}";
	return $query;
}

sub generatequery {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $datatypes = shift;

	my $sub = "generate$command";
	return $self->$sub($connector, $container, $fields, $datatypes);
}

sub protodisconnect {
	1;
}

=For Net::UserAgent credentials

sub get_basic_credentials
{
	my($self, $realm, $uri) = @_;
	return ($self->{db}->{_userid}{username}, $self->{db}->{_userid}{password});
}

sub GetTableKinds {
	return undef;
}

1;
