#!/usr/local/bin/perl
#
# cafpFTP 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafpFTP;
 
use connectors::cafProto;
use Net::FTP;
@ISA = ("cafProto");
use strict;


sub _init {
	my $self = shift;

	$self->connected();
}

sub _cwd {
	my $self = shift;
	my $dir = shift;

	my $ftp = $self->{_FTPH};

	unless ($ftp->cwd($dir . "/")) {
		my $wd = $ftp->pwd();
		$wd =~ s/\/\s*$//;
		$dir =~ s/\/\s*$//;
		return undef unless (lc ($wd) eq lc ($dir));
	}
	return 1;
}
	

sub connected {
	my $self = shift;
	my $class = ref($self);

	my $ftp = $self->{_FTPH};

	return $self if($ftp && $ftp->pwd());

	my $db = $self->{db};

	my %attrs;
	unless ($ftp) {
		my $server = $db->{server}{host_name} ||  $db->{server}{host_address};

		%attrs = (
			Port        => $db->{server}{port} || undef,
			Debug       => 0,
			Timeout     => $db->{attributes}{Timeout} || 900,
			Firewall    => $db->{attributes}{Firewall},
			Passive     => $db->{attributes}{Passive},
		);

		$ftp = $self->{_FTPH} = Net::FTP->new($server, %attrs) || die "$class new Net::FTP Connection - $server - Failed $@";
		$self->{_FTPATTRS} = \%attrs;
	}

	my @loginpar = ($db->{user}{username}, $db->{user}{password}, $db->{attributes}{Account});
	my $logged = $ftp->login(@loginpar) || die "$class login Net::FTP Connection Failed";

	$self->_dir($ftp->pwd()) unless ($self->_dir());
	unless($self->_cwd($self->_dir())) {
		die "$class cwd " . $self->_dir() . " Net::FTP Change working directory Failed (" . $ftp->pwd() .")\n";
	}

	return $self;
}

sub getfile {
	my $self = shift;
	my $filedesc = shift;

	my $class = ref($self);

	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $fname = $filedesc->{fname};
	my $dir = $filedesc->{dir} || $self->_dir();
	my $mode = $filedesc->{mode};

	my $ftp = $self->{_FTPH};
	my ($fh, $tempf);

	if (($mode eq 'r') || ($mode eq 'w')) {
		($fh, $tempf) = $self->gettemporaryfile(".ftp", "fh", 1, "ftp");
		my $cwd = $ftp->pwd();
		if ($dir) { $self->_cwd($dir) || die "$class openfile : cwd($dir) Failed"; }

		if ($mode eq 'r') { $ftp->get($fname, $fh); }
		close $fh;
		$self->_cwd($cwd);
		return ($tempf);
	}
	else { die "$class openfile : unsupported mode ($mode)"; }
}

sub putfile {
	my $self = shift;
	my $class = ref($self);
	my $sourcefile = shift;
	my $destfile = shift;

	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $dir = $self->_dir();

	my $ftp = $self->{_FTPH};

	$ftp->put($sourcefile, $destfile . ".tmp");
	$ftp->rename ($destfile . ".tmp", $destfile);

	1;
}

sub listtables {
	my $self = shift;
	my $dir = shift || $self->_dir();
	my $pattern = shift;
 
	my $class = ref($self);

	my $dieerror = undef;
	my $ftp = $self->{_FTPH};
	unless ($self->connected()) { die "$class listtables : Connection failed"; }
	my $cwd = $ftp->pwd();
	$self->_cwd($dir ? $dir : $cwd) || die "$class cwd($dir) Net::FTP Connection Failed";;
 
	$pattern = ".*" unless $pattern;
	$pattern =~ s/%/.*/g;
	$pattern =~ s/_/./g;
 
	my @rows;
	my $i = -1;


	my $files = $ftp->dir();

	shift @$files if ($files->[0] =~ /^\s*total/);

	foreach my $file (@$files) {
		if ($file =~ /$pattern/) {
			$i++;
			$rows[$i] = {}; #[0] = $file;

#			my @fdesc = split(" ", $file);
			my @fdesc = split(/\s+/, $file);
			my $mode = ($fdesc[0] =~ /^d/) ? 'DIRECTORY' : 'FILE';
			my $usrn = $fdesc[2];
			my $remarks = "Last Modified : $fdesc[5] $fdesc[6] $fdesc[7] / File Size : $fdesc[4]";
			my $p = join('\s*', @fdesc[0..7]);
			$p .= '\s*(.*)';
			$file =~ /$p/;
			$file = $1;
			if ($file =~ /(.*)( -> .*)$/) { $file = $1; $remarks .= " ($2)"; }

			$rows[$i] = {
				externalname => $file, #Table Name
				name         => $file,
				Type         => $mode, # Table Type
				Owner        => $usrn,
				Remarks      => $remarks,
			};
		}
	}
=over
	if (my $files = $ftp->ls()) {
		my @files = @$files;
		foreach my $file (@files) {
			if ($file =~ /$pattern/) {
				$i++;
				$rows[$i] = {}; #[0] = $file;

				my @lines = $ftp->dir($file);
				if ($lines[0]) {
					my @fdesc = split(" ", $lines[0]);
					my $mode = ($fdesc[0] =~ /^d/) ? 'DIRECTORY' : 'FILE';
					my $usrn = $fdesc[2];
					my $remarks = "Last Modified : $fdesc[5] $fdesc[6] $fdesc[7] / File Size : $fdesc[4]";
					$rows[$i] = {
						externalname => $file, #Table Name
						name         => $file,
						Type         => "FILE", # Table Type
						Owner        => $usrn,
						Remarks      => $remarks,
					};
				}
				else {$rows[$i] = {externalname => $file, name       => $file,} }
			}
		}
	}
	else { eval { cafDbg->pushstackdump(1); }; $dieerror = "20001;" . ref($self) . "::listtable can't open directory $dir"; }
=cut
 
	chdir $cwd;
	if ($dieerror) { die $dieerror; }
	if ($#rows > -1) { return (\@rows); }
	return (undef);
 
}

sub fullpath {
	my $self = shift;
	my $dir = shift;
	my $class = ref($self) || $self;

	unless ($self->connected()) { die "$class fullpath : Connection failed"; }
	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($dir ? $dir : $cwd) || die "$class cwd($dir) Net::FTP Connection Failed";
	my $currpath = $ftp->pwd();
	$self->_cwd($cwd);
	$currpath;
}

sub to_date {
	my ($m, $d, $yh) = @_;


	my ($y, $h);
	if ($yh =~ /:/) { $h = "$yh:00"; my @year = cafUtils->cafdatetime0(); $y = $year[5]; }
	else { $y = $yh; $h = "00:00:00"; }

	my $month;
	my $i = 0;
	my @months = qw((JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC));
	foreach my $mn (@months) {
		$i++;
		if (uc($m) eq $mn) { $month = $i; last; }
	}

	if (! $month) {
		$month = 1;
		@months = qw(JAN F.V MAR ARV MAI JUN JUI AO. SEP OCT NOV DEC);
		foreach my $mn (@months) {
			$i++;
			if (uc($m) =~ /^$mn/) { $month = $i; last; }
		}
	}

	$month = "0$month" if ($month < 10);

	$h = "0$h" if ($h =~ /^.:/);

	return "$d/$month/$y $h";
	
}

sub dirlisting {
	my $self = shift;
	my $dir = shift || $self->_dir();
	my $long = shift || 1;
 
	my $class = ref($self);

	my $dieerror = undef;
	unless ($self->connected()) { die "$class listtables : Connection failed"; }
	my $ftp = $self->{_FTPH};
	my $cwd = $ftp->pwd();
	$self->_cwd($dir ? $dir : $cwd) || die "$class cwd($dir) Net::FTP Connection Failed";
	my $currdir = $ftp->pwd();
 
	my @lines = $long ? $ftp->dir() : $ftp->ls();
	my @rows;
	foreach my $line (@lines) {
		my @row;
		my $ftype;
		if ($long) {
			my @fdesc = split(/\s+/, $line);
			if ($fdesc[0] =~ /^\s*d/) { $ftype = "DIR" }
			else { $ftype = "FILE" }
			
			@row = @fdesc[0..4];
			my $p = join('\s*', @fdesc[0..7]);
			$p .= '\s*(.*)';
			$line =~ /$p/;
			$row[6] = $1;

			$row[5] = to_date ($fdesc[5..7]);
			$row[7] = $ftype;
			$row[8] = $line;
			$row[9] = $dir;
		}
		else {
			if ($self->_cwd($line)) { $ftype = "DIR"; $self->_cwd($currdir); }
			else { $ftype = "FILE"; } 
			@row = (undef, undef, undef, undef, undef, $line, $ftype, $line, $dir);
		}
		push @rows, \@row;

	}
	$self->_cwd($cwd) || die "$class cwd($cwd) Net::FTP Connection Failed";;
	return \@rows;
}

sub protocommit {
	my $self = shift;
	$self->putfile(@_);
}

sub protorollback {
	my $self = shift;
	my $tempf = shift;

	unlink ($tempf) if ($tempf and (-f $tempf));
}

sub protodisconnect {
	my $self = shift;
	my $class = ref($self);

	my $ftp = $self->{_FTPH};

	if ($ftp) {
		$ftp->quit();
	}

	$self->{_FTPH} = undef;
}

sub moveexternalfile {
	my $self = shift;
	my $source = shift;
	my $dest = shift;

	my $class = ref($self);
	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($self->_dir());

	my $ret = $ftp->rename($source, $dest);
	$self->_cwd($cwd);
	$ret;
}

sub deleteexternalfile {
	my $self = shift;
	my $file = shift;

	my $class = ref($self);
	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($self->_dir());

	my $ret =  $ftp->delete($file);

	$self->_cwd($cwd);
	$ret;
}

sub renameexternalfile {
	my $self = shift;
	my $source = shift;
	my $dest = shift;

	my $class = ref($self);
	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($self->_dir());

	my $ret = $ftp->rename($source, $dest);
	$self->_cwd($cwd);
	$ret;
}

sub copyexternalfile {
	my $self = shift;
	my $direction = shift;
	my $source = shift;
	my $dest = shift;

	my $class = ref($self);
	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($self->_dir());

	my $ret = 1;
	if ($direction eq "put") { $ret = $ftp->put($source, $dest); }
	elsif ($direction eq "get") { local $! = undef; $ret = $ftp->get($source, $dest); }
	elsif ($direction eq "copy") {
		my $tempfile = $self->getfile({ name => $source, mode => "r"});
		$self->putfile($tempfile, $dest);
		unlink $tempfile;
	}

	$self->_cwd($cwd);
	$ret
}

sub createexternaldir {
	my $self = shift;
	my $dirname = shift;

	my $class = ref($self);
	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($self->_dir());

	my $ret = $ftp->mkdir($dirname);

	$self->_cwd($cwd);
	$ret
}

sub removeexternaldir {
	my $self = shift;
	my $local = shift;
	my $dirname = shift;

	my $class = ref($self);
	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	my $ftp = $self->{_FTPH};

	my $cwd = $ftp->pwd();
	$self->_cwd($self->_dir());

	my $ret = $ftp->rmdir($dirname);

	$self->_cwd($cwd);
	$ret
}

1;
