use strict;

sub getfilecontent {
	my $infile = shift;

	my $content;
	{
		open (I, $infile); #"altertables.txt");
		local $/ = undef;
		$content = <I>;
		close(I);
	}
	$content;
}
sub getalterdefs {
	my $infile = shift;
	my $content = getfilecontent($infile);
	my @commands;
	
	$content=~s/\s*\n\s*//g;
	$content =~ s/\\;/#:#:#/g;
	my @cmds = split(/;/, $content);
	
	foreach my $cmd (@cmds) {
		$cmd =~ s/#:#:#/;/g;
		$cmd =~ s/\\,/#:#:#/g;
		my @elmts = split(/,/, $cmd);
		my %command = ();
		foreach my $elt (@elmts) {
			$elt =~ s/#:#:#/,/g;
			$elt =~ s/\\=/#:#:#/g;
			my ($key, $value) = split(/=/, $elt);
			$key =~ s/#:#:#/=/g;
			$value =~ s/#:#:#/=/g;
			if ($value =~ /-/) {
				$value =~ s/\\-/#:#:#/g;
				my @v = split(/-/,$value);
				$value = \@v;
				foreach my $vv (@v) { $vv =~ s/#:#:#/-/g; }
			}
			$command{$key} = $value;
		}
		push @commands, \%command;
	}
	return { alterdefs => \@commands };
}
sub dumpobject {
	my $object = shift;
	my $varname = shift || "object";
	use Data::Dumper;
	my $dump = Data::Dumper->new([$object], [$varname]);
	$dump->Indent(1);
	my $ptext = $dump->Dump;
	print $ptext;
}

sub generateXML {
	my $object = shift;
	require XML::Simple;

	my $xs = new XML::Simple();

	my $xml = $xs->XMLout($object, NoAttr => 1);

	print $xml;
}

sub readXML {
	my $infile = shift;
	my $content = getfilecontent($infile);

	require XML::Simple;


	my $xs = new XML::Simple();

	my $xml = $xs->XMLin($content);

	$xml;
}

sub describe {
	my $dbh = shift;
	my $tablename = shift;
	my $columnname = uc(shift || ".*");

	my @rows;
	my %c;
	my $sth = $dbh->column_info(undef, undef, $tablename, "%");
	my $i = -1;

	while (my $row = $sth->fetchrow_hashref()) {
#	  print "<BR> $row->{TABLE_NAME} - $row->{TABLE_TYPE} - $row->{COLUMN_NAME}";
		next unless (uc($row->{COLUMN_NAME}) =~ /^$columnname/);
		unless ($c{$row->{COLUMN_NAME}}) {
			$c{$row->{COLUMN_NAME}}=1;
			$i++;
#		  print "$row->{COLUMN_NAME} ==> $row->{DATA_TYPE},$row->{SQL_DATA_TYPE},<BR>";
			$rows[$i] = {  externalname => $row->{COLUMN_NAME},
				name			=> $row->{COLUMN_NAME},
				datatypeid	=> uc ($row->{DATA_TYPE} || $row->{SQL_DATA_TYPE}),
				datalength	=> $row->{COLUMN_SIZE},
				datascale	 => $row->{DECIMAL_DIGITS},
				fieldorder	=> $row->{ORDINAL_POSITION},
				nullable	  => $row->{IS_NULLABLE},
				defaultvalue => $row->{COLUMN_DEF},
				Remarks		=> $row->{REMARKS},
#{ name => $col, externalname => $col, datatypeid => 'VARCHAR', datalength => 100,  fieldorder => $i*10};
			};
		}
	}
	\@rows;
}

sub otherAlterFieldSQL {
	my $object = shift;
	my $names = $object->{names};
	my ($oldName, $newName) = ref($names) ? ($names->[0], $names->[1]) : ($names, $names);

	my @sql;
	if ($object->{default}) {
		print " ==== otherAlterFieldSQL === $object->{default}\n";
		push @sql, "ALTER TABLE ALTER COLUMN SET DEFAULT $object->{default}";
		push @sql, "UPDATE $object->{objname} set $newName = '$object->{default}' WHERE $newName is NULL";
	}
	if ($object->{dropdefault}) { push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName DROP DEFAULT"; }
	if ($object->{notnull}) { push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName SET NOT NULL"; }
	if ($object->{dropnotnull}) { push @sql, "ALTER TABLE $object->{objname} ALTER COLUMN $newName DROP NOT NULL"; }
	return @sql;
}

sub alterFieldSQL {
	my $dbh = shift;
	my $object = shift;
	my $names = $object->{names};
	my ($oldName, $newName) = ref($names) ? ($names->[0], $names->[1]) : ($names, $names);
	my $oldtype = uc($object->{datatypes}[0]);
	my $newtype = $object->{datatypes}[1];
	my $rebuildIndexes = $object->{rebuildindexes};
	my $default = $object->{default};
	my $randName = "C_" . int(rand(10000));

	my @sql;

	my $rows = describe($dbh, $object->{objname}, $oldName);
#	dumpobject($rows, $object->{objname});
	return undef unless (uc($rows->[0]{datatypeid}) =~ /^$oldtype/);

	if ($rebuildIndexes) {} # TODO
	push @sql, "ALTER TABLE $object->{objname} add column $randName $newtype";
	if ($object->{convert}) { push @sql, "UPDATE $object->{objname} set $randName = $object->{convert}"; }
	push @sql, "ALTER TABLE $object->{objname} DROP column $oldName";
	push @sql, "ALTER TABLE $object->{objname} RENAME column $randName TO $newName";
	my @otherSql = otherAlterFieldSQL($object);
	push (@sql, @otherSql) if (@otherSql);
	return @sql;
}

sub renameFieldSQL {
	my $dbh = shift;
	my $object = shift;
	my $names = $object->{names};
	my ($oldName, $newName) = ref($names) ? ($names->[0], $names->[1]) : ($names, $names);
	my $oldtype = uc($object->{datatypes}[0]);
	my $newtype = $object->{datatypes}[1];
	my $rebuildIndexes = $object->{rebuildindexes};

	return undef unless ($newName and ($newName ne $oldName));
	my @sql;
	push @sql, "ALTER TABLE $object->{objname} RENAME column $oldName TO $newName";
	my @otherSql = otherAlterFieldSQL($object);
	push (@sql, @otherSql) if (@otherSql);
	return @sql;
}

sub generateSQL {
	my $alterList = shift->{alterdefs} || [];
	my @sqlList;
	require DBI;
	my $dbh = DBI->connect("dbi:Pg:dbname=aliphe", "aliphe", "aliphe");
	foreach my $object (@$alterList) {
		print "$object->{action} $object->{objname}\n";
		if ($object->{objtype} eq "table") {
			if ($object->{action} eq "alterfield") {
				my @sql = alterFieldSQL($dbh, $object);
				push (@sqlList, @sql) if (@sql);
			}
			elsif ($object->{action} eq "renamefield") {
				my @sql = renameFieldSQL($dbh, $object);
				push (@sqlList, @sql) if (@sql);
			}
		}
	}
	$dbh->disconnect();
	return @sqlList;
}

#my $commands = getalterdefs("altertables.txt");
#dumpobject ($commands, "alterlist");
#generateXML($commands);
my $xml = readXML("altertables.xml");
#dumpobject($xml,"xml");

my @sqlList = generateSQL($xml);
dumpobject(\@sqlList, "hehe");
