package FlowRt; #XmlSocket;
use XML::Simple;
use strict;
sub XSGlobalAttribute {
	my $self = shift;
	my $attrLabel = shift;

	$self->{__XMLSOCXKET__}{__GLOBAL__} ||= {};
	my $globalAttrs = $self->{__XMLSOCXKET__}{__GLOBAL__};
	@_ ? $globalAttrs->{$attrLabel} = shift : $globalAttrs->{$attrLabel};

}

sub XSServerAttribute {
	my $self = shift;
	my $attrLabel = shift;

	if ($attrLabel eq 'UNDEFINE') { $self->{__XMLSOCXKET__}{__SERVER__} = undef; }
	$self->{__XMLSOCXKET__}{__SERVER__} ||= {};
	my $globalAttrs = $self->{__XMLSOCXKET__}{__SERVER__};
	@_ ? $globalAttrs->{$attrLabel} = shift : $globalAttrs->{$attrLabel};

}

sub XSSocketAttribute {
	my $self = shift;
	my $socket = shift;
	my $attrLabel = shift;
	return undef unless ($socket and $attrLabel);
	if ($attrLabel eq 'UNDEFINE') {
		$socket ? $self->{__SOCKETS__}{ $socket } = undef : $self->{__SOCKETS__} = undef; 
		return undef;
	}
	$self->{__SOCKETS__}{ $socket } ||= {};
	my $socketAttrs = $self->{ $socket };
	@_ ? $socketAttrs->{$attrLabel} = shift : $socketAttrs->{$attrLabel};
}

sub XSChildAttribute {
	my $self = shift;
	my $attrLabel = shift;

	$self->{__XMLSOCXKET__}{ __CHILD__ } ||= {};
	my $childAttrs = $self->{ __CHILD__ };
	@_ ? $childAttrs->{$attrLabel} = shift : $childAttrs->{$attrLabel};
}

sub XSCanRead {
	my $self = shift;
	my $ioSelect = $self->XSGlobalAttribute("IOSELECT");
	return $ioSelect->can_read();
}

sub XSWrite {
	my $self = shift;
	my $socket = shift;

	my $msgTxt;
	my $recSep     = $self->XSGlobalAttribute("XS_RECSEP");
	if (ref($_[0]) eq 'HASH') {
		$msgTxt = XML::Simple::XMLout(shift, RootName => "XML");
	}
	else {
		my $req = shift;
		my $data = shift;
		$msgTxt = "<XML><REQUEST>$req</REQUEST><DATA>$data</DATA></XML>";
	}
	print $socket $msgTxt, $recSep;
}

sub XSRead {
	my $self = shift;
	my $socket = shift;
	my $maxMsgSize = $self->XSGlobalAttribute("XS_MAXMSGSIZE");
	my $readTimeOut = $self->XSGlobalAttribute("XS_READTIMEOUT") || 1;
	my $recSep     = $self->XSGlobalAttribute("XS_RECSEP");

	$socket->input_record_separator($recSep);

	my $input;
	eval
	{
		local $SIG{ALRM} = sub { die ":::alarm::::\n" }; # NB: \n required
		alarm 1;
		$input = $socket->getline();
		alarm 0;
	};
	if ($@) {
		alarm 0;
		my $errormsg = $@ =~ /:::alarm::::/ ? "XSRead timout" : "XSRead fatal error : $@";
		$self->LogSysTrace($errormsg);
		$self->XSWrite($socket, "XSReadError", "<METHOD>getline</METHOD><MESSAGE>$errormsg</MESSAGE>");
		return undef;
	}
	else {
		if (length($input) > $maxMsgSize) {
			my $errormsg = "XSRead Message to long";
			$self->LogSysTrace($errormsg); return undef 
			$self->XSWrite($socket, "XSReadError", "<METHOD>getline</METHOD><MESSAGE>$errormsg</MESSAGE>");
			return undef;
		}
	}

	return $input;
}

# Server SUBs
sub XmlSocket {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();

	my $attrlist = $objHier->attributelist($self->MyFlowId());
	my $attrs = {};

	foreach my $attr (@$attrlist) {
		$self->XSGlobalAttribute($attrs->{$attr->{attrdefid}}, $attr->{attrvalue}) if ($attr->{attrdefid});
	}

	$self->XSOpenSockets ($attrs) || $self->ProcessTerminate();

	$self->QueueInactiveDestroy(1);
	$SIG{"TERM"} = \&FlowRt::ProcessTerminate;
	$SIG{"INT"} = \&FlowRt::ProcessTerminate;
	$SIG{"CHLD"} = 'IGNORE';

	$self->XSServerLoop();
}


sub XSOpenSockets {
	my $self = shift;
	my $attrs = shift;

	my $clientPort = $self->XSGlobalAttribute("XS_CLIENTPORT");
	my $reuse = $self->XSGlobalAttribute("XS_REUSE");

	my $serverAddress = $self->XSGlobalAttribute("XS_SEVERADDRESS");

	my %listenTo = (Listen => 1, LocalPort => $clientPort, Reuse => $reuse, Proto => 'tcp');
	if ($serverAddress and ($serverAddress ne '*')) { $listenTo{ LocalAddr } = $serverAddress; }

	my $listenSocket = IO::Socket::INET->new(%listenTo) || return undef;

	my $ioSelect = IO::Select->new( $listenSocket ) || return undef;

	$self->XSServerAttribute("LISTENSOCKET", $listenSocket);
	$self->XSGlobalAttribute("IOSELECT", $ioSelect);
	return 1;

}

sub XSServerLoop {
	my $self = shift;

	while (1) {
		my @readySockets = $self->XSCanRead();
		foreach my $socket (@readySockets) {
			if ($socket == $self->XSServerAttribute("LISTENSOCKET")) {
				$self->XSNewClient($socket);
			}
			elsif ($self->XSSocketAttribute($socket, "CONNECTED")) {
				$self->XSMsgFromChild($socket);
			}
		}
	}
}

sub XSChildDisconnect {
	my $self = shift;
	my $socket = shift;

	my $ioSelect = $self->XSServerAttribute('IOSELECT');
	$ioSelect->remove($socket);
	$socket->close();
	$self->XSSocketAttribute($socket, 'UNDEFINE');
}

sub XSMatchChildAttrs {
	my $self = shift;
	my $patterns = shift || {};
	my $child = shift;

	return undef unless ($patterns and (ref($patterns) eq 'HASH'));
	foreach my $attr (keys %$patterns) {
		my $val = $patterns->{ $attr };
		if ($child->{ $attr } !~ /$val/) { return undef; }
	}
	return 1;
}

sub XSSetClientId {
	my $self = shift;
	my $fsock = shift;
	my $data = shift;

	$self->XSSocketAttribute($fsock, "ID", $data);
}

sub XSBroadCast {
	my $self = shift;
	my $fsock = shift;
	my $data = shift;

	my $recSep     = $self->XSGlobalAttribute("XS_RECSEP");

	my $destAttrs = $data->{ TO };

	my $from = $self->XSSocketAttribute($fsock, "ID");

	return undef unless ($from->{ SESSIONID } eq $data->{ FROM }{ SESSIONID });

	my $ioSelect = $self->XSServerAttribute('IOSELECT');
	my $listenSock = $self->XSServerAttribute("LISTENSOCKET");

	my $message = {
		REQUEST => "XSMessageReceived",
		DATA => $data,
	};
	my $txtMsg = XML::Simple::XMLout($message, RootName => "XML");

	my @sockets = $ioSelect->handles();
	my $recSep        = $self->XSGlobalAttribute("XS_RECSEP");
	foreach my $dsock (@sockets) {
		next if (($dsock == $fsock) or ($dsock == $listenSock));
		if ($destAttrs->{ALL} or $self->XSMatchChildAttrs($destAttrs)) {
			print $dsock $txtMsg, $recSep;
		}
	}
}

sub XSMsgFromChild {
	my $self = shift;
	my $socket = shift;

	my %childMethods = ( XSBroadCast => 1, XSSetClientId => 1 );
	my $input = $socket->XSRead($socket);

	unless ($input) {
		$self->XSChildDisconnect($socket);
		return;
	}
	my $tree;
	eval {
		$tree = XML::Simple::XMLin($input);
	};

	my $message;
	if ($@) { $self->XSWrite($socket, "XSServerError", "<METHOD>XML::Simple::XMLin</METHOD><MESSAGE>$@</MESSAGE>"); }
	else {
		my $func = $tree->{ REQUEST };
		if ($childMethods{ $func }) {
			my $ret;
			eval {
				$ret = $self->$func($socket, $tree->{ DATA })
			};
			if ($@) { $self->XSWrite($socket, "XSServerError", "<METHOD>$func</METHOD><MESSAGE>$@</MESSAGE>"); }
			else { $self->XSWrite($socket, "XSMethodResult", "<METHOD>$func</METHOD><RETURN>$@</RETURN>"); }
		}
		else { $self->XSWrite($socket, "XSServerError", "<METHOD>$func</METHOD><MESSAGE>UNKNOWN METHOD</MESSAGE>"); }
	}
}

sub XSCanAccept {
	my $self = shift;
	my $sock = shift;

	my ($hostDeny, $hostAllow);
	unless ($hostDeny = $self->XSGlobalAttribute("__HOSTDENY__")) {
		my $hostPattern = $self->XSGlobalAttribute("XS_HOSTDENY");
		my @ahostDeny = split(/[,;]/, $hostPattern);
		foreach my $pat (@ahostDeny) {
			$pat =~ s/\./\\\./g;
			$pat =~ s/\*/\.\*/g;
		}
		$hostDeny = $self->XSGlobalAttribute("__HOSTDENY__", \@ahostDeny);
	}

	unless ($hostAllow = $self->XSGlobalAttribute("__HOSTALLOW__")) {
		my $hostPattern = self->XSGlobalAttribute("XS_HOSTALLOW");
		my @ahostAllow = split(/[,;]/, $hostPattern);
		foreach my $pat (@ahostAllow) {
			$pat =~ s/\./\\\./g;
			$pat =~ s/\*/\.\*/g;
		}
		$hostAllow = $self->XSGlobalAttribute("__HOSTALLOW__", \@ahostAllow);
	}

	my $peerhost = $sock->peerhost();
	foreach my $pat (@{$hostDeny}) {
		if ($peerhost =~ /^$pat$/) { return undef; }
	}

	foreach my $pat (@{$$hostAllow}) {
		if ($peerhost =~ /^$pat$/) { return 1; }
	}
	return undef;
}


sub XSNewClient {
	my $self = shift;
	my $socket = shift;

	my $ioSelect = $self->XSGlobalAttribute("IOSELECT");
	my $newClient = $socket->accept();
	if ($self->XSCanAccept($newClient)) {
		no strict;
		my ($parentSocket, $childSocket) = IO::Socket->socketpair(AF_UNIX, SOCK_STREAM, PF_UNSPEC);
		use strict;
		if (my $pid = fork()) {
			$parentSocket->close();
			$self->XSSocketAttribute($childSocket, 'CONNECTED', 1);
			$ioSelect->add($childSocket);
		}
		else {
			$childSocket->close();
			$self->XSChildAttribute('SERVERSOCKET', $parentSocket);
			$self->XSChildAttribute('CLIENTSOCKET', $newClient);
			foreach my $fh ($ioSelect->handles()) { $ioSelect->remove(); $fh->close(); }
			$ioSelect->add($parentSocket);
			$ioSelect->add($newClient);
			$self->QueueDbhAutocommit(undef);
			$self->QueueDbh(undef);
			$self->QueueInactiveDestroy(0);
			$self->QueueConnect() || $self->XSChildTerminate();
			$self->XSServerAttribute('UNDEFINE');
			$self->XSSocketAttribute($childSocket, 'UNDEFINE');
			$self->XSChildLoop();
			$self->XSChildTerminate();
		}
	}
	else {
		$newClient->close();
	}
}

sub XSChildTerminate {
	my $self = shift;

	exit;
}

# Child
sub XSChildLoop {
	my $self = shift;

	while (1) {
		my @readySockets = $self->XSCanRead();
		foreach my $socket (@readySockets) {
			if ($socket == $self->XSChildAttribute("SERVERSOCKET")) {
				$self->XSMsgFromServer($socket);
			}
			elsif ($socket == $self->XSChildAttribute("CLIENTSOCKET")) {
				$self->XSMsgFromClient($socket);
			}
		}
	}
}

sub XSMsgFromServer {
	my $self = shift;
	my $socket = shift;

	my %serverMethods = ( XSMessageReceived => 1, XSStop => 1, XSServerError => 1, XSMethodResult => 1);
	my $maxMsgSize    = $self->XSGlobalAttribute("XS_MAXMSGSIZE");
	my $recSep        = $self->XSGlobalAttribute("XS_RECSEP");
	my $input         = $socket->XSRead($maxMsgSize, $recSep, $socket);

	unless ($input) { $self->XSChildTerminate(); }

	my $tree;
	eval { $tree = XML::Simple::XMLin($input); };

	my $func = $tree->{ REQUEST };
	if ($@ or ($func eq 'XSSTop')) { $self->XSChildTerminate($@); }
	else {
		if ($serverMethods{ $func }) {
			my $ret;
			eval {
				$ret = $self->$func($tree->{ DATA });
			};
			if ($@) { $self->XSChildTerminate($@); }
		}
	}
}

sub XSMessageReceived {
	my $self = shift;
	my $data = shift;

	my $message = {
		REQUEST => "XSMessageReceived",
		DATA    => $data,
	};

	my $socket = $self->XSChildAttribute('CLIENTSOCKET');
	$self->XSWrite($socket, $message);
}

sub XSServerError {
	my $self = shift;
	my $data = shift;

	my $message = {
		REQUEST => "XSServerError",
		DATA    => $data,
	};

	my $socket = $self->XSChildAttribute('CLIENTSOCKET');
	$self->XSWrite($socket, $message);
	$self->XSChildTerminate();
}

sub XSMethodResult {
	my $self = shift;
	my $data = shift;

	my $message = {
		REQUEST => "XSMethodResult",
		DATA    => $data,
	};

	my $socket = $self->XSChildAttribute('CLIENTSOCKET');
	$self->XSWrite($socket, $message);
}


sub XSMsgFromClient {
	my $self = shift;
	my $socket = shift;

	my %serverMethods = ( XSClientBoradCast => 1, XSStop => 1, XSClientLogin => 1, XSRunScript => 1 );
	my $input         = $self->XSRead($socket);

	unless ($input) { $self->XSChildTerminate(); }

	my $tree;
	eval { $tree = XML::Simple::XMLin($input); };

	my $func = $tree->{ REQUEST };
	if ($@ or ($func eq 'XSSTop')) { $self->XSChildTerminate($@); }
	else {
		if ($serverMethods{ $func }) {
			my $ret;
			eval {
				$ret = $self->$func($tree->{ DATA });
			};
			if ($@) { $self->XSChildTerminate($@); }
		}
	}
}

sub XSClientBroadCast {
	my $self = shift;
	my $data = shift;

	my $message = {
		REQUEST => "XSBroadCast",
		DATA => $data,
	};

	my $socket = $self->XSChildAttribute('SERVERSOCKET');
	$self->XSWrite($socket, $message);
}

sub XSClientLogin {
	my $self = shift;
	my $data = shift;

	my $login = $data->{ LOGIN };
	my $password;
	$login =~ /(.*)\/(.*)/;
	$login = $1;
	$password = $2;

	my $socket = $self->XSChildAttribute('CLIENTSOCKET');
	my $sessionId;

	my $dbh = $self->QueueDbhAutocommit();
	my $sessionId;
	my $ip = $socket->peerhost();
	eval { $sessionId = $dbh->rtnewsession(userid => $login, userpass => $login, ipaddress => $ip); };
	if ($@) {
		$self->XSWrite($socket, "XSNOTCONNECTED", "<MESSAGE>$@</MESSAGE>");
		$self->XSChildTerminate($@);
	}

	my $message = {
		REQUEST => "XSSetClientId",
		DATA    => { }
	};

	foreach my $attr (keys %$data) { $message->{ DATA }{ $attr } = $data->{ $attr }; }
	$message->{ DATA }{ LOGIN } = $login;
	$message->{ DATA }{ IPADDRESS } = $ip;
	$message->{ DATA }{ SESSIONID } = $sessionId;
			
	my $txtMsg = XML::Simple::XMLout($message, RootName => "XML");
	my $srvSock = $self->XSChildAttribute('SERVERSOCKET');
	$self->XSWrite($srvSock, $message);
	$self->XSWrite($socket, "XSCONNECTED", "<SESSIONID>$sessionId</SESSIONID>");
	$self->XSChildAttribute("ID", $data);
}

sub XSRunScript {
	my $self = shift;
	my $data = shift;

	my $scriptId = $data-> { SCRIPTID };
	my $scriptRt = $self->LoadScript($scriptId);
	my $message;
	my $ret;
	if ($scriptRt) {
		eval { $ret = $scriptRt->RunScript($data->{ PARAMS }); };
		if ($@) {
			$message = {
				REQUEST => "XSScriptError",
				DATA    => { SCRIPTID => $scriptId, MESSAGE  => $@, }
			};
		}
		else {
			$message = {
				REQUEST => "XSScriptResult",
				DATA    => { SCRIPTID => $scriptId, RESULT  => $ret }
			}
		}
	}
	else { 
			$message = {
				REQUEST => "XSScriptNotExist",
				DATA    => { SCRIPTID => $scriptId, MESSAGE  => "No such script $scriptId", }
			};
	}
	my $socket = $self->XSChildAttribute('CLIENTSOCKET');
	$self->XSWrite($socket, $message);
}

package ScriptRt;

sub whoami {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->XSChildAttribute("ID");

}

