<?php
/*****************************************************************************************
  Fileame: postgresql.inc

  Purpose: Contains the functions required for the wrapper to access a PostgreSQL Database

  Created: 11-01-00
  Updated:

  History:

******************************************************************************************/

//set our defines

if (!defined("DB_LIKE")) define("DB_LIKE","ILIKE");

//Opens a connection to the desired database w/ the given connection information
function db_connect($dbhost,$dbuser,$dbpassword,$dbport,$dbname) {

	if (!$conn = pg_connect("host=$dbhost port=$dbport user=$dbuser password=$dbpassword dbname=$dbname")) echo "Could not connect to database";
	return $conn;
}

//queries the database, returns a result and the number of rows of results
function report_query($conn,$sql) {

	if (!$result = pg_exec($conn,$sql)) echo "ERROR_SQL=".$sql;

	$num = pg_numrows($result);
	$report = array($result,$num);
	return $report;
}


//This will run a function to display the results of a query.  If the called
//function returns a value, this function will return that cumlative value
function result($query_result,$query_num,$function_variable,$passVar) {

	$string = null;

	for ($row=0;$row<$query_num;$row++) {

		$query_myrow = @pg_fetch_array($query_result,$row);
		if ($function_variable) $string .= $function_variable($query_myrow,$passVar);

	}

	return $string;
}


//this function will return one array which contains all the results from the
//query in their respective associative array.  There must be a better
//way of doing this
function total_result($conn,$sql) {

	if (!$result = pg_exec($conn,$sql)) echo "ERROR_SQL=".$sql;
	$num = pg_numrows($result);

	if ($num!=0) {

		$keyArray = array_keys(@pg_fetch_array($result,0));

		$returnArray = array();

		for ($row=0;$row<count($keyArray);$row++) {

			$key = $keyArray[$row];
			$tempArray = array();

			for ($i=0;$i<$num;$i++) {

				$query_myrow = @pg_fetch_array($result,$i);

				$tempArray[]=$query_myrow[$key];

			}

			$returnArray[$key] = $tempArray;

		}

		return $returnArray;
	}

	//array format will = array[key][row];

}



//Run by a do-while loop to display the desired number of results
function single_myrow_result($query_result,$number) {

	$query_myrow = @pg_fetch_array($query_result,$number);
	return $query_myrow;
}


//this function will return the associative array that is resulted
//from a single hit query statement
function single_result($conn,$sql) {

	$query_return = report_query($conn,$sql);
	if ($query_return[1]!=0) {
		$value = @pg_fetch_array($query_return[0],0);
		return $value;
	}
	else return false;

}

//this function will return the associative array that is resulted
//from a single hit query statement
function select_result($conn,$num,$sql) {

	$query_return = report_query($conn,$sql);
	if ($query_return[1]!=0) {
		$value = @pg_fetch_array($query_return[0],$num);
		return $value;
	}
	else return false;

}


//this function will return only the number of results for the query
function num_result($conn,$sql) {

	$query_return = report_query($conn,$sql);
	return $query_return[1];

}


function db_function_query($conn,$sql) {
	$result = @pg_exec($conn,$sql);
	$query_myrow = @pg_fetch_array($result,0);
	$return_value=$query_myrow[0];

	return $return_value;
}


//For generic database queries.  Can be used to ADD, INSERT, UPDATE, or DELETE records
function db_query($conn,$sql) {

	if (!$result = pg_exec($conn,$sql)) echo "ERROR_SQL=".$sql;

	return $result;
}


//This function replaces array_myrow_result and does not use globals
function array_result($field,$query_result,$query_num) {

	$id_values=array();

	for ($row=0;$row<$query_num;$row++) {
		$query_myrow = @pg_fetch_array($query_result,$row);

		$id_variable=$query_myrow[$field];
		$id_values[$row]=$id_variable;

	}

	return $id_values;

}

//Run by a do-while loop to return a simple variable;
function return_result($query_result,$query_num,$function_variable,$result_start,$passvar) {

	$return_variable=$result_start;
	for ($row=0;$row<$query_num;$row++) {

		$query_myrow = @pg_fetch_array($query_result,$row);
		if ($function_variable) $return_variable.=$function_variable($query_myrow,$passvar);

	}

	return $return_variable;
}


//Run by a do-while loop to display the desired number of results in specified number of columns
function column_result($query_result,$columns,$stored_query_num,$query_num,$function_variable) {

	$row=0;
	$newrow=$row;
	do {
	$row=$newrow;
	echo "<td valign=top>";
	echo "<table>";
		do {
			echo "<tr><td>";
			$query_myrow = @pg_fetch_array($query_result,$row);
			if ($function_variable) $function_variable($query_myrow);

			$row=$row+$columns;
			echo "</td></tr>";
		}
		while ($row < $query_num);
	echo "</table>";
	echo "</td>";
	$newrow++;
	}
	while ($newrow < $columns);
}

function db_insert_id($table,$id,$conn,$result) {
	$pgoid=@pg_last_oid($result);
	$result1=@pg_exec($conn,"SELECT $id FROM $table WHERE oid='$pgoid'");
	$query_myrow=@pg_fetch_array($result1,0);
	$return_id=$query_myrow[$id];
	return $return_id;
}

function color_result($query_result,$query_num,$function_variable,$color1,$color2,$conn) {

	for ($row=0;$row<$query_num;$row++) {

		$string = $row % 2;

		if ($string==1) {
   			$color=$color1;
   		} else {
   			$color=$color2;
   		}

		$query_myrow = @pg_fetch_array($query_result,$row);
		if ($function_variable) $function_variable($query_myrow,$color,$conn);

	}

	return $query_myrow;
}

//begins a transaction instance
function beginTransaction($conn) {
	$sql = "BEGIN WORK";
	if (db_query($conn,$sql)) return true;
	else return false;
}

//ends a transaction instance
function endTransaction($conn) {
	$sql = "END WORK";
	if (db_query($conn,$sql)) return true;
	else return false;
}

function db_vacuum($conn) {

	$sql = "VACUUM";

	if (db_query($conn,$sql)) $message = "Database Vacuumed Successfully";
	else $message = "Database Vacuum Failed";

	return $message;

}

