/*
	agent.h

	The Agent class is a base for both class MasterAgent and class DbAgent.
	It implements common agent functionality. All members, including the
	constructor, are protected. This class is not supposed to be instantiated
	directly. Since this class does not implement any thread-related functionality,
	it does not derive from class Thread. That means MasterAgent and DbAgent must
	derive from class Agent as well as from class Thread.

	Project: pgjobs
	Author: Zlatko Michailov
	Created: 13-Oct-2003
	Updated:

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003, Zlatko Michailov

*/



#ifndef __AGENT_H__
#define __AGENT_H__



//--------------------------------------------------------------------------------

#include <string>
#include "log.h"
#include "defs.h"


using namespace std;



//--------------------------------------------------------------------------------
// Class Agent implements common (protected) functionality for specific pgjobs
// agent classes.

class Agent
{
// Data members
protected:
	static Log		SharedLog;

	string			AgentName;
	const char*		Status;
	int				LogLevel;
	bool			IsReadyToRun;


// Construction
protected:
	Agent( const char* agentName, int logLevel );
	

// Methods
protected:
	bool InitLog();
	bool Record( const char* text, int messageLevel );
};



#endif	// __AGENT_H__


