/* Module:          SQLAllocConnect.c
 *
 * Description:     Has been replaced by SQLAllocHandle.
 *
 * Classes:         
 *
 * API functions:   SQLAllocConnect
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLAllocConnect(
								  SQLHENV     hDrvEnv,
								  SQLHDBC *phDrvDbc
								  )
{
	EnvironmentClass *env = (EnvironmentClass *)hDrvEnv;
	ConnectionClass *conn;
	static char *func="SQLAllocConnect";

	mylog( "%s: entering...\n", func);

	conn = CC_Constructor();
	mylog("**** %s: hDrvEnv = %u, conn = %u\n", func, hDrvEnv, conn);

    if( ! conn)
	{
		env->errormsg = "Couldn't allocate memory for Connection object.";
        env->errornumber = ENV_ALLOC_ERROR;
		*phDrvDbc = SQL_NULL_HDBC;
		EN_log_error(func, "", env);
        return SQL_ERROR;
    }

    if ( ! EN_add_connection(env, conn))
	{
		env->errormsg = "Maximum number of connections exceeded.";
        env->errornumber = ENV_ALLOC_ERROR;
        CC_Destructor(conn);
		*phDrvDbc = SQL_NULL_HDBC;
		EN_log_error(func, "", env);
        return SQL_ERROR;
    }

	*phDrvDbc = (SQLHDBC) conn;

    return SQL_SUCCESS;
}
