/* Module:          SQLSetPos.c
 *
 * Description:     Sets the cursor position in a rowset and allows an 
 *					application to refresh data in the rowset or to update 
 *					or delete data in the result set.
 *
 * Classes:         
 *
 * API functions:   SQLSetPos
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLSetPos(
        SQLHSTMT   hDrvStmt,
        SQLUSMALLINT   nRow,
        SQLUSMALLINT   nOperation,
        SQLUSMALLINT   nLockType)
{
static char *func = "SQLSetPos";
StatementClass *stmt = (StatementClass *) hDrvStmt;
QResultClass *res;
int num_cols, i;
BindInfoClass *bindings = stmt->bindings;

	if ( ! stmt) {
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	if (nOperation != SQL_POSITION && nOperation != SQL_REFRESH) {
		stmt->errornumber = STMT_NOT_IMPLEMENTED_ERROR;
		stmt->errormsg = "Only SQL_POSITION/REFRESH is supported for SQLSetPos";
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}

	if ( ! (res = stmt->result)) {
		stmt->errormsg = "Null statement result in SQLSetPos.";
		stmt->errornumber = STMT_SEQUENCE_ERROR;
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}
	num_cols = QR_NumResultCols(res);

	if (nRow == 0) {
		stmt->errornumber = STMT_ROW_OUT_OF_RANGE;
		stmt->errormsg = "Driver does not support Bulk operations.";
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}

	if (nRow > stmt->last_fetch_count) {
		stmt->errornumber = STMT_ROW_OUT_OF_RANGE;
		stmt->errormsg = "Row value out of range";
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}

	nRow--;

	/*	Reset for SQLGetData */
	for (i = 0; i < num_cols; i++)
		bindings[i].data_left = -1;

	QR_set_position(res, nRow);

	stmt->currTuple = stmt->rowset_start + nRow;

	return SQL_SUCCESS;

}
