'
'	Frank Lupo (Wolf) !! 
'	frank_lupo@email.it
'
'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Class Describe
'	Describe for object database
'
Option Explicit

Class ClsDescribe
	'\l
    Public Sub ListAllDatabase(bDisplayNumRow)
	Dim szIstr

		szIstr="SELECT d.datname as ""Name""," & VbCrLf
        szIstr=szIstr & "       u.usename as ""Owner""," & VbCrLf
        szIstr=szIstr & "       pg_encoding_to_char(d.encoding) as ""Encoding"" " & VbCrLf
		szIstr=szIstr & "FROM pg_database d LEFT JOIN pg_user u ON d.datdba = u.usesysid " & VbCrLf
		szIstr=szIstr & "ORDER BY 1;"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of databases"
		App.Data.Print.DisplayNumRow=bDisplayNumRow
		App.Data.Print.PrintResultSQL
	End Sub

	'\d 
    Public Sub DescribeTableDetails(szName)
	Dim szIstr,ResultSetTableInfo,szHeaders,iCols,szViewDef,szCells,szFooter,iNumFooter,ResultSet,iNumRow
	Dim ResultSetData,iRowData
	Dim iRow,iCol,szTitle,szSpaceAdjust,bFrist,szTemp

	Const FlagDesc=False
'	Const FlagDesc=True

		if len(trim(szName)) = 0 then
			ListTables szName,0
			Exit Sub
		End if

		'Get general table info
		szIstr="SELECT relhasindex, relkind, relchecks, reltriggers, relhasrules" & vbcrlf
		szIstr=szIstr & "FROM pg_class WHERE relname='" & szName & "'"
		App.Data.ConDb.Execute szIstr
		if App.Data.ConDb.NumRow=0 then 
			wscript.echo "Did not find any relation named """ & szName & """"
			Exit Sub
		end if
		set ResultSetTableInfo=App.Data.ConDb.ResultSet

		Redim szHeaders(5)
		szHeaders(0)="Column"
		szHeaders(1)="Type"
		iCols=1

		if ResultSetTableInfo("relkind") = "r" or ResultSetTableInfo("relkind") = "v" then
			iCols=iCols+1
			szHeaders(iCols)="Modifiers"
		end if

		if FlagDesc then
			iCols=iCols+1
			szHeaders(iCols)="Description"
		End if

		'Get column info (index requires additional checks)
		if ResultSetTableInfo("relkind") = "i" then
			szIstr="SELECT" & vbcrlf
			szIstr=szIstr & "  CASE i.indproc WHEN ('-'::regproc) THEN a.attname" & vbcrlf
			szIstr=szIstr & "  ELSE SUBSTR(pg_get_indexdef(attrelid)," & vbcrlf
			szIstr=szIstr & "  POSITION('(' in pg_get_indexdef(attrelid)))" & vbcrlf
			szIstr=szIstr & "  END, "
		else
			szIstr="SELECT a.attname, "
		end if 
		szIstr=szIstr & "format_type(a.atttypid, a.atttypmod), a.attnotnull, a.atthasdef, a.attnum" & vbcrlf

		if FlagDesc then szIstr=szIstr & ", col_description(a.attrelid, a.attnum)" & vbcrlf
		szIstr=szIstr & " FROM pg_class c, pg_attribute a"

		if ResultSetTableInfo("relkind") = "i" then szIstr=szIstr & ", pg_index i" & vbcrlf

		szIstr=szIstr & " WHERE c.relname = '" & szName & "'" & vbcrlf
		szIstr=szIstr & "  AND a.attnum > 0 AND a.attrelid = c.oid" & vbcrlf

		if ResultSetTableInfo("relkind") = "i" then szIstr=szIstr & " AND a.attrelid = i.indexrelid" & vbcrlf
		szIstr=szIstr & "ORDER BY a.attnum"
		App.Data.ConDb.Execute szIstr
		iRowData=App.Data.ConDb.NumRow
		if iRowData=0 then Exit Sub
		Set ResultSetData=App.Data.ConDb.ResultSet

		'Check if table is a view
		szViewDef=""
		if ResultSetTableInfo("relhasrules") = 1 then 
			szIstr="SELECT definition FROM pg_views WHERE viewname = '" & szName & "'"
			App.Data.ConDb.Execute szIstr
			if App.Data.ConDb.NumRow=0 then Exit Sub
			szViewDef=App.Data.ConDb.ResultSet("definition")
		end if

		'Generate table cells to be printed
		ReDim szCells(iRowData-1,ResultSetData.Fields.Count)

		iRow=0
		While Not ResultSetData.Eof
			iCol=0

			'Name
			szCells(iRow,0)=ResultSetData.Fields(0)

			'Type
			szCells(iRow,1)=ResultSetData.Fields(1)

			'Extra: not null and default
			'(I'm cutting off the 'default' string at 128)
 			if ResultSetTableInfo("relkind") = "r" or ResultSetTableInfo("relkind") = "v" then
				if ResultSetData.Fields(2)=1 then szCells(iRow,2)="not null"

				'handle "default" here
				if ResultSetData.Fields(3)=1 then 
					szIstr="SELECT substring(d.adsrc for 128) FROM pg_attrdef d, pg_class c" & vbcrlf
					szIstr=szIstr & "WHERE c.relname = '" & szName & "' AND c.oid = d.adrelid AND d.adnum = " & ResultSetData.Fields(4)
					App.Data.ConDb.Execute szIstr

					if len(szCells(iRow,2)) > 0 then szCells(iRow,2) = szCells(iRow,2) & " "
					szCells(iRow,2) = szCells(iRow,2) & "default "
					szCells(iRow,2) = szCells(iRow,2) & App.Data.ConDb.ResultSet.Fields(0)
				end if
			End if

			'Description
			if FlagDesc then szCells(iRow,iCols) = ResultSetData.Fields(5)

			iRow=iRow+1
			ResultSetData.MoveNext
		Wend

		'Make title
		Select Case ResultSetTableInfo("relkind") 
			Case "r"
				szTitle="Table "
			Case "v"
				szTitle="View "
			Case "S"
				szTitle="Sequence "
			Case "i"
				szTitle="Index "
			Case "s"
				szTitle="Special relation "
			Case "t"
				szTitle="TOAST table "
			Case Else
				szTitle=ResultSetTableInfo("relkind") & " "
		End Select 
		szTitle=szTitle & """" & szName & """"

		'Make footers
		redim szFooter(100)
		iNumFooter=0
		if ResultSetTableInfo("relkind") ="i" then
			'Footer information about an index
		
			szIstr="SELECT i.indisunique, i.indisprimary, a.amname, c2.relname," & vbcrlf
			szIstr=szIstr & " pg_get_expr(i.indpred,i.indrelid)" & vbcrlf
			szIstr=szIstr & " FROM pg_index i, pg_class c, pg_class c2, pg_am a" & vbcrlf
			szIstr=szIstr & " WHERE i.indexrelid = c.oid AND c.relname = '" & szName & "' AND c.relam = a.oid" & vbcrlf
			szIstr=szIstr & " AND i.indrelid = c2.oid"
			App.Data.ConDb.Execute szIstr
			if App.Data.ConDb.NumRow <> 1 then exit sub
			if App.Data.ConDb.NumRow > 0 then 
				Set ResultSet=App.Data.ConDb.ResultSet

				if ResultSet.Fields(1) =1 then				'index is primary
					szFooter(iNumFooter)="primary key, "
				elseif ResultSet.Fields(0) =1 then		    'index is unique
					szFooter(iNumFooter)="unique, "
				end if
				szFooter(iNumFooter)=szFooter(iNumFooter) & ResultSet.Fields(2) 
				iNumFooter=iNumFooter+1
				szFooter(iNumFooter)=szFooter(iNumFooter) & "for table """ & ResultSet.Fields(3) & """"
	
				if len(ResultSet.Fields(4)) > 0 then 
					iNumFooter=iNumFooter+1
					szFooter(iNumFooter)=szFooter(iNumFooter) & ", predicate " & ResultSet.Fields(4)
				end if 
			end if	
		elseif len(szViewDef) > 0 then
			'count rules
			Set ResultSet=Nothing
			iNumRow=0
			if ResultSetTableInfo("relhasrules") =1 then
				szIstr="SELECT r.rulename" & vbcrlf
				szIstr=szIstr & " FROM pg_rewrite r, pg_class c" & vbcrlf
				szIstr=szIstr & " WHERE c.relname = '" & szName & "' AND c.oid = r.ev_class" & vbcrlf
				szIstr=szIstr & " AND r.rulename != '_RETURN'"
				App.Data.ConDb.Execute szIstr
				iNumRow=App.Data.ConDb.NumRow 
				if iNumRow>0 then Set ResultSet=App.Data.ConDb.ResultSet
			end if

			'Footer information about a view
			szFooter(iNumFooter)="View definition: " & szViewDef

			'print rules
			if iNumRow > 0 then
				iNumFooter=iNumFooter+1
				szTemp="Rules: "
				szFooter(iNumFooter)=szTemp
				szSpaceAdjust=space(len(szTemp))
				bFrist=True
				while Not ResultSet.Eof
					if bFrist then
						szFooter(iNumFooter)=szFooter(iNumFooter) & ResultSet.Fields(0)
						bFrist=False
					else
						iNumFooter=iNumFooter+1
						szFooter(iNumFooter)= szSpaceAdjust & ResultSet.Fields(0)
					end if

					ResultSet.MoveNext
					if Not ResultSet.Eof then szFooter(iNumFooter)=szFooter(iNumFooter) & ","
				Wend
			end if
		elseif ResultSetTableInfo("relkind") ="r" then
			'Footer information about a table
			'count indexes
			if ResultSetTableInfo("relhasindex") =1 then
				szIstr="SELECT c2.relname, i.indisprimary, i.indisunique," & vbcrlf
				szIstr=szIstr & " SUBSTR(pg_get_indexdef(i.indexrelid)," & vbcrlf
				szIstr=szIstr & " POSITION('USING ' IN pg_get_indexdef(i.indexrelid))+5)" & vbcrlf
				szIstr=szIstr & " FROM pg_class c, pg_class c2, pg_index i" & vbcrlf
				szIstr=szIstr & " WHERE c.relname = '" & szName & "' AND c.oid = i.indrelid AND i.indexrelid = c2.oid" & vbcrlf
				szIstr=szIstr & " ORDER BY i.indisprimary DESC, i.indisunique DESC, c2.relname"
				App.Data.ConDb.Execute szIstr
				iNumRow=App.Data.ConDb.NumRow 
				if iNumRow>0 then 
					Set ResultSet=App.Data.ConDb.ResultSet

					szTemp="Indexes: " 
					szFooter(iNumFooter)=szTemp 
					szSpaceAdjust=space(len(szTemp))
					bFrist=True
					while Not ResultSet.Eof
						if bFrist then
							szFooter(iNumFooter)=szFooter(iNumFooter) & ResultSet.Fields(0)
							bFrist=False
						else
							iNumFooter=iNumFooter+1
							szFooter(iNumFooter)=szSpaceAdjust & ResultSet.Fields(0)
						end if

						'Label as primary key or unique (but not both)
						if ResultSet.Fields(1)=1 then szFooter(iNumFooter)=szFooter(iNumFooter) & " primary key"
						if ResultSet.Fields(2)=1 then szFooter(iNumFooter)=szFooter(iNumFooter) & " unique"

						'Everything after "USING" is echoed verbatim
						szFooter(iNumFooter)=szFooter(iNumFooter) & ResultSet.Fields(3)
						ResultSet.MoveNext
						if Not ResultSet.Eof then szFooter(iNumFooter)=szFooter(iNumFooter) & "," 
					wend
				End if
			End if

			'count table (and column) check constraints
			if ResultSetTableInfo("relchecks") =1 then
				szIstr="SELECT consrc, conname" & vbcrlf
				szIstr=szIstr & " FROM pg_constraint r, pg_class c" & vbcrlf
				szIstr=szIstr & " WHERE c.relname='" & szName & "' AND c.oid = r.conrelid" & vbcrlf
				szIstr=szIstr & " AND r.contype = 'c'"
				App.Data.ConDb.Execute szIstr
				iNumRow=App.Data.ConDb.NumRow 
				if iNumRow>0 then 
					Set ResultSet=App.Data.ConDb.ResultSet

					szTemp="Check constraints: " 
					if len(szFooter(iNumFooter)) > 0 then
						szFooter(iNumFooter)= szTemp
					else
						iNumFooter=iNumFooter+1
						szFooter(iNumFooter)=szTemp
					end if
					szSpaceAdjust=space(len(szTemp))
					bFrist=True
					while Not ResultSet.Eof
						if bFrist then
							szFooter(iNumFooter)=szFooter(iNumFooter) & """" & ResultSet.Fields(1) & """ " & ResultSet.Fields(0)
							bFrist=False
						else
							iNumFooter=iNumFooter+1
							szFooter(iNumFooter)=szSpaceAdjust & """" & ResultSet.Fields(1) & """ " & ResultSet.Fields(0)
						end if
						ResultSet.MoveNext
						if Not ResultSet.Eof then szFooter(iNumFooter)=szFooter(iNumFooter) & ","
					wend
				end if
			end if

			'count rules
			if ResultSetTableInfo("relhasrules") =1 then
				szIstr="SELECT r.rulename" & vbcrlf
				szIstr=szIstr & " FROM pg_rewrite r, pg_class c" & vbcrlf
				szIstr=szIstr & " WHERE c.relname='" & szName & "' AND c.oid = r.ev_class"
				App.Data.ConDb.Execute szIstr
				iNumRow=App.Data.ConDb.NumRow 
				if iNumRow>0 then 
					Set ResultSet=App.Data.ConDb.ResultSet

					szTemp="Rules: "
					if len(szFooter(iNumFooter)) > 0 then
						szFooter(iNumFooter)= szTemp
					else
						iNumFooter=iNumFooter+1
						szFooter(iNumFooter)=szTemp
					end if
					szSpaceAdjust=space(len(szTemp))
					bFrist=True
					while Not ResultSet.Eof
						if bFrist then
							szFooter(iNumFooter)=szFooter(iNumFooter) & ResultSet.Fields(0)
							bFrist=False
						else
							szFooter(iNumFooter)=szSpaceAdjust & ResultSet.Fields(0)
						end if
						ResultSet.MoveNext
						if Not ResultSet.Eof then szFooter(iNumFooter)=szFooter(iNumFooter) & ","
					wend
				end if
			End if

			'count triggers
			if ResultSetTableInfo("reltriggers") =1 then
				szIstr="SELECT t.tgname" & vbcrlf
				szIstr=szIstr & " FROM pg_trigger t, pg_class c" & vbcrlf
				szIstr=szIstr & " WHERE c.relname='" & szName & "' AND c.oid = t.tgrelid"
				App.Data.ConDb.Execute szIstr
				iNumRow=App.Data.ConDb.NumRow 
				if iNumRow>0 then 
					Set ResultSet=App.Data.ConDb.ResultSet

					szTemp="Triggers: "
					if len(szFooter(iNumFooter)) > 0 then
						szFooter(iNumFooter)= szTemp
					else
						iNumFooter=iNumFooter+1
						szFooter(iNumFooter)=szTemp
					end if
					szSpaceAdjust=space(len(szTemp))
					bFrist=True
					while Not ResultSet.Eof
						if bFrist then
							szFooter(iNumFooter)=szFooter(iNumFooter) & ResultSet.Fields(0)
							bFrist=False
						else
							szFooter(iNumFooter)=szSpaceAdjust & ResultSet.Fields(0)
						end if
						ResultSet.MoveNext
						if Not ResultSet.Eof then szFooter(iNumFooter)=szFooter(iNumFooter) & "," & vbcrlf
					wend
				end if
			End if
		End if

		'Owner
		szIstr="select u.usename as Owner from pg_class c ,pg_user u where c.relname='" & szName & "' And c.relowner = u.usesysid"
		App.Data.ConDb.Execute szIstr
		if App.Data.ConDb.NumRow > 0 then
			iNumFooter=iNumFooter+2
			szFooter(iNumFooter)="Owner relation: " & App.Data.ConDb.ResultSet("Owner")
		end if

		redim preserve szCells(ubound(szCells,1),iCols)
		redim preserve szHeaders(iCols)
		redim preserve szFooter(iNumFooter)
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultNoSQL szTitle,szHeaders,szCells,szFooter
	End Sub

	'\da
    Public Sub DescribeAggregates(szName)
	Dim szIstr

		szIstr="SELECT a.aggname AS ""Name""," & vbcrlf
		szIstr=szIstr & "  CASE a.aggbasetype" & vbcrlf
		szIstr=szIstr & "    WHEN 0 THEN CAST('(all types)' AS text)" & vbcrlf
		szIstr=szIstr & "    ELSE format_type(a.aggbasetype, NULL)" & vbcrlf
		szIstr=szIstr & "  END AS ""Data type""," & vbcrlf
		szIstr=szIstr & "  obj_description(a.oid, 'pg_aggregate') as ""Description""" & vbcrlf
		szIstr=szIstr & "FROM pg_aggregate a" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " WHERE a.aggname ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1, 2"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of aggregate functions"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub

	'\df
    Public Sub DescribeFunctions(szName)
	Dim szIstr

		szIstr="SELECT format_type(p.prorettype, NULL) as ""Result data type""," & vbcrlf
		szIstr=szIstr & "  p.proname as ""Name""," & vbcrlf
		szIstr=szIstr & "  oidvectortypes(p.proargtypes) as ""Argument data types""" & vbcrlf
		szIstr=szIstr & "FROM pg_proc p" & vbcrlf
		szIstr=szIstr & "WHERE p.prorettype <> 0 AND (pronargs = 0 OR oidvectortypes(p.proargtypes) <> '')" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " AND p.proname ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 2, 1, 3"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of functions"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub

	'\dT
    Public Sub DescribeTypes(szName)
	Dim szIstr

		szIstr=szIstr & "SELECT format_type(t.oid, NULL) AS ""Name""," & vbcrlf
		szIstr=szIstr & "  obj_description(t.oid, 'pg_type') as ""Description""" & vbcrlf
		szIstr=szIstr & "FROM pg_type t" & vbcrlf
		szIstr=szIstr & "WHERE t.typrelid = 0 AND t.typname !~ '^_.*'" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " AND (format_type(t.oid, NULL) ~ '^" & szName & "' OR t.typname ~ '^" & szName & "')" & vbcrlf
		szIstr=szIstr & "ORDER BY 1" & vbcrlf

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of data types"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub
	
	'\do 
    Public Sub DescribeOperators(szName)
	Dim szIstr

		szIstr="SELECT o.oprname AS ""Name""," & vbcrlf
		szIstr=szIstr & "  CASE WHEN o.oprkind='l' THEN NULL ELSE format_type(o.oprleft, NULL) END AS ""Left arg type""," & vbcrlf
  		szIstr=szIstr & "CASE WHEN o.oprkind='r' THEN NULL ELSE format_type(o.oprright, NULL) END AS ""Right arg type""," & vbcrlf
  		szIstr=szIstr & "format_type(o.oprresult, NULL) AS ""Result type""," & vbcrlf
  		szIstr=szIstr & "obj_description(o.oprcode, 'pg_proc') AS ""Description""" & vbcrlf
		szIstr=szIstr & "FROM pg_operator o" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " WHERE o.oprname = '" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1, 2, 3, 4"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of operators"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub

	'\du
    Public Sub DescribeUsers(szName)
	Dim szIstr

		szIstr="SELECT u.usename AS ""User name""," & vbcrlf
		szIstr=szIstr & "  u.usesysid AS ""User ID""," & vbcrlf
		szIstr=szIstr & "  CASE WHEN u.usesuper AND u.usecreatedb THEN CAST('superuser, create database' AS text)" & vbcrlf
		szIstr=szIstr & "       WHEN u.usesuper THEN CAST('superuser' AS text)" & vbcrlf
		szIstr=szIstr & "       WHEN u.usecreatedb THEN CAST('create database' AS text)" & vbcrlf
		szIstr=szIstr & "       ELSE CAST('' AS text)" & vbcrlf
		szIstr=szIstr & "  END AS ""Attributes""" & vbcrlf
		szIstr=szIstr & "FROM pg_user u" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " WHERE u.usename ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of database users"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub

	'\dg
    Public Sub DescribeGroups(szName)
	Dim szIstr,szTitle,szHeaders(2),szCells,iRow,ResultSet,szTemp,vData,ii,szFooter

		szTitle="List of database group"

		szHeaders(0)="Group Name"
		szHeaders(1)="Group Id"
		szHeaders(2)="User Name"

		szIstr="SELECT groname,grosysid,grolist FROM pg_group g" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " WHERE u.groname ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1"
		App.Data.ConDb.Execute szIstr
		iRow=App.Data.ConDb.Numrow

		if iRow > 0 then
			set ResultSet=App.Data.ConDb.ResultSet

			'Calcuate the numer of element mat
			iRow=0
			While Not ResultSet.Eof
				szTemp=ResultSet("grolist")
				szTemp=replace(szTemp,"{","")
				szTemp=replace(szTemp,"}","")
				vData=split(szTemp,",")

				iRow=iRow+1+ubound(vdata)+1
				ResultSet.MoveNext
			Wend 
			Redim szCells(Irow-1,2)

			ResultSet.MoveFirst
			iRow=0		
			While Not ResultSet.Eof
				szCells(iRow,0)=ResultSet("groname")
				szCells(iRow,1)=ResultSet("grosysid")

				szTemp=ResultSet("grolist")
				szTemp=replace(szTemp,"{","")
				szTemp=replace(szTemp,"}","")
				vData=split(szTemp,",")

				for ii=0 to ubound(vData)
					App.Data.ConDb.Execute "select usename from pg_user where usesysid=" & vdata(ii)
					if App.Data.ConDb.Numrow > 0 then 
						iRow=iRow+1
						szCells(iRow,2)=App.Data.ConDb.ResultSet("usename")
					end if
				next

				iRow=iRow+1
				ResultSet.MoveNext
			Wend
		else	
			redim szCells(-1,2)
			irow=0
		end if

		'Footer
		redim szFooter(0)
		szFooter(0)=App.Data.Message.Row(irow)

		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultNoSQL szTitle,szHeaders,szCells,szFooter
	End Sub

	'\z (or \dp)
    Public Sub PermissionsList(szName)
	Dim szIstr

		szIstr="SELECT relname as ""Table""," & vbcrlf
		szIstr=szIstr & "       relacl as ""Access privileges""" & vbcrlf
		szIstr=szIstr & "FROM   pg_class" & vbcrlf
		szIstr=szIstr & "WHERE  relkind in ('r', 'v', 'S') AND" & vbcrlf
		szIstr=szIstr & "       relname NOT LIKE 'pg$_%' ESCAPE '$'" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " AND relname ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1" 

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="Access privileges for current database"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub

	'\dd
    Public Sub ObjectDescription(szName)
	Dim szIstr

		szIstr="SELECT DISTINCT tt.name AS ""Name"", tt.object AS ""Object"", d.description AS ""Description""" & vbcrlf
		szIstr=szIstr & "FROM (" & vbcrlf
		szIstr=szIstr & "  SELECT a.oid as oid, a.tableoid as tableoid," & vbcrlf
		szIstr=szIstr & "  CAST(a.aggname AS text) as name, CAST('aggregate' AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_aggregate a" & vbcrlf
		szIstr=szIstr & "UNION ALL" & vbcrlf
		szIstr=szIstr & "  SELECT p.oid as oid, p.tableoid as tableoid," & vbcrlf
		szIstr=szIstr & "  CAST(p.proname AS text) as name, CAST('function' AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_proc p" & vbcrlf
		szIstr=szIstr & "  WHERE p.pronargs = 0 or oidvectortypes(p.proargtypes) <> ''" & vbcrlf
		szIstr=szIstr & "UNION ALL" & vbcrlf
		szIstr=szIstr & "  SELECT RegprocToOid(o.oprcode) as oid," & vbcrlf
		szIstr=szIstr & "  (SELECT oid FROM pg_class WHERE relname = 'pg_proc') as tableoid," & vbcrlf
		szIstr=szIstr & "  CAST(o.oprname AS text) as name, CAST('operator' AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_operator o" & vbcrlf
		szIstr=szIstr & "UNION ALL" & vbcrlf
		szIstr=szIstr & "  SELECT t.oid as oid, t.tableoid as tableoid," & vbcrlf
		szIstr=szIstr & "  format_type(t.oid, NULL) as name, CAST('data type' AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_type t" & vbcrlf
		szIstr=szIstr & "UNION ALL" & vbcrlf
		szIstr=szIstr & "  SELECT c.oid as oid, c.tableoid as tableoid," & vbcrlf
		szIstr=szIstr & "  CAST(c.relname AS text) as name," & vbcrlf
		szIstr=szIstr & "  CAST(" & vbcrlf
		szIstr=szIstr & "    CASE c.relkind WHEN 'r' THEN 'table' WHEN 'v' THEN 'view' WHEN 'i' THEN 'index' WHEN 'S' THEN 'sequence' END  AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_class c" & vbcrlf
		szIstr=szIstr & "UNION ALL" & vbcrlf
		szIstr=szIstr & "  SELECT r.oid as oid, r.tableoid as tableoid," & vbcrlf
		szIstr=szIstr & "  CAST(r.rulename AS text) as name, CAST('rule' AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_rewrite r" & vbcrlf
		szIstr=szIstr & "  WHERE r.rulename !~ '^_RET'" & vbcrlf
		szIstr=szIstr & "UNION ALL" & vbcrlf
		szIstr=szIstr & "  SELECT t.oid as oid, t.tableoid as tableoid," & vbcrlf
		szIstr=szIstr & "  CAST(t.tgname AS text) as name, CAST('trigger' AS text) as object" & vbcrlf
		szIstr=szIstr & "  FROM pg_trigger t" & vbcrlf
		szIstr=szIstr & ") AS tt," & vbcrlf
		szIstr=szIstr & "pg_description d" & vbcrlf
		szIstr=szIstr & "WHERE tt.oid = d.objoid and tt.tableoid = d.classoid and d.objsubid = 0" & vbcrlf
		if len(trim(szName)) > 0 Then szIstr=szIstr & " AND tt.name ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="Object descriptions"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub

	'\dt, \di, \ds, \dS, etc.
    Public Sub ListTables(szName,InfoType)
	Dim szIstr

		szIstr="SELECT c.relname as ""Name""," & vbcrlf
		szIstr=szIstr & "  CASE c.relkind WHEN 'r' THEN 'table' WHEN 'v' THEN 'view' WHEN 'i' THEN 'index'" & vbcrlf
		szIstr=szIstr & " WHEN 'S' THEN 'sequence' WHEN 's' THEN 'special' END as ""Type""," & vbcrlf
		szIstr=szIstr & "  u.usename as ""Owner""" & vbcrlf
		szIstr=szIstr & "FROM pg_class c LEFT JOIN pg_user u ON c.relowner = u.usesysid" & vbcrlf
		if InfoType =0 then
			szIstr=szIstr & "WHERE c.relkind IN ('r','v','S','')" & vbcrlf
		elseif InfoType =1 then
			'Table
			szIstr=szIstr & "WHERE c.relkind IN ('r','')" & vbcrlf
		elseif InfoType =2 then
			'Index
			szIstr=szIstr & "WHERE c.relkind IN ('i','')" & vbcrlf
		elseif InfoType =3 then
			'Sequence
			szIstr=szIstr & "WHERE c.relkind IN ('S','')" & vbcrlf
		elseif InfoType =4 then
			'View
			szIstr=szIstr & "WHERE c.relkind IN ('v','')" & vbcrlf
		elseif InfoType =5 then
			szIstr=szIstr & "WHERE c.relkind IN ('r','v','S','s','')" & vbcrlf
		end if
		if InfoType=5 then
			szIstr=szIstr & "  AND c.relname ~ '^pg_'" & vbcrlf
		else
			szIstr=szIstr & "  AND c.relname !~ '^pg_'" & vbcrlf
		end if
		if len(trim(szName)) > 0 Then szIstr=szIstr & " AND c.relname ~ '^" & szName & "'" & vbcrlf
		szIstr=szIstr & "ORDER BY 1"

		App.Data.ConDb.Execute szIstr
		App.Data.Print.Title="List of relations"
		App.Data.Print.DisplayNumRow=True
		App.Data.Print.PrintResultSQL
	End Sub
End Class
