.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "REINDEX" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
REINDEX \- rebuild indexes

.SH SYNOPSIS
.sp
.nf
REINDEX { INDEX | TABLE | DATABASE | SYSTEM } \fIname\fR [ FORCE ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBREINDEX\fR rebuilds an index using the data
stored in the index's table, replacing the old copy of the index. There are
several scenarios in which to use \fBREINDEX\fR:
.TP 0.2i
\(bu
An index has become corrupted, and no longer contains valid
data. Although in theory this should never happen, in
practice indexes can become corrupted due to software bugs or
hardware failures. \fBREINDEX\fR provides a
recovery method.
.TP 0.2i
\(bu
An index has become ``bloated'', that it is contains many
empty or nearly-empty pages. This can occur with B-tree indexes in
PostgreSQL under certain uncommon access
patterns. \fBREINDEX\fR provides a way to reduce
the space consumption of the index by writing a new version of
the index without the dead pages. See in the documentation for more information.
.TP 0.2i
\(bu
You have altered a storage parameter (such as fillfactor)
for an index, and wish to ensure that the change has taken full effect.
.TP 0.2i
\(bu
An index build with the CONCURRENTLY option failed, leaving
an ``invalid'' index. Such indexes are useless but it can be
convenient to use \fBREINDEX\fR to rebuild them. Note that
\fBREINDEX\fR will not perform a concurrent build. To build the
index without interfering with production you should drop the index and
reissue the \fBCREATE INDEX CONCURRENTLY\fR command.
.PP
.SH "PARAMETERS"
.TP
\fBINDEX\fR
Recreate the specified index.
.TP
\fBTABLE\fR
Recreate all indexes of the specified table. If the table has a
secondary ``TOAST'' table, that is reindexed as well.
.TP
\fBDATABASE\fR
Recreate all indexes within the current database.
Indexes on shared system catalogs are skipped except in stand-alone mode
(see below). This form of \fBREINDEX\fR cannot be executed 
inside a transaction block.
.TP
\fBSYSTEM\fR
Recreate all indexes on system catalogs within the current database.
Indexes on user tables are not processed. Also, indexes on shared
system catalogs are skipped except in stand-alone mode (see below).
This form of \fBREINDEX\fR cannot be executed inside a
transaction block.
.TP
\fB\fIname\fB\fR
The name of the specific index, table, or database to be
reindexed. Index and table names can be schema-qualified.
Presently, \fBREINDEX DATABASE\fR and \fBREINDEX SYSTEM\fR
can only reindex the current database, so their parameter must match
the current database's name. 
.TP
\fBFORCE\fR
This is an obsolete option; it is ignored if specified.
.SH "NOTES"
.PP
If you suspect corruption of an index on a user table, you can
simply rebuild that index, or all indexes on the table, using
\fBREINDEX INDEX\fR or \fBREINDEX TABLE\fR. 
.PP
Things are more difficult if you need to recover from corruption of
an index on a system table. In this case it's important for the
system to not have used any of the suspect indexes itself.
(Indeed, in this sort of scenario you might find that server
processes are crashing immediately at start-up, due to reliance on
the corrupted indexes.) To recover safely, the server must be started
with the \fB-P\fR option, which prevents it from using
indexes for system catalog lookups.
.PP
One way to do this is to shut down the server and start a single-user
PostgreSQL server
with the \fB-P\fR option included on its command line.
Then, \fBREINDEX DATABASE\fR, \fBREINDEX SYSTEM\fR,
\fBREINDEX TABLE\fR, or \fBREINDEX INDEX\fR can be
issued, depending on how much you want to reconstruct. If in
doubt, use \fBREINDEX SYSTEM\fR to select
reconstruction of all system indexes in the database. Then quit
the single-user server session and restart the regular server.
See the \fBpostgres\fR(1) reference page for more
information about how to interact with the single-user server
interface.
.PP
Alternatively, a regular server session can be started with
\fB-P\fR included in its command line options.
The method for doing this varies across clients, but in all
\fBlibpq\fR-based clients, it is possible to set
the \fBPGOPTIONS\fR environment variable to -P
before starting the client. Note that while this method does not
require locking out other clients, it might still be wise to prevent
other users from connecting to the damaged database until repairs
have been completed.
.PP
If corruption is suspected in the indexes of any of the shared
system catalogs (which are \fBpg_authid\fR,
\fBpg_auth_members\fR,
\fBpg_database\fR,
\fBpg_pltemplate\fR,
\fBpg_shdepend\fR,
\fBpg_shdescription\fR, and
\fBpg_tablespace\fR), then a standalone server
must be used to repair it. \fBREINDEX\fR will not process
shared catalogs in multiuser mode.
.PP
For all indexes except the shared system catalogs, \fBREINDEX\fR
is crash-safe and transaction-safe. \fBREINDEX\fR is not
crash-safe for shared indexes, which is why this case is disallowed
during normal operation. If a failure occurs while reindexing one
of these catalogs in standalone mode, it will not be possible to
restart the regular server until the problem is rectified. (The
typical symptom of a partially rebuilt shared index is ``index is not
a btree'' errors.)
.PP
\fBREINDEX\fR is similar to a drop and recreate of the index
in that the index contents are rebuilt from scratch. However, the locking
considerations are rather different. \fBREINDEX\fR locks out writes
but not reads of the index's parent table. It also takes an exclusive lock
on the specific index being processed, which will block reads that attempt
to use that index. In contrast, \fBDROP INDEX\fR momentarily takes
exclusive lock on the parent table, blocking both writes and reads. The
subsequent \fBCREATE INDEX\fR locks out writes but not reads; since
the index is not there, no read will attempt to use it, meaning that there
will be no blocking but reads might be forced into expensive sequential
scans.
.PP
Reindexing a single index or table requires being the owner of that
index or table. Reindexing a database requires being the owner of
the database (note that the owner can therefore rebuild indexes of
tables owned by other users). Of course, superusers can always
reindex anything.
.PP
Prior to PostgreSQL 8.1, \fBREINDEX
DATABASE\fR processed only system indexes, not all indexes as one would
expect from the name. This has been changed to reduce the surprise
factor. The old behavior is available as \fBREINDEX SYSTEM\fR.
.PP
Prior to PostgreSQL 7.4, \fBREINDEX
TABLE\fR did not automatically process TOAST tables, and so those had
to be reindexed by separate commands. This is still possible, but
redundant.
.SH "EXAMPLES"
.PP
Rebuild a single index:
.sp
.nf
REINDEX INDEX my_index;
.sp
.fi
.PP
Rebuild all the indexes on the table my_table:
.sp
.nf
REINDEX TABLE my_table;
.sp
.fi
.PP
Rebuild all indexes in a particular database, without trusting the
system indexes to be valid already:
.sp
.nf
$ \fBexport PGOPTIONS="-P"\fR
$ \fBpsql broken_db\fR
...
broken_db=> REINDEX DATABASE broken_db;
broken_db=> \\q
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBREINDEX\fR command in the SQL standard.
