#include <time.h>
#include <mem.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

static char * pszMonth[12] = { "Jan", "Fev", "Mar", "Apr", "May",
			       "Jun", "Jul", "Aug", "Sep", "Oct",
			       "Nov", "Dec" };

/* This function returns the numbers of seconds since January, 1st 1970 */
time_t DATE_hms(char * pszDate)
{
	struct tm tTmTime;
	int	  index;

	memset (&tTmTime, 0, sizeof (struct tm));

	/* Day */
	if( pszDate[0] == ' ' )
		tTmTime.tm_mday = atoi (pszDate + 1);
	else
		tTmTime.tm_mday = atoi (pszDate);

	/* Month */
	for (index = 0; index < 12; index++)
	{
		if( ! strncmp (pszDate + 3, pszMonth[index], 3) )
		{
			tTmTime.tm_mon = index;
			break;
		}
	} /* End FOR */

	/* Year */
	tTmTime.tm_year = atoi	(pszDate + 9);

	return (mktime (&tTmTime));
}

/*------------------------------------------------------------------------
  ------ Convert an unsigned long to date / time -------------------------
  ----------------------------------------------------------------------*/
/* This fonction is straight from DxNet */
void DATE_dateTime_Long2Str(char * Date, char * Time, unsigned long DateTime)
{
	int 	nVal1;
	int	nVal2;

	/*
	bits	Means
	0-4	day
	5-8	month
	9-15    Year - 1980
	16-20	Seconds / 2 (not in use with DxNet)
	21-26	Minutes
	27-31	Hours (0 to 23)
	*/

	/* Hours */
	nVal1 = (unsigned int) (DateTime / 134217728L);
	DateTime = DateTime % 134217728L;

	/* Minutes */
	nVal2 = (unsigned int) (DateTime / 2097152L);
	DateTime = DateTime % 2097152L;

	/* Make the Time string */
	sprintf(Time, "%02d%02d", nVal1, nVal2);

	/* Year */
	nVal1 = (unsigned int) (DateTime / 512L);
	nVal1 = nVal1 + 1980;
	DateTime = DateTime % 512L;

	/* Month */
	nVal2 = (unsigned int) (DateTime / 32L);
	DateTime = DateTime % 32L;

	/* Make the Date string */
	sprintf(Date, "%2d-%3s-%4d", (unsigned int) DateTime,
				     pszMonth[nVal2],
				     nVal1);
}
