/*
 * This file is used to configure the locations of essential files required
 * by ax25-utils. It is modified by the 'configure' script, but once created
 * the file config.h may be edited by hand to fit in with non-standard
 * systems.
 */

#ifndef	CONFIG_H
#define	CONFIG_H

/*
 * Some global #defines for programmers to use for conditional compilation
 */
#define HAVEAX25
#define HAVEROSE
#define HAVENETROM


/*
 * The /proc filesystem entries
 */
#define	PROC_AX25_FILE		"/proc/net/ax25"
#define	PROC_AX25_CALLS_FILE	"/proc/net/ax25_calls"
#define	PROC_AX25_ROUTE_FILE	"/proc/net/ax25_route"

#define	PROC_NR_FILE		"/proc/net/nr"
#define	PROC_NR_NEIGH_FILE	"/proc/net/nr_neigh"
#define	PROC_NR_NODES_FILE	"/proc/net/nr_nodes"

#define PROC_RS_FILE		"/proc/net/rose"
#define PROC_RS_NEIGH_FILE	"/proc/net/rose_neigh"
#define PROC_RS_NODES_FILE	"/proc/net/rose_nodes"
#define PROC_RS_ROUTES_FILE	"/proc/net/rose_routes"

#define	PROC_IP_ROUTE_FILE	"/proc/net/route"

#define PROC_AX25_SYSCTL_DIR	"/proc/sys/net/ax25"
#define PROC_NR_SYSCTL_DIR	"/proc/sys/net/netrom"
#define PROC_RS_SYSCTL_DIR	"/proc/sys/net/rose"

/*
 * THE configuration files
 */
#define	CONF_AXPORTS_FILE	"/etc/ax25/axports"
#define	CONF_NRPORTS_FILE	"/etc/ax25/nrports"
#define	CONF_RSPORTS_FILE	"/etc/ax25/rsports"

/*
 * ax25d specific
 */
#define	CONF_AX25D_FILE		"/etc/ax25/ax25d.conf"

/*
 * ax25ipd specific
 */
#define	CONF_AX25IPD_FILE	"/etc/ax25/ax25ipd.conf"

/*
 * ax25routed specific
 */
#define	CONF_AX25ROUTED_FILE		"/etc/ax25/ax25rtd.conf"
#define	DATA_AX25ROUTED_CTL_SOCK	"/var/ax25/ax25rtd/control"
#define	DATA_AX25ROUTED_AXRT_FILE	"/var/ax25/ax25rtd/ax25_route"
#define	DATA_AX25ROUTED_IPRT_FILE	"/var/ax25/ax25rtd/ip_route"

/*
 * axspawn specific
 */
#define	CONF_AXSPAWN_FILE	"/etc/ax25/axspawn.conf"
#define	CONF_AXSPAWN_PROF_FILE	"/etc/ax25/ax25.profile"
#define	LOCK_AXSPAWN_FILE	"/var/lock/axspawn"

/*
 * mheard specific
 */
#define	DATA_MHEARD_FILE	"/var/ax25/mheard/mheard.dat"

/*
 * rip98d specific
 */
#define	CONF_RIP98D_FILE	"/etc/ax25/rip98.conf"

/*
 * rxecho specific
 */
#define	CONF_RXECHO_FILE	"/etc/ax25/rxecho.conf"

/*
 * netromd specific
 */
#define	CONF_NETROMD_FILE	"/etc/ax25/nrbroadcast"

/*
 * node specific
 */
#define	CONF_NODE_FILE		"/etc/ax25/node.conf"
#define	CONF_NODE_PERMS_FILE	"/etc/ax25/node.perms"
#define	CONF_NODE_MOTD_FILE	"/etc/ax25/node.motd"
#define	CONF_NODE_INFO_FILE	"/etc/ax25/node.info"
#define	DATA_NODE_LOGIN_FILE	"/var/ax25/node/loggedin"
#define	DATA_NODE_HELP_DIR	"/usr/lib/ax25/node/help/"

/*
 * pms specific
 */
#define	CONF_PMS_INFO_FILE	"/etc/ax25/pms.info"
#define	CONF_PMS_MOTD_FILE	"/etc/ax25/pms.motd"
#define	DATA_PMS_LOGIN_FILE	"/var/ax25/pms/loggedin"
#define	DATA_PMS_USERS_FILE	"/var/ax25/pms/users"
#define	DATA_PMS_HEAD_FILE	"/var/ax25/pms/msg.head"
#define	DATA_PMS_BODY_FILE	"/var/ax25/pms/msg.body"
#define	DATA_PMS_TALK_FILE	"/var/ax25/pms/talk.pm/pipe.%d"
#define	MAIL_DELIVERY_AGENT	"/usr/sbin/sendmail %s"
/* #define MY_GATEWAY           "hostname.mail.gw" */
#define	MY_TALK			"/usr/sbin/ttylinkd"

/*
 * ttylinkd specific
 */
#define	CONF_TTYLINKD_FILE	"/etc/ax25/ttylinkd.conf"

/*
 * Location of serial port lock files
 */
#define	LOCK_SERIAL_DIR		"/var/lock"

#endif
