/****************************************************************************
*                                                                           *
*  This program is a template that can used for building client programs    *
*  for PREDICT.  This program functions sends a data request to the server  *
*  (the machine on which PREDICT is running in server mode), and retrieves  *
*  the response from the server.  The sscanf function is used to parse the  *
*  response from the server.                                                *
*                                                                           *
*  This program takes two arguments.  The first is the hostname of          *
*  the server, and the second is the satellite name.  For example:          *
*                                                                           *
*                    demo localhost OSCAR-10                                *
*                                                                           *
*  If the satellite name contains spaces, enclose the name in "quotes".     *
*                                                                           *
*****************************************************************************
*                                                                           *
* This program was written by Ivan Galysh, KD4HBO on January 24, 2000.      *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.                                                                  *
*                                                                           *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.                                                         *
*                                                                           *
*****************************************************************************
* Some additions/changes made by John A. Magliacane, KD2BD on 26-Mar-2000   *
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <errno.h>
#include <arpa/inet.h>

void handler()
{
	/* This is a function that is called when the response function
	   times out.  This is in case the server fails to respond. */

	signal(SIGALRM,handler);
}


int connectsock(char *host, char *service, char *protocol)
{
	/* This function is used to connect to the server.  "host" is the
	   name host is the name of the computer the server program resides
	   on.  "service" is the name of the socket port.  "protocol" is the
	   socket protocol.  It should be set to UDP. */

	struct hostent *phe;
	struct servent *pse;
	struct protoent *ppe;
	struct sockaddr_in sin;
	
	int s, type;
	
	bzero((char *)&sin,sizeof(struct sockaddr_in));
	sin.sin_family=AF_INET;
	
	if ((pse=getservbyname(service,protocol)))
		sin.sin_port=pse->s_port;

	else if ((sin.sin_port=htons((unsigned short)atoi(service)))==0)
	{
		printf("Can't get services\n");
		return -1;
	}

	if ((phe=gethostbyname(host)))
		bcopy(phe->h_addr,(char *)&sin.sin_addr,phe->h_length);

	else if ((sin.sin_addr.s_addr=inet_addr(host))==INADDR_NONE)
	{
		printf("Can't get host.\n");
		return -1;
	}
	
	if ((ppe=getprotobyname(protocol))==0)
		return -1;

	if (strcmp(protocol,"udp")==0)
		type=SOCK_DGRAM;
	else
		type=SOCK_STREAM;
	
	s=socket(PF_INET,type,ppe->p_proto);

	if (s<0)
	{
		printf("Can't get socket.\n");
		return -1;
	}

	if (connect(s,(struct sockaddr *)&sin,sizeof(sin))<0)
	{
		printf("Can't connect to socket.\n");
		return -1;
	}

	return s;
}


void get_response(int sock, char *buf)
{
	/* This function gets a response from the server in string format. */

	int n;
	alarm(10); 
	n=read(sock,buf,256);

	if (errno==EINTR)
		return;

	if (n<0)
	{
		alarm(0); 
		return;
	}
	
	buf[n]='\0';
	alarm(0); 
}


int main (int argc, char *argv[])
{
	/********************************************************
 	 * argv[1] specifies the name of the server (localhost) *
	 * argv[2] specifies the name of the satellite          *
	 *                                                      *
	 * See the README file for an explanation of the socket *
	 *  commands interpreted by PREDICT in this release.    *
	 ********************************************************/

	int x, y, sk;
	char buf[128];
	char satname[26];
	long aostime;
	float az, el, slong, slat, footprint;
	time_t t;

	if (argc==3)
	{
		/* Open a network socket */
		sk=connectsock(argv[1],"predict","udp");

		if (sk<0)
			exit(-1);

		/* Build a command buffer */
		sprintf(buf,"GET_SAT %s\n",argv[2]);

		/* Send the command to the server */
   		write(sk,buf,strlen(buf));

		/* Get the response */
   		get_response(sk,buf);

		/* Close the connection */
   		close(sk);

		printf("\nPREDICT returned the following string in response to GET_SAT %s:\n\n%s\n",argv[2],buf);

		/* Parse the response */

		/* The first element of the response is the satellite name.
		   It is ended with a '\n' character and many contain spaces. */

		for (x=0; buf[x]!='\n'; x++)
			satname[x]=buf[x];

		satname[x]=0;
		x++;

		/* The rest of the data can be parsed using the sscanf()
		   function.  First, the satellite name is removed from
		   "buf", and then "buf" is parsed for numerical data
		   using an sscanf(). */

		for (y=0; buf[x+y]!=0; y++)
			buf[y]=buf[x+y];

		buf[y]=0;
 
		sscanf(buf,"%f %f %f %f %ld %f",&slong,&slat,&az,&el,&aostime,&footprint);

		t=(time_t)aostime;
		
		printf("Values are as follows:\nName: %s\nLong: %7.2f\nLat: %7.2f\nAz: %7.2f\nEl: %+-6.2f\nNext AOS: %ld = %sFootprint: %7.2f\n\n",satname,slong,slat,az,el,aostime,asctime(gmtime(&t)),footprint);

	}

	else
		printf("Use: demo system_name satellite_name\n");

	exit(0);
}
