#!/bin/bash
#
#   This is the LBBS upgrade and install script.  It *WILL* probably be
#      broken very often.
#
#

cat <<!EOF!
This is the LBBS upgrade and install script.  It *WILL* probably be
broken very often.                                            - dlm

!EOF!

if [ -d /usr/lbbs ]
then
   cat <<!EOF!
It appears you (might) already have a version of LBBS installed, it is
IMPORTANT you backup all of your existing setup just in case this script
deletes/overwrites anything you did not want it to.

Please back your LBBS setup with:

tar -c -v -f - /usr/lbbs | gzip >/usr/LBBS-backup.tar.gz

Do you wish to continue? [y]
!EOF!

   read ANS

   if [ "$ANS" = "n" ] || [ "$ANS" = "no" ]
   then
      echo "Exiting..."
      exit 1
   fi
fi

if [ $UID -ne 0 ]
then
   echo "This scripts needs to be run as root (uid = 0)"
   echo "Please feel free to check over the script before running"
   exit 1
fi

if ! grep -s "^lbbs:" /etc/group
then
   echo "Adding system group id for 'lbbs'"
   groupadd lbbs || exit 1
fi

if ! grep -s "^lbbs:" /etc/passwd
then
   echo "Adding system user id for 'lbbs'"
   useradd -g lbbs -d /usr/lbbs lbbs || exit 1
fi

if [ ! -d /usr/lbbs ]
then
   echo "Creating '/usr/lbbs' directory"
   mkdir -p /usr/lbbs || exit 1
   chown lbbs.lbbs /usr/lbbs
   chmod 0775 /usr/lbbs
   upgrade=0
else
   upgrade=1
fi

echo "Check intergrity of the package..."
missing=0
for i in `cat Manifest`
do
   if [ ! -e $i ]
   then
      missing=1
      echo
      echo "File missing from archive: $I"
   else
      echo -n "."
   fi
done

if [ $missing -eq 1 ]
then
   echo "It appears you have some files missing."
   echo "You should have extracted the archive in a clean directory and run this"
   echo "script without modifiying any."
   exit 1
fi

if [ $upgrade -eq 0 ]
then
   # Fresh...
   tar -c -f - `cat Manifest` | (cd /usr/lbbs; tar -x -v -f -)
else
   # Upgrade...
   tar -c -f - `cat Manifest | grep -v "^etc/" | grep -v "^spool/"` |
    (cd /usr/lbbs; tar -x -v -f -)
fi

echo "I hope the install was sucessfull"

exit 0
