#!/bin/bash
#
#   Simply remove old 7plus part from the dirs.  A crontab would usually
#    run this.
#
StoreDir="/usr/lbbs/contrib/7plus-rx/7plus"
BuildDir="/usr/lbbs/contrib/7plus-rx/7plus-all"

if [ $UID -eq 0 ]
then
   echo "$0: Don't run me as root, I don't trust myself, run me with:"
   echo "        su lbbs -c $0"
   exit 1
fi


if [ -d ${StoreDir} ]
then
   # We keep things for 30 days, then they go.
   find ${StoreDir} -type f -mtime +30 -exec rm -f {} ';'
fi

if [ -d ${BuildDir} ]
then
   # We keep things for 30 days, then they go.
   find ${BuildDir} -type f -mtime +30 -exec rm -f {} ';'
fi
