#!/usr/bin/perl
#
#   May 1995 - Copyright (C) Darryl L. Miles G7LED
#
#
#   This simply scans the $StoreDir for parts, if it finds ALL parts they
#    get copied to $BuildDir.  At the moment as my 7plus decoding utility
#    just crashes (and I personally make very little use out of it) I
#    haven't done anything to autodecode, to verify/check CRCs etc...
#
#   But *another* script could go in and copy (move) all files found to an
#    FTPable area.  I really want to decode them and move the decoded file
#    to the FTP area, and also allow it to be gated to a binary newsgroup or
#    mailing-list but uucoded!
#
#   Loadsa possibilities.
#
#
$StoreDir = '/usr/lbbs/contrib/7plus-rx/7plus';
$BuildDir = '/usr/lbbs/contrib/7plus-rx/7plus-all';

chdir($StoreDir) || die "Unable to chdir to $StoreDir\n";

opendir(DIR, $StoreDir);

Loop:
while($fname = readdir(DIR)) {
   if(($fname eq ".") || ($fname eq "..")) {
      next;
   }
   $fname =~ /(.*)\.\d+of\d+/;
   $n = $1;

   foreach $i (@List) {
      if($i eq $n) {
         next Loop;
      }
   }
   
   push(@List, $n);
}

closedir(DIR);

Another:
foreach $i (@List) {
   $sum = 0;
   undef $parts;
   
   opendir(DIR, $StoreDir);
   
   while($fname = readdir(DIR)) {
      if(($fname eq ".") || ($fname eq "..")) {
         next;
      }

      $fname =~ /(.*)\.(\d+)of(\d+)/;
      
      if($i ne $1) {
         next;
      }
      
      if($sum == 0) {
         $sum = $3;
      }
      
      $parts[$2] = 1;
   }
   
   closedir(DIR);
   
   for($n = 1; $n <= $sum; $n++) {
      if(!defined($parts[$n])) {
#         print "Not enough parts for $i\n";
         next Another;
      }
   }

   for($n = 1; $n <= $sum; $n++) {
      $fname = sprintf("%s/%s.%03dof%03d", $StoreDir, $i, $n, $sum);
      $i =~ /([^\.]*)/;
      $build = sprintf("%s/%s.p%02x", $BuildDir, $1, $n);
      $build =~ tr/A-Z/a-z/;
      
print "$fname $build\n";
      link($fname, $build);
   }
   print "$i Ready!\n";

}
