#!/usr/bin/perl
#
#   Another Perl script to make a better job of sending news via mail.
#
#   Copyright (C) 1995, Darryl L. Miles, May 1995.
#
#
#  If you want to run it from the Cnews side of things, move the lot to:
#$RootDir="/usr/spool/news/out.mail";
#  If you want to run it out-of-the-box with LBBS installed use:
$RootDir="/usr/lbbs/contrib/newsviamail";
#
$UserCfgDir=$RootDir . "/" . "users";
$LogFile=$RootDir . "/" . "Log";
#
$TmpHdr="/tmp/news-hdr.$$";
$TmpBdy="/tmp/news-bdy.$$";

if(!open(HDR, "+>$TmpHdr")) {
   print "ERROR: Can not create: $TmpHdr\n";
   exit 1;
}

if(!open(BDY, "+>$TmpBdy")) {
   print "ERROR: Can not create: $TmpBdy\n";
   exit 1;
}

$body=0;

while(<>) {
   if($body == 0) {
      if(/^\s*$/) {
         $body=1;
         redo;
      }
      print HDR $_;
   } else {
      print BDY $_;
   }
}

close STDIN;

seek(HDR, 0, 0);
seek(BDY, 0, 0);

$id = &Find("Message-ID");
$from = &Find("From");
$newsgroups = &Find("Newsgroups");

#print "$id\n$from\n$newsgroups\n";

@groups = split(/,/, $newsgroups);


if(!opendir(DIR, $UserCfgDir)) {
   print "ERROR: No directory $UserCfgDir\n";
   exit 1;
}

while($fname = readdir(DIR)) {
#   if($fname =~ /^\.{1,2}$/) {
#      next;
#   }
#
# Watch out, we'll not pick up files no purely made up of alpha-numerical
#  chars (i.e. stop . .. and files ending with a tilde '~' char, mainly for).
   if($fname !~ /^[a-zA-Z0-9]+$/) {
      next;
   }
#   print "File: $fname\n";
   if(!open(USR, $UserCfgDir . "/" . $fname)) {
      print "ERROR: Can not open $UserCfgDir/$fname\n";
      next;
   }
   $sent=0;
   while(<USR>) {
      if($sent == 1) {
         last;
      }
      chop;
      if(/^\s*#/) {
         next;
      }
      if(/^\s*([^\s]+)\s+([^\s]+)\s*/i) {
 #        print "Entry:$_\n";
         $group = $1;
         $addr = $2;

         foreach $tmp (@groups) {
 #           print "Testing:'$tmp' '$group'\n";
            if($group eq $tmp || $tmp =~ /^$group\..+$/) {
               &SendIt($addr);
               &Log($fname, $tmp, $addr);
# Only send them it the once.
               $sent=1;
               last;
            }
         }
      }
   }
   close USR;
}

closedir DIR;

unlink($TmpHdr);
unlink($TmpBdy);
exit 0;


sub Find {
   local($hdr) = $_[0];
   local($found);
   local(*FH);
   
   if(!open(FH, $TmpHdr)) {
      return;
   }

# This method also takes the last (which is correct)   
   while(<FH>) {
      chop;
      if(/^${hdr}:\s+(.+)/i) {
#         print "$hdr\n";
         $found = $1;
      }
   }
   close FH;
   
   $found;
}

sub SendIt {
   local($addr) = $_[0];
   local(*PIPE);
   
   if(!open(PIPE, "| /usr/lib/sendmail $addr")) {
      print "ERROR: Unable to mail article $id to $addr\n";
      return;
   }
   
   print PIPE "To: $addr\n";

   seek(HDR, 0, 0);
   while(<HDR>) {
      print PIPE $_;
   }

   seek(BDY, 0, 0);
   while(<BDY>) {
      print PIPE $_;
   }
      
   close PIPE;

#   print "MATCH\n";   

}

sub Log {
   local($fname) = $_[0];
   local($group) = $_[1];
   local($addr) = $_[2];
   local(*LOG);
   
   if(!open(LOG, ">>$LogFile")) {
      print "ERROR: Unable to log for system $fname mailing to $addr\n";
      return;
   }
   
   ($sec, $min, $hour, $mday, $mon, $year) = localtime(time);
   $mday++;
   $year %= 100;
   
   printf LOG "%02d/%02d/%02d %02d:%02d:%02d %s %s -> %s\n", $mday, $mon, $year,
    $hour, $min, $sec, $fname, $group, $addr;
   
   close LOG;
}
