/*
 *  window.c
 *    Copyright (C) 1996 by Isao SEKI
 *       040796  I.SEKI  Created
 */

#ifdef CURSES

#include <sys/file.h>
#include <sys/ioctl.h>
#include <curses.h>
#include <sgtty.h>
#include <signal.h>
#include "window.h"

void
cnvmkwin()
{
int i;

    ioctl(0, TIOCGWINSZ, (char *) &winsize);
    rows = winsize.ws_row;
    columns = winsize.ws_col;

    if (rows < 24) {
        printf("Sorry, your terminal is poor for this software, Bye\n");
        exit(1);
    }

    initscr();
    clear();
    refresh();
    noecho();
    cbreak();
    signal(SIGINT, die);

    win1 = newwin(rows-10, columns, 0, 0);
    scrollok(win1, TRUE);
    wclear(win1);

    win2 = newwin(9, columns, rows-9, 0);
    scrollok(win2, TRUE);
    wclear(win2);

    line_win = newwin(1, columns, rows-10, 0);
    box(line_win, '-', '-');
    wrefresh(line_win);
}

void
cnvprnwin(ptr, len)
char * ptr;
int len;
{
    int i,x,y;
#if 0
    waddstr(win1, ptr);
    wrefresh(win1);
#endif
    for (i=0; i<len; i++) {
        waddch(win1, *ptr);
        wrefresh(win1);
        getyx(win1, y, x);
        if (y == (rows-11) && x == 0) {
            wclrtoeol(win1);
            wrefresh(win1);
        }
        ptr++;
    }
}

void
cnvreadwin(ptr, len)
char * ptr;
int len;
{
    int i,x,y;

    for (i=0; i<len; i++) {
        waddch(win2, *ptr);
        wrefresh(win2);
        getyx(win2, y, x);
        if (y == 8 && x == 0) {
            wclrtoeol(win2);
            wrefresh(win2);
        }
        ptr++;
    }
}

int
die()
{
    signal(SIGINT, SIG_IGN);
    mvcur(0, rows - 1, columns - 1, 0);
    endwin();
    exit(0);
}
#endif
