/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_file.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/

#include "defs.h"

#define BOX_FILE_G
#include "box_file.h"


#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef CRC_H
#include "crc.h"
#endif

#ifndef BOXBCAST_H
#include "boxbcast.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_SERV_H
#include "box_serv.h"
#endif


Static long startuptime;


void reset_boxruntime(void)
{
  startuptime = sys_ixtime();
  lastwpcreate = startuptime;
  debug0(0, -1, 127);
}


long get_boxruntime_l(void)
{
  if (startuptime > clock_.ixtime)
    startuptime = clock_.ixtime;
  return (clock_.ixtime - startuptime);
}


void get_boxruntime_s(Char *hs)
{
  calc_ixsecs_to_string(get_boxruntime_l(), hs);
}


/* liefert neue Laenge des Files zurueck */

Static long ap_sysfile(short unr, Char *txt, Char *fname)
{
  long Result;
  short x;
  boolean first;
  Char hs[256];
  Char d2[256], t2[256], c2[256];
  Char s[512], w[256], ww[256];
  Char STR7[256];

  Result = 0;
  if (boxrange(unr))
    sprintf(hs, "%.6s", user[unr]->call);
  else if (unr == -2)
    strcpy(hs, "FILTER");
  else if (unr == -3)
    strcpy(hs, "LOOP");
  else if (unr == -4)
    strcpy(hs, "DIRTY");
  else if (unr == -5)
    strcpy(hs, "OLD");
  else if (unr == -6)
    strcpy(hs, "REDIST");
  else
    strcpy(hs, "SYSTEM");
  strcat(hs, ":");
  rspacing(hs, 8);
  utc_clock();
  sprintf(d2, "%.5s", clock_.datum);
  sprintf(t2, "%.8s", clock_.zeit);
  x = unr;
  if (x < 0)
    x = 0;
  sprintf(c2, "%ld", x);
  lspacing(c2, 2);
  if (strlen(txt) < 52) {
    sprintf(w, "%s %s %s %s%s", d2, t2, c2, hs, txt);
    boxprotokoll(w);
    return (append(fname, w, true));
  }
  first = true;
  strcpy(s, txt);
  while (*s != '\0') {
    x = strlen(s);
    if (x > 51) {
      x = 51;
      while (x > 8 && s[x - 1] != ' ')
	x--;
      if (s[x - 1] != ' ')
	x = 51;
    }
    sprintf(w, "%.*s", x, s);
    strdelete((void *)s, 1, x);
    if (first)
      sprintf(ww, "%s %s %s %s", d2, t2, c2, hs);
    else
      strcpy(ww, "                          ");
    sprintf(STR7, "%s%s", ww, w);
    boxprotokoll(STR7);
    sprintf(STR7, "%s%s", ww, w);
    Result = append(fname, STR7, true);
    first = false;
  }
  return Result;
}


void append_profile(short unr, Char *txt)
{
  ap_sysfile(unr, txt, profile_box);
}


void append_readlog(short unr, Char *txt)
{
  Char rlog[256];

  sprintf(rlog, "%sreadlog%cbox", boxprotodir, extsep);
  ap_sysfile(unr, txt, rlog);
}


Static void append_log(short unr, Char *hs)
{
  Char txt[300];

  if (!boxrange(unr))
    return;
  if (user[unr]->smode)
    sprintf(txt, "fileserver: %s", user[unr]->lastcmd);
  else if (*user[unr]->brett != '\0')
    sprintf(txt, "(%s) %s", user[unr]->brett, user[unr]->lastcmd);
  else
    strcpy(txt,user[unr]->lastcmd);
  ap_sysfile(unr, txt, hs);
}


void append_syslog(short unr)
{
  Char hs[256];

  sprintf(hs, "%ssyslog%cbox", boxprotodir, extsep);
  append_log(unr, hs);
}


void append_userlog(short unr)
{
  Char hs[256];

  sprintf(hs, "%suserlog%cbox", boxprotodir, extsep);
  append_log(unr, hs);
}


void append_usersflog(short unr, Char *sender, Char *board, Char *mbx,
		      Char *bid, Char *size)
{
  Char hs[256], txt[256];

  sprintf(txt, "%s@%s <%s", board, mbx, sender);
  if (*bid != '\0')
    sprintf(txt + strlen(txt), " $%s", bid);
  sprintf(txt + strlen(txt), " %s", size);
  del_lastblanks(txt);
  sprintf(hs, "%susrsflog%cbox", boxprotodir, extsep);
  ap_sysfile(unr, txt, hs);
}


void append_protolog(short unr)
{
  Char hs[256];

  sprintf(hs, "%s%s%cPRO", boxprotodir, user[unr]->call, extsep);
  append_log(unr, hs);
}


void append_sflog(short unr)
{
  Char hs[256];

  sprintf(hs, "%ssflog%cbox", boxprotodir, extsep);
  append_log(unr, hs);
}


void append_convlog(short unr, Char *txt)
{
  Char hs[256];

  sprintf(hs, "%sconvlog%cbox", boxprotodir, extsep);
  ap_sysfile(unr, txt, hs);
}


void debug_2(short level, short unr, short pn, Char *txt)
{
  Char hs[256], p[256];
  Char dbold[256];
  short k;

  if (level > debug_level)
    return;
  if (disk_full)
    return;
  switch (pn) {

  case 1:
    strcpy(p, "read_index");
    break;

  case 2:
    strcpy(p, "write_index");
    break;

  case 3:
    strcpy(p, "read_log");
    break;

  case 4:
    strcpy(p, "write_log");
    break;

  case 5:
    strcpy(p, "write_log_and_bid");
    break;

  case 6:
    strcpy(p, "check_mybbsfile");
    break;

  case 7:
    strcpy(p, "show_all_user_at");
    break;

  case 8:
    strcpy(p, "update_mybbsfile");
    break;

  case 9:
    strcpy(p, "load_userfile");
    break;

  case 10:
    strcpy(p, "save_userfile");
    break;

  case 11:
    strcpy(p, "get_bbsinfo");
    break;

  case 12:
    strcpy(p, "check_hpath");
    break;

  case 13:
    strcpy(p, "create_new_boxlog");
    break;

  case 14:
    strcpy(p, "garbage error");
    break;

  case 15:
    strcpy(p, "garbage_collection");
    break;

  case 16:
    strcpy(p, "garbage, board");
    break;

  case 17:
    strcpy(p, "garbage, no mem");
    break;

  case 18:
    strcpy(p, "last_valid");
    break;

  case 19:
    strcpy(p, "alter_log");
    break;

  case 20:
    strcpy(p, "alter_x_and_log_entry");
    break;

  case 21:
    strcpy(p, "recompile_log");
    break;

  case 22:
    strcpy(p, "boxcheck");
    break;

  case 23:
    strcpy(p, "load_rubrikinfos");
    break;

  case 24:
    strcpy(p, "load_balise");
    break;

  case 25:
    strcpy(p, "call_mfilter");
    break;

  case 26:
    strcpy(p, "new_entry");
    break;

  case 27:
    strcpy(p, "transform_boxheader");
    break;

  case 28:
    strcpy(p, "sort_new_mail");
    break;

  case 29:
    strcpy(p, "send_file1");
    break;

  case 30:
    strcpy(p, "send_text3");
    break;

  case 31:
    strcpy(p, "open_sendfile");
    break;

  case 32:
    strcpy(p, "box_txt2");
    break;

  case 33:
    strcpy(p, "send_text1");
    break;

  case 34:
    strcpy(p, "send_check");
    break;

  case 35:
    strcpy(p, "send_sysmsg");
    break;

  case 36:
    strcpy(p, "search_by_bid");
    break;

  case 37:
    strcpy(p, "erase_by_bid");
    break;

  case 38:
    strcpy(p, "set_sys_fwd");
    break;

  case 39:
    strcpy(p, "delete_brett_by_bid");
    break;

  case 40:
    strcpy(p, "erase_brett");
    break;

  case 41:
    strcpy(p, "readlimit");
    break;

  case 42:
    strcpy(p, "read_brett");
    break;

  case 43:
    strcpy(p, "list_brett");
    break;

  case 44:
    strcpy(p, "change_mbx");
    break;

  case 45:
    strcpy(p, "change_lifetime");
    break;

  case 46:
    strcpy(p, "check");
    break;

  case 47:
    strcpy(p, "show_dir");
    break;

  case 48:
    strcpy(p, "show_statistik");
    break;

  case 49:
    strcpy(p, "set_forward");
    break;

  case 50:
    strcpy(p, "transfer");
    break;

  case 51:
    strcpy(p, "export_brett");
    break;

  case 52:
    strcpy(p, "read_for_view");
    break;

  case 53:
    strcpy(p, "read_for_bcast");
    break;

  case 54:
    strcpy(p, "begruessung");
    break;

  case 55:
    strcpy(p, "enter_password");
    break;

  case 56:
    strcpy(p, "analyse_boxcommand");
    break;

  case 57:
    strcpy(p, "run_batch");
    break;

  case 58:
    strcpy(p, "run_sysbatch");
    break;

  case 59:
    strcpy(p, "box_command_fract");
    break;

  case 60:
    strcpy(p, "get_binstart");
    break;

  case 61:
    strcpy(p, "add_line_to_buff");
    break;

  case 62:
    strcpy(p, "write_msgid");
    break;

  case 63:
    strcpy(p, "bid_mem");
    break;

  case 64:
    strcpy(p, "bbspath");
    break;

  case 65:
    strcpy(p, "get_last_bbs");
    break;

  case 66:
    strcpy(p, "scan_for_ack");
    break;

  case 67:
    strcpy(p, "scan_hierarchicals");
    break;

  case 68:
    strcpy(p, "pack_entry");
    break;

  case 69:
    strcpy(p, "kill_resume");
    break;

  case 70:
    strcpy(p, "check_resume");
    break;

  case 71:
    strcpy(p, "send_pfbbram");
    break;

  case 72:
    strcpy(p, "send_pfbbdisk");
    break;

  case 73:
    strcpy(p, "resend_userfile");
    break;

  case 74:
    strcpy(p, "propose_sf");
    break;

  case 75:
    strcpy(p, "change_sfentries");
    break;

  case 76:
    strcpy(p, "received_sf");
    break;

  case 77:
    strcpy(p, "ok_sf_sending");
    break;

  case 78:
    strcpy(p, "prepare_for_next_fbb");
    break;

  case 79:
    strcpy(p, "send_fbb_answer");
    break;

  case 80:
    strcpy(p, "analyse_fbb_answer");
    break;

  case 81:
    strcpy(p, "sf_rx_emt");
    break;

  case 82:
    strcpy(p, "add_bpacksf");
    break;

  case 83:
    strcpy(p, "fbbpack");
    break;

  case 84:
    strcpy(p, "fbb2pack");
    break;

  case 85:
    strcpy(p, "check_frag_sf");
    break;

  case 86:
    strcpy(p, "abort_sf");
    break;

  case 87:
    strcpy(p, "_protokoll");
    break;

  case 88:
    strcpy(p, "start_sf");
    break;

  case 89:
    strcpy(p, "start_modem_sf");
    break;

  case 90:
    strcpy(p, "load_sfinfos");
    break;

  case 91:
    strcpy(p, "vermerke_sf");
    break;

  case 92:
    strcpy(p, "analyse_sf_command");
    break;

  case 93:
    strcpy(p, "show_user");
    break;

  case 94:
    strcpy(p, "change_mybbs");
    break;

  case 95:
    strcpy(p, "change_levels");
    break;

  case 96:
    strcpy(p, "change_name");
    break;

  case 97:
    strcpy(p, "change_language");
    break;

  case 98:
    strcpy(p, "disc_user");
    break;

  case 99:
    strcpy(p, "write_ctext");
    break;

  case 100:
    strcpy(p, "reset_to_term");
    break;

  case 101:
    strcpy(p, "call_runprg");
    break;

  case 102:
    strcpy(p, "read_file");
    break;

  case 103:
    strcpy(p, "write_file");
    break;

  case 104:
    strcpy(p, "abort_useroutput");
    break;

  case 105:
    strcpy(p, "abort_box");
    break;

  case 106:
    strcpy(p, "melde_user_an");
    break;

  case 107:
    strcpy(p, "melde_user_ab");
    break;

  case 108:
    strcpy(p, "get_btext");
    break;

  case 109:
    strcpy(p, "show_rfile");
    break;

  case 110:
    strcpy(p, "show_help");
    break;

  case 111:
    strcpy(p, "separate_status");
    break;

  case 112:
    strcpy(p, "create_status2");
    break;

  case 113:
    strcpy(p, "new_bid");
    break;

  case 114:
    strcpy(p, "split_sline");
    break;

  case 115:
    strcpy(p, "find_command");
    break;

  case 116:
    strcpy(p, "load_boxbcastparms");
    break;

  case 117:
    strcpy(p, "get_nextvalidlog");
    break;

  case 118:
    strcpy(p, "find_firstvalidlog");
    break;

  case 119:
    strcpy(p, "send_lognr");
    break;

  case 120:
    strcpy(p, "boxbcasttimer");
    break;

  case 121:
    strcpy(p, "tell_processing");
    break;

  case 122:
    strcpy(p, "timeout_check");
    break;

  case 123:
    strcpy(p, "show_mailbeacon");
    break;

  case 124:
    strcpy(p, "write_file2");
    break;

  case 125:
    strcpy(p, "check_sftimer");
    break;

  case 126:
    strcpy(p, "sf_for");
    break;

  case 127:
    strcpy(p, "*** (re)start ***");
    break;

  case 128:
    strcpy(p, "clear_hash");
    break;

  case 129:
    strcpy(p, "add_hash");
    break;

  case 130:
    strcpy(p, "load_bidhash");
    break;

  case 131:
    strcpy(p, "delete_hash_offset");
    break;

  case 132:
    strcpy(p, "update_hash");
    break;

  case 133:
    strcpy(p, "find_bidhash");
    break;

  case 134:
    strcpy(p, "free_membidpuffer");
    break;

  case 135:
    strcpy(p, "dispose_sfinfos");
    break;

  case 136:
    strcpy(p, "dispose_rubrikinfos");
    break;

  case 137:
    strcpy(p, "check_hcs");
    break;

  case 138:
    strcpy(p, "del_first_emblock");
    break;

  case 139:
    strcpy(p, "set_forward");
    break;

  case 140:
    strcpy(p, "new_sfentry");
    break;

  case 141:
    strcpy(p, "check_reject");
    break;

  case 142:
    strcpy(p, "do_convtit");
    break;

  case 143:
    strcpy(p, "check_dirty");
    break;

  case 144:
    strcpy(p, "disp_hash");
    break;

  case 145:
    strcpy(p, "search_in_ram");
    break;

  case 146:
    strcpy(p, "search_in_hash");
    break;

  case 147:
    strcpy(p, "add_line_to_buff");
    break;

  case 148:
    strcpy(p, "valid_partner");
    break;

  case 149:
    strcpy(p, "check_sfdeffile");
    break;

  case 150:
    strcpy(p, "end_boxconnect");
    break;

  case 151:
    strcpy(p, "find_sfdef");
    break;

  case 152:
    strcpy(p, "wildcardcompare");
    break;

  case 153:
    strcpy(p, "calc_bidhash");
    break;

  case 154:
    strcpy(p, "box_input");
    break;

  case 155:
    strcpy(p, "boxrange");
    break;

  case 157:
    strcpy(p, "set_password");
    break;

  case 158:
    strcpy(p, "load_bptr");
    break;

  case 159:
    strcpy(p, "add_bptr");
    break;

  case 160:
    strcpy(p, "load_hbox");
    break;

  case 161:
    strcpy(p, "msgnum2cposstart");
    break;

  case 162:
    strcpy(p, "fill_msgnumarr");
    break;

  case 163:
    strcpy(p, "create_all_msgnums");
    break;
  
  case 164:
    strcpy(p, "recompile_fwd");
    break;

  case 200:
    strcpy(p, "open_iface");
    break;

  case 201:
    strcpy(p, "close_iface");
    break;

  case 202:
    strcpy(p, "send_command_packet");
    break;

  case 203:
    strcpy(p, "send_command_iface");
    break;

  case 204:
    strcpy(p, "send_command_channel_if");
    break;

  case 205:
    strcpy(p, "unblocking");
    break;

  case 206:
    strcpy(p, "packet_analysis");
    break;

  case 207:
    strcpy(p, "write_iface_packet2");
    break;

  case 208:
    strcpy(p, "main");
    break;

  default:
    *p = '\0';
    break;
  }
  
  if (*p != '\0' && pn != 127)
    strcat(p, "()");

  strcpy(lastproc, p);

/*  rspacing(p, 21); */
  k = strlen(p) + 2;
  if (strlen(txt) + k > 255)
    sprintf(hs, "%s %.*s>", p, 254 - k, txt);
  else
    sprintf(hs, "%s %s", p, txt);

  del_lastblanks(hs);
  if (debug_level > 0) {
    if (ap_sysfile(unr, hs, debug_box) > debug_size) {
      strcpy(dbold, debug_box);
      new_ext(dbold, "bak");
      sfdelfile(dbold);
      sfrename(debug_box, dbold);
    }
  }
  if (level == 0)
    ap_sysfile(unr, hs, profile_box);
}


void debug0(short level, short unr, short pn)
{
  Char hs[256];

  if (level <= debug_level && !disk_full) {
    *hs = '\0';
    debug_2(level, unr, pn, hs);
  }
}


void read_index(short handle, short nr, indexstruct *ibuf)
{
  long seek, err;
  boolean ok;
  Char hs[256];
  Char STR1[256];

  ibuf->absender[0] = '\0';
  if (nr == -1)
    ok = true;
  else {
    seek = (nr - 1) * sizeof(indexstruct);
    err = sfseek(seek, handle, SFSEEKSET);
    ok = (seek == err);
  }
  if (!ok)
    return;
  if (sfread(handle, sizeof(indexstruct), (uchar *)ibuf) == sizeof(indexstruct))
    return;
  handle2name(handle, hs);
  sprintf(hs, "read error: %s", strcpy(STR1, hs));
  debug(0, 0, 1, hs);
}


short write_index(short handle, short nr, indexstruct *ibuf)
{
  short Result;
  long seek, err;
  boolean ok;
  Char hs[256];
  Char STR1[256];

  Result = 0;
  if (nr == -1) {
    err = sfseek(0, handle, SFSEEKEND);   /* Eintrag anhaengen */
    ok = (err / sizeof(indexstruct) < SHORT_MAX);
  } else {
    seek = (nr - 1) * sizeof(indexstruct);
    err = sfseek(seek, handle, SFSEEKSET);
    ok = (seek == err);
  }

  ibuf->hver = headervn;
  ibuf->reserved = 0;
  create_hcs(ibuf);

  if (ok) {
    if (sfwrite(handle, sizeof(indexstruct), (uchar *)ibuf) ==
	sizeof(indexstruct))
      return (err / sizeof(indexstruct) + 1);
    handle2name(handle, hs);
    sprintf(hs, "write error: %s", strcpy(STR1, hs));
    debug(0, 0, 2, hs);
    return Result;
  }
  handle2name(handle, hs);
  sprintf(hs, "seek error: %s", strcpy(STR1, hs));
  debug(0, 0, 2, hs);
  return Result;
}


void read_log(short handle, long nr, boxlogstruct *ibuf)
{
  long seek, err;
  boolean ok;
  Char hs[256];
  Char STR1[256];

  if (nr == -1)
    ok = true;
  else {
    seek = (nr - 1) * sizeof(boxlogstruct);
    err = sfseek(seek, handle, SFSEEKSET);
    ok = (seek == err);
  }
  if (!ok)
    return;
  if (sfread(handle, sizeof(boxlogstruct), (uchar *)ibuf) == sizeof(boxlogstruct))
    return;
  handle2name(handle, hs);
  sprintf(hs, "read error: %s", strcpy(STR1, hs));
  debug(0, 0, 3, hs);
}


void write_log(short handle, long nr, boxlogstruct *ibuf)
{
  long seek, err;
  boolean ok;
  Char hs[256];
  Char STR1[256];

  if (nr == -1) {
    sfseek(0, handle, SFSEEKEND);   /* Eintrag anhaengen */
    ok = true;
  } else {
    seek = (nr - 1) * sizeof(boxlogstruct);
    err = sfseek(seek, handle, SFSEEKSET);
    ok = (seek == err);
  }
  if (!ok)
    return;
  if (sfwrite(handle, sizeof(boxlogstruct), (uchar *)ibuf) ==
      sizeof(boxlogstruct))
    return;
  handle2name(handle, hs);
  sprintf(hs, "write error: %s", strcpy(STR1, hs));
  debug(0, 0, 4, hs);
}


void write_log_and_bid(Char *brett1, short nummer, indexstruct header)
{
  short k1;
  boxlogstruct logheader;
  Char hs[256];

  debug(5, 0, 5, brett1);
  if (*header.id != '\0')
    write_msgid(-1, header.id);

  k1 = sfopen(boxlog, FO_RW);
  if (k1 < minhandle)
    k1 = sfcreate(boxlog, FC_FILE);

  if (k1 < minhandle) {
    debug(2, 0, 5, "file not created");
    return;
  }

  logheader.date = clock_.ixtime;
  strcpy(logheader.brett, brett1);
  strcpy(logheader.obrett, header.dest);
  logheader.msgnum = header.msgnum;
  logheader.idxnr = nummer;
  strcpy(logheader.bid, header.id);
  logheader.size = truesize(header);
  logheader.lifetime = header.lifetime;
  logheader.deleted = header.deleted;
  logheader.pmode = header.pmode;
  logheader.level = header.level;
  logheader.msgtype = header.msgtype;
  logheader.msgflags = header.msgflags;
  logheader.pmode = header.pmode;
  strcpy(hs, header.absender);
  cut(hs, 6);
  strcpy(logheader.absender, hs);
  strcpy(hs, header.verbreitung);
  cut(hs, 6);
  strcpy(logheader.verbreitung, hs);
  strcpy(hs, header.betreff);
  cut(hs, 40);
  strcpy(logheader.betreff, hs);
  write_log(k1, -1, &logheader);
  sfclose(&k1);

  *hs = '\0';
  if (unproto_list)
    send_unproto_header(logheader, hs, hs, false, false);
}


Static void check_mybbsfile(void)
{
  mybbstyp nheader;
  Char oidxname[256], nidxname[256];
  long ct, dsize;
  short kin_index, kout_index;

  debug0(2, 0, 6);
  strcpy(oidxname, mybbs_box);
  if (ramdisk > '0') {
    if (DiskFree(drv2num(ramdisk)) > sfsize(oidxname))
      sprintf(nidxname, "%c%c%cmybbs%cbox", ramdisk, drivesep, dirsep, extsep);
    else
      strcpy(nidxname, oidxname);
  } else
    strcpy(nidxname, oidxname);
  nidxname[strlen(nidxname) - 1] = 'N';
  dsize = sfsize(oidxname);

  kin_index = sfopen(oidxname, FO_READ);
  kout_index = sfcreate(nidxname, FC_FILE);
  if (kin_index >= minhandle && kout_index >= minhandle) {
    for (ct = 1; ct <= dsize / sizeof(mybbstyp); ct++) {
      if (sfread(kin_index, sizeof(mybbstyp), (uchar *)(&nheader)) !=
	  sizeof(mybbstyp)) {
	debug(0, 0, 6, "read error");
	goto _L1;
      }
      if (callsign(nheader.call)) {
	if (callsign(nheader.bbs)) {
	  if (nheader.mode != 'U' && nheader.mode != 'G') nheader.mode = 'U';
	  if ((nheader.mode == 'U' && clock_.ixtime - nheader.ix_time < 86400 * 365 * 5) /* fuenf jahre mybbs stehen lassen */
	    || (clock_.ixtime - nheader.ix_time < 86400 * 365))
	    sfwrite(kout_index, sizeof(mybbstyp), (uchar *)(&nheader));
	}
      }
    }

_L1:
    sfclose(&kin_index);
    sfclose(&kout_index);
    sfdelfile(oidxname);
    filemove(nidxname, oidxname);
  }

  sfclose(&kin_index);
  sfclose(&kout_index);
  sfdelfile(nidxname);
}


#define csustain        2


typedef struct counttyp {
  struct counttyp *next;
  Char bbs[7];
  long anz;
} counttyp;


Static unsigned short shall_sem;
Static counttyp *countroot;


Static void del_ctp(void)
{
  counttyp *hp, *hp1;

  hp = countroot;
  while (hp != NULL) {
    hp1 = hp;
    hp = hp->next;
    Free(hp1);
  }
  countroot = NULL;
}


Static void add_ctp(Char *bbsc)
{
  counttyp *hp;

  hp = countroot;
  while (hp != NULL && strcmp(hp->bbs, bbsc))
    hp = hp->next;
  if (hp != NULL) {
    hp->anz++;
    return;
  }
  hp = Malloc(sizeof(counttyp));
  if (hp == NULL)
    return;
  hp->next = countroot;
  strcpy(hp->bbs, bbsc);
  hp->anz = 1;
  countroot = hp;
}


Static void write_ctp(short k_)
{
  short k;
  counttyp *hp;
  Char hs[256];
  Char STR1[256];

  k = k_;
  hp = countroot;
  while (hp != NULL) {
    if (hp->anz >= csustain) {
      sprintf(hs, "%ld", hp->anz);
      while (strlen(hs) < 4)
	sprintf(hs, "0%s", strcpy(STR1, hs));
      sprintf(hs + strlen(hs), " %s", hp->bbs);
      string_to_file(&k, hs, true);
    }
    hp = hp->next;
  }
}


void show_all_user_at(short unr, Char *call, boolean del, boolean del2,
		      boolean only_count, Char *all_count)
{
  mybbstyp *bbsptr;
  long dsize, anz, ct;
  short k, cct, list, last, outf;
  boolean countall;
  uchar *puffer;
  long psize, rpos;
  indexstruct header;
  mybbstyp bbsrec;
  Char fname[256];
  Char sname[256];
  Char hs[256], ls[256];
  Char STR1[256], STR7[256];

  debug(2, unr, 7, call);

  countroot = NULL;
  countall = (*all_count != '\0');
  if (countall) {
    if (all_count[strlen(all_count) - 1] != '*')
      strcat(all_count, "*");
    del = false;
    del2 = false;
    only_count = true;
  }

  *ls = '\0';
  cct = 0;
  shall_sem++;
  sprintf(hs, "%ld", shall_sem);
  strcpy(fname, mybbs_box);
  sprintf(sname, "%sSBBSF%c%s", tempdir, extsep, hs);
  dsize = sfsize(fname);
  if (dsize <= 0)
    return;

  outf = sfcreate(sname, FC_FILE);
  if (outf < minhandle) {
    wlnuser(unr, "file create error");
    return;
  }

  anz = dsize / sizeof(mybbstyp);

  if (dsize < maxram())
    puffer = Malloc(dsize);
  else
    puffer = NULL;

  if (puffer != NULL) {
    psize = dsize;
    if (del)
      k = sfopen(fname, FO_RW);
    else
      k = sfopen(fname, FO_READ);
    if (k >= minhandle) {
      sfread(k, psize, puffer);
      rpos = 0;
      while (rpos < psize - 1) {
	bbsptr = (mybbstyp *)(&puffer[rpos]);
	if (countall) {
	  if (wildcardcompare(SHORT_MAX, all_count, bbsptr->bbs, ls)) {
	    add_ctp(bbsptr->bbs);
	    cct++;
	  }
	} else if ((!del2 && !strcmp(bbsptr->bbs, call) &&
		    callsign(bbsptr->call)) ||
		   del2 && !strcmp(bbsptr->call, call)) {
	  cct++;
	  string_to_file(&outf, bbsptr->call, true);
	  if (del) {
	    clear_uf_cache(bbsrec.call);
	    strcpy(bbsptr->call, "******");
	  }
	}
	rpos += sizeof(mybbstyp);
      }
      if (del && cct > 0) {
	sfseek(0, k, SFSEEKSET);
	sfwrite(k, psize, puffer);
      }
      sfclose(&k);
    }
    mymfreep(&puffer);
  } else {
	/* Falls die Datei nicht in den Speicher passt oder eine DOSE am werkeln ist */
    if (del)
      k = sfopen(fname, FO_RW);
    else
      k = sfopen(fname, FO_READ);
    if (k >= minhandle) {
      for (ct = 1; ct <= anz; ct++) {
	sfread(k, sizeof(mybbstyp), (uchar *)(&bbsrec));
	if (countall) {
	  if (wildcardcompare(SHORT_MAX, all_count, bbsrec.bbs, ls)) {
	    add_ctp(bbsrec.bbs);
	    cct++;
	  }
	} else if (!del2 && !strcmp(call, bbsrec.bbs) && callsign(bbsrec.call) ||
		   del2 && !strcmp(call, bbsrec.call)) {
	  cct++;
	  string_to_file(&outf, bbsrec.call, true);
	  if (del) {
	    clear_uf_cache(bbsrec.call);
	    strcpy(bbsrec.call, "******");
	    sfseek(-sizeof(mybbstyp), k, SFSEEKCUR);
	    sfwrite(k, sizeof(mybbstyp), (uchar *)(&bbsrec));
	  }
	}
      }
      sfclose(&k);
    }
  }


  if (!countall) {
    sprintf(fname, "%sM%c%s", indexdir, extsep, idx_e);
    dsize = sfsize(fname);
    last = dsize / sizeof(indexstruct);
    if (last > 0) {
      if (del)
	list = sfopen(fname, FO_RW);
      else
	list = sfopen(fname, FO_READ);
      if (list >= minhandle) {
	k = 0;
	while (k < last) {
	  k++;
	  read_index(list, k, &header);
	  if (header.deleted || !check_hcs(header))
	    continue;
	  unhpath(header.verbreitung, hs);
	  if ((del2 || strcmp(hs, call)) &&
	      (!del2 || strcmp(header.absender, call)))
	    continue;
	  cct++;
	  string_to_file(&outf, header.absender, true);
	  if (del) {
	    clear_uf_cache(header.absender);
	    header.deleted = true;
	    write_index(list, k, &header);
	  }
	}
	sfclose(&list);
      }
    }
    anz += last;

  } else {
    write_ctp(outf);
    del_ctp();
  }

  sfclose(&outf);

  if (cct > 0 && !del2) {
    w_btext(unr, 42);
    if (countall) {
      sprintf(hs, "%ld", cct);
      get_btext(unr, 107, ls);
      sprintf(hs, " %s %s %s", strcpy(STR1, hs), ls, all_count);
    } else {
      sprintf(hs, "%ld", anz);
      get_btext(unr, 108, ls);
      sprintf(hs, " %s %s ", strcpy(STR7, hs), ls);
    }
    wlnuser(unr, hs);
    wlnuser0(unr);
    sort_file(sname);
    outf = sfopen(sname, FO_READ);
    if (outf < minhandle) {
      wln_btext(unr, 106);
      return;
    }

    if (countall) {
      while (file_to_string(outf, hs)) {
	get_word(hs, ls);
	rspacing(hs, 7);
	cut(hs, 7);
	while (ls[0] == '0')
	  strdelete((void *)ls, 1, 1);
	lspacing(ls, 4);
	strcat(hs, ls);
	wlnuser(unr, hs);
      }

    } else {
      cct = 0;
      *ls = '\0';
      while (file_to_string(outf, hs)) {
	if (!strcmp(hs, ls))
	  continue;
	strcpy(ls, hs);
	rspacing(hs, 7);
	if (!only_count)
	  wuser(unr, hs);
	cct++;
	if (!only_count) {
	  if (cct % 10 == 0)
	    wlnuser0(unr);
	}
      }
    }

    sfclose(&outf);

    if (!countall) {
      if (!only_count)
	wlnuser0(unr);
      sprintf(hs, "%ld", cct);
      get_btext(unr, 108, ls);
      sprintf(hs, "@%s: %s %s", call, strcpy(STR7, hs), ls);
      if (del) {
	get_btext(unr, 89, ls);
	sprintf(hs + strlen(hs), " %s", ls);
      }
      wlnuser(unr, hs);
    }

    wlnuser0(unr);
  } else if (!del2)
    wln_btext(unr, 45);
  sfdelfile(sname);
}

static void redir_denied(boolean has_mail, char *call, char *newbbs, char *language)
{
  char betreff[256];
  char msg[256], msg2[256];
  
  get_language(184, langmemroot, language, betreff);
  expand_macro(-1, betreff);
  get_language(185, langmemroot, language, msg);
  expand_macro(-1, msg);
  strcat(msg, newbbs);
  if (has_mail) {
    get_language(186, langmemroot, language, msg2);
    expand_macro(-1, msg2);
    strcat(msg, msg2);
  }
  send_sysmsg(call, Console_call, betreff, msg, 90);
  send_sysmsg(call, newbbs, betreff, msg, 90);
  
  sprintf(msg, "Warning: MyBBS of %s maybe pirated to bbs %s", call, newbbs);
  append_profile(-1, msg);
}

#define rbsize 2500*sizeof(mybbstyp)

boolean update_mybbsfile(boolean by_usercommand, Char *call_, long *updatetime,
			 Char *mybbs_, Char *mybbsmode)
{
  boolean Result;
  Char call[7];
  Char mybbs[41];
  mybbstyp bbsrec, *bbsptr;
  userstruct rec;
  Char fname[256];
  Char w1[31], w2[31];
  uchar *puffer;
  Char gmode;
  long psize, dsize, fsize, rpos, wpos, spos, bc, gtime;
  boolean found, rdout, redirect, has_mails;
  long anz, ct;
  short k;
  Char STR1[256];

  strcpy(call, call_);
  strcpy(mybbs, mybbs_);
  debug(4, 0, 8, mybbs);
  Result = false;
  puffer = NULL;
  gtime = 0;
  gmode = '\0';
  wpos = 0;
  k = strpos2(mybbs, ".", 1);
  if (k > 0)
    cut(mybbs, k - 1);
  k = nohandle;
  if (*updatetime == 0)
    *updatetime = clock_.ixtime;

  if (callsign(mybbs))
    change_mybbs(-1, call, mybbs, *updatetime, "", mybbsmode[0], true, false);
  strcpy(fname, mybbs_box);
  if (!(callsign(call) && (callsign(mybbs) || *mybbs == '\0')))
    return Result;
  rdout = (*mybbs == '\0');
  if (rdout) *mybbsmode = '\0';
  found = false;
  dsize = sfsize(fname);
  if (dsize > 0) {
    psize = dsize;
    if (psize > rbsize)
      psize = rbsize;
    puffer = Malloc(psize);
    
    if (puffer != NULL) {
    
      if (rdout)
        k = sfopen(fname, FO_READ);
      else
        k = sfopen(fname, FO_RW);
        
      if (k >= minhandle) {
        spos = 0;
        fsize = sfread(k, psize, puffer);
	while (!found && fsize % sizeof(mybbstyp) == 0 && fsize > 0) {
	  rpos = 0;
	  while (!found && rpos < (fsize - sizeof(mybbstyp)) + 1) {
	    bbsptr = (mybbstyp *)(&puffer[rpos]);
	    if (!strcmp(bbsptr->call, call)) {
	      gtime = bbsptr->ix_time;
	      gmode = bbsptr->mode;
	      if (gmode != 'U' && gmode != 'G')
	        gmode = 'U';
	      if (rdout) {
		strcpy(mybbs_, bbsptr->bbs);
		*mybbsmode = gmode;
		*updatetime = gtime;
	      }
	      bbsrec = *bbsptr;
	      found = true;
	      wpos = rpos + spos;
	    }
	    if (!found)
	      rpos += sizeof(mybbstyp);
	  }
	  if (!found) {
	    spos += fsize;
	    fsize = sfread(k, psize, puffer);
	  }
	}
      }
      mymfreep(&puffer);
      
    } else {
    
      anz = dsize / sizeof(mybbstyp);
      if (rdout)
        k = sfopen(fname, FO_READ);
      else
        k = sfopen(fname, FO_RW);
      found = false;
      if (k >= minhandle) {
	for (ct = 1; ct <= anz; ct++) {
	  bc = sfread(k, sizeof(mybbstyp), (uchar *)(&bbsrec));
	  if (bc <= 0) {
	    debug(0, 0, 8, "read error (11)");
	    goto _L2;
	  }
	  if (!strcmp(call, bbsrec.call)) {
	    found = true;
	    gtime = bbsrec.ix_time;
	    gmode = bbsrec.mode;
	    if (gmode != 'U' && gmode != 'G')
	      gmode = 'U';
	    if (rdout) {
	      strcpy(mybbs_, bbsrec.bbs);
	      *mybbsmode = gmode;
	      *updatetime = gtime;
	    }
	    goto _L1;
	  }
	  wpos += bc;	  
	}
      }
    }

_L1: ;
  }

  if (!rdout) {
    /* nachschauen, ob wieder ein Witzbold ein sehr zukuenftiges */
    /* Datum angegeben hat...                                    */
    /* die +43200 sind WICHTIG, falls die eigene Uhr mal einige  */
    /* Minuten falsch geht (Fenster von 12 Stunden)              */

    if (*updatetime < clock_.ixtime + 43200L) {
    
    /* nachschauen ob
     * a) not found
     * b) found and mode != 'U' and mybbsmode == 'U'
     * c) found and mode != 'U' and mybbsmode != 'U' and updatetime > bbsrec.ix_time
     * d) found and mode == 'U' and mybbsmode == 'U' and updatetime > bbsrec.ix_time
     */
    
      if (!found
          || (found && gmode != 'U' && *mybbsmode == 'U')
          || (found && gmode != 'U' && *mybbsmode != 'U' && gtime < *updatetime)
          || (found && gmode == 'U' && *mybbsmode == 'U' && gtime < *updatetime)
         ) {
    
	Result = true;
	
    /* check ob mybbs vorher auf eigenem Boxcall stand, wenn ja */
    /* und wenn readlock > 0 und passwort aktiv, dann userfile  */
    /* nicht hinterherschicken, stattdessen eine Warnung an den */
    /* User lokal und bei der neuen mybbs absetzen, dass das    */
    /* mybbs geaendert wurde.                                   */
     
	redirect = true;
	if (found && !by_usercommand && gmode == 'U') {
	  unhpath(bbsrec.bbs, STR1);
	  if (!strcmp(STR1, Console_call)) {
	    unhpath(mybbs, STR1);
	    if (strcmp(STR1, Console_call)) {
	      if (!strcmp(call, Console_call))
	        redirect = false;
	      else {
	        load_userfile(false, false, call, &rec);
	        if (rec.readlock > 0 || rec.pwmode > 1)
	          redirect = false;
	      }
	    }
	  }
	}
	
	strcpy(bbsrec.call, call);
	strcpy(bbsrec.bbs, mybbs);
	bbsrec.ix_time = *updatetime;
	bbsrec.mode = *mybbsmode;
	if (k < minhandle)
	  k = sfcreate(fname, FC_FILE);
	if (k >= minhandle) {
	  if (found)
	    sfseek(wpos, k, SFSEEKSET);
	  else
	    sfseek(0, k, SFSEEKEND);
	  sfwrite(k, sizeof(mybbstyp), (uchar *)(&bbsrec));
	  sfclose(&k);
	}
	k = nohandle;
	clear_uf_cache(call);
	sprintf(STR1, "%s%s%c%s", indexdir, call, extsep, idx_e);
	if (exist(STR1)) {
	  has_mails = resend_userfile(redirect, call, mybbs);
	  if (!redirect) {
	    redir_denied(has_mails, call, mybbs, rec.language); 
	  }
	} else {
	  if (!redirect) {
	    redir_denied(false, call, mybbs, rec.language);
	  }
	}
      }
    } else {
      sprintf(w1, "%ld", *updatetime);
      sprintf(w2, "%ld", clock_.ixtime);
      sprintf(STR1, "corrupted M-forward-date : %s@%s stamp:%s mytime:%s",
	      call, mybbs, w1, w2);
      append_profile(-1, STR1);
    }
  }


_L2:
  sfclose(&k);
  return Result;
}

#undef rbsize


Static void dispose_mptr(void)
{
  mptrtype *hp, *hp1;

  hp = mptrroot;
  while (hp != NULL) {
    hp1 = hp;
    hp = hp->next;
    Free(hp1);
  }
  mptrroot = NULL;
}


Static void load_mptr(void)
{
  short x, k, l;
  mptrtype *hp;
  indexstruct ix;
  Char n[256];

  dispose_mptr();
  sprintf(n, "%sM%c%s", indexdir, extsep, idx_e);
  l = sfsize(n) / sizeof(indexstruct);
  if (l <= 0)
    return;
  k = sfopen(n, FO_READ);
  if (k < minhandle)
    return;
  for (x = 1; x <= l; x++) {
    read_index(k, x, &ix);
    if (check_hcs(ix) && !ix.deleted) {
      hp = Malloc(sizeof(mptrtype));
      if (hp != NULL) {
	hp->next = NULL;
	hp->csum = strcpycs(hp->call, ix.absender);
	hp->mpos = x;
	if (mptrroot == NULL)
	  mptrroot = hp;
	else {
	  hp->next = mptrroot->next;
	  mptrroot->next = hp;
	}
      }
    }
  }
  sfclose(&k);
}


Static void del_mptr(Char *call)
{
  mptrtype *hp, *hp1;
  uchar csum;

  hp = mptrroot;
  hp1 = NULL;
  csum = calccs(call);
  while (hp != NULL && (hp->csum != csum || strcmp(hp->call, call))) {
    hp1 = hp;
    hp = hp->next;
  }

  if (hp == NULL)
    return;
  if (hp1 == NULL)
    mptrroot = hp->next;
  else
    hp1->next = hp->next;
  Free(hp);
}


Static void add_mptr(Char *call, short mpos)
{
  mptrtype *hp;

  if (mpos <= 0 || (unsigned long)strlen(call) >= 32 ||
      ((1L << strlen(call)) & 0x7e) == 0)
    return;
  if (mptrroot == NULL)
    load_mptr();
  del_mptr(call);
  hp = Malloc(sizeof(mptrtype));
  if (hp == NULL)
    return;
  hp->next = NULL;
  hp->csum = strcpycs(hp->call, call);
  hp->mpos = mpos;
  if (mptrroot == NULL)
    mptrroot = hp;
  else {
    hp->next = mptrroot->next;
    mptrroot->next = hp;
  }
}


Static short find_mptr(Char *call)
{
  mptrtype *hp;
  uchar csum;

  csum = calccs(call);
  hp = mptrroot;
  while (hp != NULL && (hp->csum != csum || strcmp(hp->call, call)))
    hp = hp->next;
  if (hp != NULL)
    return (hp->mpos);
  else
    return -1;
}


Static boolean load_m(short mpos, Char *call, indexstruct *ix)
{
  short k;
  Char STR1[256];

  *ix->absender = '\0';
  if (mpos <= 0)
    return false;
  sprintf(STR1, "%sM%c%s", indexdir, extsep, idx_e);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return false;
  read_index(k, mpos, ix);
  sfclose(&k);
  if (check_hcs(*ix) && !strcmp(ix->absender, call) && ix->deleted == false)
    return true;
  return false;
}


Static short load_m_call(Char *call, indexstruct *ix)
{
  short k;

  k = find_mptr(call);
  if (k > 0) {
    if (!load_m(k, call, ix))
      k = -1;
  }
  return k;
}


void init_ufcache(void)
{
  short x;

  for (x = 0; x <= maxufcache; x++) {
    if (ufcache[x] != NULL)
      Free(ufcache[x]);
    ufcache[x] = NULL;
  }
  ufcr = 0;
}


void clear_uf_cache(Char *call)
{
  short x;
  uchar csum;

  csum = calccs(call);
  x = 0;
  while (x <= maxufcache) {
    if (ufcache[x] != NULL && csum == ufcache[x]->callcsum && !strcmp(ufcache[x]->call, call)) {
      Free(ufcache[x]);
      ufcache[x] = NULL;
    }
    x++;
  }
}


Static void add_uf_cache(userstruct uf)
{
  clear_uf_cache(uf.call);
  ufcr++;
  if (ufcr > maxufcache)
    ufcr = 0;
  if (ufcache[ufcr] != NULL)
    Free(ufcache[ufcr]);
  ufcache[ufcr] = Malloc(sizeof(userstruct));
  if (ufcache[ufcr] != NULL) {
    *ufcache[ufcr] = uf;
    ufcache[ufcr]->callcsum = calccs(uf.call);
  }
}


Static boolean load_uf_through_cache(Char *call, userstruct *uf)
{
  short x;
  boolean hit;
  uchar csum;

  csum = calccs(call);
  hit = false;
  x = 0;
  while (!hit && x <= maxufcache) {
    if (ufcache[x] != NULL && ufcache[x]->callcsum == csum && !strcmp(ufcache[x]->call, call))
      hit = true;
    else
      x++;
  }
  if (hit) {
    *uf = *ufcache[x];
    ufchit++;
  } else
    ufcmiss++;
  return hit;
}


Static void clear_userstruct(userstruct *rec)
{
  rec->callcsum = 0;
  *rec->call = '\0';
  *rec->mybbs = '\0';
  rec->mybbsmode = '\0';
  *rec->language = '\0';
  *rec->name = '\0';
  *rec->password = '\0';
  *rec->logincommands = '\0';
  *rec->promptmacro = '\0';
  *rec->nocheckboards = '\0';
  *rec->wantcheckboards = '\0';
  rec->lastdate = 0;
  rec->logindate = 0;
  rec->level = 1;
  rec->plevel = 1;
  rec->sf_level = 0;
  rec->pwmode = 0;
  rec->mybbsupd = 0;
  rec->pwsetat = 0;
  rec->lastatime = 0;
  rec->readlock = 0;
  rec->ttl = gttl;

  rec->srbytes = 0;
  rec->ssbytes = 0;
  rec->ssrbytes = 0;
  rec->sssbytes = 0;
  rec->sslogins = 0;
  rec->sfstat_rx_p = 0;
  rec->sfstat_rx_b = 0;
  rec->sfstat_rx_s = 0;
  rec->sfstat_tx_p = 0;
  rec->sfstat_tx_b = 0;
  rec->sfstat_tx_s = 0;
  rec->rbytes = 0;
  rec->sbytes = 0;
  rec->fstat_rx_p = 0;
  rec->fstat_rx_b = 0;
  rec->fstat_rx_s = 0;
  rec->fstat_tx_p = 0;
  rec->fstat_tx_b = 0;
  rec->fstat_tx_s = 0;
  rec->logins = 0;
  rec->ssf_level = 0;
  rec->M_pos = 0;
  rec->hidebeacon = false;
  rec->fbbmode = false;
  rec->sfmd2pw = false;
  rec->unproto_ok = false;
  rec->lock_here = multi_master;

  rec->dstat_rx_p = 0;
  rec->dstat_rx_b = 0;
  rec->dstat_rx_s = 0;
  rec->dstat_rx_bytes = 0;
  rec->dstat_tx_p = 0;
  rec->dstat_tx_b = 0;
  rec->dstat_tx_s = 0;
  rec->dstat_tx_bytes = 0;
  rec->dlogins = 0;

  rec->maxread_day = 0;
  rec->read_today = 0;

  rec->sendheader = NULL;
}


void convert_ufil(boolean with_ext_strings, indexstruct header,
		  userstruct *rec)
{
  uchar *p1, *p2;
  boolean wantchb;
  short x, y, k;
  Char w[256], hs[256], ds[256];
  short FORLIM;
  Char STR1[256];

  clear_userstruct(rec);

  *ds = '\0';
  *rec->logincommands = '\0';
  *rec->promptmacro = '\0';
  *rec->nocheckboards = '\0';
  *rec->wantcheckboards = '\0';

  strcpy(rec->call, header.absender);
  strcpy(rec->mybbs, header.verbreitung);
  p1 = (uchar *)(&header.size);
  p2 = rec->language;
  for (x = 0; x <= 3; x++)
    p2[x] = p1[x];

  strcpy(hs, header.readby);
  strcpy(w, hs);
  x = strpos2(hs, ";1", 1);
  if (x == 0) {
    cut(w, 80);
    strcpy(rec->name, w);
  } else {
    if (x <= 81)
      cut(w, x - 1);
    else
      cut(w, 80);
    strcpy(rec->name, w);
    strdelete((void *)hs, 1, x + 1);
    x = strpos2(hs, ";2", 1);
    if (x > 0) {
      sprintf(rec->promptmacro, "%.*s", x - 1, hs);
      strdelete((void *)hs, 1, x + 1);
      strcpy(rec->logincommands, hs);

      x = strpos2(hs, ";6", 1);
      if (x > 0) {
	rec->readlock = hs[x + 1] - '0';
	if (rec->readlock > 2) {
	  rec->hidebeacon = true;
	  rec->readlock -= 3;
	}
	strdelete((void *)hs, x, 3);
      }

      x = strpos2(hs, ";7", 1);
      if (x > 0) {
	y = hs[x + 1] - '0';
	rec->ttl = ((y & 1) != 0);
	rec->lock_here = ((y & 2) == 0);
	strdelete((void *)hs, x, 3);
      }

      x = strpos2(hs, ";8", 1);
      if (x > 0) {
        y = strpos2(hs, ";", x + 1);
        if (y > x) {
          strcpy(ds, hs);
          cut(ds, y - 1);
          strdelete((void *)ds, 1, x + 1);
          strdelete((void *)hs, x, y - x); 
        } else {
	  strcpy(ds, hs);
	  cut(hs, x - 1);
	  strdelete((void *)ds, 1, x + 1);
	}
      }

      x = strpos2(hs, ";9", 1);
      if (x > 0) {
	y = hs[x + 1] - '0';
	rec->sfmd2pw = ((y & 1) != 0);
	rec->fbbmode = ((y & 2) != 0);
	rec->unproto_ok = ((y & 4) != 0);
	strdelete((void *)hs, x, 3);
      }

      x = strpos2(hs, ";5", 1);
      if (x > 0) {
	cut(rec->logincommands, x - 1);
	FORLIM = strlen(rec->logincommands);
	for (y = 0; y < FORLIM; y++) {
	  if (rec->logincommands[y] == ',')
	    rec->logincommands[y] = ';';
	}

	if (with_ext_strings) {
	  sprintf(STR1, "%s%s%cEXT", extuserdir, rec->call, extsep);
	  k = sfopen(STR1, FO_READ);
	  if (k >= minhandle) {
	    file_to_string(k, rec->nocheckboards);
	    file_to_string(k, rec->wantcheckboards);
	    file_to_string(k, ds);
	    sfclose(&k);
	  }
	}
      } else {
	x = strpos2(hs, ";3", 1);
	if (x == 0) {
	  x = strpos2(hs, ";4", 1);
	  wantchb = true;
	} else
	  wantchb = false;
	if (x > 0)
	  cut(rec->logincommands, x - 1);
	FORLIM = strlen(rec->logincommands);
	for (y = 0; y < FORLIM; y++) {
	  if (rec->logincommands[y] == ',')
	    rec->logincommands[y] = ';';
	}
	if (x > 0) {
	  strdelete((void *)hs, 1, x + 1);
	  if (*hs != '\0' && hs[0] == ',') {
	    if (wantchb)
	      strcpy(rec->wantcheckboards, hs);
	    else
	      strcpy(rec->nocheckboards, hs);
	  }
	}
      }


    }
  }


  strcpy(rec->password, header.betreff);
  rec->lastdate = header.rxdate;
  rec->lastatime = header.lastread;
  rec->level = header.level;
  rec->plevel = header.level;
  if (header.pmode < 255)
    rec->sf_level = header.pmode;
  else
    rec->sf_level = -1;
  rec->ssf_level = rec->sf_level;
  rec->pwmode = header.fwdct;
  if (rec->pwmode > maxpwmode)
    rec->pwmode = 0;
  rec->mybbsupd = header.txdate;
  rec->mybbsmode = header.id[0];
  if (*rec->mybbs != '\0' && rec->mybbsmode != 'U' && rec->mybbsmode != 'G')
    rec->mybbsmode = 'U';

  rec->srbytes = header.start;
  rec->ssbytes = header.packsize;
  rec->sfstat_rx_p = header.rxqrg;

  p1 = (uchar *)(&rec->sfstat_rx_b);
  p2 = header.dest;
  for (x = 0; x <= 3; x++)
    p1[x] = p2[x];

  p1 = (uchar *)(&rec->sfstat_rx_s);
  p2 = (uchar *)(&p2[4]);
  for (x = 0; x <= 3; x++)
    p1[x] = p2[x];

  p1 = (uchar *)(&rec->sfstat_tx_p);
  p2 = header.rxfrom;
  for (x = 0; x <= 3; x++)
    p1[x] = p2[x];

  p1 = (uchar *)(&rec->sfstat_tx_b);
  p2 = (uchar *)(&p2[4]);
  for (x = 0; x <= 2; x++)
    p1[x] = p2[x];
  p2 = &header.msgtype;
  p1[3] = p2[0];

  p1 = (uchar *)(&rec->sfstat_tx_s);
  p2 = (uchar *)(&header.lifetime);
  for (x = 0; x <= 1; x++)
    p1[x] = p2[x];
  p2 = (uchar *)(&header.txlifetime);
  for (x = 0; x <= 1; x++)
    p1[x + 2] = p2[x];

  rec->ssrbytes = header.erasetime;
  rec->sslogins = header.readcount;

  p2 = (uchar *)(&header.infochecksum);
  p1 = (uchar *)(&rec->sssbytes);
  for (x = 0; x <= 1; x++)
    p1[x] = p2[x];
  p2 = (uchar *)(&header.bcastchecksum);
  for (x = 0; x <= 1; x++)
    p1[x + 2] = p2[x];

  p2 = header.sendbbs;
  p1 = (uchar *)(&rec->pwsetat);
  if (p2[0] == 1) {
    for (x = 0; x <= 3; x++) {
      p1[x] = p2[x + 1];

    }
  } else {
    if (strlen(rec->password) > 20)
      rec->pwsetat = clock_.ixtime - 604800L;
  }

  rec->logins = header.msgflags;

  rec->maxread_day = (long)header.firstbyte * maxreaddivisor;
  if (clock_.ixtime - rec->lastatime > 86400L)
    rec->read_today = 0;
  else
    rec->read_today = (long)header.eraseby * maxreaddivisor;

  if (*ds != '\0' && in_sfp(rec->call)) {
    get_word(ds, w);
    rec->dstat_rx_p = str2lint(w);
    get_word(ds, w);
    rec->dstat_rx_b = str2lint(w);
    get_word(ds, w);
    rec->dstat_rx_s = str2lint(w);
    get_word(ds, w);
    rec->dstat_rx_bytes = str2lint(w);
    get_word(ds, w);
    rec->dstat_tx_p = str2lint(w);
    get_word(ds, w);
    rec->dstat_tx_b = str2lint(w);
    get_word(ds, w);
    rec->dstat_tx_s = str2lint(w);
    get_word(ds, w);
    rec->dstat_tx_bytes = str2lint(w);
    get_word(ds, w);
    rec->dlogins = (unsigned short)str2lint(w);
    return;
  }

  rec->dstat_rx_p = rec->sfstat_rx_p;
  rec->dstat_rx_b = rec->sfstat_rx_b;
  rec->dstat_rx_s = rec->sfstat_rx_s;
  rec->dstat_rx_bytes = rec->srbytes;
  rec->dstat_tx_p = rec->sfstat_tx_p;
  rec->dstat_tx_b = rec->sfstat_tx_b;
  rec->dstat_tx_s = rec->sfstat_tx_s;
  rec->dstat_tx_bytes = rec->ssbytes;
  rec->dlogins = rec->logins;
}


void load_userfile(boolean only_m, boolean with_ext_strings, Char *calls,
		   userstruct *rec)
{
  indexstruct header, *hp;
  Char mbbs[7];
  Char lan[256];
  long time;

  debug(4, 0, 9, calls);

  if (load_uf_through_cache(calls, rec))
    return;

  with_ext_strings = true;

  rec->M_pos = load_m_call(calls, &header);

  if (rec->M_pos > 0) {
    hp = &header;   /*alter eintrag ?*/
    if (hp->size == 0) {
      clear_userstruct(rec);
      strcpy(rec->call, hp->absender);
      strcpy(rec->mybbs, hp->verbreitung);
      strcpy(rec->language, hp->id);
      cut(hp->dest, 80);
      strcpy(rec->name, hp->dest);
      strcpy(rec->password, hp->betreff);
      rec->lastdate = hp->rxdate;
      rec->level = hp->level;
      rec->plevel = hp->level;
      rec->sf_level = hp->pmode;
      rec->ssf_level = rec->sf_level;
      rec->pwmode = hp->msgflags;
      if (rec->pwmode > maxpwmode)
	rec->pwmode = 0;
      rec->mybbsupd = hp->rxqrg;
      rec->mybbsmode = hp->id[0];
    } else
      convert_ufil(with_ext_strings, *hp, rec);
  } else
    clear_userstruct(rec);

  if (*rec->call == '\0' && !only_m) {
    *mbbs = '\0';
    update_mybbsfile(false, calls, &time, mbbs, &rec->mybbsmode);
	/*mal in den M - Meldungen suchen*/
    if (*mbbs != '\0') {
      strcpy(rec->call, calls);
      user_language(&whichlangmem, &whichlangsize, whotalks_lan, rec->call,
		    lan);
      cut(lan, 3);
      strcpy(rec->language, lan);
      strcpy(rec->mybbs, mbbs);
      rec->mybbsupd = time;
    }
  }
  
  if (rec->sf_level > 1) rec->sf_level = 1; /* keine Sonderrechte mehr fuer DieBox */
  if (rec->ssf_level > 1) rec->ssf_level = 1; /* dito */
  
  if (*rec->mybbs != '\0' && rec->mybbsmode != 'U' && rec->mybbsmode != 'G')
    rec->mybbsmode = 'U';

  if (*rec->call != '\0')
    add_uf_cache(*rec);
}


void load_userinfo_for_change(boolean only_m, Char *callx, userstruct *ufil)
{
  Char lan[256];

  if (!callsign(callx))
    return;
  load_userfile(only_m, true, callx, ufil);
  if (*ufil->call != '\0' && *ufil->language != '\0')
    return;
  user_language(&whichlangmem, &whichlangsize, whotalks_lan, callx, lan);
  cut(lan, 3);
  strcpy(ufil->language, lan);
  strcpy(ufil->call, callx);
}


void code_ufil(userstruct *rec, indexstruct *header)
{
  uchar *p1, *p2;
  short x, k, i;
  Char hs[256], w[256], ds[256];
  Char STR7[256];
  short FORLIM;

  *ds = '\0';
  if (in_sfp(rec->call)) {
    sprintf(ds, "%ld", rec->dstat_rx_p);
    sprintf(w, "%ld", rec->dstat_rx_b);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dstat_rx_s);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dstat_rx_bytes);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dstat_tx_p);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dstat_tx_b);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dstat_tx_s);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dstat_tx_bytes);
    sprintf(ds + strlen(ds), " %s", w);
    sprintf(w, "%ld", rec->dlogins);
    sprintf(ds + strlen(ds), " %s", w);
  }

  strcpy(header->absender, rec->call);
  strcpy(header->verbreitung, rec->mybbs);
  p1 = (uchar *)(&header->size);
  p2 = rec->language;
  for (x = 0; x <= 3; x++)
    p1[x] = p2[x];
  strcpy(hs, rec->name);
  cut(hs, 80);
  strcat(hs, ";1");
  cut(rec->promptmacro, 130 - strlen(hs));
  sprintf(hs + strlen(hs), "%s;2", rec->promptmacro);
  strcpy(w, rec->logincommands);
  cut(w, 132 - strlen(hs));
  FORLIM = strlen(w);
  for (x = 0; x < FORLIM; x++) {
    if (w[x] == ';')
      w[x] = ',';
  }

  if (strlen(rec->wantcheckboards) + strlen(rec->nocheckboards) + strlen(ds) +
      strlen(w) + strlen(hs) > 127) {
    sprintf(STR7, "%s%s%cEXT", extuserdir, rec->call, extsep);
    k = sfcreate(STR7, FC_FILE);
    if (k >= minhandle) {
      string_to_file(&k, rec->nocheckboards, true);
      string_to_file(&k, rec->wantcheckboards, true);
      string_to_file(&k, ds, true);
      sfclose(&k);
      sprintf(hs + strlen(hs), "%s;5", w);
    } else
      strcat(hs, w);
    *w = '\0';
  } else {
    sprintf(STR7, "%s%s%cEXT", extuserdir, rec->call, extsep);
    sfdelfile(STR7);
    if (*rec->wantcheckboards != '\0') {
      sprintf(hs + strlen(hs), "%s;4", w);
      strcpy(w, rec->wantcheckboards);
    } else {
      sprintf(hs + strlen(hs), "%s;3", w);
      strcpy(w, rec->nocheckboards);
    }
    if (*ds != '\0')
      sprintf(w + strlen(w), ";8%s", ds);
  }


  cut(w, 131 - strlen(hs));
  strcat(hs, w);

  i = rec->readlock;
  if (rec->hidebeacon)
    i += 3;
  sprintf(w, "%ld", i);
  sprintf(hs + strlen(hs), ";6%c", w[0]);

  x = 0;
  if (rec->ttl)
    x++;
  if (!rec->lock_here)
    x += 2;
  sprintf(hs + strlen(hs), ";7%ld", x);

  x = 0;
  if (rec->sfmd2pw)
    x++;
  if (rec->fbbmode)
    x += 2;
  if (rec->unproto_ok)
    x += 4;
  sprintf(hs + strlen(hs), ";9%ld", x);

  strcpy(header->readby, hs);

  strcpy(header->betreff, rec->password);
  header->rxdate = rec->lastdate;
  if (rec->lastdate != 0 && rec->lastatime == 0)
    rec->lastatime = rec->lastdate;
  header->lastread = rec->lastatime;
  header->level = rec->plevel;
  header->txdate = rec->mybbsupd;
  header->deleted = false;
  if (rec->ssf_level >= 0)
    header->pmode = rec->ssf_level;
  else
    header->pmode = 255;
  if (rec->pwmode > maxpwmode)
    rec->pwmode = 0;
  header->fwdct = rec->pwmode;

  rec->srbytes += rec->rbytes;
  rec->ssbytes += rec->sbytes;
  rec->ssrbytes += rec->rbytes;
  rec->sssbytes += rec->sbytes;
  rec->sfstat_rx_p += rec->fstat_rx_p;
  rec->fstat_rx_p = 0;
  rec->sfstat_rx_b += rec->fstat_rx_b;
  rec->fstat_rx_b = 0;
  rec->sfstat_rx_s += rec->fstat_rx_s;
  rec->fstat_rx_s = 0;
  rec->sfstat_tx_p += rec->fstat_tx_p;
  rec->fstat_tx_p = 0;
  rec->sfstat_tx_b += rec->fstat_tx_b;
  rec->fstat_tx_b = 0;
  rec->sfstat_tx_s += rec->fstat_tx_s;
  rec->fstat_tx_s = 0;

  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL && !strcmp(user[x]->call, rec->call)) {
      user[x]->srbytes = rec->srbytes;
      user[x]->ssbytes = rec->ssbytes;
      user[x]->ssrbytes = rec->ssrbytes;
      user[x]->sssbytes = rec->sssbytes;
      user[x]->sfstat_rx_p = rec->sfstat_rx_p;
      user[x]->sfstat_rx_b = rec->sfstat_rx_b;
      user[x]->sfstat_rx_s = rec->sfstat_rx_s;
      user[x]->sfstat_tx_p = rec->sfstat_tx_p;
      user[x]->sfstat_tx_b = rec->sfstat_tx_b;
      user[x]->sfstat_tx_s = rec->sfstat_tx_s;
      user[x]->logins = rec->logins;
      user[x]->sslogins = rec->sslogins;
    }
  }

  header->start = rec->srbytes;
  header->packsize = rec->ssbytes;
  header->rxqrg = rec->sfstat_rx_p;

  p1 = (uchar *)(&rec->sfstat_rx_b);
  p2 = header->dest;
  for (x = 0; x <= 3; x++)
    p2[x] = p1[x];

  p1 = (uchar *)(&rec->sfstat_rx_s);
  p2 = (uchar *)(&p2[4]);
  for (x = 0; x <= 3; x++)
    p2[x] = p1[x];

  p1 = (uchar *)(&rec->sfstat_tx_p);
  p2 = header->rxfrom;
  for (x = 0; x <= 3; x++)
    p2[x] = p1[x];

  p1 = (uchar *)(&rec->sfstat_tx_b);
  p2 = (uchar *)(&p2[4]);
  for (x = 0; x <= 2; x++)
    p2[x] = p1[x];
  p2 = &header->msgtype;
  p2[0] = p1[3];

  p1 = (uchar *)(&rec->sfstat_tx_s);
  p2 = (uchar *)(&header->lifetime);
  for (x = 0; x <= 1; x++)
    p2[x] = p1[x];
  p2 = (uchar *)(&header->txlifetime);
  for (x = 0; x <= 1; x++)
    p2[x] = p1[x + 2];

  header->msgflags = rec->logins;
  header->erasetime = rec->ssrbytes;
  header->readcount = rec->sslogins;

  p2 = (uchar *)(&header->infochecksum);
  p1 = (uchar *)(&rec->sssbytes);
  for (x = 0; x <= 1; x++)
    p2[x] = p1[x];
  p2 = (uchar *)(&header->bcastchecksum);
  for (x = 0; x <= 1; x++)
    p2[x] = p1[x + 2];

  p2 = header->sendbbs;
  p1 = (uchar *)(&rec->pwsetat);
  p2[0] = 1;
  for (x = 0; x <= 3; x++)
    p2[x + 1] = p1[x];

  header->firstbyte =
    ((rec->maxread_day + maxreaddivisor - 1) / maxreaddivisor) & 0xff;
  header->eraseby = ((rec->read_today + maxreaddivisor - 1) / maxreaddivisor) & 0xff;

  header->id[0] = rec->mybbsmode;
  for (x = 1; x < 12; x++)
    header->id[x] = '\0';

}


void save_userfile(userstruct *rec)
{
  Char index[256];
  indexstruct header;
  long isize;
  short k, list, last;
  boolean found;
  userstruct rec2;

  debug0(4, 0, 10);
  sprintf(index, "%sM%c%s", indexdir, extsep, idx_e);
  isize = sfsize(index);
  last = isize / sizeof(indexstruct);
  list = sfopen(index, FO_RW);
  found = false;

  if (list >= minhandle) {
    k = rec->M_pos;
    if (k > 0 && k <= last) {
      read_index(list, k, &header);
      if (!header.deleted && !strcmp(header.absender, rec->call) &&
	  check_hcs(header))
        found = true;
    }

    if (!found) {
      k = find_mptr(rec->call);
      if (k > 0 && k <= last) {
        read_index(list, k, &header);
        if (!header.deleted && !strcmp(header.absender, rec->call) &&
	    check_hcs(header))
          found = true;
      }
    }
  }
  
  if (list < minhandle)
    list = sfcreate(index, FC_FILE);
  if (list < minhandle) {
    clear_uf_cache(rec->call);
    return;
  }
  
  code_ufil(rec, &header);
  if (found)
    k = write_index(list, k, &header);
  else
    k = write_index(list, -1, &header);
  sfclose(&list);

  if (k <= 0) {
    clear_uf_cache(rec->call);
    return;
  }
  
  add_mptr(rec->call, k);

  convert_ufil(true, header, &rec2);
  if (*rec2.call == '\0')
    return;
  
  rec->M_pos = k;
  rec2.M_pos = k;
  add_uf_cache(rec2);
}


void user_mybbs(Char *call, Char *mbx)
{
  userstruct ufil;

  *mbx = '\0';
  load_userfile(false, false, call, &ufil);
  if (*ufil.call != '\0') {
    if (*ufil.mybbs != '\0')
      strcpy(mbx, ufil.mybbs);
  }
}


/* ********************************************************************************* */

Static void ordne_ein(blogmem *lroot, blogmem **last, long date1, long logct1)
{
  blogmem *temp;
  short erg;
  blogmem *entry_;

  entry_ = Malloc(sizeof(blogmem));

  if (entry_ == NULL)
    return;
  entry_->date = date1;
  entry_->logidxct = logct1;

  if (entry_->date > (*last)->date)
    temp = *last;
  else
    temp = lroot;

  erg = 0;
  while (erg == 0) {
    if (temp->nach != NULL) {
      if (entry_->date > temp->date)
	temp = temp->nach;
      else
	erg = 1;
    } else {
      if (entry_->date > temp->date)
	erg = 2;
      else
	erg = 3;
    }
  }

  if (erg == 2) {
    temp->nach = entry_;
    entry_->vor = temp;
    entry_->nach = NULL;
  } else {
    entry_->nach = temp;
    entry_->vor = temp->vor;
    temp->vor = entry_;
    entry_->vor->nach = entry_;

  }

  *last = entry_;

}


Static void conv_idx_to_blog(Char *brett1, short idxct, indexstruct header,
			     boxlogstruct *blog)
{
  Char hs[256];
  unsigned short d1, d2;

  strcpy(blog->brett, brett1);
  strcpy(blog->obrett, header.dest);
  blog->msgnum = header.msgnum;
  blog->date = header.rxdate;
  blog->idxnr = idxct;
  blog->msgflags = header.msgflags;
  strcpy(blog->bid, header.id);
  blog->size = truesize(header);
  blog->lifetime = header.lifetime;
  blog->deleted = header.deleted;
  blog->pmode = header.pmode;
  d1 = 1;
  d2 = blog->lifetime;
  check_lt_acc(brett1, &d2, &d1);
  blog->level = d1;
  blog->msgtype = header.msgtype;
  strcpy(hs, header.absender);
  cut(hs, 6);
  strcpy(blog->absender, hs);
  strcpy(hs, header.verbreitung);
  cut(hs, 6);
  strcpy(blog->verbreitung, hs);
  strcpy(hs, header.betreff);
  cut(hs, 40);
  strcpy(blog->betreff, hs);
}


Static void schreibe_templog(short templog, Char *brett1, short idxct,
			     indexstruct *header)
{
  boxlogstruct blog;

  conv_idx_to_blog(brett1, idxct, *header, &blog);
  write_log(templog, -1, &blog);
}


Static boolean schreibe_log(short templog, short log, blogmem *lroot)
{
  blogmem *temp, *hp;
  boxlogstruct blog;
  long ct;
  boolean disordered_msgnums;
  long lastmsgnum;

  ct = 0;
  lastmsgnum = 0;
  disordered_msgnums = false;
  temp = lroot;
  while (temp != NULL) {
    ct++;
    if (temp->logidxct > 0) {
      if (ct % 100 == 0)   /*Watchdog resetten*/
	dp_watchdog(2, 4711);
      read_log(templog, temp->logidxct, &blog);
      if (blog.msgnum <= lastmsgnum)
        disordered_msgnums = true;
      lastmsgnum = blog.msgnum;
      write_log(log, -1, &blog);
    }
    hp = temp;
    temp = temp->nach;
    Free(hp);
  }
  
  if (!disordered_msgnums) {
    if (lastmsgnum > 998000 && ct < 998000)
      disordered_msgnums = true;
  }
  
  return disordered_msgnums;
}


Static boolean cnb_sem;


#define fmemname        "BL7782ER"


boolean create_new_boxlog1(short unr, boolean bullids)
{
  short fmem;
  DTA dirinfo;
  short result, k, list;
  indexstruct header;
  short log, templog, msglog;
  Char brett[256], hs[256];
  Char fmemfile[256];
  Char tempname[256];
  long totalsize;
  boolean recalc_msgnums;

  blogmem *lroot, *lastptr;

  long err, logct, bseek;
  Char STR1[256];
  Char TEMP;


  debug0(2, unr, 13);
  cnb_sem = true;
  recalc_msgnums = false;
  msglog = nohandle;
  *brett = '\0';
  boxsgdial1();
  sprintf(fmemfile, "%s%s", tempdir, fmemname);
  *tempname = '\0';
  totalsize = 0;
  fmem = sfcreate(fmemfile, FC_FILE);
  if (fmem < minhandle) {
    debug(0, unr, 13, "create error");
    return false;
  }
  sprintf(STR1, "%s%c%c%s", indexdir, allquant, extsep, idx_e);
  result = sffirst(STR1, 0, &dirinfo);
  while (result == 0) {
    dp_watchdog(2, 4711);   /*Watchdog resetten*/
    strcpy(hs, dirinfo.d_fname);
    del_ext(hs);
    string_to_file(&fmem, hs, true);
    totalsize += dirinfo.d_length / sizeof(indexstruct);
    result = sfnext(&dirinfo);
  }
  sfclose(&fmem);
  sort_file(fmemfile);
  fmem = sfopen(fmemfile, FO_READ);
  if (fmem < minhandle) {
    debug(0, unr, 13, "open error");
    return false;
  }
  if (bullids) {
    msglog = sfopen(msgidlog, FO_RW);
    if (msglog < minhandle)
      msglog = sfcreate(msgidlog, FC_FILE);
    if (msglog < minhandle) {
      debug(0, unr, 13, "open error 2");
      sfclose(&fmem);
      sfdelfile(fmemfile);
      return false;
    }
  }
  logct = 0;
  lroot = Malloc(sizeof(blogmem));
  lroot->vor = NULL;
  lroot->nach = NULL;
  lroot->date = 0;
  lroot->logidxct = 0;
  lastptr = lroot;
  log = sfcreate(boxlog, FC_FILE);

  sprintf(tempname, "%stemplog%cbox", tempdir, extsep);

  templog = sfcreate(tempname, FC_FILE);
  if (templog >= minhandle && log >= minhandle) {
    while (file_to_string(fmem, brett)) {
      dp_watchdog(2, 4711);   /*Watchdog resetten*/
      del_ext(brett);
      boxrgdial1(brett);   /* anzeigen */
      if (strlen(brett) <= 1 &&
	  (strlen(brett) != 1 ||
	   (TEMP = upcase_(brett[0]), TEMP == 'M' || TEMP == 'X')))
	continue;
      sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
      list = sfopen(STR1, FO_READ);
      if (list < minhandle)
	continue;
      k = 0;
      do {
	k++;
	err = sfread(list, sizeof(indexstruct), (uchar *)(&header));
	if (err == sizeof(indexstruct)) {
	  logct++;
	  ordne_ein(lroot, &lastptr, header.rxdate, logct);
	  schreibe_templog(templog, brett, k, &header);
	  if (bullids) {
	    if (*header.id != '\0') {
	      if (bullidseek >= maxbullids) {
		bullidseek = 0;
		bseek = bullidseek * 13;
		sfseek(bseek, msglog, SFSEEKSET);
	      }
	      sfwrite(msglog, 13, header.id);
	      bullidseek++;
	    }
	  }
	}
      } while (err == sizeof(indexstruct));
      sfclose(&list);
    }
    strcpy(brett, "writing");
    boxrgdial1(brett);   /* anzeigen */
    recalc_msgnums = schreibe_log(templog, log, lroot);
  } else
    debug(0, unr, 13, "file error - not created");

  sfclose(&log);
  sfclose(&templog);
  sfdelfile(tempname);
  sfclose(&fmem);
  sfdelfile(fmemfile);
  if (bullids) {
    sfclose(&msglog);
    update_bidseek();
  }
  boxegdial1();
  cnb_sem = false;
  return recalc_msgnums;
}

#undef fmemname

Static void create_all_msgnums(boolean recalc);

void create_new_boxlog(short unr, boolean bullids)
{
  debug(2, unr, 13, "01");
  free_boxbcastdesc();
  free_membidpuffer();
  wln_btext(unr, 32);
  boxspoolread();
  if (bullids) {
    sfdelfile(msgidlog);
    clear_bidhash();
    free_membidpuffer();
    bullidseek = 0;
  }
  sfdelfile(eralog);
  if (create_new_boxlog1(unr, bullids)) {
    wlnuser(unr, "recreating msgnums");
    create_all_msgnums(true);
  }
  if (bullids)
    check_bullidseek();
  fill_msgnumarr();
}


Static void gberror1(boolean xgar, short unr, Char *s_,
		     boolean *garbage_error)
{
  Char s[256];

  strcpy(s, s_);
  debug(0, unr, 14, s);
  debug(0, unr, 14, "garbage aborted");
  boxprotokoll(s);
  *garbage_error = true;
  boxsetgdial(xgar, "1", 0, 0, 0, 0, 0, s);
  boxwait(10);
}


Static void gberrclose(long bct, Char *dname, short unr, boolean xgar,
		       uchar **copybuf, boolean *garbage_error, short posi,
		       short *k, short ct, Char *temp, boolean cserr)
{
  Char hs[256], w[256];
  Char STR1[256];

  *garbage_error = true;
  sprintf(hs, "%ld", ct);
  sprintf(w, "%ld", posi);
  sfclose(k);
  *k = nohandle;
  if (*temp != '\0')
    sfdelfile(temp);
  if (cserr) {
    sprintf(STR1, "%s %s info checksum error (7/%s)", dname, hs, w);
    gberror1(xgar, unr, STR1, garbage_error);
  } else if (bct <= 0) {
    sprintf(STR1, "%s %s read error (7/%s)", dname, hs, w);
    gberror1(xgar, unr, STR1, garbage_error);
  } else {
    sprintf(STR1, "%s %s write error (7/%s)", dname, hs, w);
    gberror1(xgar, unr, STR1, garbage_error);
  }
  if (*copybuf != NULL)
    mymfreep(copybuf);
}


Static void replace_x_nr(short old_x, short new_x)
{
  short z, y;
  userstruct *WITH;

  for (y = 1; y <= maxuser; y++) {
    if (user[y] != NULL) {
      WITH = user[y];
      if (WITH->f_bbs) {
	for (z = 0; z < maxfbbprops; z++) {
	  if (WITH->fbbprop[z].x_nr == old_x)
	    WITH->fbbprop[z].x_nr = new_x;
	}
      }
    }
  }
}


Static void delete_tempboxfiles(void)
{
  Char STR1[256], STR7[256];

  sprintf(STR1, "%sSFBOX%c%c", newmaildir, extsep, allquant);
  del_dir(STR1);
  sprintf(STR1, "%sAUTOBOX%c%c", newmaildir, extsep, allquant);
  del_dir(STR1);
  sprintf(STR1, "%sSENDING%c%c", newmaildir, extsep, allquant);
  del_dir(STR1);
  sprintf(STR7, "%sBOXCUT%c%c%c", newmaildir, allquant, extsep, allquant);
  del_dir(STR7);
  sprintf(STR1, "%s&%c%c%c", newmaildir, allquant, extsep, allquant);
  del_dir(STR1);
  sprintf(STR7, "%s%%%c%c%c", newmaildir, allquant, extsep, allquant);
  del_dir(STR7);
  sprintf(STR1, "%s$%c%c%c", newmaildir, allquant, extsep, allquant);
  del_dir(STR1);
}


Static void imp_sysfile(Char *fname, Char *titel)
{
  Char STR1[256];

  if (exist(fname)) {
    sprintf(STR1, "&%s", fname);
    send_sysmsg("Y", Console_call, titel, STR1, y_lifetime);
    sfdelfile(fname);
  }
}


Static void extract_readcalls(boolean rej, Char *readby, Char *w)
{
  short x;
  Char hs[256];

  x = 1;
  *w = '\0';
  while (x < strlen(readby) && strlen(w) < 59) {
    strsub(hs, readby, x, 7);
    x += 7;
    if (rej && hs[0] == '%' ||
	!rej && (hs[0] == '!' || hs[0] == ',' || hs[0] == '.')) {
      strdelete((void *)hs, 1, 1);
      sprintf(w + strlen(w), "%s ", hs);
    }
  }
  del_lastblanks(w);
}


Static short retmailinf(indexstruct *hptr, boolean unread, boolean unknown)
{
  short k, x;
  Char hs[256], bbs[256];
  Char w[256];
  Char STR1[256], STR7[256];

  sprintf(hs, "%simport%c001", newmaildir, extsep);
  validate(hs);
  k = sfcreate(hs, FC_FILE);
  if (k < minhandle)
    return k;
  strcpy(bbs, hptr->sendbbs);
  complete_hierarchical_adress(bbs);
  string_to_file(&k, Console_call, true);
  string_to_file(&k, Console_call, true);
  string_to_file(&k, hptr->absender, true);
  string_to_file(&k, bbs, true);
  strcpy(hs, "30                   ");   /* Lifetime */
  string_to_file(&k, hs, true);
  *hs = '\0';
  rspacing(hs, 70);   /* BID */
  string_to_file(&k, hs, true);
  if (unknown)
    sprintf(hs, "User %s unknown", hptr->dest);
  else if (unread)
    sprintf(hs, "Unread mail for %s", hptr->dest);
  else
    sprintf(hs, "Can't forward your mail for %s", hptr->dest);
  string_to_file(&k, hs, true);
  sprintf(hs, "From: %s @ %s", Console_call, ownhiername);
  string_to_file(&k, hs, true);
  sprintf(hs, "To  : %s @ %s", hptr->absender, bbs);
  string_to_file(&k, hs, true);
  *hs = '\0';
  string_to_file(&k, hs, true);

  if (unread || unknown) {
    extract_readcalls(false, hptr->readby, w);
    if (*w != '\0') {
      if (unknown)
	strcpy(hs, "Error        : recipient unknown");
      else
	strcpy(hs, "Error        : mail not read by recipient");
      string_to_file(&k, hs, true);
      sprintf(hs, "Read by      : %s", w);
    } else {
      if (unknown)
	strcpy(hs, "Error        : recipient unknown");
      else
	strcpy(hs, "Error        : Unread mail, now deleted");
    }
  } else {
    if ((hptr->msgflags & MSG_REJECTED) != 0) {
      extract_readcalls(true, hptr->readby, w);
      sprintf(hs, "Error        : Your mail was rejected by %s", w);
    } else if ((hptr->msgflags & MSG_SFERR) != 0) {
      extract_readcalls(true, hptr->readby, w);
      sprintf(hs,
	"Error        : The next bbs (%s) in the fwd has a problem with your mail",
	w);
    } else
      strcpy(hs, "Error        : Can't forward due to bad link or bad route");
  }

  string_to_file(&k, hs, true);
  sprintf(hs, "Your mail to : %s@%s", hptr->dest, hptr->verbreitung);
  string_to_file(&k, hs, true);
  sprintf(hs, "Your subject : %s", hptr->betreff);
  string_to_file(&k, hs, true);
  sprintf(hs, "%ld", (clock_.ixtime - hptr->rxdate) / 86400L);
  if (unread || unknown)
    sprintf(hs, "Deleted after: %s days", strcpy(STR7, hs));
  else
    sprintf(hs, "Tried for    : %s days", strcpy(STR1, hs));
  string_to_file(&k, hs, true);
  *hs = '\0';
  string_to_file(&k, hs, true);
  sprintf(hs, "73s from %s %s", ownhiername, ownfheader);
  string_to_file(&k, hs, true);
  *hs = '\0';
  string_to_file(&k, hs, true);
  if (strpos2(hptr->betreff, "CP ", 1) == 1)
  {
    sfclose(&k);
    return k;
  }
  if (unknown)
    strcpy(hs, "undeliverable mail follows:");
  else if (unread)
    strcpy(hs, "unread mail follows:");
  else
    strcpy(hs, "unrouteable mail follows:");
  string_to_file(&k, hs, true);

  *hs = '\0';
  for (x = 1; x <= 79; x++)
    strcat(hs, "-");
  string_to_file(&k, hs, true);
  return k;
}


#define maxret          1500


Static void returnmail(boolean pack, short *handle, uchar *buf, long size)
{
  long size2;
  short k, i;
  boolean first;
  Char hs[256], s[256], s1[256], lastr[256], tname[256], tname2[256];
  Char STR1[256], STR7[256];

  if (*handle < minhandle)
    return;
  sprintf(tname, "%sretmail%c001", tempdir, extsep);
  validate(tname);
  k = sfcreate(tname, FC_FILE);
  if (k >= minhandle) {
    sfwrite(k, size, buf);
    sfclose(&k);

    if (pack) {
      strcpy(tname2, tname);
      validate(tname2);
      if (huffpacker(false, tname, tname2, false) != 0) {
	sfdelfile(tname);
	sfdelfile(tname2);
	sfclose(handle);
	return;
      }
      sfdelfile(tname);
      strcpy(tname, tname2);
    }

    k = sfopen(tname, FO_READ);
    if (k >= minhandle) {
      *s = '\0';
      *lastr = '\0';
      first = true;
      while (file_to_string(k, hs) && strpos2(hs, "R:", 1) == 1) {
	strcpy(lastr, hs);
	i = strpos2(hs, "@", 1);
	if (i <= 0)
	  continue;
	strdelete((void *)hs, 1, i);
	if (hs[0] == ':')
	  strdelete((void *)hs, 1, 1);
	get_word(hs, s1);
	unhpath(s1, hs);
	if (first) {
	  strcpy(s, Console_call);
	  first = false;
	}
	sprintf(s + strlen(s), "!%s", hs);
	if (strlen(s) >= 67) {
	  sprintf(s, "Path: %s", strcpy(STR7, s));
	  string_to_file(handle, s, true);
	  *s = '\0';
	}
      }
      if (*s != '\0') {
	sprintf(s, "Path: %s!", strcpy(STR1, s));
	string_to_file(handle, s, true);
      }
      if (*lastr != '\0') {
	sprintf(lastr, "Sent: %s", strcpy(STR1, lastr));
	cut(lastr, 79);
	string_to_file(handle, lastr, true);
      }
      *s = '\0';
      string_to_file(handle, s, true);
      string_to_file(handle, hs, true);
      size2 = strlen(hs);
      while (size2 < maxret && file_to_string(k, hs) &&
	     strpos2(hs, "#BIN#", 1) != 1) {
	if (strpos2(hs, "/ACK", 1) != 1) {
	  string_to_file(handle, hs, true);
	  size2 += strlen(hs);
	}
      }
      if (strpos2(hs, "#BIN#", 1) == 1) {
	strcpy(hs, "(*** binary file)");
	string_to_file(handle, hs, true);
	size2 = maxret;
      }
      if (size2 >= maxret) {
	*hs = '\0';
	for (i = 1; i <= 79; i++)
	  strcat(hs, "-");
	string_to_file(handle, hs, true);
	strcpy(hs, "returned mail shortened");
	string_to_file(handle, hs, true);
      }
      sfclose(&k);
    }
    sfdelfile(tname);
  }
  sfclose(handle);
}

#undef maxret


void delete_invalid_board(Char *fname)
{
  Char hs[255], STR1[255];
  
  sprintf(STR1, "%s%s", indexdir, fname);
  sfdelfile(STR1);
  strcpy(hs, fname);
  new_ext(hs, inf_e);
  sprintf(STR1, "%s%s", infodir, hs);
  sfdelfile(STR1);
}


Static long lastxreroute;


#define fmemname        "DPGARBAG.001"


void garbage_collection(boolean xgar, boolean fill_cbyte, boolean check_all,
			boolean immediate, short unr)
{
  indexstruct *hptr, header, *nhptr;
  boxlogstruct blog;
  short kin_index, kout_index, kin_info, kout_info;
  boolean output_opened, m_changed;
  long in_info_size, spos, tomorrowct;
  short ct, k;
  DTA dirinfo;
  short result, sflfsp, tomorrow;
  boolean garbage_error;
  long err, obsolete, dsize;
  short fmem;
  uchar *copybuf;
  long cbsize, bct, boardct, hsize, rs;
  boolean do_it;
  long ddiff1, ddiff2;
  short kx, k1;
  boolean no_info, unknown_user;
  long freeonhd, diff, packgewinn;
  Char swappart;
  boolean swap_info, swap_index;
  long seconds, tbytes, tmsgs, bps;
  short delct;
  long tbzs, tmsgszs;
  uchar *ipuffer;
  long isize;
  short new_ct;
  boolean copied, tempramdisk;
  long lastend;
  boolean from_disk, iscall;
  uchar fbyte;
  short returnhandle, nhv;
  long l1;
  boolean invheader, reroute;
  unsigned short ics;

  Char temp1[256], temp2[256];
  Char hs[256], w[256], w1[256], umbbs[256];
  Char dname[256], fmemfile[256];
  Char oinfname[256];
  Char oidxname[256];
  Char ninfname[256];
  Char nidxname[256];
  Char STR1[256];
  Char TEMP;
  short FORLIM;
  Char STR13[256];

  x_garbage_waiting = false;

  if (!xgar) {  /* alle rauswerfen */
    debug(1, unr, 15, "start");
    disc_user(unr, "ALL *** system reorganisation");
    if (boxhoststarted())
      boxsendallbufs();
    sprintf(STR1, "%sgarbage%cbat", boxsysdir, extsep);
    run_sysbatch(STR1);
    boxsaveallbuffers();
    boxfreemostram(true);
    free_boxbcastdesc();
    if (maxavail__() <= 100000L) {
      debug(0, unr, 15, "no mem - aborted");
      return;
    }
  } else
    debug(2, unr, 15, "(X) start");

  tempramdisk = false;
  m_changed = false;
  bps = 0;
  tbytes = 0;
  tmsgs = 0;
  obsolete = 0;
  packgewinn = 0;
  seconds = sys_ixtime();
  *ninfname = '\0';
  *nidxname = '\0';
  ipuffer = NULL;
  copybuf = NULL;
  kin_info = nohandle;
  kout_info = nohandle;
  kout_index = nohandle;
  kin_index = nohandle;
  tomorrow = nohandle;
  fmem = nohandle;
  returnhandle = nohandle;
  nhv = nohandle;
  tomorrowct = 0;
  boardct = 0;
  freeonhd = DiskFree(drv2num(laufwerk));

  if (!xgar) {
    wln_btext(unr, 33);
    wlnuser0(unr);
    boxspoolread();
    boxsgdial();

    boxsetgdial(xgar, "", 0, 0, 0, 0, 0, "");

    garbramdisk = false;

    sprintf(temp1, "%sGARBAGE%cTP", tempdir, extsep);
    sprintf(temp2, "%s2", temp1);
    strcat(temp1, "1");

    boxisbusy(true);

    boxsetgdial(xgar, "", 0, 0, 0, 0, 0, "deleting boxlog");
    sfdelfile(boxlog);
    sfdelfile(eralog);
    append_profile(unr, "starting garbage collection");
    boxsetgdial(xgar, "", 0, 0, 0, 0, 0, "checking diskspace");

    boxsetgdial(xgar, "", 0, 0, 0, 0, 0, "creating filelist");

    delete_tempboxfiles();

    sprintf(STR1, "%stomorrow%cdel", tempdir, extsep);
    tomorrow = sfcreate(STR1, FC_FILE);
    string_to_file(&tomorrow, "expired lifetime:", true);
    string_to_file(&tomorrow, "", true);

    sprintf(fmemfile, "%s%s", tempdir, fmemname);
    validate(fmemfile);
    fmem = sfcreate(fmemfile, FC_FILE);

    if (fmem <= minhandle) {
      sprintf(hs, "can't create sortfile %s", fmemfile);
      debug(0, unr, 15, hs);
      boxisbusy(false);
      return;
    }

    sprintf(STR1, "%s%c%c%s", indexdir, allquant, extsep, idx_e);
    result = sffirst(STR1, 0, &dirinfo);

    while (result == 0) {
      strcpy(hs, dirinfo.d_fname);
      if (dirinfo.d_length > 0 && dirinfo.d_length % sizeof(indexstruct) == 0) {
	del_ext(hs);
	del_lastblanks(hs);
	if (*hs != '\0') {
	  sprintf(w, "%ld", dirinfo.d_length);
	  sprintf(hs + strlen(hs), " %s", w);
	  string_to_file(&fmem, hs, true);
	} else {
	  sprintf(STR1, "invalid filename: %s - deleted.", dirinfo.d_fname);
	  debug(0, unr, 14, STR1);
	  delete_invalid_board(dirinfo.d_fname);
	}
      } else {
	sprintf(STR1, "odd length: %s - deleted", hs);
	debug(0, unr, 14, STR1);
	delete_invalid_board(dirinfo.d_fname);
      }
      result = sfnext(&dirinfo);
    }
    sfclose(&fmem);
    sort_file(fmemfile);

    fmem = sfopen(fmemfile, FO_READ);
    if (fmem <= minhandle) {
      sprintf(hs, "can't open sortfile %s", fmemfile);
      debug(0, unr, 15, hs);
      boxisbusy(false);
      return;
    }

  } else {
    sprintf(STR1, "%sX%c%s", indexdir, extsep, idx_e);
    if (!exist(STR1))
      return;
    strcpy(dname, "X");
    fmem = nohandle;   /* doppelt, aber wer weiss */
  }




  while (xgar && boardct == 0 || file_to_string(fmem, hs)) {
    dsize = 0;
    if (!xgar) {
      get_word(hs, dname);
      dsize = str2lint(hs);
    }

    boardct++;

    dp_watchdog(2, 4711);   /* Watchdog resetten         */
    swap_index = false;
    swap_info = false;
    unknown_user = false;
    iscall = callsign(dname);

    debug(4, unr, 16, dname);
    sprintf(oidxname, "%s%s%c%s", indexdir, dname, extsep, idx_e);
    sprintf(oinfname, "%s%s%c%s", infodir, dname, extsep, inf_e);
    sprintf(nidxname, "%s%s%c%s", indexdir, dname, extsep, gidx_e);
    sprintf(ninfname, "%s%s%c%s", infodir, dname, extsep, ginf_e);
    upper(dname);

    if (xgar)
      dsize = sfsize(oidxname);

    delct = 0;
    boxsetgdial(xgar, dname, 0, delct, tbytes, tmsgs, bps, "checking...");
    no_info = false;
    if (strlen(dname) == 1) {
      TEMP = upcase_(dname[0]);
      if (TEMP == 'M' || TEMP == 'X')
	no_info = true;
    }
    garbage_error = false;
    kin_info = nohandle;
    kout_info = nohandle;
    kout_index = nohandle;
    kin_index = nohandle;
    copybuf = NULL;
    ipuffer = NULL;
    isize = 0;
    if (maxavail__() - dsize > 500000L)
      sfbread(false, oidxname, &ipuffer, &isize);

    from_disk = (isize <= 0);
    if (from_disk) {
      /*   dsize   := sfsize(oidxname); */
      kin_index = sfopen(oidxname, FO_READ);
      if (kin_index <= minhandle) {
        sprintf(hs, "can't open index file %s", oidxname);
	debug(0, unr, 15, hs);
	goto _L2;
      }
      boxsetgdial(xgar, dname, 0, delct, tbytes, tmsgs, bps,
		  "checking (on disk)...");
    } else
      dsize = isize;

    output_opened = false;
    spos = 0;
    k = dsize / sizeof(indexstruct);
    ct = 1;
    tmsgszs = 0;
    tbzs = 0;
    umbbs[0] = '\0';

    if (lastxreroute == 0)
      lastxreroute = clock_.ixtime;
    reroute = (!strcmp(dname, "X") && clock_.ixtime - lastxreroute > 14400);
    if (reroute)
      lastxreroute = clock_.ixtime;

    do_it = (!strcmp(dname, "X") || !strcmp(dname, "M") ||
	     (fill_cbyte || check_all || reroute) && k > 0);

    while (ct <= k && !do_it) {
      if (from_disk) {
	read_index(kin_index, ct, &header);
	hptr = &header;
      } else
	hptr = (indexstruct *)(&ipuffer[(ct - 1) * sizeof(indexstruct)]);

      if (check_hcs(*hptr)) {
	tmsgszs++;
	if (!no_info)
	  tbzs += hptr->size;

	do_it = hptr->deleted;
	if (do_it) {
	  if (erasewait > 0 && strcmp(dname, "X") && strcmp(dname, "M") &&
	      hptr->erasetime > 0 &&
	      clock_.ixtime - hptr->erasetime < erasewait && !immediate)
	    do_it = false;
	}

	if (!do_it) {
	  sflfsp = ct;

	  if (!hptr->deleted) {
	    ddiff2 = clock_.ixtime - hptr->rxdate;
	    if (hptr->lifetime > 0)
	      do_it = (ddiff2 >= hptr->lifetime * 86400L);
	  }

	  if (!do_it) {
	    ddiff1 = clock_.ixtime - hptr->rxdate;
	    do_it = (hptr->size >= packmin && (hptr->pmode & PM_HUFF2) == 0 &&
		     !no_info && (ddiff1 >= packdelay * 86400L || disk_full));
	  }

	  if (!do_it)
	    do_it = !callsign(hptr->absender);

	  if (!do_it && iscall && strcmp(dname, Console_call))
	  {  /* return mailer */
	    if (hptr->fwdct == 0 && clock_.ixtime - hptr->rxdate >= returntime) {
	      if ((hptr->msgflags & (MSG_CUT | MSG_OWNHOLD)) == 0) {
		unhpath(hptr->verbreitung, hs);
		if (strcmp(hs, Console_call))
		  do_it = true;
		else {
		  /* @console_call, nachschauen, ob wir den User kennen */
		  if (*umbbs == '\0')
		    user_mybbs(dname, umbbs);
		  unhpath(umbbs, w);
		  if (strcmp(w, Console_call)) {
		    do_it = true;
		    unknown_user = true;
		  }
		}
	      }
	    }
	  }

	  if (!do_it && iscall) {
	    if (hptr->fwdct == 0 &&
		(hptr->msgflags & (MSG_REJECTED | MSG_DOUBLE | MSG_SFNOFOUND)) != 0)
	      do_it = true;
	  }

	  if (!do_it && iscall) {
	    unhpath(hptr->verbreitung, hs);
	    do_it = !callsign(hs);
	  }

	}

      } else
	do_it = true;
      ct++;
    }


    if (do_it) {
      in_info_size = sfsize(oinfname);

      boxsetgdial(xgar, "1", 0, delct, tbytes, tmsgs, bps, "optimizing...");

      swappart = '0';


    }


    if (!do_it) {
      sfclose(&kin_index);
      if (ipuffer != NULL)
	mymfreep(&ipuffer);
      isize = 0;
      tbytes += tbzs;
      tmsgs += tmsgszs;
    } else {
      k = dsize / sizeof(indexstruct);

      new_ct = 0;
      lastend = 0;
      nhptr = NULL;
      FORLIM = k;
      for (ct = 1; ct <= FORLIM; ct++) {
	fbyte = 0;
	copybuf = NULL;
	sfclose(&returnhandle);

	if (ct % 20 == 0 || ct == 1)   /* Watchdog resetten         */
	  dp_watchdog(2, 4711);

	boxsetgdial(xgar, "1", ct, delct, tbytes, tmsgs, bps, "1");

	if (from_disk) {
	  read_index(kin_index, ct, &header);
	  hptr = &header;
	} else
	  hptr = (indexstruct *)(&ipuffer[(ct - 1) * sizeof(indexstruct)]);

	if (!check_hcs(*hptr)) {
	  hptr->deleted = true;
	  invheader = true;
	} else
	  invheader = false;

	if (!hptr->deleted) {  /* denn dann fliegt's sowieso raus-- */
	  if (!strcmp(dname, "X")) {
	    if (!xgar) {
	      if (hptr->pmode == 16)
		hptr->pmode = 4;
	      hptr->pmode &= ~128;
	      if ((hptr->pmode & 2) != 0 || (hptr->pmode & 4) != 0) {
		if (labs(clock_.ixtime - hptr->rxdate) > bullsfwait)
		  hptr->deleted = true;
	      }
	    }
	    if (reroute && hptr->pmode != 16 && !hptr->deleted) {
	      unhpath(hptr->verbreitung, hs);
	      if (callsign(hs)) {
		if (smart_routing ||
		    clock_.ixtime - hptr->rxdate > returntime >> 1) {
		  find_neighbour(0, hs, w);
		  if (*w != '\0' && strcmp(w, hptr->rxfrom))
		    strcpy(hptr->dest, w);
		}
	      }
	    }
	  } else if (!strcmp(dname, "M")) {
	    hptr->eraseby = 0;   /* read_today loeschen */
	    ddiff2 = hptr->rxdate;
	    if (hptr->lastread > ddiff2)
	      ddiff2 = hptr->lastread;
	    if (hptr->txdate > ddiff2)
	      ddiff2 = hptr->txdate;
	    if (ddiff2 > 0 && clock_.ixtime - ddiff2 > 31536000) {
	      sprintf(hs,
		      "deleting user entry of %s (>365 days of inactivity)",
		      hptr->absender);
	      append_profile(unr, hs);
	      hptr->deleted = true;
	    }
	  } else {
	    ddiff2 = clock_.ixtime - hptr->rxdate;

	    if (!hptr->deleted && iscall) {  /* fehlerhafte usermails */
	      if ((hptr->msgflags & MSG_OWNHOLD) == 0) {
		if (hptr->lifetime > erasedelay) {
		  unhpath(hptr->verbreitung, hs);
		  if (!callsign(hs))
		    hptr->lifetime = erasedelay;
		}
	      }
	    }

	    if (hptr->lifetime > 0) {
	      if (ddiff2 >= hptr->lifetime * 86400L) {
		hptr->eraseby = EB_LIFETIME;

		if (iscall) {
		  if (hptr->fwdct == 0) {
		    if ((hptr->msgflags & (MSG_CUT | MSG_OWNHOLD | MSG_DOUBLE)) ==
			0) {
		      if (strpos2(hptr->betreff, "ACK:", 1) != 1) {
			if (*hptr->sendbbs != '\0' &&
			    strpos2(hptr->readby, dname, 1) == 0) {
			  returnhandle = retmailinf(hptr,
			      (hptr->msgflags & MSG_SFERR) == 0,
			      unknown_user);
			  sprintf(hs,
			    "informed %s@%s about deletion of unread mail for %s@%s",
			    hptr->absender, hptr->sendbbs, dname,
			    hptr->verbreitung);
			  append_profile(unr, hs);
			}
			hptr->eraseby = EB_RETMAIL;
		      }
		    }
		  }

		}


		hptr->deleted = true;
		hptr->erasetime = clock_.ixtime;

		if (!xgar && tomorrow >= minhandle) {
		  conv_idx_to_blog(dname, new_ct + 1, *hptr, &blog);
		  if (tomorrowct == 0) {
		    get_btext(unr, 17, hs);
		    string_to_file(&tomorrow, hs, true);
		    *hs = '\0';
		    string_to_file(&tomorrow, hs, true);
		  }
		  tomorrowct++;
		  disp_logptr(-1, tomorrowct, false, &blog, hs);
		  string_to_file(&tomorrow, hs, true);
		}

	      }

	    }

	    if (!hptr->deleted)
	      hptr->deleted = !callsign(hptr->absender);

	    if (!hptr->deleted && iscall && strcmp(dname, Console_call))
	    {  /* return mailer */
	      if (hptr->fwdct == 0 &&
		  clock_.ixtime - hptr->rxdate >= returntime) {
		if ((hptr->msgflags & (MSG_CUT | MSG_OWNHOLD | MSG_DOUBLE)) ==
		    0) {
		  if (strpos2(hptr->betreff, "ACK:", 1) != 1 &&
		      strpos2(hptr->betreff, "CP ", 1) != 1) {
		    unhpath(hptr->verbreitung, hs);
		    if (strcmp(hs, Console_call) || unknown_user) {
		      if (callsign(hs) && *hptr->sendbbs != '\0' &&
			  strpos2(hptr->readby, dname, 1) == 0 &&
			  strcmp(hptr->absender, Console_call)) {
			returnhandle = retmailinf(hptr, false, unknown_user);
			if (unknown_user)
			  sprintf(hs, "unknown: %s@%s informed sender %s@%s",
				  dname, hptr->verbreitung, hptr->absender,
				  hptr->sendbbs);
			else
			  sprintf(hs,
				  "informed %s@%s about fwd err for %s@%s",
				  hptr->absender, hptr->sendbbs, dname,
				  hptr->verbreitung);
			append_profile(unr, hs);
		      } else {
			if (unknown_user)
			  sprintf(hs, "unknown: %s@%s, sender not informed",
				  dname, hptr->verbreitung);
			else
			  sprintf(hs,
				  "fwd failed for %s@%s, sender not informed",
				  dname, hptr->verbreitung);
			append_profile(unr, hs);
		      }
		      hptr->deleted = true;
		      hptr->erasetime = clock_.ixtime;
		      hptr->eraseby = EB_RETMAIL;
		    }
		  } else {
		    hptr->deleted = true;
		    hptr->erasetime = clock_.ixtime;
		    hptr->eraseby = EB_SFERR;
		  }
		}
	      }
	    }

	    if (!hptr->deleted && iscall && hptr->fwdct == 0)
	    {  /* rerouter nummer 2 */
	      if ((hptr->msgflags &
		   (MSG_REJECTED | MSG_DOUBLE | MSG_SFNOFOUND)) != 0) {
		if ((hptr->msgflags & (MSG_CUT | MSG_OWNHOLD)) == 0) {
		  unhpath(hptr->verbreitung, hs);
		  if (strcmp(hs, Console_call)) {
		    if (callsign(hs) && *hptr->sendbbs != '\0' &&
			strpos2(hptr->readby, dname, 1) == 0) {
		      *hs = '\0';
		      hptr->msgflags &= ~(MSG_REJECTED | MSG_DOUBLE |
					  MSG_SFNOFOUND);
		      hptr->msgflags &= vermerke_sf(-1, false, dname,
						    hptr->rxfrom, hs, *hptr,
						    hs);
		    }
		  }
		}
	      }
	    }

	  }
	}


	if (hptr->deleted && !strcmp(dname, "M")) {
	  m_changed = true;
	  sprintf(STR1, "%s%s%cEXT", extuserdir, hptr->absender, extsep);
	  sfdelfile(STR1);
	}

	if (!hptr->deleted || returnhandle >= minhandle ||
	    (erasewait > 0 && !invheader && strcmp(dname, "X") &&
	     strcmp(dname, "M") && hptr->erasetime > 0 &&
	     clock_.ixtime - hptr->erasetime < erasewait && !immediate)) {
	  if (!output_opened) {
	    if (in_info_size >= hptr->start + hptr->packsize || no_info) {
	      if (!no_info)
		kin_info = sfopen(oinfname, FO_READ);
	      kout_index = sfcreate(nidxname, FC_FILE);
	      if (!no_info)
		kout_info = sfcreate(ninfname, FC_FILE);
	      if (!((kin_info >= minhandle || no_info) &&
		    kout_index >= minhandle &&
		    (kout_info >= minhandle || no_info))) {
		gberror1(xgar, unr, "output error (4)", &garbage_error);
		goto _L2;
	      }
	      output_opened = true;
	    } else
	      obsolete += hptr->packsize;
	  }

	  if (output_opened) {
	    if (!no_info) {
	      spos = sfseek(0, kout_info, SFSEEKEND);
	      err = sfseek(hptr->start, kin_info, SFSEEKSET);
	    }

	    if (!(err == hptr->start || no_info)) {
	      gberror1(xgar, unr, "read error (14)", &garbage_error);
	      goto _L2;
	    }
	    err = 0;

	    tmsgs++;

	    copybuf = NULL;
	    if (!no_info) {
	      tbytes += hptr->size;

	      if (hptr->packsize > maxram())
		cbsize = maxram();
	      else
		cbsize = hptr->packsize;
	      /* nur bei grossen files testen, ob genug ram da ist */
	      if (cbsize > 100000L && cbsize > maxavail__())
		cbsize = maxavail__();
	      if (cbsize > 0)
		copybuf = Malloc(cbsize);
	    }

	    if (!(copybuf != NULL || no_info)) {
	      gberror1(xgar, unr, memfailtxt, &garbage_error);
	      goto _L1;
	    }



	    if (!no_info) {
	      copied = false;

	      if (hptr->size >= packmin && (hptr->pmode & PM_HUFF2) == 0) {
		ddiff1 = clock_.ixtime - hptr->rxdate;
		if (ddiff1 >= packdelay * 86400L || disk_full) {
		  if (cbsize == hptr->packsize) {
		    bct = sfread(kin_info, cbsize, copybuf);
		    ics = 0;
		    checksum16_buf(copybuf, bct, &ics);
		    fbyte = copybuf[0];
		    if (!(bct == cbsize && hptr->infochecksum == ics &&
			  (fill_cbyte || fbyte == hptr->firstbyte))) {
		      bct = 0;
		      gberrclose(bct, dname, unr, xgar, &copybuf,
				 &garbage_error, 2, &nhv, ct, "",
				 hptr->infochecksum != ics);
		      goto _L2;
		    }
		    returnmail(false, &returnhandle, copybuf, bct);
		    l1 = hptr->packsize;


		    kx = hptr->pmode;
		    diff = l1;
		    pack_entry(&copybuf, &l1, &kx);
		    hptr->infochecksum = 0;
		    checksum16_buf(copybuf, l1, &hptr->infochecksum);
		    fbyte = copybuf[0];
		    hptr->firstbyte = fbyte;
		    packgewinn += diff - l1;
		    hptr->packsize = l1;
		    hptr->pmode = kx;
		    if (sfwrite(kout_info, hptr->packsize, copybuf) !=
			hptr->packsize) {
		      gberrclose(bct, dname, unr, xgar, &copybuf,
				 &garbage_error, 1, &nhv, ct, "", false);
		      goto _L2;
		    }
		    copied = true;
		    err = hptr->packsize;
		  } else {
		    k1 = sfcreate(temp1, FC_FILE);
		    if (k1 >= minhandle) {
		      hsize = 0;
		      err = 0;
		      ics = 0;
		      rs = hptr->packsize;
		      while (rs > 0) {
			if (rs > cbsize)
			  rs = cbsize;
			bct = sfread(kin_info, rs, copybuf);
			checksum16_buf(copybuf, bct, &ics);
			if (hsize == 0)
			  fbyte = copybuf[0];
			if (bct <= 0 || sfwrite(k1, bct, copybuf) < 0 ||
			    fbyte != hptr->firstbyte && !fill_cbyte) {
			  if (fbyte != hptr->firstbyte && !fill_cbyte)
			    bct = 0;
			  gberrclose(bct, dname, unr, xgar, &copybuf,
				     &garbage_error, 3, &k1, ct, temp1,
				     false);
			  goto _L2;
			}
			returnmail(false, &returnhandle, copybuf, bct);
			hsize += bct;
			rs = hptr->packsize - hsize;
		      }
		      if (hptr->infochecksum != ics) {
			gberrclose(bct, dname, unr, xgar, &copybuf,
				   &garbage_error, 13, &k1, ct, temp1, true);
			goto _L2;
		      }
		      sfclose(&k1);

		      if (huffpacker(true, temp1, temp2, false) == 0) {
			sfdelfile(temp1);
			k1 = sfopen(temp2, FO_READ);
			if (k1 >= minhandle) {
			  hptr->packsize = sfsize(temp2);
			  hptr->pmode |= PM_HUFF2;

			  hsize = 0;
			  err = 0;
			  hptr->infochecksum = 0;
			  rs = hptr->packsize;
			  while (rs > 0) {
			    if (rs > cbsize)
			      rs = cbsize;
			    bct = sfread(k1, rs, copybuf);
			    checksum16_buf(copybuf, bct, &hptr->infochecksum);
			    if (hsize == 0) {
			      fbyte = copybuf[0];
			      hptr->firstbyte = fbyte;
			    }
			    if (bct <= 0 ||
				sfwrite(kout_info, bct, copybuf) < 0) {
			      bct = 0;
			      gberrclose(bct, dname, unr, xgar, &copybuf,
					 &garbage_error, 4, &k1, ct, temp2,
					 false);
			      goto _L2;
			    }
			    hsize += bct;
			    rs = hptr->packsize - hsize;
			  }
			  sfclose(&k1);
			  sfdelfile(temp2);
			  copied = true;
			  err = hptr->packsize;

			}
		      } else
			sfdelfile(temp1);
		      sfdelfile(temp2);
		    }
		  }


		}

	      }

	      if (!copied) {
		hsize = 0;
		err = 0;
		ics = 0;
		rs = hptr->packsize;
		while (rs > 0) {
		  if (rs > cbsize)
		    rs = cbsize;
		  bct = sfread(kin_info, rs, copybuf);
		  checksum16_buf(copybuf, bct, &ics);
		  if (hsize == 0)
		    fbyte = copybuf[0];
		  if (!(bct > 0 && (fill_cbyte || fbyte == hptr->firstbyte))) {
		    bct = 0;
		    gberrclose(bct, dname, unr, xgar, &copybuf,
			       &garbage_error, 6, &nhv, ct, "", false);
		    goto _L2;
		  }
		  returnmail((hptr->pmode & PM_HUFF2) != 0, &returnhandle,
			     copybuf, bct);
		  if (sfwrite(kout_info, bct, copybuf) != bct) {
		    gberrclose(bct, dname, unr, xgar, &copybuf,
			       &garbage_error, 5, &nhv, ct, "", false);
		    goto _L2;
		  }
		  err += bct;
		  hsize += bct;
		  rs = hptr->packsize - hsize;
		}
		if (hptr->infochecksum != 0) {
		  if (ics != hptr->infochecksum) {
		    gberrclose(bct, dname, unr, xgar, &copybuf,
			       &garbage_error, 15, &nhv, ct, "", true);
		    goto _L2;
		  }
		} else
		  hptr->infochecksum = ics;
	      } else
		err = hptr->packsize;

	      mymfreep(&copybuf);

	    }

	    if (!(err == hptr->packsize || no_info)) {
	      gberror1(xgar, unr, "write error-disk full", &garbage_error);
	      sfclose(&kin_index);
	      sfclose(&kin_info);
	      sfclose(&kout_index);
	      sfclose(&kout_info);
	      sfdelfile(nidxname);
	      sfdelfile(ninfname);
	      goto _L1;
	    }


	    if (!no_info)
	      hptr->start = spos;

	    if (fill_cbyte)
	      hptr->firstbyte = fbyte;

	    create_hcs(hptr);
	    if (sfwrite(kout_index, sizeof(indexstruct), (uchar *)hptr) !=
		sizeof(indexstruct)) {
	      gberror1(xgar, unr, "write error (12)", &garbage_error);
	      goto _L2;
	    }

	    new_ct++;
	    if (!strcmp(dname, "X")) {
	      if (ct != new_ct)
		replace_x_nr(ct, new_ct);
	    }

	    if (copybuf != NULL)
	      mymfreep(&copybuf);
	  }

	} else {
	  obsolete += hptr->packsize;
	  delct++;
	}

      }

      boxsetgdial(xgar, "1", k, delct, tbytes, tmsgs, bps, "1");

      sfclose(&kin_index);
      sfclose(&kin_info);
      sfclose(&kout_index);
      sfclose(&kout_info);

      if (!garbage_error) {
	sfdelfile(oidxname);
	if (!no_info)
	  sfdelfile(oinfname);

	if (output_opened) {
	  if (swap_index)
	    filemove(nidxname, oidxname);
	  else
	    sfrename(nidxname, oidxname);

	  if (!no_info) {
	    if (swap_info)
	      filemove(ninfname, oinfname);
	    else
	      sfrename(ninfname, oinfname);
	  }
	}


      } else {
	sfdelfile(nidxname);
	if (!no_info)
	  sfdelfile(ninfname);
      }


    }


    if (ipuffer != NULL) {
      mymfreep(&ipuffer);
      isize = 0;
    }

    if (m_changed) {
      m_changed = false;
      load_mptr();
      init_ufcache();
    }

  }


_L2:
  sfclose(&kin_index);   /* wenn schon geschlossen, dann  */
  sfclose(&kin_info);   /* merkt das sfclose und tut     */
  sfclose(&kout_index);   /* nichts                        */
  sfclose(&kout_info);

_L1:
  if (copybuf != NULL)
    mymfreep(&copybuf);

  sfclose(&returnhandle);

  if (garbage_error) {
    sfdelfile(nidxname);
    sfdelfile(ninfname);
  }

  if (ipuffer != NULL) {
    mymfreep(&ipuffer);
    isize = 0;
  }

  if (tomorrowct == 0)
    sfclosedel(&tomorrow);
  else
    sfclose(&tomorrow);
  sfclosedel(&fmem);

  if (xgar)
    return;

  boxegdial();

  sprintf(hs, "%ld", obsolete);
  sprintf(hs, "Deleted          : %s Bytes", strcpy(STR13, hs));
  wlnuser(unr, hs);
  append_profile(unr, hs);
  sprintf(hs, "%ld", packgewinn);
  sprintf(hs, "Saved by packing : %s Bytes", strcpy(STR1, hs));
  wlnuser(unr, hs);
  append_profile(unr, hs);
  sprintf(hs, "%ld", tbytes);
  sprintf(hs, "Total Bytes      : %s", strcpy(STR1, hs));
  wlnuser(unr, hs);
  append_profile(unr, hs);
  sprintf(hs, "%ld", tmsgs);
  sprintf(hs, "Total Msgs       : %s", strcpy(STR1, hs));
  wlnuser(unr, hs);
  append_profile(unr, hs);
  wlnuser0(unr);
  create_new_boxlog(unr, false);
  wlnuser0(unr);
  wlnuser(unr, "Checking HPATH.BOX");
  boxspoolread();
  dp_watchdog(2, 4711);   /* watchdog resetten         */
  check_hpath(true);
  wlnuser(unr, "Checking MYBBS.BOX");
  boxspoolread();
  dp_watchdog(2, 4711);   /* watchdog resetten         */
  check_mybbsfile();
  init_ufcache();
  dp_watchdog(2, 4711);   /* watchdog resetten         */
  kill_resume();
  utc_clock();
  seconds = clock_.ixtime - seconds;
  sprintf(hs, "%ld", seconds / 3600);
  sprintf(w, "%ld", seconds % 3600 / 60);
  sprintf(w1, "%ld", seconds % 60);
  sprintf(hs, "used time: %sh %smin %ssec", strcpy(STR13, hs), w, w1);
  wlnuser(unr, hs);

  boxcheckdiskspace();

  append_profile(unr, "ending garbage collection");

  if (!disk_full) {
    imp_sysfile(profile_box, "profile");
    imp_sysfile(r_erase_box, "remote erases");
    sprintf(hs, "%sfile_err%ctxt", boxprotodir, extsep);
    imp_sysfile(hs, "file errors");
    sprintf(hs, "%ssyslog%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "syslog");
    sprintf(hs, "%slostfile%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "lost files");
    sprintf(hs, "%suserlog%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "userlog");
    sprintf(hs, "%susrsflog%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "usersflog");
    sprintf(hs, "%sreadlog%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "readlog");
    sprintf(hs, "%ssflog%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "sflog");
    sprintf(hs, "%sconvlog%cbox", boxprotodir, extsep);
    imp_sysfile(hs, "convlog");

    sprintf(STR13, "%s%c%cPRO", boxprotodir, allquant, extsep);
    result = sffirst(STR13, 0, &dirinfo);
    while (result == 0) {
      strcpy(w, dirinfo.d_fname);
      sprintf(hs, "%s%s", boxprotodir, w);
      imp_sysfile(hs, w);
      result = sfnext(&dirinfo);
    }

    sprintf(STR13, "%s%c%cERR", boxprotodir, allquant, extsep);
    result = sffirst(STR13, 0, &dirinfo);
    while (result == 0) {
      strcpy(w, dirinfo.d_fname);
      sprintf(hs, "%s%s", boxprotodir, w);
      del_ext(w);
      if (in_sfp(w)) {
	if (forwerr) {
	  sprintf(STR13, "&%s", hs);
	  send_sysmsg(w, w, "forward errors", STR13, 3);
	}
	strcat(w, " forward errors");
	imp_sysfile(hs, w);   /* Kopie an Y */
      } else
	sfdelfile(hs);
      result = sfnext(&dirinfo);
    }

    sprintf(hs, "%stomorrow%cdel", tempdir, extsep);
    imp_sysfile(hs, "expired mails");

    wlnuser(unr, "Generating WP updates");
    boxspoolread();
    generate_wp_files();

    if (clock_.day == 1) {
      wlnuser(unr, "Generating monthly statistics");
      boxspoolread();
      generate_sfstat(-1);
    } else if (clock_.day > 24) {
      k = clock_.mon;
      if (k == 12)
	k = 1;
      else
	k++;
      sprintf(hs, "%ld", k);
      sprintf(hs, "%sboxlog%s%cbox", boxprotodir, strcpy(STR1, hs), extsep);
      sfdelfile(hs);
    }

    sprintf(STR1, "%simport%c%c", newmaildir, extsep, allquant);
    sort_new_mail(-1, STR1, Console_call);   /* return-mails und andere... */

  }

  sprintf(STR1, "%stomorrow%cdel", tempdir, extsep);
  sfdelfile(STR1);
  boxreadallbuffers();
  boxisbusy(false);
  load_boxbcastparms(bcast_box);
}

#undef fmemname


/* Gibt an, welche Indexnummer der Rubrik die letzte gueltige fuer den       */
/* aktuellen User ist. Hidden-Flag und Level werden beachtet, auch ufilhide  */
/* Das Indexfile wird auf Wunsch im Speicher gehalten (so es reinpasst)      */

short last_valid(short unr, Char *brett, boolean hold, uchar **start,
		 long *size)
{
  short Result;
  indexstruct header, *hpointer;
  userstruct uf;
  long isize;
  short k, mct;
  boolean hit, iscall, ufloaded, ownboard;
  unsigned short lt, acc;
  uchar *puffer;
  Char hs[256];
  Char STR1[256];

  *start = NULL;
  *size = 0;
  Result = 0;
  lt = 0;
  acc = SHORT_MAX;

  if (!boxrange(unr))
    return Result;

  debug(3, unr, 18, brett);

  if (strlen(brett) == 1) {
    if (user[unr]->supervisor || user[unr]->rsysop) {
      if (!may_sysaccess(unr, brett))
	return Result;
      check_lt_acc(brett, &lt, &acc);
    } else
      acc = SHORT_MAX;
  } else
    check_lt_acc(brett, &lt, &acc);

  if (user[unr]->level < acc)
    return Result;

  hit = false;
  iscall = callsign(brett);
  ownboard = (iscall && !strcmp(brett, user[unr]->call));
  ufloaded = false;
  uf.readlock = 2;

  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  isize = sfsize(STR1);
  if (isize <= 0) {
    *size = 0;
    return Result;
  }
  mct = isize / sizeof(indexstruct);
  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return Result;

  puffer = NULL;
  if (hold && isize <= maxram())   /*or (isize <= 20000)*/
    puffer = Malloc(isize);

  if (puffer != NULL) {
    if (sfread(k, isize, puffer) == isize) {
      while (mct > 0 && hit == false) {
	hpointer = (indexstruct *)(&puffer[(mct - 1) * sizeof(indexstruct)]);
	if (hpointer->deleted != user[unr]->hidden) {
	  mct--;
	  continue;
	}
	/* hier ist mit absicht kein check_hcs drin... */
	if (!(iscall || hpointer->msgtype != 'B') || user[unr]->supervisor) {
	  hit = true;
	  break;
	}
	if (iscall && !ufilhide && !ufloaded) {
	  load_userfile(true, false, brett, &uf);
	  if (*uf.call == '\0')
	    uf.readlock = 2;
	  ufloaded = true;
	}

	unhpath(hpointer->verbreitung, hs);

	if (ufilhide || uf.readlock == 2 || strcmp(hs, Console_call)) {
	  hit = (ownboard || !strcmp(hpointer->absender, user[unr]->call) ||
		 !strcmp(hpointer->dest, user[unr]->call));

	  if (!hit)
	    Result = -1;

	} else if (uf.readlock == 1) {
	  hit = (ownboard || !strcmp(hpointer->absender, user[unr]->call) ||
		 !strcmp(hpointer->dest, user[unr]->call) ||
		 strpos2(hpointer->readby, brett, 1) > 0);

	  if (!hit)
	    Result = -1;

	} else
	  hit = true;

	if (!hit)
	  mct--;
      }

      if (hold && hit) {
	*size = isize;
	*start = puffer;
      } else
	mymfreep(&puffer);
    } else {
      debug(0, unr, 18, "read error (15)");
      mymfreep(&puffer);
    }

  } else {
    *size = 0;
    while (mct > 0 && hit == false && k >= minhandle) {
      read_index(k, mct, &header);
      /* auch hier mit absicht kein check_hcs */
      if (header.deleted != user[unr]->hidden) {
	mct--;
	continue;
      }

      if (!(iscall || header.msgtype != 'B') || user[unr]->supervisor) {
	hit = true;
	break;
      }
      if (iscall && !ufilhide && !ufloaded) {
	load_userfile(true, false, brett, &uf);
	if (*uf.call == '\0')
	  uf.readlock = 2;
	ufloaded = true;
      }

      unhpath(header.verbreitung, hs);

      if (ufilhide || uf.readlock == 2 || strcmp(hs, Console_call)) {
	hit = (ownboard || !strcmp(header.absender, user[unr]->call) ||
	       !strcmp(header.dest, user[unr]->call));

	if (!hit)
	  Result = -1;

      } else if (uf.readlock == 1) {
	hit = (ownboard || !strcmp(header.absender, user[unr]->call) ||
	       !strcmp(header.dest, user[unr]->call) ||
	       strpos2(header.readby, brett, 1) > 0);

	if (!hit)
	  Result = -1;

      } else
	hit = true;

      if (!hit)
	mct--;
    }
  }


  sfclose(&k);
  if (hit)
    return mct;
  return Result;
}


/* Diese Routine legt ein Zusatzfile an, welches beim naechsten Aufruf der   */
/* Forwardliste beruecksichtigt wird.                                        */

typedef struct erafwdtype {
  long new_msgnum;
  char what;
  char bid[13];
  char sfcall[7];
  char new_board[9];
} erafwdtype;


void alter_fwd(char what, char *bid, long new_msgnum, char *new_board, char *sfcall)
{
  erafwdtype elog;
  short k;
  Char hs[256];

  if (strlen(bid) > 12)
    return;
  if (strlen(new_board) > 8)
    return;
  if (strlen(sfcall) > 6)
    return;
  strcpy(elog.bid, bid);
  elog.what = what;
  elog.new_msgnum = new_msgnum;
  strcpy(elog.new_board, new_board);
  strcpy(elog.sfcall, sfcall);
  
  sprintf(hs, "%salterfwd%cbox", boxstatdir, extsep);
  k = sfopen(hs, FO_RW);
  if (k < minhandle)
    k = sfcreate(hs, FC_FILE);
  if (k < minhandle) {
    return;
  }
  sfseek(0, k, SFSEEKEND);
  sfwrite(k, sizeof(erafwdtype), (uchar *)(&elog));
  sfclose(&k);
}

Static boolean in_alterfwd_list(uchar *epuffer, long esize, char *bid, char *fwdto,
			        long *epos)
{
  erafwdtype *elog;

  if (esize <= 0)
    return false;
  *epos = 0;
  while (*epos < esize) {
    elog = (erafwdtype *)(&epuffer[*epos]);
    if (!strcmp(elog->bid, bid)) {
      if ((*elog->sfcall == '\0') || (!strcmp(elog->sfcall, fwdto)))
        return true;
      else
	*epos += sizeof(erafwdtype);
    }
    else
      *epos += sizeof(erafwdtype);
  }
  return false;
}


Static void alter_fwdptr(uchar *epuffer, long esize, indexstruct *logptr,
			 long epos)
{
  erafwdtype *elog;
  
  while (epos < esize) {
    elog = (erafwdtype *)(&epuffer[epos]);
    epos += sizeof(erafwdtype);
    if (strcmp(logptr->id, elog->bid))
      continue;
    if (*elog->sfcall != '\0' && strcmp(elog->sfcall, logptr->dest))
      continue;
    
    switch (elog->what) {

    case 'E':
      logptr->deleted = true;
      break;

    case 'U':
      logptr->deleted = false;
      break;

    case 'R':
      logptr->msgflags &= ~(MSG_SFHOLD | MSG_LOCALHOLD);
      break;
    
    case 'T':
      strcpy(logptr->betreff, elog->new_board);
      logptr->msgnum = elog->new_msgnum;
      break;
    }
  }
}


#define cpentries       150
#define cpsize          (cpentries * sizeof(indexstruct))

void recompile_fwd(void)
{
  long cpstart, err, seekpos;
  short log;
  indexstruct *logptr;
  long lv, ct;
  indexstruct logheader;
  uchar *ipuffer, *epuffer;
  long esize, retep;
  Char efname[256];
  Char logname[256];

  debug0(2, -1, 164);

  sprintf(efname, "%salterfwd%cbox", boxstatdir, extsep);
  if (!exist(efname))
    return;
    
  sfbread(true, efname, &epuffer, &esize);
  if (esize > 0) {

    sprintf(logname,"%sX%c%s", indexdir, extsep, idx_e);
    err = sfsize(logname);

    if (err <= 0) {
      mymfreep(&epuffer);
      sfdelfile(efname);
      return;
    }

    ipuffer = Malloc(cpsize);

    lv = err / sizeof(indexstruct);

    log = sfopen(logname, FO_RW);
    cpstart = 0;

    if (log >= minhandle && lv > 0) {
      ct = 0;
      while (ct < lv) {
	ct++;
	if ((ct & 63) == 0)   /* Watchdog resetten */
	  dp_watchdog(2, 4711);

	if (ipuffer == NULL) {
	  read_index(log, ct, &logheader);
	  logptr = &logheader;
	} else {
	  if (ct >= cpstart + cpentries || cpstart == 0) {
	    if (cpstart == 0)
	      cpstart = 1;
	    else
	      cpstart += cpentries;
	    if (cpstart > lv)
	      goto _L1;
	    seekpos = (cpstart - 1) * sizeof(indexstruct);
	    if (sfseek(seekpos, log, SFSEEKSET) != seekpos)
	      goto _L1;
	    if (sfread(log, cpsize, ipuffer) <= 0)
	      goto _L1;
	    if (ct >= cpstart + cpentries)
	      goto _L1;
	  }

	  logptr = (indexstruct *)
		   (&ipuffer[(ct - cpstart) * sizeof(indexstruct)]);
	}

	if (check_hcs(*logptr) && in_alterfwd_list(epuffer, esize, logptr->id, logptr->dest,
			                          &retep)) {
	  alter_fwdptr(epuffer, esize, logptr, retep);
	  write_index(log, ct, logptr);
	}

      }
    }


_L1:
    if (ipuffer != NULL)
      mymfreep(&ipuffer);
    sfclose(&log);
    mymfreep(&epuffer);

  }

  sfdelfile(efname);


}

#undef cpentries
#undef cpsize






/* Diese Routine legt ein Zusatzfile an, welches beim naechsten Aufruf der   */
/* Checkliste beruecksichtigt wird. Die hier gemachten Aenderungen werden    */
/* also erst bei CHECK wirklich in BOXLOG.DP uebernommen...                  */

typedef struct eralogtype {
  long msgnum;
  Char what;
  unsigned short msgflags;
  Char info[21];
} eralogtype;


void alter_log(boolean onram, long msgnumber, unsigned short msgflags,
	       Char what, Char *info)
{
  eralogtype elog;
  short k;
  Char hs[256];

  debug(3, 0, 19, info);

  elog.msgnum = msgnumber;
  elog.what = what;
  elog.msgflags = msgflags;
  if (strlen(info) <= 20)
    strcpy(elog.info, info);
  else
    *elog.info = '\0';

  if (ramdisk > '0' && onram) {
    del_path(hs);
    sprintf(hs, "%c%c%c%s", ramdisk, drivesep, dirsep, eralog);
  } else
    strcpy(hs, eralog);

  k = sfopen(hs, FO_RW);
  if (k < minhandle)
    k = sfcreate(hs, FC_FILE);
  if (k < minhandle) {
    debug(0, 0, 19, "open error");
    return;
  }
  sfseek(0, k, SFSEEKEND);
  sfwrite(k, sizeof(eralogtype), (uchar *)(&elog));
  sfclose(&k);
}


/* Kopiert das ERALOG (siehe oben) temporaer auf die Ramdisk oder zurueck    */

void copy_eralog(boolean toram)
{
  Char rdf[256];
  Char STR1[256];

  if (ramdisk <= '0')
    return;
  strcpy(rdf, eralog);
  del_path(rdf);
  sprintf(rdf, "%c%c%c%s", ramdisk, drivesep, dirsep, strcpy(STR1, rdf));
  if (toram)
    filecopy(eralog, rdf);
  else
    filemove(rdf, eralog);
}


Static boolean in_erase_list(uchar *epuffer, long esize, long msgnumber,
			     short nr, long *epos)
{
  boolean found;
  eralogtype *elog;

  if (esize > 0) {
    *epos = 0;
    found = false;
    while (!found && *epos < esize) {
      elog = (eralogtype *)(&epuffer[*epos]);
      if (elog->msgnum == msgnumber)
	found = true;
      else
	*epos += sizeof(eralogtype);
    }
    return found;
  } else
    return false;
}


Static void alter_logptr(uchar *epuffer, long esize, boxlogstruct **logptr,
			 long epos)
{
  eralogtype *elog;
  Char w2[256];

  while (epos < esize) {
    elog = (eralogtype *)(&epuffer[epos]);
    epos += sizeof(eralogtype);
    if ((*logptr)->msgnum != elog->msgnum)
      continue;
    elog->msgnum = -1;
    switch (elog->what) {

    case 'E':
      (*logptr)->deleted = true;
      break;

    case 'U':
      (*logptr)->deleted = false;
      break;

    case '#':
      get_word(elog->info, w2);
      (*logptr)->lifetime = Str2int(w2);
      break;

    case '@':
      get_word(elog->info, w2);
      cut(w2, 6);
      strcpy((*logptr)->verbreitung, w2);
      break;

    case '$':
      get_word(elog->info, w2);
      cut(w2, 12);
      strcpy((*logptr)->bid, w2);
      break;
    }
    if (elog->msgflags != 0)
      (*logptr)->msgflags = elog->msgflags;
  }
}


#define cpentries       checkblocksize

#define cpsize          (cpentries * sizeof(boxlogstruct))


void recompile_log(short unr)
{
  long cpstart, err, seekpos;
  short log;
  boxlogstruct *logptr;
  long lv, ct;
  boxlogstruct logheader;
  uchar *ipuffer, *epuffer;
  long esize, retep;
  long act;
  Char efname[256];
  Char logname[256];

  strcpy(efname, eralog);
  strcpy(logname, boxlog);

  debug(2, unr, 21, logname);

  if (!exist(efname))
    return;
  sfbread(true, efname, &epuffer, &esize);
  if (esize > 0) {
    act = esize / sizeof(eralogtype);


    err = sfsize(logname);

    if (err <= 0) {
      mymfreep(&epuffer);
      sfdelfile(efname);
      return;
    }

    ipuffer = Malloc(cpsize);

    lv = err / sizeof(boxlogstruct);

    log = sfopen(logname, FO_RW);
    cpstart = 0;

    if (log >= minhandle && lv > 0) {
      ct = 0;
      while (ct < lv && act > 0) {
	ct++;
	if ((ct & 63) == 0)   /* Watchdog resetten */
	  dp_watchdog(2, 4711);

	if (ipuffer == NULL) {
	  read_log(log, ct, &logheader);
	  logptr = &logheader;
	} else {
	  if (ct >= cpstart + cpentries || cpstart == 0) {
	    if (cpstart == 0)
	      cpstart = 1;
	    else
	      cpstart += cpentries;
	    if (cpstart > lv)
	      goto _L1;
	    seekpos = (cpstart - 1) * sizeof(boxlogstruct);
	    if (sfseek(seekpos, log, SFSEEKSET) != seekpos)
	      goto _L1;
	    if (sfread(log, cpsize, ipuffer) <= 0)
	      goto _L1;
	    if (ct >= cpstart + cpentries)
	      goto _L1;
	  }

	  logptr = (boxlogstruct *)
		   (&ipuffer[(ct - cpstart) * sizeof(boxlogstruct)]);
	}



	if (in_erase_list(epuffer, esize, logptr->msgnum, logptr->idxnr,
			  &retep)) {
	  act--;
	  alter_logptr(epuffer, esize, &logptr, retep);
	  write_log(log, ct, logptr);
	}

      }
    }


_L1:
    if (ipuffer != NULL)
      mymfreep(&ipuffer);
    sfclose(&log);
    mymfreep(&epuffer);

  }

  sfdelfile(efname);


}

#undef cpentries
#undef cpsize


short boxcheck(boolean all, Char *callx)
{
  /* all wird nicht benutzt, anzahl auch nicht */
  short list, msgct, ct, lv;
  indexstruct header;
  Char hs[256];
  boolean ok;
  Char hmbx[41];
  Char STR1[256];

  debug(3, 0, 22, callx);
  msgct = 0;
  if (!(all || strcmp(callx, Console_call)))
    return msgct;
  sprintf(STR1, "%s%s%c%s", indexdir, callx, extsep, idx_e);
  lv = sfsize(STR1) / sizeof(indexstruct);
  if (lv <= 0)
    return msgct;
  sprintf(STR1, "%s%s%c%s", indexdir, callx, extsep, idx_e);
  list = sfopen(STR1, FO_READ);
  if (list < minhandle)
    return msgct;
  strcpy(hs, callx);
  rspacing(hs, 6);
  ct = lv;
  ok = true;
  while (ct > 0 && ok) {
    read_index(list, ct, &header);
    if (!header.deleted && check_hcs(header)) {
      if (all)
	msgct++;
      else {
	if (clock_.ixtime - header.rxdate > 604800)
	  ok = false;
	else {
	  if (strpos2(header.readby, hs, 1) == 0 && header.fwdct == 0) {
	    unhpath(header.verbreitung, hmbx);
	    if (!strcmp(hmbx, Console_call)) {
	      msgct++;
	      ok = false;
	    }
	  } else
	    ok = false;
	}
      }
    }
    ct--;
  }
  sfclose(&list);
  return msgct;
}


Static void dispose_tcpip(void)
{
  tcpiptype *hp, *hph;

  hp = tcpiproot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  tcpiproot = NULL;
}


void load_tcpipbuf(void)
{
  short inf;
  tcpiptype *hp, *hph;
  Char hs[256];
  Char w[256];

  dispose_tcpip();
  hph = NULL;
  inf = sfopen(tcpip_box, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    if (count_words(hs) <= 0)
      continue;
    hp = Malloc(sizeof(tcpiptype));
    if (hp == NULL)
      continue;
    if (tcpiproot == NULL)
      tcpiproot = hp;
    get_word(hs, w);
    upper(w);
    cut(w, 6);
    strcpy(hp->call, w);
    cut(hs, 80);
    strcpy(hp->txt, hs);
    hp->next = NULL;
    if (hph != NULL)
      hph->next = hp;
    hph = hp;
  }
  sfclose(&inf);
}


void send_tcpip_protocol_frame(short unr)
{
  tcpiptype *hp;
  short chan;
  Char hs[256];

  chan = user[unr]->pchan;
  if (chan <= 0)
    return;
  hp = tcpiproot;
  while (hp != NULL) {
    if (!strcmp(hp->call, user[unr]->call)) {
      strcpy(hs, hp->txt);
      expand_macro(unr, hs);
      wlnuser(unr, hs);
      boxspoolfend(chan);
    }
    hp = hp->next;
  }
}


Static void dispose_badwords(void)
{
  dirtytype *hp, *hph;

  hp = badwordroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  badwordroot = NULL;
}


Static void load_badwords(void)
{
  short inf, x, l;
  dirtytype *hp, *hph;
  Char hs[256];

  dispose_badwords();
  hph = NULL;
  sprintf(hs, "%sbadwords%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);

  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    l = strpos2(hs, "#", 1);
    if (l > 0)
      cut(hs, l - 1);
    if (count_words(hs) <= 0)
      continue;
    upper(hs);

    hp = Malloc(sizeof(dirtytype));
    if (hp == NULL)
      continue;
    if (badwordroot == NULL)
      badwordroot = hp;
    cut(hs, 18);
    l = strlen(hs);
    if (hs[0] != '*' && hs[0] != ' ')
      strcpy(hp->bad, "*");
    else
      *hp->bad = '\0';

    for (x = 0; x < l; x++)
      sprintf(hp->bad + strlen(hp->bad), "%c*", hs[x]);

    while (strpos2(hp->bad, "**", 1) > 0)
      strdelete((void *)hp->bad, strpos2(hp->bad, "**", 1), 1);

    if (l > 1 && hs[l - 1] == ' ')
      strdelete((void *)hp->bad, strlen(hp->bad), 1);

    hp->next = NULL;

    if (hph != NULL)
      hph->next = hp;
    hph = hp;

  }
  sfclose(&inf);
}


Static void dispose_rejectinfos(void)
{
  rejecttype *hp, *hph;

  hp = rejectroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  rejectroot = NULL;
}


Static boolean checkneg(Char *w)
{
  boolean Result;

  if (w[0] != '~')
    return true;
  Result = false;
  strdelete((void *)w, 1, 1);
  return Result;
}


Static void load_rejectinfos(void)
{
  short inf;
  rejecttype *hp, *hph;
  Char hs[256];
  Char w[256];

  dispose_rejectinfos();
  hph = NULL;
  sprintf(hs, "%sreject%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;

    if (count_words(hs) <= 6)
      continue;
    upper(hs);

    hp = Malloc(sizeof(rejecttype));
    if (hp == NULL)
      continue;
    if (rejectroot == NULL)
      rejectroot = hp;

    convtit = true;

    get_word(hs, w);
    hp->what = upcase_(w[0]);
    get_word(hs, w);
    hp->msgtypeneg = checkneg(w);
    hp->msgtype = upcase_(w[0]);
    get_word(hs, w);
    hp->fromneg = checkneg(w);
    cut(w, 6);
    strcpy(hp->from, w);
    get_word(hs, w);
    hp->mbxneg = checkneg(w);
    cut(w, 40);
    strcpy(hp->mbx, w);
    get_word(hs, w);
    hp->tobneg = checkneg(w);
    cut(w, 8);
    strcpy(hp->tob, w);
    get_word(hs, w);
    hp->bidneg = checkneg(w);
    cut(w, 12);
    strcpy(hp->bid, w);
    get_word(hs, w);
    hp->maxsizeneg = checkneg(w);
    hp->maxsize = str2lint(w) * 1024;
    hp->next = NULL;

    if (hph != NULL)
      hph->next = hp;
    hph = hp;

  }
  sfclose(&inf);
}


Static void dispose_rubrikinfos(void)
{
  rubriktype *hp, *hph;

  debug0(2, 0, 136);
  hp = rubrikroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  rubrikroot = NULL;
}


Static void load_rubrikinfos(void)
{
  short inf, k, acc;
  rubriktype *hp, *hph;
  Char hs[256];
  Char w[256];
  Char w1[256], w2[256], w3[256];
  short TEMP;

  dispose_rubrikinfos();
  debug0(2, 0, 23);
  hph = NULL;

  inf = sfopen(rubriken_box, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    TEMP = count_words(hs);
    if ((unsigned)TEMP < 32 && ((1L << TEMP) & 0xc) != 0)
      strcpy(w, hs);
    else {
      get_word(hs, w);
      do {
	k = strpos2(w, ":", 1);
	if (k > 0)
	  w[k - 1] = ' ';
      } while (k != 0);
    }
    get_word(w, w1);
    get_word(w, w2);
    get_word(w, w3);
    if ((unsigned long)strlen(w1) >= 32 || ((1L << strlen(w1)) & 0x1fe) == 0)
      continue;

    hp = Malloc(sizeof(rubriktype));
    if (hp == NULL)
      continue;

    if (rubrikroot == NULL)
      rubrikroot = hp;

    upper(w1);
    strcpy(hp->name, w1);

    hp->lifetime = Str2int(w2);
    acc = Str2int(w3);
    if (acc < 1)
      acc = 1;
    hp->access = acc;
    hp->next = NULL;

    if (hph != NULL)
      hph->next = hp;
    hph = hp;

  }
  sfclose(&inf);
}


Static void dispose_verteilinfos(void)
{
  transfertype *hp, *hph;

  hp = transferroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;

    Free(hph);
  }
  transferroot = NULL;
}


Static void load_verteilinfos(void)
{
  short inf;
  transfertype *hp, *hph;
  Char hs[256];
  Char w[256];

  dispose_verteilinfos();
  hph = NULL;
  sprintf(hs, "%stransfer%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    if (count_words(hs) != 2)
      continue;
    upper(hs);
    hp = Malloc(sizeof(transfertype));
    if (hp == NULL)
      continue;
    if (transferroot == NULL)
      transferroot = hp;
    get_word(hs, w);
    cut(w, 8);
    strcpy(hp->board1, w);
    get_word(hs, w);
    cut(w, 8);
    strcpy(hp->board2, w);
    hp->next = NULL;
    if (hph != NULL)
      hph->next = hp;
    hph = hp;
  }
  sfclose(&inf);
}


Static void dispose_rsysops(void)
{
  rsysoptype *hp, *hph;

  hp = rsysoproot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  rsysoproot = NULL;
}


Static void load_rsysops(void)
{
  short inf;
  rsysoptype *hp, *hph;
  Char hs[256], w[256];

  dispose_rsysops();
  hph = NULL;
  sprintf(hs, "%sprvcalls%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    if (count_words(hs) != 2)
      continue;
    upper(hs);
    hp = Malloc(sizeof(rsysoptype));
    if (hp == NULL)
      continue;
    if (rsysoproot == NULL)
      rsysoproot = hp;
    get_word(hs, w);
    cut(w, 6);
    strcpy(hp->call, w);
    get_word(hs, w);
    cut(w, 8);
    strcpy(hp->board, w);
    hp->next = NULL;
    if (hph != NULL)
      hph->next = hp;
    hph = hp;
  }
  sfclose(&inf);
}


Static void dispose_convtit(void)
{
  convtittype *hp, *hph;

  hp = convtitroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  convtitroot = NULL;
}


Static void load_convtit(void)
{
  short inf;
  convtittype *hp, *hph;
  Char hs[256];
  Char w[256];

  dispose_convtit();
  hph = NULL;
  sprintf(hs, "%sconvtit%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    if (count_words(hs) <= 3)
      continue;
    upper(hs);
    hp = Malloc(sizeof(convtittype));
    if (hp == NULL)
      continue;
    convtit = true;
    if (convtitroot == NULL)
      convtitroot = hp;
    get_word(hs, w);
    cut(w, 8);
    strcpy(hp->fromboard, w);
    get_word(hs, w);
    cut(w, 8);
    strcpy(hp->toboard, w);
    get_word(hs, w);
    hp->newlt = (unsigned short)Str2int(w);
    cut(hs, 80);
    strcpy(hp->title, hs);
    hp->next = NULL;
    if (hph != NULL)
      hph->next = hp;
    hph = hp;
  }
  sfclose(&inf);
}


Static void dispose_convlt(void)
{
  convtittype *hp, *hph;

  hp = convltroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  convltroot = NULL;
}


Static void load_convlt(void)
{
  short inf;
  convtittype *hp, *hph;
  Char hs[256];
  Char w[256];

  dispose_convlt();
  hph = NULL;
  sprintf(hs, "%sconvlt%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);
  if (inf < minhandle)
    return;
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    if (count_words(hs) <= 2)
      continue;
    upper(hs);
    hp = Malloc(sizeof(convtittype));
    if (hp == NULL)
      continue;
    convtit = true;
    if (convltroot == NULL)
      convltroot = hp;
    get_word(hs, w);
    cut(w, 8);
    strcpy(hp->fromboard, w);
    get_word(hs, w);
    hp->newlt = (unsigned short)Str2int(w);
    cut(hs, 80);
    strcpy(hp->title, hs);
    hp->next = NULL;
    hp->toboard[0] = '\0';
    if (hph != NULL)
      hph->next = hp;
    hph = hp;
  }
  sfclose(&inf);
}


Static void load_balise(void)
{
  long rp;
  boolean ok;
  Char hs[256], w[256];

  debug0(2, 0, 24);
  balisetime = 0;
  ok = false;
  if (balisesize != 0)
    mymfreep(&balisebuf);
  sfbread(true, beacon_box, &balisebuf, &balisesize);
  if (balisesize <= 0)
    return;
  rp = 0;
  do {
    get_line(balisebuf, &rp, balisesize, hs);
    upper(hs);
    get_word(hs, w);
    if (!strcmp(w, "INTERVAL")) {
      get_word(hs, w);
      balisetime = str2lint(w) * 60;
      ok = true;
    }
  } while (!(ok || rp >= balisesize));
}


Static void free_unprotodefs(void)
{
  unprotoportstype *hpp, *hpp1;

  if (unprotodefroot == NULL)
    return;
  hpp = unprotodefroot->ports;
  while (hpp != NULL) {
    hpp1 = hpp;
    hpp = hpp->next;
    Free(hpp1);
  }
  Free(unprotodefroot);
  unprotodefroot = NULL;
}


Static void load_unprotodefs(void)
{
  short k;
  unprotoportstype *hp;
  Char hs[256], w[256];
  Char STR1[256];

  free_unprotodefs();
  sprintf(STR1, "%sunproto%cbox", boxsysdir, extsep);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return;
  unprotodefroot = Malloc(sizeof(unprotodeftype));
  if (unprotodefroot == NULL)
    return;
  unprotodefroot->ports = NULL;
  unprotodefroot->maxback = 2000;
  unprotodefroot->interval = 20;
  unprotodefroot->priv = false;
  unprotodefroot->sys = false;
  unprotodefroot->fbb = true;
  unprotodefroot->dpbox = true;
  while (file_to_string(k, hs)) {
    del_comment(hs, '#');
    get_word(hs, w);
    if (*w == '\0' || w[0] == '#')
      continue;
    upper(w);
    del_lastblanks(hs);
    if (!strcmp(w, "INTERVAL")) {
      unprotodefroot->interval = str2lint(hs);
      continue;
    }
    if (!strcmp(w, "PRIVATES")) {
      unprotodefroot->priv = positive_arg(hs);
      continue;
    } 
    if (!strcmp(w, "SYSOP")) {
      unprotodefroot->sys = positive_arg(hs);
      continue;
    }  
    if (!strcmp(w, "MAXBACK")) {
      unprotodefroot->maxback = str2lint(hs);
      continue;
    }
    if (!strcmp(w, "FBB")) {
      get_word(hs, w);
      unprotodefroot->fbb = positive_arg(w);
      continue;
    }
    if (!strcmp(w, "DPBOX")) {
      get_word(hs, w);
      unprotodefroot->dpbox = positive_arg(w);
      continue;
    }
    if (strcmp(w, "QRG"))
      continue;
    get_word(hs, w);
    if (*w == '\0')
      continue;
    hp = Malloc(sizeof(unprotoportstype));
    if (hp == NULL)
      continue;
    cut(w, 20);
    strcpy(hp->port, w);
    upper(hs);
    strcpy(hp->path, hs);
    hp->next = unprotodefroot->ports;
    unprotodefroot->ports = hp;
  }
  sfclose(&k);
  if (unprotodefroot->maxback < 200)
    unprotodefroot->maxback = 200;
  else if (unprotodefroot->maxback > 4000)
    unprotodefroot->maxback = 4000;
  if (unprotodefroot->interval < 0)
    unprotodefroot->interval = 0;
  if (!(unprotodefroot->fbb || unprotodefroot->dpbox))
    free_unprotodefs();
}


Static void dispose_boxcommands(void)
{
  bcommandtype *hp, *hph;

  hp = bcommandroot;   /* alte Liste loeschen */
  while (hp != NULL) {
    hph = hp;
    hp = hp->next;
    Free(hph);
  }
  bcommandroot = NULL;
}


Static void load_boxcommands(void)
{
  short inf;
  bcommandtype *hp, *hph;
  Char hs[256];
  Char w[256];

  dispose_boxcommands();
  hph = NULL;
  sprintf(hs, "%scommands%cbox", boxsysdir, extsep);
  inf = sfopen(hs, FO_READ);
  if (inf < minhandle) {
    boxalert2("No COMMANDS.BOX !", true);
    return;
  }
  while (file_to_string(inf, hs)) {
    if (strpos2(hs, "#", 1) == 1)
      continue;
    if (count_words(hs) != 4)
      continue;
    upper(hs);
    hp = Malloc(sizeof(bcommandtype));
    if (hp == NULL)
      continue;
    if (bcommandroot == NULL)
      bcommandroot = hp;
    get_word(hs, w);
    cut(w, 10);
    strcpy(hp->command, w);
    get_word(hs, w);
    hp->cnr = Str2int(w);
    get_word(hs, w);
    hp->sysop = (Str2int(w) != 0);
    get_word(hs, w);
    hp->ulev = Str2int(w);
    hp->next = NULL;
    if (hph != NULL)
      hph->next = hp;
    hph = hp;
  }
  sfclose(&inf);
}


Static void load_fbbheader(void)
{
  short x, fbb, zct;
  Char zl[256];


  for (x = 0; x <= 11; x++)
    *fbb_month[x] = '\0';
  fbb_fromfield[0] = '\0';
  fbb314_fromfield[0] = '\0';
  fbb_tofield[0] = '\0';
  fbb314_tofield[0] = '\0';

  if (!exist(f6fbb_box))
    return;
  fbb = sfopen(f6fbb_box, FO_READ);

  zct = 0;
  while (file_to_string(fbb, zl)) {
    del_leadblanks(zl);
    if (*zl == '\0')
      continue;
    if (zl[0] == '#')
      continue;
    zct++;
    switch (zct) {

    case 1:
      cut(zl, 20);
      strcpy(fbb_fromfield, zl);
      break;

    case 2:
      cut(zl, 20);
      strcpy(fbb_tofield, zl);
      break;

    case 3:
      cut(zl, 20);
      strcpy(fbb314_fromfield, zl);
      break;

    case 4:
      cut(zl, 20);
      strcpy(fbb314_tofield, zl);
      break;

    default:
      if ((unsigned)zct < 32 && ((1L << zct) & 0x1ffe0L) != 0) {
	cut(zl, 3);
	upper(zl);
	strcpy(fbb_month[zct - 5], zl);
      }
      break;
    }
  }
  sfclose(&fbb);
}


boolean positive_arg(Char *s)
{
  boolean Result;

  Result = false;
  if (!strcmp(s, "ON") || !strcmp(s, "YES") || !strcmp(s, "+") ||
      !strcmp(s, "OUI") || !strcmp(s, "JA") || !strcmp(s, "TRUE") ||
      !strcmp(s, "AN") || !strcmp(s, "1"))
    return true;
  return Result;
}


Static void load_boxconfig(void)
{
  short x, inf;
  Char hs[256], w[256], w1[256], w2[256], h2[256];

  strcpy(sf_connect_call, Console_call);
  y_lifetime = 3;
  resume_lifetime = 3;
  *e_m_verteiler = '\0';
  *pacsrv_verteiler = '\0';
  tpkbbs = false;
  *default_rubrik = '\0';
  *default_tpkbbs = '\0';
  bcastforward = false;
  multiprivate = false;
  sfinpdefault = SFI_FROMPB;
  MaxReadBuf = MaxReadBufDefault;
  bid_in_ram = true;
  debug_level = 0;
  debug_size = 99999999L;
  usertimeout = 20;
  sftimeout = 5;
  max_lt_inc = 0;
  garbramdisk = true;
  ufilhide = false;
  create_wp = false;
  scan_all_wp = false;
  create_syslog = true;
  create_userlog = false;
  create_usersflog = false;
  holdownfiles = false;
  create_readlog = false;
  create_sflog = false;
  create_convlog = false;
  remoteerasecheck = false;
  authentinfo = false;
  mail_beacon = false;
  gttl = false;
  add_ex = false;
  smart_routing = false;
  request_lt = false;
  small_first = true;
  sort_props = true;
  create_acks = true;
  packed_sf = true;
  forwerr = true;
  xcheck_in_ram = true;
  valid_in_ram = false;
  /*   send_bbsbcast   := false; */
  unproto_list = false;
  ring_bbs = false;
  multi_master = true;
  charge_bbs = false;
  auto7plusextract = false;
  autobinextract = false;
  reduce_lt_after_extract = false;
  check_sffor_in_ram = false;
  no_rline_if_exterior = false;
  allunproto = false;
  guess_mybbs = true;
  usersftellmode = SFT_NONE;
  holddelay = 86400L;   /*1 tag*/
  erasewait = 259200L;   /*3 tage*/
  wpcreateinterval = 86400L;   /*1 tag*/
  returntime = 604800L;   /*1 woche*/
  bullsfwait = 604800L;   /*7 tage*/
  bullsfmaxage = 2592000L;   /*30 tage*/
  incominglifetime = 604800L;   /*7 tage*/
  maxuserconnects = 2;
  all_maxread_day = 999999999L;
  sprintf(connecttext, "%s BBS", Console_call);
  *redlocal = '\0';
  *redregion = '\0';
  *rednation = '\0';
  *reddefboard = '\0';
  redlifetime = -1;
  strcpy(default_prompt, "(%b) %c de %m>");
  sub_bid = 0;

  if (exist(config_box)) {
    inf = sfopen(config_box, FO_READ);
    while (file_to_string(inf, hs)) {
      del_blanks(hs);
      if (*hs == '\0' || *hs == '#') continue;
      get_word(hs, w);
      strcpy(h2, hs);
      get_word(hs, w1);
      upper(w);
      strcpy(w2, w1);
      upper(w1);

      if (!strcmp(w, "DEFAULTPROMPT")) {
	cut(h2, 80);
	strcpy(default_prompt, h2);
	continue;
      }

      if (!strcmp(w, "UNDEFBOARD")) {
	cut(w1, 8);
	strcpy(default_rubrik, w1);
	continue;
      }

      if (!strcmp(w, "SFCONNECTCALL")) {
	cut(w1, 6);
	if (*w1 != '\0')
	  strcpy(sf_connect_call, w1);
	continue;
      }

      if (!strcmp(w, "REDIST_LOCAL")) {
	cut(w1, 8);
	strcpy(redlocal, w1);
	continue;
      }

      if (!strcmp(w, "REDIST_REGION")) {
	cut(w1, 8);
	strcpy(redregion, w1);
	continue;
      }

      if (!strcmp(w, "REDIST_NATION")) {
	cut(w1, 8);
	strcpy(rednation, w1);
	continue;
      }

      if (!strcmp(w, "REDIST_DEFBOARD")) {
	cut(w1, 8);
	if (valid_boardname(w1))
	  strcpy(reddefboard, w1);
	continue;
      }

      if (!strcmp(w, "REDIST_LIFETIME")) {
	redlifetime = Str2int(w1);
	if (redlifetime > 999)
	  redlifetime = -1;
	continue;
      }

      if (!strcmp(w, "INCOMING_LIFETIME")) {
	incominglifetime = Str2int(w1) * 86400L;
	continue;
      }

      if (!strcmp(w, "SYSFORWARD")) {
	cut(w1, 8);
	strcpy(e_m_verteiler, w1);
	continue;
      }

      if (!strcmp(w, "PACSRV")) {
	cut(w1, 8);
	strcpy(pacsrv_verteiler, w1);
	continue;
      }

      if (!strcmp(w, "RESUMELT")) {
	resume_lifetime = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "SUB_BID")) {
	sub_bid = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "YLT")) {
	y_lifetime = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "TTASK")) {
	ttask = Str2int(w1) / 5;
	continue;
      }
      
      if (!strcmp(w, "GUESS_MYBBS")) {
	guess_mybbs = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "MULTI_BBS")) {
	ring_bbs = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "MULTI_MASTER")) {
	multi_master = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "CHARGE_BBS")) {
	charge_bbs = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "FORWARDERRORS")) {
	forwerr = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "BCASTFORWARD")) {
	bcastforward = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "REDUCEEXTRACTLT")) {
	reduce_lt_after_extract = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "AUTO7PLUSEXTRACT")) {
	auto7plusextract = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "AUTOBINEXTRACT")) {
	autobinextract = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "UNPROTO")) {
	unproto_list = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "ALL_UNPROTO")) {
	allunproto = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "TTL")) {
	gttl = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "ADDEX")) {
	add_ex = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SMALL_FIRST")) {
	small_first = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SMART_ROUTING")) {
	smart_routing = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SEND_BBSBCAST")) {
	send_bbsbcast = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "REQUEST_LT")) {
	request_lt = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SORT_PROPS")) {
	sort_props = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SYSLOG")) {
	create_syslog = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "USERLOG")) {
	create_userlog = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "USERSFLOG")) {
	create_usersflog = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "READLOG")) {
	create_readlog = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SFLOG")) {
	create_sflog = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "CREATE_ACKS")) {
	create_acks = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "CONVLOG")) {
	create_convlog = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "REMOTEERASECHECK")) {
	remoteerasecheck = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "MULTIPRIVATE")) {
	multiprivate = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "HOLDOWNFILES")) {
	holdownfiles = positive_arg(w1);
	continue;
      }
      
/*      if (!strcmp(w, "READLIMIT")) {  no more used
	MaxReadBuf = str2lint(w1);
	continue;
      } 
 */
      
      if (!strcmp(w, "SFINPUT")) {
	x = Str2int(w1);
	if ((unsigned)x < 32 &&
	    ((1L << x) & ((1L << (SFI_ALL + 1)) - (1L << SFI_NONE))) != 0)
	  sfinpdefault = x;
	continue;
      }

      if (!strcmp(w, "USERSFTELLMODE")) {
	x = Str2int(w1);
	if ((unsigned)x < 32 &&
	    ((1L << x) & ((1L << (SFT_ALL + 1)) - (1L << SFT_NONE))) != 0)
	  usersftellmode = x;
	continue;
      }

      if (!strcmp(w, "RAMBID")) {
	bid_in_ram = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "DEBUGLEVEL")) {
	debug_level = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "DEBUGSIZE")) {
	debug_size = str2lint(w1);
	continue;
      }
      
      if (!strcmp(w, "USERTIMEOUT")) {
	usertimeout = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "SFTIMEOUT")) {
	sftimeout = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "MAXLTINC")) {
	max_lt_inc = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "MAXUSERCONNECTS")) {
	maxuserconnects = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "GARBRAMDISK")) {
	garbramdisk = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "UFILHIDE")) {
	ufilhide = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "WPCREATE")) {
	create_wp = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "XCHECKINRAM")) {
	xcheck_in_ram = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "VALIDINRAM")) {
	valid_in_ram = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "SFCHECKINRAM")) {
	check_sffor_in_ram = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "WPSCANALL")) {
	scan_all_wp = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "RETURNTIME")) {
	returntime = str2lint(w1) * 86400L;
	continue;
      }
      
      if (!strcmp(w, "BULLSFWAIT")) {
	bullsfwait = str2lint(w1) * 86400L;
	continue;
      }
      
      if (!strcmp(w, "BULLSFMAXAGE")) {
	bullsfmaxage = str2lint(w1) * 86400L;
	continue;
      }
      
      if (!strcmp(w, "ERASEDELAY")) {
	erasewait = str2lint(w1) * 86400L;
	continue;
      }
      
      if (!strcmp(w, "UNDEFBOARDSLT")) {
	erasedelay = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "MAXPERDAY")) {
	all_maxread_day = str2lint(w1);
	continue;
      }
      
      if (!strcmp(w, "WPCREATEINTERVAL")) {
	wpcreateinterval = str2lint(w1) * 3600;
	continue;
      }
      
      if (!strcmp(w, "HOLDDELAY")) {
	holddelay = str2lint(w1) * 3600;
	continue;
      }
      
      if (!strcmp(w, "CONNECTTEXT")) {
	strcpy(connecttext, h2);
	cut(connecttext, 30);
	continue;
      }


      if (!strcmp(w, "OWNHIERNAME")) {
	if (*w1 == '\0') {
	  strcpy(ownhiername, Console_call);
	  continue;
	}
	if (strpos2(w1, Console_call, 1) == 1)
	  strcpy(h2, w1);
	else
	  sprintf(h2, "%s.%s", Console_call, w1);
	cut(h2, 40);
	strcpy(ownhiername, h2);
	continue;
      }

      if (!strcmp(w, "MAXBULLIDS")) {
	maxbullids = str2lint(w1);
	continue;
      }
      
      if (!strcmp(w, "WITH_RLINE")) {
	with_rline = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "NO_EXT_RLINE")) {
	no_rline_if_exterior = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "ANA_HPATH")) {
	ana_hpath = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "AUTO_GARBAGE")) {
	auto_garbage = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "PACKDELAY")) {
	packdelay = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "BOX_PW")) {
	box_pw = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "USERLIFETIME")) {
	userlifetime = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "GARBAGETIME")) {
	garbagetime = Str2int(w1);
	continue;
      }
      
      if (!strcmp(w, "FHEADER")) {
	cut(h2, 107 - strlen(ownhiername));
	strcpy(ownfheader, h2);
	continue;
      }

      if (!strcmp(w, "REMOTE_ERASE")) {
	remote_erase = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "PACKED_SF")) {
	packed_sf = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "MAIL_BEACON")) {
	mail_beacon = positive_arg(w1);
	continue;
      }
      
      if (!strcmp(w, "AUTHENTIFICATION") || !strcmp(w, "AUTHENTICATION")) {
	authentinfo = positive_arg(w1);

      } else if (!strcmp(w, "HOMEBBS")) {
	cut(w1, 6);
	strcpy(default_tpkbbs, w1);
	tpkbbs = true;
      }
    }
    sfclose(&inf);
  }

  if (ttask < 1)
    ttask = 1;
  else if (ttask > 400)
    ttask = 400;
  if (*ownhiername == '\0')
    strcpy(ownhiername, Console_call);
  if (maxbullids == 0)
    maxbullids = 30000;
  if (sftimeout > 45) /* nicht hoeher ! */
    sftimeout = 45;
  if (usertimeout > 60 * 12) /* 12 h */
    usertimeout = 60 * 12;
  if (wpcreateinterval < 3600)
    wpcreateinterval = 3600;
  if (holddelay < 3600)
    holddelay = 3600;
  if (returntime < 86400L)
    returntime = 86400L;
  if (bullsfwait < 86400L)
    bullsfwait = 86400L;
  if (bullsfmaxage < 86400L)
    bullsfmaxage = 86400L;
  if (debug_size < 10000)
    debug_size = 10000;
  if (all_maxread_day <= 0 || all_maxread_day >= 261120)
    all_maxread_day = 999999999L;
  else if (all_maxread_day < 10000)
    all_maxread_day = 10000;
  if (incominglifetime < 86400L)
    incominglifetime = 86400L;
  if ((unsigned)sub_bid > 6)
    sub_bid = 0;
  
  garbramdisk = false;
  
}


void load_all_parms(void)
{
  Char STR1[256];

  dispose_mptr();
  clear_hboxhash();
  free_membidpuffer();
  clear_bidhash();
  free_languages(&langmemroot);
  dispose_boxcommands();
  dispose_sfinfos();
  dispose_rubrikinfos();
  dispose_verteilinfos();
  dispose_rejectinfos();
  dispose_badwords();
  dispose_rsysops();
  dispose_convtit();
  dispose_convlt();
  dispose_tcpip();
  if (balisesize != 0)
    mymfreep(&balisebuf);
  balisesize = 0;
  del_resume_list();
  convtit = false;
  free_boxbcastdesc();
  free_unprotodefs();

  load_boxconfig();
  load_boxcommands();
  sprintf(STR1, "%s%c%cLAN", boxlanguagedir, allquant, extsep);
  load_languages(&langmemroot, STR1);
  load_sfinfos();
  load_rubrikinfos();
  load_verteilinfos();
  load_rejectinfos();
  load_badwords();
  load_fbbheader();
  load_balise();
  load_resume();
  load_tcpipbuf();
  load_boxbcastparms(bcast_box);
  load_convtit();
  load_convlt();
  load_rsysops();
  load_badwords();
  load_mptr();
  init_ufcache();
  boxloadgreeting();
  reload_proto();
  load_unprotodefs();
  strcpy(STR1, "7plus.out");
  sfdelfile(STR1);
  strcpy(spluspath, "7plus");
  call_prg(spluspath, "-Y -Q", "");
  if (!exist(STR1))
    *spluspath = '\0';
  sfdelfile(STR1);

  m_filter = exist(m_filter_prg);
  lastxreroute = 0;
  garbage_collection(true, false, false, false, -1);
}


Static void check_indexes(void)
{
  DTA dirinfo;
  short result;
  long sz;
  Char STR1[256];

  sprintf(STR1, "%s%c%c%s", indexdir, allquant, extsep, idx_e);
  result = sffirst(STR1, 0, &dirinfo);
  if (result != 0)
    return;

  sprintf(STR1, "%s%s", indexdir, dirinfo.d_fname);
  sz = sfsize(STR1);

  if (sz % sizeof(indexstruct) != 0) {
    boxalert2(
      "The format of the|box-indicies has changed.|Please delete the content|of the bbs manually",
      false);
    ende = true;
    /*           end; */
  }

}


/* local fuer check_bullidseek */

Static long lastbid(void)
{
  long Result;
  short log, lognr;
  boxlogstruct logheader;


  Result = -1;
  lognr = sfsize(boxlog) / sizeof(boxlogstruct);
  log = sfopen(boxlog, FO_READ);
  if (log < minhandle)
    return Result;
  read_log(log, lognr, &logheader);
  if (actmsgnum <= 0)
    actmsgnum = logheader.msgnum;
  sfclose(&log);
  return (bull_mem(logheader.bid, false));
}


void check_bullidseek(void)
{
  /* falls das bidseek-file fehlt... */
  long fpos, bs;

  fpos = bullidseek;
  bs = sfsize(msgidlog) / 13;
  if (bullidseek < bs && bs < maxbullids || bullidseek > bs) {
    fpos = bs;

  } else if (bs >= maxbullids) {
    if (sfsize(boxlog) % sizeof(boxlogstruct) != 0)
      create_new_boxlog(0, false);

    fpos = lastbid();

    /* die folgenden Zeilen sind wegen der ' BULLID + ' - Funktion da */
    if (fpos >= 0) {
      if (fpos < bullidseek) {
	if (bullidseek - fpos < 50)
	  fpos = bullidseek;
      }
    }
  }

  if (bullidseek == fpos)
    return;
  if (fpos > 0) {
    bullidseek = fpos;
    update_bidseek();
  }
}

static boolean msgnumsem;

Static void create_all_msgnums(boolean recalc)
{
  long bsize, xsize;
  short k, h;
  long ct, cct;
  boxlogstruct log;
  indexstruct header;
  Char hs[256], fn[256], lfn[256];
  long FORLIM;
  Char STR7[256];
  Char STR13[34];
  Char STR14[30];
  
  if (msgnumsem)
    return;
  msgnumsem = true;

  actmsgnum = 0;

  bsize = sfsize(boxlog);
  if (!recalc && (bsize % sizeof(boxlogstruct) != 0 || bsize == 0)) {
    boxbusy("creating checklist");
    create_new_boxlog(-1, false);
    boxendbusy();
    bsize = sfsize(boxlog);
  }

  if (bsize <= 0) {   /* leere bbs */
    msgnumsem = false;
    return;
  }
  
  append_profile(-1, "creating msgnums");
  
  sprintf(hs, "%sX%c%s", indexdir, extsep, idx_e); /* msgnums in X loeschen */
  xsize = sfsize(hs);
  k = sfopen(hs, FO_RW);
  if (k >= minhandle) {
    FORLIM = xsize / sizeof(indexstruct);
    for (ct = 1; ct <= FORLIM; ct++) {
      read_index(k, ct, &header);
      if (check_hcs(header)) {
        header.msgnum = 0;
        write_index(k, ct, &header);
      }
    }
    sfclose(&k);
  }
  
  cct = bsize / sizeof(boxlogstruct);

  k = sfopen(boxlog, FO_RW);
  if (k < minhandle) {   /* ? */
    msgnumsem = false;
    return;
  }

  boxbusy("creating msgnums");

  *lfn = '\0';
  h = nohandle;

  FORLIM = cct;
  for (ct = 1; ct <= FORLIM; ct++) {
    if (ct % 25 == 0) {
      bootinf(".");
      dp_watchdog(2, 4711);   /* Watchdog resetten */
      sprintf(hs, "%ld", calc_prozent(ct, cct));
      sprintf(hs, "msgnums: %s%%", strcpy(STR7, hs));
      boxendbusy();
      boxbusy(hs);
    }

    *log.brett = '\0';
    read_log(k, ct, &log);

    sprintf(fn, "%s%s%c%s", indexdir, log.brett, extsep, idx_e);
    if (strcmp(fn, lfn)) {
      strcpy(lfn, fn);
      sfclose(&h);
      h = sfopen(fn, FO_RW);
    }

    if (h >= minhandle) {
      *header.absender = '\0';
      read_index(h, log.idxnr, &header);
      if (check_hcs(header)) {
	header.msgnum = new_msgnum();
	log.msgnum = header.msgnum;
	write_index(h, log.idxnr, &header);
	write_log(k, ct, &log);
      } else {
	sprintf(STR13, "checksum error (index %s)", log.brett);
	debug(0, -1, 163, STR13);
      }
    } else {
      sprintf(STR14, "open error (index %s)", log.brett);
      debug(0, -1, 163, STR14);
    }

  }

  sfclose(&h);
  sfclose(&k);
  boxendbusy();
  unproto_last = actmsgnum;
  flush_bidseek_immediately();
  append_profile(-1, "msgnums created");
  msgnumsem = false;
}


Static long check_msgnum(void)
{
  long Result;
  short k;
  long size;
  boxlogstruct log;

  Result = actmsgnum;
  size = sfsize(boxlog);
  if (size <= 0)
    return Result;
  k = sfopen(boxlog, FO_READ);
  if (k < minhandle)
    return Result;
  log.msgnum = -157;
  read_log(k, size / sizeof(boxlogstruct), &log);
  sfclose(&k);
  if (log.msgnum > 0 && actmsgnum < log.msgnum)
    actmsgnum = log.msgnum;
  return Result;
}


void init_boxvars(void)
{
  short x;
  long l;
  Char dbold[256], w[256];

  boxisbusy(true);
  strcpy(dbold, debug_box);
  new_ext(dbold, "001");
  validate(dbold);
  sfdelfile(dbold);
  sfrename(debug_box, dbold);

  reset_boxruntime();
  quick_speed();
  delete_tempboxfiles();

  /* noch einige versionen lang drinlassen */
  sfdelfile(b_eralog);
  sfdelfile(u_eralog);
  sfdelfile(b_boxlog);
  sfdelfile(u_boxlog);
  
  strcpy(w, boxstatdir);
  strcat(w, "7plock.box");
  sfdelfile(w); /* 7plus-Lockfile loeschen */
  
  sprintf(boxlog, "%smsglist%cbox", boxstatdir, extsep);
  sprintf(eralog, "%smsglist%cupd", boxstatdir, extsep);
  sprintf(bidseekfile, "%sbidseek%cbox", boxstatdir, extsep);
  sprintf(extuserdir, "%sextusers%c", boxstatdir, dirsep);
  sprintf(fservdir, "fileserv%c", dirsep);
  sprintf(pservdir, "privserv%c", dirsep);

  for (x = 0; x <= maxuser; x++)
    user[x] = NULL;
  for (x = 0; x <= maxufcache; x++)
    ufcache[x] = NULL;
  clear_msgnumarr();
  actmsgnum = 0;
  zombieroot = NULL;
  immediate_extcheck = false;
  newmailroot = NULL;
  protocalls = NULL;
  traces = NULL;
  mptrroot = NULL;
  badtimecount = 0;
  unproto_lasttime = 0;
  ttask = 20;
  maxerrors = 5;
  packmin = 6;   /* der packer setzt selber 4 Bytes am Anfang ein */
  garbage_done = false;
  tell_waiting = true;
  garbage_waiting = false;
  x_garbage_waiting = false;
  new_mybbs_data = true;
  mybbsseekp = 0;
  new_remote_erases = true;
  remerseekp = 0;
  rubrikroot = NULL;

  transferroot = NULL;
  membidpuffer = NULL;
  membidsize = 0;
  boxtimect = 0;
  sfdefs = NULL;
  balisesize = 0;
  balisetime = 0;
  lastbalise = 0;
  debug_level = 0;
  lastmailixtime = 0;
  bcommandroot = NULL;
  sf_allowed = true;
  gesperrt = false;
  langmemroot = NULL;
  resume_root = NULL;
  tcpiproot = NULL;
  convtitroot = NULL;
  convltroot = NULL;
  rsysoproot = NULL;
  badwordroot = NULL;
  bcommandroot = NULL;
  rejectroot = NULL;
  unprotodefroot = NULL;
  hiscore_connects = 0;
  convtit = false;
  m_filter = exist(m_filter_prg);
  load_all_parms();
  check_indexes();
  check_hpath(false);

  if (!load_bidseek())
    check_bullidseek();
  l = sfsize(msgidlog) / 13;
  if (bullidseek > l)
    bullidseek = l;
  if (l < maxbullids)
    bullidseek = l;

  actmsgnum = check_msgnum();
  unproto_last = actmsgnum;

  if (actmsgnum < 1) {
    bootinf(" creating new msgnums");
    create_all_msgnums(false);   /* msgnummern neu erstellen... */
  }
  fill_msgnumarr();

  boxisbusy(false);
}


void exit_boxvars(void)
{
  short x;

  flush_bidseek_immediately();
  delete_all_protocalls();
  delete_all_tracecalls();
  for (x = 1; x <= maxuser; x++) {
    if (boxrange(x)) {
      user[x]->action = 15;
      abort_useroutput(x);
      end_boxconnect(x);
    }
  }
}


/* ------------------------------------------------------------------------------ */


Static unsigned short mfilter_sem;


Static short call_m_filter(uchar **puffer, long *size, long *lesezeiger,
  Char *frombox, Char *ziel, Char *mbx, Char *absender, Char *lifetime,
  Char *bulletin_id, Char *betreff, boolean *no_sf)
{
  short Result;
  Char tempname[256];
  Char filtername[256];
  Char hs[256];
  short handle, ergebnis;
  long rp;

  debug(2, 0, 25, ziel);
  *no_sf = false;
  Result = 0;
  mfilter_sem++;
  sprintf(hs, "%ld", mfilter_sem);
  sprintf(tempname, "%sM_FILTER%c%s", tempdir, extsep, hs);
  strcpy(filtername, m_filter_prg);
  handle = sfcreate(tempname, FC_FILE);
  if (handle < minhandle)
    return Result;
  if (*frombox != '\0')
    string_to_file(&handle, frombox, true);
  else
    string_to_file(&handle, Console_call, true);
  string_to_file(&handle, absender, true);
  string_to_file(&handle, ziel, true);

  string_to_file(&handle, mbx, true);
  string_to_file(&handle, lifetime, true);
  string_to_file(&handle, bulletin_id, true);
  string_to_file(&handle, betreff, true);
  if (sfwrite(handle, *size - *lesezeiger, (uchar *)(&(*puffer)[*lesezeiger])) ==
      *size - *lesezeiger) {
    sfclose(&handle);
    ergebnis = call_prg(filtername, tempname, "OUT.TXT");
    if (ergebnis > 4) ergebnis = 0;
    if (ergebnis > 2) {
      if (ergebnis == 4)
	*no_sf = true;
      ergebnis = 1;   /* erstmal als geloescht markieren */
      mymfreep(puffer);
      rp = 0;
      *size = sfsize(tempname);
      if (*size <= maxram()) {
	handle = sfopen(tempname, FO_READ);
	if (handle >= minhandle) {
	  *puffer = Malloc(2048);
	  if (*puffer != NULL) {
	    sfread(handle, 2048, *puffer);
	    get_line(*puffer, &rp, *size, hs);
	    get_line(*puffer, &rp, *size, hs);
	    get_line(*puffer, &rp, *size, hs);
	    cut(hs, 8);
	    strcpy(ziel, hs);
	    get_line(*puffer, &rp, *size, hs);
	    get_line(*puffer, &rp, *size, hs);
	    cut(hs, 3);
	    strcpy(lifetime, hs);
	    get_line(*puffer, &rp, *size, hs);
	    get_line(*puffer, &rp, *size, hs);
	    mymfreep(puffer);
	    sfseek(rp, handle, SFSEEKSET);
	    *size -= rp;
	    *puffer = Malloc(*size);
	    if (*puffer != NULL) {
	      if (sfread(handle, *size, *puffer) == *size) {
		*lesezeiger = 0;
		ergebnis = 0;   /* ok, gueltig */
	      } else {
		*size = 0;
		mymfreep(puffer);
		debug(0, 0, 25, "read error");
		ergebnis = 0;
		m_filter = false;
	      }
	    }
	  }
	  sfclose(&handle);
	}
      }
    } else if (ergebnis == 2) {
      *no_sf = true;
      ergebnis = 0;
    } else if (ergebnis < 0) {
      debug(0, 0, 25, "EXEC ERROR");
      ergebnis = 0;
      m_filter = false;
    }
    Result = ergebnis;
  } else
    sfclose(&handle);
  sfdelfile(tempname);
  return Result;
}


#define blocksize       16384


Static void new_entry(short unr, Char *dname1_, Char *status_, Char *betreff1,
		      Char *bulletin_id, long size1, long lesezeiger,
		      Char *rcall_, Char *frombox_, boolean forwarding,
		      boolean sfcut, boolean authentisch, boolean broadcast)
{
  Char dname1[256];
  Char status[256];
  Char rcall[7], frombox[7];

  Char info[256], index[256], archiv[256];
  Char temp1[256], temp2[256], dname[256];
  short k, k1, k2, k4, nr;
  Char hs[256], hs2[256], hs3[256];
  Char ziel[256], ziel2[256];
  Char absender1[256];
  Char mbx[256];
  Char datum[256], zeit[256], laenge[256], lifetime1[256];
  Char ackcall[256];
  indexstruct header;
  short packresult, fidx, loopct;
  unsigned short acc, lth;
  boolean fw1, looperr, server, dieboxsys, no_sf, is_7plus, is_binary,
	  ack_requested, compress, is_html, dirty, part, db, ok, usersf;
  Char hmbx[7];
  boolean hmbxiscall;
  uchar *nmem, *puffer;
  long nsize, psize, bct, lastpos1, lastpos2, sv, hsize, rs, li, updtime,
       chargedate, txdate1;
  short ergebnis;
  Char mtyp, mtyp7ext;
  boolean wpupdate, outdated, reject_it, hold_it, dbimport, dbimpfilter;
  unsigned short ics;
  Char dirtystring[256];
  Char lastvias[256];
  Char TEMP;
  Char STR1[256];
  Char STR7[36];
  Char STR13[256];

  strcpy(dname1, dname1_);
  strcpy(status, status_);
  strcpy(rcall, rcall_);
  strcpy(frombox, frombox_);
  debug(2, unr, 26, dname1);
  if (!fast_machine)
    boxendbusy();
  strcpy(dname, dname1);
  ack_requested = false;
  is_binary = false;
  is_7plus = false;
  dirty = false;
  is_html = false;
  server = false;
  looperr = false;
  wpupdate = false;
  reject_it = false;
  hold_it = false;
  outdated = false;
  dbimport = (unr == -98 || unr == -99);
  dbimpfilter = (unr == -98);
  loopct = 0;
  txdate1 = 0;
  header.packsize = 0;
  ics = 0;
  mtyp = '\0';
  ackcall[0] = '\0';

  lastvias[0] = '\0';
  dirtystring[0] = '\0';
  chargedate = 0;

  compress = (size1 - lesezeiger >= packmin && packdelay == 0);
  if (sfcut)
    split_sline(status, ziel, absender1, mbx, bulletin_id, lifetime1, hs);
  else
    mtyp = separate_status(status, ziel, absender1, mbx, datum, zeit, laenge,
			   lifetime1);

  if (!strcmp(lifetime1, "-"))
    strcpy(lifetime1, "0");

  if (mtyp == '\0')
    check_msgtype(&mtyp, ziel, betreff1);

  strcpy(header.dest, ziel);
  header.txlifetime = Str2int(lifetime1);
  no_sf = false;

  if (dbimport)
    cdbtboard(ziel);
  check_verteiler(ziel);
  if (!valid_boardname(ziel)) {
    if (*default_rubrik != '\0')
      strcpy(ziel, default_rubrik);
    else
      strcpy(ziel, "TEMP");
  }


  fw1 = (forwarding || callsign(frombox));
  unhpath(mbx, hmbx);
  hmbxiscall = callsign(hmbx);

  if (broadcast)   /* Der S&F... */
    forwarding = (strcmp(hmbx, frombox) && bcastforward);
  else if (callsign(frombox))
    forwarding = true;

  hs[0] = '\0';

  dieboxsys = (strlen(ziel) == 1 &&
	       (TEMP = upcase_(ziel[0]), TEMP == 'E' || TEMP == 'M'));

  usersf = (!dbimport && !charge_bbs && fw1 && !dieboxsys &&
	    *frombox != '\0' && sfinpdefault < 3 &&
	    strcmp(frombox, Console_call) && !in_sfp(frombox));

  if (usersf) {  /* im user-sf hinter die letzte R:-Zeile gehen */
    k1 = sfopen(dname, FO_READ);
    if (k1 >= minhandle) {
      if (sfseek(lesezeiger, k1, SFSEEKSET) == lesezeiger) {
	while (file_to_string(k1, hs) && strpos2(hs, "R:", 1) == 1)
	  lesezeiger = sfseek(0, k1, SFSEEKCUR);
      }
      sfclose(&k1);
    }
  } else if (fw1 && (!strcmp(frombox, Console_call) || charge_bbs)) {
    k1 = sfopen(dname, FO_READ);
    if (k1 >= minhandle) {
      if (sfseek(lesezeiger, k1, SFSEEKSET) == lesezeiger) {
	if (file_to_string(k1, hs) && strpos2(hs, "R:", 1) == 1 &&
	    (charge_bbs || uspos(Console_call, hs) > 0)) {
	  if (charge_bbs) {
	    if (strlen(hs) >= '\016' && hs[13] != 'Z')
	      hs[13] = 'Z';
	    chargedate = get_headerdate(hs);
	  }
	  lesezeiger = sfseek(0, k1, SFSEEKCUR);
	}
      }
      sfclose(&k1);
    }
  }


  if (fw1 && !broadcast && !dbimport && !charge_bbs) {
    if (hmbxiscall && !strcmp(hmbx, Console_call)) {
      if (!strcmp(header.dest, "WP"))
	wpupdate = (create_wp && callsign(absender1) &&
		    strcmp(absender1, Console_call) &&
		    (scan_all_wp || in_wpservers(absender1)));
      else if (!strcmp(header.dest, "LOCAL") && mtyp == 'P' ||
	       !strcmp(header.dest, "LOCBBS") && mtyp == 'P' ||
	       !strcmp(header.dest, "REGION") ||
	       !strcmp(header.dest, "NATION")) {
	if (do_redist(absender1, header.dest, betreff1, dname, lesezeiger)) {
	  if (*bulletin_id != '\0')
	    write_msgid(-1, bulletin_id);
	  server = true;
	}
      } else if (in_servers(header.dest)) {
	if (do_server(absender1, header.dest, betreff1, dname, lesezeiger)) {
	  if (*bulletin_id != '\0')
	    write_msgid(-1, bulletin_id);
	  server = true;
	} else {
	  sprintf(betreff1, "SERVER %s: %s",
		  header.dest, strcpy(STR1, betreff1));
	  cut(betreff1, 80);
	  strcpy(ziel, "Y");
	  sprintf(STR7, "Invalid request to server %s", header.dest);
	  append_profile(unr, STR7);
	}
      }

    }
  }

  /* ------------------------------------------------------------------ */

  part = true;

  if (!dieboxsys) {
    psize = size1 - lesezeiger;
    if (psize <= maxram()) {
      puffer = Malloc(psize);
      if (puffer != NULL) {
	part = false;
	k1 = sfopen(dname, FO_READ);
	if (k1 >= minhandle) {
	  sfseek(lesezeiger, k1, SFSEEKSET);
	  size1 = sfread(k1, psize, puffer);
	  sfclose(&k1);
	  lesezeiger = 0;
	}
      }

    }


  }


  /* ----------------------------------------------------------------- */

  if (server) {  /* auch bei servermails die hroutes updaten! */
    if (!part) {
      if (ana_hpath && !usersf) {
	if (strcmp(rcall, "-moni-")) {
	  if (*frombox != '\0' || !fw1) {
	    strcpy(hs, frombox);
	    scan_hierarchicals(hs, puffer, size1, &txdate1,
			       in_sfp(hs) && mtyp != 'A', lastvias);
	  }
	}
      }
      mymfreep(&puffer);
    }
  }

  /* ----------------------------------------------------------------- */

  if (!dieboxsys && !server) {
    strcpy(ziel2, ziel);

    if (!part) {
      /* tja, sorry, bei nur teilweise in den Speicher zu ladenden     */
      /* Files wird der Filter nicht aufgerufen. Sollte aber in der    */
      /* Praxis nicht auftreten.                                       */

      if (m_filter)
	ergebnis = call_m_filter(&puffer, &size1, &lesezeiger, frombox, ziel,
				 mbx, absender1, lifetime1, bulletin_id,
				 betreff1, &no_sf);
      else
	ergebnis = 0;
    } else
      ergebnis = 0;


    if (ergebnis == 0 && convtit && (!dbimport || dbimpfilter)) {
      /*local?*/
      do_convtit(frombox, mtyp, ziel, mbx, absender1, lifetime1, betreff1,
		 bulletin_id, size1, usersf || fw1 && *frombox == '\0',
		 authentisch, &reject_it, &hold_it);
    }

    if (!strcmp(ziel, ziel2))
      switch_to_default_board(ziel);
    if (reject_it)
      ergebnis = 1;

    /* ----------------------------------------------------------------- */
    if (ergebnis == 0) {
      if (!fast_machine)
	boxbusy("sort mail");

      if (ana_hpath && !usersf) {
	if (strcmp(rcall, "-moni-")) {
	  if (*frombox != '\0' || !fw1) {
	    strcpy(hs, frombox);

	    if (part) {
	      /* So grosses Filefragment wie moeglich einlesen und dann abscannen   */

	      sfbread(true, dname, &puffer, &psize);
	      if (psize > 0) {
		loopct = scan_hierarchicals(hs,
		    (uchar *)(&puffer[lesezeiger]), psize - lesezeiger,
		    &txdate1, in_sfp(hs) && mtyp != 'A', lastvias);
		mymfreep(&puffer);
	      }
	    } else
	      loopct = scan_hierarchicals(hs, puffer, size1, &txdate1,
					  in_sfp(hs) && mtyp != 'A',
					  lastvias);


	    /* gesamtes File scannen                                             */



	    if (hmbxiscall)   /* kommt sonst kein "Routing Error" */
	      *lastvias = '\0';

	  }
	}
      }

      /* --------------------------------------------------------------------- */

      if (loopct > 0 && fw1) {  /* nur stoppen, wenn im S&F */
	if (!hmbxiscall)
	      /* einfach lschen ! doppelte Bulletins hat es nicht zu geben */
		goto _L1;
	if (loopct >= 3) {
	  no_sf = true;   /* sf stoppen. geht augenscheinlich schief */
	  looperr = true;
	}
      } else if (!hmbxiscall && txdate1 != 0 &&
		 clock_.ixtime - txdate1 > bullsfmaxage) {
	if (!dbimport && !charge_bbs) {
	  outdated = true;
	  no_sf = true;
	}
      }

      /* ---------------------------------------------------------------------- */

      if (check_for_dirty(betreff1)) {
	strcpy(dirtystring, betreff1);
	dirty = true;
      }

      /* ---------------------------------------------------------------------- */

      mtyp7ext = mtyp;
	  /* Keine Mails an privilegierte Rubriken extrahieren */
      if (mtyp7ext == 'B') {
	acc = 1;
	check_lt_acc(ziel, &lth, &acc);
	if (acc > 1 || ziel[1] == '\0') /* Einbuchstabenrubrik */
	  mtyp7ext = 'C';
      }

      if (part) {   /* und Test auf #BIN#-File */
	debug(2, unr, 26, "part");

	/* den ersten und den letzten Block des Files einlesen und scannen   */

	dpgetmem(&puffer, blocksize);
	if (puffer != NULL) {
	  k1 = sfopen(dname, FO_READ);
	  if (k1 >= minhandle) {
	    sv = lesezeiger;
	    psize = size1 - sv;
	    if (psize > blocksize)
	      psize = blocksize;
	    sfseek(sv, k1, SFSEEKSET);
	    psize = sfread(k1, psize, puffer);

	    /* scan nach BIN / 7PLUS */

	    ack_requested = scan_for_ack(puffer, psize, wpupdate, part,
		absender1, header.dest, betreff1, mtyp7ext, ackcall,
		&is_binary, &dirty, &is_html, dirtystring, &is_7plus);
		/* und Test auf #BIN#-File */

	    /*not ack_requested and*/
	    if (sv + psize < size1) {
	      sv = size1 - blocksize;
	      if (sv < lesezeiger)
		sv = lesezeiger;
	      psize = size1 - sv;
	      sfseek(sv, k1, SFSEEKSET);
	      psize = sfread(k1, psize, puffer);

	      /* scan nach '/ACK'      */

	      ack_requested = scan_for_ack(puffer, psize, wpupdate, part,
		  absender1, header.dest, betreff1, mtyp7ext, hs, &db, &dirty,
		  &is_html, dirtystring, &db);
	    }
	    sfclose(&k1);
	  }
	  dpfreemem(&puffer, blocksize);
	}


      } else
	ack_requested = scan_for_ack(puffer, size1, wpupdate, part, absender1,
	    header.dest, betreff1, mtyp7ext, ackcall, &is_binary, &dirty,
	    &is_html, dirtystring, &is_7plus);

      /* das ganze File ist im RAM und wird in einem Rutsch gescannt   */


      if (!((hmbxiscall && !strcmp(hmbx, Console_call) || unr == -77) &&
	    fw1 && strpos2(betreff1, "CP ", 1) != 1))
	ack_requested = false;


      if ((dirty || !strcmp(ziel, "D")) && strcmp(absender1, Console_call)) {
	strcpy(ziel, "D");
	dirty = true;
	no_sf = true;
      } else
	dirty = false;

      /* ------------------------------------------------------------------- */

      sprintf(info, "%s%s%c%s", infodir, ziel, extsep, inf_e);
      sprintf(index, "%s%s%c%s", indexdir, ziel, extsep, idx_e);
      if (sfsize(index) / sizeof(indexstruct) >= SHORT_MAX - 1) {
	sprintf(STR13, "board %s full. No more input possible.", ziel);
	debug(0, unr, 26, STR13);
	goto _L1;
      }
      sprintf(archiv, "%sINFO%cT0", tempdir, extsep);
      sprintf(temp1, "%sINFO%cT1", tempdir, extsep);
      sprintf(temp2, "%sINFO%cT2", tempdir, extsep);

      if (strcmp(rcall, Console_call) && !sfcut && !broadcast || usersf) {
	if (usersf) {
	  sprintf(hs, "X-Info: User S&F received from %s at %s\n",
		  frombox, Console_call);
	  if (!authentisch && authentinfo) {   /* and (mtyp <> 'P') */
	    sig_german_authinfo(frombox, mbx, hs2);
	    sprintf(hs + strlen(hs), "%s\n", hs2);
	  }
	} else {
	  strsub(hs, datum, 7, 2);
	  strsub(hs2, datum, 4, 2);
	  strcat(hs, hs2);
	  sprintf(hs2, "%.2s", datum);
	  sprintf(hs + strlen(hs), "%s/", hs2);
	  sprintf(hs2, "%.2s", zeit);
	  strcat(hs, hs2);
	  strsub(hs2, zeit, 4, 2);
	  sprintf(hs + strlen(hs), "%sz @:%s", hs2, rcall);
	  if (!strcmp(rcall, "-moni-"))
	    sprintf(hs, "I:%s [Monitor/Import at %s]",
		    strcpy(STR13, hs), Console_call);
	  else
	    sprintf(hs, "R:%s", strcpy(STR13, hs));
	}
      } else
	*hs = '\0';




      /* --------------------------------------------------------------------- */

      if (compress) {
	if (part) {
	  /* Leider liegt sie nicht komplett im RAM vor ...            */

	  dpgetmem(&puffer, blocksize);
	  if (puffer != NULL) {
	    k2 = sfcreate(temp1, FC_FILE);
	    if (k2 >= minhandle) {
	      k1 = sfopen(dname, FO_READ);
	      if (k1 >= minhandle) {
		if (strlen(hs) >= '\0')
		  string_to_file(&k2, hs, true);

		hsize = sfseek(lesezeiger, k1, SFSEEKSET);
		rs = size1 - hsize;
		ok = true;
		while (rs > 0 && ok) {
		  if (rs > blocksize)
		    rs = blocksize;
		  bct = sfread(k1, rs, puffer);
		  if (bct <= 0) {
		    debug(0, unr, 26, "read error (1)");
		    no_sf = true;
		    ok = false;
		    continue;
		  }

		  if (sfwrite(k2, bct, puffer) == bct) {
		    hsize += bct;
		    rs = size1 - hsize;
		  } else {
		    debug(0, unr, 26, "write error (1)");
		    no_sf = true;
		    ok = false;
		  }
		}

		sfclose(&k1);
		sfclose(&k2);

		size1 -= lesezeiger;
		lesezeiger = 0;
		strcpy(dname, temp1);

		header.size = size1;

		if (huffpacker(true, dname, temp2, false) == 0) {
		  sfdelfile(dname);
		  strcpy(dname, temp2);
		  header.pmode = PM_HUFF2;
		} else
		  header.pmode = PM_NONE;

		header.packsize = sfsize(dname);
		size1 = header.packsize;

	      } else
		sfclose(&k2);


	    }
	    dpfreemem(&puffer, blocksize);
	  } else
	    boxprotokoll("no mem");


	} else {
	  /* Datei komplett im RAM, dann passt auch das Ergebnis ins RAM   */

	  if (*hs != '\0') {
	    bct = size1;
	    add_line_to_buff(&puffer, &bct, 0, hs);
	    size1 = bct;
	  }

	  packresult = huffmempacker(true, puffer, size1, &nmem, &nsize,
				     archiv, false);
	  header.size = size1;
	  if (packresult != 0) {
	    boxprotokoll(memfailtxt);
	    header.packsize = size1;
	    header.pmode = PM_NONE;
	  } else {
	    mymfreep(&puffer);
	    lesezeiger = 0;
	    if (nmem != NULL) {
	      puffer = nmem;
	      header.packsize = nsize;
	    } else {
	      puffer = Malloc(sfsize(archiv));
	      if (puffer != NULL) {
		k4 = sfopen(archiv, FO_READ);
		header.packsize = sfread(k4, sfsize(archiv), puffer);
		sfclose(&k4);
	      } else {
		puffer = NULL;
		header.packsize = 0;
	      }
	      sfdelfile(archiv);
	    }

	    header.pmode = PM_HUFF2;
	  }
	}


      } else
	header.packsize = size1 - lesezeiger;

      /* -------------------------------------------------------------------- */

      if (header.packsize > 0) {
	if (exist(info)) {
	  k1 = sfopen(info, FO_RW);
	  k2 = sfopen(index, FO_RW);
	} else {
	  k1 = sfcreate(info, FC_FILE);
	  k2 = sfcreate(index, FC_FILE);
	}

	if (k1 >= minhandle && k2 >= minhandle) {
	  lastpos1 = sfseek(0, k1, SFSEEKEND);
	  lastpos2 = sfseek(0, k2, SFSEEKEND);


	  if (!compress) {
	    header.pmode = PM_NONE;

	    if (*hs != '\0') {
	      checksum16_buf(hs, strlen(hs), &ics);
	      checksum16(10, &ics);
	      string_to_file(&k1, hs, true);
	    }
	  }

	  if (part) {
	    dpgetmem(&puffer, blocksize);

	    if (puffer != NULL) {
	      k = sfopen(dname, FO_READ);
	      if (k >= minhandle) {
		hsize = sfseek(lesezeiger, k, SFSEEKSET);
		rs = size1 - hsize;
		ok = true;
		while (rs > 0 && ok) {
		  if (rs > blocksize)
		    rs = blocksize;
		  bct = sfread(k, rs, puffer);
		  if (bct <= 0) {
		    debug(0, unr, 26, "read error (2)");
		    no_sf = true;
		    ok = false;
		    continue;
		  }
		  checksum16_buf(puffer, bct, &ics);
		  if (sfwrite(k1, bct, puffer) == bct) {
		    hsize += bct;
		    rs = size1 - hsize;
		  } else {
		    debug(0, unr, 26, "write error (2)");
		    no_sf = true;
		    ok = false;
		  }
		}

		sfclose(&k);

	      }


	      dpfreemem(&puffer, blocksize);
	    } else
	      boxprotokoll("no mem");


	  } else {
	    if (puffer != NULL) {
	      checksum16_buf(puffer, header.packsize, &ics);
	      if (sfwrite(k1, header.packsize, puffer) != header.packsize) {
		debug(0, unr, 26, "write error (4)");
		no_sf = true;
	      }
	      mymfreep(&puffer);
	    }
	  }



	  if (!compress) {
	    header.size = size1 - lesezeiger;
	    if (*hs != '\0')
	      header.size += strlen(hs) + 1;
	    header.packsize = header.size;
	  }

	  header.deleted = false;
	  header.msgnum = new_msgnum();
	  strcpy(header.id, bulletin_id);
	  strcpy(header.absender, absender1);
	  strcpy(header.verbreitung, mbx);
	  cut(betreff1, 80);
	  strcpy(header.betreff, betreff1);
	  if (dbimport)
	    header.rxdate = string2ixtime(datum, zeit);
	  else if (charge_bbs) {
	    if (chargedate > clock_.ixtime || chargedate == 0)
	      chargedate = clock_.ixtime;
	    header.rxdate = chargedate;
	  } else {
	    header.rxdate = clock_.ixtime;
	    if (header.rxdate <= lastmailixtime)
	      header.rxdate = lastmailixtime + 1;
	    lastmailixtime = header.rxdate;
	  }
	  header.txdate = txdate1;
	  header.rxqrg = boxaktqrg();
	  header.lifetime = Str2int(lifetime1);
	  if (outdated)
	    header.lifetime = 1;

	  if (reduce_lt_after_extract && (is_7plus || is_binary) &&
	      header.msgtype == 'B') {
	    li = bullsfmaxage / 86400L;
	    if (li > 0) {
	      if (header.lifetime > li || header.lifetime == 0)
		header.lifetime = li;
	    }
	  }

	  header.start = lastpos1;
	  strcpy(header.rxfrom, frombox);
	  sfseek(header.start, k1, SFSEEKSET);
	  sfread(k1, 1, &header.firstbyte);
	  header.msgtype = mtyp;
	  header.fwdct = 0;
	  header.erasetime = 0;
	  header.lastread = 0;
	  header.readcount = 0;
	  *header.readby = '\0';
	  header.eraseby = 0;
	  strcpy(header.sendbbs, ackcall);

	  header.infochecksum = ics;
	  header.bcastchecksum = 0;

	  acc = 1;
	  check_lt_acc(ziel, &header.lifetime, &acc);
	  header.level = acc;

	  if (is_binary)
	    header.pmode |= TBIN;
	  else if (is_7plus)
	    header.pmode |= T7PLUS;
	  if (is_html)
	    header.pmode |= THTML;

	  if (broadcast)
	    header.msgflags = MSG_BROADCAST_RX;
	  else {
	    if (fw1) {
	      if (!usersf && *header.rxfrom != '\0')
		header.msgflags = MSG_SFRX;
	      else {
		header.msgflags = MSG_MINE;
		strcpy(header.sendbbs, Console_call);
		header.txdate = header.rxdate;
	      }
	    } else
	      header.msgflags = MSG_CUT;
	  }

	  if (hold_it && strcmp(header.absender, Console_call)) {
	    if (header.msgflags == MSG_MINE)
	      header.msgflags |= MSG_LOCALHOLD;
	    else
	      header.msgflags |= MSG_SFHOLD;
	  }

	  if (outdated)
	    header.msgflags |= MSG_OUTDATED;

	  if ((header.msgflags & MSG_SFRX) != 0) {
	    nr = actual_user(frombox);
	    if (nr > 0) {
	      switch (header.msgtype) {

	      case 'A':
	      case 'P':
		user[nr]->fstat_rx_p++;
		break;

	      default:
		user[nr]->fstat_rx_b++;
		break;
	      }
	    }
	  }
	  ack_requested = ((header.msgflags & MSG_SFRX) != 0 && ack_requested);


	  write_index(k2, -1, &header);
	  sfclose(&k2);
	  sfclose(&k1);

	  write_log_and_bid(ziel, lastpos2 / sizeof(indexstruct) + 1, header);

	  if (!dbimport && !charge_bbs && forwarding) {
	    if (no_sf) {
	      if (looperr)
		fidx = -3;   /* das ist ein Flag */
	      else if (outdated)
		fidx = -5;   /* das auch */
	      else if (dirty)
		fidx = -4;   /* das auch */
	      else
		fidx = -2;
	      if (dirty) {
		sprintf(ziel + strlen(ziel), "(%s)", header.dest);
		*hs = '\0';
	      } else
		strcpy(hs, "fwd stopped for ");
	      sprintf(STR13, "%s%s@%s < %s $%s",
		      hs, ziel, header.verbreitung, header.absender,
		      header.id);
	      append_profile(fidx, STR13);
	    } else if (!dirty) {
	      fidx = sfsize(index) / sizeof(indexstruct);
	      *hs = '\0';
	      if (fidx > 0)
		set_forward(-1, unr, ziel, hs, fidx, fidx, "FORWARD", frombox,
			    lastvias);
	    }
	  }

	  if (dirty && *dirtystring != '\0')
	    append_profile(-4, dirtystring);

	  /* Achtung, neue Nachricht fuer Dich ... */
	  if (!dbimport && callsign(ziel) && !dirty && !charge_bbs &&
	      strcmp(header.absender, ziel)) {
	    nr = actual_user(ziel);
	    if (nr > 0) {
	      if (!user[nr]->f_bbs) {
		if (user[nr]->action == 0 && user[nr]->lastprocnumber == 0) {
		  fidx = sfsize(index) / sizeof(indexstruct);
		  wlnuser(nr, "");
		  wlnuser(nr, "");
		  wln_btext(nr, 10);
		  *hs = '\0';
		  wlnuser0(nr);
		  list_brett(nr, ziel, fidx, fidx, hs, hs);
		  show_prompt(nr);
		} else {
		  msgwuser(nr, false, "", true);
		  msgwuser(nr, false, "", true);
		  get_btext(nr, 10, hs);
		  msgwuser(nr, false, hs, true);
		}
	      }
	    }
	  }

	  if (create_acks && ack_requested && !dbimport && !dirty &&
	      !charge_bbs) {
	    if (unr == -77)
	      strcpy(hs, header.verbreitung);
	    else
	      *hs = '\0';
	    create_ack(header.absender, ackcall, header.dest, hs,
		       header.betreff);
	  }

	}  /* of k1 / k2 >= minhandle */
	else {
	  sfclose(&k1);
	  sfclose(&k2);
	  sprintf(hs, "file open error: %s", info);
	  debug(0, unr, 26, hs);
	}

      }

    }  /* of ergebnis = 0 */

  }  /* of not diebox_sys */
  else if (dieboxsys && !dbimport && !charge_bbs && check_double(bulletin_id)) {
    if (forwarding && !no_sf) {
      nr = actual_user(frombox);
      if (nr > 0)
	user[nr]->fstat_rx_s++;
      set_sys_fwd(ziel[0], frombox, absender1, bulletin_id, betreff1, mbx);
    }
    if (upcase_(ziel[0]) == 'E') {
      strcpy(hs, betreff1);
      get_word(hs, hs2);
      cut(hs2, 12);
      if (remote_erase) {
	if (!remoteerasecheck || strpos2(hs2, absender1, 1) > 0)
	  add_remote_erase(absender1, bulletin_id, frombox, hs2);
      }
    } else if (upcase_(ziel[0]) == 'M') {
      strcpy(hs, betreff1);
      get_word(hs, hs2);
      get_word(hs, hs3);
      updtime = str2lint(hs3);
      if ((unsigned long)strlen(hs2) < 32 && ((1L << strlen(hs2)) & 0x78) != 0) {
	updtime -= THEBOX_ERRONEOUS_OFFSET;
	if (callsign(hs2))
	  update_mybbsfile(false, absender1, &updtime, hs2, "U");
      }
    }

_L1: ;
  }


  debug(5, unr, 26, "...done");
}

#undef blocksize


Static void get_fbbdatime(Char *zs, long *date)
{
  uchar d, m, y, h, min, s;
  short x;
  Char w[256];
  Char dw[21];

  upper(zs);
  x = strpos2(zs, ":", 1);
  if (x > 0)
    strdelete((void *)zs, 1, x);
  get_word(zs, w);
  d = clock_.day;
  m = clock_.mon;
  y = clock_.year;
  x = strpos2(w, "-", 1);
  if (x > 0) {
    sprintf(dw, "%.*s", x - 1, w);
    d = Str2int(dw);
    strdelete((void *)w, 1, x);
    cut(w, 3);
    x = 0;
    do {
      x++;
    } while (x != 12 && strcmp(fbb_month[x - 1], w));
    m = x;
  }
  get_word(zs, w);
  h = clock_.hour;
  min = clock_.min;
  s = 0;
  x = strpos2(w, ":", 1);
  if (x > 0) {
    sprintf(dw, "%.*s", x - 1, w);
    h = Str2int(dw);
    strdelete((void *)w, 1, x);
    min = Str2int(dw);
  }
  *date = calc_ixtime(d, m, y, h, min, s);
}


Static void transform_boxheader(cutboxtyp cuttyp, Char *status, Char *z1,
  Char *z2, Char *z3, Char *z4, Char *z5, Char *z6)
{
  indexstruct header;
  short x;
  boolean nb;
  Char brett[256], dw[256];
  Char z0[256], w[256];

  debug(3, 0, 27, status);
  strcpy(z0, status);
  status[0] = '\0';
  header.lifetime = 0;
  header.msgtype = '\0';
  header.size = 999000L;
  strcpy(header.verbreitung, Console_call);

  switch (cuttyp) {

  case F6FBB_USER_314:
    strdelete((void *)z0, 1, strlen(fbb314_fromfield));
    get_word(z0, header.absender);
    strdelete((void *)z1, 1, strlen(fbb314_tofield));
    get_word(z1, w);
    x = strpos2(w, "@", 1);
    if (x > 0) {
      strsub(header.verbreitung, w, x + 1, strlen(w) - x);
      cut(w, x - 1);
      strcpy(brett, w);
    } else {
      strcpy(brett, w);
      if (strpos2(z1, "@", 1) == 1) {
	strdelete((void *)z1, 1, 1);
	get_word(z1, header.verbreitung);
      }
    }

    x = strpos2(z6, ":", 1);
    if (x > 0)
      strdelete((void *)z6, 1, x);
    del_leadblanks(z6);
    cut(z6, 80);
    strcpy(header.betreff, z6);

    get_fbbdatime(z3, &header.rxdate);

    x = strpos2(z4, ":", 1);
    if (x > 0)
      strdelete((void *)z4, 1, x);
    del_leadblanks(z4);
    cut(z4, 12);
    strcpy(header.id, z4);
    create_status(0, false, brett, header, status);
    strcpy(z1, header.betreff);
    sprintf(z2, "* ID %s *", header.id);

    break;

  case F6FBB_USER:
    strdelete((void *)z0, 1, strlen(fbb_fromfield));
    get_word(z0, header.absender);
    strdelete((void *)z0, 1, strlen(fbb_tofield));
    get_word(z0, w);
    x = strpos2(w, "@", 1);
    if (x > 0) {
      strsub(header.verbreitung, w, x + 1, strlen(w) - x);
      cut(w, x - 1);
      strcpy(brett, w);
    } else {
      strcpy(brett, w);
      if (strpos2(z0, "@", 1) == 1) {
	strdelete((void *)z0, 1, 1);

	get_word(z0, header.verbreitung);
      }
    }
    x = strpos2(z4, ":", 1);
    if (x > 0)
      strdelete((void *)z4, 1, x);
    del_leadblanks(z4);
    cut(z4, 80);
    strcpy(header.betreff, z4);

    get_fbbdatime(z2, &header.rxdate);
    ixzeit2string(header.rxdate, dw);
    ixdatum2string(header.rxdate, w);
    create_userid(brett, header.absender, w, dw, header.betreff, header.id);
    create_status(0, false, brett, header, status);
    strcpy(z1, header.betreff);
    sprintf(z2, "* ID %s *", header.id);
    break;

  case AA4RE_USER:
    z1[0] = '\0';
    z2[0] = '\0';
    break;

  case W0RLI_USER:
    z1[0] = '\0';
    z2[0] = '\0';
    break;

  case RAW_IMPORT:
    upper(z1);
    if (callsign(z1)) {
      strcpy(header.absender, z1);

      upper(z2);
      if (valid_boardname(z2)) {
	strcpy(header.dest, z2);

	upper(z3);
	unhpath(z3, dw);
	nb = false;


	if (*dw == '\0' || !strcmp(dw, Console_call)) {
	  if (callsign(header.dest)) {
	    user_mybbs(header.dest, z3);
	    if (*z3 == '\0')
	      strcpy(z3, ownhiername);
	    else {
	      unhpath(z3, dw);
	      if (strcmp(dw, Console_call))
		nb = true;
	    }
	  } else
	    strcpy(z3, ownhiername);
	}

	if (strpos2(z3, ".", 1) == 0 && callsign(z3))
	  complete_hierarchical_adress(z3);

	strcpy(header.verbreitung, z3);

	header.lifetime = Str2int(z4);

	if ((unsigned long)strlen(z5) < 32 &&
	    ((1L << strlen(z5)) & 0x1fff) != 0) {
	  strcpy(header.id, z5);
	  if (*header.id == '\0')
	    new_bid(header.id);
	  else if (nb) {
	    write_msgid(-1, header.id);
	    new_bid(header.id);
	  }

	  if (strpos2(z6, "Subject: ", 1) == 1)
	    strdelete((void *)z6, 1, 9);
	  cut(z6, 80);
	  strcpy(header.betreff, z6);

	  header.rxdate = clock_.ixtime;

	  create_status(0, true, header.dest, header, status);

	  strcpy(z1, header.betreff);
	  sprintf(z2, "* ID %s *", header.id);

	}
      }
    }
    break;

  }
}


#define blocksize       16384


Static boolean sort_new_mail3(short unr, Char *pattern_, Char *rcall1_)
{
  boolean Result;
  Char pattern[256];
  Char rcall1[256];

  DTA dirinfo;
  short result;
  Char zeile[256], ds[256];
  Char z1[256], z2[256], z3[256], z4[256], z5[256], z6[256], status[256],
       betreff[256];
  Char ziel[9];
  Char absender[7];
  Char mbx[41];
  Char datum[256], zeit[256], laenge[256], lifetime[256];
  short k;
  long bct, lesezeiger, hlz, err;
  boolean imperr, origin, sfcut, okb, oka, had_no_bid;
  Char bulletin_id[256];
  Char dname[256];
  long dsize;
  uchar *puffer;

  Char frombox[256];
  cutboxtyp cuttyp;

  boolean take_double, broadcast, authentisch, mycall_in_rlines;
  Char hpath[256], rcall[256];
  Char STR1[10];
  Char STR7[8];
  Char STR13[256];


  strcpy(pattern, pattern_);
  strcpy(rcall1, rcall1_);
  debug(2, unr, 28, pattern);

  Result = false;

  dpgetmem(&puffer, blocksize);
  if (puffer == NULL)
    return Result;
  boxsetbmouse();
  strcpy(hpath, pattern);
  result = sffirst(pattern, 0, &dirinfo);

  if (result == 0 && dirinfo.d_length > 0) {
    Result = true;
    get_path(hpath);
    sprintf(dname, "%s%s", hpath, dirinfo.d_fname);

    debug(3, unr, 28, dname);
    strcpy(frombox, dname);
    broadcast = false;
    del_path(frombox);
    authentisch = true;
    if (frombox[0] == '&') {
      strdelete((void *)frombox, 1, 1);
      del_ext(frombox);
    } else if (frombox[0] == '%') {
      strdelete((void *)frombox, 1, 1);
      del_ext(frombox);
      authentisch = false;
    } else if (frombox[0] == '$') {
      strdelete((void *)frombox, 1, 1);
      del_ext(frombox);
      broadcast = true;
    } else
      *frombox = '\0';
    if (frombox[0] == '_') {
      strdelete((void *)frombox, 1, 1);
      had_no_bid = true;
    } else
      had_no_bid = false;
    cut(frombox, 6);
    if (!callsign(frombox))
      *frombox = '\0';

    cut(frombox, 6);
    strcpy(ds, dname);
    upper(ds);
    del_path(ds);
    if (ds[0] == '%' || ds[0] == '&')
      strdelete((void *)ds, 1, 1);
    if (ds[0] == '_')
      strdelete((void *)ds, 1, 1);
    strcpy(rcall, rcall1);
    cut(rcall, 6);
    sprintf(STR1, "SENDING%c", extsep);
    origin = ((strpos2(ds, STR1, 1) == 1 ||
	       strpos2(ds, (sprintf(STR7, "IMPORT%c", extsep), STR7), 1) == 1) &&
	      !strcmp(rcall, Console_call));
    sprintf(STR7, "SFBOX%c", extsep);
    sfcut = (strpos2(ds, STR7, 1) == 1);
    take_double = (strpos2(ds, "BOXCUT", 1) == 1);

    if (!fast_machine)
      boxbusy("new mail");

    dsize = sfsize(dname);
    k = sfopen(dname, FO_READ);
    if (k >= minhandle) {
      bct = sfread(k, blocksize, puffer);
      sfclose(&k);
      *status = '\0';
      *betreff = '\0';
      imperr = false;
      lesezeiger = 0;
      do {
	get_line(puffer, &lesezeiger, bct, status);
      } while (*status == '\0' && lesezeiger < bct);

      if (strpos2(status, dpreadoutmagic, 1) == 1) {
	get_word(status, zeile);
	get_word(status, rcall);
	cut(rcall, 6);
	*status = '\0';
	do {
	  get_line(puffer, &lesezeiger, bct, status);
	} while (*status == '\0' && lesezeiger < bct);
      }
      *bulletin_id = '\0';
      del_lastblanks(status);
      if (count_words(status) == 1 && callsign(status)) {
	cuttyp = RAW_IMPORT;
	strcpy(frombox, status);
	upper(frombox);
      } else if (sfcut)
	cuttyp = W0RLI_SF;
      else
	cuttyp = boxheader(status);


      if (((1L << ((long)cuttyp)) & ((1L << ((long)W0RLI_USER)) |
	     (1L << ((long)AA4RE_USER)) | (1L << ((long)F6FBB_USER)) |
	     (1L << ((long)F6FBB_USER_314)) | (1L << ((long)RAW_IMPORT)))) != 0) {
	hlz = lesezeiger;
	get_line(puffer, &lesezeiger, bct, z1);
	get_line(puffer, &lesezeiger, bct, z2);
	get_line(puffer, &lesezeiger, bct, z3);
	get_line(puffer, &lesezeiger, bct, z4);
	if (((1L << ((long)cuttyp)) & ((1L << ((long)F6FBB_USER_314)) |
				       (1L << ((long)RAW_IMPORT)))) != 0) {
	  get_line(puffer, &lesezeiger, bct, z5);
	  get_line(puffer, &lesezeiger, bct, z6);
	} else {
	  *z5 = '\0';
	  *z6 = '\0';
	}
	del_lastblanks(z1);
	del_lastblanks(z2);
	del_lastblanks(z3);
	del_lastblanks(z4);
	del_lastblanks(z5);
	del_lastblanks(z6);
	transform_boxheader(cuttyp, status, z1, z2, z3, z4, z5, z6);
	if (*status != '\0') {
	  err = lesezeiger - strlen(z1) - strlen(z2) - 2;
	  if (err >= hlz) {
	    lesezeiger = err;
	    put_line(puffer, &err, z1);
	    put_line(puffer, &err, z2);
	    cuttyp = THEBOX_USER;
	  } else {
	    imperr = true;
	    if (cuttyp == RAW_IMPORT)
	      debug(0, unr, 28,
		    "header conversion failed, import file deleted");
	  }
	} else
	  imperr = true;

      }

      if (!imperr) {
	if (((1L << ((long)cuttyp)) &
	     ((1L << ((long)THEBOX_USER)) | (1L << ((long)WAMPES_USER)) |
	      (1L << ((long)W0RLI_SF)) | (1L << ((long)NOP)))) != 0 ||
	    origin || sfcut) {
	  if (cuttyp == W0RLI_SF)
	    get_word(status, zeile);
	  get_line(puffer, &lesezeiger, bct, betreff);
	  if (cuttyp == WAMPES_USER)
	    strdelete((void *)betreff, 1, 9);
	  hlz = lesezeiger;
	  get_line(puffer, &hlz, bct, zeile);
	  if (!sfcut) {
	    if (cuttyp == WAMPES_USER) {
	      if (count_words(zeile) == 3) {
		get_word(zeile, ds);
		get_word(zeile, ds);
		if (!strcmp(ds, "ID:")) {
		  get_word(zeile, bulletin_id);
		  lesezeiger = hlz;
		}
	      }
	    } else {
	      if (count_words(zeile) == 4) {
		get_word(zeile, ds);
		get_word(zeile, ds);
		if (strpos2(ds, "ID", 1) > 0) {
		  get_word(zeile, bulletin_id);
		  lesezeiger = hlz;
		}
	      }
	      get_line(puffer, &hlz, bct, zeile);
	      if (strpos2(zeile, "*** Received from", 1) == 1)
		lesezeiger = hlz;
	    }
	  }
	} else if (cuttyp == BAYCOM_USER) {
	  get_line(puffer, &lesezeiger, bct, zeile);
	  if (strpos2(zeile, "BID :", 1) == 1) {
	    strdelete((void *)zeile, 1, 6);
	    get_word(zeile, bulletin_id);
	    get_line(puffer, &lesezeiger, bct, zeile);
	  }
	  while (strpos2(zeile, "Read:", 1) == 1)
	    get_line(puffer, &lesezeiger, bct, zeile);
	  if (strpos2(zeile, "Subj:", 1) == 1) {
	    strcpy(betreff, zeile);
	    strdelete((void *)betreff, 1, 6);
	  }
	}


	if (sfcut)
	  split_sline(status, ziel, absender, mbx, bulletin_id, lifetime,
		      zeile);
	else
	  separate_status(status, ziel, absender, mbx, datum, zeit, laenge,
			  lifetime);

	cut(betreff, 80);
	if (*betreff != '\0') {
	  if (*bulletin_id == '\0' && !sfcut)
	    create_userid(ziel, absender, datum, zeit, betreff, bulletin_id);

	  /* Wenn schonmal eingelesen, dann das alte File loeschen */
	  /* wenn es nicht aus dem SF kam                          */

	  if (take_double)
	    take_double = erase_by_bid(true, bulletin_id, Console_call);
	  else
	    take_double = check_double(bulletin_id);

	  if (take_double) {
	    hlz = dsize;

	    if (!sfcut) {
	      do {
		err = lesezeiger;
		get_line(puffer, &lesezeiger, bct, zeile);
		    /* Leerzeilen am Anfang ueberlesen */
		if (*zeile != '\0')
		  lesezeiger = err;
	      } while (*zeile == '\0' && lesezeiger < bct);
	    }

	    if (had_no_bid) {
	      mycall_in_rlines = false;
	      strcpy(z2, " @:");
	      strcat(z2, ownhiername);
	      strcat(z2, " ");
	      err = lesezeiger;
	      do {
		get_line(puffer, &err, bct, zeile);
		oka = (strpos2(zeile, "R:", 1) == 1);
		if (oka) {
		  if (strpos2(zeile, z2, 1) > 0)
		    mycall_in_rlines = true;
		  k = strpos2(zeile, " $:", 1);
		}
		okb = (oka && k > 1);
		if (okb) {
		  strdelete((void *)zeile, 1, k + 2);
		  get_word(zeile, z1);
		  if ((unsigned long)strlen(z1) < 32 &&
		      ((1L << strlen(z1)) & 0x1ffe) != 0) {

		    if (!check_double(z1)) { /*schon bekannt?*/
		      if (!mycall_in_rlines) {
		        do {
		          get_line(puffer, &err, bct, zeile);
			  oka = (strpos2(zeile, "R:", 1) == 1);
			  if (oka) {
		  	    if (strpos2(zeile, z2, 1) > 0)
		    	      mycall_in_rlines = true;
		          }
		        } while (err < bct && oka && !mycall_in_rlines);
		      }
		      take_double = mycall_in_rlines; /* passiert bei loops */
		    } else {
		      strcpy(bulletin_id, z1);
		    }
		  } else
		    okb = false;
		}
	      } while (err < bct && oka && !okb);
	    }

	    if (take_double)   /* Laenge */
	      new_entry(unr, dname, status, betreff, bulletin_id, hlz,
			lesezeiger, rcall, frombox, origin, sfcut,
			authentisch, broadcast);
	    else
	      boxprotokoll("double (recovered message ID)...");
	    /* Vorspann */


	  } else
	    boxprotokoll("double...");


	} else
	  debug(0, unr, 28, "corrupted header (no subject)...");
	

      } else
	debug(0, unr, 28, "corrupted header...");

    }
    if (!fast_machine)
      boxendbusy();
    sfdelfile(dname);
    sprintf(STR13, "%c", allquant);
    if (strpos2(pattern, STR13, 1) == 0)
      Result = false;
  }
  boxsetamouse();
  dpfreemem(&puffer, blocksize);
  return Result;
}

#undef blocksize


void sort_new_mail4(void)
{
  long ticks;
  newmailtype *hp;

  ticks = statclock();
  while (newmailroot != NULL && statclock() - ticks < ttask * 2) {
    if (!sort_new_mail3(newmailroot->unr, newmailroot->pattern,
			newmailroot->rcall)) {
      hp = newmailroot;
      newmailroot = newmailroot->next;
      Free(hp);
    }
  }
}


void sort_new_mail2(short unr, Char *pattern, Char *rcall1)
{
  newmailtype *newp, *hp;

  if (unr >= 0) debug(0, -1, 28, "error: unr >= 0");

  /* vorsicht bei unr = -99 (= diebox-import) */
  /* unr = -55 -> immediate, z.B. fuer boxcut */

  if (unr == -99) {
    while (sort_new_mail3(unr, pattern, rcall1)) ;
    return;
  }
  if (unr == -55) {
    while (sort_new_mail3(-1, pattern, rcall1)) ;
    return;
  }
  newp = Malloc(sizeof(newmailtype));

  if (newp == NULL) {
    while (sort_new_mail3(unr, pattern, rcall1)) ;
    return;
  }
  newp->next = NULL;
  newp->unr = unr;
  strcpy(newp->pattern, pattern);
  strcpy(newp->rcall, rcall1);
  if (newmailroot == NULL) {
    newmailroot = newp;
    return;
  }
  hp = newmailroot;
  while (hp->next != NULL)
    hp = hp->next;
  hp->next = newp;
}


void _box_file_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  msgnumsem = false;
  remote_erase = true;
  with_rline = true;
  maxbullids = 0;
  shall_sem = 0;
  cnb_sem = false;
  mfilter_sem = 0;
  ufcr = 0;
  ufchit = 0;
  ufcmiss = 0;
  lastxreroute = 0;
}
