/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_serv.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/

#include "defs.h"

#define BOX_SERV_G
#include "box_serv.h"


#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef BOXGLOBL_H
#include "boxglobl.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif


Static unsigned short serv_sem, redserv_sem;


Static boolean valid_servername(Char *n_)
{
  Char n[256];
  
  if ((unsigned long)strlen(n_) >= 32 || ((1L << strlen(n_)) & 0x7e) == 0)
    return false;
  strcpy(n,n_);
  check_verteiler(n);
  if (callsign(n) || !defined_board(n))
    return true;
  return false;
}


Static void strip_call(Char *c1_, Char *c2, Char *c)
{
  Char c1[256];
  short k;

  strcpy(c1, c1_);
  if (c1[0] == '!') {
    *c = '!';
    strdelete((void *)c1, 1, 1);
  } else
    *c = '\0';
  cut(c1, 6);
  k = strpos2(c1, "@", 1);
  if (k > 0)
    cut(c1, k - 1);
  del_lastblanks(c1);
  strcpy(c2, c1);
}


boolean in_servers(Char *board)
{
  Char s[256];

  sprintf(s, "%s%s%cSRV", serverdir, board, extsep);
  return (exist(s));
}


Static short in_abonnees(Char *sender, Char *board)
{
  short ifl;
  boolean ok, sflag;
  Char c;
  Char hs[256], c1[256];
  Char STR1[256];

  ok = false;
  sflag = false;
  if (in_servers(board)) {
    sprintf(STR1, "%s%s%cSRV", serverdir, board, extsep);
    ifl = sfopen(STR1, FO_READ);
    while (file_to_string(ifl, hs) && !ok) {
      strip_call(hs, c1, &c);
      sflag = (c == '!');
      ok = (strcmp(c1, sender) == 0);
    }
    sfclose(&ifl);
  }
  if (ok) {
    if (sflag)
      return 2;
    else
      return 1;
  } else
    return 0;
}


#define blocksize       16384


boolean do_server(Char *sender_, Char *board_, Char *betreff_, Char *tname_,
		  long offset)
{
  boolean Result;
  Char sender[256];
  Char board[256], betreff[256], tname[256];

  short ifl, ifs, ifc, k, x, y, unr, kanal, k2;
  uchar *tb;
  long tbs, rp, lrp, lrp2;
  boolean ok;
  long cntmsg;
  Char c;
  Char svname[256];
  Char sublist[256];
  Char svcnt[256];
  Char svsysop[256];
  Char hs[256], name[256];
  Char tobbs[256];
  Char w[256], nname[256];
  Char betreff1[256];
  Char STR7[256];

  strcpy(sender, sender_);
  strcpy(board, board_);
  strcpy(betreff, betreff_);
  strcpy(tname, tname_);
  serv_sem++;
  Result = false;
  if (exist(tname)) {
    if (callsign(sender)) {
      if (in_abonnees(sender, board) > 0) {
	unr = melde_user_an(sender, 0, 0, UM_SYSREQ, false);
	if (boxrange(unr)) {
	  strcpy(betreff1, betreff);
	  kanal = sfopen(tname, FO_READ);
	  if (kanal >= minhandle) {
	    sfseek(offset, kanal, SFSEEKSET);
	    tb = Malloc(blocksize);
	    if (tb != NULL) {
	      tbs = sfread(kanal, blocksize, tb);
	      sfclose(&kanal);
	      rp = 0;
	      lrp = 0;
	      lrp2 = 0;
	      ok = true;
	      while (rp + 10 < tbs && ok) {
		get_line(tb, &rp, tbs, hs);
		if (strpos2(hs, "R:", 1) != 1)
		  ok = false;
		else {
		  lrp2 = lrp;
		  lrp = rp;
		}
	      }
	      offset += lrp2;
	    } else
	      sfclose(&kanal);
	    sprintf(w, "%ld", serv_sem);
	    sprintf(nname, "%s249WS%s%cSRV", tempdir, w, extsep);
	    filecut_nodel(tname, nname, offset, 0);

	    sprintf(sublist, "%s247WW%s%cSUB", tempdir, w, extsep);
	    sprintf(svname, "%s%s%cSRV", serverdir, board, extsep);
	    sprintf(svcnt, "%s%s%cCNT", serverdir, board, extsep);
	    *svsysop = '\0';
	    if (exist(svcnt)) {
	      ifc = sfopen(svcnt, FO_READ);
	      file_to_string(ifc, w);
	      sfclose(&ifc);
	      cntmsg = str2lint(w);
	    } else
	      cntmsg = 0;
	    cntmsg++;
	    ifc = sfcreate(svcnt, FC_FILE);
	    sprintf(w, "%ld", cntmsg);
	    string_to_file(&ifc, w, true);
	    sfclose(&ifc);

	    sprintf(STR7, "(%s ", board);
	    x = strpos2(betreff1, STR7, 1);
	    if (x > 0) {
	      y = strpos2(betreff1, ") ", 1);
	      if (y > x)
		strdelete((void *)betreff1, x, y - x + 2);
	    }
	    sprintf(betreff1, "(%s %s) %s", board, w, strcpy(STR7, betreff1));

	    ifl = sfopen(svname, FO_READ);
	    ifs = sfcreate(sublist, FC_FILE);
	    *hs = '\0';
	    while (file_to_string(ifl, w)) {
	      strip_call(w, name, &c);
	      if (c == '!') {
		if (*svsysop == '\0')
		  strcpy(svsysop, name);
		else if (strlen(svsysop) < 70)
		  sprintf(svsysop + strlen(svsysop), " %s", name);
	      }
	      if (*hs == '\0')
		strcpy(hs, name);
	      else if (strlen(hs) < 70)
		sprintf(hs + strlen(hs), " %s", name);
	      else {
		string_to_file(&ifs, hs, true);
		strcpy(hs, name);
	      }
	    }
	    if (*hs != '\0')
	      string_to_file(&ifs, hs, true);
	    sfclose(&ifl);
	    sfclose(&ifs);

	    ifl = sfopen(svname, FO_READ);
	    if (ifl >= minhandle) {
	      while (file_to_string(ifl, hs)) {
		dp_watchdog(2, 4711);   /* Watchdog resetten         */

		if (*hs == '\0')
		  continue;
		strip_call(hs, name, &c);
		k = strpos2(hs, "@", 1);
		if (k > 0)
		  strdelete((void *)hs, 1, k);
		else
		  *hs = '\0';
		del_leadblanks(hs);
		strcpy(tobbs, hs);
		if (*tobbs != '\0')
		  sprintf(tobbs, " @ %s", strcpy(STR7, tobbs));

		sprintf(w, " < %s %s", sender, betreff1);
		sprintf(hs, "%s%s %s", name, tobbs, w);

		user[unr]->input2[0] = '\0';
		send_check(unr, hs, false, '\0');
		if (user[unr]->sendchan < minhandle) {
		  boxprotokoll("file error (server)");
		  continue;
		}


		Result = true;
		kanal = sfopen(nname, FO_READ);
		if (kanal >= minhandle) {
		  sprintf(STR7,
			  "Mail processed by dpbox mailing list server %s@%s",
			  board, ownhiername);
		  send_text3(unr, false, STR7, true);
		  send_text3(unr, false, "  ", true);
		  send_text3(unr, false, "Subscriber list:", true);
		  k2 = sfopen(sublist, FO_READ);
		  if (k2 >= minhandle)
		    send_file1(unr, &k2, false, 1);
		  send_text3(unr, false, "  ", true);
		  sprintf(STR7, "For server redistribution reply to %s@%s",
			  board, ownhiername);
		  send_text3(unr, false, STR7, true);
		  if (*svsysop != '\0') {
		    sprintf(STR7, "Server is maintained by %s", svsysop);
		    send_text3(unr, false, STR7, true);
		  }
		  send_text3(unr, false, "  ", true);
		  send_text3(unr, false,
		    "-----------------------------------------------------------------------------",
		    true);
		  send_file1(unr, &kanal, false, 1);
		} else
		  send_text3(unr, false, "*** read error", true);
		send_text3(unr, false, "***END", true);
	      }

	      sfclose(&ifl);
	    }
	    sfdelfile(nname);
	    sfdelfile(sublist);
	  }
	}
	melde_user_ab(unr, false);
      }

    }
  }
  serv_sem--;
  return Result;
}

#undef blocksize


Static void list_abonnees(short unr, Char *sname, Char *call_)
{
  Char call[256];
  short ifl;
  Char svname[256];
  Char hs[256], w[256], w0[256];
  Char STR7[256];

  strcpy(call, call_);
  serv_sem++;
  if (in_servers(sname)) {
    sprintf(svname, "%s%s%cSRV", serverdir, sname, extsep);
    w_btext(unr, 115);
    sprintf(STR7, " %s:", sname);
    wlnuser(unr, STR7);
    ifl = sfopen(svname, FO_READ);
    *w0 = '\0';
    if (*call != '\0' && call[strlen(call) - 1] != '*')
      strcat(call, "*");
    while (file_to_string(ifl, hs)) {
      upper(hs);
      if (*call == '\0') {
	wlnuser(unr, hs);
	continue;
      }
      strcpy(w, hs);
      if (w[0] == '!')
	strdelete((void *)w, 1, 1);
      if (wildcardcompare(SHORT_MAX, call, w, w0))
	wlnuser(unr, hs);
    }
    sfclose(&ifl);
  } else
    wln_btext(unr, 45);
  serv_sem--;
}


Static void add_abonnee(short unr, Char *sname, Char *call)
{
  short ifl, ofl;
  Char c;
  Char svname[256];
  Char ovname[256];
  Char hs[256], c1[256], c2[256];
  Char STR1[256], STR7[256];

  serv_sem++;
  sprintf(svname, "%s%s%cSRV", serverdir, sname, extsep);
  strip_call(call, c1, &c);
  if (callsign(c1)) {
    if (!in_servers(sname)) {
      w_btext(unr, 116);
      sprintf(STR1, " %s", sname);
      wlnuser(unr, STR1);
      w_btext(unr, 117);
      sprintf(STR7, " %s ", c1);
      wlnuser(unr, STR7);
      w_btext(unr, 118);
      chwuser(unr, 32);
      wlnuser(unr, sname);
      ofl = sfcreate(svname, FC_FILE);
      if (ofl >= minhandle) {
	string_to_file(&ofl, call, true);
	sfclose(&ofl);
      } else
	wln_btext(unr, 119);
    } else {
      sprintf(ovname, "%s%s%cSRX", serverdir, sname, extsep);
      w_btext(unr, 117);
      sprintf(STR1, " %s ", c1);
      wlnuser(unr, STR1);
      w_btext(unr, 118);
      chwuser(unr, 32);
      wlnuser(unr, sname);
      ifl = sfopen(svname, FO_READ);
      ofl = sfcreate(ovname, FC_FILE);
      while (file_to_string(ifl, hs)) {
	strip_call(hs, c2, &c);
	if (strcmp(c1, c2))
	  string_to_file(&ofl, hs, true);
      }
      string_to_file(&ofl, call, true);
      sfclose(&ifl);
      sfclose(&ofl);
      sfdelfile(svname);
      sfrename(ovname, svname);
      sort_file(svname);
    }
  }
  serv_sem--;
}


Static void sub_abonnee(short unr, Char *sname, Char *call)
{
  short ifl, ofl, ct;
  Char c;
  Char svname[256];
  Char ovname[256];
  Char hs[256];
  Char c1[256], c2[256];
  Char STR7[256];

  serv_sem++;
  if (in_servers(sname)) {
    sprintf(svname, "%s%s%cSRV", serverdir, sname, extsep);
    sprintf(ovname, "%s%s%cSRX", serverdir, sname, extsep);
    strip_call(call, c1, &c);
    if (callsign(c1)) {
      w_btext(unr, 120);
      sprintf(STR7, " %s ", c1);
      wlnuser(unr, STR7);
      w_btext(unr, 118);
      chwuser(unr, 32);
      wlnuser(unr, sname);
      ct = 0;
      ifl = sfopen(svname, FO_READ);
      ofl = sfcreate(ovname, FC_FILE);
      while (file_to_string(ifl, hs)) {
	strip_call(hs, c2, &c);
	if (strcmp(c1, c2)) {
	  string_to_file(&ofl, hs, true);
	  ct++;
	} else
	  wlnuser(unr, "OK");
      }
      sfclose(&ifl);
      sfclose(&ofl);
      sfdelfile(svname);
      if (ct == 0) {
	sfdelfile(ovname);
	new_ext(ovname, "CNT");
	sfdelfile(ovname);
	w_btext(unr, 121);
	chwuser(unr, 32);
	wlnuser(unr, sname);
      }
      sfrename(ovname, svname);
    }
  } else
    wln_btext(unr, 45);
  serv_sem--;
}


boolean config_server(short unr, Char *eingabe_)
{
  boolean Result;
  Char eingabe[256];
  DTA dirinfo;
  short result, k;
  Char sname[256];
  Char w[256], w1[256];
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  Result = false;
  if (!boxrange(unr))
    return Result;
  if (*eingabe != '\0') {
    get_word(eingabe, sname);
    upper(sname);
    if (!valid_servername(sname))
      return Result;
    if (!(user[unr]->supervisor || in_abonnees(user[unr]->call, sname) == 2))
      return Result;
    get_word(eingabe, w);
    get_word(eingabe, w1);
    upper(w1);
    if (strlen(w) != 1)
      return Result;
    Result = true;
    switch (w[0]) {

    case '+':
      add_abonnee(unr, sname, w1);
      break;

    case '-':
      sub_abonnee(unr, sname, w1);
      break;

    case '=':
      list_abonnees(unr, sname, w1);
      break;

    default:
      Result = false;
      break;
    }
    return Result;
  }


  if (!user[unr]->supervisor)
    return Result;
  Result = true;
  wln_btext(unr, 122);
  wlnuser0(unr);
  wlnuser(unr, "Name   Count");
  wlnuser(unr, "------------");
  sprintf(STR1, "%s%c%cSRV", serverdir, allquant, extsep);
  result = sffirst(STR1, 0, &dirinfo);   /* alle normalen Files suchen */
  while (result == 0) {
    strcpy(w, dirinfo.d_fname);
    del_ext(w);
    sprintf(STR1, "%s%s%cCNT", serverdir, w, extsep);
    k = sfopen(STR1, FO_READ);
    rspacing(w, 8);
    wuser(unr, w);
    strcpy(w, "0");
    if (k >= minhandle) {
      file_to_string(k, w);
      sfclose(&k);
    }
    lspacing(w, 4);
    wlnuser(unr, w);
    result = sfnext(&dirinfo);
  }
  wlnuser(unr, "------------");
  return Result;
}


#define blocksize       16384


/* ------------------------------------------------------------------------------------------ */

/* der REDIST - Server...                        */
/* SP LOCBBS, SP LOCAL, S REGION, S NATION       */
/* Wenn in der Titelzeile zu Beginn ein # steht, */
/* ist das angefuegte Wort als Rubrikangabe      */
/* zu interpretieren, ansonsten gehts an ALL     */
/* Der Absender bekommt eine Bestaetigung        */
/* Die Absender-R:-Line wird an die neue Mail    */
/* angehaengt                                    */

boolean do_redist(Char *absender, Char *dest, Char *betreff_, Char *tname,
		  long offset)
{
  boolean Result;
  Char betreff[256];

  short k, h, x;
  long seekp;
  Char hs[256], newb[256], newmbx[256];
  Char lastr[256], sendbbs[256];
  Char STR7[256];

  strcpy(betreff, betreff_);
  redserv_sem++;
  Result = false;
  if (exist(tname)) {
    if (callsign(absender)) {
      *newmbx = '\0';
      if (!strcmp(dest, "LOCBBS"))
	strcpy(newmbx, Console_call);
      else if (!strcmp(dest, "LOCAL"))
	strcpy(newmbx, redlocal);
      else if (!strcmp(dest, "REGION"))
	strcpy(newmbx, redregion);
      else if (!strcmp(dest, "NATION"))
	strcpy(newmbx, rednation);

      if (*newmbx != '\0') {
	strcpy(newb, "ALL");
	if (*reddefboard != '\0')
	  strcpy(newb, reddefboard);
	if (betreff[0] == '#') {
	  get_word(betreff, hs);
	  strdelete((void *)hs, 1, 1);
	  cut(hs, 8);
	  upper(hs);
	  if (valid_boardname(hs) && !callsign(hs))
	    strcpy(newb, hs);
	}

	if (*betreff == '\0')
	  strcpy(betreff, "REDIST MSG");

	sprintf(hs, "%simport%c001", newmaildir, extsep);
	validate(hs);
	k = sfcreate(hs, FC_FILE);
	if (k >= minhandle) {
	  string_to_file(&k, Console_call, true);   /* frombox */
	  string_to_file(&k, absender, true);   /* absender */
	  string_to_file(&k, newb, true);   /* an */
	  string_to_file(&k, newmbx, true);   /* mbx */
	  if (redlifetime >= 0)
	    sprintf(hs, "%ld", redlifetime);
	  else
	    strcpy(hs, "30");
	  rspacing(hs, 30);
	  string_to_file(&k, hs, true);   /* lt */
	  strcpy(hs, "                   ");
	  string_to_file(&k, hs, true);   /* BID */
	  string_to_file(&k, betreff, true);   /* subject */

	  h = sfopen(tname, FO_READ);
	  if (h >= minhandle) {
	    Result = true;
	    seekp = sfseek(offset, h, SFSEEKCUR);
	    *lastr = '\0';
	    *sendbbs = '\0';
	    while (file_to_string(h, hs) && strpos2(hs, "R:", 1) == 1) {
	      strcpy(lastr, hs);
	      seekp = sfseek(0, h, SFSEEKCUR);
	    }

	    sfclose(&h);

	    x = strpos2(lastr, "]", 1);
	    if (x > 0)
	      cut(lastr, x + 1);
	    x = strpos2(lastr, "$:", 1);
		/* sollte eigentlich nicht vorkommen */
	    if (x > 0)
	      cut(lastr, x - 1);

	    x = strpos2(lastr, "@", 1);
	    if (x > 0) {
	      strsub(sendbbs, lastr, x + 1, 7);
	      if (sendbbs[0] == ':')
		strdelete((void *)sendbbs, 1, 1);
	      unhpath(sendbbs, sendbbs);
	      if (!callsign(sendbbs))
		*sendbbs = '\0';
	    }

	    string_to_file(&k, lastr, true);

	    app_file2(tname, k, seekp, false);

	    sfclose(&k);

	    strcpy(hs, absender);
	    if (*sendbbs != '\0')
	      sprintf(hs + strlen(hs), "@%s", sendbbs);
	    sprintf(hs + strlen(hs), " used redist server %s (%s@%s)",
		    dest, newb, newmbx);
	    append_profile(-6, hs);

	    if (*sendbbs != '\0') {
	      sprintf(hs, "%simport%c001", newmaildir, extsep);
	      validate(hs);
	      k = sfcreate(hs, FC_FILE);
	      if (k >= minhandle) {
		string_to_file(&k, Console_call, true);   /* frombox */
		string_to_file(&k, Console_call, true);   /* absender */
		string_to_file(&k, absender, true);   /* an */
		string_to_file(&k, sendbbs, true);   /* mbx */
		*hs = '\0';
		rspacing(hs, 30);
		string_to_file(&k, hs, true);   /* lt */
		strcpy(hs, "                   ");
		string_to_file(&k, hs, true);   /* BID */
		strcpy(hs, "ACK:REDIST server acknowledged");
		string_to_file(&k, hs, true);   /* subject */
		sprintf(hs, "Mail delivered to %s@%s", newb, newmbx);
		string_to_file(&k, hs, true);
		sfclose(&k);
	      }

	    }

	    sprintf(STR7, "%simport%c%c", newmaildir, extsep, allquant);
	    sort_new_mail(-1, STR7, Console_call);

	  } else
	    sfclosedel(&k);


	}

      }
    }

  }
  redserv_sem--;
  return Result;
}

#undef blocksize





void _box_serv_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  serv_sem = 0;
  redserv_sem = 0;

}



/* End. */
