/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_sf.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_SF_G
#include "box_sf.h"


#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef CRC_H
#include "crc.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOXBCAST_H
#include "boxbcast.h"
#endif


Static boolean gen_sftest3(short unr, Char *frombox, Char *board, Char *mbx);


/* Loescht die verketteten Pointer der Resume-Liste   */

void del_resume_list(void)
{
  resumemem *hr, *hl;

  hr = resume_root;
  while (hr != NULL) {
    hl = hr->next;
    Free(hr);
    hr = hl;
  }
  resume_root = NULL;
}


/* Laedt die Resume-List von Disk ins RAM    */

void load_resume(void)
{
  short k;
  resumemem *hr, *hl;
  short ct, x;

  del_resume_list();
  ct = sfsize(resume_inf) / sizeof(resumemem);
  if (ct <= 0)
    return;
  k = sfopen(resume_inf, FO_READ);
  if (k < minhandle)
    return;
  hl = NULL;
  for (x = 1; x <= ct; x++) {
    hr = Malloc(sizeof(resumemem));
    if (hr != NULL) {
      sfread(k, sizeof(resumemem), (uchar *)hr);
      hr->next = hl;
      hl = hr;
    }
  }
  sfclose(&k);
  resume_root = hr;
}


/* Schreibt die im Speicher gehaltene Resume-Liste auf Disk  */

Static void write_resume(void)
{
  short k;
  resumemem *hr;

  if (resume_root == NULL) {
    sfdelfile(resume_inf);
    return;
  }
  k = sfcreate(resume_inf, FC_FILE);
  if (k < minhandle)
    return;
  hr = resume_root;
  while (hr != NULL) {
    sfwrite(k, sizeof(resumemem), (uchar *)hr);
    hr = hr->next;
  }
  sfclose(&k);
}


/* Loescht File und Eintrag in resume-liste identifiziert durch bid und call  */

Static void del_resume(Char *bid, Char *call)
{
  resumemem *hr, *hl;
  Char STR1[256];

  hr = resume_root;
  hl = hr;
  while (hr != NULL) {
    if (strcmp(hr->rbid, bid)) {
      hl = hr;
      hr = hr->next;
      continue;
    }
    if (strcmp(hr->rcall, call)) {
      hl = hr;
      hr = hr->next;
      continue;
    }
    sprintf(STR1, "%s%s", boxstatdir, hr->rfname);
    sfdelfile(STR1);
    if (hl == hr)
      resume_root = hr->next;
    else
      hl->next = hr->next;
    Free(hr);
    hr = NULL;
    write_resume();   /* Liste aktualisiert auf Disk schreiben */
  }
}


/* loescht nach Ablauf der Lifetime die Resume-Files  */
/* wird aus Garbage aufgerufen                        */

void kill_resume(void)
{
  resumemem *hr, *hl;
  Char STR1[256];

  debug0(1, 0, 69);
  hr = resume_root;
  hl = hr;
  while (hr != NULL) {
    if (clock_.ixtime - hr->rdate <= resume_lifetime * 86400L &&
	clock_.ixtime >= hr->rdate) {
      hl = hr;
      hr = hr->next;
      continue;
    }

    sprintf(STR1, "%s%s", boxstatdir, hr->rfname);
    sfdelfile(STR1);
    if (hl == hr) {
      resume_root = hr->next;
      hl = resume_root;
    } else
      hl->next = hr->next;
    Free(hr);
    if (hl != NULL)
      hr = hl->next;
    else
      hr = NULL;
  }

  write_resume();   /* Liste aktualisiert auf Disk schreiben */
}


/* sucht in der resume-file-liste nach einem Eintrag mit derselben BID       */
/* gesendet von demselben Call. Wenn gefunden, dann werden Filename und      */
/* Offset zurueckgeliefert. Sollte da was inkonsistent sein (File geloescht  */
/* oder andere Laenge) werden Eintrag und File geloescht.                    */

Static long check_resume(Char *bid, Char *call, Char *fname)
{
  long Result;
  resumemem *hr;
  Char STR1[256];

  debug(3, 0, 70, call);
  fname[0] = '\0';
  Result = 0;
  hr = resume_root;

  while (hr != NULL) {
    if (strcmp(hr->rbid, bid)) {
      hr = hr->next;
      continue;
    }
    if (strcmp(hr->rcall, call)) {
      hr = hr->next;
      continue;
    }
    sprintf(STR1, "%s%s", boxstatdir, hr->rfname);
    if (sfsize(STR1) == hr->rsize) {
      Result = hr->rsize;
      strcpy(fname, hr->rfname);
      hr = NULL;
      debug(3, 0, 70, "fragment found");
    } else {
      debug(3, 0, 70, "unmatching size");
      del_resume(bid, call);
      hr = NULL;
    }
  }

  return Result;
}


boolean in_sfp(Char *call)
{
  if ((unsigned long)strlen(call) < 32 && ((1L << strlen(call)) & 0x78) != 0)
    return (find_sf_pointer(call) != NULL);
  else
    return false;
}


short bbs_pack(short unr)
{
  userstruct *WITH;

  if (!boxrange(unr))
    return 0;
  WITH = user[unr];
  if (!((strchr(WITH->SID, 'F') != NULL || strchr(WITH->SID, 'D') != NULL) &&
	strchr(WITH->SID, 'B') != NULL && WITH->sf_level > 3 && packed_sf))
    return 0;
  if (strpos2(WITH->SID, "B1", 1) > 0) { 
    if (strchr(WITH->SID, 'D') != NULL) {
      if (strpos2(WITH->SID, "D1", 1) > 0)
	return 5;   /* + CRC im Block        */
      else
	return 4;   /* HBS' neuer BIN-Modus  */
    } else
      return 3;     /* FBBs neuer BIN-Modus  */
  } else {
    if (strchr(WITH->SID, 'D') != NULL)
      return 2;     /* HBS' alter BIN-Modus  */
    else
      return 1;     /* FBBs alter BIN-Modus  */
  }
  return 0;
}


Static void chwuser1(short unr, uchar ch, unsigned short *chksum)
{
  *chksum = (*chksum + ch) & 0xff;
  chwuser(unr, ch);
}


Static void boxmemspool1(short unr, short tcon, short pchan, short prn,
  boolean strip_lf, boolean add_bcrc, uchar *puffer, long blen,
  unsigned short *chksum, unsigned short *bcrc)
{
  checksum8_buf(puffer, blen, chksum);
  if (!add_bcrc) {
    boxmemspool(tcon, pchan, prn, strip_lf, puffer, blen);
    return;
  }
  crcfbb_buf(puffer, blen, bcrc);
  boxmemspool(tcon, pchan, prn, strip_lf, puffer, blen);
  chwuser(unr, (*bcrc) & 0xff);
  chwuser(unr, ((*bcrc) >> 8) & 0xff);
}


/* 'Send packed fbb' ! IN RAM !*/

void send_pfbbram(short mode, short unr, uchar *puffer, long size,
		  long offset, Char *betreff)
{
  uchar b1, b2;
  short x;
  long blen;
  unsigned short sf_crc, bcrc, sf_chksum;
  Char hs[256];
  long ct;
  boolean blockcrc;
  short FORLIM;
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  debug(2, unr, 71, betreff);
  b1 = 0;
  b2 = 0;
  sf_crc = 0;

  if (mode < 3)
    offset = 0;
  else if (offset < 10)
    offset = 0;
  blockcrc = (mode == 5);

  sprintf(hs, "%ld", offset);
  lspacing(hs, 6);

  chwuser(unr, 1);
  chwuser(unr, strlen(betreff) + strlen(hs) + 2);
  wuser(unr, betreff);
  chwuser(unr, 0);
  wuser(unr, hs);
  chwuser(unr, 0);

  if (offset > 1)
    offset -= 2;


  switch (mode) {

  case 3:
  case 4:
  case 5:  /* FBB 2 */
    if ((unsigned)mode < 32 && ((1L << mode) & 0x30) != 0) {   /* HBS neu */
      FORLIM = strlen(betreff);
      /* HBS berechnet die CRC auch ueber den Titel */
      for (x = 0; x < FORLIM; x++)
	crcfbb(betreff[x], &sf_crc);
    }

    crcfbb_buf(puffer, size, &sf_crc);

    b1 = sf_crc & 0xff;
    b2 = (sf_crc >> 8) & 0xff;

    break;

  case 2:  /* HBS */
    FORLIM = strlen(betreff);
    for (x = 0; x < FORLIM; x++)
      crcthp(betreff[x], &sf_crc);
    crcthp(0, &sf_crc);
    FORLIM = strlen(hs);
    for (x = 0; x < FORLIM; x++)
      crcthp(hs[x], &sf_crc);
    crcthp(0, &sf_crc);

    crcthp_buf(puffer, size, &sf_crc);

    b1 = sf_crc & 0xff;
    b2 = (sf_crc >> 8) & 0xff;
    break;
  }

  ct = offset;
  sf_chksum = 0;

  while (ct < size) {
    /* Nach Moeglichkeit blen auf max. 250 lassen ! Nebeneffekte  */
    /* siehe weiter unten                                         */

    if (size - ct > 250)
      blen = 250;
    else
      blen = size - ct;

    bcrc = 0;
    chwuser(unr, 2);

    if (ct == offset && (unsigned)mode < 32 && ((1L << mode) & 0x38) != 0) {
      /* erster Datenblock, bei FBB 2  */
      /* CRC einfuegen                 */

      /* Achtung: Das funktioniert SO nur, wenn blen 3..255 ist, also      */
      /* VORSICHT bei Modifikation des Sources !   Nicht auf 0 setzen!     */

      if (offset == 0) {
	if (blen > 248) {
	  chwuser(unr, blen & 0xff);
	  blen -= 2;
	} else
	  chwuser(unr, (blen + 2) & 0xff);

	chwuser1(unr, b1, &sf_chksum);   /* CRC Byte 1    */
	chwuser1(unr, b2, &sf_chksum);   /* CRC Byte 2    */

	if (blockcrc) {
	  crcfbb(b1, &bcrc);   /* BlockCRC auch updaten */
	  crcfbb(b2, &bcrc);
	}

      } else {
	chwuser(unr, 6);
	chwuser1(unr, b1, &sf_chksum);   /* CRC Byte 1    */
	chwuser1(unr, b2, &sf_chksum);   /* CRC Byte 2    */

	chwuser1(unr, puffer[0], &sf_chksum);   /* Originallaenge */
	chwuser1(unr, puffer[1], &sf_chksum);
	chwuser1(unr, puffer[2], &sf_chksum);
	chwuser1(unr, puffer[3], &sf_chksum);

	if (blockcrc) {  /* BlockCRC erzeugen und anhaengen   */
	  crcfbb(b1, &bcrc);   /* CRC Byte 1    */
	  crcfbb(b2, &bcrc);   /* CRC Byte 2    */

	  crcfbb(puffer[0], &bcrc);   /* Originallaenge */
	  crcfbb(puffer[1], &bcrc);
	  crcfbb(puffer[2], &bcrc);
	  crcfbb(puffer[3], &bcrc);

	  chwuser(unr, bcrc & 0xff);
	  chwuser(unr, (bcrc >> 8) & 0xff);

	  bcrc = 0;
	}

	chwuser(unr, 2);
	chwuser(unr, blen & 0xff);
      }


      /* FBB fuegt einen ganzen YAPP - Block ein, wenn der Offset > 0 ist   */


    } else
      chwuser(unr, blen & 0xff);


    WITH = user[unr];

    boxmemspool1(unr, WITH->tcon, WITH->pchan, boxprn2bios(WITH->print),
		 false, blockcrc, (uchar *)(&puffer[ct]), blen, &sf_chksum,
		 &bcrc);
    upd_statistik(unr, 0, blen, 0, 0);
    ct += blen;

  }


  chwuser(unr, 4);

  if (mode == 2) {   /* HBS */
    chwuser(unr, b1);
    chwuser(unr, b2);
  } else {
    sf_chksum = (-sf_chksum) & 0xff;
    chwuser(unr, sf_chksum);
  }

}


/* 'Send packed fbb' ON DISK */

void send_pfbbdisk(short mode, short unr, long offset, Char *tempname,
		   Char *betreff)
{
  uchar b1, b2;
  short x;
  long blen;
  unsigned short sf_crc, bcrc, sf_chksum;
  Char hs[256];
  long size, ct;
  short fhandle;
  boolean blockcrc;
  uchar firstfour[4];
  uchar pufferarr[256];
  uchar *puffer;
  short FORLIM;
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  debug(2, unr, 72, tempname);

  puffer = pufferarr;
  sf_crc = 0;

  if (mode < 3)
    offset = 0;
  else if (offset < 10)
    offset = 0;
  blockcrc = (mode == 5);

  sprintf(hs, "%ld", offset);
  lspacing(hs, 6);

  chwuser(unr, 1);
  chwuser(unr, strlen(betreff) + strlen(hs) + 2);
  wuser(unr, betreff);
  chwuser(unr, 0);
  wuser(unr, hs);
  chwuser(unr, 0);

  if (offset > 1)
    offset -= 2;

  fhandle = sfopen(tempname, FO_READ);

  if (fhandle < minhandle)
    return;

  /* Die ersten vier Bytes... */

  sfread(fhandle, 4, firstfour);
  sfclose(&fhandle);


  switch (mode) {

  case 3:
  case 4:
  case 5:  /* FBB 2 */
    if ((unsigned)mode < 32 && ((1L << mode) & 0x30) != 0) {   /* HBS neu */
      FORLIM = strlen(betreff);
      /* HBS berechnet die CRC auch ber den Titel */
      for (x = 0; x < FORLIM; x++)
	crcfbb(betreff[x], &sf_crc);
    }

    for (x = 0; x <= 3; x++)
      crcfbb(firstfour[x], &sf_crc);
    file_crc(3, tempname, sf_crc, 4, 0);

    b1 = sf_crc & 0xff;
    b2 = (sf_crc >> 8) & 0xff;

    break;

  case 2:  /* HBS */
    FORLIM = strlen(betreff);
    for (x = 0; x < FORLIM; x++)
      crcthp(betreff[x], &sf_crc);
    crcthp(0, &sf_crc);
    FORLIM = strlen(hs);
    for (x = 0; x < FORLIM; x++)
      crcthp(hs[x], &sf_crc);
    crcthp(0, &sf_crc);

    for (x = 0; x <= 3; x++)
      crcfbb(firstfour[x], &sf_crc);
    file_crc(2, tempname, sf_crc, 4, 0);

    b1 = sf_crc & 0xff;
    b2 = (sf_crc >> 8) & 0xff;
    break;
  }


  size = sfsize(tempname);
  ct = offset;
  sf_chksum = 0;
  fhandle = sfopen(tempname, FO_READ);

  if (fhandle < minhandle)
    return;

  sfseek(offset, fhandle, SFSEEKSET);

  while (ct < size) {
    /* Nach Moeglichkeit blen auf max. 250 lassen ! Nebeneffekte  */
    /* siehe weiter unten                                         */

    if (size - ct > 250)
      blen = 250;
    else
      blen = size - ct;

    chwuser(unr, 2);
    bcrc = 0;

    if (ct == offset && (unsigned)mode < 32 && ((1L << mode) & 0x38) != 0) {
      /* erster Datenblock, bei FBB 2  */
      /* CRC einfuegen                 */

      /* Achtung: Das funktioniert SO nur, wenn blen 3..255 ist, also      */
      /* VORSICHT bei Modifikation des Sources !   Nicht auf 0 setzen!     */

      if (offset == 0) {
	chwuser(unr, blen & 0xff);
	chwuser1(unr, b1, &sf_chksum);   /* CRC Byte 1    */
	chwuser1(unr, b2, &sf_chksum);   /* CRC Byte 2    */

	chwuser1(unr, firstfour[0], &sf_chksum);
	chwuser1(unr, firstfour[1], &sf_chksum);
	chwuser1(unr, firstfour[2], &sf_chksum);
	chwuser1(unr, firstfour[3], &sf_chksum);

	if (blockcrc) {
	  crcfbb(b1, &bcrc);   /* BlockCRC auch updaten */
	  crcfbb(b2, &bcrc);

	  crcfbb(firstfour[0], &bcrc);
	  crcfbb(firstfour[1], &bcrc);
	  crcfbb(firstfour[2], &bcrc);
	  crcfbb(firstfour[3], &bcrc);
	}

	blen -= 6;
	ct += 4;
      } else {
	chwuser(unr, 6);
	chwuser1(unr, b1, &sf_chksum);   /* CRC Byte 1    */
	chwuser1(unr, b2, &sf_chksum);   /* CRC Byte 2    */

	chwuser1(unr, firstfour[0], &sf_chksum);
	chwuser1(unr, firstfour[1], &sf_chksum);
	chwuser1(unr, firstfour[2], &sf_chksum);
	chwuser1(unr, firstfour[3], &sf_chksum);

	if (blockcrc) {
	  crcfbb(b1, &bcrc);   /* BlockCRC auch updaten */
	  crcfbb(b2, &bcrc);

	  crcfbb(firstfour[0], &bcrc);
	  crcfbb(firstfour[1], &bcrc);
	  crcfbb(firstfour[2], &bcrc);
	  crcfbb(firstfour[3], &bcrc);

	  chwuser(unr, bcrc & 0xff);
	  chwuser(unr, (bcrc >> 8) & 0xff);

	  bcrc = 0;
	}

	chwuser(unr, 2);
	chwuser(unr, blen & 0xff);
      }

      /* FBB fuegt einen ganzen YAPP - Block ein, wenn der Offset > 0 ist   */


    } else
      chwuser(unr, blen & 0xff);


    blen = sfread(fhandle, blen, puffer);
    if (blen <= 0)
      goto _L1;

    WITH = user[unr];

    boxmemspool1(unr, WITH->tcon, WITH->pchan, boxprn2bios(WITH->print),
		 false, blockcrc, puffer, blen, &sf_chksum, &bcrc);
    upd_statistik(unr, 0, blen, 0, 0);
    ct += blen;
  }


_L1:
  sfclose(&fhandle);

  chwuser(unr, 4);

  if (mode == 2) {   /* HBS */
    chwuser(unr, b1);
    chwuser(unr, b2);
  } else {
    sf_chksum = (-sf_chksum) & 0xff;
    chwuser(unr, sf_chksum);
  }


}


boolean resend_userfile(boolean redirect, Char *brett, Char *newmbx)
{
  Char index[256];
  indexstruct header;
  short k, list, lv;
  boolean has_mails;
  Char umbx[41];
  Char hs[256];

  debug(2, 0, 73, brett);
  
  has_mails = false;
  
  if (!strcmp(brett, Console_call))
    return false;
  unhpath(newmbx, umbx);
  if (strpos2(newmbx, ".", 1) == 0)
    complete_hierarchical_adress(newmbx);

  sprintf(index, "%s%s%c%s", indexdir, brett, extsep, idx_e);

  lv = sfsize(index) / sizeof(indexstruct);
  if (lv <= 0)
    return false;


  list = sfopen(index, FO_RW);
  if (list >= minhandle) {
    copy_eralog(true);
    for (k = 1; k <= lv; k++) {
      read_index(list, k, &header);
      if (!header.deleted && check_hcs(header)) {
	if ( strcmp(header.verbreitung, newmbx)
	    || (clock_.ixtime - header.rxdate > 5 * 86400) ) {
	  if ((header.msgflags & (MSG_SFRX | MSG_MINE)) != 0 && header.fwdct == 0) {
	      has_mails = true;
	    if (redirect) {
	      if (header.msgflags & MSG_OWNHOLD == 0) {
	        new_bid(header.id);   /* wie immer, wenn wir userfiles */
	                              /* redirecten wollen             */
	        strcpy(header.verbreitung, newmbx);
	        write_index(list, k, &header);
	        sfclose(&list);
	        write_msgid(-1, header.id);
	        alter_log(true, header.msgnum, header.msgflags, '$', header.id);
	        alter_log(true, header.msgnum, header.msgflags, '@', newmbx);
	        *hs = '\0';
	        if (strcmp(umbx, Console_call))
	          set_forward(-1, -1, brett, hs, k, k, "FORWARD", hs, hs);
	        list = sfopen(index, FO_RW);
	      }
	    } else { /* zukuenftige MyBBS-Spielereien unterbinden */
	      header.msgflags |= MSG_OWNHOLD;
	      write_index(list, k, &header);
	      alter_log(true, header.msgnum, header.msgflags, '!', "");
	    }
	  }
	}
      }
    }
    copy_eralog(false);
  }

  sfclose(&list);
  
  return has_mails;
}


Static boolean not_while_connected(Char *absender, long date)
{
  short y;

  for (y = 1; y <= maxuser; y++) {
    if (user[y] != NULL) {
      if (!user[y]->f_bbs) {
	if (!user[y]->console) {
	  if (!strcmp(user[y]->call, absender))
	    return (clock_.ixtime - date > 300);   /* nach 5 Minuten */
	}
      }
    }
  }
  return true;
}


Static boolean not_multiprivprop(short unr, Char *bid)
{
  short z, y;

  for (y = 1; y <= maxuser; y++) {
    if (user[y] != NULL) {
      if (user[y]->f_bbs) {
	if (strcmp(user[y]->call, user[unr]->call)) {
	  for (z = 0; z < maxfbbprops; z++) {
	    if (!strcmp(user[y]->fbbprop[z].bid, bid))
	      return false;
	  }
	}
      }
    }
  }
  return true;
}


Static boolean not_in_prop_list(short unr, short x, Char *bid)
{
  short z, y;

  for (y = 1; y <= maxuser; y++) {
    if (user[y] != NULL) {
      if (user[y]->f_bbs) {
	if (!strcmp(user[y]->call, user[unr]->call)) {
	  for (z = 0; z < maxfbbprops; z++) {
	    if (user[y]->fbbprop[z].x_nr == x)
	      return false;
	    if (!strcmp(user[y]->fbbprop[z].bid, bid))
	      return false;
	  }
	}
      }
    }
  }
  return true;
}


Static boolean not_double_same_sender(Char *absender, Char *lastsender,
				      boolean *dflag)
{
  if (strcmp(absender, lastsender)) {
    strcpy(lastsender, absender);
    return true;
  }
  *dflag = true;
  return false;
}


Static void binmsg(short unr, short *list, Char *tocall, Char *tombx,
		   Char *absender)
{
  Char hs[256];
  short k;
  Char STR7[92];

  if (tocall[0] == Console_call[0] || absender[0] == Console_call[0]) {
    sprintf(hs, "%simport%c001", newmaildir, extsep);
    validate(hs);
    k = sfcreate(hs, FC_FILE);
    if (k >= minhandle) {
      if (tocall[0] == Console_call[0]) {
	string_to_file(&k, Console_call, true);
	string_to_file(&k, Console_call, true);
	string_to_file(&k, tocall, true);
	string_to_file(&k, tombx, true);
	strcpy(hs, "14");   /* Lifetime */
	rspacing(hs, 60);
	string_to_file(&k, hs, true);
	*hs = '\0';   /* BID */
	string_to_file(&k, hs, true);
	sprintf(hs, "Undeliverable mail from %s at %s",
		absender, Console_call);
	string_to_file(&k, hs, true);
	*hs = '\0';
	string_to_file(&k, hs, true);
	sprintf(hs, "binary file for %s at %s, please read out and delete!",
		tocall, Console_call);
	string_to_file(&k, hs, true);
      } else if (absender[0] == Console_call[0]) {
	string_to_file(&k, Console_call, true);
	string_to_file(&k, Console_call, true);
	string_to_file(&k, absender, true);
	string_to_file(&k, Console_call, true);
	strcpy(hs, "14");   /* Lifetime */
	rspacing(hs, 60);
	string_to_file(&k, hs, true);
	*hs = '\0';   /* BID */
	string_to_file(&k, hs, true);
	sprintf(hs, "Undeliverable mail at %s", Console_call);
	string_to_file(&k, hs, true);
	*hs = '\0';
	string_to_file(&k, hs, true);
	sprintf(hs, "binary file for %s at %s, can't forward.",
		tocall, Console_call);
	string_to_file(&k, hs, true);
	sprintf(hs, "no binary forward with %s", user[unr]->call);
	string_to_file(&k, hs, true);
      }

    }

    sfclose(&k);
  }


  sprintf(STR7, "bin-mail held for %s@%s via %s (14 days)",
	  tocall, tombx, user[unr]->call);
  append_profile(-1, STR7);
}


Static void setbinlt(indexstruct *hpointer, Char *rubrik)
{
  Char fname[256];
  short rl, ct, lv;
  indexstruct rp;

  if ((hpointer->pmode & 4) != 0)
    return;
  sprintf(fname, "%s%s%c%s", indexdir, rubrik, extsep, idx_e);
  lv = sfsize(fname) / sizeof(indexstruct);
  rl = sfopen(fname, FO_RW);
  ct = lv + 1;

  if (rl < minhandle)
    return;
  while (ct > 1) {
    ct--;
    read_index(rl, ct, &rp);
    if (!strcmp(rp.id, hpointer->id) && check_hcs(rp)) {
      if (rp.lifetime > 14) {
	rp.lifetime = 14;
	write_index(rl, ct, &rp);
      }
    }
  }
  sfclose(&rl);
}


Static boolean conv_to_7plus(short unr, Char *board, Char *bid)
{
  boolean Result;
  short lv2, x, y, k;
  long pid;
  indexstruct header;
  Char fname[256], w[256], w1[256], hs1[256];
  Char ofi[256], sd[256], ld[256], hs[256];
  Char hsendbbs[256];
  Char STR1[256];
  Char STR7[94];

  Result = false;
  if (*spluspath == '\0')
    return Result;

  lv2 = search_by_bid(board, bid, false);
  if (lv2 < 1)
    return Result;

  sprintf(fname, "%stmp7pl%c001", tempdir, extsep);
  validate(fname);
  export_brett(unr, board, lv2, lv2, "", "", fname);
  if (!exist(fname))
    return Result;

  sprintf(STR1, "%s%s%c%s", indexdir, board, extsep, idx_e);
  k = sfopen(STR1, FO_RW);
  if (k < minhandle)
    return Result;

  read_index(k, lv2, &header);
  header.deleted = true;
  header.eraseby = EB_BIN27PLUS;
  header.erasetime = clock_.ixtime;
  alter_log(false, header.msgnum, header.msgflags, 'E', "");
  write_index(k, lv2, &header);
  sfclose(&k);

  sprintf(STR7, "bin>7plus: converting mail from %s to %s@%s",
	  header.absender, header.dest, header.verbreitung);
  append_profile(-1, STR7);
  dp_watchdog(2, 4711);

  Result = true;
  /*   pid := fork; */
  pid = -1;
      /* denn eigentlich ist es unsinn, hier mit mehreren instanzen zu arbeiten */
  if (pid > 0) {
    add_zombie(pid);
    return Result;
  }
  /*       setsid; */

  strcpy(sd, fname);
  get_path(sd);
  sprintf(w, "%s -k -y -q -#", fname);
  sfgetdir(0, ld);
  sfchdir(sd);
  call_prg(spluspath, w, "");
  sfchdir(ld);

  sfdelfile(fname);

  sprintf(ofi, "%s7plus.out", sd);
  sfdelfile(ofi);

  sprintf(ofi, "%s7plus.fls", sd);
  k = sfopen(ofi, FO_READ);
  if (k < minhandle) {
    if (pid == 0)
      exit(1);
    else
      return Result;
  }

  *ld = '\0';
  file_to_string(k, ld);
  sfclosedel(&k);

  if (*ld == '\0') {
    if (pid == 0)
      exit(1);
    else
      return Result;
  }

  get_word(ld, w);   /* anzahl    */
  get_word(ld, w1);   /* name      */
  y = Str2int(w);

  if (y == 0) {
    if (pid == 0)
      exit(1);
    else
      return Result;
  }

  strcpy(ofi, fname);
  del_path(ofi);

  strcpy(hsendbbs, header.sendbbs);
  complete_hierarchical_adress(hsendbbs);

  for (x = 1; x <= y; x++) {
    if (y == 1)
      strcpy(w, "7pl");
    else {
      int2hstr(x, w);
      lower(w);
      while (strlen(w) < 2)
	sprintf(w, "0%s", strcpy(STR1, w));
      sprintf(w, "p%s", strcpy(STR1, w));
    }
    sprintf(fname, "%s%s%c%s", sd, w1, extsep, w);

    sprintf(hs, "%simport%c001", newmaildir, extsep);
    validate(hs);
    k = sfcreate(hs, FC_FILE);
    if (k >= minhandle) {
      if (*header.rxfrom == '\0')
	string_to_file(&k, Console_call, true);
      else
	string_to_file(&k, header.rxfrom, true);
      string_to_file(&k, header.absender, true);
      string_to_file(&k, header.dest, true);
      string_to_file(&k, header.verbreitung, true);
      sprintf(hs, "%ld", header.txlifetime);
      rspacing(hs, 80);
      string_to_file(&k, hs, true);
      *hs = '\0';   /* BID */
      string_to_file(&k, hs, true);
      sprintf(hs, "%s%c%s", w1, extsep, w);
      upper(hs);
      sprintf(hs, "bin>7plus: %s (%s) %s",
	      strcpy(STR1, hs), ofi, header.betreff);
      cut(hs, 79);
      string_to_file(&k, hs, true);
      /* Start der Message */
      if (strcmp(header.sendbbs, Console_call)) {
	ixdatum2string(header.txdate, hs);
	sprintf(hs1, "%c%c%c%c%c%c/",
		hs[6], hs[7], hs[3], hs[4], hs[0], hs[1]);
	ixzeit2string(header.txdate, hs);
	sprintf(hs1 + strlen(hs1), "%c%c%c%cz", hs[0], hs[1], hs[3], hs[4]);
	sprintf(hs, "R:%s @:", hs1);
	strcat(hs, hsendbbs);
	string_to_file(&k, hs, true);
	*hs = '\0';
	string_to_file(&k, hs, true);
	sprintf(hs, "Original message from %s@%s", header.absender, hsendbbs);
	string_to_file(&k, hs, true);
      } else {
	*hs = '\0';
	string_to_file(&k, hs, true);
      }
      string_to_file(&k, "Converted from full binary format to 7plus", true);
      sprintf(hs, "at %s %s",
	      ownhiername, ownfheader);
      string_to_file(&k, hs, true);
      sprintf(hs, "Send error reports to %s@%s, NOT TO %s !",
	      header.absender, hsendbbs, Console_call);
      string_to_file(&k, hs, true);
      *hs = '\0';
      string_to_file(&k, hs, true);
      app_file2(fname, k, 0, true);
      sfclose(&k);
    }

  }

  sprintf(hs, "%simport%c001", newmaildir, extsep);
  validate(hs);
  k = sfcreate(hs, FC_FILE);
  if (k >= minhandle) {
    string_to_file(&k, Console_call, true);
    string_to_file(&k, Console_call, true);
    string_to_file(&k, header.absender, true);
    string_to_file(&k, hsendbbs, true);
    sprintf(hs, "%ld", header.txlifetime);
    rspacing(hs, 60);
    string_to_file(&k, hs, true);
    *hs = '\0';   /* BID */
    string_to_file(&k, hs, true);
    sprintf(hs, "bin>7plus: converted your mail to %s (%s) %s",
	    header.dest, ofi, header.betreff);
    cut(hs, 79);
    string_to_file(&k, hs, true);
    *hs = '\0';
    string_to_file(&k, hs, true);
    strcpy(hs, "Converted your mail from full binary format to 7plus at");
    string_to_file(&k, hs, true);
    sprintf(hs, "%s %s", ownhiername, ownfheader);
    string_to_file(&k, hs, true);
    sprintf(hs, "Wait for error reports of %s@%s",
	    header.dest, header.verbreitung);
    string_to_file(&k, hs, true);
    *hs = '\0';
    string_to_file(&k, hs, true);
    strcpy(hs,
      "To respond a returning error report, put it in the same directory as");
    string_to_file(&k, hs, true);
    strcpy(hs,
      "the original file and start 7plus with the error report as option.");
    string_to_file(&k, hs, true);
    strcpy(hs, "7plus returns a .COR file, send it to");
    string_to_file(&k, hs, true);
    sprintf(hs, "%s@%s", header.dest, header.verbreitung);
    string_to_file(&k, hs, true);
    *hs = '\0';
    string_to_file(&k, hs, true);
    sprintf(hs, "73 from %s %s", ownhiername, ownfheader);
    string_to_file(&k, hs, true);
    *hs = '\0';
    string_to_file(&k, hs, true);
    sfclose(&k);
  }

  if (pid == 0)
    exit(0);
  return Result;


}


Static boolean valid_entry(indexstruct hpointer, Char *rubrik,
			   boolean spec_sf, long maxu, long maxb,
			   boolean send_pack, short *ct, Char *origrub)
{
  Char fname[256];
  short rlist, lv2;
  uchar *ipuffer;
  long isize;
  indexstruct header1, *rpointer;
  boolean valid;

  valid = false;

  if ((hpointer.pmode & 4) != 0) {
    valid = true;
    return valid;
  }
  sprintf(fname, "%s%s%c%s", indexdir, rubrik, extsep, idx_e);
  isize = 0;
  if (valid_in_ram)
    sfbread(false, fname, &ipuffer, &isize);
  if (isize <= 0) {
    lv2 = sfsize(fname) / sizeof(indexstruct);
    rlist = sfopen(fname, FO_READ);
  } else {
    rlist = nohandle;
    lv2 = isize / sizeof(indexstruct);
  }
  *ct = lv2 + 1;
  if (rlist >= minhandle || isize > 0) {
    header1.deleted = false;
    rpointer = &header1;   /*bleibt gleich wenn isize <= 0*/

    while (*ct > 1 && !valid) {
      (*ct)--;
      if (isize <= 0)
	read_index(rlist, *ct, &header1);
      else
	rpointer = (indexstruct *)(&ipuffer[(*ct - 1) * sizeof(indexstruct)]);
      if (check_hcs(*rpointer) &&
	  (hpointer.msgnum == 0 || hpointer.msgnum == rpointer->msgnum) &&
	  !strcmp(rpointer->id, hpointer.id))
	valid = true;
    }

    sfclose(&rlist);

    if (rpointer->deleted)
      valid = false;
    if (valid)
      valid = (!strcmp(hpointer.verbreitung, rpointer->verbreitung) ||
	       spec_sf);
    if (valid) {
      if (rpointer->msgtype != 'B')
	valid = (rpointer->size <= maxu ||
		 rpointer->packsize <= maxu && send_pack);
      else
	valid = (rpointer->size <= maxb ||
		 rpointer->packsize <= maxb && send_pack);
    }

    if (valid)
      strcpy(origrub, rpointer->dest);
  }

  if (isize > 0)
    mymfreep(&ipuffer);
  return valid;
}


/* local consts/types fuer propose_sf_sending */

#define msg_nil         0
#define msg_conscall    1
#define msg_user        2
#define msg_bulletin    3
#define msg_system      4
#define msg_system2     5
#define maxsyscount     50

typedef struct proprectype {
  boolean filled, is_sys, specsf;
  indexstruct pheader;
  short x_nr, r_nr;
  Char porigrubrik[9], pmyrubrik[9];
} proprectype;

typedef proprectype parrtyp[msg_system - msg_nil + 1][maxfbbprops];
typedef short pcttyp[msg_system - msg_nil + 1];
typedef Char lastsendertyp[msg_system - msg_nil + 1][7];


Static short smaller_than_in_props(boolean is_system, indexstruct *hpointer,
  boolean send_pack, short msg_type, proprectype (*pa)[maxfbbprops],
  short *pct)
{
  short a, b;
  long sizea, sizeb, sizec;
  short FORLIM;

  sizec = 0;
  b = -1;

  if (send_pack) {
    if (is_system)
      sizeb = 3000;
    else
      sizeb = hpointer->packsize;
  } else {
    if (is_system)
      sizeb = maxsyscount * 80;
    else
      sizeb = hpointer->size;
  }

  FORLIM = pct[msg_type - msg_nil];
  for (a = 1; a <= FORLIM; a++) {
    if (send_pack && pa[msg_type - msg_nil][a - 1].pheader.packsize > 0) {
      if (pa[msg_type - msg_nil][a - 1].is_sys)
	sizea = 3000;
      else
	sizea = pa[msg_type - msg_nil][a - 1].pheader.packsize;
    } else {
      if (pa[msg_type - msg_nil][a - 1].is_sys)
	sizea = maxsyscount * 80;
      else
	sizea = pa[msg_type - msg_nil][a - 1].pheader.size;
    }

    if (sizeb < sizea) {
      if (sizea > sizec) {
	b = a;
	sizec = sizea;
      }
    }
  }


  return b;

}


Static void sort_pa(short maxprop, short msg_type,
		    proprectype (*pa)[maxfbbprops])
{
  short a, b, c, d, loopc;
  long s1, s2;
  proprectype p1;

  for (d = 1; d <= 2; d++) {
    loopc = 0;
    b = maxprop;
    do {
      loopc++;
      a = b;
      b--;
      while (a > 2 && !pa[msg_type - msg_nil][a - 1].filled)
	a--;
      if (a > 1 && pa[msg_type - msg_nil][a - 1].filled) {
	if (pa[msg_type - msg_nil][a - 1].is_sys)
	  s1 = 3000;
	else {
	  s1 = pa[msg_type - msg_nil][a - 1].pheader.packsize;
	  if (s1 == 0)
	    s1 = pa[msg_type - msg_nil][a - 1].pheader.size;
	}
	c = a;
	while (c > 1 && pa[msg_type - msg_nil][c - 2].filled) {
	  c--;
	  if (pa[msg_type - msg_nil][c - 1].is_sys)
	    s2 = 3000;
	  else {
	    s2 = pa[msg_type - msg_nil][c - 1].pheader.packsize;
	    if (s2 == 0)
	      s2 = pa[msg_type - msg_nil][c - 1].pheader.size;
	  }
	  if (s1 < s2) {
	    p1 = pa[msg_type - msg_nil][c - 1];
	    pa[msg_type - msg_nil][c - 1] = pa[msg_type - msg_nil][a - 1];
	    pa[msg_type - msg_nil][a - 1] = p1;
	    c = 0;
	  }
	}
      }
    } while (a != 1 && d != 2 && loopc <= 30);
    if (loopc > 30)
      boxprotokoll("failure in sort_pa()");
  }
}


Static boolean not_in_own_props(short x, Char *bid, short msg_type,
				proprectype (*pa)[maxfbbprops], short *pct)
{
  short a, FORLIM;

  FORLIM = pct[msg_type - msg_nil];
  for (a = 0; a < FORLIM; a++) {
    if (pa[msg_type - msg_nil][a].x_nr == x)
      return false;
    if (!strcmp(pa[msg_type - msg_nil][a].pheader.id, bid))
      return false;
  }
  return true;
}


Static uchar fwtype(uchar pmode, Char *rubrik, Char *absender)
{
  if ((pmode & 1) != 0) {
    if (!strcmp(absender, Console_call))
      return msg_conscall;
    else
      return msg_user;
  } else if ((pmode & 2) != 0) {
    if (!strcmp(rubrik, "F"))
      return msg_conscall;
    else
      return msg_bulletin;
  } else if ((pmode & 4) != 0) {
    return msg_system;

    /* spezielles Flag fuer Systemmails welche im blockweisen Senden stehen */

  } else if ((pmode & 16) != 0) {
    return msg_system2;

  } else
    return msg_nil;
}


/* Dies ist eine der komplexesten Routinen der Box, die Steuerung des    */
/* ausgehenden S&F. Bitte Vorsicht bei kleinen Aenderungen, sie haben    */
/* GROSSE Wirkung...                                                     */

#define LookAheadBufSize 150*sizeof(indexstruct)

Static short propose_sf_sending(short unr)
{
  short Result;

  boolean doublesamesenderflag;
  lastsendertyp lastsender;
  indexstruct *hpointer, header;
  short k, lv, sel, sel2, list, ct, is_what, newlt;
  boolean i_changed, is_ack, send_pack, valid, delete_it, spec_sf, boxbin;
  long selsize;

  short prop, x, y, maxprop;
  long maxb, maxu, maxp;
  boolean loopex, nothing, dpflag, theboxflag, invalid, again,
	  is_system;
  short is_smaller;
  uchar *xpuffer;
  long xsize, CurBufOffs, WantedOffs, TotalSize;

  parrtyp pa;
  pcttyp pct;
  Char msgchar;
  short msg_type;
  unsigned short sct;
  short fct, fsl, fmax, loopct;

  Char hs[256], hs2[256], hb[256];
  Char to_box[256];
  Char w[256];
  Char myrubrik[9], brubrik[9], rubrik[9], fbs[9], origrub[9];
  Char hmbx[41];
  Char xname[256];
  userstruct *WITH;
  Char STR1[256];
  sfdeftype *WITH1;
  fbbproptype *WITH2;
  proprectype *WITH3;

  debug0(2, unr, 74);
  
  recompile_fwd();
  
  Result = 0;

  if (boxrange(unr)) {
    WITH = user[unr];
    WITH->emblockct = 0;
    boxbin = false;
    sprintf(xname, "%sX%c%s", indexdir, extsep, idx_e);
    dpflag = (strchr(WITH->SID, 'D') != NULL);
    theboxflag = (strcmp(WITH->FSID, "THEBOX") == 0); /* wenn ich das auskommentiere, stuerzt diebox ab */

    if (dpflag)
      boxbin = true;
    else if (!strcmp(WITH->FSID, "BAYCOM")) {
      if (WITH->MSID[0] > '1' || WITH->MSID[0] == '1' && WITH->MSID[2] >= '3')
	boxbin = true;
    } /* else if (theboxflag) { */ /* hier macht diebox leider mist, deswegen kein fwd */
/*    if (WITH->MSID[0] > '1' || !strcmp(WITH->MSID, "1.9"))
	boxbin = true;
    } */

    send_pack = (WITH->fwdmode > 0);

    if (WITH->sf_ptr != NULL) {
      WITH1 = WITH->sf_ptr;
      maxb = WITH1->maxbytes_b;
      maxu = WITH1->maxbytes_u;
      maxp = WITH1->maxbytes_p;
    } else {
      maxb = 50000L;
      maxu = 50000L;
      maxp = 50000L;
    }

    Result = 0;
    strcpy(to_box, WITH->call);
    xsize = 0;
    TotalSize = sfsize(xname);
    CurBufOffs = 0;
    xpuffer = NULL;
    if (xcheck_in_ram) {
      xpuffer = mymalloc(LookAheadBufSize);
      if (xpuffer != NULL) {
        CurBufOffs = LONG_MAX;
        xsize = 1;
      }
    }

    lv = TotalSize / sizeof(indexstruct);
 
    i_changed = false;
    is_what = 0;
    selsize = 0;
    sel = 0;

    for (x = 0; x < maxfbbprops; x++) {
      WITH2 = &WITH->fbbprop[x];
      WITH2->line[0] = '\0';
      WITH2->brett[0] = '\0';
      WITH2->nr = 0;
      WITH2->x_nr = 0;
      WITH2->crc = 0;
      WITH2->pack = false;
      WITH2->bid[0] = '\0';
      WITH2->mtype = '\0';
    }

    for (x = msg_nil; x <= msg_system; x++) {
      pct[x - msg_nil] = 0;
      for (y = 0; y < maxfbbprops; y++)
	pa[x - msg_nil][y].filled = false;
    }

    nothing = true;

    if (WITH->sf_level > 2)
      maxprop = 5;
    else
      maxprop = 1;

    if (lv > 0)
      list = sfopen(xname, FO_RW);
    else
      list = nohandle;

    if (list >= minhandle) {
      again = false;

_L4:
      if (again) {
	is_what = 0;
	selsize = 0;
	sel = 0;

	for (x = 0; x < maxfbbprops; x++) {
	  WITH2 = &WITH->fbbprop[x];
	  WITH2->line[0] = '\0';
	  WITH2->brett[0] = '\0';
	  WITH2->nr = 0;
	  WITH2->x_nr = 0;
	  WITH2->crc = 0;
	  WITH2->pack = false;
	  WITH2->bid[0] = '\0';
	  WITH2->mtype = '\0';
	}

	for (x = msg_nil; x <= msg_system; x++) {
	  pct[x - msg_nil] = 0;
	  for (y = 0; y < maxfbbprops; y++)
	    pa[x - msg_nil][y].filled = false;
	}
      } else
	again = true;

      hpointer = &header;   /* bleibt gleich, wenn xsize <= 0 */
      loopct = 0;
      doublesamesenderflag = false;
      do {
        i_changed = true;
	if (doublesamesenderflag)   /* zweiter Schleifendurchlauf */
	  *WITH->lastsfcall = '\0';
	doublesamesenderflag = false;
	for (x = msg_conscall; x <= msg_system; x++) {
	  if (maxprop == 1)
	    strcpy(lastsender[x - msg_nil], WITH->lastsfcall);
	  else
	    lastsender[x - msg_nil][0] = '\0';
	}

	k = 0;

	loopct++;

	do {
	  k++;
	  delete_it = false;

	  if (xpuffer == NULL)
	    read_index(list, k, &header);
	  else {
	    WantedOffs = (k - 1) * sizeof(indexstruct);
	    if (i_changed || WantedOffs < CurBufOffs || WantedOffs >= CurBufOffs + xsize) {
	      i_changed = false;
	      xsize = 0;
	      CurBufOffs = sfseek(WantedOffs, list, SFSEEKSET);
	      if (CurBufOffs == WantedOffs)
	        xsize = sfread(list, LookAheadBufSize, xpuffer);
	      else
	        xsize = 0; /* kann gefaehrlich sein */
	    }
	    hpointer = (indexstruct *)(&xpuffer[WantedOffs - CurBufOffs]);
	  }
	  if (!hpointer->deleted) {
	    if (!strcmp(hpointer->dest, to_box) && check_hcs(*hpointer) &&
		(hpointer->pmode & 128) == 0) /* laterflag */
	    {
	      msg_type = fwtype(hpointer->pmode, hpointer->dest,
				hpointer->absender);

	      is_smaller = -1;
	      is_system = (msg_type == msg_system);
	      if (is_system)
		msg_type = msg_bulletin;

	      if (small_first) {
		if (msg_type != msg_system2) {
		  if (pct[msg_type - msg_nil] >= maxprop)
		    is_smaller = smaller_than_in_props(is_system, hpointer,
			send_pack, msg_type, pa, pct);

		}
	      }

	      if (msg_type != msg_system2 &&
		  (pct[msg_type - msg_nil] < maxprop || is_smaller > 0) &&
		  ((hpointer->msgflags & (MSG_LOCALHOLD | MSG_SFHOLD)) == 0 ||
		   clock_.ixtime - hpointer->rxdate > holddelay) &&
		  not_in_own_props(k, hpointer->id, msg_type, pa, pct) &&
		  not_in_prop_list(unr, k, hpointer->id) &&
		  (is_system ||
		   not_double_same_sender(
					  hpointer->absender,
					  lastsender[msg_type - msg_nil],
					  &doublesamesenderflag)) &&
		  not_while_connected(hpointer->absender, hpointer->rxdate)) {
		if ((hpointer->pmode & 1) == 0 || multiprivate ||
		    not_multiprivprop(unr, hpointer->id))
		    /* ist kein PrivateFile */
		    {  /* doch, aber noch nicht in Aussendung */
		  spec_sf = ((hpointer->pmode & 8) != 0);
		  strcpy(hs, hpointer->betreff);
		  get_word(hs, rubrik);
		  hs[0] = '\0';

		  if ((hpointer->pmode & TBIN) != 0)
		  {  /* nur bei THEBOX1.9/DP Binfiles senden  */
		    /* und auch bei baycombox > 1.30         */
		    if (boxbin)
		      valid = true;
		    else {
		      if (callsign(rubrik)) {
			if (!conv_to_7plus(unr, rubrik, hpointer->id)) {
			  binmsg(unr, &list, rubrik, hpointer->verbreitung,
				 hpointer->absender);
			  setbinlt(hpointer, rubrik);
			}
		      }
		      valid = false;
		      delete_it = true;
		    }
		  } else
		    valid = true;

		  if (valid) {
		    if (msg_type == msg_nil) {
		      debug(0, unr, 74, "invalid pmode in X -> deleted");
		      valid = false;   /* was nie vorkommen sollte */
		      delete_it = true;
		    }
		  }

		  if (valid) {
		    origrub[0] = '\0';

		    if (is_smaller <= 0) {
		      pct[msg_type - msg_nil]++;
		      is_smaller = pct[msg_type - msg_nil];
		    }

		    WITH3 = &pa[msg_type - msg_nil][is_smaller - 1];
		    WITH3->filled = true;
		    WITH3->specsf = spec_sf;
		    WITH3->pheader = *hpointer;
		    WITH3->x_nr = k;
		    WITH3->is_sys = is_system;
		  }


		  if (delete_it) {
		    hpointer->deleted = true;
			/* Loeschen da nicht mehr gueltig */
		    write_index(list, k, hpointer);
		  }

		}
		/* doch, aber soll doppelt gesendet werden */

	      }


	    }

	  }

	} while (k < lv);

      } while (loopct <= maxprop && doublesamesenderflag);

_L1:
      if (small_first && sort_props && maxprop > 1) {
	for (x = msg_conscall; x <= msg_bulletin; x++)   /*msg_system*/
	  sort_pa(maxprop, x, pa);
      }

      prop = 0;
      loopex = false;
      invalid = false;

      while (prop < maxprop && !loopex) {
	sel = 0;
	sel2 = 0;
	is_what = 0;

	for (x = msg_conscall; x <= msg_bulletin; x++) {   /*msg_system*/
	  for (y = 0; y < maxprop; y++) {
	    WITH3 = &pa[x - msg_nil][y];
	    if (WITH3->filled) {
	      WITH3->filled = false;

	      valid = true;
	      strcpy(hs, WITH3->pheader.betreff);
	      get_word(hs, rubrik);
	      hs[0] = '\0';
	      if (!WITH3->is_sys)
		valid = valid_entry(WITH3->pheader, rubrik, WITH3->specsf,
				    maxu, maxb, send_pack, &ct, origrub);

	      if (valid) {
		if (WITH3->is_sys) {
		  WITH3->r_nr = 0;
		  sprintf(STR1, "%c", WITH3->pheader.betreff[0]);
		  strcpy(WITH3->porigrubrik, STR1);
		  /*NUR EINBUCHSTABIGE SYSTEMRUBRIKEN*/
		  strcpy(WITH3->pmyrubrik, WITH3->porigrubrik);

		} else {
		  WITH3->r_nr = ct;
		  strcpy(WITH3->porigrubrik, origrub);
		  strcpy(WITH3->pmyrubrik, rubrik);
		}

		sel = WITH3->x_nr;
		sel2 = WITH3->r_nr;
		header = WITH3->pheader;

		if (x == msg_conscall) {
		  if (!strcmp(WITH3->pmyrubrik, "F"))
			/* 'F' haben wir ja unter      */
			/* msg_conscall bevorrangt. Das*/
			/* muessen wir jetzt aber      */
			/* wieder auf typ=bulletin     */
			/* stellen, sonst kommt die    */
			/* Senderoutine aus dem        */
			/* Tritt                       */
			  is_what = msg_bulletin;
		  else
		    is_what = msg_user;
		} else
		  is_what = x;
		if (WITH3->is_sys)
		  is_what = msg_system;

		strcpy(myrubrik, WITH3->pmyrubrik);
		strcpy(brubrik, WITH3->porigrubrik);
		goto _L2;
	      }

	      invalid = true;
	      WITH3->pheader.deleted = true;
		    /* Loeschen da nicht mehr gueltig */
	      write_index(list, WITH3->x_nr, &WITH3->pheader);
	    }
	  }
	}

_L2:
	if (sel <= 0) {
	  loopex = true;
	  if (invalid && prop == 0) {
	    dp_watchdog(2, 4711);
	    goto _L4;
	  }
	} else {
	  is_ack = (strpos2(WITH->SID, "A", 1) > 0 && header.msgtype == 'A');
	  if (!strcmp(brubrik, "T") && !strcmp(WITH->FSID, "FBB")) {
	    msgchar = 'P';
	    header.size = 80;
	    header.packsize = 80;
	  } else if (WITH->sf_level > 2 && is_what == msg_system) {
	    header.size = 80;
	    header.packsize = 80;
	    msgchar = header.msgtype;
	    if (msgchar == '\0')
	      msgchar = 'B';
	  } else if (header.msgtype != '\0')
	    msgchar = header.msgtype;
	  else {
	    switch (is_what) {

	    case msg_user:
	      msgchar = 'P';
	      break;

	    default:
	      msgchar = 'B';
	      break;
	    }
	  }
	  if (msgchar == 'A' && !is_ack)
	    msgchar = 'P';

	  nothing = false;
	  prop++;
	  strcpy(fbs, brubrik);
	  if (is_what != msg_user)
	    extend_6_to_8(fbs);
	  if (!dpflag && WITH->sf_level != 2)
	    cut(fbs, 6);

	  unhpath(header.verbreitung, hmbx);

	  if (WITH->sf_level > 2) {
	    *WITH->lastsfcall = '\0';

	    switch (WITH->fwdmode) {

	    case 1:
	    case 3:
	      strcpy(hs, "FA");
	      break;

	    case 2:
	    case 4:
	    case 5:
	      strcpy(hs, "FD");
	      break;

	    default:
	      strcpy(hs, "FB");
	      break;
	    }

	    sprintf(hs + strlen(hs), " %c", msgchar);

	    if (strpos2(WITH->SID, "H", 1) > 0)
	      sprintf(hs + strlen(hs), " %s %s %s %s",
		      header.absender, header.verbreitung, fbs, header.id);
	    else
	      sprintf(hs + strlen(hs), " %s %s %s %s",
		      header.absender, hmbx, fbs, header.id);
		      
	    sprintf(hs + strlen(hs), " %ld", header.size);

	    if (is_what != msg_system) {
	      if (WITH->sf_level > 3 && send_pack)
		selsize += header.packsize;
	      else
		selsize += header.size;
	    }

	    if (dpflag && header.txlifetime > 0) {
	      newlt = header.txlifetime - (clock_.ixtime - header.rxdate) / 86400L;
	      if (newlt < 1)
		newlt = 1;
	      sprintf(hs + strlen(hs), " %ld", newlt);
	    }

	    if (is_what == msg_system)
	      sel2 = 0;

	    upper(hs);
	  } else {
	    if (is_what == msg_system && WITH->sf_level == 2) {
	      /* Blockweises E/M - Forwarding */

	      *WITH->lastsfcall = '\0';
	      sct = 0;
	      boxspoolfend(user[unr]->pchan);
	      fmax = boxgetpaclen(user[unr]->pchan);
	      fct = 0;

	      while (sel <= lv && sct < maxsyscount) {
		if (xpuffer == NULL)
		  read_index(list, sel, &header);
		else {
	          WantedOffs = (sel - 1) * sizeof(indexstruct);
	          if (i_changed || WantedOffs < CurBufOffs || WantedOffs >= CurBufOffs + xsize) {
	            i_changed = false;
	            xsize = 0;
	            CurBufOffs = sfseek(WantedOffs, list, SFSEEKSET);
	            if (CurBufOffs == WantedOffs)
	              xsize = sfread(list, LookAheadBufSize, xpuffer);
	            else
		      xsize = 0;
		  }
		  hpointer = (indexstruct *)(&xpuffer[WantedOffs - CurBufOffs]);
		}
		
		if (!hpointer->deleted) {
		  if (!strcmp(hpointer->dest, to_box) && check_hcs(*hpointer)) {
		    if ((hpointer->pmode & 4) != 0) {
		      sct++;
		      strcpy(hb, hpointer->betreff);
		      get_word(hb, hs2);   /* M/E loeschen */
		      sprintf(hs, "S %s @ %s < %s $%s",
			      hs2, hpointer->verbreitung, hpointer->absender,
			      hpointer->id);

		      if (!strcmp(hs2, "M") && theboxflag) {
			get_word(hb, w);
			unhpath(w, w);
		      } else
			get_word(hb, w);

		      sprintf(hs + strlen(hs), " %s", w);
		      if (!strcmp(hs2, "M"))
			get_word(hb, w);
		      else
			*w = '\0';

		      sprintf(hs + strlen(hs), " %s \032", w);
		      fsl = strlen(hs) + 1;

		      if (theboxflag || fct + fsl > fmax) {
			boxspoolfend(user[unr]->pchan);
			fct = 0;
		      }

		      wlnuser(unr, hs);
		      fct += fsl;

		      hpointer->pmode = 16;
		      write_index(list, sel, hpointer);
		    }
		  }
		}
		sel++;
	      }
	      if (sct > 0) {
		WITH->action = 40;
		WITH->emblockct = sct;
		nothing = false;
		goto _L3;
	      } else {
		nothing = true;
		sel = 0;
		goto _L3;
	      }
	    }

	    strcpy(WITH->lastsfcall, header.absender);

	    sprintf(hs, "S%c", msgchar);

	    /*die letzte DieBox schaut in die Userliste...*/
	    if (is_what == msg_user && !strcmp(hmbx, to_box) &&
		WITH->sf_level == 2) {
	      sprintf(hs + strlen(hs), " %s < %s", fbs, header.absender);

	    } else {
	      if (strpos2(WITH->SID, "H", 1) > 0)
		sprintf(hs + strlen(hs), " %s @ %s < %s",
			fbs, header.verbreitung, header.absender);
	      else
		sprintf(hs + strlen(hs), " %s @ %s < %s",
			fbs, hmbx, header.absender);
	    }

	    if ((is_what != msg_user || msgchar == 'B' ||
		 strpos2(user[unr]->SID, "M", 1) > 0 ||
		 !callsign(fbs)) && *header.id != '\0')
	      sprintf(hs + strlen(hs), " $%s", header.id);

	    if (is_what == msg_bulletin && header.txlifetime > 0) {
	      if (WITH->sf_level == 2) {
		newlt = header.txlifetime - (clock_.ixtime - header.rxdate) / 86400L;
		if (newlt < 1)
		  newlt = 1;
		sprintf(w, "%ld", newlt);
		sprintf(hs + strlen(hs), " #%s", w);
	      }
	    }

	    if (is_what == msg_system)
	      sel2 = 0;
	  }

	  strcpy(WITH->fbbprop[prop - 1].line, hs);
	  strcpy(WITH->fbbprop[prop - 1].brett, myrubrik);
	  WITH->fbbprop[prop - 1].nr = sel2;
	  WITH->fbbprop[prop - 1].x_nr = sel;
	  strcpy(WITH->fbbprop[prop - 1].bid, header.id);
	  switch (is_what) {

	  case msg_system:
	    WITH->fbbprop[prop - 1].mtype = 'S';
	    break;

	  case msg_user:
	    WITH->fbbprop[prop - 1].mtype = 'P';
	    break;

	  default:
	    WITH->fbbprop[prop - 1].mtype = 'B';
	    break;
	  }

	}


	if (selsize >= maxp)
	  loopex = true;
	if (nothing)
	  loopex = true;
      }


_L3:
      sfclose(&list);
    }

    if (xpuffer != NULL)
      mymfreep(&xpuffer);

    if (nothing && *WITH->fbbprop[0].line == '\0' &&
	strcmp(WITH->call, Console_call)) {
      sprintf(xname, "%s%s%c%s", indexdir, WITH->call, extsep, idx_e);
      if (exist(xname)) {
	lv = sfsize(xname) / sizeof(indexstruct);
	list = sfopen(xname, FO_RW);
	if (list >= minhandle) {
	  k = 1;
	  prop = 1;
	  selsize = 0;
	  do {
	    read_index(list, k, &header);

	    if (!header.deleted && check_hcs(header) && header.fwdct == 0 &&
		(header.msgflags & MSG_CUT) == 0) {
	      if (header.msgtype != '\0')
		msgchar = header.msgtype;
	      else
		msgchar = 'P';

	      if (msgchar == 'A') {
		if (strpos2(WITH->SID, "A", 1) == 0)
		  msgchar = 'P';
	      }

	      if (WITH->sf_level > 2) {
		switch (WITH->fwdmode) {

		case 1:
		case 3:
		  strcpy(hs, "FA");
		  break;

		case 2:
		case 4:
		case 5:
		  strcpy(hs, "FD");
		  break;

		default:
		  strcpy(hs, "FB");
		  break;
		}

		sprintf(hs + strlen(hs), " %c %s %s %s %s",
			msgchar, header.absender, WITH->call, user[unr]->call,
			header.id);
		sprintf(w, "%ld", header.size);
		sprintf(hs + strlen(hs), " %s", w);
		if (WITH->sf_level > 3 && send_pack)
		  selsize += header.packsize;
		else
		  selsize += header.size;
		if (dpflag && header.txlifetime > 0) {
		  newlt = header.txlifetime -
			  (clock_.ixtime - header.rxdate) / 86400L;
		  if (newlt < 1)
		    newlt = 1;
		  sprintf(w, "%ld", newlt);
		  sprintf(hs + strlen(hs), " %s", w);
		}
		*WITH->lastsfcall = '\0';
	      } else {
		strcpy(WITH->lastsfcall, header.absender);
		sprintf(hs, "S%c %s < %s",
			msgchar, WITH->call, header.absender);
		if ((strpos2(WITH->SID, "M", 1) > 0 || msgchar == 'B') &&
		    *header.id != '\0')
		  sprintf(hs + strlen(hs), " $%s", header.id);
	      }


	      strcpy(WITH->fbbprop[prop - 1].line, hs);
	      strcpy(WITH->fbbprop[prop - 1].brett, user[unr]->call);
	      WITH->fbbprop[prop - 1].nr = k;
	      WITH->fbbprop[prop - 1].x_nr = 0;
	      strcpy(WITH->fbbprop[prop - 1].bid, header.id);
	      WITH->fbbprop[prop - 1].mtype = 'P';
	      prop++;
	      sel = 1;
	      if (msgchar == 'B')
		is_what = msg_bulletin;
	      else
		is_what = msg_user;
	    }

	    k++;
	  } while (k <= lv && prop <= maxprop && selsize < maxp);
	  sfclose(&list);
	}
      }
    }

    if (WITH->sf_level < 3) {
      if (WITH->action != 40) {
	if (sel > 0) {
	  wlnuser(unr, WITH->fbbprop[0].line);
	  switch (is_what) {

	  case msg_system:
	    if (WITH->sf_level == 2)
	      Result = 2;
	    else
	      Result = 1;
	    break;

	  default:
	    Result = 1;
	    break;
	  }
	} else {
	  *WITH->lastsfcall = '\0';
	  Result = 0;
	}
      } else
	Result = 4;
      boxspoolread();
    }
  }

  return Result;

}

#undef LookAheadBufSize


Static uchar *fxpuffer;
Static long fxsize;


Static boolean sf_for(Char *box)
{
  boolean mail;
  indexstruct *hpointer, header;
  short list, k, lv;
  Char xname[256];

  debug(4, 0, 126, box);
  mail = false;

  sprintf(xname, "%sX%c%s", indexdir, extsep, idx_e);
  fxsize = 0;

  if (fxpuffer == NULL) {
    if (check_sffor_in_ram)
      sfbread(false, xname, &fxpuffer, &fxsize);
  }

  if (fxsize <= 0)
    lv = sfsize(xname) / sizeof(indexstruct);
  else
    lv = fxsize / sizeof(indexstruct);

  if (lv <= 0)
    return mail;
  hpointer = &header;   /* bleibt im Zweifelsfall gleich */
  if (fxsize <= 0)
    list = sfopen(xname, FO_READ);
  else
    list = nohandle;

  if (list < minhandle && fxsize <= 0)
    return mail;
  k = 1;
  while (k <= lv && !mail) {
    if (fxsize <= 0)
      read_index(list, k, &header);
    else
      hpointer = (indexstruct *)(&fxpuffer[(k - 1) * sizeof(indexstruct)]);
    if (check_hcs(*hpointer)) {
      mail = (!hpointer->deleted && !strcmp(hpointer->dest, box));
      if (mail)
	mail = ((hpointer->pmode & 128) == 0 &&
		not_while_connected(hpointer->absender, hpointer->rxdate) &&
		((hpointer->msgflags & (MSG_LOCALHOLD | MSG_SFHOLD)) == 0 ||
		 clock_.ixtime - hpointer->rxdate > holddelay));
    }
    k++;
  }
  sfclose(&list);
  return mail;
}


Static void release_sf_for(void)
{
  if (fxpuffer != NULL)
    mymfreep(&fxpuffer);
  fxsize = 0;
}


void change_sfentries(short von, short bis, Char *forcall, Char typ,
		      Char *newcall)
{
  indexstruct header;
  short list, k, lv;
  Char mtyp;
  Char w[256], w1[256];
  Char xname[256];
  boolean delet;

  debug(2, 0, 75, forcall);
  delet = (strcmp(newcall, "NIL") == 0);
  sprintf(xname, "%sX%c%s", indexdir, extsep, idx_e);
  lv = sfsize(xname) / sizeof(indexstruct);
  if (lv <= 0)
    return;
  list = sfopen(xname, FO_RW);
  if (list >= minhandle) {
    k = von;
    if (bis > lv)
      bis = lv;

    while (k <= bis) {
      read_index(list, k, &header);
      if (!check_hcs(header))
	continue;
      strcpy(w, header.betreff);
      get_word(w, w1);

      mtyp = header.msgtype;

      if (strlen(w1) == 1 && (w1[0] == 'M' || w1[0] == 'E'))
	mtyp = 'S';
      else if (mtyp == 'A')
	mtyp = 'P';
      else if (mtyp != 'P')
	mtyp = 'B';

      if (typ == 'A' || typ == mtyp) {
	if (*forcall == '\0' || !strcmp(header.dest, forcall)) {
	  if (delet) {
	    header.deleted = true;
	    x_garbage_waiting = true;
	  } else
	    strcpy(header.dest, newcall);
	  write_index(list, k, &header);
	}
      }

      k++;
    }

  }
  sfclose(&list);
}


Static void routing_error(short unr, Char condition, indexstruct header,
			  Char *board, Char *comment)
{
  Char hs[256], hs2[256], w[256];
  Char ucall[7];
  Char STR7[256];
  userstruct *WITH;

  *hs = '\0';
  if (*header.dest != '\0') {
    if (strcmp(header.dest, board))
      sprintf(hs, "(%s)", header.dest);
  }

  if (boxrange(unr))
    strcpy(ucall, user[unr]->call);
  else
    strcpy(ucall, "SYSTEM");
  sprintf(hs, "%s: %s%s@%s < %s $%s %s",
	  comment, board, strcpy(STR7, hs), header.verbreitung,
	  header.absender, header.id, header.betreff);
  cut(hs, 120);
  append_profile(unr, hs);

  if (condition == 'f')
    return;
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (!in_sfp(WITH->call))
    return;
  sprintf(hs2, "%s%s%cERR", boxprotodir, WITH->call, extsep);
  if (!exist(hs2)) {
    get_btext(unr, 123, w);
    sprintf(w + strlen(w), " %s:", Console_call);
    append(hs2, w, true);
    get_btext(unr, 124, w);
    append(hs2, w, true);
    append(hs2, "---", true);
  }
  append(hs2, hs, true);
}


/* Rueckwirkend blockweise E/M - Eintraege loeschen oder ruecksetzen */

void del_emblocks(short unr, unsigned short undelete)
{
  Char index[256];
  short list, lv;
  indexstruct header;

  if (!boxrange(unr))
    return;
  sprintf(index, "%sX%c%s", indexdir, extsep, idx_e);
  lv = sfsize(index) / sizeof(indexstruct);
  list = sfopen(index, FO_RW);
  if (list >= minhandle) {
    while (lv > 0) {
      read_index(list, lv, &header);
      if (check_hcs(header)) {
	if (!strcmp(header.dest, user[unr]->call)) {
	  if ((header.pmode & 16) != 0) {
	    if (undelete > 0) {
	      undelete--;
	      header.pmode = 4;
	    } else
	      header.deleted = true;
	    write_index(list, lv, &header);
	  }
	}
      }
      lv--;
    }

    sfclose(&list);
    x_garbage_waiting = true;
  }
  user[unr]->emblockct = 0;
}


void reset_laterflag(short unr)
{
  Char index[256];
  short list, lv, x;
  indexstruct header;

  if (!boxrange(unr))
    return;
  sprintf(index, "%sX%c%s", indexdir, extsep, idx_e);
  lv = sfsize(index) / sizeof(indexstruct);
  list = sfopen(index, FO_RW);
  if (list < minhandle)
    return;
  for (x = 1; x <= lv; x++) {
    read_index(list, x, &header);
    if (check_hcs(header)) {
      if ((header.pmode & 128) != 0) {
        if (!strcmp(header.dest, user[unr]->call)) {
	  if ((header.pmode & 128) != 0) {
	    header.pmode &= ~128;
	    write_index(list, x, &header);
	  }
	}
      }
    }
  }
  user[unr]->laterflag = false;
  sfclose(&list);
}


Static void set_reject_call(indexstruct *header, Char *rc_)
{
  Char rc[256];
  short x;
  Char STR1[256];

  strcpy(rc, rc_);
  rspacing(rc, 6);
  sprintf(rc, "%%%s", strcpy(STR1, rc));
  if (strpos2(header->readby, rc, 1) != 0)
    return;
  if (strlen(header->readby) < 134) {
    strcat(header->readby, rc);
    return;
  }
  x = strpos2(header->readby, "!", 1);
  if (x > 0) {
    strdelete((void *)header->readby, x, 7);
    strcat(header->readby, rc);
  }
}


Static void received_sf_sending(Char condition, short unr, short prop,
				boolean abgelehnt)
{
  Char index[256], hs[256];
  Char uh[256];
  Char w1[256], w2[256];
  short inr;
  indexstruct header;
  short lv, list, rindex, newlt;
  boolean inc_fwd, spec_sf, abg2, rerr;
  userstruct *WITH;
  fbbproptype *WITH1;

  debug0(3, unr, 76);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  abg2 = false;
  inc_fwd = !abgelehnt;
  spec_sf = false;
  rerr = (condition == 'f');

  if (!abgelehnt) {
    switch (WITH->fbbprop[prop - 1].mtype) {

    case 'P':
      WITH->fstat_tx_p++;
      break;

    case 'S':
      WITH->fstat_tx_s++;
      break;

    default:
      WITH->fstat_tx_b++;
      break;
    }
  }

  rindex = WITH->fbbprop[prop - 1].x_nr;
  if (rindex > 0) {
    sprintf(index, "%sX%c%s", indexdir, extsep, idx_e);
    lv = sfsize(index) / sizeof(indexstruct);
    if (rindex <= lv) {
      list = sfopen(index, FO_RW);
      if (list >= minhandle) {
	read_index(list, rindex, &header);
	if (check_hcs(header)) {
	  spec_sf = ((header.pmode & 8) != 0);
	  header.deleted = true;
	  write_index(list, rindex, &header);
	}
	sfclose(&list);
	x_garbage_waiting = true;
      }
    }
  }

  strcpy(w1, WITH->fbbprop[prop - 1].brett);
  inr = WITH->fbbprop[prop - 1].nr;
  if (inr > 0) {
    sprintf(index, "%s%s%c%s", indexdir, w1, extsep, idx_e);
    lv = sfsize(index) / sizeof(indexstruct);
    if (inr > 0 && inr <= lv) {
      list = sfopen(index, FO_RW);
      if (list >= minhandle) {
	read_index(list, inr, &header);
	if (check_hcs(header)) {
	  unhpath(header.verbreitung, uh);

	  if (rerr || callsign(uh) && !spec_sf) {
	    if (inc_fwd)
	      header.msgflags |= MSG_SFTX;

	    if (abgelehnt || rerr) {
	      if ((header.msgflags & MSG_PROPOSED) > 0 && condition == '-') {
		inc_fwd = true;
		header.msgflags &= ~MSG_PROPOSED;
	      } else if (condition == '-' &&
			 !strcmp(WITH->call, Console_call) &&
			 !strcmp(uh, Console_call)) {
		inc_fwd = false;
		    /* doppelte boxinstallation am selben ort */
		header.msgflags &= ~MSG_PROPOSED;
	      } else if (!rerr && WITH->fbbprop[prop - 1].x_nr == 0)
		inc_fwd = false;   /*das sind die Userfile-Vorschlaege...*/
	      else {
		inc_fwd = false;
		if (header.fwdct == 0 || condition != '-') {
		  abg2 = true;
		  if (condition != 'f') {
		    header.msgflags |= MSG_SFERR;
		    set_reject_call(&header, WITH->call);
		  }
		  switch (condition) {

		  case 'E':
		    strcpy(w2, "Syntax Error");
		    break;

		  case 'R':
		  case '\0':
		    header.msgflags |= MSG_REJECTED;
		    strcpy(w2, "Rejected");
		    break;

		  case '-':
		    header.msgflags |= MSG_DOUBLE;
		    strcpy(w2, "Double");
		    break;

		  case 'f':
		    strcpy(w2, "Read Error (file deleted)");
		    break;

		  /*   #0  :   w2  := 'Unknown answer'; */
		  default:
		    sprintf(w2, "Unknown answer (%c)", condition);
		    break;
		  }
		  switch (condition) {

		  case 'E':
		  case 'R':
		  case '-':
		    switch (condition) {

		    case 'E':
		      newlt = 3;
		      break;

		    case 'R':
		      newlt = returntime / 86400L + 1;
		      break;

		    case '-':
		      newlt = 1;
		      break;

		    default:
		      newlt = 1;
		      break;
		    }
		    if (header.lifetime == 0 || header.lifetime > newlt) {
		      header.lifetime = newlt;
		      sprintf(hs, "%ld", header.lifetime);
		      alter_log(false, header.msgnum, header.msgflags, '#',
				hs);
		    }
		    break;

		  case 'f':
		    header.lifetime = 1;
		    header.deleted = true;
		    header.erasetime = clock_.ixtime;
		    header.eraseby = EB_SFERR;
		    add_eraseby(user[unr]->call, &header);
		    alter_log(false, header.msgnum, header.msgflags, 'E', "");
		    break;
		  }
		  routing_error(unr, condition, header, w1, w2);
		}
	      }
	    } else {
	      inc_fwd = true;
	      header.msgflags &= ~MSG_PROPOSED;
	      alter_log(false, header.msgnum, header.msgflags, '!', "");
	    }

	    if (!multiprivate) {
	      /*tocalls nur einmal forwarden, auch wenn mehrere Eintraege in der SF-Liste sind*/
	      strcpy(hs, "X");
	      delete_brett_by_bid(hs, "", header.id, false, true);
	    }



	    if (multiprivate) {
	      strcpy(hs, "X");
	      if (search_by_bid(hs, header.id, false) == 0) {
		if (!abg2) {
		  header.msgflags &= ~MSG_SFWAIT;
		  if (!holdownfiles || strcmp(header.absender, Console_call)) {
		    if (strcmp(WITH->call, Console_call) ||
			strcmp(uh, Console_call)) {
		      header.deleted = true;
		      header.erasetime = clock_.ixtime;
		      header.eraseby = EB_SF;
		      add_eraseby(user[unr]->call, &header);
		    }
		    alter_log(false, header.msgnum, header.msgflags, 'E', "");
		  } else {
		    header.msgflags |= MSG_OWNHOLD;
		    alter_log(false, header.msgnum, header.msgflags, '!', "");
		  }
		}
	      }
	    } else {
	      if (!abg2) {
		header.msgflags &= ~MSG_SFWAIT;
		if (!holdownfiles || strcmp(header.absender, Console_call)) {
		  if (strcmp(WITH->call, Console_call) ||
		      strcmp(uh, Console_call)) {
		    header.deleted = true;
		    header.erasetime = clock_.ixtime;
		    header.eraseby = EB_SF;
		    add_eraseby(user[unr]->call, &header);
		  }
		  alter_log(false, header.msgnum, header.msgflags, 'E', "");
		} else {
		  header.msgflags |= MSG_OWNHOLD;
		  alter_log(false, header.msgnum, header.msgflags, '!', "");
		}
	      }
	    }
	  } else {
	    header.msgflags &= ~MSG_PROPOSED;
	    header.msgflags |= MSG_SFTX;
	    strcpy(hs, "X");
	    if (search_by_bid(hs, header.id, false) == 0)
	      header.msgflags &= ~MSG_SFWAIT;
	    alter_log(false, header.msgnum, header.msgflags, '!', "");
	  }



	  if (inc_fwd)
	    header.fwdct++;
	  write_index(list, inr, &header);
	}
	sfclose(&list);
      }
    }
  }

  WITH1 = &WITH->fbbprop[prop - 1];
  WITH1->crc = 0;
  WITH1->pack = false;
  WITH1->nr = 0;
  WITH1->x_nr = 0;
  WITH1->brett[0] = '\0';
  WITH1->line[0] = '\0';
  WITH1->bid[0] = '\0';
  WITH1->mtype = '\0';
}


Static void set_msgflag(Char *brett, short nr)
{
  short k;
  indexstruct header;
  Char STR1[256];

  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  k = sfopen(STR1, FO_RW);
  if (k < minhandle)
    return;
  read_index(k, nr, &header);
  if (check_hcs(header)) {
    header.msgflags |= MSG_PROPOSED;
    write_index(k, nr, &header);
    alter_log(false, header.msgnum, header.msgflags, '!', "");
  }
  sfclose(&k);
}


Static void get_title(Char *brett, short nr, Char *title)
{
  short k;
  indexstruct idx;
  Char STR1[256];

  title[0] = '\0';
  sprintf(STR1, "%s%s%c%s", indexdir, brett, extsep, idx_e);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return;
  read_index(k, nr, &idx);
  if (check_hcs(idx))
    strcpy(title, idx.betreff);
  else
    *title = '\0';
  sfclose(&k);
}


void ok_sf_sending(short unr, short prop, long offset)
{
  Char hs[256], title[256];
  indexstruct lheader;
  Char rpa[301];
  uchar *rp, *nmem;
  long rps, nsize;
  Char temp2[256];
  short kx;
  fbbproptype *WITH;

  debug0(3, unr, 77);
  if (!boxrange(unr))
    return;
  WITH = &user[unr]->fbbprop[prop - 1];
  WITH->line[0] = '\0';
  if (*WITH->brett != '\0' && WITH->nr > 0) {
    set_msgflag(WITH->brett, WITH->nr);
    
    if (read_brett(unr, nohandle, WITH->brett, WITH->nr, WITH->nr, "", "",
		   offset, &lheader) != 0xffffL)
      return;

    if (user[unr] != NULL) {
      received_sf_sending('f', unr, prop, true);
      abort_sf(unr, false, "file error");
    }
    return;
  }
  if (strcmp(WITH->brett, "E") && strcmp(WITH->brett, "M")) {
    abort_sf(unr, false, "msg not found 1");
    return;
  }
  title[0] = '\0';
  if (user[unr]->sf_level < 2 || user[unr]->sf_level > 2 && !packed_sf) {
    get_title("X", WITH->x_nr, title);
    get_word(title, hs);
    wlnuser(unr, title);
    wlnuser(unr, "***system file***");

    chwuser(unr, 0x1a);

    return;
  }
  if (user[unr]->sf_level <= 2) {
    abort_sf(unr, false, "msg not found 2");
    return;
  }
  /* zur Unterdrueckung der zu sendenden Daten im Verbindungsfenster */
  boxsetboxbin(user[unr]->pchan, true);
  get_title("X", WITH->x_nr, title);
  get_word(title, hs);

  rp = rpa;
  rps = 0;
  nmem = NULL;
  nsize = 0;
  sprintf(temp2, "%sPCKEM657", tempdir);

  put_line(rp, &rps, "  ");
  put_line(rp, &rps, "***system file***");
  put_line(rp, &rps, "  ");

  if (huffmempacker(true, rp, rps, &nmem, &nsize, temp2, true) != 0) {
    abort_sf(unr, false, "*** packerror");
    return;
  }
  if (nsize != 0) {
    rp = nmem;
    rps = nsize;
  } else {
    rps = sfsize(temp2);
    kx = sfopen(temp2, FO_READ);
    if (kx >= minhandle) {
      sfread(kx, rps, rp);
      sfclose(&kx);
      sfdelfile(temp2);
    }
  }
  send_pfbbram(user[unr]->fwdmode, unr, rp, rps, offset, title);
  if (nsize != 0)
    mymfreep(&nmem);
}


void look_for_mail(short unr, boolean not_last, boolean immediate)
{
  short x;
  boolean nobbs;
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  switch (propose_sf_sending(unr)) {

  case 0:
    if (!not_last)
      abort_sf(unr, false, "***done");
    else {
      if (immediate) {
	WITH->sf_to = false;
	WITH->action = 5;
	wlnuser(unr, "F>");
      } else {
	switch (WITH->action) {

	case 205:
	  WITH->sf_to = false;
	  WITH->action = 5;
	  wlnuser(unr, "F>");
	  break;

	case 200:
	case 201:
	case 202:
	case 203:
	case 204:
	  WITH->action++;
	  break;

	default:   /* 30 sekunden warten, dann nochmal probieren */
	  WITH->action = 200;

	  if (WITH->action != 5) {
	    nobbs = true;
	    if (in_sfp(user[unr]->call)) {
	      for (x = 1; x <= maxuser; x++) {
		if (x != unr) {
		  if (user[x] != NULL) {
		    if (user[x]->f_bbs)
		      nobbs = false;
		  }
		}
	      }
	    }
	    if (nobbs) {
	      WITH->sf_to = false;
	      WITH->action = 5;
	      wlnuser(unr, "F>");
	    }
	  }

	  break;
	}
      }
    }
    break;

  case 1:  /*bulletin*/
    WITH->sf_to = true;
    WITH->action = 3;
    break;

  case 2:  /*system*/
    WITH->sf_to = true;
    WITH->action = 30;
    break;

  case 3:  /*private diebox*/
    WITH->sf_to = true;
    WITH->action = 4;
    ok_sf_sending(unr, 1, 0);
    break;

  case 4:
    WITH->sf_to = true;
    break;
  }
}


Static boolean calc_prop_crc(short unr, Char *crcstr)
{
  boolean Result;
  short x, z;
  unsigned short crc16;
  boolean true_crc;
  Char hs[256];
  userstruct *WITH;
  short FORLIM1;
  Char STR1[256];

  crcstr[0] = '\0';
  crc16 = 0;
  Result = false;

  if (!boxrange(unr))
    return Result;

  WITH = user[unr];
  true_crc = (strpos2(WITH->SID, "D", 1) > 0);

  for (x = 0; x < maxfbbprops; x++) {
    if (*WITH->fbbprop[x].line != '\0') {
      Result = true;
      if (true_crc) {  /*HBS-Checksumme*/
	FORLIM1 = strlen(WITH->fbbprop[x].line);
	for (z = 0; z < FORLIM1; z++)
	  crcthp(WITH->fbbprop[x].line[z], &crc16);
      } else {  /*FBB-Checksumme*/
	FORLIM1 = strlen(WITH->fbbprop[x].line);
	for (z = 0; z < FORLIM1; z++)
	  crc16 = (crc16 + WITH->fbbprop[x].line[z]) & 0xff;
	crc16 = (crc16 + 13) & 0xff;
      }
    }
  }

  if (true_crc) {
    int2hstr(crc16, hs);
    while (strlen(hs) < 4)
      sprintf(hs, "0%s", strcpy(STR1, hs));
    sprintf(crcstr, "%c%c%c%c", hs[2], hs[3], hs[0], hs[1]);
    return Result;
  }


  crc16 = (-crc16) & 0xff;
  int2hstr(crc16, hs);
  while (strlen(hs) < 2)
    sprintf(hs, "0%s", strcpy(STR1, hs));
  sprintf(crcstr, "%c%c", hs[0], hs[1]);
  return Result;
}


void send_fbb_proposals(short unr, boolean disc_if_none)
{
  short x;
  boolean nobbs;
  Char crcstr[256];
  userstruct *WITH;
  Char STR1[256];

_L1:
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  boxsetboxbin(WITH->pchan, false);
  propose_sf_sending(unr);


  if (calc_prop_crc(unr, crcstr)) {
    for (x = 0; x < maxfbbprops; x++) {
      if (*WITH->fbbprop[x].line != '\0')
	wlnuser(unr, WITH->fbbprop[x].line);
    }
    sprintf(STR1, "F> %s", crcstr);
    wlnuser(unr, STR1);
    WITH->action = 11;
    WITH->sf_to = true;
    return;
  }


  if (tell_waiting) {
    tell_check();
    goto _L1;
  }
  if (disc_if_none) {
    switch (WITH->action) {

    case 305:
      wlnuser(unr, "FQ");
      abort_sf(unr, false, "");
      return;
      break;

    case 300:
    case 301:
    case 302:
    case 303:
    case 304:
      WITH->action++;
      break;

    default:   /* 30 sekunden warten, dann nochmal probieren */
      WITH->action = 300;

      nobbs = true;
      if (in_sfp(user[unr]->call)) {
	for (x = 1; x <= maxuser; x++) {
	  if (x != unr) {
	    if (user[x] != NULL) {
	      if (user[x]->f_bbs)
		nobbs = false;
	    }
	  }
	}
      }
      if (nobbs) {
	wlnuser(unr, "FQ");
	abort_sf(unr, false, "");
	return;
      }
      break;
    }

    return;
  }
  wlnuser(unr, "FF");
  WITH->action = 20;
  WITH->sf_to = false;
}


void prepare_for_next_fbb(short unr)
{
  Char hs[256], hs2[256];
  Char w[256], hw[256];
  short x, hit;
  Char msgtype;
  Char STR7[256];

  debug0(3, unr, 78);
  if (!boxrange(unr))
    return;
  hs[0] = '\0';
  hit = 0;
  for (x = maxfbbprops; x >= 1; x--) {
    if (*user[unr]->fbbprop[x - 1].line != '\0')
      hit = x;
  }
  if (hit <= 0) {
    send_fbb_proposals(unr, false);
    return;
  }
  strcpy(hs, user[unr]->fbbprop[hit - 1].line);
  user[unr]->fbbprop[hit - 1].line[0] = '\0';
  get_word(hs, w);   /*FA/FB/FD*/
  get_word(hs, w);   /*B/P/A*/
  msgtype = w[0];
  get_word(hs, w);   /*Absender*/
  sprintf(hs2, " < %s", w);
  get_word(hs, w);   /*mbx*/
  strcpy(hw, w);
  if (strpos2(hw, ".", 1) > 0)
    cut(hw, strpos2(hw, ".", 1) - 1);
  /*letzte Box prueft MyBBS*/
  if (strcmp(hw, Console_call))
    sprintf(hs2, " @ %s%s", w, strcpy(STR7, hs2));
  get_word(hs, w);   /*Ziel*/
  sprintf(hs2, "%s%s", w, strcpy(STR7, hs2));
  get_word(hs, w);   /*BID/MID*/
  strcpy(user[unr]->resumebid, w);
  /* damit ich hinterher beim Abbruch auch weiss,  */
  /* welche BID dieses File hatte                  */
  user[unr]->no_binpack = user[unr]->fbbprop[hit - 1].unpacked;
  sprintf(hs2 + strlen(hs2), " $%s", w);
  get_word(hs, w);   /*laenge*/
  get_word(hs, w);   /*Lifetime wenn vorhanden*/
  if (*w != '\0')
    sprintf(hs2 + strlen(hs2), " #%s", w);
  user[unr]->input2[0] = '\0';
  send_check(unr, hs2, false, msgtype);

  /* sind wir etwa im Resume-Mode am empfangen ? */

  if (*user[unr]->fbbprop[hit - 1].rname == '\0')
    return;

  /* ja, also File kopieren und unter dem Namen ablegen, wie   */
  /* er in SET_PACKSF erwartet wird                            */

  sprintf(hs, "%sBOXSF%c%ld", tempdir, extsep, unr);
  sprintf(STR7, "%s%s", boxstatdir, user[unr]->fbbprop[hit - 1].rname);
  filecopy(STR7, hs);
}


/* FB B DL8HBS ALL ATARI $123456123456 9124 */

boolean check_prop_crc(short unr, Char *eingabe_)
{
  Char eingabe[256];
  Char crcstr[256];

  strcpy(eingabe, eingabe_);
  if (calc_prop_crc(unr, crcstr)) {
    del_lastblanks(eingabe);
    if (*eingabe != '\0')
      return (strcmp(crcstr, eingabe) == 0);
    else
      return true;
  } else
    return false;
}


Static boolean routing_ok(Char *call, Char *board, Char *mbx)
{
  Char hs[256];

  unhpath(mbx, hs);
  if (callsign(hs) && strcmp(hs, Console_call))
    return (gen_sftest3(-1, call, board, mbx));
  else
    return true;
}


/* (Sx) DL8HBS @ DB0GR < DL7XYZ */

Static boolean allowed_rlisf(short unr, Char msgtype, Char *fline_)
{
  Char fline[256];
  Char sender[256], hs[256];
  Char board[256], mbx[256];
  Char bid[256];
  boolean from, b;
  boolean p, ok;
  short k;
  boolean insfp, reject_it, db;



  strcpy(fline, fline_);
  get_word(fline, board);   /* to */
  upper(board);
  if (strpos2(board, "@", 1) > 0)
    cut(board, strpos2(board, "@", 1) - 1);
  k = strpos2(fline, "@", 1);
  if (k > 0) {
    strdelete((void *)fline, 1, k);
    get_word(fline, mbx);
    upper(mbx);
  } else
    strcpy(mbx, Console_call);
  strdelete((void *)fline, 1, strpos2(fline, "<", 1));
  get_word(fline, sender);
  upper(sender);
  get_word(fline, bid);
  if (*bid != '\0' && bid[0] == '$')
    strdelete((void *)bid, 1, 1);
  else
    *bid = '\0';

  *hs = '\0';

  reject_it = false;

  check_reject(user[unr]->call, msgtype, board, mbx, sender, hs, hs, bid, 0,
	       false, false, &reject_it, &db);

  if (reject_it)
    return false;

  ok = false;
  insfp = in_sfp(user[unr]->call);

  if (sfinpdefault == SFI_ALL || insfp) {
    ok = true;

  } else {
    if (sfinpdefault != SFI_NONE) {
      b = false;
      p = false;

      if ((unsigned long)strlen(board) < 32 &&
	  ((1L << strlen(board)) & 0x1fc) != 0) {
	if (callsign(board))
	  p = true;
	else
	  b = true;
      } else if (!strcmp(board, "T") && usersftellmode != SFT_NONE) {
	unhpath(mbx, hs);
	if ((unsigned)usersftellmode < 32 &&
	    ((1L << usersftellmode) & ((1L << SFT_OWN) | (1L << SFT_ALL))) != 0 &&
	    !strcmp(hs, Console_call))
	  p = true;
	else if (usersftellmode == SFT_ALL)
	  b = true;
      }


      from = (strcmp(sender, user[unr]->call) == 0);
      switch (sfinpdefault) {

      case SFI_FROMPB:
	ok = ((p || b) && from);
	break;

      case SFI_FROMP:
	ok = (p && from);
	break;
      }
      if (ok)
	ok = routing_ok(user[unr]->call, board, mbx);
      if (create_usersflog && ok && !insfp)
	append_usersflog(unr, sender, board, mbx, bid, "  ");
    }
  }

  if (ok)
    ok = routing_ok(user[unr]->call, board, mbx);

  return ok;
}


/* FB B DL8HBS ALL ATARI $123456123456 9124 */

Static boolean allowed_fbbsf(short unr, Char *sender, Char *board, Char *mbx,
			     Char *bid, Char *size)
{
  boolean from, b;
  boolean p, ok, insfp;
  Char hs[256];

  ok = false;
  insfp = in_sfp(user[unr]->call);
  if (sfinpdefault == SFI_ALL || insfp)
    ok = true;
  else {
    if (sfinpdefault != SFI_NONE) {
      b = false;
      p = false;
      from = (strcmp(sender, user[unr]->call) == 0);

      if ((unsigned long)strlen(board) < 32 &&
	  ((1L << strlen(board)) & 0x1fc) != 0) {
	if (callsign(board))
	  p = true;
	else
	  b = true;
      } else if (!strcmp(board, "T") && usersftellmode != SFT_NONE) {
	unhpath(mbx, hs);
	if ((unsigned)usersftellmode < 32 &&
	    ((1L << usersftellmode) & ((1L << SFT_OWN) | (1L << SFT_ALL))) != 0 &&
	    !strcmp(hs, Console_call))
	  p = true;
	else if (usersftellmode == SFT_ALL)
	  b = true;
      }


      switch (sfinpdefault) {

      case SFI_FROMPB:
	ok = ((p || b) && from);
	break;

      case SFI_FROMP:
	ok = (p && from);
	break;
      }
    }
  }
  if (ok)
    ok = routing_ok(user[unr]->call, board, mbx);

  if (create_usersflog && ok && !insfp)
    append_usersflog(unr, sender, board, mbx, bid, size);

  return ok;
}


/* FB B DL8HBS ALL ATARI $123456123456 9124 */

void send_fbb_answer(short unr)
{
  Char answer[256];
  Char bid[256];
  Char hs[256], hs2[256];
  Char tmbx[256];
  Char tboard[256];
  Char tsender[256], tsize[256];
  short propct, x, y, w, z;
  long roffset;
  boolean ok, no_sf, double_prop, disk_full_abort;
  bidchecktype bidcheck;
  bidarrtype bidarr;
  boolean extended_proto, reject_it;
  Char mtype;
  userstruct *WITH;

  debug0(3, unr, 79);
  disk_full_abort = false;

  if (!boxrange(unr))
    return;
  WITH = user[unr];

  extended_proto = ((unsigned)WITH->fwdmode < 32 && ((1L << WITH->fwdmode) & 0x38) != 0);

  ok = false;
  strcpy(answer, "FS ");

  propct = 0;
  for (x = 0; x < maxfbbprops; x++) {
    bidarr[x][0] = '\0';
    if (*WITH->fbbprop[x].line != '\0') {
      propct++;
      strcpy(hs, WITH->fbbprop[x].line);
      for (y = 1; y <= 6; y++)
	get_word(hs, hs2);
      cut(hs2, 12);   /* 6. Wort ist die BID */
      strcpy(bidarr[x], hs2);
      strcpy(WITH->fbbprop[x].bid, hs2);
    }
  }


  multiple_bullcheck(propct, bidcheck, bidarr);

  for (x = 1; x <= propct; x++) {
    WITH->fbbprop[x - 1].rname[0] = '\0';


    if (count_words(WITH->fbbprop[x - 1].line) == 7 ||
	(count_words(WITH->fbbprop[x - 1].line) == 8 &&
	 strpos2(WITH->SID, "D", 1) > 0)) {
      if (bidcheck[x - 1]) {
	strcpy(hs, WITH->fbbprop[x - 1].line);
	for (y = 1; y <= 2; y++)
	  get_word(hs, hs2);
	mtype = hs2[0];
	get_word(hs, tsender);   /* 3. Wort ist der Absender */
	cut(tsender, 6);
	get_word(hs, tmbx);   /* 4. Wort ist @mbx */
	cut(tmbx, 40);
	get_word(hs, tboard);
	cut(tboard, 8);   /* 5. Wort ist die Zielrubrik */

	get_word(hs, hs2);
	cut(hs2, 12);
	strcpy(bid, hs2);
	get_word(hs, tsize);

	*hs = '\0';
	reject_it = false;
	no_sf = false;
	check_reject(WITH->call, mtype, tboard, tmbx, tsender, hs, hs, bid,
		     str2lint(tsize), false, false, &reject_it, &no_sf);

	if (!reject_it) {
	  double_prop = false;

	  for (w = 1; w <= maxuser; w++) {
	    if (user[w] != NULL) {
	      if (user[w]->f_bbs && !user[w]->sf_to) {
		for (z = 0; z < maxfbbprops; z++) {
		  if (w != unr || z + 1 != x) {
		    if (double_prop == false)
		      double_prop = (strcmp(bid, user[w]->fbbprop[z].bid) == 0);
		  }
		}
	      }
	    }
	  }


	  if (double_prop) {
	    strcat(answer, "=");
	    WITH->fbbprop[x - 1].line[0] = '\0';
	    WITH->fbbprop[x - 1].bid[0] = '\0';
	  } else {
	    if (disk_full) {
	      strcat(answer, "=");
	      WITH->fbbprop[x - 1].line[0] = '\0';
	      disk_full_abort = true;
	    } else {
	      /* Testen, ob die Mail an den Sender zurueckgeroutet werden muesste, */
	      /* ob wir ueberhaupt einen Weg zum Ziel kennen und ob der Einspieler */
	      /* berechtigt ist, an das Ziel zu senden                             */

	      if (allowed_fbbsf(unr, tsender, tboard, tmbx, bid, tsize)) {
		/* Nachschauen, ob ein Resume-Fragment vorliegt */

		if (extended_proto) {  /* resume !? */
		  roffset = check_resume(bidarr[x - 1], WITH->call,
					 WITH->fbbprop[x - 1].rname);
		  if (roffset > 0) {  /* ja! */
		    sprintf(hs2, "%ld", roffset);
		    sprintf(answer + strlen(answer), "!%s", hs2);
		  } else {
		    if (no_sf)
		      strcat(answer, "H");
		    else
		      strcat(answer, "+");
		  }
		} else {
		  if (no_sf)
		    strcat(answer, "H");
		  else
		    strcat(answer, "+");
		}
		ok = true;

	      } else {
		if (extended_proto)
		  strcat(answer, "R");
		else
		  strcat(answer, "-");
		WITH->fbbprop[x - 1].line[0] = '\0';
	      }

	    }

	  }

	} else {
	  if (extended_proto)
	    strcat(answer, "R");
	  else
	    strcat(answer, "-");
	  WITH->fbbprop[x - 1].line[0] = '\0';
	}


      } else {  /*schon vorhanden*/
	strcat(answer, "-");
	WITH->fbbprop[x - 1].line[0] = '\0';
      }


    } else if (*WITH->fbbprop[x - 1].line != '\0') {
      if (extended_proto)
	strcat(answer, "E");
      else
	strcat(answer, "-");
      WITH->fbbprop[x - 1].line[0] = '\0';
    }
  }


  if (disk_full_abort) {
    abort_sf(unr, false, "DISK FULL");
    return;
  }
  if (!boxrange(unr))
    return;
  wlnuser(unr, answer);
  boxspoolread();

  /* nachschauen, ob eventuell von hier auch eine msg mit dieser BID an    */
  /* den Partner gehen soll und dann sofort loeschen...                    */

  strcpy(hs, "X");
  for (y = 0; y < propct; y++) {
    if (!bidcheck[y])   /* diese hier war doppelt       */
      delete_brett_by_bid(hs, WITH->call, bidarr[y], false, true);
  }

  if (!ok)
    send_fbb_proposals(unr, false);
  else
    prepare_for_next_fbb(unr);

}


void analyse_fbb_answer(short unr, Char *eingabe_)
{
  Char eingabe[256];
  short z;
  Char w[256];
  indexstruct header;
  long off;
  short k;
  userstruct *WITH;
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  debug(3, unr, 80, eingabe);
  if (boxrange(unr)) {
    WITH = user[unr];
    z = 0;
    while (z < maxfbbprops && *eingabe != '\0') {
      z++;

      switch (eingabe[0]) {

      case '=':  /*aus der aktuellen Liste nehmen...*/
        if (WITH->fbbprop[z - 1].x_nr > 0) {
	  sprintf(STR1, "%sX%c%s", indexdir, extsep, idx_e);
	  k = sfopen(STR1, FO_RW);
	  if (k >= minhandle) {
	    read_index(k, WITH->fbbprop[z - 1].x_nr, &header);
	    header.pmode |= 128;   /* laterflag */
	    write_index(k, WITH->fbbprop[z - 1].x_nr, &header);
	    sfclose(&k);
	    WITH->laterflag = true;
	  }
	}
	WITH->fbbprop[z - 1].nr = 0;
	WITH->fbbprop[z - 1].x_nr = 0;
	WITH->fbbprop[z - 1].brett[0] = '\0';
	WITH->fbbprop[z - 1].line[0] = '\0';
	WITH->fbbprop[z - 1].bid[0] = '\0';
	break;

      case 'H':
      case '+':
	ok_sf_sending(unr, z, 0);
	if (user[unr] == NULL)
	  goto _L1;
	break;

      case '!':
	w[0] = '\0';
	while (strlen(eingabe) > 1 && isdigit(eingabe[1])) {
	  sprintf(w + strlen(w), "%c", eingabe[1]);
	  strdelete((void *)eingabe, 1, 1);
	}
	off = str2lint(w);
	ok_sf_sending(unr, z, off);
	if (user[unr] == NULL)
	  goto _L1;
	break;

      /* 'E','R','-' : */
      default:   /* loeschen */
	received_sf_sending(eingabe[0], unr, z, true);
	break;
	
      }
      strdelete((void *)eingabe, 1, 1);
    }
    WITH->action = 20;
  }

_L1: ;
}


Static void sf_rx_emt2(boolean wp, Char *eingabe, Char *from)
{
  indexstruct header;
  Char w[256], w1[256], w2[256], hs[256];
  Char tob;
  long time;
  boolean ok;
  short TEMP;

  debug(2, -1, 81, eingabe);
  /*S M @ THEBOX < DH4FBC $BID MYBBS TIME CTRL-Z*/
  /*S E @ THEBOX < DB0HAG $BID ERASEBID CTRL-Z*/

  upper(eingabe);
  get_word(eingabe, w);   /* M / E ... */
  if (!(strlen(w) == 1 &&
	(TEMP = count_words(eingabe), (unsigned)TEMP < 32 &&
				      ((1L << TEMP) & 0x180) != 0)))
    return;
  tob = w[0];
  get_word(eingabe, w);   /* @ */
  get_word(eingabe, w);   /* THEBOX */
  strcpy(header.verbreitung, w);
  get_word(eingabe, w);   /* < */
  get_word(eingabe, w);   /* Absender */
  if (!callsign(w))
    return;
  strcpy(header.absender, w);
  get_word(eingabe, w);   /* BID */
  if (strlen(w) <= 1)
    return;
  if (w[0] == '$')   /* das $ */
    strdelete((void *)w, 1, 1);
  if (strlen(w) > 12)
    return;
  strcpy(header.id, w);
  del_lastblanks(eingabe);
  if (*eingabe == '\0')
    return;
  if (eingabe[strlen(eingabe) - 1] == '\032')
    strdelete((void *)eingabe, strlen(eingabe), 1);
  del_lastblanks(eingabe);
  if (strlen(eingabe) > 80)
    return;
  if (*eingabe == '\0')
    return;
  strcpy(header.betreff, eingabe);
  header.dest[0] = '\0';
  header.fwdct = 0;
  header.pmode = 0;
  header.size = 0;
  header.packsize = 0;
  header.lifetime = 0;
  header.txlifetime = 0;
  header.deleted = false;
  header.txdate = 0;
  header.rxqrg = boxaktqrg();
  strcpy(header.rxfrom, from);
  header.level = 1;
  header.fwdct = 0;
  header.msgflags = 0;
  header.msgtype = 'B';
  ok = true;
  if (tob == 'E') {
    if (remote_erase) {
      if (!remoteerasecheck || strpos2(header.betreff, header.absender, 1) > 0)
	add_remote_erase(header.absender, header.id, header.rxfrom,
			 header.betreff);
    }
  } else if (tob == 'M') {
    strcpy(hs, header.betreff);
    get_word(hs, w2);
    unhpath(w2, w);
    get_word(hs, w1);
    time = str2lint(w1);
    time -= THEBOX_ERRONEOUS_OFFSET;
    if (callsign(w)) {
      ok = update_mybbsfile(false, header.absender, &time, w, "U");
      if (*header.rxfrom != '\0' && ok)
	add_wpline(header.absender, w2, time, header.rxfrom, wp);
    }
  }
  sprintf(w, "%c", tob);
  strcpy(w1, "*");
  if (*header.rxfrom != '\0' && ok) {
    if (wp)
      new_bid(header.id);
    vermerke_sf(-1, false, w, header.rxfrom, w1, header, "");
  }
  if (wp && ok)
    write_msgid(-1, header.id);
}


void do_emt(long *seekp)
{
  long tc;
  short k;
  Char hs[256], fn[256];
  Char w1[256], w2[256];

  tc = statclock();
  sprintf(fn, "%smybbs%ctmp", boxstatdir, extsep);
  k = sfopen(fn, FO_READ);
  if (k >= minhandle) {
    if (sfseek(*seekp, k, SFSEEKSET) == *seekp) {
      do {
	if (file_to_string(k, hs)) {
	  *seekp += strlen(hs) + 1;
	  get_word(hs, w1);
	  get_word(hs, w2);
	  if (w1[0] == '!')
	    *w1 = '\0';
	  sf_rx_emt2(w2[0] == 'W', hs, w1);
	} else
	  *seekp = 0;
      } while (*seekp != 0 && statclock() - tc < ttask);
    } else
      *seekp = 0;
    sfclose(&k);
  } else
    *seekp = 0;

  if (*seekp == 0) {
    sfdelfile(fn);
    new_mybbs_data = false;
  }
}


void sf_rx_emt1(short unr, Char *eingabe, Char *actwpfilesender)
{
  short x;
  Char hs[256], w[256];
  Char STR1[256];

  if (strlen(eingabe) > 100) return;
  if (unr == -17)
    strcpy(hs, "W");
  else
    strcpy(hs, "M");
  sprintf(hs, " %s %s", strcpy(STR1, hs), eingabe);
  if (*actwpfilesender == '\0')
    sprintf(hs, "!%s", strcpy(STR1, hs));
  else
    sprintf(hs, "%s%s", actwpfilesender, strcpy(STR1, hs));
  sprintf(STR1, "%smybbs%ctmp", boxstatdir, extsep);
  append(STR1, hs, true);
  if (unr >= 0) {
    for (x = 1; x <= 6; x++)
      get_word(hs, w);
    if (w[0] == '$') {
      strdelete((void *)w, 1, 1);
      write_msgid(-1, w);
    }
  }
  new_mybbs_data = true;
}


void sf_rx_emt(short unr, Char *eingabe)
{
  Char hs[256];

  if (boxrange(unr))
    strcpy(hs, user[unr]->call);
  else
    *hs = '\0';
  sf_rx_emt1(unr, eingabe, hs);
}


void set_packsf(short unr)
{
  userstruct *WITH;
  binsftyp *WITH1;
  Char STR1[256];

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (WITH->binsfptr == NULL) {
    abort_sf(unr, false, "no binsfptr 2");
    return;
  }
  boxsetrwmode(WITH->pchan, 8);
  WITH->binsfptr->blockcounter = 0;

  WITH1 = WITH->binsfptr;

  sprintf(WITH1->wname, "%ld", unr);
  sprintf(STR1, "%sBOXSF%c%s", tempdir, extsep, WITH1->wname);
  strcpy(WITH1->wname, STR1);

  WITH1->wchan = nohandle;

  /* Wenn alles geklappt hat, dann haben wir ein Resume-Fragment   */
  /* hier liegen, wenn der TX-Offset > 0 ist                       */

  if (WITH1->offset > 0)
    WITH1->wchan = sfopen(WITH1->wname, FO_RW);

  /* Entweder war da nix oder wir sind nicht im Resume-Modus. Dann */
  /* wird das File neu erzeugt. Wenn wir im Resume sind, ist das   */
  /* ein Fehler, der wird aber in CHECK_FIRSTSIX abgefangen        */

  if (WITH1->wchan < minhandle)
    WITH1->wchan = sfcreate(WITH1->wname, FC_FILE);
  if (WITH1->wchan < minhandle) {
    abort_sf(unr, true, "no handle");
    return;
  }

  WITH1->checksum = 0;
  WITH1->rxbytes = 0;
  WITH1->validbytes = 0;
}


Static boolean check_firstsix(short unr)
{
  boolean Result;
  long err;
  firstsixtype fs2;
  short x;
  binsftyp *WITH;

  Result = false;
  if (!boxrange(unr))
    return Result;
  if (user[unr]->binsfptr == NULL)
    return Result;
  WITH = user[unr]->binsfptr;
  sfseek(0, WITH->wchan, SFSEEKSET);   /* an den Anfang des Files */
  sfread(WITH->wchan, sizeof(firstsixtype), fs2);
  err = sfseek(WITH->offset, WITH->wchan, SFSEEKSET);
      /* an die aktuelle Schreibmarke */
  if (err != WITH->offset)
    return Result;
  Result = true;
  for (x = 0; x <= 5; x++) {
    if (fs2[x] != WITH->firstsix[x])
      Result = false;
  }
  return Result;
}



Static void del_binsfptr(short unr)
{
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (WITH->binsfptr != NULL)
    Free(WITH->binsfptr);
  WITH->binsfptr = NULL;
}


Static unsigned short dpi16integer(unsigned short l)
{
  return l;
}


Static void add_bpacksf(short unr)
{
  boolean crc_ok;
  short mode, k;
  unsigned short soll_crc;
  short x;
  Char w[256], hs[256];
  boolean abort;
  uchar *puffer;
  long size;
  uchar *nmem;
  long nsize;
  userstruct *WITH;
  Char STR1[256];
  short FORLIM;

  debug0(4, unr, 82);
  puffer = NULL;
  abort = false;
  if (!boxrange(unr))
    return;

  WITH = user[unr];
  /* nachschauen, ob da ein Fragment rumliegt, wenn ja, dann weg damit! */
  del_resume(WITH->resumebid, WITH->call);

  if (WITH->binsfptr == NULL)
    return;
  mode = WITH->fwdmode;
  crc_ok = (WITH->binsfptr->checksum == 0);

  /* quasi die Grundvoraussetzung */

  if (crc_ok) {
    sprintf(w, "%ld", unr);
    sprintf(w, "%sDECSF%c%s", tempdir, extsep, strcpy(STR1, w));
    size = sfsize(WITH->binsfptr->wname);

    if (size > 0) {
      if ((unsigned)mode < 32 && ((1L << mode) & 0x38) != 0)
	size -= 2;

      if (size <= maxram())
	puffer = Malloc(size);


      if (puffer != NULL) {
	k = sfopen(WITH->binsfptr->wname, FO_READ);
	if (k >= minhandle) {
	  if ((unsigned)mode < 32 && ((1L << mode) & 0x38) != 0) {
	    sfread(k, 2, (uchar *)(&soll_crc));
	    /* CRC umdrehen */
	    soll_crc = dpi16integer(soll_crc);
	  }
	  sfread(k, size, puffer);
	  sfclose(&k);
	  sfdelfile(WITH->binsfptr->wname);

	  /* CRC testen    */
	  if ((unsigned)mode < 32 && ((1L << mode) & 0x38) != 0) {
	    WITH->binsfptr->crcsum = 0;

	    if ((unsigned)mode < 32 && ((1L << mode) & 0x30) != 0) {
	      FORLIM = strlen(WITH->binsfptr->fbbtitle);
	      for (x = 0; x < FORLIM; x++)
		crcfbb(WITH->binsfptr->fbbtitle[x], &WITH->binsfptr->crcsum);
	    }

	    crcfbb_buf(puffer, size, &WITH->binsfptr->crcsum);
	    crc_ok = (WITH->binsfptr->crcsum == soll_crc);

	  }


	  if (crc_ok) {
	    nmem = NULL;
	    if (WITH->no_binpack) {
	      sfwrite(WITH->sendchan, size, puffer);
	      mymfreep(&puffer);
	      del_binsfptr(unr);
	      strcpy(w, "\032");
	      send_text3(unr, false, w, true);
	    } else {
	      if (huffmempacker(false, puffer, size, &nmem, &nsize, w, true) == 0) {
		mymfreep(&puffer);
		if (nmem == NULL)
		  app_file(w, WITH->sendchan, true);
		else {
		  sfwrite(WITH->sendchan, nsize, nmem);
		  mymfreep(&nmem);
		}
		del_binsfptr(unr);
		strcpy(w, "\032");
		send_text3(unr, false, w, true);
	      } else
		abort = true;
	    }
	  } else
	    abort = true;
	} else
	  abort = true;
	/* Soll-CRC auslesen */

      } else {
	crc_ok = false;
	if ((unsigned)mode < 32 && ((1L << mode) & 0x38) != 0) {
	  k = sfopen(WITH->binsfptr->wname, FO_READ);
	  if (k >= minhandle) {
	    sfread(k, 2, (uchar *)(&soll_crc));
	    sfclose(&k);
	    /* CRC umdrehen */
	    soll_crc = dpi16integer(soll_crc);
	    strcpy(hs, w);
	    validate(hs);
	    filecut(WITH->binsfptr->wname, hs, 2, 0);
	    strcpy(WITH->binsfptr->wname, hs);
	    if (mode == 3)
	      crc_ok = (file_crc(3, hs, 0, 0, 0) == soll_crc);
	    else
	      crc_ok = (file_crc(3, hs, WITH->binsfptr->crcsum, 0, 0) ==
			soll_crc);
	  }
	} else
	  crc_ok = true;

	if (crc_ok) {
	  if (WITH->no_binpack) {
	    app_file(WITH->binsfptr->wname, WITH->sendchan, true);
	    strcpy(w, "\032");
	    send_text3(unr, false, w, true);
	  } else {
	    if (huffpacker(false, WITH->binsfptr->wname, w, true) == 0) {
	      sfdelfile(WITH->binsfptr->wname);
	      del_binsfptr(unr);
	      app_file(w, WITH->sendchan, true);
	      strcpy(w, "\032");
	      send_text3(unr, false, w, true);
	    } else
	      abort = true;
	  }
	} else
	  abort = true;


      }

    } else {  /* leeres File (nur Titel) */
      sfdelfile(WITH->binsfptr->wname);
      del_binsfptr(unr);
      strcpy(w, "\032");
      send_text3(unr, false, w, true);
    }


    if (!abort)
      return;

    if (puffer != NULL)
      mymfreep(&puffer);
    if (crc_ok)
      strcpy(w, "*** Decode-Error");
    else
      strcpy(w, "*** CRC-Error");
    sfdelfile(WITH->binsfptr->wname);
    del_binsfptr(unr);
    string_to_file(&WITH->sendchan, w, true);
    abort_sf(unr, false, w);
    return;
  }


  strcpy(w, "*** Checksum-Error");
  sfdelfile(WITH->binsfptr->wname);
  del_binsfptr(unr);
  string_to_file(&WITH->sendchan, w, true);
  abort_sf(unr, false, w);
}


/* Hier kommt der Titel von FBB an */

Static void title_ok(short unr)
{
  short x, mode;
  Char hs[256];
  binsftyp *WITH;
  short FORLIM;

  mode = user[unr]->fwdmode;
  WITH = user[unr]->binsfptr;
  WITH->offset = 0;
  WITH->checksum = 0;
  WITH->crcsum = 0;
  WITH->validbytes = 0;
  WITH->blockcrc = 0;

  if (mode == 2) {   /* HBS alt */
    FORLIM = WITH->fbbtitlelen;
    for (x = 0; x < FORLIM; x++)
      crcthp(WITH->fbbtitle[x], &WITH->crcsum);
  }

  if ((unsigned)mode < 32 && ((1L << mode) & 0x38) != 0)
  {  /* Offset extrahieren */
    x = 1;
    while (WITH->fbbtitle[x - 1] != '\0' && x < WITH->fbbtitlelen)
      x++;
    if (WITH->fbbtitle[x - 1] == '\0') {
      hs[0] = '\0';
      x++;
      while (WITH->fbbtitle[x - 1] != '\0' && x < WITH->fbbtitlelen) {
	if (WITH->fbbtitle[x - 1] != ' ')
	  sprintf(hs + strlen(hs), "%c", WITH->fbbtitle[x - 1]);
	x++;
      }

      WITH->offset = str2lint(hs);
    }
  }
  
  box_txt2(false, unr, WITH->fbbtitle);
}


void fbbpack2(short unr, unsigned short infosize, unsigned short *infstart,
	      uchar *info)
{
  short ct, hx, hy, hlen;
  long count;
  short oinfs;
  unsigned short hsize;
  binsftyp *WITH;

  debug0(4, unr, 83);
  hsize = infosize - *infstart + 1;
  if (!boxrange(unr)) {
    *infstart = SHORT_MAX;
    abort_sf(unr, true, "invalid unr");
    return;
  }
  count = statclock();
  oinfs = *infstart;
  if (user[unr]->binsfptr == NULL) {
    *infstart = SHORT_MAX;
    abort_sf(unr, true, "no binsfptr");
    return;
  }
  WITH = user[unr]->binsfptr;
  box_ttouch(unr);
  if (hsize > 0) {
    if (WITH->blockcounter == SHORT_MAX) {
      if (hsize <= 1) {
	*infstart = SHORT_MAX;
	abort_sf(unr, false, "please restart s&f...");
	return;
      }

      /* Dies ist eine Fehlermeldung, die immer dann erscheint, wenn erst das  */
      /* erste Byte des Titelblocks (der Identifier) kam. Reine Faulheit...    */

      if (info[*infstart - 1] != 1) {
	*infstart = SHORT_MAX;
	abort_sf(unr, false, "invalid block identifier");
	return;
      }
      hlen = info[*infstart];
      hx = hsize;
      if (hx >= hlen + 2)
	hy = hlen;
      else
	hy = hx - 2;
      for (ct = 1; ct <= hy; ct++)
	WITH->fbbtitle[ct - 1] = info[*infstart + ct];
      WITH->fbbtitle[hy] = '\0';
      WITH->fbbtitlelen = hy;
      if (hx >= hlen + 2) {
	*infstart += hlen + 2;
	WITH->blockcounter = 0;
	title_ok(unr);
      } else {
	*infstart += hsize;
	WITH->blockcounter = hlen - hx + 2;
      }
    } else if (WITH->blockcounter > 0) {
      hy = WITH->blockcounter;
      if (hy > hsize)
	hy = hsize;
      hx = WITH->fbbtitlelen;
      for (ct = 1; ct <= hy; ct++)
	WITH->fbbtitle[ct + hx - 1] = info[*infstart + ct - 2];
      WITH->fbbtitle[hx + hy] = '\0';
      WITH->fbbtitlelen = hx + hy;
      WITH->blockcounter -= hy;
      *infstart += hy;
      if (WITH->blockcounter == 0)
	title_ok(unr);
    } else {
      *infstart = SHORT_MAX;
      abort_sf(unr, true, "invalid bcount");
      return;
    }

  }
  upd_statistik(unr, *infstart - oinfs, 0, count, statclock());
}


#define bcmagic1        SHORT_MAX
#define bcmagic2        (SHORT_MAX - 1)
#define bcmagic3        (SHORT_MAX - 2)
#define bcmagic4        (SHORT_MAX - 3)
#define bcmagic5        (SHORT_MAX - 4)


Static void put_data(short unr, unsigned short infosize,
		     unsigned short *infstart, uchar *info)
{
  unsigned short hsize;
  uchar *buff;
  unsigned short y;
  short z;
  boolean error;
  binsftyp *WITH;

  buff = (uchar *)(&info);
  error = false;
  WITH = user[unr]->binsfptr;
  hsize = infosize - *infstart + 1;
  if (hsize > WITH->blockcounter)
    hsize = WITH->blockcounter;

  /* Die ersten 6 Bytes muessen gleich den bereits empfangenen */
  /* sein, wenn es sich um eine RESUME - Aussendung handelt    */

  if (WITH->offset > 0 && WITH->rxbytes < 6) {
    y = 6 - WITH->rxbytes;
    if (y > hsize)
      y = hsize;

    for (z = 1; z <= y; z++)
      WITH->firstsix[z + WITH->rxbytes - 1] = info[z + *infstart - 2];

    if (y + WITH->rxbytes == 6) {
      error = !check_firstsix(unr);
      if (!error) {
	buff = &info[*infstart - 1];
	WITH->rxbytes = WITH->offset - y;
	if (hsize - y > 0) {
	  if (WITH->wchan < minhandle) {
	    abort_sf(unr, true, "no handle");
	    *infstart = SHORT_MAX;
	    return;

	  }
	  sfwrite(WITH->wchan, hsize - y, (uchar *)(&buff[y]));
	}
      }

    }

  } else {
    buff = &info[*infstart - 1];
    if (buff != NULL && hsize > 0) {
      if (WITH->wchan < minhandle) {
	abort_sf(unr, true, "no handle");
	*infstart = SHORT_MAX;
	return;
      }
      sfwrite(WITH->wchan, hsize, buff);
    }
  }

  if (!error) {
    switch (user[unr]->fwdmode) {

    case 1:
    case 3:
    case 4:
      checksum8_buf(buff, hsize, &WITH->checksum);
      WITH->blockcounter -= hsize;
      break;

    case 5:
      checksum8_buf(buff, hsize, &WITH->checksum);
      crcfbb_buf(buff, hsize, &WITH->blockcrc);
      WITH->blockcounter -= hsize;
      if (WITH->blockcounter == 0)
	WITH->blockcounter = bcmagic4;
      break;

    case 2:
      crcthp_buf(buff, hsize, &WITH->crcsum);
      WITH->blockcounter -= hsize;
      break;
    }

    *infstart += hsize;
    WITH->rxbytes += hsize;
    return;
  }

  *infstart = SHORT_MAX;
  del_resume(user[unr]->resumebid, user[unr]->call);
  abort_sf(unr, false, "*** unmatching CRC in resume, file deleted");
}


Static void add_it(short unr)
{
  binsftyp *WITH;

  WITH = user[unr]->binsfptr;
  sfclose(&WITH->wchan);
  WITH->blockcounter = 0;
  boxsetrwmode(user[unr]->pchan, 0);
  add_bpacksf(unr);
}


/* Hier kommen die Daten von FBB an */

void fbb2pack2(short unr, unsigned short infosize, unsigned short *infstart,
	       uchar *info)
{
  unsigned short isize;
  long count;
  short oinfs, mode;
  binsftyp *WITH;

  debug0(4, unr, 84);
  if (!boxrange(unr)) {
    *infstart = SHORT_MAX;
    return;
  }
  if (user[unr]->binsfptr == NULL)
    return;
  WITH = user[unr]->binsfptr;
  count = statclock();
  oinfs = *infstart;
  box_ttouch(unr);
  isize = infosize - *infstart + 1;

  if (isize > 0) {
    mode = user[unr]->fwdmode;

    if (WITH->blockcounter == 0) {
      if (info[*infstart - 1] == 2) {
	WITH->blockcrc = 0;
	WITH->validbytes = WITH->rxbytes;
	if (isize > 1) {
	  WITH->blockcounter = info[*infstart];
	  if (WITH->blockcounter == 0)
	    WITH->blockcounter = 256;
	  *infstart += 2;
	  put_data(unr, infosize, infstart, info);
	  if (*infstart == SHORT_MAX)
	    return;
	} else {
	  WITH->blockcounter = bcmagic1;
	  (*infstart)++;
	}
      } else if (info[*infstart - 1] == 4) {
	if (isize > 1) {
	  if (mode == 2) {
	    if (isize > 2) {
	      WITH->crc2 = 0;
	      WITH->crc2 = info[*infstart + 1];
	      WITH->crc2 = (WITH->crc2 << 8) + info[*infstart];
	      if (WITH->crcsum == WITH->crc2)
		WITH->checksum = 0;
	      else
		WITH->checksum = 1;
	      *infstart += 3;
	      add_it(unr);
	    } else {
	      WITH->crc2 = 0;
	      WITH->crc2 = info[*infstart];
	      *infstart += 2;
	      WITH->blockcounter = bcmagic3;
	    }
	  } else {
	    WITH->checksum = (WITH->checksum + info[*infstart]) & 0xff;
	    *infstart += 2;
	    add_it(unr);
	  }
	} else {
	  WITH->blockcounter = bcmagic2;
	  (*infstart)++;
	}
      } else {
	*infstart = SHORT_MAX;
	abort_sf(unr, false, "invalid block identifier");
	return;
      }


    } else if (WITH->blockcounter == bcmagic1) {
      WITH->blockcounter = info[*infstart - 1];
      if (WITH->blockcounter == 0)
	WITH->blockcounter = 256;
      (*infstart)++;
      put_data(unr, infosize, infstart, info);
      if (*infstart == SHORT_MAX)
	return;
    } else if (WITH->blockcounter == bcmagic2) {
      if (mode == 2) {
	WITH->crc2 = 0;
	WITH->crc2 = info[*infstart];
	WITH->crc2 = (WITH->crc2 << 8) + info[*infstart - 1];
	if (WITH->crcsum == WITH->crc2)
	  WITH->checksum = 0;
	else
	  WITH->checksum = 1;
	(*infstart)++;
	(*infstart)++;
	add_it(unr);
      } else {
	WITH->checksum = (WITH->checksum + info[*infstart - 1]) & 0xff;
	(*infstart)++;
	add_it(unr);

      }
    } else if (WITH->blockcounter == bcmagic3) {
      WITH->crc2 += info[*infstart - 1] << 8;
      if (WITH->crcsum == WITH->crc2)
	WITH->checksum = 0;
      else
	WITH->checksum = 1;
      (*infstart)++;
      add_it(unr);
    } else if (WITH->blockcounter == bcmagic4) {
      if (isize > 1) {
	WITH->crc2 = 0;
	WITH->crc2 = info[*infstart];
	WITH->crc2 = (WITH->crc2 << 8) + info[*infstart - 1];
	if (WITH->crc2 != WITH->blockcrc) {
	  *infstart = SHORT_MAX;
	  abort_sf(unr, false, "invalid block crc (1)");
	  return;
	}
	WITH->blockcounter = 0;
	WITH->blockcrc = 0;
	*infstart += 2;
      } else {
	WITH->crc2 = 0;
	WITH->crc2 = info[*infstart - 1];
	(*infstart)++;
	WITH->blockcounter = bcmagic5;
      }
    } else if (WITH->blockcounter == bcmagic5) {
      WITH->crc2 += info[*infstart - 1] << 8;
      if (WITH->crc2 != WITH->blockcrc) {
	*infstart = SHORT_MAX;
	abort_sf(unr, false, "invalid block crc (2)");
	return;
      }
      WITH->blockcounter = 0;
      WITH->blockcrc = 0;
      (*infstart)++;
    } else {
      put_data(unr, infosize, infstart, info);
      if (*infstart == SHORT_MAX)
	return;
    }

  }
  upd_statistik(unr, *infstart - oinfs, 0, count, statclock());
}


/* Schaut nach, ob das ein abgebrochener S&F war, ob der im FBB/DP - Resume -*/
/* Modus war, ob da mehr als 250 gueltige Daten gesendet wurden und legt     */
/* dann einen Pointer mit den entsprechenden Daten zum Wiederaufnehmen des   */
/* s&f an nachdem die empfangenen Daten gesichert worden sind                */

void check_frag_sf(short unr)
{
  resumemem *hr;
  Char hfragname[256];
  userstruct *WITH;
  binsftyp *WITH1;

  debug0(3, unr, 85);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (!WITH->f_bbs)
    return;
  if (!((unsigned)WITH->fwdmode < 32 && ((1L << WITH->fwdmode) & 0x38) != 0))
    return;
  if (WITH->binsfptr == NULL)
    return;
  WITH1 = WITH->binsfptr;
  if (WITH1->wchan < minhandle)
    return;
  sfclose(&WITH1->wchan);
  if (WITH1->validbytes > 500) {
    WITH1->validbytes -= 500;
    hr = Malloc(sizeof(resumemem));
    if (hr != NULL) {
      /* Eventuell vorhandenes altes Resume-Fragment   */
      /* loeschen, gleichfalls den Pointer im Speicher */
      del_resume(WITH->resumebid, WITH->call);
      sprintf(hfragname, "%sresume%c001", boxstatdir, extsep);
      validate(hfragname);
      filecut(WITH1->wname, hfragname, 0, WITH1->validbytes);
      del_path(hfragname);
      cut(WITH->resumebid, 12);
      strcpy(hr->rbid, WITH->resumebid);
      strcpy(hr->rcall, WITH->call);
      cut(hfragname, 12);
      strcpy(hr->rfname, hfragname);
      hr->rsize = WITH1->validbytes;
      hr->rdate = clock_.ixtime;
      hr->next = NULL;
      if (resume_root != NULL) {
	hr->next = resume_root->next;
	resume_root->next = hr;
      } else
	resume_root = hr;
      write_resume();
    }

  }
  sfdelfile(WITH1->wname);
}


void abort_sf(short unr, boolean immediate, Char *txt)
{
  Char STR1[256];
  userstruct *WITH;

  debug(1, unr, 86, txt);
  if (*txt != '\0') {
    sprintf(STR1, "S&F: %s", txt);
    boxprotokoll(STR1);
  }
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  sfclosedel(&WITH->sendchan);
  if (!immediate) {
    if (*txt != '\0')
      wlnuser(unr, txt);
    boxspoolread();
  } else
    abort_useroutput(unr);
  WITH->action = 15;   /* ABORT */
}


Static void sfproterr2(short unr)
{
  abort_sf(unr, false, "***error");
}


void sfproterr(short unr)
{
  abort_sf(unr, true, "unexpected answer");
}


sfdeftype *find_sf_pointer(Char *call)
{
  sfdeftype *sftptr;
  boolean found;

  found = false;
  sftptr = sfdefs;
  while (sftptr != NULL && !found) {
    found = (strcmp(sftptr->call, call) == 0);
    if (!found)
      sftptr = sftptr->next;
  }
  if (found)
    return sftptr;
  return NULL;
}


Static long calc_aclock(void)
{
  long h, m, s;

  utc_clock();   /* Uhr stellen */
  h = clock_.hour;
  m = clock_.min;
  s = clock_.sec;
  return (h * 3600 + m * 60 + s);
}


Static void set_sf_timer(boolean routing, Char *call)
{
  sfdeftype *sftptr;

  sftptr = find_sf_pointer(call);
  if (sftptr == NULL)
    return;
  sftptr->lasttry = calc_aclock();
  if (routing)
    sftptr->in_routing = true;
}


/* Der Box wird vom Packet-Router mitgeteilt, dass der Connectversuch    */
/* erfolglos verlief bzw. beendet ist, da er zustande gekommen ist       */

void abort_routing(Char *call_)
{
  Char call[256];
  sfdeftype *sftptr;

  strcpy(call, call_);
  if (strpos2(call, "-", 1) > 0)
    cut(call, strpos2(call, "-", 1) - 1);
  sftptr = find_sf_pointer(call);
  if (sftptr != NULL)
    sftptr->in_routing = false;
}


void kill_all_routing_flags(void)
{
  sfdeftype *sftptr;

  sftptr = sfdefs;
  while (sftptr != NULL) {
    sftptr->in_routing = false;
    sftptr = sftptr->next;
  }

  load_boxbcastparms(bcast_box);
}


Static void unr_and_protokoll(short unr, Char *s_)
{
  Char s[256];

  strcpy(s, s_);
  debug(1, unr, 87, s);
  if (unr > 0)
    wlnuser(unr, s);
  boxprotokoll(s);
}


Static void start_file_forward(short unr, Char *call, Char *fname)
{
  unr_and_protokoll(unr, "opening forward to file");
}


void start_sf(short unr, Char *call_, Char *parameter_)
{
  Char call[256], parameter[256];
  Char hs[256];
  sfcpathtype *hp;
  Char w[256];
  boolean fchk;
  Char fpath[256];
  boolean tofile;
  Char qrgstr[256];
  short outtnc, k;
  sfdeftype *sfp;
  Char STR7[256];

  strcpy(call, call_);
  strcpy(parameter, parameter_);
  debug(2, unr, 88, call);
  fchk = false;
  upper(call);
  cut(call, 6);
  *qrgstr = '\0';
  tofile = false;
  outtnc = -1;
  *fpath = '\0';

  sfp = find_sf_pointer(call);
  if (sfp != NULL) {
    if (sfp->in_routing) {
      get_btext(unr, 125, w);
      sprintf(w, "%s: %s", call, strcpy(STR7, w));
      unr_and_protokoll(unr, w);

      return;
    }
    for (k = 1; k <= 2; k++) {
      get_word(parameter, hs);
      if (*hs != '\0') {
	if (hs[0] == '#') {
	  if (hs[1] >= '0' && hs[1] <= '3')
	    outtnc = hs[1] - '0';
	} else {
	  fchk = true;
	  strcpy(qrgstr, hs);
	}
      }
    }

    hp = sfp->cpathp;
_L1:
    while (hp != NULL) {
      if (fchk) {
	if (strcmp(hp->qrg, qrgstr)) {
	  hp = hp->next;
	  goto _L1;
	}
      }
      if (!strcmp(hp->qrg, "FILE")) {
	tofile = true;
	fchk = true;
	strcpy(fpath, hp->conpath);
	goto _L2;
      }
      if (find_socket(hp->qrg, &outtnc)) {
	fchk = true;
	strcpy(fpath, hp->conpath);
	goto _L2;
      }
      hp = hp->next;
    }
  }

_L2:
  if (!(fchk && *fpath != '\0')) {
    sprintf(STR7, "%s: no path found", call);
    unr_and_protokoll(unr, STR7);
    return;
  }
  sprintf(STR7, "S&F: %s", fpath);
  unr_and_protokoll(unr, STR7);
  if (tofile) {
    set_sf_timer(false, call);
    start_file_forward(unr, call, fpath);
    return;
  }
  if (boxpboxsf(outtnc, sf_connect_call, fpath))
    set_sf_timer(true, call);
  else {
    sprintf(STR7, "%s: cannot open connection", call);
    unr_and_protokoll(unr, STR7);
  }
}


Static short total_connects(Char *call)
{
  short i, x;

  i = 0;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, call))
	i++;
    }
  }
  return i;
}


Static long last_sftimer;


void check_sftimer(void)
{
  sfdeftype *sftptr;
  long aclock, ival, ival2, zsum1, zsum2;
  boolean has_mail, try, try1, try2;
  short x;
  Char w[256];
  boolean tcheck;
  sfdeftype *WITH;

  aclock = calc_aclock();
  if (labs(aclock - last_sftimer) <= 30)
    return;
  debug0(4, 0, 125);
  last_sftimer = aclock;
  has_mail = false;
  sftptr = sfdefs;

  while (sftptr != NULL) {
    WITH = sftptr;
    try = true;
    x = 1;
    while (x <= maxuser && try) {  /* Box schon eingeloggt? */
      if (user[x] != NULL) {
	if (user[x]->f_bbs) {
	  if (!strcmp(user[x]->call, WITH->call)) {
	    if (user[x]->sf_level >= 3) {
	      try = (total_connects(WITH->call) < 2 &&
		     clock_.ixtime - user[x]->lastcmdtime >= sftimeout * 60);
	      goto _L1;
	    }
	    if (user[x]->sf_to)
	      try = false;
	  }
	}
      }
      x++;
    }

_L1:
    if (try) {
      ival = WITH->intervall * 60;
      ival2 = WITH->pollifnone * 60;
      if (WITH->startutc < WITH->endutc)
	tcheck = (aclock >= WITH->startutc && aclock <= WITH->endutc);
      else
	tcheck = (aclock <= WITH->endutc || aclock >= WITH->startutc);

      if (tcheck && !WITH->in_routing) {
	try1 = false;
	try2 = false;
	if ((ival > 0 || ival2 > 0) && WITH->bedingung > 0) {
	  if (WITH->intervall == 1)
	    try1 = (WITH->bedingung < 32 &&
		    ((1L << WITH->bedingung) & 0x6) != 0);
		/* sofort forwarden */
	  else {
	    if (WITH->lasttry > aclock)
	      zsum1 = WITH->lasttry + ival - 86400L;
	    else
	      zsum1 = WITH->lasttry + ival;
	    if (zsum1 <= aclock)
	      try1 = (WITH->bedingung < 32 &&
		      ((1L << WITH->bedingung) & 0x6) != 0);
	  }

	  if (WITH->lasttry > aclock)
	    zsum2 = WITH->lasttry + ival2 - 86400L;
	  else
	    zsum2 = WITH->lasttry + ival2;
	  if (zsum2 <= aclock)
	    try2 = (WITH->bedingung == 2);

	  if (try1 || try2) {
	    has_mail = sf_for(WITH->call);
	    if (has_mail || try2)
	      WITH->lasttry = aclock;
	    else if (WITH->bedingung < 2)
	      WITH->lasttry = aclock;
	    try = (has_mail && try1 || try2);
	  } else
	    try = false;

	  if (try) {
	    if (WITH->bedingung == 1)
	      try = has_mail;
	    if (try) {
	      *w = '\0';
	      start_sf(-1, WITH->call, w);
	    }
	  }
	}

      }
    } else if (WITH->in_routing)
      WITH->lasttry = aclock;
    sftptr = sftptr->next;
  }

  release_sf_for();
}


void set_sftimer(Char *box, short min, short stnc, short sfcase, long maxb,
		 long maxu, long maxp, long pifnone, long sutc, long eutc)
{
  sfdeftype *sfptr;

  sfptr = find_sf_pointer(box);
  if (sfptr == NULL)
    return;

  if (sfptr->maxbytes_p == 0) {
    sfptr->intervall = 0;
    sfptr->pollifnone = 0;
    sfptr->tnc = 0;
    sfptr->bedingung = 0;
    sfptr->maxbytes_b = 20000;
    sfptr->maxbytes_p = 20000;
    sfptr->maxbytes_u = 20000;
    sfptr->lasttry = calc_aclock();
    sfptr->startutc = 0;
    sfptr->endutc = 86399L;
    sfptr->in_routing = false;
  }
  if (min >= 0)
    sfptr->intervall = min;
  if (stnc >= 0)
    sfptr->tnc = stnc;
  if (sfcase >= 0)
    sfptr->bedingung = sfcase;
  if (maxb >= 0)
    sfptr->maxbytes_b = maxb;
  if (maxu >= 0)
    sfptr->maxbytes_u = maxu;
  if (maxp >= 0)
    sfptr->maxbytes_p = maxp;
  if (pifnone >= 0)
    sfptr->pollifnone = pifnone;
  if (sutc >= 0)
    sfptr->startutc = sutc;
  if (eutc >= 0)
    sfptr->endutc = eutc;

  if (sfptr->tnc > 3)
    sfptr->tnc = 0;
  if (sfptr->startutc > 86399L)
    sfptr->startutc = 0;
  if (sfptr->endutc > 86399L)
    sfptr->endutc = 86399L;
  if (sfptr->bedingung > 2)
    sfptr->bedingung = 0;
  if (sfptr->bedingung <= 0) {
    sfptr->bedingung = 0;
    return;
  }
  if (sfptr->intervall < 1)
    sfptr->intervall = 1;
  if (sfptr->pollifnone == 0)
    sfptr->bedingung = 1;
  if (sfptr->bedingung == 2) {
    if (sfptr->pollifnone < 5)
      sfptr->pollifnone = 5;
  }

}


Static long gwli(Char *h)
{
  Char w[256];

  get_word(h, w);
  return (str2lint(w));
}


Static short gwi(Char *h)
{
  return (gwli(h));
}


Static long gwutc(Char *h)
{
  Char w[256], w2[256];
  long hl, erg;

  get_word(h, w);
  if (zahl(w) && strlen(w) == 4) {
    sprintf(w2, "%.2s", w);
    hl = str2lint(w2);
    strsub(w2, w, 3, 2);
    erg = str2lint(w2);
    return ((hl * 60 + erg) * 60);
  } else
    return -1;
}


void set_sfparms(Char *box, Char *hs_)
{
  Char hs[256];
  Char w[256], w2[256];
  short min, tnc, sfcase;
  long pifnone, sutc, eutc, hl, maxb, maxu, maxp;
  short which;
  long val;
  short wc;

  strcpy(hs, hs_);
  wc = count_words(hs);
  if ((unsigned)wc < 32 && ((1L << wc) & 0x240) != 0) {
    min = gwi(hs);
    tnc = gwi(hs);
    sfcase = gwi(hs);
    if (sfcase > 2)
      sfcase = 0;
    maxb = gwli(hs);
    maxu = gwli(hs);
    maxp = gwli(hs);
    pifnone = gwli(hs);
    sutc = gwutc(hs);
    eutc = gwutc(hs);
    set_sftimer(box, min, tnc, sfcase, maxb, maxu, maxp, pifnone, sutc, eutc);
    return;
  }
  if (wc != 2) {
    set_sftimer(box, -1, -1, -1, -1, -1, -1, -1, -1, -1);
    return;
  }
  get_word(hs, w);
  if (!zahl(w))
    return;
  which = Str2int(w);
  if ((unsigned)which >= 32 || ((1L << which) & 0x3fe) == 0)
    return;
  get_word(hs, w);
  if (!zahl(w))
    return;
  val = str2lint(w);
  maxb = -1;
  maxu = -1;
  maxp = -1;
  sfcase = -1;
  min = -1;
  tnc = -1;
  pifnone = -1;
  sutc = -1;
  eutc = -1;
  switch (which) {

  case 1:
    min = val;
    break;

  case 2:
    tnc = val;
    break;

  case 3:
    sfcase = val;
    break;

  case 4:
    maxb = val;
    break;

  case 5:
    maxu = val;
    break;

  case 6:
    maxp = val;
    break;

  case 7:
    pifnone = val;
    break;

  case 8:
  case 9:
    if (zahl(w) && strlen(w) == 4) {
      sprintf(w2, "%.2s", w);
      hl = str2lint(w2);
      strsub(w2, w, 3, 2);
      val = str2lint(w2);
      val = (hl * 60 + val) * 60;
      if (which == 8)
	sutc = val;
      else
	eutc = val;
    }
    break;
  }
  set_sftimer(box, min, tnc, sfcase, maxb, maxu, maxp, pifnone, sutc, eutc);
}


Static void form_utc(long time, Char *out)
{
  Char ts1[256], ts2[256];
  Char STR1[256];

  time /= 60;
  sprintf(ts2, "%ld", time % 60);
  if (strlen(ts2) < 2)
    sprintf(ts2, "0%s", strcpy(STR1, ts2));
  sprintf(ts1, "%ld", time / 60);
  if (strlen(ts1) < 2)
    sprintf(ts1, "0%s", strcpy(STR1, ts1));
  sprintf(out, "%s%s", ts1, ts2);
}


Static void form_nextutc(long time, long start, long ende, Char *out)
{
  if (time > 86400L)
    time -= 86400L;
  if (start < ende) {
    if (time > ende || time < start)
      time = start;
  } else {  /* start ist groesser als ende... ,zb s&f von 2200-0400 */
    if (time > ende && time < start)
      time = start;
  }
  form_utc(time, out);
}


Static void add_hs(long v, short spc, short blanks, Char *hs)
{
  Char w[256];
  short x;

  sprintf(w, "%ld", v);
  lspacing(w, spc);
  strcat(hs, w);
  for (x = 1; x <= blanks; x++)
    strcat(hs, " ");
}


void show_sfparms(short unr, Char *box)
{
  sfdeftype *sfptr;
  sfcpathtype *cp1;
  boolean ok;
  Char hs[256];
  Char sutcs[256], eutcs[256], nutcs[256];
  sfdeftype *WITH;

  upper(box);
  ok = false;
  sfptr = sfdefs;
  while (sfptr != NULL) {
    WITH = sfptr;
    if (*box == '\0' || !strcmp(WITH->call, box)) {
      switch (WITH->bedingung) {

      case 1:
	if (sf_for(WITH->call))
	  form_nextutc(WITH->lasttry + WITH->intervall * 60 + 60,
		       WITH->startutc, WITH->endutc, nutcs);
	else
	  strcpy(nutcs, "-");
	break;

      case 2:
	if (sf_for(WITH->call))
	  form_nextutc(WITH->lasttry + WITH->intervall * 60 + 60,
		       WITH->startutc, WITH->endutc, nutcs);
	else
	  form_nextutc(WITH->lasttry + WITH->pollifnone * 60 + 60,
		       WITH->startutc, WITH->endutc, nutcs);
	break;

      default:
	strcpy(nutcs, "-");
	break;
      }
      form_utc(WITH->startutc, sutcs);
      form_utc(WITH->endutc, eutcs);
      if (!ok)
	wlnuser(unr,
	  "Box  1:Min 2:TNC 3:if 4:Info 5:User 6:Proposals 7:Min2 8:sUTC 9:eUTC Next");
      ok = true;

      strcpy(hs, WITH->call);
      rspacing(hs, 6);
      add_hs(WITH->intervall, 3, 3, hs);
      add_hs(WITH->tnc, 3, 3, hs);
      add_hs(WITH->bedingung, 2, 1, hs);
      add_hs(WITH->maxbytes_b, 6, 1, hs);
      add_hs(WITH->maxbytes_u, 6, 5, hs);
      add_hs(WITH->maxbytes_p, 6, 2, hs);
      add_hs(WITH->pollifnone, 3, 5, hs);
      sprintf(hs + strlen(hs), "%s   %s   %s", sutcs, eutcs, nutcs);
      if (WITH->in_routing)
	strcat(hs, " *");
      cp1 = WITH->cpathp;
      while (cp1 != NULL) {
	if (!strcmp(cp1->qrg, "FILE")) {
	  strcat(hs, " !");
	  cp1 = NULL;
	} else
	  cp1 = cp1->next;
      }
      wlnuser(unr, hs);
    }
    sfptr = sfptr->next;
  }
  if (!ok)
    wln_btext(unr, 45);
  release_sf_for();
}


void dispose_sfinfos(void)
{
  sfdeftype *hp;
  sfcpathtype *cp1, *cp2;
  sffortype *fp1, *fp2;
  sfrubtype *rp1, *rp2;
  sfnotfromtype *nf1, *nf2;

  debug0(2, 0, 135);
  while (sfdefs != NULL) {
    hp = sfdefs;
    sfdefs = sfdefs->next;

    cp1 = hp->cpathp;
    while (cp1 != NULL) {
      cp2 = cp1;
      cp1 = cp1->next;
      Free(cp2);
    }

    fp1 = hp->forp;
    while (fp1 != NULL) {
      fp2 = fp1;
      fp1 = fp1->next;
      Free(fp2);
    }

    fp1 = hp->notforp;
    while (fp1 != NULL) {
      fp2 = fp1;
      fp1 = fp1->next;
      Free(fp2);
    }

    rp1 = hp->rubrikp;
    while (rp1 != NULL) {
      rp2 = rp1;
      rp1 = rp1->next;
      Free(rp2);
    }

    rp1 = hp->notrubrikp;
    while (rp1 != NULL) {
      rp2 = rp1;
      rp1 = rp1->next;
      Free(rp2);
    }

    nf1 = hp->notfromp;
    while (nf1 != NULL) {
      nf2 = nf1;
      nf1 = nf1->next;
      Free(nf2);
    }

    Free(hp);
  }

  sfdefs = NULL;
}


void load_sfinfos(void)
{
  short k;
  DTA dirinfo;
  short result;
  sfdeftype *hp, *hp2;
  sfcpathtype *cp1;
  sffortype *fp1;
  sfrubtype *rp1;
  sfnotfromtype *nf1;
  Char hs[256], w[256];
  boolean ok;
  Char lastcall[7];
  Char sfps[256];
  Char STR1[256];

  dispose_sfinfos();
  debug0(2, 0, 90);

  hp2 = NULL;
  sprintf(STR1, "%s%c%csf", boxsfdir, allquant, extsep);
  result = sffirst(STR1, 0, &dirinfo);
  while (result == 0) {
    ok = false;
    *sfps = '\0';

    hp = Malloc(sizeof(sfdeftype));
    if (hp != NULL) {
      hp->next = NULL;

      hp->forp = NULL;
      hp->notforp = NULL;
      hp->rubrikp = NULL;
      hp->notrubrikp = NULL;
      hp->notfromp = NULL;

      hp->cpathp = NULL;

      strcpy(hs, dirinfo.d_fname);
      del_ext(hs);
      cut(hs, 6);
      upper(hs);
      strcpy(hp->call, hs);
      strcpy(lastcall, hs);

      hp->maxbytes_p = 0;   /* ist ein Flag */

      sprintf(STR1, "%s%s", boxsfdir, dirinfo.d_fname);
      k = sfopen(STR1, FO_READ);
      if (k >= minhandle) {
	ok = true;

	while (file_to_string(k, hs)) {
	  del_blanks(hs);
	  if (*hs == '\0' || hs[0] == '#')
	    continue;
	  upper(hs);
	  get_word(hs, w);

	  if (*hs == '\0')
	    continue;

	  if (!strcmp(w, "IFQRG")) {
	    cp1 = Malloc(sizeof(sfcpathtype));
	    if (cp1 == NULL)
	      continue;
	    get_word(hs, w);
	    cut(w, 20);
	    strcpy(cp1->qrg, w);
	    strcpy(cp1->conpath, hs);   /* timeout bei Linux, bzw. filename */
	    cp1->next = hp->cpathp;
	    hp->cpathp = cp1;
	    continue;
	  }

	  if (!strcmp(w, "SFPARMS")) {
	    strcpy(sfps, hs);

	    continue;
	  }
	  if (!strcmp(w, "FOR")) {
	    while (*hs != '\0') {
	      fp1 = Malloc(sizeof(sffortype));
	      if (fp1 == NULL)
		continue;
	      get_word(hs, w);
	      cut(w, 40);
	      strcpy(fp1->pattern, w);
	      fp1->next = hp->forp;
	      hp->forp = fp1;
	    }
	    continue;
	  }

	  if (!strcmp(w, "NOT") || !strcmp(w, "NOTFOR")) {
	    while (*hs != '\0') {
	      fp1 = Malloc(sizeof(sffortype));
	      if (fp1 == NULL)
		continue;
	      get_word(hs, w);
	      cut(w, 40);
	      strcpy(fp1->pattern, w);
	      fp1->next = hp->notforp;
	      hp->notforp = fp1;
	    }
	    continue;
	  }

	  if (!strcmp(w, "RUBRIK")) {
	    while (*hs != '\0') {
	      rp1 = Malloc(sizeof(sfrubtype));
	      if (rp1 == NULL)
		continue;
	      get_word(hs, w);
	      cut(w, 8);

	      strcpy(rp1->pattern, w);
	      rp1->next = hp->rubrikp;
	      hp->rubrikp = rp1;

	    }
	    continue;
	  }

	  if (!strcmp(w, "NOTRUBRIK")) {
	    while (*hs != '\0') {
	      rp1 = Malloc(sizeof(sfrubtype));
	      if (rp1 == NULL)
		continue;
	      get_word(hs, w);
	      cut(w, 8);
	      strcpy(rp1->pattern, w);
	      rp1->next = hp->notrubrikp;
	      hp->notrubrikp = rp1;
	    }
	    continue;
	  }

	  if (strcmp(w, "NOTFROM"))
	    continue;
	  while (*hs != '\0') {
	    nf1 = Malloc(sizeof(sfnotfromtype));
	    if (nf1 == NULL)
	      continue;
	    get_word(hs, w);
	    cut(w, 6);
	    strcpy(nf1->pattern, w);
	    nf1->next = hp->notfromp;
	    hp->notfromp = nf1;
	  }
	}

	sfclose(&k);

	if (hp2 == NULL) {
	  hp2 = hp;
	  sfdefs = hp;
	} else {
	  hp2->next = hp;
	  hp2 = hp;
	}
      } else
	Free(hp);

    }

    if (ok)
      set_sfparms(lastcall, sfps);

    result = sfnext(&dirinfo);
  }


}


/* Diese Routine durchsucht die S&F-DEFINITIONEN auf Gueltigkeit zu den aktuellen    */
/* Parametern einer Nachricht. Wenn look_FOR false ist, dann wird nur getestet, ob die aktuelle  */
/* Nachricht auf gar keinen Fall an den entsprechenden Partner zu senden ist. Dies ist notwendig */
/* im Zusammenhang mit dem automatischen Router, welcher immer dann in Aktion tritt, wenn die fest*/
/* vorgegebenen Definitionen keine Partnerbox fuer eine Zielmailbox angeben.         */

Static boolean check_sfdeffile(boolean look_FOR, boolean only_rubrik,
  sfdeftype *sfp, Char *rubrik, Char *mbx, Char *hiermbx, Char *frombox,
  Char *bid, boolean *rubrik_transfer, Char *lastvias)
{
  boolean Result, ok;
  Char s[256];
  short k;
  sffortype *fp1;
  sfrubtype *rp1;
  sfnotfromtype *nf1;

  *rubrik_transfer = false;
  Result = false;
  if (sfp == NULL)
    return Result;

  debug(5, -1, 149, sfp->call);

  k = strpos2(lastvias, sfp->call, 1);
      /* lief das BULLETIN schon ueber diese Partnerbox ? */
  if (k > 0) {
    if (lastvias[k + strlen(sfp->call) - 1] == ' ')
      return false;
  }

  s[0] = '\0';

  if (!only_rubrik) {
    if (look_FOR) {
      ok = (strcmp(sfp->call, mbx) == 0);   /* @zielbox ist immer gueltig */

      if (strcmp(mbx, Console_call) || !strcmp(sfp->call, Console_call)) {
	fp1 = sfp->forp;
	while (fp1 != NULL && !ok) {
	  ok = wildcardcompare(SHORT_MAX, fp1->pattern, mbx, s);
	  fp1 = fp1->next;
	}

	if (*hiermbx != '\0' && !ok) {
	  fp1 = sfp->forp;
	  while (fp1 != NULL && !ok) {
	    ok = wildcardcompare(SHORT_MAX, fp1->pattern, hiermbx, s);
	    fp1 = fp1->next;
	  }
	}

      }


    } else
      ok = true;

    fp1 = sfp->notforp;
    while (fp1 != NULL && ok) {
      ok = !wildcardcompare(SHORT_MAX, fp1->pattern, mbx, s);
      fp1 = fp1->next;
    }

    if (*hiermbx != '\0' && ok) {
      fp1 = sfp->notforp;
      while (fp1 != NULL && ok) {
	ok = !wildcardcompare(SHORT_MAX, fp1->pattern, hiermbx, s);
	fp1 = fp1->next;
      }
    }

    rp1 = sfp->notrubrikp;
    while (rp1 != NULL && ok) {
      ok = !wildcardcompare(SHORT_MAX, rp1->pattern, rubrik, s);
      rp1 = rp1->next;
    }

    if (!callsign(mbx)) {
      nf1 = sfp->notfromp;
      while (nf1 != NULL && ok) {
	ok = !wildcardcompare(SHORT_MAX, nf1->pattern, frombox, s);
	nf1 = nf1->next;
      }
    }

  } else
    ok = false;


  rp1 = sfp->rubrikp;
  while (rp1 != NULL && !ok) {
    ok = wildcardcompare(SHORT_MAX, rp1->pattern, rubrik, s);
    rp1 = rp1->next;
    if (ok) {
      if (callsign(mbx))
	*rubrik_transfer = true;
    }
  }

  if (ok && strcmp(sfp->call, Console_call)) {
    if (strlen(sfp->call) == 6)
      ok = (strpos2(bid, sfp->call, 1) == 0);
    /* bei kurzen BoxCalls kann man diesen Test nicht machen ... */
  }

  return ok;
}


Static boolean valid_partner(Char *box, Char *rubrik, Char *mbx,
			     Char *hiermbx, Char *frombox, Char *bid)
{
  boolean ok, db;
  sfdeftype *sfp;

  debug(5, -1, 148, box);
  sfp = find_sf_pointer(box);
  if (sfp != NULL) {
    ok = check_sfdeffile(false, false, sfp, rubrik, mbx, hiermbx, frombox,
			 bid, &db, "");
    return ok;
  }
  if (strcmp(box, Console_call) && strlen(box) == 6)
    ok = (strpos2(bid, box, 1) == 0);
  else  /* bei kurzen BoxCalls kann man diesen Test nicht machen ... */
    ok = true;
  return ok;
}


/* vermerke_sf gibt nun auch Informationen ueber die gefundenen Wege an den  */
/* User aus. Da dies schon bei Beginn der Eingabe (also direkt nach Eingabe  */
/* des SEND-Befehles) passieren soll, gibt es einen quasi zweigeteilten      */
/* Modus: einmal wird vermerke_sf mit gesetztem Flag routtest aufgerufen     */
/* (zu Beginn), dabei wird NUR der Router getestet und die Informationen     */
/* ausgegeben, dann wird NACH dem CTRL-Z nochmal vermerke_sf aufgerufen,     */
/* diesmal allerdings ohne unr_msg, was dazu fuehrt, dass nichts ausgegeben  */
/* wird, aber geroutet wird, da routtest = false ist.                        */

Static void new_sfentry(indexstruct *xheader)
{
  Char index[256];
  short k2;
  unsigned short acc;
  Char ziel[9];

  debug0(5, -1, 140);
  strcpy(ziel, "X");
  sprintf(index, "%sX%c%s", indexdir, extsep, idx_e);
  if (exist(index)) {
    k2 = sfopen(index, FO_RW);
    sfseek(0, k2, SFSEEKEND);   /* ans Ende der Datei */
  } else
    k2 = sfcreate(index, FC_FILE);
  if (k2 < minhandle)
    return;
  xheader->deleted = false;
  xheader->start = 0;

  if (xheader->rxdate == 0)
    xheader->rxdate = clock_.ixtime;
  if (!callsign(xheader->rxfrom))
    xheader->rxfrom[0] = '\0';
  acc = 1;
  check_lt_acc(ziel, &xheader->lifetime, &acc);
  xheader->level = acc;

  xheader->erasetime = 0;
  xheader->lastread = 0;
  xheader->readcount = 0;
  *xheader->readby = '\0';
  xheader->eraseby = 0;
  *xheader->sendbbs = '\0';
  xheader->infochecksum = 0;
  xheader->bcastchecksum = 0;
  write_index(k2, -1, xheader);
  sfclose(&k2);
}


Static void set_fwd(short unr_msg, indexstruct header1, short *routct,
		    boolean routtest, boolean rubrik_transfer,
		    boolean spec_sf, Char *to_box, Char *rubrik)
{
  Char w[256];
  indexstruct header;

  debug0(5, unr_msg, 139);
  if (!routtest) {
    header = header1;
    if (header.msgtype == '\0')
      check_msgtype(&header.msgtype, header.dest, header.betreff);
    if (rubrik_transfer)
      strcpy(header.verbreitung, to_box);
    if (*header.verbreitung != '\0') {
      upper(header.verbreitung);
      strcpy(header.dest, to_box);
      header.fwdct = 0;
      strcpy(header.betreff, rubrik);
      if (strlen(rubrik) == 1 && (rubrik[0] == 'M' || rubrik[0] == 'E')) {
	header.pmode = 4;
	sprintf(header.betreff + strlen(header.betreff), " %s",
		header1.betreff);
      } else if (header.msgtype == 'P')
	header.pmode = 1;
      else
	header.pmode = 2;
      if (spec_sf || rubrik_transfer)
	header.pmode |= 8;
      if ((header1.pmode & TBIN) != 0)
	header.pmode |= TBIN;
      else if ((header1.pmode & T7PLUS) != 0)
	header.pmode |= T7PLUS;
      new_sfentry(&header);
    }
  }

  if (!boxrange(unr_msg))
    return;

  if (*routct == 0)
    wuser(unr_msg, "Routing  : ");
  (*routct)++;
  if (*routct % 7 == 0) {
    wlnuser0(unr_msg);
    wuser(unr_msg, "         ");
  }
  strcpy(w, to_box);
  if (ring_bbs && !strcmp(w, Console_call)) {
    strcat(w, " (swap)");
    rspacing(w, 14);
    (*routct)++;
  } else
    rspacing(w, 7);
  wuser(unr_msg, w);
}


Static void check_if_err(short unr_msg, Char *rubrik, Char *mbx,
			 boolean routtest, indexstruct header1, short routct,
			 uchar *ret)
{
  if (!(callsign(mbx) && strcmp(mbx, Console_call))) {
    *ret = 0;
    return;
  }
  *ret = MSG_SFNOFOUND;


  if (!routtest)
    routing_error(-1, '\0', header1, rubrik, "routing error");


  if (!boxrange(unr_msg))
    return;

  if (routct == 0)
    wuser(unr_msg, "routing error: ");
  wln_btext(unr_msg, 45);
}


unsigned short vermerke_sf(short unr_msg, boolean routtest, Char *rubrik,
			   Char *from_box, Char *to_box_, indexstruct header1,
			   Char *lastvias)
{
  unsigned short Result;
  Char to_box[256];
  Char hiermbx[256], mbx[256], w[256];
  Char hiermbx2[256], mbx2[256];
  boolean fout, fchk, rubrik_transfer, spec_sf, iscall, mirror, check_defs;
  boolean hierarchical_mess, was_local;
  Char box2[256];
  uchar ret;
  short k;
  sfdeftype *sfp;
  short routct;
  userstruct ufil;

  strcpy(to_box, to_box_);
  debug(3, unr_msg, 91, rubrik);
  routct = 0;
  ret = 0;
  fout = false;
  rubrik_transfer = false;
  hierarchical_mess = false;
  was_local = false;
  spec_sf = (strcmp(to_box, "*") && callsign(to_box));

  if (!spec_sf && to_box[0] == '!') {
    /*So kann man einem nicht definierten Partner Eintraege forwarden (mit FOR + )*/
    unhpath(header1.verbreitung, mbx);
    spec_sf = (!callsign(mbx) ||
	       !strcmp(mbx, Console_call) && header1.msgtype == 'P');
    strdelete((void *)to_box, 1, 1);
    if (callsign(to_box))
      set_fwd(unr_msg, header1, &routct, routtest, rubrik_transfer, spec_sf,
	      to_box, rubrik);
  } else {
    if (spec_sf) {
      unhpath(header1.verbreitung, w);
      spec_sf = (!callsign(w) ||
		 !strcmp(w, Console_call) && header1.msgtype == 'P' ||
		 header1.msgtype == 'B');
      strcpy(header1.verbreitung, to_box);
    }

    strcpy(mbx, header1.verbreitung);
    hiermbx[0] = '\0';
    k = strpos2(mbx, ".", 1);
    if (k > 0) {
      strsub(hiermbx, mbx, k, strlen(mbx) - k + 1);
      cut(mbx, k - 1);
    }
    cut(mbx, 6);

_L1:
    if (sfdefs != NULL) {
      iscall = callsign(mbx);
      was_local = iscall && !strcmp(mbx, Console_call);
      mirror = false;

      if (iscall && !strcmp(mbx, Console_call) && callsign(header1.dest)) {
	if (in_sfp(Console_call)) {
	  load_userfile(true, true, header1.dest, &ufil);
	  check_defs = !ufil.lock_here;
	  mirror = check_defs;
	} else
	  check_defs = false;
      } else
	check_defs = true;

      if (check_defs) {
	if (!(smart_routing && iscall) || mirror) {
	  sfp = sfdefs;
	  while (sfp != NULL) {
	    if (unr_msg == -77 || strcmp(from_box, sfp->call) ||
		ring_bbs && !strcmp(from_box, Console_call)) {
	      fchk = check_sfdeffile(true, false, sfp, rubrik, mbx, hiermbx,
				     from_box, header1.id, &rubrik_transfer,
				     lastvias);
	      if (fchk) {
		set_fwd(unr_msg, header1, &routct, routtest, rubrik_transfer,
			spec_sf, sfp->call, rubrik);
		fout = true;
	      }
	    }
	    sfp = sfp->next;
	  }
	}

	if (!fout && iscall && 
	    (callsign(header1.dest) || strcmp(Console_call, mbx))) {
	  find_neighbour(0, mbx, box2);
	  if (*box2 != '\0') {
	    if (unr_msg == -77 || strcmp(from_box, box2) ||
		ring_bbs && !strcmp(from_box, Console_call)) {
	      if (valid_partner(box2, rubrik, mbx, hiermbx, from_box,
				header1.id)) {
		set_fwd(unr_msg, header1, &routct, routtest, rubrik_transfer,
			spec_sf, box2, rubrik);
		fout = true;
	      }
	    }
	  }
	}

	if (!fout && smart_routing && iscall) {
	  sfp = sfdefs;
	  while (sfp != NULL) {
	    if (unr_msg == -77 || strcmp(from_box, sfp->call) ||
		ring_bbs && !strcmp(from_box, Console_call)) {
	      fchk = check_sfdeffile(true, false, sfp, rubrik, mbx, hiermbx,
				     from_box, header1.id, &rubrik_transfer,
				     lastvias);
	      if (fchk) {
		set_fwd(unr_msg, header1, &routct, routtest, rubrik_transfer,
			spec_sf, sfp->call, rubrik);
		fout = true;
	      }
	    }
	    sfp = sfp->next;
	  }
	}
	
	if (!fout && iscall && !was_local) { /* dg5lk.db0hes.#slh.deu.eu */
          strcpy(mbx2, hiermbx); /* hiermbx = .db0hes.#slh.deu.eu */
          hiermbx2[0] = '\0';
          k = strpos2(mbx2, ".", 1);
          if (k == 1) {
            strdelete(mbx2, 1, 1);
            k = strpos2(mbx2, ".", 1);
          }
          if (k > 0) {
            strsub(hiermbx2, mbx2, k, strlen(mbx2) - k + 1);
            cut(mbx2, k - 1);
          }
          cut(mbx2, 6);

	  if (callsign(mbx2)) {
	    if (strcmp(Console_call, mbx2)) {
	      strcpy(mbx, mbx2);
	      strcpy(hiermbx, hiermbx2);
	      goto _L1;
	    } else hierarchical_mess = true;
	  }
	}

	if (fout) {
	  if (iscall)
	    ret = MSG_SFWAIT;
	}
	else if (!hierarchical_mess)
	  check_if_err(unr_msg, rubrik, mbx, routtest, header1, routct, &ret);
      }

    } else
      check_if_err(unr_msg, rubrik, mbx, routtest, header1, routct, &ret);

  }

  Result = ret;

  if (routct > 0) {
    if (boxrange(unr_msg))
      wlnuser0(unr_msg);
  }

  debug(5, unr_msg, 91, "...done");
  return Result;
}


Static boolean gen_sftest3(short unr, Char *frombox, Char *board, Char *mbx)
{
  indexstruct header;

  strcpy(header.verbreitung, mbx);
  *header.id = '\0';
  strcpy(header.dest, board);
  *header.absender = '\0';
  *header.betreff = '\0';
  strcpy(header.rxfrom, frombox);
  header.deleted = false;
  header.pmode = TTEXT;
  header.msgflags = MSG_SFRX;
  *header.readby = '\0';
  *header.sendbbs = '\0';

  if (callsign(board))
    header.msgtype = 'P';
  else
    header.msgtype = 'B';

  return (vermerke_sf(unr, true, board, frombox, "*", header, "") !=
	  MSG_SFNOFOUND);
}


boolean gen_sftest2(short unr, Char *board, Char *mbx)
{
  Char frombox[256];

  frombox[0] = '\0';
  return (gen_sftest3(unr, frombox, board, mbx));
}


void gen_sftest(short unr, Char *eingabe)
{
  Char rubrik[9];
  Char hs[256];
  Char mbx[41];
  Char STR7[52];

  split_sline(eingabe, rubrik, hs, mbx, hs, hs, hs);
  if (*mbx == '\0') {
    if (callsign(rubrik))
      user_mybbs(rubrik, mbx);
  }

  if (strpos2(mbx, ".", 1) == 0)
    complete_hierarchical_adress(mbx);

  sprintf(STR7, "%s @ %s", rubrik, mbx);
  wlnuser(unr, STR7);
  gen_sftest2(unr, rubrik, mbx);
}


Static boolean check_tpk_request(short unr, Char *eingabe)
{
  long msgnum;
  short idx;
  indexstruct header;
  Char board[9];
  Char w[256];

  get_word(eingabe, w);
  msgnum = str2lint(w) - msgnumoffset;
  idx = msgnum2board(msgnum, board);
  if (idx <= 0)
    return false;
  if (read_brett(unr, nohandle, board, idx, idx, "T", "", 0, &header) != 0xffffL) {
    wlnuser(unr, ">");
    return true;
  }
  abort_sf(unr, false, "***error");
  return false;
}


Static void ok_master(short unr)
{
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (WITH->sf_level == 1 && WITH->sf_master)
    wlnuser(unr, "F>");
  else {
    chwuser(unr, '>');
    wlnuser0(unr);
  }


  if (!strcmp(WITH->FSID, "THEBOX")) /* ausnahmsweise drinlassen... */
    boxspoolfend(WITH->pchan);
  boxspoolread();
}


void analyse_sid(boolean request, short unr, Char *w)
{
  short k, x;
  Char w2[256], w3[256];
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  WITH->sf_ptr = find_sf_pointer(WITH->call);
  WITH->f_bbs = true;
  WITH->sf_level = 1;
  boxsetboxsf(WITH->pchan, true);
  strcpy(w2, w);
  upper(w2);
  k = strpos2(w2, "-", 1);
  x = 0;
  while (k > 0) {
    x++;
    if (x == 1) {
      strsub(w3, w2, 2, k - 2);
      cut(w3, 20);
      strcpy(WITH->FSID, w3);
    } else if (x == 2) {
      sprintf(w3, "%.*s", k - 1, w2);
      cut(w3, 20);
      strcpy(WITH->MSID, w3);
    }
    strdelete((void *)w2, 1, k);
    k = strpos2(w2, "-", 1);
  }
  if (strlen(w2) > 1)   /* $] */
    strdelete((void *)w2, strlen(w2) - 1, 2);
  cut(w2, 20);
  strcpy(WITH->SID, w2);

  if (strpos2(WITH->SID, "F", 1) > 0) {
    if (strpos2(WITH->SID, "B1", 1) > 0)
      WITH->sf_level = 5;
    else if (strpos2(WITH->SID, "B", 1) > 0)
      WITH->sf_level = 4;
    else
      WITH->sf_level = 3;
  } else if (strpos2(WITH->SID, "D", 1) > 0)
    WITH->sf_level = 2;
  else
    WITH->sf_level = 1;

  if (WITH->sf_level < 2) {
    if (!strcmp(WITH->FSID, "THEBOX"))
      WITH->sf_level = 2;
    else if (!strcmp(WITH->FSID, "BAYCOM"))
      WITH->sf_level = 2;
  }
  
  WITH->fwdmode = bbs_pack(unr);

  if (!request) {
    WITH->action = 1;
    return;
  }

  WITH->sf_to = false;
  if (WITH->sf_level > 2)
    WITH->action = 20;
  else {
    WITH->action = 5;
    ok_master(unr);
  }
}


Static boolean check_for_double_connect(short unr)
{
  boolean Result;
  short x;

  Result = false;
  if (!boxrange(unr))
    return Result;

  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (x != unr) {
	if (!strcmp(user[x]->call, user[unr]->call)) {
	  if (user[x]->sf_to)
	    return true;
	}
      }
    }
  }
  return Result;
}


Static boolean errorcondition(Char *eingabe)
{
  if (strpos2(eingabe, "CONNECTED TO", 1) > 0)
    return true;
  else if (strpos2(eingabe, "FAILURE WITH", 1) > 0)
    return true;
  else if (strpos2(eingabe, "BUSY FROM", 1) > 0)
    return true;
  else if (!strcmp(eingabe, "***DONE"))
    return true;
  else
    return false;
}


void analyse_sf_command(short unr, Char *eingabe, boolean return_)
{
  Char w[256], w1[256], w2[256], w3[256];
  short k, x;
  Char search[256];
  boolean has_bid, plus;
  Char msgtype;
  Char pwresp[256];
  userstruct *WITH;
  Char STR1[256];
  Char STR13[256];

  debug(5, unr, 92, eingabe);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  box_ttouch(unr);

  if (*eingabe != '\0') {
    switch (WITH->action) {

    case 7:
    case 28:
      /* blank case */
      break;

    case 6:
    case 8:
    case 9:
    case 27:
      if (strlen(WITH->lastcmd) + strlen(eingabe) <= 254)
	sprintf(WITH->lastcmd + strlen(WITH->lastcmd), " %s", eingabe);
      else {
	sprintf(STR13, "%s %.*s",
		WITH->lastcmd, (int)(254 - strlen(WITH->lastcmd)), eingabe);
	strcpy(WITH->lastcmd, STR13);
      }
      break;

    default:
      strcpy(WITH->lastcmd, eingabe);
      break;
    }
  }

  if ((unsigned)WITH->action >= 32 ||
      ((1L << WITH->action) & 0x10000080L) == 0) {
    if (debug_level < 5)
      debug(1, unr, 92, eingabe);

    if (create_sflog)
      append_sflog(unr);
    if (in_protocalls(user[unr]->call))
      append_protolog(unr);
  }

  if (WITH->action == 0)
    return;
  del_lastblanks(eingabe);
  switch (WITH->action) {

  case 1:
    *pwresp = '\0';
    if (*WITH->sfpwdb != '\0')
      calc_pwdb(WITH->call, WITH->sfpwdb, pwresp);
    else if (*WITH->sfpwtn != '\0') {
      if (count_words(WITH->sfpwtn) == 1)   /* MD2 */
	calc_MD2_pw(WITH->sfpwtn, WITH->password, pwresp);
      else {
	calc_pwtn(WITH->call, WITH->sfpwtn, pwresp);
	jitter_pwtn(pwresp);
      }
    }
    if (*pwresp != '\0')
      sprintf(pwresp, " %s", strcpy(STR13, pwresp));
    WITH->sf_to = true;
    if (eingabe[strlen(eingabe) - 1] == '>') {
      WITH->sf_ptr = find_sf_pointer(WITH->call);
/*    if (WITH->sf_level == 2 && !strcmp(WITH->FSID, "THEBOX")) {
	if (packed_sf) {
	  sprintf(STR13, "[THEBOX-1.9-AB1D1FHMR$]%s", pwresp);
	  wlnuser(unr, STR13);
	} else {
	  sprintf(STR13, "[THEBOX-1.9-ADFHMR$]%s", pwresp);
	  wlnuser(unr, STR13);
	}
      } else { */
	if (packed_sf) {
	  sprintf(STR13, "[DP-%s-AB1D1FHMR$]%s", dp_vnr, pwresp);
	  wlnuser(unr, STR13);
	} else {
	  sprintf(STR13, "[DP-%s-ADFHMR$]%s", dp_vnr, pwresp);
	  wlnuser(unr, STR13);
	}
/*    }  */
      if (WITH->sf_level > 2)
	send_fbb_proposals(unr, false);
      else
	user[unr]->action = 110;
    } else {
      upper(eingabe);
      if (errorcondition(eingabe))
	sfproterr(unr);
    }
    break;

  case 110:
    if (eingabe[strlen(eingabe) - 1] == '>') {
      if (check_for_double_connect(unr)) {
	wlnuser(unr, "F>");
	WITH->sf_to = false;
	WITH->action = 5;
      } else
	look_for_mail(unr, true, true);
    } else
      sfproterr(unr);
    break;

  case 2:
    if (eingabe[strlen(eingabe) - 1] == '>')
      look_for_mail(unr, true, false);
    else
      sfproterr(unr);
    break;

  case 3:
  case 4:   /* bulletin */
    /* diebox private */
    k = strlen(eingabe);
    if (k > 0) {
      upper(eingabe);
      if (errorcondition(eingabe))
	sfproterr(unr);
      else if (eingabe[0] == 'O') {
	if (WITH->action == 3)
	  ok_sf_sending(unr, 1, 0);
	WITH->action = 30;
      } else if (eingabe[k - 1] == '>' && (k < 2 || eingabe[k - 2] != '|')) {
	/* die komische DieBox-Signalisation einer fehlerhaften BIN-CRC: */
	received_sf_sending('\0', unr, 1, false);
	look_for_mail(unr, true, false);
      } else
	WITH->action = 35;
    } else
      sfproterr(unr);

    break;

  case 5:
    if (strlen(eingabe) > 100) {
      abort_sf(unr, true, "messy input");
      break;
    }
    msgtype = '\0';
    get_word(eingabe, w);
    if ((unsigned long)strlen(w) < 32 && ((1L << strlen(w)) & 0x6) != 0) {
      if (!strcmp(w, "F<")) {
	if (!check_tpk_request(unr, eingabe))
	  abort_sf(unr, false, "***invalid message number");
      } else if (w[0] == 'S') {
	if (disk_full)
	  abort_sf(unr, false, "DISK FULL");
	else {
	  if (strlen(w) == 2)
	    msgtype = w[1];
	  strcpy(w1, eingabe);
	  get_word(w1, w2);   /*Rubrik*/
	  if (strpos2(w2, "@", 1) > 0)
	    cut(w2, strpos2(w2, "@", 1) - 1);

	  if (msgtype == '\0') {
	    *w3 = '\0';
	    check_msgtype(&msgtype, w2, w3);
	  }


	  if (allowed_rlisf(unr, msgtype, eingabe)) {
	    if (!strcmp(w2, "M") || !strcmp(w2, "E")) {
	      for (x = 1; x <= 5; x++)   /* Die BID */
		get_word(w1, search);
	      if (*search != '\0') {
		if (search[0] == '$') {
		  strdelete((void *)search, 1, 1);
		  if (check_double(search)) {
		    WITH->fstat_rx_s++;
		    if (count_words(eingabe) == 6) {
		      wlnuser(unr, "OK");
		      strcpy(WITH->input2, eingabe);
		      WITH->action = 8;

		    } else {
		      wlnuser(unr, "OK");
		      chwuser(unr, '>');
		      wlnuser0(unr);
		      if (!strcmp(WITH->FSID, "THEBOX")) /* ausnahmsweise drinlassen... */
			boxspoolfend(WITH->pchan);
		      boxspoolread();
		      sf_rx_emt(unr, eingabe);
		    }
		  } else {
                    delete_brett_by_bid("X", WITH->call, search, false, true);
		    wlnuser(unr, "NO");
		    ok_master(unr);
		  }
		} else {
		  wlnuser(unr, "NO");
		  ok_master(unr);
		}
	      }

	    } else {
	      has_bid = false;
	      plus = true;
	      do {
		get_word(w1, w3);
		if (strlen(w3) > 1) {
		  if (w3[0] == '$') {
		    strdelete((void *)w3, 1, 1);
		    cut(w3, 12);
		    plus = check_double(w3);
		    has_bid = true;
		  }
		}
	      } while (*w1 != '\0' && plus != false);

	      if (!has_bid) {
		if (!callsign(w2) || msgtype == 'B')
		  plus = false;
	      }

	      if (plus) {
		wlnuser(unr, "OK");
		send_check(unr, eingabe, false, msgtype);
	      } else {
		if (has_bid) {
                  delete_brett_by_bid("X", WITH->call, w3, false, true);
		  wlnuser(unr, "NO - double");
		}
		else
		  wlnuser(unr, "NO - no BID");
		ok_master(unr);
	      }

	    }

	  } else {
	    wlnuser(unr, "NO - rejected");
	    ok_master(unr);
	  }


	}

      } else if (!strcmp(w, "F>")) {
	if (check_for_double_connect(unr))
	  abort_sf(unr, false, "*** double connect");
	else
	  look_for_mail(unr, false, false);
      } else
	sfproterr2(unr);


    } else {
      upper(eingabe);
      if (errorcondition(eingabe))
	abort_sf(unr, true, "");
      else
	sfproterr2(unr);
    }


    break;

  case 6:
    box_txt2(false, unr, eingabe);
    break;


  case 7:
    send_text3(unr, false, eingabe, return_);
    break;

  case 8:
    if (strlen(eingabe) > 80) {
      abort_sf(unr, true, "messy input");
      break;
    }
    sprintf(eingabe, "%s %s \032", WITH->input2, strcpy(STR1, eingabe));
    sf_rx_emt(unr, eingabe);
    WITH->input2[0] = '\0';
    WITH->action = 9;
    break;

  case 9:
    if (strpos2(eingabe, "\032", 1) > 0) {
      ok_master(unr);
      WITH->action = 5;
    } else {
      upper(eingabe);
      if (errorcondition(eingabe))
	sfproterr(unr);
    }
    break;

  case 11:
    get_word(eingabe, w);
    if (!strcmp(w, "FS"))
      analyse_fbb_answer(unr, eingabe);
    else
      sfproterr2(unr);
    break;

  /* ACHTUNG: 14-15 sind reserviert! */

  case 20:
  case 21:
  case 22:
  case 23:
  case 24:
    boxsetboxbin(WITH->pchan, false);   /* damit wir wieder was sehen... */
    get_word(eingabe, w);
    if (!strcmp(w, "FF") || !strcmp(w, "F>") || !strcmp(w, "FQ") ||
	!strcmp(w, "FB") || !strcmp(w, "FA") || !strcmp(w, "FD") ||
	!strcmp(w, "FU") || !strcmp(w, "F<")) {
      WITH->sf_to = false;

      if (WITH->action == 20) {
	for (x = 1; x <= maxfbbprops; x++) {
	  if (WITH->fbbprop[x - 1].nr > 0 || WITH->fbbprop[x - 1].x_nr > 0)
	    received_sf_sending('\0', unr, x, false);
	}
      }


      if (!strcmp(w, "FF"))
	send_fbb_proposals(unr, true);
      else if (!strcmp(w, "FQ"))
	abort_sf(unr, false, "");
      else if (!strcmp(w, "F>") && user[unr]->action > 20) {
	if (check_prop_crc(unr, eingabe))
	  send_fbb_answer(unr);
	else
	  sfproterr2(unr);
      } else if (!strcmp(w, "F<")) {
	if (WITH->action == 20) {
	  if (!check_tpk_request(unr, eingabe))
	    abort_sf(unr, false, "***invalid message number");
	} else
	  abort_sf(unr, false, "*** F< - command mixed with other...");
      } else if (!strcmp(w, "FB")) {
	if ((unsigned)WITH->fwdmode < 32 && ((1L << WITH->fwdmode) & 0xa) != 0)
	      /* ist ein FBB-Bin-FILE */
		abort_sf(unr, false, "*** file transfer not supported");
	else {
	  sprintf(WITH->fbbprop[WITH->action - 20].line, "%s %s", w, eingabe);
	  WITH->fbbprop[WITH->action - 20].unpacked = false;
	  WITH->action++;
	}
      } else if ((!strcmp(w, "FA") &&
		  ((unsigned)WITH->fwdmode < 32 &&
		  ((1L << WITH->fwdmode) & 0xa) != 0)) ||
		 (!strcmp(w, "FD") &&
		  ((unsigned)WITH->fwdmode < 32 &&
		  ((1L << WITH->fwdmode) & 0x34) != 0))) {
	sprintf(WITH->fbbprop[WITH->action - 20].line, "%s %s", w, eingabe);
	WITH->fbbprop[WITH->action - 20].unpacked = false;
	WITH->action++;
      } else if (!strcmp(w, "FU") &&
		 ((unsigned)WITH->fwdmode < 32 &&
		 ((1L << WITH->fwdmode) & 0x3e) != 0)) {
	sprintf(WITH->fbbprop[WITH->action - 20].line, "%s %s", w, eingabe);
	WITH->fbbprop[WITH->action - 20].unpacked = true;
	WITH->action++;
      } else
	sfproterr(unr);
    } else
      sfproterr(unr);

    break;

  case 25:
    get_word(eingabe, w);
    if (!strcmp(w, "F>")) {
      if (check_prop_crc(unr, eingabe))
	send_fbb_answer(unr);
      else
	sfproterr2(unr);
    } else
      sfproterr(unr);
    break;

  case 27:   /*hier kommt der Titel an*/
    box_txt2(false, unr, eingabe);
    break;

  case 28:   /*hier kommt der Text an*/
    send_text3(unr, false, eingabe, return_);
    break;

  case 30:
  case 31:
  case 32:
  case 33:
  case 35:
  case 36:
  case 37:
  case 38:
    upper(eingabe);
    boxsetboxbin(WITH->pchan, false);   /*damit wir wieder was sehen...*/
    if (errorcondition(eingabe))
      sfproterr(unr);
    else if (eingabe[strlen(eingabe) - 1] == '>') {
      received_sf_sending('\0', unr, 1, WITH->action >= 35);
      look_for_mail(unr, true, false);
    } else {
      WITH->action++;
      if (WITH->action == 34 || WITH->action == 39)
	sfproterr(unr);
    }
    break;

  case 34:
  case 39:
    sfproterr(unr);
    break;


  case 40:
  case 41:
  case 42:
  case 43:  /* Bestaetigungen im blockweisen E/M */
    upper(eingabe);
    if (errorcondition(eingabe))
      sfproterr(unr);
    else if (eingabe[strlen(eingabe) - 1] == '>') {
      WITH->fstat_tx_s++;
      WITH->emblockct--;
      if (WITH->emblockct <= 0) {
	WITH->action = 0;
	del_emblocks(unr, 0);
	look_for_mail(unr, true, false);
      } else
	WITH->action = 40;
    } else
      WITH->action++;
    break;

  case 44:
    sfproterr(unr);
    break;

  /* Achtung: 70-99 reserviert ! */

  case 100:
  case 101:
  case 102:
  case 103:
  case 104:
  case 105:
    strcpy(w1, eingabe);   /* fuer MD2 brauchen wir auch lowercase */
    upper(eingabe);
    if (errorcondition(eingabe))
      sfproterr(unr);
    else {
      get_word(eingabe, w);
      if (strlen(w) > 4) {
	if (w[0] == '[' && w[strlen(w) - 1] == ']' && w[strlen(w) - 2] == '$') {
	  analyse_sid(false, unr, w);
	  
	  del_lastblanks(eingabe);
	  switch (count_words(eingabe)) {   /* Passwordanfrage ? */
	  case 1:
	    if (eingabe[0] == '[') {  /* MD2 */
	      if (strlen(eingabe) >= 12) {
		get_word(w1, w); /* SID entfernen */
		strsub(WITH->sfpwtn, w1, 2, 10);
	      }
	    } else if (strlen(eingabe) == 10)
	      strcpy(WITH->sfpwdb, eingabe);
	    else if ((strlen(eingabe) == 11) && (eingabe[10] == 'N')) { /* neues DieBox-PW */
	      strncpy(WITH->sfpwdb, eingabe, 10);
	      WITH->sfpwdb[10] = '\0';
	    }
	    break;
	    
	  case 2: /* diebox kann sich nicht entscheiden... */
	    get_word(eingabe, w);
	    if (strlen(w) == 10)
	      strcpy(WITH->sfpwdb, w);
	    break;

	  case 5:
	    if (strlen(eingabe) < 15)
	      strcpy(WITH->sfpwtn, eingabe);
	    break;
	  }
	} else
	  WITH->action++;
      } else
	WITH->action++;
    }
    break;

  default:
    if (useq(eingabe, "***done"))
      abort_sf(unr, true, "");
    else
      sfproterr(unr);
    break;
  }

}


void _box_sf_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  fxpuffer = NULL;   /* sf_for */
  last_sftimer = 0;   /* check_sftimer */
}



/* End. */
