/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_sub.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_SUB_G
#include "box_sub.h"


#ifndef CRC_H
#include "crc.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef STATUS_H
#include "status.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif




Static void send_unproto_line(Char *path, Char *port, boolean fbb,
			      boolean dpbox, Char *line)
{
  short iface, chan;
  Char hs[256];

  if (!fbb && !dpbox)
    return;
  iface = -1;   /* wichtig */
  if (!find_socket(port, &iface))
    return;
  chan = boxgettncmonchan(0);
  if (fbb) {
    sprintf(hs, "FBB %s", path);
    del_lastblanks(hs);
    boxsetunproto(chan, hs, iface, port);
    boxsendpline(chan, line, true, iface);
  }
  if (!dpbox)
    return;
  sprintf(hs, "DPBOX %s", path);
  del_lastblanks(hs);
  boxsetunproto(chan, hs, iface, port);
  boxsendpline(chan, line, true, iface);
}


void send_unproto_header(boxlogstruct header, Char *port, Char *path,
			 boolean fbb, boolean dpbox)
{
  long ct;
  unprotoportstype *hp, *disp;
  Char hs[256], w[256], w1[256];

  if (!unproto_list)
    return;
  if (unprotodefroot == NULL)
    return;
  if (header.deleted)
    return;
  if (!unprotodefroot->priv && header.msgtype != 'B')
    return;
  if (header.msgtype != 'B') {
    unhpath(header.verbreitung, hs);
    if (strcmp(hs, Console_call))
      return;
  }
  if (!unprotodefroot->sys && strlen(header.obrett) == 1)
    return;

  disp = NULL;
  if ((unsigned long)strlen(port) < 32 &&
      ((1L << strlen(port)) & 0x1ffffeL) != 0) {
    hp = Malloc(sizeof(unprotoportstype));
    if (hp == NULL)
      return;
    disp = hp;
    hp->next = NULL;
    strcpy(hp->port, port);
    strcpy(hp->path, path);
  } else {
    hp = unprotodefroot->ports;
    fbb = unprotodefroot->fbb;
    dpbox = unprotodefroot->dpbox;
  }

  while (hp != NULL) {
    if (unproto_last > header.msgnum)
      unproto_last = header.msgnum;
    if (header.msgnum > unproto_last + 1) {
      if (header.msgnum - unproto_last > unprotodefroot->maxback)
	unproto_last = header.msgnum - unprotodefroot->maxback;
      for (ct = unproto_last + 1; ct < header.msgnum; ct++) {
	if (ct % 50 == 0)
	  dp_watchdog(2, 4711);
	sprintf(hs, "%ld #", ct + msgnumoffset);
	send_unproto_line(hp->path, hp->port, fbb, dpbox, hs);
      }
    }

    ixdatum2string(header.date, w);
    
    if (fbb) {

/*
12345 B 2053 TEST  @ALL F6FBB 920325 This is the subject
             ^^^^^^ six chars, fill up with spaces
*/

      strcpy(w1, header.obrett);
      rspacing(w1, 6);
      cut(w1, 6);
      sprintf(hs, "%ld %c %ld %s@%s %s %c%c%c%c%c%c %s",
    		header.msgnum + msgnumoffset, header.msgtype,
    		header.size, w1, header.verbreitung, header.absender,
    		w[6], w[7], w[3], w[4], w[0], w[1], header.betreff);
      cut(hs, 79);
      send_unproto_line(hp->path, hp->port, fbb, false, hs);
    }

    if (dpbox) {

/*
12345 1234_DL8HBS 365 B 2053 MODIFICA@ALL F6FBB 920325 This is the subject
                             ^^^^^^^^ up to 8 signs, no spaces appended
*/

    sprintf(hs, "%ld %s %ld %c %ld %s@%s %s %c%c%c%c%c%c %s",
    		header.msgnum + msgnumoffset, header.bid, header.lifetime, header.msgtype,
    		header.size, header.obrett, header.verbreitung, header.absender,
    		w[6], w[7], w[3], w[4], w[0], w[1], header.betreff);
      cut(hs, 79);
      send_unproto_line(hp->path, hp->port, false, dpbox, hs);
    }
    hp = hp->next;
  }

  if (disp != NULL)
    Free(disp);

  unproto_last = header.msgnum;
}


/* Die Verwaltung fuer Unproto-Requests:                                 */
/*                                                                       */
/* CALL ist das Absender-Call des Requesters, kann auch mit SSID sein    */
/* PORT ist der TNC-Port, auf dem der Request hereinkam                  */
/* PATH ist das dritte bis n-te call aus dem ax25-header,                */
/*      kann also auch leer sein                                         */
/* S    ist die empfangene Unproto-Zeile                                 */

void unproto_request1(Char *call, Char *port, Char *path, Char *s)
{
  boolean ok;
  userstruct ufil;
  long mnum;
  short x, k;
  unprotoportstype *hp;
  boolean dpboxmode;
  long cs, cs1, maxc, cpos, ct;
  boxlogstruct log;
  Char hs[256], w[256], w1[256];
  Char STR1[256], STR7[256];

  if (unprotodefroot == NULL)
    return;

  x = strlen(s);
  if (x < 12 || x > 13)
    return;

  if (clock_.ixtime - unproto_lasttime < unprotodefroot->interval)
    return;

  strcpy(hs, path);
      /* senden wir ueberhaupt ueber diesen pfad?                      */
  get_word(hs, w);
      /* mit flexnet-digis funktioniert das allerdings nicht gut...    */
  upper(w);
  ok = false;
  hp = unprotodefroot->ports;
  while (hp != NULL && !ok) {
    if (!strcmp(port, hp->port)) {
      strcpy(hs, hp->path);
      get_word(hs, w1);
      ok = (strcmp(w, w1) == 0);
    }
    hp = hp->next;
  }
  if (!ok)   /* nein -> und tschuess */
    return;

  strcpy(hs, s);   /* nachfragemodus pruefen */
  get_word(hs, w);
  dpboxmode = (strcmp(w, "??") == 0);
  if (!dpboxmode && strcmp(w, "?"))
    return;
  if (dpboxmode && !unprotodefroot->dpbox)
    return;
  if (!dpboxmode && !unprotodefroot->fbb)
    return;

  get_word(hs, w);   /* msgnum und checksumme pruefen */
  if (strlen(w) != 10)
    return;
  cs = hstr2int(strsub(STR1, w, 9, 2));
  sprintf(STR1, "%.8s", w);
  mnum = hstr2int(STR1) - msgnumoffset;
  if (mnum < 1)
    return;
  cs1 = 0;
  for (x = 0; x <= 3; x++)
    cs1 = (cs1 + hstr2int(strsub(STR1, w, x * 2 + 1, 2))) & 0xff;
  if (cs1 != cs) {
    boxprotokoll("invalid unproto checksum");
    return;
  }

  ok = allunproto;   /* ist dieser user zur nachfrage zugelassen? */
  if (!ok) {
    del_callextender(call, hs);
    load_userfile(false, true, hs, &ufil);
    ok = ufil.unproto_ok;
  }

  if (!ok) {  /* nein -> fehlermeldung auf entsprechendem pfad ausgeben */
    sprintf(w, "%ld / %s", mnum, call);
    send_unproto_line(path, port, !dpboxmode && unprotodefroot->fbb,
		      dpboxmode && unprotodefroot->dpbox, w);
    return;
  }

  if (actmsgnum - mnum > unprotodefroot->maxback) {
    mnum = actmsgnum - unprotodefroot->maxback;
    sprintf(hs, "%ld ! %s", mnum + msgnumoffset, call);
    send_unproto_line(path, port, !dpboxmode && unprotodefroot->fbb,
		      dpboxmode && unprotodefroot->dpbox, hs);
  }

  strcpy(w, path);   /* unproto-pfad umdrehen */
  *hs = '\0';
  while (*w != '\0') {
    get_word(w, w1);
    sprintf(hs, "%s %s", w, strcpy(STR7, hs));
  }
  del_lastblanks(hs);

  cpos = msgnum2centry(mnum, &log);
  maxc = sfsize(boxlog) / sizeof(boxlogstruct);
  k = sfopen(boxlog, FO_READ);
  if (k < minhandle)
    return;
  for (ct = cpos; ct <= maxc; ct++) {
    if (ct % 50 == 0)
      dp_watchdog(2, 4711);
    log.msgnum = -167;
    read_log(k, ct, &log);
    if (log.msgnum > 0)
      send_unproto_header(log, port, path, !dpboxmode && unprotodefroot->fbb,
			  dpboxmode && unprotodefroot->dpbox);
    unproto_lasttime = clock_.ixtime;
  }
  sfclose(&k);

}


void clear_msgnumarr(void)
{
  short x;

  for (x = 0; x <= maxmsgnumarr; x++) {
    msgnumarr[x].msgnum = 0;
    msgnumarr[x].cpos = 0;
  }
  firstmsgnum = 0;
  msgnumarrct = 0;
  msgnumarrblock = 0;
}


void fill_msgnumarr(void)
{
  short k;
  long bsize, bct, mct, cpos, cct;
  boxlogstruct log;

  clear_msgnumarr();
  debug0(3, -1, 162);

  bsize = sfsize(boxlog);
  if (bsize <= 0)
    return;
  cct = bsize / sizeof(boxlogstruct);
  bct = (cct >> 9) + 1;

  k = sfopen(boxlog, FO_READ);
  if (k < minhandle)
    return;

  mct = 0;

  do {

    cpos = mct * bct;
    log.msgnum = -176;
    read_log(k, cpos + 1, &log);
    if (log.msgnum == -176) {
      sfclose(&k);
      debug(0, -1, 162, "read error");
      return;
    }

    if (mct == 0)
      firstmsgnum = log.msgnum;
    msgnumarr[mct].msgnum = log.msgnum;
    msgnumarr[mct].cpos = cpos;

    mct++;

  } while (mct <= maxmsgnumarr && mct * bct < cct);

  sfclose(&k);

  while (mct <= maxmsgnumarr) {
    msgnumarr[mct].msgnum = log.msgnum + 1;
    msgnumarr[mct].cpos = cpos;
    mct++;
  }

  msgnumarrct = mct - 1;
  msgnumarrblock = bct;
}


Static long msgnum2cposstart(long msgnum)
{
  long Result;
  short x, f, n, lct;

  debug0(4, -1, 161);
  Result = -1;
  if (msgnum < firstmsgnum || msgnum > actmsgnum)
    return Result;
  if (msgnumarrct == 1)
    return 0;

  f = msgnumarrct >> 1;
  x = f;
  lct = 0;
  do {
    lct++;
    if (lct > msgnumarrct)
      return Result;
    f >>= 1;
    n = msgnumarr[x].msgnum;
    if (n == msgnum)
      f = 0;
    else if (n > msgnum)
      x -= f;
    else
      x += f;
    if ((unsigned)x > msgnumarrct) {
      debug(0, -1, 161, "resolving error");
      return Result;
    }
  } while (f > 1);

  if (msgnumarr[x].msgnum > msgnum && x > 0)
    x--;
  if (msgnumarr[x].msgnum > msgnum)
    x = 0;

  return (msgnumarr[x].cpos);
}


long msgnum2centry(long msgnum, boxlogstruct *log)
{
  long start, seekp;
  short k;

  start = msgnum2cposstart(msgnum);
  if (start < 0)
    return -1;

  k = sfopen(boxlog, FO_READ);
  if (k < minhandle)
    return -1;

  seekp = start * sizeof(boxlogstruct);
  if (sfseek(seekp, k, SFSEEKSET) != seekp) {
    sfclose(&k);
    return -1;
  }

  do {
    if (sfread(k, sizeof(boxlogstruct), (uchar *)log) != sizeof(boxlogstruct)) {
      sfclose(&k);
      return -1;
    }
  } while (log->msgnum < msgnum);

  seekp = sfseek(0, k, SFSEEKCUR);
  sfclose(&k);

  if (log->msgnum == msgnum)
    return (seekp / sizeof(boxlogstruct));
  return -1;
}


short msgnum2board(long msgnum, Char *board)
{
  boxlogstruct log;

  if (msgnum2centry(msgnum, &log) > 0) {
    strcpy(board, log.brett);
    return (log.idxnr);
  } else {
    *board = '\0';
    return -1;
  }
}



short actual_connects(void)
{
  short x, z;

  z = 0;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL)
      z++;
  }
  return z;
}


/* Makros:

   %7   CTRL-G (bell)
   %9   TAB

   %a   momentane Auslastung des Boxrechners in Prozent (letzte 40 Sekunden)
   %b   momentan aktiver Boardname
   %c   Call des eingelogten Benutzers
   %d   momentanes Datum
   %e   cpu-type
   %f   bogomips
   %h   hex-Zeichen (%hHH)
   %i   Loginzeitpunkt
   %l   Letzer Login (Datum und Uhrzeit)
   %m   Call der Mailbox
   %n   Name des Benutzers
   %o   Anzahl der eingelogten Benutzer (Logins)
   %p   vebrauchte Maschinenzeit seit dem Login
   %r   Zeilenumbruch (Return)
   %s   boxruntime (Tage, Stunden und Sekunden)
   %t   momentane Uhrzeit (mit Sekunden)
   %u   momentane Uhrzeit (ohne Sekunden)
   %v   Versionsnummer der Software
   %x   boxruntime in Tagen
   %z   letztes Kommando
   %%   das % Zeichen
*/

void expand_macro(short unr, Char *hs)
{
  short x, l;
  boolean brange;
  Char w[256], r[256], h[256];
  Char STR1[256];

  *r = '\0';
  brange = boxrange(unr);
  l = strlen(hs);
  x = 1;
  while (x <= l && strlen(r) < 175) {
    if (hs[x - 1] == '%') {
      if (x < l) {
	*w = '\0';

	switch (hs[x]) {

	case '7':
	  strcpy(w, "\007");
	  break;

	case '9':
	  strcpy(w, "\t");
	  break;

	case 'a':
	  get_lastsysload(w);
	  break;

	case 'b':
	  if (brange)
	    strcpy(w, user[unr]->brett);
	  break;

	case 'c':
	  if (brange)
	    strcpy(w, user[unr]->call);
	  break;

	case 'd':
	  strcpy(w, clock_.datum);
	  break;
	  
	case 'e':
	  get_cpuinf(w, h);
	  break;
	  
	case 'f':
	  get_cpuinf(h, w);
	  break;

	case 'h':
	  if (l - x > 2) {
	    strsub(h, hs, x + 2, 2);
	    sprintf(w, "%c", (Char)hstr2int(h));
	    x += 2;
	  } else
	    strcpy(w, "%h");
	  break;

	case 'i':
	  if (brange)
	    ix2string(user[unr]->logindate, w);
	  break;

	case 'l':
	  ix2string(user[unr]->lastdate, w);
	  break;

	case 'm':
	  strcpy(w, Console_call);
	  break;

	case 'n':
	  if (brange)
	    strcpy(w, user[unr]->name);
	  break;

	case 'o':
	  sprintf(w, "%ld", actual_connects());
	  break;

	case 'p':
	  if (brange) {
	    sprintf(w, "%ld", user[unr]->processtime / 200);
	    sprintf(h, "%ld", (user[unr]->processtime % 200) >> 1);
	    while (strlen(h) < 2)
	      sprintf(h, "0%s", strcpy(STR1, h));
	    sprintf(w + strlen(w), ".%s", h);
	  }
	  break;

	case 'r':
	  strcpy(w, "\015");
	  break;

	case 's':
	  get_boxruntime_s(w);
	  break;

	case 't':
	  strcpy(w, clock_.zeit);
	  break;

	case 'u':
	  sprintf(w, "%.5s", clock_.zeit);
	  break;

	case 'v':
	  sprintf(w, "%s%s", dp_vnr, dp_vnr_sub);
	  break;

	case 'x':
	  sprintf(w, "%ld", get_boxruntime_l() / 86400L);
	  break;

	case 'z':
	  if (brange)
	    strcpy(w, user[unr]->lastcmd);
	  break;

	case '%':
	  strcpy(w, "%");
	  break;

	default:
	  sprintf(w, "%%%c", hs[x]);
	  break;
	}
	strcat(r, w);
	x++;
      } else
	sprintf(r + strlen(r), "%c", hs[x - 1]);
    } else
      sprintf(r + strlen(r), "%c", hs[x - 1]);
    x++;
  }
  strcpy(hs, r);
}


boolean in_rsysops_boards(Char *call, Char *board)
{
  rsysoptype *hp;
  boolean ok;
  unsigned short lt, acc;
  Char w[256];

  ok = false;
  hp = rsysoproot;
  while (hp != NULL && !ok) {
    if (!strcmp(hp->call, call)) {
      if (!strcmp(hp->board, board))
	ok = true;
      else if (!strcmp(hp->board, "*"))
	ok = true;
      else if (!strcmp(hp->board, "!"))
	ok = !defined_board(board);
      else if (hp->board[0] == '#') {
	strcpy(w, hp->board);
	check_lt_acc(board, &lt, &acc);
	strdelete((void *)w, 1, 1);
	ok = (lt <= Str2int(w));
      }
    }
    hp = hp->next;
  }
  return ok;
}


short in_tracecalls(Char *call)
{
  tracetype *hp;

  hp = traces;
  while (hp != NULL) {
    if (!strcmp(hp->call, call) || !strcmp(hp->call, "ALL"))
      return (hp->by);
    hp = hp->next;
  }
  return 0;
}


void delete_trace_from(short unr)
{
  tracetype *hp, *hpa;
  boolean found;
  short x;

  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL && user[x]->trace_to == unr)
      user[x]->trace_to = 0;
  }

  do {
    found = false;
    hp = traces;
    hpa = hp;
    while (hp != NULL && hp->by != unr) {
      hpa = hp;
      hp = hp->next;
    }
    if (hp != NULL) {
      found = true;
      if (hp != traces) {
	hpa->next = hp->next;
	Free(hp);
      } else {
	hpa = hp->next;
	Free(hp);
	traces = hpa;
      }
    }
  } while (found);
}


Static void add_tracecall(short unr, Char *call)
{
  tracetype *hp;
  short x;

  if (in_tracecalls(call) != 0 || in_tracecalls("ALL") != 0) {
    wlnuser(unr, "TRACE set by another Task. Abort");
    return;
  }
  hp = Malloc(sizeof(tracetype));
  if (hp == NULL)
    return;
  hp->next = traces;
  strcpy(hp->call, call);
  hp->by = unr;
  traces = hp;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL &&
	(!strcmp(user[x]->call, call) || !strcmp(call, "ALL")))
      user[x]->trace_to = unr;
  }
  wlnuser(unr, "added");
}


Static void delete_tracecall(Char *call)
{
  tracetype *hp, *hpa;
  short x;

  hp = traces;
  hpa = hp;
  while (hp != NULL && strcmp(hp->call, call)) {
    hpa = hp;
    hp = hp->next;
  }
  if (hp == NULL)
    return;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL &&
	(!strcmp(user[x]->call, call) || !strcmp(call, "ALL")))
      user[x]->trace_to = 0;
  }
  if (hp != traces) {
    hpa->next = hp->next;
    Free(hp);
    return;
  }
  hpa = hp->next;
  Free(hp);
  traces = hpa;
}


void delete_all_tracecalls(void)
{
  tracetype *hp, *hpa;
  short x;

  hp = traces;
  while (hp != NULL) {
    hpa = hp;
    hp = hp->next;
    Free(hpa);
  }
  traces = NULL;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL)
      user[x]->trace_to = 0;
  }
}


void trace_cmd(short unr, Char *w, Char *w1)
{
  tracetype *pcp;

  if (*w == '\0') {
    if (traces == NULL) {
      wlnuser(unr, "Trace inactive");
      return;
    }
    wlnuser(unr, "Trace on: ");
    pcp = traces;
    while (pcp != NULL) {
      if (pcp->by == unr)
	wlnuser(unr, pcp->call);
      pcp = pcp->next;
    }
    return;
  }
  if ((!strcmp(w, "OFF") || !strcmp(w, "-")) &&
      (callsign(w1) || !strcmp(w1, "ALL") || *w1 == '\0')) {
    if (*w1 == '\0')
      delete_trace_from(unr);
    else
      delete_tracecall(w1);
    if (!strcmp(w, "OFF"))
      abort_useroutput(unr);
    wlnuser(unr, "OK");
    return;
  }
  if ((!strcmp(w, "ON") || !strcmp(w, "+")) &&
      (callsign(w1) || !strcmp(w1, "ALL")))
    add_tracecall(unr, w1);
  else
    wlnuser(unr, "USAGE: TRACE <+-> <CALL|ALL>");
}


boolean in_protocalls(Char *call)
{
  protocalltype *hp;
  uchar cs1;

  hp = protocalls;
  cs1 = calccs(call);
  while (hp != NULL) {
    if (hp->cs == cs1) {
      if (!strcmp(hp->call, call))
	return true;
    }
    hp = hp->next;
  }
  return false;
}


Static void add_protocall(Char *call)
{
  protocalltype *hp;

  if (in_protocalls(call))
    return;
  hp = Malloc(sizeof(protocalltype));
  if (hp == NULL)
    return;
  hp->next = protocalls;
  strcpy(hp->call, call);
  hp->cs = calccs(call);
  protocalls = hp;
}


Static void delete_protocall(Char *call)
{
  protocalltype *hp, *hpa;

  hp = protocalls;
  hpa = hp;
  while (hp != NULL && strcmp(hp->call, call)) {
    hpa = hp;
    hp = hp->next;
  }
  if (hp == NULL)
    return;
  if (hp != protocalls) {
    hpa->next = hp->next;
    Free(hp);
    return;
  }
  hpa = hp->next;
  Free(hp);
  protocalls = hpa;
}


void delete_all_protocalls(void)
{
  protocalltype *hp, *hpa;

  hp = protocalls;
  while (hp != NULL) {
    hpa = hp;
    hp = hp->next;
    Free(hpa);
  }
  protocalls = NULL;
}


void reload_proto(void)
{
  short k;
  Char hs[256];
  Char STR1[256];

  delete_all_protocalls();
  sprintf(STR1, "%sproto%clst", boxstatdir, extsep);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return;
  while (file_to_string(k, hs)) {
    if (callsign(hs))
      add_protocall(hs);
  }
  sfclose(&k);
}


Static void store_proto(void)
{
  short k;
  protocalltype *pcp;
  Char STR1[256];

  if (protocalls == NULL) {
    sprintf(STR1, "%sproto%clst", boxstatdir, extsep);
    sfdelfile(STR1);
    return;
  }
  sprintf(STR1, "%sproto%clst", boxstatdir, extsep);
  k = sfcreate(STR1, FC_FILE);
  if (k < minhandle)
    return;
  pcp = protocalls;
  while (pcp != NULL) {
    string_to_file(&k, pcp->call, true);
    pcp = pcp->next;
  }
  sfclose(&k);
}


void proto_cmd(short unr, Char *w, Char *w1)
{
  protocalltype *pcp;

  if (*w == '\0') {
    if (protocalls == NULL) {
      wlnuser(unr, "Proto inactive");
      return;
    }
    wlnuser(unr, "Proto on: ");
    pcp = protocalls;
    while (pcp != NULL) {
      wlnuser(unr, pcp->call);
      pcp = pcp->next;
    }
    return;
  }
  if ((!strcmp(w, "OFF") || !strcmp(w, "-")) && (callsign(w1) || *w1 == '\0')) {
    if (*w1 == '\0') {
      wlnuser(unr, "Proto on: ");
      pcp = protocalls;
      while (pcp != NULL) {
        wlnuser(unr, pcp->call);
        pcp = pcp->next;
      }
      wlnuser(unr, "now deleted");
      delete_all_protocalls();
    }
    else
      delete_protocall(w1);
    store_proto();
    wlnuser(unr, "OK, ended");
    return;
  }
  if (strcmp(w, "ON") && strcmp(w, "+") || !callsign(w1)) {
    wlnuser(unr, "USAGE: PROTO <+-> <CALL>");
    return;
  }
  add_protocall(w1);
  store_proto();
  wlnuser(unr, "OK, started");
}


Static short updbidseekcounter;


void flush_bidseek(void)
{
  short k;

  if (updbidseekcounter <= 0)
    return;
  updbidseekcounter = 0;
  k = sfcreate(bidseekfile, FC_FILE);
  if (k < minhandle)
    return;
  sfwrite(k, sizeof(long), (uchar *)(&bullidseek));
  sfwrite(k, sizeof(short), (uchar *)(&hiscore_connects));
  sfwrite(k, sizeof(long), (uchar *)(&actmsgnum));
  sfclose(&k);
}


void update_bidseek(void)
{
  updbidseekcounter++;
  flush_bidseek();
}


void flush_bidseek_immediately(void)
{
  updbidseekcounter = 1;
  flush_bidseek();
}


boolean load_bidseek(void)
{
  boolean Result;
  short k;
  long li;
  short i;

  Result = false;
  bullidseek = sfsize(msgidlog) / 13;
  k = sfopen(bidseekfile, FO_READ);
  if (k < minhandle)
    return Result;
  if (sfread(k, sizeof(long), (uchar *)(&li)) == sizeof(long)) {
    bullidseek = li;
    Result = true;
    if (sfread(k, sizeof(short), (uchar *)(&i)) == sizeof(short)) {
      hiscore_connects = i;
      if (sfread(k, sizeof(long), (uchar *)(&li)) == sizeof(long)) {
	if (li > 0)
	  actmsgnum = li;
      }
    }
  }
  sfclose(&k);
  return Result;
}


void create_hcs(indexstruct *h)
{
  /* header-checksumme */
  unsigned short zs;

  zs = 0;
  checksum16_buf((uchar *)h, sizeof(indexstruct) - 4, &zs);
      /* Alignment des GNU-C */
  h->headerchecksum = zs;
}


boolean check_hcs(indexstruct h)
{
  boolean Result;
  unsigned short zs;
  Char STR1[36];
  Char STR7[34];

  zs = 0;
  checksum16_buf((uchar *)(&h), sizeof(indexstruct) - 4, &zs);
      /* Alignment des GNU-C */
  if (h.headerchecksum != zs) {
    Result = false;
    sprintf(STR1, "%s : invalid header checksum", h.dest);
    debug(0, -1, 137, STR1);
    return Result;
  }
  if (h.hver == headervn)
    return true;
  Result = false;
  sprintf(STR7, "%s : invalid header version", h.dest);
  debug(0, -1, 137, STR7);
  return Result;
}


boolean boxrange(short unr)
{

  if (unr < 1)
    return false;
  if (unr > maxuser)
    return false;
  if (user[unr] == NULL)
    return false;
  if (user[unr]->magic1 == magicconst && user[unr]->magic2 == magicconst &&
      user[unr]->magic3 == magicconst)
    return true;
  debug(0, -1, 155, "userstruct violated");
  debug(0, -1, 155, "now trying to stop dpbox");
  ende = true;
  return false;
}


void upd_statistik(short unr, long txbytes, long rxbytes, long start,
		   long stop)
{
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (rxbytes > 0)   /* das ist etwas vertauscht */
    WITH->sbytes += rxbytes;
  if (txbytes > 0)   /* txbytes = die von der Gegenstation gesendeten Bytes */
    WITH->rbytes += txbytes;
  if (start > 0)
    WITH->processtime += stop - start;
}


void get_btext(short unr, short nr, Char *s)
{
  userstruct uf;

  debug0(5, unr, 108);
  *s = '\0';
  if (boxrange(unr)) {
    get_language(nr, langmemroot, user[unr]->language, s);
    expand_macro(unr, s);
    return;
  }
  load_userfile(false, false, Console_call, &uf);
  get_language(nr, langmemroot, uf.language, s);
  expand_macro(unr, s);
}


Static void x_w_btext(short unr, short nr, boolean lf)
{
  Char s[256];

  if (!boxrange(unr))
    return;
  get_btext(unr, nr, s);
  if (nr == 48) {
    if (s[0] == ',') {
      if (s[1] == ' ')
	strdelete((void *)s, 1, 2);
    }
  }
  if (lf)
    wlnuser(unr, s);
  else
    wuser(unr, s);
}


void w_btext(short unr, short nr)
{
  x_w_btext(unr, nr, false);
}


void wln_btext(short unr, short nr)
{
  x_w_btext(unr, nr, true);
}


void unhpath(Char *ins, Char *outs)
{
  short k, i;

  k = strpos2(ins, ".", 1);
  i = strpos2(ins, "-", 1);
  if (k > 0)
    k--;
  else
    k = strlen(ins);
  if (k > 6)
    k = 6;
  if (i > 0 && i <= k)
    k = i - 1;
  sprintf(outs, "%.*s", k, ins);
}


/* 'es gibt momentan keine nachrichten fuer...' */

void no_files(short unr, Char *name)
{
  Char STR1[256];
  Char hs[256];

  w_btext(unr, 14);
  if (*name == '\0')
    wlnuser(unr, " ()");
  else {
    sprintf(STR1, " %s", name);
    if (callsign(name)) {
      user_mybbs(name, hs);
      if (*hs != '\0') {
        strcat(STR1, " @ ");
        strcat(STR1, hs);
      }
    }
    wlnuser(unr, STR1);
  }
}


/* sucht die Boxusernummer eines durch tnr (= terminal) und pchan (= packet channel) */
/* definierten Benutzers */

short find_buser(short tnr, short pchan)
{
  short x;
  boolean ok;

  x = 1;
  ok = false;
  while (x <= maxuser && !ok) {
    if (user[x] != NULL)
      ok = (user[x]->tcon == tnr && user[x]->pchan == pchan);
    if (!ok)
      x++;
  }
  if (ok)
    return x;
  else
    return -1;
}


/* Ist der Nutzer z.Z. in der Box eingeloggt ? */

short actual_user(Char *calls)
{
  short x, first;
  boolean ok;

  x = 1;
  first = 0;
  ok = false;

  while (x <= maxuser && !ok) {
    if (user[x] != NULL)
      ok = (strcmp(user[x]->call, calls) == 0);

    if (ok) {
      ok = false;
      if (first == 0) {
	first = x;
	if (user[x]->action == 0 && !user[x]->f_bbs &&
	    user[x]->lastprocnumber == 0 &&
	    boxspoolstatus(user[x]->tcon, user[x]->pchan, -1) == 0)
	  ok = true;
      } else {
	if (user[x]->action == 0 && !user[x]->f_bbs &&
	    user[x]->lastprocnumber == 0 &&
	    boxspoolstatus(user[x]->tcon, user[x]->pchan, -1) == 0) {
	  first = x;
	  ok = true;
	}
      }
    }

    x++;
  }

  return first;
}


void fill_logline(boolean full, short unr, Char *hs)
{
  Char hw1[256], hw2[256], hw3[256];
  userstruct *WITH;

  hs[0] = '\0';
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  *hw1 = '\0';
  strcpy(hw3, WITH->conpath);
  get_word(hw3, hs);
  if (hs[1] == ':')
    strdelete((void *)hs, 1, 2);
  while (*hw3 != '\0')
    get_word(hw3, hw1);
  if (*hw1 != '\0') {
    rspacing(hs, 9);
    cut(hw1, 9);
    rspacing(hw1, 9);
    sprintf(hs + strlen(hs), " v %s", hw1);
  } else
    rspacing(hs, 21);

  if (full) {
    ixdatum2string(WITH->logindate, hw1);
    ixzeit2string(WITH->logindate, hw2);
    sprintf(hs + strlen(hs), " %s %s - ", hw1, hw2);
    ixdatum2string(clock_.ixtime, hw3);
    ixzeit2string(clock_.ixtime, hw2);
    sprintf(hs + strlen(hs), "%s %s", hw3, hw2);
  } else {
    ixzeit2string(WITH->logindate, hw2);
    sprintf(hs + strlen(hs), " %s", hw2);
  }

  sprintf(hw2, "%ld", WITH->rbytes);
  lspacing(hw2, 9);
  strcat(hs, hw2);
  sprintf(hw2, "%ld", WITH->sbytes);
  lspacing(hw2, 9);
  strcat(hs, hw2);
}


void box_logbuch(short unr)
{
  Char hs[256], hw1[256], hw2[256];

  if (!boxrange(unr))
    return;
  fill_logline(true, unr, hs);
  sprintf(hw1, "%sboxlog%ld%cbox", boxprotodir, clock_.mon, extsep);
  if (!exist(hw1)) {
    strcpy(hw2,
      "Call     via    Start (UTC)         End (UTC)          RxBytes  TxBytes");
    append(hw1, hw2, true);
    strcpy(hw2,
      "=======================================================================");
    append(hw1, hw2, true);
  }
  append(hw1, hs, true);
}


boolean wildcardcompare(short fangraster, Char *w, Char *t, Char *wr)
{
  boolean Result;
  short x, y, l, k, z, r, v, hz;
  boolean first;
  Char lastc;
  Char wc[256], tc[256], t1[256];
  Char STR7[256];

  if (debug_level >= 6) {
    sprintf(t1, "%s,%s", w, t);
    debug(6, -1, 152, t1);
    t1[0] = '\0';
  }
  Result = false;

  l = strlen(w);
  if (l == 0 || l > 255)
    return Result;
  if (l == 1 && w[0] == '*')
    return true;


  k = strlen(t);
  if (k == 0 || k > 255)
    return Result;
  if (l == k && !strcmp(w, t))
    return true;

  x = strpos2(w, "*", 1);

  if (x == 0)
    return Result;

  strcpy(wc, w);
  strcpy(tc, t);
  t1[0] = '\0';
  hz = 0;
  lastc = '\0';
  r = strlen(wr);
  if (r > 255)
    r = 0;

_L1:
  first = true;
  if (fangraster == SHORT_MAX)
    fangraster--;

  while (l > 0) {
    if (x > 1) {   /* unmoeglich */
      sprintf(STR7, "%.*s", x - 1, wc);
      z = strpos2(tc, STR7, 1);
      if (z != 1)
	return Result;
      strdelete((void *)tc, 1, x - 1);
      strdelete((void *)wc, 1, x - 1);
      if (x == l)
	return true;
    } else if (x == 1 && l > 1) {
      strdelete((void *)wc, 1, 1);
      l--;

      y = strpos2(wc, "*", 1);
      if (y > 1) {
	sprintf(STR7, "%.*s", y - 1, wc);
	z = strpos2(tc, STR7, 1);
	if (z < 1 || !first && z > fangraster + 1)
	  return Result;
	if (first)
	  hz = z + y - 2;

	if (r > 0 && !first) {
	  for (v = 0; v <= z - 2; v++) {
	    sprintf(STR7, "%c", tc[v]);
	    if (strpos2(wr, STR7, 1) == 0) {
	      if (tc[v] != lastc) {
		if (hz > 0) {
		  strcpy(wc, w);
		  if (*t1 == '\0')
		    strcpy(t1, t);
		  strdelete((void *)t1, 1, hz);
		  strcpy(tc, t1);
		  lastc = '\0';
		  goto _L1;
		} else
		  return Result;
	      }
	    }
	  }
	}

	lastc = wc[0];
	strdelete((void *)tc, 1, z + y - 2);
	strdelete((void *)wc, 1, y - 1);
      } else if (y == 0) {
	if (l > 0) {
	  z = strlen(tc) - l;
	  if (z < 0 || !first && z > fangraster)
	    return Result;

	  if (r > 0 && !first) {
	    for (v = 0; v < z; v++) {
	      sprintf(STR7, "%c", tc[v]);
	      if (strpos2(wr, STR7, 1) == 0) {
		if (tc[v] != lastc)
		  return Result;
	      }
	    }
	  }

	  strdelete((void *)tc, 1, z);
	  return (strcmp(wc, tc) == 0);
	} else
	  return true;
	return Result;
      }

      /* else doppeltes ** - macht aber nichts, kommt im naechsten Durchlauf dran */
    } else if (x == 1 && l == 1)
      return true;
    else if (x == 0)
      return (strcmp(wc, tc) == 0);
    else
      return Result;

    x = strpos2(wc, "*", 1);
    l = strlen(wc);
    first = false;
  }
  return Result;
}


Static Char dwr_string[256];


Static void setup_dwrstring(void)
{
  short x;

  *dwr_string = '\0';
  for (x = 1; x <= 63; x++)
    sprintf(dwr_string + strlen(dwr_string), "%c", x);
  for (x = 91; x <= 96; x++)
    sprintf(dwr_string + strlen(dwr_string), "%c", x);
  for (x = 123; x <= 127; x++)
    sprintf(dwr_string + strlen(dwr_string), "%c", x);
  for (x = 168; x <= 175; x++)
    sprintf(dwr_string + strlen(dwr_string), "%c", x);
  for (x = 185; x <= 224; x++)
    sprintf(dwr_string + strlen(dwr_string), "%c", x);
  for (x = 226; x <= 255; x++)
    sprintf(dwr_string + strlen(dwr_string), "%c", x);
}


boolean check_for_dirty(Char *hs)
{
  dirtytype *hp;
  Char STR1[58];

  debug0(6, -1, 143);
  hp = badwordroot;

  while (hp != NULL) {
    if (wildcardcompare(50, hp->bad, hs, dwr_string)) {
      sprintf(STR1, "dirty, keyword: %s", hp->bad);
      boxprotokoll(STR1);
      return true;
    }
    hp = hp->next;
  }
  return false;
}


boolean check_for_dirty2(Char *bs, Char *hs)
{
  return (wildcardcompare(50, bs, hs, dwr_string));
}


void check_reject(Char *frombox, Char msgchar, Char *ziel, Char *mbx,
		  Char *absender, Char *lifetime, Char *betreff, Char *bid,
		  long laenge, boolean is_local, boolean is_privlocal,
		  boolean *reject_it, boolean *no_sf)
{
  rejecttype *hp;
  Char w[256], s[256];

  debug0(5, -1, 141);
  hp = rejectroot;
  s[0] = '\0';
  w[0] = '\0';

  while (hp != NULL) {
    if ((hp->msgtype == msgchar) == hp->msgtypeneg || hp->msgtype == '*') {
      if ((hp->maxsize <= laenge) == hp->maxsizeneg) {
	if (wildcardcompare(SHORT_MAX, hp->from, absender, s) == hp->fromneg) {
	  if (wildcardcompare(SHORT_MAX, hp->mbx, mbx, s) == hp->mbxneg) {
	    if (wildcardcompare(SHORT_MAX, hp->tob, ziel, s) == hp->tobneg) {
	      if (wildcardcompare(SHORT_MAX, hp->bid, bid, s) == hp->bidneg) {
		switch (hp->what) {

		case 'R':
		  *reject_it = true;
		  return;
		  break;

		case 'H':
		  *no_sf = true;
		  break;

		case 'L':
		  if (is_local)
		    *no_sf = true;
		  break;

		case 'P':
		  if (is_local && !is_privlocal)
		    *no_sf = true;
		  break;
		}
	      }
	    }
	  }
	}
      }
    }

    hp = hp->next;
  }


}



Static boolean convtit2(boolean iscall, boolean ltconv, convtittype *hp,
			Char *ziel, Char *mbx, Char *absender1,
			Char *lifetime1, Char *betreff1)
{
  boolean Result;
  unsigned short olt;
  Char orub[9];
  boolean ok, ok2, frag;
  short k;
  boolean einbuch;
  Char s[256], s2[256], hs[256];
  Char w[256], w2[256];

  Result = false;
  if (hp == NULL)
    return Result;
  ok = false;
  frag = false;
  strcpy(orub, hp->fromboard);
  k = strlen(orub);
  if (k > 2) {
    if (strpos2(orub, "*", 1) == k) {
      frag = true;
      strdelete((void *)orub, k, 1);
    }
  }

  einbuch = (strlen(ziel) == 1);

  if (strcmp(orub, ziel) && (strcmp(orub, "*") || iscall || einbuch) &&
      (strcmp(orub, "**") || einbuch) &&
      (!frag || einbuch || strpos2(ziel, orub, 1) != 1) &&
      (strcmp(orub, "!") || iscall || einbuch || defined_board(ziel)))
    return ok;

  strcpy(s, betreff1);
  upper(s);

  strcpy(hs, hp->title);
  ok = (*hs != '\0');
  while (*hs != '\0' && ok) {
    get_word(hs, w);
    if (*w == '\0')
      continue;
    switch (w[0]) {

    case '&':
      strdelete((void *)w, 1, 1);
      ok = (ok && !strcmp(absender1, w));
      break;

    case '@':
      strdelete((void *)w, 1, 1);
      ok = (ok && !strcmp(mbx, w));
      break;

    case '%':
      strdelete((void *)w, 1, 1);
      ok = (ok && !strcmp(ziel, w));
      break;

    case '~':  /* quatsch, gestrichen */
      ok = false;
      break;

    case '$':  /* dito*/
      ok = false;
      break;

    case '^':
      ok2 = false;
      strdelete((void *)w, 1, 1);
      if (strpos2(s, w, 1) > 0) {
	strcpy(s2, s);
	while (*s2 != '\0' && !ok2) {
	  get_word(s2, w2);
	  ok2 = (strcmp(w2, w) == 0);
	}
      }
      ok = (ok && ok2);
      break;

    default:
      ok = (ok && strpos2(s, w, 1) > 0);
      break;
    }
  }

  if (!ok)
    return ok;
  if (!ltconv)
    strcpy(ziel, hp->toboard);
  olt = (unsigned short)Str2int(lifetime1);
  if (olt > hp->newlt || olt == 0 && hp->newlt > 0)
    sprintf(lifetime1, "%ld", hp->newlt);
  return ok;
}


void do_convtit(Char *frombox, Char msgchar, Char *ziel, Char *mbx,
		Char *absender1, Char *lifetime1, Char *betreff1, Char *bid,
		long laenge, boolean is_local, boolean is_privlocal,
		boolean *reject_it, boolean *no_sf)
{
  convtittype *hp;
  boolean ok, ok3, iscall;
  Char ob[256], olt[256];
  Char hs[256];

  debug0(5, -1, 142);
  ok = false;
  ok3 = false;
  iscall = callsign(ziel);

  if (create_convlog) {
    strcpy(ob, ziel);
    strcpy(olt, lifetime1);
  }

  if (rejectroot != NULL)
    check_reject(frombox, msgchar, ziel, mbx, absender1, lifetime1, betreff1,
		 bid, laenge, is_local, is_privlocal, reject_it, no_sf);

  if (*reject_it)
    return;

  hp = convtitroot;
  while (hp != NULL && !ok) {
    ok = convtit2(iscall, false, hp, ziel, mbx, absender1, lifetime1,
		  betreff1);
    hp = hp->next;
  }

  hp = convltroot;
  while (hp != NULL && !ok3) {
    ok3 = convtit2(iscall, true, hp, ziel, mbx, absender1, lifetime1,
		   betreff1);
    hp = hp->next;
  }

  if (!(create_convlog && (ok || ok3) &&
	(strcmp(ob, ziel) || strcmp(olt, lifetime1))))
    return;

  if (!strcmp(ziel, ob))
    strcpy(ob, "-");
  rspacing(ob, 8);
  rspacing(olt, 3);
  sprintf(hs, "%s %s ", ob, olt);
  strcpy(ob, ziel);
  strcpy(olt, lifetime1);
  rspacing(ob, 8);
  rspacing(olt, 3);
  sprintf(hs + strlen(hs), "%s %s %s", ob, olt, betreff1);
  cut(hs, 54);
  append_convlog(-1, hs);
}


void show_rfile(short unr, uchar *base, long size, boolean mit_r, boolean sf,
		boolean only_headers)
{
  long lesezeiger, bodystart;
  short lct, k;
  boolean nop, is_r;
  Char zeile[256];
  Char hs[256], zl[256], lr[256];
  Char STR7[256];

  debug0(4, unr, 109);

  if (sf) {
    show_puffer(unr, base, size);
    return;
  }

  if (mit_r) {
    if (!only_headers) {
      show_puffer(unr, base, size);
      return;
    }



    lesezeiger = 0;
    is_r = true;

    while (lesezeiger < size && is_r) {
      get_line(base, &lesezeiger, size, zeile);
      if (strlen(zeile) <= 18)
	continue;
      if (strpos2(zeile, "I:", 1) == 1)
	wlnuser(unr, zeile);
      else if (strpos2(zeile, "R:", 1) == 1)
	wlnuser(unr, zeile);
      else
	is_r = false;
    }

    return;
  }


  lesezeiger = 0;
  bodystart = 0;
  lct = 0;
  *hs = '\0';
  *zl = '\0';
  *lr = '\0';
  is_r = true;
  while (lesezeiger < size && is_r) {
    nop = false;
    get_line(base, &lesezeiger, size, zeile);
    bodystart = lesezeiger;
    lct++;
    if (strlen(zeile) > 18) {
      if (strpos2(zeile, "I:", 1) == 1)
	zeile[0] = 'R';
      if (strpos2(zeile, "R:", 1) == 1) {
	if (!mit_r)
	  strcpy(lr, zeile);
	k = strpos2(zeile, "@", 1);
	if (k > 0) {
	  strsub(hs, zeile, k + 1, strlen(zeile) - k);
	  if (hs[0] == ':')
	    strdelete((void *)hs, 1, 1);
	  k = strpos2(hs, " ", 1);
	  if (k > 0)
	    strdelete((void *)hs, k, strlen(hs) - k + 1);

	  if (!mit_r) {
	    unhpath(hs, hs);
	    *zeile = '\0';

	    if (*zl == '\0') {
	      if (lct == 1) {
		if (*hs != '\0')
		  sprintf(hs, "%s!%s", Console_call, strcpy(STR7, hs));
		else
		  strcpy(hs, Console_call);
		sprintf(zl, "Path: %s", hs);
	      } else
		sprintf(zl, "Path: !%s", hs);

	      nop = true;

	    } else if (strlen(zl) < 70) {
	      sprintf(zl + strlen(zl), "!%s", hs);
	      nop = true;

	    } else {
	      strcpy(zeile, zl);
	      sprintf(zl, "Path: !%s", hs);
	      nop = false;

	    }


	  }

	} else
	  is_r = false;
      } else if (*zl != '\0' && !mit_r) {
	wlnuser(unr, zl);
	*zl = '\0';
	if (strlen(lr) > 15) {
	  strdelete((void *)lr, 1, 2);
	  cut(lr, 73);
	  wuser(unr, "Sent: ");
	  wlnuser(unr, lr);
	  *lr = '\0';
	}
	is_r = false;
      } else
	is_r = false;
    } else if (*zl != '\0' && !mit_r) {
      wlnuser(unr, zl);
      *zl = '\0';
      if (strlen(lr) > 15) {
	strdelete((void *)lr, 1, 2);
	cut(lr, 73);
	wuser(unr, "Sent: ");
	wlnuser(unr, lr);
	*lr = '\0';
      }
      is_r = false;
    }
    if (!nop && !mit_r) {
      wlnuser(unr, zeile);
      *zeile = '\0';
    }
  }

  if (mit_r)
    return;

  if (*zl != '\0') {
    wlnuser(unr, zl);
    *zl = '\0';
  }
  if (*zeile != '\0') {
    wlnuser(unr, zeile);
    *zl = '\0';
  }
  if (!only_headers)
    show_puffer(unr, (uchar *)(&base[bodystart]), size - bodystart);

}


void show_textfile(short unr, Char *name)
{
  long size, lz;
  uchar *rp;
  Char hs[256];

  sfbread(true, name, &rp, &size);
  if (size <= 0) {
    if (!exist(name))
      wlnuser(unr, "file not found");
    return;
  }
  lz = 0;
  while (lz < size) {
    get_line(rp, &lz, size, hs);
    if (user[unr] != NULL && user[unr]->in_begruessung &&
	hs[strlen(hs) - 1] == '>')
      hs[strlen(hs) - 1] = ']';
    wlnuser(unr, hs);
  }
  mymfreep(&rp);
}


Static void show_allhelp(short unr, Char *fn_, Char *hw_)
{
  Char fn[256];
  Char hw[256];
  short k;
  uchar *tb;
  long tbs, rp;
  Char hs[256], h2[256];
  Char STR7[256];

  strcpy(fn, fn_);
  strcpy(hw, hw_);
  sprintf(hw, " %s ", strcpy(STR7, hw));
  upper(hw);


  sfbread(false, fn, &tb, &tbs);
  if (tb != NULL) {
    rp = 0;

_L1:
    while (rp < tbs) {
      get_line(tb, &rp, tbs, hs);
      if (strpos2(hs, "---", 1) != 1)
	continue;
      while (rp < tbs) {
	get_line(tb, &rp, tbs, hs);
	del_leadblanks(hs);
	if (*hs == '\0')
	  continue;
	sprintf(h2, " %s ", hs);
	if (strpos2(h2, hw, 1) > 0) {
	  wlnuser(unr, hs);
	  while (rp < tbs) {
	    get_line(tb, &rp, tbs, hs);
	    if (strpos2(hs, "---", 1) == 1)
	      goto _L2;
	    wlnuser(unr, hs);
	  }
_L2:
	  mymfreep(&tb);
	  wlnuser0(unr);
	  return;
	} else {
	  goto _L1;
	  continue;
	}
      }
    }
    mymfreep(&tb);
    wln_btext(unr, 30);
    return;
  }

  k = sfopen(fn, FO_READ);
  if (k < minhandle) {
    wln_btext(unr, 4);
    return;
  }
_L3:
  while (file_to_string(k, hs)) {
    if (strpos2(hs, "---", 1) != 1)
      continue;
    while (file_to_string(k, hs)) {
      del_leadblanks(hs);
      if (*hs == '\0')
	continue;
      sprintf(h2, " %s ", hs);
      if (strpos2(h2, hw, 1) > 0) {
	wlnuser(unr, hs);
	while (file_to_string(k, hs) && strpos2(hs, "---", 1) != 1)
	  wlnuser(unr, hs);
	sfclose(&k);
	wlnuser0(unr);
	return;
      } else {
	goto _L3;
	continue;
      }
    }
  }
  sfclose(&k);
  wln_btext(unr, 30);
}


void show_help(short unr, Char *w_)
{
  Char w[256];
  DTA dirinfo;
  short result;
  Char fname[256], hname[256];
  userstruct *WITH;
  Char STR1[256], STR7[256];

  strcpy(w, w_);
  debug(2, unr, 110, w);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (*w == '\0')
    sprintf(fname, "%sHELP%c%s", boxlanguagedir, extsep, WITH->language);
  else {
    expand_command(unr, w);
    sprintf(STR1, "%s%s%cALL", boxlanguagedir, WITH->language, extsep);
    if (exist(STR1)) {
      sprintf(hname, "%s%s%cALL", boxlanguagedir, WITH->language, extsep);
      show_allhelp(unr, hname, w);
      return;
    }
    sprintf(STR7, "%sG%cALL", boxlanguagedir, extsep);
    if (exist(STR7)) {
      sprintf(hname, "%sG%cALL", boxlanguagedir, extsep);
      show_allhelp(unr, hname, w);
      return;
    }
    sprintf(hname, "%s%s%c%c%s",
	    boxlanguagedir, w, allquant, extsep, WITH->language);
    result = sffirst(hname, 0, &dirinfo);
    if (result != 0)
      sprintf(dirinfo.d_fname, "ERROR%c%s", extsep, WITH->language);
    sprintf(fname, "%s%s", boxlanguagedir, dirinfo.d_fname);
  }
  if (!exist(fname))
    new_ext(fname, "G");
  if (exist(fname))
    show_textfile(unr, fname);
  else
    wln_btext(unr, 30);
  wlnuser0(unr);

  if (!(WITH->supervisor && *w == '\0'))
    return;
  sprintf(fname, "%sHELP_SYS%c%s", boxlanguagedir, extsep, WITH->language);
  if (!exist(fname))
    new_ext(fname, "G");
  if (exist(fname))
    show_textfile(unr, fname);
  else
    wln_btext(unr, 31);
  wlnuser0(unr);
}


/* boardnamen (und calls) duerfen nur aus 0..9 / A..Z - _ bestehen, und mindestens ein Buchstabe... */

boolean valid_boardname(Char *rubrik)
{
  boolean ok, notnum;
  short x, l;

  l = strlen(rubrik);
  notnum = false;
  if ((unsigned)l >= 32 || ((1L << l) & 0x1fe) == 0) {
    ok = false;
    return (ok && notnum);
  }
  ok = true;
  for (x = 0; x < l; x++) {
    if (!(rubrik[x] == '_' || rubrik[x] == '-' || isupper(rubrik[x]) ||
	  isdigit(rubrik[x])))
      ok = false;
    else if (isupper(rubrik[x]))
      notnum = true;
  }
  return (ok && notnum);
}


void extend_6_to_8(Char *rubr)
{
  rubriktype *hp;
  Char hv[9];

  if (strlen(rubr) != 6 || callsign(rubr))
    return;
  hp = rubrikroot;
  while (hp != NULL) {
    if (strlen(hp->name) <= 6) {
      hp = hp->next;
      continue;
    }
    strcpy(hv, hp->name);
    cut(hv, 6);
    if (!strcmp(hv, rubr)) {
      strcpy(rubr, hp->name);
      hp = NULL;
    } else
      hp = hp->next;
  }
}


boolean defined_board(Char *rubr)
{
  rubriktype *hp;
  boolean ok;

  ok = (callsign(rubr) || strlen(rubr) == 1);
  if (!ok) {
    hp = rubrikroot;
    while (hp != NULL) {
      if (!strcmp(hp->name, rubr)) {
	ok = true;
	hp = NULL;
      } else
	hp = hp->next;
    }
  }
  if (ok)
    ok = (strcmp(rubr, "X") && strcmp(rubr, "D"));
  return ok;
}


void switch_to_default_board(Char *rubr)
{
  if (*default_rubrik == '\0')
    return;
  if (*rubr != '\0') {
    if (!defined_board(rubr))
      strcpy(rubr, default_rubrik);
  }
}


void check_verteiler(Char *rubr)
{
  transfertype *hp;
  boolean loop;

  loop = false;
  extend_6_to_8(rubr);   /*bei S&F-Namensbegrenzung auf 6 Bytes...*/
_L1:
  hp = transferroot;
  if (hp != NULL) {
    while (hp != NULL && strcmp(hp->board1, rubr))
      hp = hp->next;

    if (hp != NULL)
      strcpy(rubr, hp->board2);
  }


  if (strcmp(rubr, "X") && strcmp(rubr, "D"))
    return;
  if (*default_rubrik != '\0') {
    strcpy(rubr, default_rubrik);
    return;
  }
  strcpy(rubr, "DIV");
  if (!loop) {
    loop = true;
    goto _L1;
  }
}


void chk_maxlt(unsigned short *lt1, unsigned short ltd)
{
  if (ltd == 0)
    return;
  if (*lt1 == 0)
    *lt1 = ltd;
  else if (*lt1 > ltd)
    *lt1 = ltd;
}


void check_lt_acc(Char *rubr, unsigned short *lt, unsigned short *acc)
{
  rubriktype *hp;

  hp = rubrikroot;
  while (hp != NULL) {
    if (!strcmp(hp->name, rubr)) {
      if (hp->lifetime > 0)
	chk_maxlt(lt, hp->lifetime);
      *acc = hp->access;
      return;
    }
    hp = hp->next;
  }

  if (callsign(rubr)) {
    chk_maxlt(lt, userlifetime);
    *acc = 1;
    return;
  }
  if (strlen(rubr) != 1) {
    chk_maxlt(lt, erasedelay);
    *acc = 1;
    return;
  }
  chk_maxlt(lt, erasedelay);
  *lt = erasedelay;
  *acc = 10;
}


boolean may_sysaccess(short unr, Char *board)
{
  boolean Result;
  unsigned short lt, acc;

  Result = false;
  if (!boxrange(unr))
    return Result;
  if (user[unr]->supervisor ||
      user[unr]->rsysop && in_rsysops_boards(user[unr]->call, board)) {
    check_lt_acc(board, &lt, &acc);
    return (user[unr]->level >= acc);
  }
  return Result;
}


void check_msgtype(Char *msgtype, Char *ziel, Char *betreff)
{
  if (*msgtype != '\0')
    return;
  if (!callsign(ziel)) {
    *msgtype = 'B';
    return;
  }
  if (*betreff == '\0') {
    *msgtype = 'P';
    return;
  }
  if (strpos2(betreff, "ACK:", 1) != 1)
    *msgtype = 'P';
  else
    *msgtype = 'A';
}


long truesize(indexstruct rec)
{
  long sz;

  if (strcmp(rec.dest, "M")) {
    sz = rec.size + strlen(rec.betreff) + 64;   /* Laenge des Headers */
    /* CR LF * 3         */
    if (*rec.id != '\0')
      sz += 35;
    if (*rec.rxfrom != '\0')
      sz += strlen(rec.rxfrom) + 26;
    return sz;
  } else
    return 0;
}


/*
diebox:
DL8HBS @DB0GR.DEU.EU de:DL7WA  15.09.91 13:37  70    814 Bytes
SP @DB0GR        de:DL7WA  15.09.91 13:37  70    814 Bytes
wampes:
Msg# 19522   To: ALL @WW   From: N0NJY   Date: 04May93/1559
baycom:
DD6OQ  > MEINUN   04.05.93 13:38 39 Zeilen 1805 Bytes #30 @DL
DD6OQ  > MEINUN   04.05.93 13:38 39 Zeilen 1805 Bytes #30 DB0GV@DL
*/

Char separate_status(Char *status_, Char *ziel, Char *absender, Char *mbx,
		     Char *datum, Char *zeit, Char *laenge, Char *lifetime)
{
  Char status[256];
  Char hs[256];
  cutboxtyp typ;
  short x;
  Char mtype;
  short TEMP;
  Char STR7[256];

  strcpy(status, status_);
  cut(status, 200);
  debug(5, 0, 111, status);

  typ = boxheader(status);
  mtype = '\0';
  *ziel = '\0';
  *absender = '\0';
  *mbx = '\0';
  *datum = '\0';
  *zeit = '\0';
  *laenge = '\0';
  *lifetime = '\0';

  if (((1L << ((long)typ)) &
       ((1L << ((long)THEBOX_USER)) | (1L << ((long)NOP)))) != 0) {
    if (count_words(status) != 8)
      return mtype;
    get_word(status, hs);
    cut(hs, 8);
    strcpy(ziel, hs);
    upper(ziel);
    get_word(status, hs);
    if (hs[0] == '@')
      strdelete((void *)hs, 1, 1);
    cut(hs, 40);
    strcpy(mbx, hs);
    upper(mbx);
    get_word(status, hs);
    if (strpos2(hs, "de:", 1) == 1)
      strdelete((void *)hs, 1, 3);
    cut(hs, 6);
    strcpy(absender, hs);
    upper(absender);
    get_word(status, hs);
    cut(hs, 8);
    strcpy(datum, hs);
    get_word(status, hs);
    cut(hs, 5);
    strcpy(zeit, hs);
    get_word(status, hs);
    cut(hs, 3);
    strcpy(lifetime, hs);
    get_word(status, hs);
    cut(hs, 8);
    strcpy(laenge, hs);

    get_word(status, hs);
    if (strpos2(hs, "Byte", 1) != 1) {
      *ziel = '\0';
      *absender = '\0';
    } else {
      if (strpos2(hs, "~", 1) == 6)
	mtype = hs[6];
    }
    return mtype;
  }

  if (typ == BAYCOM_USER) {
    TEMP = count_words(status);
    if (!((unsigned)TEMP < 32 && ((1L << TEMP) & 0xc00) != 0))
      return mtype;
    get_word(status, absender);
    get_word(status, hs);
    get_word(status, ziel);
    get_word(status, datum);
    get_word(status, zeit);
    get_word(status, hs);
    get_word(status, hs);
    get_word(status, laenge);
    get_word(status, hs);
    if (strcmp(hs, "Bytes")) {
      *ziel = '\0';
      *absender = '\0';
      return mtype;
    }
    get_word(status, hs);
    if (*hs == '\0')
      return mtype;
    if (hs[0] == '#') {
      strcpy(lifetime, hs);
      strdelete((void *)lifetime, 1, 1);
      get_word(status, hs);
    }
    if (*hs == '\0')
      return mtype;

    x = strpos2(hs, "@", 1);
    if (x > 0) {
      strdelete((void *)hs, 1, x);
      strcpy(mbx, hs);
    }
    return mtype;
  }

  if (typ != WAMPES_USER)
    return mtype;
  if (strpos2(status, "bbs>", 1) == 1)
    strdelete((void *)status, 1, 4);
  if (count_words(status) != 9)
    return mtype;
  get_word(status, hs);
  get_word(status, hs);
  get_word(status, hs);
  if (strcmp(hs, "To:"))
    return mtype;
  get_word(status, ziel);
  get_word(status, mbx);
  strdelete((void *)mbx, 1, 1);
  get_word(status, hs);
  get_word(status, absender);
  get_word(status, hs);
  get_word(status, hs);
  strsub(zeit, hs, 9, 4);
  cut(hs, 7);
  if (strlen(zeit) == 4)
    strinsert(":", (void *)zeit, 3);
  strcpy(datum, hs);
  strdelete((void *)datum, 3, 3);
  strdelete((void *)hs, 1, 2);
  cut(hs, 3);
  if (!strcmp(hs, "Jan"))
    strcpy(hs, "01");
  else if (!strcmp(hs, "Feb"))
    strcpy(hs, "02");
  else if (!strcmp(hs, "Mar"))
    strcpy(hs, "03");
  else if (!strcmp(hs, "Apr"))
    strcpy(hs, "04");
  else if (!strcmp(hs, "May"))
    strcpy(hs, "05");
  else if (!strcmp(hs, "Jun"))
    strcpy(hs, "06");
  else if (!strcmp(hs, "Jul"))
    strcpy(hs, "07");
  else if (!strcmp(hs, "Aug"))
    strcpy(hs, "08");
  else if (!strcmp(hs, "Sep"))
    strcpy(hs, "09");
  else if (!strcmp(hs, "Oct"))
    strcpy(hs, "10");
  else if (!strcmp(hs, "Nov"))
    strcpy(hs, "11");
  else if (!strcmp(hs, "Dec"))
    strcpy(hs, "12");
  else
    strcpy(hs, "01");
  sprintf(hs, ".%s.", strcpy(STR7, hs));
  strinsert(hs, (void *)datum, 3);
  strcpy(laenge, "999999");
  return mtype;
}


void create_status(long additional, boolean hierarchicals, Char *name,
		   indexstruct header, Char *status)
{
  Char hs[256], w[256];
  Char STR7[256];

  strcpy(hs, header.verbreitung);
  if (!hierarchicals) {
    unhpath(hs, hs);
    sprintf(hs, "%s @%s", name, strcpy(STR7, hs));
    rspacing(hs, 17);
  } else
    sprintf(hs, "%s @%s ", name, header.verbreitung);
  sprintf(hs + strlen(hs), "de:%s ", header.absender);
  rspacing(hs, 27);
  strcpy(status, hs);
  ix2string(header.rxdate, hs);
  cut(hs, 14);
  sprintf(status + strlen(status), "%s ", hs);
  sprintf(hs, "%ld", header.lifetime);   /* war mal header.lifetime */
  lspacing(hs, 3);
  sprintf(w, "%ld", truesize(header) + additional);
  lspacing(w, 6);
  sprintf(hs + strlen(hs), " %s Bytes", w);
  if (hierarchicals && header.msgtype != '\0')
    sprintf(hs + strlen(hs), "~%c", header.msgtype);
  strcat(status, hs);
}


/* Dies ist speziell fuer den Broadcast - Empfang */

void create_status2(boolean hierarchicals, Char *dest, Char *absender,
		    long rxdate, long expire_time, long size, Char msgtype,
		    Char *status)
{
  short k, lifetime;
  long hl;
  Char hs[256], w[256];

  debug(4, 0, 112, dest);
  *w = '\0';
  strcpy(hs, dest);
  k = strpos2(hs, "@", 1);
  if (k > 0) {
    strsub(w, hs, k + 1, strlen(hs) - k);
    cut(hs, k - 1);
  }
  del_blanks(hs);
  cut(hs, 8);
  del_blanks(w);
  cut(w, 40);

  if (*w == '\0')
    strcpy(w, Console_call);

  if (!hierarchicals) {
    unhpath(w, w);
    sprintf(hs + strlen(hs), " @%s", w);
    rspacing(hs, 17);
  } else
    sprintf(hs + strlen(hs), " @%s ", w);

  strcpy(w, absender);
  k = strpos2(w, "@", 1);
  if (k > 0)   /* bei Pacsats sind auch Absender mit @bbs ueblich */
    cut(w, k - 1);
  del_blanks(w);
  cut(w, 6);
  sprintf(hs + strlen(hs), "de:%s ", w);
  rspacing(hs, 27);

  strcpy(status, hs);
  ix2string(rxdate, hs);
  cut(hs, 14);
  sprintf(status + strlen(status), "%s ", hs);

  lifetime = 0;
  if (expire_time > 0) {
    hl = expire_time - clock_.ixtime;
    if (hl >= 86400L)
      lifetime = (hl + 86399L) / 86400L;
    else
      lifetime = 1;
  }
  if (lifetime > 999)
    lifetime = 999;
  sprintf(hs, "%ld", lifetime);
  lspacing(hs, 3);

  sprintf(w, "%ld", size + 180);   /* 180 Bytes fuer Header... */
  lspacing(w, 6);
  sprintf(hs + strlen(hs), " %s Bytes", w);

  if (hierarchicals && msgtype != '\0')
    sprintf(hs + strlen(hs), "~%c", msgtype);

  strcat(status, hs);
}


Static void generate_it(Char *s, unsigned short *crc)
{
  short x, FORLIM;

  FORLIM = strlen(s);
  for (x = 0; x < FORLIM; x++)
    crcthp(s[x], crc);
}


void create_userid(Char *call, Char *absender, Char *datum, Char *zeit,
		   Char *betreff, Char *userid)
{
  unsigned short l;
  Char hs[256];
  Char hcall[256];
  Char STR1[256];

  strcpy(hcall, call);
  cut(hcall, 6);
  l = 0;
  generate_it(absender, &l);
  generate_it(datum, &l);
  generate_it(zeit, &l);
  generate_it(betreff, &l);
  sprintf(hs, "%ld", l);
  while (strlen(hs) < 5)
    sprintf(hs, "0%s", strcpy(STR1, hs));
  sprintf(userid, "%s!", hs);
  while (strlen(userid) + strlen(hcall) < 12)
    strcat(userid, "_");
  strcat(userid, hcall);
  upper(userid);
  cut(userid, 12);
}


long new_msgnum(void)
{
  actmsgnum++;
  if (actmsgnum < 1 || actmsgnum + msgnumoffset > maxlonginteger)
    actmsgnum = 1;
  return actmsgnum;
}


Static long lastbidtick;


void new_bid(Char *bid)
{
  short x;
  boolean ccl;
  Char c1;
  long st, lb, nib;

  debug0(3, 0, 113);
  ccl = (strlen(Console_call) > 5);
  st = clock_.ixtime;
  if (st < lastbidtick)
    st = lastbidtick;
  do {
    strcpy(bid, "000000");
    lb = st;
    for (x = 1; x <= 6; x++) {
      nib = lb % 36;
      lb /= 36;
      if (nib < 10)
	c1 = (Char)(nib + '0');
      else if (nib < 37)
	c1 = (Char)(nib - 10 + 'A');
      else
	c1 = '-';
      bid[6 - x] = c1;
    }

    if (ccl)
      strinsert(Console_call, (void *)bid, 7 - sub_bid);
    else {
      if (sub_bid == 0)
	c1 = '_';
      else
	c1 = sub_bid + '0';
      sprintf(bid + strlen(bid), "%c%s", c1, Console_call);
    }

    cut(bid, 12);
    st++;
  } while (!check_double(bid));
  lastbidtick = st;

  /* sollte nicht vorkommen hi */
}




/* Split S(end)line ... Sucht aus der Send-Angabe des Users (oder der W0RLI- */
/* S&F - Mailbox) die noetigen Angaben heraus                                */

Static boolean ordne_sparm_zu(Char *inp_, Char *inp1_, Char *mbx, Char *lt,
			      Char *bid, Char *call2)
{
  boolean Result;
  Char inp[256], inp1[256];
  short k;

  strcpy(inp, inp_);
  strcpy(inp1, inp1_);
  if (*inp == '\0')
    return false;
  Result = true;
  switch (inp[0]) {

  case '@':
    strdelete((void *)inp, 1, 1);
    if (strlen(inp) >= 1 && strlen(inp) <= 40)
      strcpy(mbx, inp);
    else {
      k = strpos2(inp, ".", 1);
      if (k >= 2 && k <= 40) {
	cut(inp, k - 1);
	strcpy(mbx, inp);
      } else {
	cut(inp, 40);
	strcpy(mbx, inp);
      }
    }

    if (*mbx != '\0') {
      if (mbx[strlen(mbx) - 1] == '.')
	mbx[strlen(mbx) - 1] = '\0';
    }
    break;

  case '#':
    if ((unsigned long)strlen(inp) < 32 &&
	((1L << strlen(inp)) & 0x1c) != 0 && isdigit(inp[1])) {
      strdelete((void *)inp, 1, 1);
      strcpy(lt, inp);
    } else
      Result = false;
    break;

  case '<':
    if ((unsigned long)strlen(inp) < 32 && ((1L << strlen(inp)) & 0xfc) != 0) {
      strdelete((void *)inp, 1, 1);
      strcpy(call2, inp);
    } else
      Result = false;
    break;

  case '$':
    strdelete((void *)inp1, 1, 1);
    cut(inp, 12);
    if (*inp != '\0')
      strcpy(bid, inp1);
    break;

  default:
    Result = false;
    break;
  }
  return Result;
}


Static void normalisiere_send(Char ch, Char *inp, boolean correct, short *p)
{
  short k, l;


  k = *p;
  l = strlen(inp);
  if (l < 1 || l > 255)
    return;

  while (k < l && inp[k - 1] != ch)
    k++;


  if (inp[k - 1] != ch)
    k = 0;

  if (k <= 0)
    return;

  if (k > 1 && correct) {
    if (inp[k - 2] != ' ' && inp[k - 2] != '.') {
      strinsert(" ", (void *)inp, k);
      k++;
    }
  }

  if (k == 1 || inp[k - 2] == ' ') {
    while (strlen(inp) > k && inp[k] == ' ')
      strdelete((void *)inp, k + 1, 1);
  }

  *p = k;
  while (*p < strlen(inp) && inp[*p - 1] != ' ')
    (*p)++;

}


void split_sline(Char *eingabe_, Char *call1, Char *call2, Char *mbx,
		 Char *bid, Char *lt, Char *betreff)
{
  Char eingabe[256];
  short p;
  Char hs[256], hs1[256], hs2[256];

  strcpy(eingabe, eingabe_);
  debug(4, 0, 114, eingabe);
  *call1 = '\0';
  *call2 = '\0';
  *mbx = '\0';
  strcpy(lt, "-");
  strcpy(bid, "#NONE#");
  *betreff = '\0';

  p = strlen(eingabe);
  if (p < 1 || p > 255)
    return;

  p = 1;
  normalisiere_send('@', eingabe, true, &p);
  normalisiere_send('<', eingabe, false, &p);
  normalisiere_send('$', eingabe, false, &p);
  normalisiere_send('#', eingabe, false, &p);

  get_word(eingabe, hs);
  if ((unsigned long)strlen(hs) >= 32 || ((1L << strlen(hs)) & 0x1fe) == 0)
    return;
  upper(hs);
  if (hs[0] == '\032' || hs[0] == '$' || hs[0] == '<' || hs[0] == '#' ||
      hs[0] == '@' || hs[0] == '*')
    return;
  strcpy(call1, hs);

  do {

    strcpy(hs1, eingabe);

    get_word(eingabe, hs);
    strcpy(hs2, hs);
    upper(hs);

  } while (ordne_sparm_zu(hs, hs2, mbx, lt, bid, call2));

  strcpy(eingabe, hs1);
  del_leadblanks(eingabe);
  cut(eingabe, 80);
  strcpy(betreff, eingabe);
}


void create_ack(Char *absender, Char *ackcall, Char *dest, Char *umleitung,
		Char *betreff_)
{
  Char betreff[256];
  Char hs[256];
  Char STR1[256];

  strcpy(betreff, betreff_);
  cut(betreff, 76);
  sprintf(betreff, "ACK:%s", strcpy(STR1, betreff));
  sprintf(hs, "%s@%s acknowledged (%s %s UTC)",
	  dest, Console_call, clock_.datum, clock_.zeit);
  if (*umleitung != '\0')
    sprintf(hs + strlen(hs), " - redirected to %s@%s", dest, umleitung);
  cut(hs, 79);
  send_sysmsg(absender, ackcall, betreff, hs, 0);
}


void show_prompt(short unr)
{
  short x;
  Char *p;
  Char prompt[256];
  Char flags[256];
  userstruct *WITH;
  Char STR1[256];

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (*WITH->call == '\0')
    return;
  wlnuser0(unr);
  *prompt = '\0';
  *flags = '\0';

  if (WITH->smode) {
    strcpy(prompt, Console_call);
    lower(prompt);
    sprintf(prompt + strlen(prompt), "-server:%s > ", WITH->spath);
    wuser(unr, prompt);
    return;
  }


  if (WITH->hidden)
    strcat(flags, "H,");
  if (WITH->print)
    strcat(flags, "P,");
  if (WITH->supervisor && WITH->console)
    strcat(flags, "S,");
  if (WITH->undef)
    strcat(flags, "U,");
  if (WITH->supervisor && !sf_allowed)
    strcat(flags, "no s&f,");
  if (WITH->supervisor && gesperrt)
    strcat(flags, "no user,");
  if (WITH->supervisor && disk_full)
    strcat(flags, "disk full,");
  if (WITH->msgselection != 0)
    strcat(flags, "selection,");
  if (*flags != '\0')
    strdelete((void *)flags, strlen(flags), 1);

  if (*WITH->promptmacro != '\0') {
    strcpy(prompt, WITH->promptmacro);
    expand_macro(unr, prompt);
  } else {
    strcpy(prompt, default_prompt);
    expand_macro(unr, prompt);
    if (WITH->in_begruessung) {
      p = strchr(prompt, 13);
      while (p != NULL) {
        *p = ' ';
        p = strchr(prompt, 13);
      }
      p = strchr(prompt, 10);
      while (p != NULL) {
        *p = ' ';
        p = strchr(prompt, 10);
      }
      x = strlen(prompt) - 1;
      if (x < 1) strcpy(prompt, ">");
      else if (prompt[x] != '>') strcat(prompt, ">"); 
    }
  }

  wuser(unr, prompt);

  if (*flags != '\0') {
    sprintf(flags, " [%s] ", strcpy(STR1, flags));
    wuser(unr, flags);
  }



}


void check_replytitle(Char *reply)
{
  short x;
  Char hs[256];
  Char STR1[256];

  strdelete((void *)reply, 1, 3);
  strcpy(hs, reply);
  upper(hs);
  if (strpos2(hs, "RE^", 1) == 1) {
    x = strpos2(hs, ":", 1);
    if ((unsigned)x >= 32 || ((1L << x) & 0x70) == 0) {
      sprintf(reply, "RE:%s", strcpy(STR1, reply));
      return;
    }
    strdelete((void *)reply, 1, 3);
    x -= 3;
    sprintf(hs, "%.*s", x - 1, reply);
    strdelete((void *)reply, 1, x);
    x = Str2int(hs);
    sprintf(hs, "%ld", x + 1);
    sprintf(reply, "RE^%s:%s", hs, strcpy(STR1, reply));
    return;
  }
  if (strpos2(hs, "RE:", 1) == 1) {
    strinsert("^2", (void *)reply, 3);
    return;
  }
  if (strpos2(hs, "RE ", 1) == 1) {
    strdelete((void *)reply, 1, 3);
    sprintf(reply, "RE^2:%s", strcpy(STR1, reply));
  } else
    sprintf(reply, "RE:%s", strcpy(STR1, reply));
}


void get_numbers(short unr, Char *eingabe, short *start, short *ende,
		 Char *option, Char *search)
{
  boolean alphab, numbers, fbb;
  long li;
  short slashct, x, t, y, z;
  Char ein[256], hs[256];
  Char opt2[256];
  Char STR1[256];
  short FORLIM;

  *start = 1;
  *ende = 1;
  *search = '\0';
  *opt2 = '\0';
  fbb = false;

  x = strpos2(eingabe, "$", 1);
  if (x > 0) {
    if (x == 1 || x > 1 && eingabe[x - 2] == ' ' || eingabe[x - 2] == '<') {
      if (strlen(opt2) < 12)
	strcat(opt2, "$");
      strdelete((void *)eingabe, x, 1);
    }
  }

  x = strpos2(eingabe, "\"", 1);
  if (x > 0) {
    strsub(hs, eingabe, x + 1, strlen(eingabe) - x + 2);
    t = strpos2(hs, "\"", 1);
    if (t > 0)
      cut(hs, t - 1);
    strcpy(search, hs);
    upper(search);
    cut(eingabe, x - 1);
    del_lastblanks(eingabe);
  }

  x = strpos2(eingabe, "<", 1);
  if (x > 0) {
    if (*search == '\0') {
      strsub(hs, eingabe, x + 1, strlen(eingabe) - x + 2);
      strcpy(search, hs);
      del_leadblanks(search);
      del_lastblanks(search);
      upper(search);
    }
    cut(eingabe, x - 1);
    del_lastblanks(eingabe);
  }

  if (strpos2(eingabe, ">", 1) > 0)   /* Wegen TRANSFER ! */
    eingabe[strpos2(eingabe, ">", 1) - 1] = ' ';

  for (z = 1; z <= 4; z++) {
    x = strpos2(eingabe, "+", 1);
    if (x > 0) {
      t = strlen(eingabe);
      *hs = '\0';
      y = x;
      y++;
      while (y <= t && eingabe[y - 1] != ' ' && isdigit(eingabe[y - 1])) {
	sprintf(hs + strlen(hs), "%c", eingabe[y - 1]);
	y++;
      }
      if ((unsigned long)strlen(hs) < 32 && ((1L << strlen(hs)) & 0xe) != 0) {
	strdelete((void *)eingabe, x, strlen(hs) + 1);
	while (strlen(hs) < 3)
	  sprintf(hs, "0%s", strcpy(STR1, hs));
	sprintf(opt2 + strlen(opt2), "!&%s", hs);
      } else {
	y = 1;
	if (t > x) {
	  switch (eingabe[x]) {

	  case 'E':
	  case 'e':   /* DieBox-FOR-Befehl */
	    strcat(opt2, "(");
	    break;

	  case 'L':
	  case 'l':   /* dito              */
	    strcat(opt2, ")");
	    break;

	  case ' ':
	    strcat(opt2, "+");
	    break;
	  }
	  y = 2;
	} else
	  strcat(opt2, "+");
	strdelete((void *)eingabe, x, y);
      }
    }
  }

  x = strpos2(eingabe, ":", 1);
  if (x > 0) {
    if (x == 1 || x > 1 && eingabe[x - 2] == ' ' || eingabe[x - 2] == '<') {
      if (strlen(opt2) < 12)
	strcat(opt2, ":");
      strdelete((void *)eingabe, x, 1);
    }
  }

  get_word(eingabe, ein);
  upper(ein);
  if (*ein != '\0') {   /*Loginsearch*/
    alphab = false;
    numbers = false;
    slashct = 0;

    FORLIM = strlen(ein);
    for (x = 0; x < FORLIM; x++) {
      if (isdigit(ein[x]))
	numbers = true;
      if (ein[x] == '_' || (ein[x] & 255) == 158 || (ein[x] & 255) == 154 ||
	  (ein[x] & 255) == 153 || (ein[x] & 255) == 142 || isupper(ein[x]))
	alphab = true;
      if (ein[x] == '-')
	slashct++;
    }

    if (alphab || numbers && alphab || slashct > 1) {
      cut(ein, 8);
      if (valid_boardname(ein))
	strcpy(user[unr]->brett, ein);
      else
	*user[unr]->brett = '\0';
      get_word(eingabe, ein);
      upper(ein);
    } else if (user[unr]->fbbmode && numbers && !alphab && slashct == 0) {
      li = str2lint(ein);
      if (li > msgnumoffset) {
	    /* sri, this is needed to distinguish msg numbers from board numbers */
	      li -= msgnumoffset;
	*start = msgnum2board(li, user[unr]->brett);
	if (*start < 1) {
	  *start = 1;
	  *user[unr]->brett = '\0';
	}
	*ende = *start;
	fbb = true;
	*ein = '\0';
      }
    }


    if (!fbb) {
      if (*ein != '\0') {
	if (strpos2(ein, "-", 1) > 1) {
	  sprintf(hs, "%.*s", strpos2(ein, "-", 1) - 1, ein);
	  *start = Str2int(hs);
	  if (*start < 1)
	    *start = 1;
	  if (strlen(ein) > strpos2(ein, "-", 1)) {
	    strsub(hs, ein, strpos2(ein, "-", 1) + 1,
		   strlen(ein) - strpos2(ein, "-", 1));
	    *ende = Str2int(hs);
	  } else
	    *ende = SHORT_MAX;
	} else if (ein[0] == '-') {
	  strdelete((void *)ein, 1, 1);
	  *ende = Str2int(ein);
	  if (*ende < 1)
	    *ende = 1;
	  *start = 1;
	} else {
	  *start = Str2int(ein);
	  if (*start < 1)
	    *start = 1;
	  *ende = *start;
	}


      } else
	strcat(opt2, "!");

    }

  } else
    strcat(opt2, "!");

  if (*ende < 1)
    *ende = SHORT_MAX;
  if (*start < 1)
    *start = 1;
  if (*start > *ende)
    *start = *ende;

  if (*search != '\0') {  /* L ATARI < DP immer von 1- durchsuchen! */
    if (strpos2(search, "*", 1) > 0) {
      if (search[0] != '*')
	sprintf(search, "*%s", strcpy(STR1, search));
      if (search[strlen(search) - 1] != '*')
	strcat(search, "*");
    }
    x = strpos2(opt2, "!", 1);
    if (x > 0) {
      strdelete((void *)opt2, x, 1);
      *start = 1;
      *ende = SHORT_MAX;
    }
  }
  cut(opt2, 12);
  strcpy(option, opt2);

  /* msgnum -> board */

}


Static short find_command_x(short unr, Char *kommando_, boolean *onlysys,
			    Char *cname)
{
  short Result;
  Char kommando[256];
  bcommandtype *hp;
  boolean found;
  short cnr;

  strcpy(kommando, kommando_);
  debug(4, unr, 115, kommando);
  Result = 0;
  *cname = '\0';
  *onlysys = false;

  if (*kommando == '\0')
    return Result;
  cnr = 0;
  found = false;

  if (kommando[0] == 'S') {
    if (!strcmp(kommando, "SP"))
      strcpy(kommando, "SEND");
    else if (!strcmp(kommando, "SB"))
      strcpy(kommando, "SEND");
    else if (!strcmp(kommando, "SR"))
      strcpy(kommando, "REPLY");
  }

  hp = bcommandroot;
  while (!found && hp != NULL) {
    if (strpos2(hp->command, kommando, 1) == 1) {
      cnr = hp->cnr;
      if (hp->sysop && !user[unr]->supervisor)
	cnr = 0;
      else if (user[unr]->level < hp->ulev)
	cnr = 0;
      if (cnr == 99 || cnr == 98) {
	if (strcmp(kommando, hp->command))
	  cnr = 0;
      }
      found = (cnr != 0);
      if (found) {
	*onlysys = hp->sysop;
	strcpy(cname, hp->command);
      }
    }
    hp = hp->next;
  }

  if (found)
    return cnr;

  *cname = '\0';
  if (user[unr]->sf_level >= 0 && strlen(kommando) > 4 &&
      kommando[0] == '[' && kommando[strlen(kommando) - 1] == ']') {
    if (kommando[strlen(kommando) - 2] == '$')
      cnr = 45;
    return cnr;
  }
  if (strpos2(kommando, "#OK#", 1) == 1) {
    cnr = 77;
    return cnr;
  }
  if (strpos2(kommando, "#NO#", 1) == 1)
    cnr = 77;
  else if (strpos2(kommando, "<GP", 1) == 1)
    cnr = 112;
  return cnr;

}


short find_command(short unr, Char *kommando, boolean *onlysys)
{
  Char hs[256];

  return (find_command_x(unr, kommando, onlysys, hs));
}


void expand_command(short unr, Char *kommando)
{
  Char hs[256];
  boolean onlysys;

  find_command_x(unr, kommando, &onlysys, hs);
  strcpy(kommando, hs);
}


short str2disturb_chan(Char *w)
{
  short Result, xchan;

  Result = 0;

  if (callsign(w))
    xchan = actual_user(w);
  else
    xchan = Str2int(w);

  if (boxrange(xchan)) {
    if (user[xchan]->action == 0 && !user[xchan]->f_bbs &&
	user[xchan]->lastprocnumber == 0 &&
	boxspoolstatus(user[xchan]->tcon, user[xchan]->pchan, -1) == 0)
      return xchan;
  }
  return Result;
}


short str2disturb_chan2(Char *w)
{
  short Result, xchan;

  Result = 0;

  if (callsign(w))
    xchan = actual_user(w);
  else
    xchan = Str2int(w);

  if (boxrange(xchan)) {
    if (!user[xchan]->f_bbs)
      return xchan;
  }
  return Result;
}


/*
=====================Header DB0PIC (Baycom)==========================

DG9FDA > ATARI    18.03.93 16:55 29 Zeilen 1502 Bytes #90 @ALLE
BID : 0833DB0SIFH7
{Read: Callsigns...}
Subj: DP = DAS PR-Programm fr ST
Path: !DB0PIC!DB0RBS!DB0LX!DB0AAA!DB0MWE!DB0KCP!OE9XPI!DB0CZ!DB0FRB!DB0GE!
      !DB0LJ!DB0SGL!DB0EAM!DB0SIF!
From: DG9FDA @ DB0SIF.DEU.EU
To  : ATARI @ ALLE

DK5SG:

Msg# 302784   To: HP @ALLE   From: DG1IY   Date: 14Sep92/1518
Subject: PACKET MIT HP48SX ???
Bulletin ID: 139258DB0GV
Path: DB0CZ!OE9XPI!HB9EAS!DB0GE!DB0IZ!DK0MWX!DB0EAM!DB0SIF!DB0GV
de DG1IY @ DB0GV

F6FBB:

Van : GB7BBS voor TPK   @EU
Type/Status : B$
Datum/tijd  : 21-Mrt 13:54
Bericht #   : 72617
Titel       : PERTON:G1DKI} Connected to BNOR71-1

Path: !PI8ZAA!PI8HWB!PI8GWO!PI8VNW!PI8MID!ON1CED!GB7TLH!GB7RUT!GB7BAD!GB7NOT!
      !GB7WRG!GB7YAX!GB7CHS!GB7SAM!GB7MAX!
HOW TO CONNECT USING A NODE


Von        : DK0NET
Nach       : DL8HBS@DB0HB.DEU.EU
Typ/Status : PF
Datum      : 17-Jun 08:23
BID/MID    : 166311DK0NET
Meldung #  : 85079
Titel      : Rubriken?! <dl5hbf

Path: !DK0NET!
 de DK0NET   @ DK0NET.DB0HBS.DEU.EU

 to DL8HBS   @ DL8HBS.DB0GR

 Moin Joachim,

Von        : DG8NBR
Nach       : YAESU @EU
Typ/Status : B$
Datum      : 18-Jun 06:44
BID/MID    : 17630BDB0BOX
Meldung #  : 85385
Titel      : info > FT 530

Path: !DB0HB!DB0HBS!DB0EAM!DB0SIF!DB0HOM!DB0GE!HB9EAS!HB9OS!DB0KCP!DB0AAB!
      !DB0FSG!DB0LNA!DB0RGB!DB0BOX!
de DG8NBR @ DB0BOX

hallo ft 530 user,                      tnx frs lesen.ich beabsichtige den kauf

Von        : DG8NBR
Nach       : YAESU @EU
Typ/Status : B$
Datum      : 18-Jun 06:44
BID/MID    : 17630BDB0BOX
Meldung #  : 85385
Titel      : info > FT 530

R:930618/0427z @DB0HB  [NORD><LINK HAMBURG, JO43XP, OP:DF4HR/DL6HAZ]
R:930618/0535l @DB0HBS.#HH.DEU.EU [۲BBS-Hamburg,JO43TN,DB-ST,OP:DL8XAW]
R:930617/2247z @DB0EAM.DEU.EU [Kassel JO41PI TheBox 19 OP:DB8AS]
R:930617/2244z @:DB0SIF.DEU.EU
R:930617/2244z @:DB0HOM.#SAR.DEU.EU
R:930617/2243z @DB0GE.#SL.DEU.EU [BBS Saarbruecken, DieBox 1.9]
R:930617/2017z @HB9EAS.CHE.EU [The Basel Area BBS]
R:930617/2015z @HB9OS  [Digital Radio Club Ost-Schweiz (HB9OS)  op:HB9CXN]
R:930617/2012z @:DB0KCP.#BAY.DEU.EU
R:930617/2012z @:DB0AAB.#BAY.DEU.EU
R:930617/2011z @:DB0FSG.#BAY.DEU.EU
R:930617/2011z @:DB0LNA.#BAY.DEU.EU
R:930617/2041z @:DB0RGB.#BAY.DEU.EU
R:930617/1841z @DB0BOX [DIE BOX in NUERNBERG JN59NJ, OP: DC3YC]
de DG8NBR @ DB0BOX

hallo ft 530 user,                      tnx frs lesen.ich beabsichtige den kauf

*/

cutboxtyp boxheader(Char *zeile)
{
  short zoffs, x, zl;
  cutboxtyp typ;
  short dpp;
  Char hs[256], w[256];
  short TEMP;

  typ = NOP;
  zl = strlen(zeile);
  if (zl <= 18 || zl >= 255)
    return typ;


  dpp = strpos2(zeile, ":", 1);
  if (dpp <= 4)
    return typ;

  if (zeile[0] == ':' || zeile[0] == '.' || zeile[0] == '|' ||
      zeile[0] == '<' || zeile[0] == '>')
	/* Kommentarzeichen */
	  return typ;

  /*                           Das $#NONE# war ein Fehler in open_sendfile() ...
TEST @DL8HBS.DB0GR.DEU.EU de:DL8HBS 04.05.93 23:20   0 100008 Bytes$#NONE#
SP @DB0GR        de:DL7WA  15.09.91 13:37  70    814 Bytes
*/
  if (zl >= 58) {  /* DieBox */
    zoffs = zl - 58;
    if (zeile[zoffs + 19] == ':') {
      if (strpos2(zeile, "de:", 1) == zoffs + 18) {
	if (strpos2(zeile, "Bytes", 1) == zoffs + 54)
	  typ = THEBOX_USER;
      }
    }
  }

  /*
DD6OQ  > MEINUN   04.05.93 13:38 39 Zeilen 1805 Bytes #30 (DB0GV)@DL
BID : 045307DB0GR
Subj: Gebuehrenerhoehung ok?
Path: !DL0AGU!DB0BRB!DB0GR!
Sent: 930504/1151z @DB0GR.DEU.EU [BERLIN-BBS, TheBox 1.9a, OP: DL7QG]
de DD6OQ @ DB0GR.DEU.EU
to MEINUNG @ DL

DG9NFF > DG9NFF   06.06.94 03:10 11 Lines 631 Bytes #120
DG9NFF > DG9NFF   06.06.94 03:10 11 Lines 80 Bytes #120


*/
  /*
TEST @DL8HBS.DB0GR.DEU.EU de:DL8HBS 04.05.93 23:20   0 100008 Bytes$#NONE#
*/
  if (typ == NOP) {
    if (zl >= 50) {  /* Baycom */
      zoffs = dpp;
      if (zoffs >= 19) {
	if (strpos2(zeile, "Bytes", 1) >= zoffs + 15) {
	  x = strpos2(zeile, ".", 1);
	  if (x > 9 && x < zoffs - 7) {
	    if (strpos2(zeile, "de:", 1) == zoffs - 2)
	      typ = THEBOX_USER;
	    else
	      typ = BAYCOM_USER;
	  }
	}
      }
    }
  }

  /*
Msg# 19522   To: ALL @WW   From: N0NJY   Date: 04May93/1559
Subject: DONT READ MSG FRM YV5KWS!!!
Bulletin ID: 28099_KA0WIN
Path: DB0BBX!DB0ERF!DB0EAM!DB0GV!DK0MTV!DB0GE!DB0IZ!PI8HRL!ON1KGX!ON1KPU!ON4TOR!
7KLY!GB7YAX!GB7WRG!GB7NOT!GB7
BAD!GB7RUT!GB7PET!GB7MHD!GB7KHW!GB7ZPU!GB7SPV!GB7DAA!GB7HSN!WA2NDV!N2BQF!KA0WIN!
KA0WIN

From: N0NJY@KA0WIN.#SECO.CO.USA.NA
To  : ALL@WW
*/
  if (typ == NOP) {  /* WAMPES */
    if (zl >= 57) {
      zoffs = strpos2(zeile, "Msg#", 1);
      if (zoffs > 0) {
	if (strpos2(zeile, "To:", 1) >= zoffs + 13) {
	  if (strpos2(zeile, "From:", 1) > zoffs + 26) {
	    if (strpos2(zeile, "Date:", 1) > zoffs + 40)
	      typ = WAMPES_USER;
	  }
	}
      }
    }
  }

  /*
Date: 28 Oct 91 13:32
Message-ID: <0@EA2RCG>
From: EB2DJM@EA2RCG
To: ALL@EU
Subject: I need the schemas of FT-73R(yaesu)
*/
  /*
                  if typ = NOP then if dpp > 4 then begin { W0RLI }
                      if pos('Date:',zeile) = dpp-4 then begin
                          if zeile[14+dpp] = ':' then begin
                              if count_words(zeile) = 5 then typ := W0RLI_USER;
                          end;
                      end;
                  end;
  */
  /*
From    : PI8TMA @ PI8TMA.#GLD.NLD.EU
To      : SCIENC @ NLDNET
Date    : 911127/1645
Msgid   : B+ 2252@PI8TMA, 31885@PI8DAZ $SCIENC.220
Subject : Bewoners Biosphere bestrijden kooldioxyde.
Path    : PI8UTR!PI8TMA
*/
  /*
                  if typ = NOP then if dpp > 8 then begin { AA4RE }
                      if zl > 15 then begin
                          if zeile[dpp-5] = 'm' then begin
                              if pos('From    : ',zeile) = dpp-8 then begin
                                  if count_words(zeile) = 5 then begin
                                      if pos('@',zeile) > dpp+2 then typ := AA4RE_USER;
                                  end;
                              end;
                          end;
                      end;
                  end;
  */
  /*

Van : DC6OQ  voor IBM   @DL
Type/Status : B$
Datum/tijd  : 21-Mrt 13:55
Bericht #   : 72618
Titel       : hilfe aastor
*/
  if (typ == NOP) {  /* F6FBB */
    if (*fbb_fromfield != '\0') {
      if (fbb_fromfield[0] == zeile[0]) {
	if (fbb_fromfield[1] == zeile[1]) {
	  if (strpos2(zeile, fbb_fromfield, 1) == 1) {
	    x = strpos2(zeile, fbb_tofield, 1);
	    if (x > strlen(fbb_fromfield) + 4) {
	      strcpy(hs, zeile);
	      strdelete((void *)hs, x, strlen(fbb_tofield));
	      strdelete((void *)hs, 1, strlen(fbb_fromfield));
	      del_leadblanks(hs);
	      TEMP = count_words(hs);
	      if ((unsigned)TEMP < 32 && ((1L << TEMP) & 0xc) != 0) {
		get_word(hs, w);
		if (callsign(w))
		  typ = F6FBB_USER;
	      }
	    }
	  }
	}
      }
    }
  }

  /*
Von        : DG8NBR
Nach       : YAESU @EU
Typ/Status : B$
Datum      : 18-Jun 06:44
BID/MID    : 17630BDB0BOX
Meldung #  : 85385
Titel      : info > FT 530
*/
  if (typ != NOP)  /* F6FBB314 */
    return typ;

  if (*fbb314_fromfield == '\0')
    return typ;
  if (fbb314_fromfield[0] != zeile[0])
    return typ;
  if (fbb314_fromfield[1] != zeile[1])
    return typ;
  if (strpos2(zeile, fbb314_fromfield, 1) != 1)
    return typ;
  strcpy(hs, zeile);
  strdelete((void *)hs, 1, strlen(fbb314_fromfield));
  del_leadblanks(hs);
  if (count_words(hs) != 1)
    return typ;
  get_word(hs, w);
  if (callsign(w))
    typ = F6FBB_USER_314;
  return typ;
}


/* ******** der Boxconvers ************** */

Static boolean valid_convchan(short unr, long newchan)
{
  return (newchan >= 0 &&
	  (newchan < 100000L || user[unr]->rsysop && newchan < 200000L ||
	   user[unr]->supervisor));

}


Static void send_convers(short unr, Char *zeile)
{
  short x;
  long uch;
  Char hs[256], hs2[256];
  Char acall[256];
  Char STR7[256];
  userstruct *WITH;

  strcpy(acall, user[unr]->call);
  uch = user[unr]->convchan;
  lower(acall);
  hs2[0] = '\0';
  sprintf(acall, "<%s>:", strcpy(STR7, acall));
  spacing(10, acall);
  sprintf(hs, "%s%s", acall, zeile);
  if (strlen(hs) > 79) {
    x = 79;
    while (hs[x - 1] != ' ' && x > 1)
      x--;
    if (x == 1)
      x = 79;
    strcpy(hs2, hs);
    cut(hs, x);
    strdelete((void *)hs2, 1, x);
    sprintf(hs2, "%s%s", acall, strcpy(STR7, hs2));
    cut(hs2, 120);
  }
  del_lastblanks(hs);
  del_lastblanks(hs2);
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      WITH = user[x];
      if (x != unr) {
	if (WITH->convchan >= 0 && WITH->convchan == uch && WITH->action == 90) {
	  wlnuser(x, hs);
	  if (*hs2 != '\0')
	    wlnuser(x, hs2);
	}
      }
    }
  }
}


Static void conv_help(short unr)
{
  short x;

  for (x = 126; x <= 132; x++)
    wln_btext(unr, x);
  wlnuser(unr, "***");
}


Static void conv_who(short unr, long cn)
{
  short x;
  Char hs[256];
  Char acall[256];
  userstruct *WITH;
  Char STR1[256];

  if (cn >= 0)
    wln_btext(unr, 133);
  else
    wln_btext(unr, 134);
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      WITH = user[x];
      if (valid_convchan(unr, WITH->convchan)) {
	if (cn < 0 || cn == WITH->convchan) {
	  strcpy(acall, WITH->call);
	  lower(acall);
	  spacing(9, acall);
	  if (cn < 0) {
	    sprintf(hs, "%ld", WITH->convchan);
	    lspacing(hs, 7);
	  } else
	    *hs = '\0';
	  sprintf(hs, "%s%s", acall, strcpy(STR1, hs));
	  wlnuser(unr, hs);
	}
      }
    }
  }
  wlnuser(unr, "***");
}


Static void conv_quit(short unr)
{
  send_convers(unr, "*** logging off");
  user[unr]->convchan = -1;
  wln_btext(unr, 135);
  user[unr]->action = 0;
}


Static void conv_channel(short unr, long newchan)
{
  Char hs[256];
  Char STR1[256];

  if (!valid_convchan(unr, newchan)) {
    wln_btext(unr, 137);
    return;
  }
  sprintf(hs, "%ld", newchan);
  if (newchan >= 100000L)
    strcpy(hs, "*** logging off");
  else
    sprintf(hs, "*** switching to chan %s", strcpy(STR1, hs));
  send_convers(unr, hs);
  user[unr]->convchan = newchan;
  send_convers(unr, "*** logging on");
  sprintf(hs, "%ld", newchan);
  w_btext(unr, 136);
  chwuser(unr, 32);
  wlnuser(unr, hs);
  conv_who(unr, newchan);
}


Static boolean check_for_conv_command(short unr, Char *zeile)
{
  boolean Result;
  Char w[256];
  Char hs[256];

  strcpy(hs, zeile);
  upper(hs);
  get_word(hs, w);
  if (strlen(w) < 1)
    return false;
  Result = true;
  if (compare(w, "/HELP")) {
    conv_help(unr);
    return Result;
  }
  if (compare(w, "/WHO")) {
    conv_who(unr, -1);
    return Result;
  }
  if (compare(w, "/QUIT")) {
    conv_quit(unr);
    return Result;
  }
  if (compare(w, "/EXIT")) {
    conv_quit(unr);
    return Result;
  }
  if (!compare(w, "/CHANNEL"))
    return false;
  conv_channel(unr, str2lint(hs));
  return Result;
}


void send_conv(short unr, Char *s)
{
  if (!boxrange(unr))
    return;
  if (!check_for_conv_command(unr, s))
    send_convers(unr, s);
}


void box_convers(short unr, Char *cmd)
{
  long i;
  Char hs[256];

  if (!boxrange(unr))
    return;
  i = str2lint(cmd);
  if (!valid_convchan(unr, i)) {
    wln_btext(unr, 137);
    return;
  }
  user[unr]->convchan = i;
  user[unr]->action = 90;
  w_btext(unr, 138);
  chwuser(unr, 32);
  sprintf(hs, "%ld", i);
  wlnuser(unr, hs);
  conv_who(unr, i);
  send_conv(unr, "*** logging on");
}


void _box_sub_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  updbidseekcounter = 0;
  lastbidtick = 0;
  setup_dwrstring();

}



/* End. */
