/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_sys.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_SYS_G
#include "box_sys.h"


#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif

#ifndef STATUS_H
#include "status.h"
#endif

#ifndef SHELL_H
#include "shell.h"
#endif


boolean is_german(Char *w)
{
  return (w[0] == 'D' && w[1] != 'U' || w[0] == 'O' && w[1] == 'E' ||
	  w[0] == 'H' && w[1] == 'B');
}


void sig_german_authinfo(Char *call, Char *mbx, Char *ret)
{
  if (is_german(call) && is_german(Console_call) && strcmp(mbx, "EU") &&
      strcmp(mbx, "WW") && strcmp(mbx, "AMSAT"))
    strcpy(ret, "X-Info: Einspielung ohne Passwortschutz");
  else
    strcpy(ret, "X-Info: Upload without password authentication");
}


void check_sysanswer(short unr, Char *eingabe_)
{
  Char eingabe[256];
  short l;
  userstruct *WITH;

  strcpy(eingabe, eingabe_);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  l = strlen(WITH->input2);
  if (l == 32)
    lower(eingabe);
  if (l == 4 && !strcmp(WITH->input2, eingabe) ||
      l == 5 && strpos2(eingabe, WITH->input2, 1) > 0 ||
      l == 32 && !strcmp(WITH->input2, eingabe))
  {   /* PRIV */
    WITH->level = WITH->plevel;
    WITH->is_authentic = (l == 4 || WITH->pwsetat + holddelay < clock_.ixtime);
    switch (WITH->pwmode) {

    case PWM_MUST_PRIV:
    case PWM_SEND_ERASE:
      WITH->se_ok = true;
      break;

    case PWM_RSYSOPPRIV:
    case PWM_RSYSOP:
      WITH->se_ok = true;
      WITH->rsysop = true;
      strcpy(WITH->lastcmd, "accepted as board-sysop");
      append_syslog(unr);
      *WITH->lastcmd = '\0';
      break;

    case PWM_SYSOPPRIV:
    case PWM_SYSOP:
      WITH->se_ok = true;
      WITH->supervisor = true;
      strcpy(WITH->lastcmd, "accepted as sysop");
      append_syslog(unr);
      *WITH->lastcmd = '\0';
      break;
    }
  } else if (l == 4)   /* SYS */
    append_syslog(unr);
  /* MD2 */

  WITH->action = 0;
  *WITH->input2 = '\0';
}


void answer_sysrequest(short unr, boolean MD2)
{
  short x, y, nr;
  short xnr[5];
  boolean ok, okpw;
  Char nstr[256];
  Char pw[256];
  Char hs[256];
  userstruct *WITH;
  Char STR1[256], STR7[256];

  for (x = 0; x <= 4; x++)
    xnr[x] = 0;
  okpw = false;

  if (!boxrange(unr))
    return;

  WITH = user[unr];
  if (strlen(WITH->password) > 20) {
    okpw = true;
    switch (WITH->pwmode) {

    case PWM_MUST_PRIV:
    case PWM_SEND_ERASE:
      strcpy(hs, "send/erase-login");
      break;

    case PWM_RSYSOPPRIV:
    case PWM_RSYSOP:
      strcpy(hs, "board-sysop-login");
      break;

    case PWM_SYSOPPRIV:
    case PWM_SYSOP:
      strcpy(hs, "sysop-login");
      break;

    default:
      okpw = false;
      break;
    }
  }

  if (!okpw)
    return;
  sprintf(WITH->lastcmd, "tries %s", hs);
  if (WITH->pwmode >= 32 ||
      ((1L << WITH->pwmode) & ((1L << PWM_MUST_PRIV) | (1L << PWM_SEND_ERASE))) == 0)
    append_syslog(unr);
  *WITH->lastcmd = '\0';

  if (MD2) {
    calc_MD2_prompt(nstr);
    calc_MD2_pw(nstr, WITH->password, pw);
    sprintf(nstr, "%s> [%s]", Console_call, strcpy(STR1, nstr));
	/*'dpbox',dp_vnr,':',*/
  } else {
    do {
      nr = dp_randomize(1, strlen(WITH->password));
    } while (WITH->password[nr - 1] == ' ');
    xnr[0] = nr;
    sprintf(pw, "%c", WITH->password[nr - 1]);
    sprintf(hs, "%s>", Console_call);   /*'dpbox',dp_vnr,':',*/
    sprintf(nstr, "%ld", nr);
    sprintf(nstr, "%s %s", hs, strcpy(STR7, nstr));

    for (x = 1; x <= 4; x++) {
      do {
	nr = dp_randomize(1, strlen(WITH->password));
	ok = true;
	for (y = 0; y < x - 1; y++) {
	  if (xnr[y] == nr)
	    ok = false;
	}
      } while (!(ok && WITH->password[nr - 1] != ' '));
      xnr[x] = nr;
      sprintf(pw + strlen(pw), "%c", WITH->password[nr - 1]);
      sprintf(hs, "%ld", nr);
      sprintf(nstr + strlen(nstr), " %s", hs);
    }
  }


  WITH->action = 77;
  strcpy(WITH->input2, pw);
  wlnuser(unr, nstr);

}


Static void calc_timestring(long seconds, Char *hs)
{
  Char w[256], w1[256];

  *hs = '\0';
  sprintf(hs, "%ld", seconds / 3600);
  sprintf(w, "%ld", seconds % 3600 / 60);
  sprintf(w1, "%ld", seconds % 60);
  sprintf(hs + strlen(hs), " h %s min %s", w, w1);
}


void show_stat(short unr, short x)
{
  long seconds0, seconds1, seconds2;
  Char hs[256], w[256], hs2[256];
  userstruct *WITH;
  Char STR1[256], STR7[256];

  if (!(boxrange(unr) && boxrange(x)))
    return;

  WITH = user[x];
  seconds0 = clock_.ixtime - WITH->logindate;
  calc_timestring(seconds0, hs);
  sprintf(hs, "Logintime   : %s sec", strcpy(STR7, hs));
  wlnuser(unr, hs);

  seconds1 = WITH->processtime / 200;
  seconds2 = (WITH->processtime % 200) >> 1;
  sprintf(hs2, "%ld", seconds2);
  while (strlen(hs2) < 2)
    sprintf(hs2, "0%s", strcpy(STR7, hs2));
  calc_timestring(seconds1, hs);
  sprintf(hs, "CPU-Time    : %s.%s sec", strcpy(STR1, hs), hs2);
  wlnuser(unr, hs);
  sprintf(hs, "%ld", WITH->rbytes);
  sprintf(w, "%ld", WITH->sbytes);
  sprintf(hs, "Bytecount   : RX %s / TX %s", strcpy(STR1, hs), w);
  wlnuser(unr, hs);
  if (seconds0 < 1)
    seconds0 = 1;
  if (seconds1 < 1)
    seconds1 = 1;
  sprintf(hs, "%ld", (WITH->rbytes + WITH->sbytes) * 8 / seconds0);
  sprintf(w, "%ld", (WITH->rbytes + WITH->sbytes) * 8 / seconds1);
  sprintf(hs, "Speed       : %s baud (HF) / %s baud (CPU)",
	  strcpy(STR7, hs), w);
  wlnuser(unr, hs);
}


Static void p_ix(short unr, long time, Char *ts)
{
  Char hs[256];
  Char STR1[256];

  if (time != 0) {
    ix2string(time, hs);
    cut(hs, 14);   /* keine Sekunden */
    sprintf(hs, "%s%s", ts, strcpy(STR1, hs));
  } else
    sprintf(hs, "%s-", ts);
  wlnuser(unr, hs);
}


void show_user(short unr, Char *calls, Char *option)
{
  short x, last;
  userstruct uf;
  long sb, rb;
  boolean owner;
  Char lan[256];
  Char hs[256];
  Char STR1[256];
  Char STR7[22];
  Char STR13[96];
  Char STR14[18];
  Char STR16[80];
  Char STR17[64];
  Char STR19[256];
  userstruct *WITH;

  debug(2, unr, 93, calls);
  if (strpos2(option, "@", 1) > 0) {
	/* alle Calls mit MyBBS @CALLS ausgeben */
	  *hs = '\0';
    if (callsign(calls))
      show_all_user_at(unr, calls, strpos2(option, "-", 1) > 0, false,
		       strpos2(option, "/", 1) > 0, hs);
    else
      wln_btext(unr, 2);
    return;
  }
  if (strpos2(option, "!", 1) > 0) {  /* alle BBS ausgeben mit Anzahl Calls */
    strcpy(hs, calls);
    show_all_user_at(unr, calls, false, false, true, hs);
    return;
  }
  if (strpos2(option, "+", 1) > 0) {
    *hs = '\0';
    if (strpos2(option, "-", 1) > 0) {
      show_all_user_at(unr, calls, true, true, false, hs);
      return;
    }
    load_userfile(false, true, calls, &uf);
    if (*uf.call == '\0' && actual_user(calls) == 0) {
      sprintf(STR1, "%s ", calls);
      wuser(unr, STR1);
      wln_btext(unr, 24);
      return;
    }
    if (*uf.call == '\0') {
      strcpy(uf.call, calls);
      upper(uf.call);
      *uf.name = '\0';
      user_language(&whichlangmem, &whichlangsize, whotalks_lan, uf.call, lan);
      cut(lan, 3);
      strcpy(uf.language, lan);
      *uf.mybbs = '\0';
    }

    owner = (strcmp(user[unr]->call, uf.call) == 0);

    sprintf(STR7, "Call        : %s", uf.call);
    wlnuser(unr, STR7);
    if (*uf.name != '\0') {
      sprintf(STR13, "Name        : %s", uf.name);
      wlnuser(unr, STR13);
    }
    sprintf(STR14, "Language    : %s", uf.language);
    wlnuser(unr, STR14);
    if (*uf.mybbs != '\0') {
      unhpath(uf.mybbs, hs);
      if (ring_bbs && !strcmp(hs, Console_call) && !uf.lock_here) {
        sprintf(STR17, "MyBBS       : %s (swap)", uf.mybbs);
        wlnuser(unr, STR17);
      } else {
        sprintf(STR16, "MyBBS       : %s", uf.mybbs);
        if (uf.mybbsmode == 'G')
          strcat(STR16, " (guessed)");
        wlnuser(unr, STR16);
      }
    }

    if (uf.lastdate > 0) p_ix(unr, uf.lastdate, "LastLogin   : ");
    if (uf.mybbsupd > 0) p_ix(unr, uf.mybbsupd, "LastMyBBS   : ");
    if (uf.lastatime > 0) p_ix(unr, uf.lastatime, "LastTouch   : ");

    x = actual_user(uf.call);
    if (uf.sslogins > 0 || x > 0) {
      if (x > 0) {
	show_stat(unr, x);
	sb = user[x]->sbytes;
	rb = user[x]->rbytes;
      } else {
	sb = 0;
	rb = 0;
      }

      if (user[unr]->supervisor) {
	if (x > 0)
	  sprintf(hs, "%ld", user[x]->read_today);
	else
	  sprintf(hs, "%ld", uf.read_today);
	if (strcmp(hs, "0") && uf.maxread_day > 0) {
	  wuser(unr, "Total/day   : ");
	  wuser(unr, hs);
	  wuser(unr, " of max. ");
	  if (uf.maxread_day > 0) {
	    sprintf(hs, "%ld", uf.maxread_day);
	    strcat(hs, " (personal)");
	  } else if (all_maxread_day < 999999999L) {
	    sprintf(hs, "%ld", all_maxread_day);
	    strcat(hs, " (general)");
	  } else
	    strcpy(hs, "infinite (general)");
	  wlnuser(unr, hs);
	}
      }

      wuser(unr, "Total/month : RX ");
      sprintf(hs, "%ld", uf.srbytes + rb);
      wuser(unr, hs);
      wuser(unr, " / TX ");
      sprintf(hs, "%ld", uf.ssbytes + sb);
      wlnuser(unr, hs);

      if (user[unr]->supervisor) {
	wuser(unr, "Total/ever  : RX ");
	sprintf(hs, "%ld", uf.ssrbytes + rb);
	wuser(unr, hs);
	wuser(unr, " / TX ");
	sprintf(hs, "%ld", uf.sssbytes + sb);
	wlnuser(unr, hs);
      }

      sprintf(hs, "%ld", uf.logins);
      sprintf(hs, "Logins/month: %s", strcpy(STR1, hs));
      wlnuser(unr, hs);

      if (user[unr]->supervisor) {
	sprintf(hs, "%ld", uf.sslogins);
	sprintf(hs, "Logins/ever : %s", strcpy(STR1, hs));
	wlnuser(unr, hs);
      }
    }

    if (uf.readlock != 0) {
      wuser(unr, "Readlock    : ");
      sprintf(hs, "%ld", uf.readlock);
      wlnuser(unr, hs);
    }

    if (uf.ttl != gttl && (user[unr]->supervisor || owner)) {
      wuser(unr, "TTL         : ");
      if (uf.ttl)
	strcpy(hs, "ON");
      else
	strcpy(hs, "OFF");
      wlnuser(unr, hs);
    }

    if (uf.sfmd2pw && (user[unr]->supervisor || owner)) {
      wuser(unr, "MD2SF       : ");
      if (uf.sfmd2pw)
	strcpy(hs, "ON");
      else
	strcpy(hs, "OFF");
      wlnuser(unr, hs);
    }

    if (uf.fbbmode && (user[unr]->supervisor || owner)) {
      wuser(unr, "FBBMODE     : ");
      if (uf.fbbmode)
	strcpy(hs, "ON");
      else
	strcpy(hs, "OFF");
      wlnuser(unr, hs);
    }

    if (uf.unproto_ok && (user[unr]->supervisor || owner)) {
      wuser(unr, "UNPROTO     : ");
      if (uf.unproto_ok)
	strcpy(hs, "ON");
      else
	strcpy(hs, "OFF");
      wlnuser(unr, hs);
    }

    if (uf.hidebeacon && (user[unr]->supervisor || owner))
      wlnuser(unr, "MailBeacon  : OFF");

    if (user[unr]->supervisor) {
      sprintf(hs, "%ld", uf.level);
      wuser(unr, "Level       : ");
      wlnuser(unr, hs);
      if (uf.sf_level == 0) {
 	if (in_sfp(uf.call))
	  uf.sf_level = 1;
      }
      
      if (uf.sf_level > 0) {
        sprintf(hs, "%ld", uf.sf_level);
        wuser(unr, "SF-Level    : ");
        wlnuser(unr, hs);
      }
      
      if (uf.pwmode > 0) {
        sprintf(hs, "%ld", uf.pwmode);
        wuser(unr, "PW-Mode     : ");
        wlnuser(unr, hs);
      }
    }

    if (!(user[unr]->supervisor || owner))
      return;
    if (*uf.nocheckboards != '\0') {
      strcpy(hs, uf.nocheckboards);
      strdelete((void *)hs, 1, 1);
      cut(hs, strlen(hs) - 1);
      sprintf(STR1, "NotBoard    : %s", hs);
      wlnuser(unr, STR1);
    } else if (*uf.wantcheckboards != '\0') {
      strcpy(hs, uf.wantcheckboards);
      strdelete((void *)hs, 1, 1);
      cut(hs, strlen(hs) - 1);
      sprintf(STR1, "WantBoard   : %s", hs);
      wlnuser(unr, STR1);
    }
    if (*uf.promptmacro != '\0') {
      sprintf(STR1, "Prompt      : %s", uf.promptmacro);
      wlnuser(unr, STR1);
    }
    if (*uf.logincommands != '\0') {
      sprintf(STR1, "LoginCmd    : %s", uf.logincommands);
      wlnuser(unr, STR1);
    }

    wuser(unr, "Password    : ");
    if (*uf.password == '\0') {
      strcpy(hs, calls);
      lower(hs);
      sprintf(STR1, "%s%s%cpwd", boxsfdir, hs, extsep);
      if (exist(STR1)) {
	if (user[unr]->supervisor)
	  wuser(unr, "1620 chars");
	else
	  chwuser(unr, '+');
      } else
	chwuser(unr, '-');
      wlnuser0(unr);
      return;
    }
    if (user[unr]->console)
      wlnuser(unr, uf.password);
    else {
      if (user[unr]->supervisor) {
	sprintf(hs, "%ld", strlen(uf.password));
	strcat(hs, " chars");
	wuser(unr, hs);
      } else
	chwuser(unr, '+');
      wlnuser0(unr);
    }
    if (user[unr]->supervisor)
      p_ix(unr, uf.pwsetat, "Activated   : ");
    if (uf.pwsetat + holddelay > clock_.ixtime) {
      if (user[unr]->supervisor || !strcmp(user[unr]->call, uf.call))
	p_ix(unr, uf.pwsetat + holddelay, "Active at   : ");
    }
    return;
  }

  last = maxuser;
  while (last > 0 && user[last] == NULL)
    last--;
  last = last / 7 + 1;
  last *= 7;
  for (x = 1; x <= last; x++) {
    sprintf(hs, "%ld", x);
    lspacing(hs, 3);
    strcat(hs, ":");
    wuser(unr, hs);
    if (user[x] == NULL)
      *hs = '\0';
    else {
      WITH = user[x];
      if (WITH->pchan > 0) {
	strcpy(hs, WITH->call);
	if (WITH->f_bbs)
	  lower(hs);
      } else {
	if (user[unr]->supervisor) {
	  if (WITH->console)
	    strcpy(hs, "local");
	  else
	    strcpy(hs, WITH->call);
	  hs[0] = lowcase(hs[0]);   /* Modem */
	} else
	  *hs = '\0';
      }
    }
    rspacing(hs, 7);
    wuser(unr, hs);
    if (x % 7 == 0)
      wlnuser0(unr);
  }
  wlnuser0(unr);

  if (compare(calls, "PATH")) {
    for (x = 1; x <= maxuser; x++) {
      if (boxrange(x)) {
	if (!user[x]->console || user[unr]->supervisor) {
	  sprintf(hs, "%ld", x);
	  lspacing(hs, 3);

	  strcat(hs, ":");
	  wuser(unr, hs);
	  fill_logline(false, x, hs);
	  wlnuser(unr, hs);
	}
      }
    }
    return;
  }


  if (!compare(calls, "ALL"))
    return;
  sprintf(hs, "%ld", clock_.mon);
  sprintf(hs, "%sboxlog%s%cbox -a -TN 1500",
	  boxprotodir, strcpy(STR19, hs), extsep);
  if (strpos2(hs, boxdir, 1) == 1)
    strdelete((void *)hs, 1, strlen(boxdir));
  read_file_immediate(false, unr, hs);
}


void set_password(short unr, boolean superv, Char *eingabe_)
{
  Char eingabe[256];
  short x;
  long t2;
  short l1;
  userstruct ufil;
  Char w[256];
  Char STR1[24];
  Char STR7[32];

  strcpy(eingabe, eingabe_);
  if (!boxrange(unr))
    return;

  if (superv)
    get_word(eingabe, w);
  else
    strcpy(w, user[unr]->call);
  upper(w);

  if (!callsign(w)) {
    wln_btext(unr, 3);
    return;
  }

  load_userinfo_for_change(false, w, &ufil);

  l1 = strlen(ufil.password);

  if (*eingabe == '\0') {
    ufil.pwmode = 0;
    ufil.pwsetat = 0;
    if (l1 > 0) {
      *ufil.password = '\0';
      wln_btext(unr, 139);
      if (l1 > 20) {
	sprintf(STR1, "%s password deleted", ufil.call);
	debug(0, unr, 157, STR1);
      }
    } else if (!superv)
      wln_btext(unr, 140);
    else
      wlnuser(unr, "? ");
  }

  l1 = strlen(ufil.password);

  if (l1 + strlen(eingabe) <= 80)
    strcat(ufil.password, eingabe);
  else
    wln_btext(unr, 141);

  /* Modemuser mit pwmode 0 duerfen ihn nicht hochsetzen */
  if (strlen(ufil.password) > 20 &&
      (ufil.pwmode != 0 || user[unr]->pchan > 0 ||
       user[unr]->console != false)) {
    if (ufil.pwmode < 2)
      ufil.pwmode = 2;
    sprintf(w, "%ld", strlen(ufil.password));
    w_btext(unr, 142);
    chwuser(unr, 32);
    wlnuser(unr, w);

    if (l1 <= 20) {
      sprintf(STR7, "%s now with active password", ufil.call);
      debug(0, unr, 157, STR7);
      if (superv)
	ufil.pwsetat = clock_.ixtime - holddelay;
      else {
	ufil.pwsetat = clock_.ixtime;
	if (holddelay > 0) {
	  t2 = ufil.pwsetat + holddelay;
	  ix2string(t2, w);
	  w_btext(unr, 143);
	  chwuser(unr, 32);
	  wlnuser(unr, w);
	}
      }
    }
  } else if (ufil.pwmode != 0 || user[unr]->pchan > 0 ||
	     user[unr]->console != false) {
    sprintf(w, "%ld", strlen(ufil.password));
    w_btext(unr, 144);
    chwuser(unr, 32);
    wlnuser(unr, w);
  }


  for (x = 1; x <= maxuser; x++) {
    if (boxrange(x)) {
      if (!strcmp(user[x]->call, ufil.call)) {
	strcpy(user[x]->password, ufil.password);
	user[x]->pwmode = ufil.pwmode;
	user[x]->pwsetat = ufil.pwsetat;
      }
    }
  }
  save_userfile(&ufil);
  wlnuser(unr, "OK");

}


boolean in_wpservers(Char *call)
{
  boolean Result;
  short inf;
  boolean ok;
  Char hs[256];
  Char wptname[256];

  Result = false;
  sprintf(wptname, "%swpfor%cbox", boxsysdir, extsep);
  if (!exist(wptname))
    return Result;
  inf = sfopen(wptname, FO_READ);
  ok = false;
  while (file_to_string(inf, hs) && !ok)
    ok = (strcmp(call, hs) == 0);
  sfclose(&inf);
  return ok;
}



void generate_wp_files(void)
{
  short inf, outf, nf;
  long time;
  boolean ok;
  Char wpmname[256];
  Char wpfname[256];
  Char wp2name[256];
  Char wptname[256];
  Char hs[256], w[256], lc[256], ll[256];
  Char r[256], ts[256];
  Char STR1[256];

  lastwpcreate = clock_.ixtime;
  sprintf(wpmname, "%swpmess%cdat", boxstatdir, extsep);
  sprintf(wp2name, "%swpmsg%cdat", boxstatdir, extsep);
  sprintf(wpfname, "%swpfor%cbox", boxsysdir, extsep);
  sprintf(wptname, "%swpfor%cdat", boxstatdir, extsep);
  sfdelfile(wp2name);
  if (create_wp) {
    if (exist(wpmname)) {
      sort_file(wpmname);
      inf = sfopen(wpmname, FO_READ);
      outf = sfcreate(wp2name, FC_FILE);
      *hs = '\0';
      *w = '\0';
      strcpy(ll, hs);
      while (file_to_string(inf, hs)) {
	strcpy(lc, w);
	get_word(hs, w);
	if (myeof(inf)) {
	  strcpy(ll, hs);
	  strcpy(lc, w);
	  *w = '\0';
	}
	if (strcmp(w, lc)) {
	  if (*ll != '\0') {
	    get_word(ll, ts);
	    time = str2lint(ts);
	    ixdatum2string(time, ts);
	    sprintf(r, "On %c%c%c%c%c%c %s/U @ ",
		    ts[6], ts[7], ts[3], ts[4], ts[0], ts[1], lc);
	    get_word(ll, ts);
	    sprintf(r + strlen(r), "%s zip ? ? ?", ts);
	    get_word(ll, ts);   /*from*/
	    if (*ts != '\0') {
	      sprintf(r, "%s %s", ts, strcpy(STR1, r));
	      string_to_file(&outf, r, true);
	    }
	  }
	}
	strcpy(ll, hs);
      }
      sfclose(&inf);
      sfclose(&outf);
    }

    if (exist(wp2name)) {
      if (exist(wpfname)) {
	nf = sfopen(wpfname, FO_READ);
	while (file_to_string(nf, hs)) {
	  ok = false;
	  get_word(hs, ts);   /*boxcall*/
	  if (*ts == '\0' || ts[0] == '#')
	    continue;
	  dp_watchdog(2, 4711);   /* Watchdog resetten         */
	  inf = sfopen(wp2name, FO_READ);
	  outf = sfcreate(wptname, FC_FILE);
	  while (file_to_string(inf, hs)) {
	    get_word(hs, w);
	    if (strcmp(w, ts)) {
	      string_to_file(&outf, hs, true);
	      ok = true;
	    }
	  }
	  sfclose(&outf);
	  sfclose(&inf);
	  if (ok) {
	    sprintf(STR1, "&%s", wptname);
	    send_sysmsg("WP", ts, "WP Update", STR1, 3);
	  }
	  sfdelfile(wptname);
	}
	sfclose(&nf);
      }
    }

  }
  sfdelfile(wpmname);
}


void add_wpline(Char *call, Char *bbs, long time, Char *from, boolean is_wp)
{
  boolean ok;
  Char hs[256], w[256], w1[256];
  Char STR7[256];

  if (!create_wp)
    return;
  if (!callsign(from))
    return;
  unhpath(bbs, w);
  if (!callsign(w))
    return;
  if (!is_wp)
    ok = (is_german(w) || strpos2(bbs, ".", 1) > 0);
  else
    ok = true;
  if (!ok)
    return;
  if (strpos2(bbs, ".", 1) == 0)
    complete_hierarchical_adress(bbs);
  if (strpos2(bbs, ".", 1) <= 0)
    return;
  sprintf(w1, "%ld", time);
  sprintf(hs, "%s %s %s %s", call, w1, bbs, from);
  sprintf(STR7, "%swpmess%cdat", boxstatdir, extsep);
  append(STR7, hs, true);
}


void set_maxread(short unr, Char *w, Char *eingabe)
{
  userstruct ufil;
  short x;
  Char w1[256];
  userstruct *WITH;
  Char STR7[256];

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (!callsign(w)) {
    wln_btext(unr, 3);
    return;
  }
  load_userinfo_for_change(false, w, &ufil);
  ufil.maxread_day = (str2lint(eingabe) + maxreaddivisor - 1) / maxreaddivisor *
		     maxreaddivisor;
  if (ufil.maxread_day > maxreaddivisor * 255)
    ufil.maxread_day = maxreaddivisor * 255;
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, ufil.call))
	user[x]->maxread_day = ufil.maxread_day;
    }
  }
  save_userfile(&ufil);
  if (ufil.maxread_day == 0)
    strcpy(w1, "infinite");
  else
    sprintf(w1, "%ld", ufil.maxread_day);
  sprintf(w1, "OK, max. read/day (%s) = %s bytes", w, strcpy(STR7, w1));
  wlnuser(unr, w1);
}


void change_prompt(short unr, Char *eingabe)
{
  userstruct ufil;
  short x;
  Char w[256], w1[256], c[256];

  strcpy(w1, eingabe);
  get_word(w1, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    upper(c);
    strcpy(w, w1);
  } else {
    strcpy(c, user[unr]->call);
    strcpy(w, eingabe);
  }

  load_userinfo_for_change(false, c, &ufil);

  strcpy(ufil.promptmacro, w);
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, ufil.call))
	strcpy(user[x]->promptmacro, ufil.promptmacro);
    }
  }
  save_userfile(&ufil);

  wlnuser(unr, "OK");
}


void change_startup(short unr, Char *eingabe)
{
  userstruct ufil;
  short x;
  Char w[256], w1[256], c[256];

  strcpy(w1, eingabe);
  get_word(w1, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    upper(c);
    strcpy(w, w1);
  } else {
    strcpy(c, user[unr]->call);
    strcpy(w, eingabe);
  }

  load_userinfo_for_change(false, c, &ufil);

  strcpy(ufil.logincommands, w);
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, ufil.call))
	strcpy(user[x]->logincommands, ufil.logincommands);
    }
  }
  save_userfile(&ufil);
  wlnuser(unr, "OK");
}


void change_ttl(short unr, Char *eingabe)
{
  short x;
  userstruct ufil;
  Char w[256], c[256];

  upper(eingabe);
  get_word(eingabe, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    get_word(eingabe, w);
  } else
    strcpy(c, user[unr]->call);

  load_userinfo_for_change(false, c, &ufil);

  if (*w != '\0') {
    ufil.ttl = positive_arg(w);
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL) {
	if (!strcmp(user[x]->call, ufil.call))
	  user[x]->ttl = ufil.ttl;
      }
    }

    save_userfile(&ufil);
  }

  if (ufil.ttl)
    wlnuser(unr, "TTL ON");
  else
    wlnuser(unr, "TTL OFF");
}


void change_unprotomode(short unr, Char *eingabe)
{
  short x;
  userstruct ufil;
  Char w[256], c[256];

  upper(eingabe);
  get_word(eingabe, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    get_word(eingabe, w);
  } else
    strcpy(c, user[unr]->call);

  load_userinfo_for_change(false, c, &ufil);

  if (*w != '\0') {
    ufil.unproto_ok = positive_arg(w);
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL) {
	if (!strcmp(user[x]->call, ufil.call))
	  user[x]->unproto_ok = ufil.unproto_ok;
      }
    }

    save_userfile(&ufil);
  }

  if (ufil.unproto_ok)
    wlnuser(unr, "UNPROTO ON");
  else
    wlnuser(unr, "UNPROTO OFF");
}


void change_md2sf(short unr, Char *eingabe)
{
  short x;
  userstruct ufil;
  Char w[256], c[256];

  upper(eingabe);
  get_word(eingabe, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    get_word(eingabe, w);
  } else
    strcpy(c, user[unr]->call);

  load_userinfo_for_change(false, c, &ufil);

  if (*w != '\0') {
    ufil.sfmd2pw = positive_arg(w);
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL) {
	if (!strcmp(user[x]->call, ufil.call))
	  user[x]->sfmd2pw = ufil.sfmd2pw;
      }
    }

    save_userfile(&ufil);
  }

  if (ufil.sfmd2pw)
    wlnuser(unr, "MD2SF ON");
  else
    wlnuser(unr, "MD2SF OFF");
}


void change_fbbmode(short unr, Char *eingabe)
{
  short x;
  userstruct ufil;
  Char w[256], c[256];

  upper(eingabe);
  get_word(eingabe, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    get_word(eingabe, w);
  } else
    strcpy(c, user[unr]->call);

  load_userinfo_for_change(false, c, &ufil);

  if (*w != '\0') {
    ufil.fbbmode = positive_arg(w);
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL) {
	if (!strcmp(user[x]->call, ufil.call))
	  user[x]->fbbmode = ufil.fbbmode;
      }
    }

    save_userfile(&ufil);
  }

  if (ufil.fbbmode)
    wlnuser(unr, "FBBMODE ON");
  else
    wlnuser(unr, "FBBMODE OFF");
}


void change_readlock(short unr, Char *eingabe)
{
  short x;
  userstruct ufil;
  Char w[256], c[256];
  Char STR1[256];

  upper(eingabe);
  get_word(eingabe, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    get_word(eingabe, w);
  } else
    strcpy(c, user[unr]->call);

  load_userinfo_for_change(false, c, &ufil);

  if (*w != '\0') {
    x = Str2int(w);
    if ((unsigned)x < 32 && ((1L << x) & 0x7) != 0) {
      ufil.readlock = x;
      for (x = 1; x <= maxuser; x++) {
	if (user[x] != NULL) {
	  if (!strcmp(user[x]->call, ufil.call))
	    user[x]->readlock = ufil.readlock;
	}
      }

      save_userfile(&ufil);
    }
  }
  sprintf(w, "%ld", ufil.readlock);
  sprintf(w, "ReadLock %s", strcpy(STR1, w));
  wlnuser(unr, w);
}


void change_mailbeacon(short unr, Char *eingabe)
{
  short x;
  userstruct ufil;
  Char w[256], c[256];

  upper(eingabe);
  get_word(eingabe, w);
  if (callsign(w) && user[unr]->supervisor) {
    strcpy(c, w);
    get_word(eingabe, w);
  } else
    strcpy(c, user[unr]->call);

  load_userinfo_for_change(false, c, &ufil);

  if (*w != '\0') {
    ufil.hidebeacon = !positive_arg(w);
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL) {
	if (!strcmp(user[x]->call, ufil.call))
	  user[x]->hidebeacon = ufil.hidebeacon;
      }
    }
    save_userfile(&ufil);
  }

  wuser(unr, "MailBeacon ");
  if (ufil.hidebeacon)
    wlnuser(unr, "OFF");
  else
    wlnuser(unr, "ON");
}


Static boolean chmbxsemaphore;


void change_mybbs(short unr, Char *callx_, Char *bbs_, long updatetime,
		  Char *level_, Char mybbsmode, boolean update, boolean fwd)
{
  Char callx[7];
  Char bbs[256];
  Char level[256];
  userstruct ufil;
  short x, mssid;
  boolean found, iscall;
  Char hs[256], bbs1[256], w[256];
  Char STR1[256], STR7[256];

  if (chmbxsemaphore)  /* sonst ruft sich das doppelt auf wegen */
    return;
  chmbxsemaphore = true;   /* update_mybbsfile                      */
  strcpy(callx, callx_);
  strcpy(bbs, bbs_);
  strcpy(level, level_);
  debug(2, unr, 94, callx);
  if (updatetime == 0)
    updatetime = clock_.ixtime;
  
  if (updatetime >= clock_.ixtime + 43200L)
    return;

  load_userinfo_for_change(update, callx, &ufil);

/*
  if (!(update && (*ufil.mybbs == '\0' || ufil.mybbsupd >= updatetime))) {
*/
    /* nachschauen ob
     * a) not update (dann wars der User in der Box selber)
     * b) found and mode != 'U' and mybbsmode == 'U'
     * c) found and mode != 'U' and mybbsmode != 'U' and updatetime > bbsrec.ix_time
     * d) found and mode == 'U' and mybbsmode == 'U' and updatetime > bbsrec.ix_time
     */
    
  found = ufil.lastatime > 0;
  
  if (!update ||
        ((found && ufil.mybbsmode != 'U' && mybbsmode == 'U')
        || (found && ufil.mybbsmode != 'U' && mybbsmode != 'U' && ufil.mybbsupd < updatetime)
        || (found && ufil.mybbsmode == 'U' && mybbsmode == 'U' && ufil.mybbsupd < updatetime)
     ))
    {

    cut(bbs, 40);

    x = strpos2(bbs, ".", 1);
    if (x > 0) {
      sprintf(hs, "%.*s", x - 1, bbs);
      strdelete((void *)bbs, 1, x);
    } else {
      strcpy(hs, bbs);
      *bbs = '\0';
    }

    if (boxrange(unr)) {
      x = strpos2(hs, "-", 1);
      if (x > 0) {
	strcpy(w, hs);
	strdelete((void *)w, 1, x);
	strdelete((void *)hs, x, strlen(hs) - x + 1);
	mssid = Str2int(w);

	if (!strcmp(hs, Console_call))
	  ufil.lock_here = (mssid == boxboxssid());
	else
	  ufil.lock_here = false;
      } else
	ufil.lock_here = (!strcmp(hs, Console_call) && multi_master);
    } else {
      x = strpos2(hs, "-", 1);
      if (x > 0)
        cut(hs, x - 1);
      if (strcmp(hs, Console_call))
	ufil.lock_here = false;
      else
        ufil.lock_here = !ring_bbs;
    }

    iscall = callsign(hs);

    if (*bbs != '\0')
      sprintf(bbs, "%s.%s", hs, strcpy(STR7, bbs));
    else
      strcpy(bbs, hs);

    strcpy(ufil.mybbs, bbs);
    ufil.mybbsupd = updatetime;
    ufil.mybbsmode = mybbsmode;
    if (zahl(level))
      ufil.level = Str2int(level);
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL) {
	if (!strcmp(user[x]->call, ufil.call)) {
	  strcpy(user[x]->mybbs, ufil.mybbs);
	  user[x]->mybbsupd = ufil.mybbsupd;
	  user[x]->mybbsmode = ufil.mybbsmode;
	  user[x]->level = ufil.level;
	  user[x]->lock_here = ufil.lock_here;
	}
      }
    }

    save_userfile(&ufil);

    if (boxrange(unr)) {
      update_mybbsfile(true, callx, &updatetime, bbs, &mybbsmode);

      if ((!user[unr]->console || strcmp(user[unr]->call, callx))
           && fwd && mybbsmode == 'U') {
	if (!update)
	  add_wpline(callx, bbs, updatetime, Console_call, false);
	unhpath(bbs, bbs1);
	sprintf(hs, "%ld", updatetime + THEBOX_ERRONEOUS_OFFSET);
	if (iscall) {
	  sprintf(STR1, "%s %s", bbs, hs);
	  set_sys_fwd('M', Console_call, callx, "", STR1, e_m_verteiler);
	}
      }

      if (!iscall) wlnuser(unr, "warning: bbs is non-callsign!");
      if (!strcmp(callx, user[unr]->call)) {
	w_btext(unr, 56);
	chwuser(unr, 32);
	wlnuser(unr, bbs);
      } else {
	sprintf(hs, "%ld", ufil.level);
	sprintf(hs, "OK, %s -> @%s level = %s", callx, bbs, strcpy(STR1, hs));
	wlnuser(unr, hs);
      }

      sprintf(STR1, "%s@%s", callx, bbs);
      gen_sftest(unr, STR1);
    }
  }
  chmbxsemaphore = false;

}


void change_levels(short unr, short cnr, Char *callx, short lvl)
{
  userstruct ufil;
  short x;

  debug(2, unr, 95, callx);
  load_userinfo_for_change(false, callx, &ufil);
  if (lvl > 127) {
    wlnuser(unr, "max. level = 127!");
    lvl = 127;
  }
  switch (cnr) {

  case 25:
    if (lvl > 1) lvl = 1;
    ufil.sf_level = lvl;
    ufil.ssf_level = lvl;
    break;

  case 29:
    ufil.level = lvl;
    ufil.plevel = lvl;
    break;

  case 66:
    ufil.pwmode = lvl;
    break;
  }
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, ufil.call)) {
	switch (cnr) {

	case 25:
	  user[x]->sf_level = lvl;
	  user[x]->ssf_level = lvl;
	  break;

	case 29:
	  if (user[x]->se_ok)
	    user[x]->level = lvl;
	  user[x]->plevel = lvl;
	  break;

	case 66:
	  user[x]->pwmode = lvl;
	  break;
	}
      }
    }
  }
  save_userfile(&ufil);
  wln_btext(unr, 57);
}


void change_name(short unr, Char *callx, Char *w_)
{
  Char w[256];
  short x;
  userstruct ufil;
  Char STR1[256];

  strcpy(w, w_);
  debug(2, unr, 96, callx);
  if (strlen(w) <= 1) {
    w_btext(unr, 60);

    user[unr]->action = 78;
    return;
  }

  cut(w, 80);
  gkdeutsch(w);
  load_userinfo_for_change(false, callx, &ufil);
  strcpy(ufil.name, w);
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, ufil.call))
	strcpy(user[x]->name, ufil.name);
    }
  }
  save_userfile(&ufil);
  if (!strcmp(callx, user[unr]->call)) {
    w_btext(unr, 58);
    chwuser(unr, 32);
    wuser(unr, w);
    wln_btext(unr, 59);
  } else {
    sprintf(STR1, "OK, %s -> %s", callx, w);
    wlnuser(unr, STR1);
  }
  user[unr]->action = 0;
}


boolean valid_language(Char *lan)
{
  boolean Result;
  languagetyp *hptr;

  Result = false;
  hptr = langmemroot;
  while (hptr != NULL) {
    if (hptr->puffer != NULL) {
      if (!strcmp(hptr->sprache, lan))
	Result = true;
    }
    hptr = hptr->next;
  }
  return Result;
}


void show_languages(short unr)
{
  languagetyp *hptr;
  short x;
  Char hs[256];

  wln_btext(unr, 66);
  wlnuser0(unr);
  hptr = langmemroot;
  x = 0;
  while (hptr != NULL) {
    if (hptr->puffer != NULL) {
      strcpy(hs, hptr->sprache);
      rspacing(hs, 4);
      wuser(unr, hs);
      x++;
      if (x % 18 == 0)
	wlnuser0(unr);
    }
    hptr = hptr->next;
  }
  if (x % 18 != 0)
    wlnuser0(unr);
}


void change_language(short unr, Char *callx, Char *w_)
{
  Char w[256];
  short x;
  userstruct ufil;
  Char STR1[256];

  strcpy(w, w_);
  debug(2, unr, 97, callx);
  if ((unsigned long)strlen(w) >= 32 || ((1L << strlen(w)) & 0xe) == 0) {
    wln_btext(unr, 62);
    show_languages(unr);
    return;
  }
  if (!valid_language(w)) {
    wln_btext(unr, 62);
    show_languages(unr);
    return;
  }
  upper(w);
  load_userinfo_for_change(false, callx, &ufil);
  strcpy(ufil.language, w);
  for (x = 1; x <= maxuser; x++) {
    if (user[x] != NULL) {
      if (!strcmp(user[x]->call, ufil.call))
	strcpy(user[x]->language, ufil.language);
    }
  }
  save_userfile(&ufil);
  if (strcmp(callx, user[unr]->call)) {
    sprintf(STR1, "OK, %s -> %s", callx, w);
    wlnuser(unr, STR1);
    return;
  }
  w_btext(unr, 61);
  chwuser(unr, 32);
  wlnuser(unr, w);
}


void show_systemtime(short unr)
{
  Char STR7[22];

  utc_clock();
  sprintf(STR7, "%s UTC %s", clock_.zeit, clock_.datum);
  wlnuser(unr, STR7);
}


void new_login(short unr, Char *times_)
{
  Char times[256];
  uchar d, m, y, h, min, s;
  Char hs[256];
  userstruct *WITH;
  short TEMP;
  Char STR1[256];

  strcpy(times, times_);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  while (strpos2(times, ".", 1) > 0)
    times[strpos2(times, ".", 1) - 1] = ' ';
  TEMP = count_words(times);
  if ((unsigned)TEMP < 32 && ((1L << TEMP) & 0xc) != 0) {
    get_word(times, hs);
    d = Str2int(hs);
    if (d >= 32 || ((1L << d) & 0xfffffffe) == 0)
      d = clock_.day;
    get_word(times, hs);
    m = Str2int(hs);
    if (m >= 32 || ((1L << m) & 0x1ffe) == 0)
      m = clock_.mon;
    get_word(times, hs);
    y = Str2int(hs);
    if ((hs[0] == '\0') || (y > 99))
      y = clock_.year;
    WITH->lastdate = calc_ixtime(d, m, y, 0, 0, 0);
  }

  decode_ixtime(WITH->lastdate, &d, &m, &y, &h, &min, &s);

  datum2string(Make_DDate(d, m, y), hs);
  w_btext(unr, 63);
  sprintf(STR1, " %s", hs);
  wuser(unr, STR1);
  zeit2string(Make_DTime(h, min, s), hs);
  strdelete((void *)hs, 6, 3);   /* Keine Sekunden zeigen*/
  sprintf(STR1, " %s", hs);
  wlnuser(unr, STR1);
}


void show_version(short unr, boolean extended)
{
  uchar *p;
  long sz, rp;
  short x, y;
  Char hs[256], w[256];
  Char STR1[256];
  Char STR7[34];

  if (!extended) {
#ifdef dpmacos
    sprintf(STR7, "dpbox (MacOS) v%s%s %s", dp_vnr, dp_vnr_sub, dp_date);
    wlnuser(unr, STR7);
    wlnuser(unr, "(c) 1990-1996 Joachim Schurig, DL8HBS");
    wlnuser(unr, "parts of the code: (c) 1994-1996 Mark Wahl, DL4YBG");
#endif
#ifdef dplinux
    sprintf(STR7, "dpbox (Linux) v%s%s %s", dp_vnr, dp_vnr_sub, dp_date);
    wlnuser(unr, STR7);
    wlnuser(unr, "(c) 1990-1996 Joachim Schurig, DL8HBS");
    wlnuser(unr, "Linux porting: (c) 1994-1996 Mark Wahl, DL4YBG");
#endif
    get_boxruntime_s(STR1);
    sprintf(hs, "dpbox runtime: %s", STR1);
    wlnuser(unr, hs);
    calc_ixsecs_to_string(get_sysruntime(), STR1);
    sprintf(hs, "system runtime: %s", STR1);
    wlnuser(unr, hs);

    y = 0;
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL)
	y++;
    }
    sprintf(hs, "%ld", y);
    sprintf(hs, "Logins: %s", strcpy(STR1, hs));
    wuser(unr, hs);
    sprintf(hs, "%ld", maxuser);
    sprintf(hs, " of max. %s", strcpy(STR1, hs));
    wlnuser(unr, hs);

    get_sysload(hs);
    sprintf(hs, "System load: %s", strcpy(STR1, hs));
    wlnuser(unr, hs);

    get_sysversion(hs);
    sprintf(hs, "System version: %s", strcpy(STR1, hs));
    wlnuser(unr, hs);

    w_btext(unr, 43);
    sprintf(w, "%ld", memavail__());
    sprintf(hs, ": %s (total free) Bytes", w);

    wlnuser(unr, hs);

    w_btext(unr, 148);
    wlnuser(unr, " V +");

    return;
  }

  p = NULL;
  boxgetstatus(user[unr]->supervisor, &p, &sz);
  if (p == NULL)
    return;
  rp = 0;
  while (rp < sz) {
    get_line(p, &rp, sz, hs);
    wlnuser(unr, hs);
  }
  boxfreestatp(&p);
}


void disc_user(short unr, Char *eingabe_)
{
  Char eingabe[256];
  short x, lo, hi;
  boolean allsf, alluser, all;
  Char hs[256];
  short FORLIM;

  strcpy(eingabe, eingabe_);
  debug(2, unr, 98, eingabe);

  get_word(eingabe, hs);

  upper(hs);
  cut(hs, 6);

  if (!strcmp(hs, "ALL")) {
    lo = 1;
    hi = maxuser;
    allsf = true;
    alluser = true;
    all = true;
  } else if (!strcmp(hs, "USER")) {
    lo = 1;
    hi = maxuser;
    allsf = false;
    alluser = true;
    all = false;
  } else if (!strcmp(hs, "SF")) {
    lo = 1;
    hi = maxuser;
    allsf = true;
    alluser = false;
    all = false;
  } else {
    if (callsign(hs))
      lo = actual_user(hs);
    else
      lo = Str2int(hs);
    hi = lo;
    allsf = false;
    all = true;
    alluser = false;
  }

  FORLIM = hi;
  for (x = lo; x <= FORLIM; x++) {
    if (x >= 1 && x <= maxuser) {
      if (x != unr) {
	if (boxrange(x)) {
	  if (user[x]->f_bbs && allsf || !user[x]->f_bbs && alluser || all) {
	    abort_useroutput(x);

	    if (*eingabe != '\0' && !user[x]->f_bbs) {
	      wlnuser(x, "");
	      wlnuser(x, eingabe);
	      wlnuser(x, "");
	    }

	    if (boxgetcompmode(user[x]->pchan)) {
	      wlnuser0(x);
	      wlnuser(x, "//COMP 0");
	      boxsetcompmode(x, false);
	    }

	    boxspoolread();

	    abort_useroutput(x);
	    end_boxconnect(x);

	  }

	}
      }
    }
  }

}


void write_ctext(short unr, Char *eingabe)
{
  Char hs[256];

  debug(3, unr, 99, eingabe);
  if (uspos("***END", eingabe) > 0 || useq(eingabe, "/EX") ||
      strpos2(eingabe, "\032", 1) > 0) {
    sfclose(&user[unr]->sendchan);
    user[unr]->action = 0;
    sprintf(hs, "%sctext%cnew", boxstatdir, extsep);
    if (sfsize(hs) == 0) {
      sfdelfile(hs);
      sfdelfile(ctext_box);
      wlnuser(unr, "ctext deleted");
      return;
    }
    sfdelfile(ctext_box);
    sfrename(hs, ctext_box);
    wlnuser(unr, "ctext changed");
    return;
  }
  if (strpos2(eingabe, "\030", 1) <= 0) {
    string_to_file(&user[unr]->sendchan, eingabe, true);
    return;
  }
  sfclose(&user[unr]->sendchan);
  user[unr]->action = 0;
  sprintf(hs, "%sctext%cnew", boxstatdir, extsep);
  sfdelfile(hs);
  wlnuser(unr, "ctext unchanged");
}


void enter_ctext(short unr)
{
  short k;
  Char STR1[256];

  wlnuser(unr, "CTEXT:");
  show_textfile(unr, ctext_box);
  w_btext(unr, 47);
  wlnuser(unr, " CTEXT ");
  wln_btext(unr, 48);
  wlnuser0(unr);
  sprintf(STR1, "%sctext%cnew", boxstatdir, extsep);
  k = sfcreate(STR1, FC_FILE);
  if (k >= minhandle) {
    user[unr]->action = 79;
    user[unr]->sendchan = k;
  } else
    wlnuser(unr, "can't create file");
}


void search_bull(short unr, Char *w, boolean kill, boolean add)
{
  long pos;
  Char hs[256];
  Char STR1[256];

  sprintf(STR1, "searching %s", w);
  wlnuser(unr, STR1);

  pos = bull_mem(w, kill);
  if (pos >= 0) {
    sprintf(hs, "%ld", pos);
    sprintf(hs, "found at position %s", strcpy(STR1, hs));
    if (kill)
      strcat(hs, "  - now deleted");
    wlnuser(unr, hs);
  } else
    wlnuser(unr, "... not found");

  if (add) {
    write_msgid(-1, w);
    wlnuser(unr, "now added");
  }

  sprintf(hs, "%ld", maxbullids);
  sprintf(hs, "MaxBullIDs: %s", strcpy(STR1, hs));
  wlnuser(unr, hs);
  sprintf(hs, "%ld", bullidseek);
  sprintf(hs, "BullIDSeek: %s", strcpy(STR1, hs));
  wlnuser(unr, hs);
  sprintf(hs, "%ld", sfsize(msgidlog) / 13);
  sprintf(hs, "BullIDs   : %s", strcpy(STR1, hs));
  wlnuser(unr, hs);
}


void set_talk_mode(short unr, Char *w)
{
  short xchan;
  Char hs[256];
  Char STR1[30];
  Char STR7[256];

  if (!boxrange(unr))
    return;
  xchan = str2disturb_chan(w);
  if (!boxrange(xchan))
    return;
  if (xchan <= 0 || xchan == unr) {
    wln_btext(unr, 11);
    return;
  }
  wlnuser(unr, "link setup...");
  wlnuser0(xchan);
  sprintf(STR1, "*** connect request of %s", user[unr]->call);
  wlnuser(xchan, STR1);
  boxspoolfend(user[xchan]->pchan);
  strcpy(hs, "*** connected to ");
  sprintf(STR7, "%s%s", hs, user[xchan]->call);
  wlnuser(unr, STR7);
  sprintf(STR7, "%s%s", hs, user[unr]->call);
  wlnuser(xchan, STR7);
  wln_btext(unr, 145);
  wln_btext(xchan, 145);
  wlnuser0(unr);
  wlnuser0(xchan);
  user[unr]->action = 80;
  user[xchan]->action = 80;
  user[unr]->talk_to = xchan;
  user[xchan]->talk_to = unr;
}


void end_talk_mode(short unr, boolean prompt)
{
  /*(unr:integer;prompt:boolean)*/
  Char bssid[256];
  Char STR1[256];

  if (!boxrange(unr))
    return;
  if (boxboxssid() > 0) {
    sprintf(bssid, "%ld", boxboxssid());
    sprintf(bssid, "-%s", strcpy(STR1, bssid));
  } else
    *bssid = '\0';
  user[unr]->talk_to = 0;
  user[unr]->action = 0;
  wlnuser0(unr);
  sprintf(STR1, "*** reconnected to %s%s", Console_call, bssid);
  wlnuser(unr, STR1);
  wlnuser0(unr);
  if (prompt)
    show_prompt(unr);
}


void talk_line(short unr, Char *eingabe)
{
  boolean endtalk;
  short x;

  if (!boxrange(unr))
    return;
  endtalk = false;
  x = strpos2(eingabe, "\032", 1);
  if (x > 0) {
    endtalk = true;
    cut(eingabe, x - 1);
  }

  wlnuser(user[unr]->talk_to, eingabe);

  if (!boxrange(user[unr]->talk_to))
    endtalk = true;

  if (endtalk) {
    end_talk_mode(user[unr]->talk_to, true);
    end_talk_mode(unr, false);
  }
}


void msgwuser(short unr, boolean immediate, Char *s, boolean cr)
{
  Char STR1[256];

  if (immediate) {
    if (cr)
      wlnuser(unr, s);
    else
      wuser(unr, s);
    return;
  }
  if (user[unr] != NULL) {
    sprintf(STR1, "%s%s%cMSG", boxstatdir, user[unr]->call, extsep);
    append(STR1, s, cr);
    user[unr]->newmsg = true;
  }
}


void send_msg(short unr, Char *w, Char *eingabe)
{
  short xchan, fp, ct, umb;
  boolean noprompt, allf, immediate;
  short lastchan;
  Char hs[256], z2[256];
  Char STR7[256], STR13[256];

  if (*eingabe == '\0') {
    wln_btext(unr, 2);
    return;
  }
  if (!strcmp(w, "ALL") && user[unr]->supervisor) {
    allf = true;
    xchan = 0;
  } else {
    xchan = str2disturb_chan2(w) - 1;
    allf = false;
  }
  if (xchan < 0) {
    wln_btext(unr, 11);
    return;
  }
  noprompt = (eingabe[0] == '&' && xchan == unr);
  if (noprompt) {
    strdelete((void *)eingabe, 1, 1);
    del_leadblanks(eingabe);
    umb = 79;
  } else
    umb = 55;

  if (allf)
    lastchan = maxuser;
  else
    lastchan = xchan + 1;

  strcpy(z2, eingabe);

  while (xchan < lastchan) {
    xchan++;
    if (user[xchan] == NULL || user[xchan]->f_bbs)
      continue;
    immediate = (user[xchan]->action == 0 &&
                 user[xchan]->lastprocnumber == 0 &&
                 boxspoolstatus(user[xchan]->tcon, user[xchan]->pchan, -1) == 0);
    strcpy(eingabe, z2);
    msgwuser(xchan, immediate, "", true);
    msgwuser(xchan, immediate, "", true);
    if (!noprompt) {
      sprintf(hs, "%ld", unr);
      sprintf(hs, "MSG de %s (%s)", user[unr]->call, strcpy(STR7, hs));
      rspacing(hs, 20);
      strcat(hs, ": ");
      msgwuser(xchan, immediate, hs, false);
    }


    ct = 0;
    do {
      ct++;
      strcpy(hs, eingabe);
      if (strlen(hs) > umb) {
	fp = umb;
	while (hs[fp - 1] != ' ' && fp > 1)
	  fp--;
	if (fp == 1)
	  fp = umb;
	cut(hs, fp);
	if (ct > 1 && !noprompt)
	  msgwuser(xchan, immediate, "                      ", false);
	msgwuser(xchan, immediate, hs, true);
	strdelete((void *)eingabe, 1, fp);
      } else {
	if (ct > 1 && !noprompt)
	  msgwuser(xchan, immediate, "                      ", false);
	msgwuser(xchan, immediate, hs, true);
	*eingabe = '\0';

      }

    } while (*eingabe != '\0');
    if (noprompt)
      continue;
    if (immediate)
      show_prompt(xchan);
    sprintf(hs, "%ld", xchan);
    sprintf(hs, "MSG OK FOR %s (%s)", user[xchan]->call, strcpy(STR13, hs));
    if (!immediate)
      sprintf(hs, "DELAYED %s", strcpy(STR13, hs));
    wlnuser(unr, hs);
  }
}



void set_comp_mode(short unr, Char *w)
{
  short chan;

  chan = user[unr]->pchan;
  if (!strcmp(w, "ON")) {
    if (boxgetcompmode(chan) != false)
      return;
    boxsetcompwait(chan, 1);
    wlnuser(unr, "//COMP 1");
    boxspoolfend(chan);
    boxsetcompmode(chan, true);
    return;
  }
  if (!strcmp(w, "OFF")) {
    if (!boxgetcompmode(chan))
      return;
    boxsetcompwait(chan, 2);
    wlnuser(unr, "//COMP 0");
    boxspoolfend(chan);
    boxsetcompmode(chan, false);
    return;
  }
  if (!strcmp(w, "1")) {
    boxsetcompmode(chan, true);
    return;
  }
  if (!strcmp(w, "0"))
    boxsetcompmode(chan, false);
  else
    wln_btext(unr, 2);
}


void reset_to_term(short unr, boolean to_sat, boolean to_node)
{
  debug0(2, unr, 100);
  wln_btext(unr, 1);
}


void show_ext_command_result(short unr)
{
  userstruct *WITH;
  short outfiles;
  Char STR1[256];

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (*WITH->wait_file == '\0')
    return;

  outfiles = 0;
  if (exist(WITH->wait_file)) outfiles++;
  new_ext(WITH->wait_file, "trn");
  if (exist(WITH->wait_file)) outfiles++;
  new_ext(WITH->wait_file, "bin");
  if (exist(WITH->wait_file)) outfiles++;
  
  if (outfiles == 0) {
    WITH->wait_file[0] = '\0';
    return;
  }

  new_ext(WITH->wait_file, "txt");
  
  if (exist(WITH->wait_file)) {
    strdelete((void *)WITH->wait_file, 1, strlen(boxdir));
    sprintf(STR1, "%s -A", WITH->wait_file);
    if (outfiles == 1)
      read_file(true, unr, STR1);
    else
      read_file_immediate(true, unr, STR1);
    sprintf(STR1, "%s%s", boxdir, WITH->wait_file);
    strcpy(WITH->wait_file, STR1);
  }

  new_ext(WITH->wait_file, "trn");
  if (exist(WITH->wait_file)) {
    strdelete((void *)WITH->wait_file, 1, strlen(boxdir));
    sprintf(STR1, "%s -F", WITH->wait_file);
    if (outfiles == 1)
      read_file(true, unr, STR1);
    else
      read_file_immediate(true, unr, STR1);
    sprintf(STR1, "%s%s", boxdir, WITH->wait_file);
    strcpy(WITH->wait_file, STR1);
  }

  new_ext(WITH->wait_file, "bin");
  if (exist(WITH->wait_file)) {
    strdelete((void *)WITH->wait_file, 1, strlen(boxdir));
    sprintf(STR1, "%s", WITH->wait_file);
    if (outfiles == 1)
      read_file(true, unr, STR1);
    else
      read_file_immediate(true, unr, STR1);
    sprintf(STR1, "%s%s", boxdir, WITH->wait_file);
    strcpy(WITH->wait_file, STR1);
  }

  WITH->wait_file[0] = '\0';
  
  if (outfiles == 1) {
    if (read_filepart(unr))
      WITH->action = 96;
  }
}


Static unsigned short lastrunnum;


boolean open_shell(short unr, boolean transparent)
{
  boolean Result;
  short olda;
  userstruct *WITH;

  Result = false;
  if (!boxrange(unr))
    return Result;
  WITH = user[unr];
  if (!WITH->supervisor)
    return Result;

  WITH->wait_file[0] = '\0';
  olda = WITH->action;
  WITH->action = 99;
  boxsetrwmode(WITH->pchan, 9);
  if (cmd_shell(unr, transparent) == 0) {
    boxsetrwmode(WITH->pchan, 0);
    WITH->action = olda;
  } else {
    Result = true;
    wlnuser(unr, "OK");
  }
  return Result;
}


void call_runprg(boolean extern_, short unr, Char *fname_, Char *rkommando_,
		 boolean full_gem)
{
  Char fname[256], rkommando[256];
  short olda;
  Char w[256], rd[256], ofi[256];
  Char adir[256];
  userstruct *WITH;
  Char STR1[256], STR7[256];

  strcpy(fname, fname_);
  strcpy(rkommando, rkommando_);
  debug(2, unr, 101, fname);

  if (!boxrange(unr))
    return;

  WITH = user[unr];
  strcpy(rd, boxrundir);
  if (insecure(fname))
    *fname = '\0';
  if (!extern_)
    lower(fname);
  sprintf(fname, "%s%s", rd, strcpy(STR1, fname));

  if (*fname == '\0')
    return;

  recompile_log(unr);
  recompile_fwd();

  lastrunnum++;

  sfgetdir(0, adir);
  sprintf(w, "%ld", lastrunnum);
  sprintf(ofi, "%sout%s%ctrn", rd, w, extsep);
  sfdelfile(ofi);
  new_ext(ofi, "bin");
  sfdelfile(ofi);
  new_ext(ofi, "txt");
  sfdelfile(ofi);

  olda = WITH->action;
  WITH->action = 99;
  strcpy(WITH->wait_file, ofi);

  sfchdir(rd);
  boxsetrwmode(WITH->pchan, 9);
  sprintf(rkommando, "%s %s", fname, strcpy(STR7, rkommando));
  if (cmd_run(unr, full_gem, rkommando, ofi) == 0) {
    boxsetrwmode(WITH->pchan, 0);
    WITH->action = olda;
    *WITH->wait_file = '\0';
  }
  sfchdir(adir);

}


typedef Char est[2];


void stelle_uhr(Char *eingabe, boolean datum)
{
  static est est1 = ".", est2 = "/", est3 = ":", est4 = "-";

  short h, m, s;
  Char w[256];
  Char datestr[256];

  strcpy(datestr, eingabe);
  ersetze(est1, "  ", datestr);
  ersetze(est2, "  ", datestr);
  ersetze(est3, "  ", datestr);
  ersetze(est4, "  ", datestr);
  get_word(datestr, w);
  if (*w != '\0') {
    h = Str2int(w);
    get_word(datestr, w);
    m = Str2int(w);
    get_word(datestr, w);
    s = Str2int(w);
/*
    if (datum)
      dpsetdate(s + 1900, m, h);
    else
      dpsettime(h, m, s);
*/
  }

  utc_clock();
}


void calc_boxactivity(short unr, cbaproc outputproc)
{
  short x;
  long isec;
  Char hs[256], w[256];
  userstruct *WITH;
  Char STR1[256];

  utc_clock();
  outputproc(unr, "Call   BCh     TxBuff Idle  Board    Command");

  for (x = 1; x <= maxuser; x++) {
    if (boxrange(x)) {
      WITH = user[x];
      strcpy(hs, WITH->call);
      if (WITH->f_bbs) {
	lower(hs);
	if (WITH->sf_to)
	  strcat(hs, "<");
	else
	  strcat(hs, ">");
      }
      rspacing(hs, 7);
      sprintf(w, "%ld", x);
      lspacing(w, 3);
      strcat(hs, w);
      if (WITH->umode < 32 &&
	  ((1L << WITH->umode) & ((1L << UM_MODEM_IN) | (1L << UM_MODEM_OUT))) != 0)
	strcpy(w, "MDM");
      else if (WITH->pchan > 0)
	strcpy(w, "   ");
      else
	strcpy(w, "TRM");
      sprintf(hs + strlen(hs), " %s", w);
      sprintf(w, "%ld", boxspoolstatus(WITH->tcon, WITH->pchan, -1));
      lspacing(w, 6);
      sprintf(hs + strlen(hs), " %s", w);
      isec = clock_.ixtime - WITH->lastcmdtime;
      if (isec > 5999)
	isec = 5999;
      sprintf(w, "%ld", isec / 60);
      if (strlen(w) < 2)
	sprintf(w, "0%s", strcpy(STR1, w));
      sprintf(hs + strlen(hs), " %s", w);
      sprintf(w, "%ld", isec % 60);
      if (strlen(w) < 2)
	sprintf(w, "0%s", strcpy(STR1, w));
      sprintf(hs + strlen(hs), ":%s", w);
      if (WITH->smode) {
        strcpy(w, "(files)");
      } else {
        strcpy(w, WITH->brett);
      }
      rspacing(w, 8);
      sprintf(hs + strlen(hs), " %s %s", w, WITH->lastcmd);
      cut(hs, 79);
      outputproc(unr, hs);
    }
  }
}


void show_boxactivity(short unr)
{
  void (*TEMP)(short unr, Char *s);

  TEMP = wlnuser;
  calc_boxactivity(unr, TEMP);
}


void yapp_responses(short unr, uchar *info, long infosize)
{
  short olda;
  userstruct *WITH;

  if (infosize <= 0)
    return;
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (WITH->yapp == NULL)
    return;

  if (WITH->yapp->filefd < minhandle) {
    WITH->yapp->filefd = sfopen(WITH->yapp->fname, FO_READ);
    sfseek(WITH->yapp->seekpos, WITH->yapp->filefd, SFSEEKSET);
  }

  WITH->yapp->touch = clock_.ixtime;
  if (yapp_upload(false, false, WITH->yapp, info, infosize))
    return;
  sfclose(&WITH->yapp->filefd);
  if (WITH->yapp->delete_)
    sfdelfile(WITH->yapp->fname);
  Free(WITH->yapp);
  WITH->yapp = NULL;
  olda = WITH->action;
  WITH->action = 0;
  boxsetrwmode(WITH->pchan, 0);
  boxspoolfend(WITH->pchan);
  if (olda == 96)
    show_prompt(unr);
}


boolean read_filepart(short unr)
{
  boolean Result;
  long len, fill;
  uchar buff[4096];
  userstruct *WITH;

  Result = false;
  if (!boxrange(unr))
    return Result;

  WITH = user[unr];

  if (WITH->yapp != NULL) {
    if (WITH->yapp->filefd < minhandle) {
      WITH->yapp->filefd = sfopen(WITH->yapp->fname, FO_READ);
      sfseek(WITH->yapp->seekpos, WITH->yapp->filefd, SFSEEKSET);
    }

    WITH->yapp->touch = clock_.ixtime;
    
    if (yapp_upload(false, WITH->yapp->filefd < minhandle, WITH->yapp, NULL,
		    0))
      return true;

    sfclose(&WITH->yapp->filefd);
    if (WITH->yapp->delete_)
      sfdelfile(WITH->yapp->fname);
    Free(WITH->yapp);
    WITH->yapp = NULL;
    boxsetrwmode(WITH->pchan, 0);
    boxspoolfend(WITH->pchan);
    if (WITH->action == 96)
      show_prompt(unr);
    return Result;
  }

  if (WITH->bin == NULL)
    return Result;
  if (WITH->bin->posi < WITH->bin->total) {
    if (WITH->bin->filefd < minhandle)
      WITH->bin->filefd = sfopen(WITH->bin->fname, FO_READ);

    if (WITH->bin->filefd < minhandle) {
      wlnuser0(unr);
      wlnuser(unr, "#ABORT#");
      wlnuser0(unr);
      wln_btext(unr, 106);
      WITH->bin->posi = WITH->bin->total;
    } else {
      if (sfseek(WITH->bin->posi, WITH->bin->filefd, SFSEEKSET) !=
	  WITH->bin->posi) {
	if (!WITH->bin->ascii) {
	  wlnuser0(unr);
	  wlnuser(unr, "#ABORT#");
	}
	wlnuser0(unr);
	wln_btext(unr, 149);
	WITH->bin->posi = WITH->bin->total;
      } else {
	fill = 0;
	do {
	  len = sfread(WITH->bin->filefd, 4096, buff);

	  if (len > 0) {
	    WITH->bin->touch = clock_.ixtime;
            upd_statistik(unr, 0, len, 0, 0);
	    boxmemspool(WITH->tcon, WITH->pchan, -1, WITH->bin->ascii, buff,
			len);
	    WITH->bin->posi += len;
	    fill += len;
	    Result = true;
	  } else if (len < 0 || WITH->bin->posi < WITH->bin->total) {
	    if (!WITH->bin->ascii) {
	      wlnuser0(unr);
	      wlnuser(unr, "#ABORT#");
	    }
	    wlnuser0(unr);
	    wln_btext(unr, 149);
	    WITH->bin->posi = WITH->bin->total;
	  }
	} while (WITH->bin->posi < WITH->bin->total &&
		 fill <= WITH->bin->maxfill);

      }


    }


  }

  if (WITH->bin->posi < WITH->bin->total)
    return Result;

  sfclose(&WITH->bin->filefd);
  if (WITH->bin->delete_)
    sfdelfile(WITH->bin->fname);
  Free(WITH->bin);
  WITH->bin = NULL;
  Result = false;
  boxspoolfend(WITH->pchan);
  if (WITH->action == 96)
    show_prompt(unr);
  return Result;


}


void abort_fileread(short unr)
{
  userstruct *WITH;

  if (!boxrange(unr))
    return;

  WITH = user[unr];
  if (WITH->yapp != NULL) {
    yapp_upload(false, true, WITH->yapp, NULL, 0);
    sfclose(&WITH->yapp->filefd);
    if (WITH->yapp->delete_)
      sfdelfile(WITH->yapp->fname);
    Free(WITH->yapp);
    WITH->yapp = NULL;
    boxsetrwmode(WITH->pchan, 0);
  }

  if (WITH->bin != NULL) {
    sfclose(&WITH->bin->filefd);
    if (WITH->bin->delete_ || WITH->bin->write_)
      sfdelfile(WITH->bin->fname);
    Free(WITH->bin);
    WITH->bin = NULL;
  }

  boxspoolfend(WITH->pchan);
  if (WITH->action == 96)
    show_prompt(unr);
}


Static void yappprotokoll(short unr, Char *s)
{
  Char STR1[256];

  sprintf(STR1, "YAPP: %s", s);
  boxprotokoll(STR1);
}


Static void yappbufout(short unr, uchar *base, long size)
{
  upd_statistik(unr, 0, size, 0, 0);
  boxmemspool(user[unr]->tcon, user[unr]->pchan, -1, false, base, size);
}


#define psize_          16384
#define ymaxfill        20000


boolean read_file(boolean delete_afterwards, short unr, Char *eingabe_)
{
  boolean Result;
  Char eingabe[256];
  long size;
  unsigned short crc;
  short k;
  boolean ascii, yapp_, pack, transparent;
  long tail, fsize, start;
  boolean on_linestart;
  Char hs[256], w[256];
  Char fname[256];
  Char pname[256];
  Char dname[256];
  Char STR1[256], STR7[256];
  userstruct *WITH;

  strcpy(eingabe, eingabe_);
  Result = false;
  if (!boxrange(unr))
    return Result;
  debug(2, unr, 102, eingabe);

  abort_fileread(unr);

  if (insecure(eingabe))
    return Result;
  sprintf(eingabe, "%s%s", boxdir, strcpy(STR1, eingabe));
  get_word(eingabe, fname);
  strcpy(pname, fname);
  strcpy(dname, fname);
  k = strlen(boxdir) + 1;
  strsub(dname, fname, k, strlen(fname) - k + 1);

  upper(eingabe);
  transparent = (strpos2(eingabe, "-F", 1) > 0);
  ascii = (strpos2(eingabe, "-A", 1) > 0);
  pack = (!ascii && strpos2(eingabe, "-P", 1) > 0);
  yapp_ = (!ascii && strpos2(eingabe, "-Y", 1) > 0);
  tail = 0;
  on_linestart = false;

  if (!yapp_) {
    k = strpos2(eingabe, "-TN", 1);
    if (k == 0)
      k = strpos2(eingabe, "-T", 1);
    else
      on_linestart = true;
    if (k > 0 && !pack) {
      if (on_linestart)
	strdelete((void *)eingabe, 1, k + 2);
      else
	strdelete((void *)eingabe, 1, k + 1);
      get_word(eingabe, w);
      tail = str2lint(w);
      if (tail < 0)
	tail = 0;
    }
  }

  fsize = sfsize(fname);
  if (fsize <= 0) {
    wln_btext(unr, 4);
    return Result;
  }
  size = fsize;

  if (pack) {
    sprintf(pname, "%sTDHPF%c001", tempdir, extsep);
    validate(pname);
    pack = (huffpacker(true, fname, pname, false) >= 0);
    if (!pack) {
      sfdelfile(pname);
      strcpy(pname, fname);
    }
    fsize = sfsize(pname);
    size = fsize;
  }

  start = 0;
  if (tail > 0) {
    if (tail > size)
      tail = size;
    start = size - tail;
    size = tail;
  }

  sprintf(hs, "%ld", size);

  if (!ascii && !transparent && !yapp_) {
    wlnuser0(unr);
    if (pack)
      wlnuser(unr, txt21);
    sprintf(hs, "#BIN#%s#", strcpy(STR7, hs));
    crc = file_crc(2, pname, 0, start, size);
    sprintf(w, "%ld", crc);
    del_path(dname);
    sprintf(hs + strlen(hs), "|%s#$1C539197#%s", w, dname);
    wlnuser(unr, hs);
  } else if (!transparent)
    wlnuser0(unr);

  k = sfopen(pname, FO_READ);
  if (k >= minhandle) {
    if (ascii && on_linestart) {
      sfseek(start, k, SFSEEKSET);
      file_to_string(k, hs);
      tail = sfseek(0, k, SFSEEKCUR);
      start = tail;
    }

    if (yapp_) {
      user[unr]->yapp = Malloc(sizeof(yapptype));
      if (user[unr]->yapp == NULL)
	return Result;
      WITH = user[unr];
      WITH->yapp->state = 0;
      WITH->yapp->filefd = k;
      WITH->yapp->delete_ = pack || delete_afterwards;
      WITH->yapp->write_ = false;
      WITH->yapp->yappc = 0;
      WITH->yapp->total = 0;
      WITH->yapp->filelength = fsize;
      WITH->yapp->seekpos = 0;
      WITH->yapp->touch = clock_.ixtime;
      WITH->yapp->maxfill = ymaxfill;
      WITH->yapp->unr = unr;
      WITH->yapp->chout = chwuser;
      WITH->yapp->lineout = wuser;
      WITH->yapp->buffout = yappbufout;
      WITH->yapp->statout = yappprotokoll;
      WITH->yapp->outlen = 0;
      WITH->yapp->outbufptr = 0;
      WITH->yapp->buflen = 0;
      WITH->yapp->fdate = 0;
      WITH->yapp->ftime = 0;
      strcpy(WITH->yapp->fname, pname);
      sprintf(WITH->yapp->yappdir, "%s%sincoming%c", boxdir, fservdir, dirsep);
      boxsetrwmode(WITH->pchan, 9);
      wln_btext(unr, 187);
      return (yapp_upload(true, false, WITH->yapp, NULL, 0));
    }

    user[unr]->bin = Malloc(sizeof(bintype));
    if (user[unr]->bin != NULL) {
      WITH = user[unr];
      WITH->bin->filefd = k;
      WITH->bin->write_ = false;
      WITH->bin->delete_ = pack || delete_afterwards;
      WITH->bin->ascii = ascii;
      WITH->bin->maxfill = ymaxfill;
      WITH->bin->posi = start;
      WITH->bin->total = fsize;
      WITH->bin->touch = clock_.ixtime;
      strcpy(WITH->bin->fname, pname);
      return true;
    }
    wln_btext(unr, 106);
    sfclose(&k);
    if (pack)
      sfdelfile(pname);
    return Result;
  }

  wln_btext(unr, 4);
  if (pack)
    sfdelfile(pname);
  return Result;
}

#undef psize_
#undef ymaxfill


void read_file_immediate(boolean delete_afterwards, short unr, Char *eingabe)
{
  if (read_file(delete_afterwards, unr, eingabe)) {
    do {
    } while (read_filepart(unr));
  }
}


void write_file2(short unr, Char *eingabe_)
{
  Char eingabe[256];
  Char hs[256];
  userstruct *WITH;

  strcpy(eingabe, eingabe_);
  debug(2, unr, 124, eingabe);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (true_bin(eingabe)) {
    WITH->errors = -5;
    boxprwprg2(WITH->pchan, eingabe);
    *hs = '\0';
    box_rtitle(true, unr, hs);
    if (WITH->action == 88)
      WITH->action = 89;
    return;
  }
  if (!strcmp(eingabe, "SHOWPROMPT")) {
    WITH->action = 0;
    WITH->errors = -5;
    return;
  }
  if (strpos2(eingabe, "#ABORT#", 1) > 0) {
    WITH->errors = 0;
    boxsetrwmode(WITH->pchan, 0);
    wln_btext(unr, 1);
    WITH->action = 0;
    return;
  }
  WITH->errors++;
  if (WITH->errors < 0)
    return;
  boxsetrwmode(WITH->pchan, 0);
  wln_btext(unr, 1);
  WITH->action = 0;
}


void yapp_input(short unr, uchar *info, long infosize)
{
  userstruct *WITH;

  if (infosize <= 0)
    return;
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (WITH->yapp == NULL)
    return;

  if (WITH->yapp->filefd < minhandle && WITH->action == 98) {
    WITH->yapp->filefd = sfopen(WITH->yapp->fname, FO_READ);
    sfseek(0, WITH->yapp->filefd, SFSEEKEND);
  }

  WITH->yapp->touch = clock_.ixtime;
  if (yapp_download(WITH->action == 97, false, WITH->yapp, info, infosize)) {
    if (WITH->action == 97)
      WITH->action = 98;
    return;
  }
  sfclose(&WITH->yapp->filefd);
  if (WITH->yapp->delete_)
    sfdelfile(WITH->yapp->fname);
  Free(WITH->yapp);
  WITH->yapp = NULL;
  WITH->action = 0;
  boxsetrwmode(WITH->pchan, 0);
  boxspoolfend(WITH->pchan);
  show_prompt(unr);
}


void write_file(short unr, Char *eingabe_)
{
  Char eingabe[256];
  boolean yapp_;
  Char fname[256];
  userstruct *WITH;
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  debug(2, unr, 103, eingabe);
  if (!boxrange(unr))
    return;

  WITH = user[unr];
  if (WITH->pchan <= 0)
    return;
  get_word(eingabe, fname);
  if (*fname == '\0')
    return;
  sprintf(fname, "%s%s", boxdir, strcpy(STR1, fname));
  if (insecure(fname))
    return;

  upper(eingabe);
  yapp_ = (strpos2(eingabe, "-Y", 1) > 0);

  if (yapp_) {
    WITH->yapp = Malloc(sizeof(yapptype));
    if (WITH->yapp == NULL)
      return;
    WITH->yapp->state = 0;
    WITH->yapp->filefd = nohandle;
    WITH->yapp->delete_ = true;
    WITH->yapp->write_ = true;
    WITH->yapp->yappc = 0;
    WITH->yapp->total = 0;
    WITH->yapp->filelength = 0;
    WITH->yapp->seekpos = 0;
    WITH->yapp->touch = clock_.ixtime;
    WITH->yapp->maxfill = 20000;
    WITH->yapp->unr = unr;
    WITH->yapp->chout = chwuser;
    WITH->yapp->lineout = wuser;
    WITH->yapp->buffout = yappbufout;
    WITH->yapp->statout = yappprotokoll;
    WITH->yapp->outlen = 0;
    WITH->yapp->outbufptr = 0;
    WITH->yapp->buflen = 0;
    WITH->yapp->fdate = 0;
    WITH->yapp->ftime = 0;
    strcpy(WITH->yapp->fname, fname);
    sprintf(WITH->yapp->yappdir, "%s%sincoming%c", boxdir, fservdir, dirsep);
    wln_btext(unr, 182);
    boxspoolread();
    boxsetrwmode(WITH->pchan, 9);
    WITH->action = 97;
    return;
  }

  wln_btext(unr, 146);
  boxspoolread();
  WITH->action = 87;
  WITH->errors = -5;
  boxsetinpfile(WITH->pchan, fname);
  boxsetrwmode(WITH->pchan, 5);
}


void update_dp2(short unr)
{
  if (exist(dp_new_prg)) {
    sfdelfile(dp_prg);
    if (sfrename(dp_new_prg, dp_prg) == 0)
      wlnuser(unr, "UPDATE completed");
    else
      wlnuser(unr, "error while renaming");
  } else
    wlnuser(unr, "update file not found");
  user[unr]->action = 87;
}


void update_dp(short unr, Char *eingabe)
{
  if (!boxrange(unr))
    return;
  if (user[unr]->pchan <= 0)
    return;
  wlnuser(unr, "preparing upload of DP.PRG");
  write_file(unr, dp_new_prg);
  user[unr]->action = 88;
}


void show_file_dir(short unr, Char *eingabe_)
{
  Char eingabe[256];
  boolean err;
  short x;
  Char fn[256], cmd[256];
  Char STR1[256], STR7[256];
  void (*TEMP)(short unr, Char *s);

  strcpy(eingabe, eingabe_);
  err = insecure(eingabe);
  sprintf(eingabe, "%s%s", boxdir, strcpy(STR1, eingabe));

  get_word(eingabe, cmd);
  if (err) {
    wln_btext(unr, 2);
    return;
  }

  if (cmd[strlen(cmd) - 1] == dirsep)
    sprintf(cmd + strlen(cmd), "%c%c%c", allquant, extsep, allquant);

  x = strlen(boxdir) + 1;
  strsub(fn, cmd, x, strlen(cmd) - x + 1);

  sprintf(STR7, "Content of %s :", fn);
  wlnuser(unr, STR7);
  wlnuser0(unr);
  wlnuser(unr, "    Filename                      Size  Date      Time");
  wlnuser0(unr);

  TEMP = wlnuser;
  file_dir(user[unr]->supervisor, cmd, "-L", unr, TEMP);
}


void calc_pwdb(Char *call_, Char *code, Char *pw)
{
  Char call[7];
  short spalte, min, k, zeile, dat;
  long fsize;
  Char d[256], t[256], fname[256];

  strcpy(call, call_);
  *pw = '\0';
  if (!(strlen(code) == 10 && zahl(code)))
    return;
  sprintf(d, "%.2s", code);
  strsub(t, code, 7, 4);
  dat = Str2int(d);
  sprintf(d, "%.2s", t);
  strdelete((void *)t, 1, 2);
  spalte = Str2int(d);
  min = Str2int(t);
  zeile = min + dat;
  if (zeile >= 60)
    zeile -= 60;

  lower(call);
  sprintf(fname, "%s%s%cpwd", boxsfdir, call, extsep);
  fsize = sfsize(fname);
  if (fsize < 1620)
    return;
  k = sfopen(fname, FO_READ);
  if (k < minhandle)
    return;
  if (fsize == 1620)   /* ohne CR */
    sfseek(zeile * 27 + spalte, k, SFSEEKSET);
  else  /* mit CR */
    sfseek(zeile * 29 + spalte, k, SFSEEKSET);
  /* Achtung Linux: Offset = 28 */
  sfread(k, 4, pw);
  pw[4] = '\0';
  sfclose(&k);
}


void calc_pwtn(Char *call, Char *code_, Char *pw)
{
  Char code[256];
  short x, y;
  Char pws[256];
  Char w[256];

  strcpy(code, code_);
  *pw = '\0';
  if (count_words(code) != 5)
    return;
  *pws = '\0';
  x = actual_user(call);
  if (x > 0)
    strcpy(pws, user[x]->password);
  if (*pws == '\0')
    return;
  for (x = 1; x <= 5; x++) {
    get_word(code, w);
    y = Str2int(w);
    if (y > 0 && y <= strlen(pws))
      sprintf(pw + strlen(pw), "%c", pws[y - 1]);
  }
}


void jitter_pwtn(Char *pw)
{
  short x;
  Char c;
  Char hs[256];

  if (*pw == '\0')
    return;
  *hs = '\0';
  for (x = 1; x <= 53; x++) {
    do {
      c = dp_randomize(48, 122);
    } while (!isalnum(c));
    sprintf(hs + strlen(hs), "%c", c);

  }
  x = dp_randomize(1, 52);
  strinsert(pw, (void *)hs, x);
  strcpy(pw, hs);
}


void generate_dbpwfile(short unr, Char *fname_, Char *options)
{
  Char fname[256];
  short k, x;
  Char c;
  boolean fwd;
  Char fcall[256];
  Char hs[256];
  Char STR1[256];
  Char STR7[12];

  strcpy(fname, fname_);
  fwd = false;
  if (callsign(fname)) {
    lower(fname);
    strcpy(fcall, fname);
    fwd = (strpos2(options, "+", 1) > 0);
    if (fwd) {
      strcpy(hs, Console_call);
      lower(hs);
      sprintf(fname, "%s%s%cpwd", boxdir, hs, extsep);
    } else
      sprintf(fname, "%s%s%cpwd", boxsfdir, strcpy(STR1, fname), extsep);
  } else {
    *fcall = '\0';

    if (insecure(fname))
      return;
    sprintf(fname, "%s%s", boxdir, strcpy(STR1, fname));
  }

  k = sfcreate(fname, FC_FILE);
  if (k < minhandle) {
    wln_btext(unr, 98);
    return;
  }
  for (x = 1; x <= 1620; x++) {
    do {
      c = dp_randomize(48, 122);
    } while (!isalnum(c));
    sfwrite(k, 1, &c);
  }
  sfclose(&k);

  if (*fcall != '\0') {
    if (fwd) {
      sprintf(STR7, "%s.PWD", Console_call);
      sprintf(STR1, "%%%s", fname);
      send_sysmsg(fcall, "", STR7, STR1, 3);
      sprintf(STR1, "%s%s%cpwd", boxdir, fcall, extsep);
      filemove(fname, STR1);
    }
  }

  wlnuser(unr, "OK");
}



Static void idis(boolean ident, short unr)
{
  Char hs[256];

  if (!ident)
    return;
  *hs = '\0';
  lspacing(hs, 15);
  if (unr > 0)
    wuser(unr, hs);
}


Static void op(short unr, short *oh, Char *s)
{
  if (unr > 0)
    wlnuser(unr, s);
  else if (*oh >= minhandle)
    string_to_file(oh, s, true);

}


typedef struct stt {
  struct stt *next;
  Char call[7];
  unsigned short uh, bh, u;

  unsigned short b, s, bin;

  unsigned short d;
  long size;
} stt;


void create_sfstat(short unr, Char *eingabe_)
{
  Char eingabe[256];
  stt *st, *hp, *hp1;
  sfdeftype *sfptr;
  indexstruct *hpointer, header;
  userstruct rec;
  short k, lv, x, list;
  uchar *xpuffer;
  long xsize, tli, ttuh, ttbh, ttu, ttb, tts, ttsize, rtu, rtb, rts, urtsize,
       uttsize, utli, tu, urtsize2, uttsize2, utli2, tbn, td, rtsize;
  boolean ident, ttofl, readjust;
  short oh, bf;
  Char w[256], w1[256], bn[256];
  Char hs[256];
  Char xname[256];
  Char STR1[256];

  if (boxrange(unr)) { /* do not recompile the fwd-list if called by users */
    if (user[unr]->supervisor)
      recompile_fwd();
  } else recompile_fwd();
  strcpy(eingabe, eingabe_);
  st = NULL;
  sfptr = sfdefs;
  oh = nohandle;
  ttofl = false;
  ident = false;

  readjust = (!strcmp(eingabe, "-") &&
	      (unr < 0 || boxrange(unr) && user[unr]->supervisor));

  if (!readjust) {
    while (sfptr != NULL) {
      hp1 = Malloc(sizeof(stt));
      if (hp1 != NULL) {
	strcpy(hp1->call, sfptr->call);

	hp1->next = NULL;
	hp1->uh = 0;
	hp1->bh = 0;
	hp1->u = 0;
	hp1->b = 0;
	hp1->s = 0;
	hp1->bin = 0;
	hp1->d = 0;
	hp1->size = 0;
      }
      if (st == NULL)
	st = hp1;
      else {
	hp = st;
	while (hp->next != NULL)
	  hp = hp->next;
	if (hp != NULL)
	  hp->next = hp1;
      }
      sfptr = sfptr->next;
    }

    upper(eingabe);
    ident = (strpos2(eingabe, "+", 1) == 1 || strpos2(eingabe, "!", 1) == 1);

    sprintf(bn, "%sbcstat%cbox", boxstatdir, extsep);

    if (strpos2(eingabe, "RESET", 1) != 1 && unr > 0) {
      if (st != NULL) {
	/*ausstehende mails zu den registrierten Partnern anzeigen*/

	list = nohandle;
	sprintf(xname, "%sX%c%s", indexdir, extsep, idx_e);
	sfbread(false, xname, &xpuffer, &xsize);

	if (xsize <= 0)
	  lv = sfsize(xname) / sizeof(indexstruct);
	else
	  lv = xsize / sizeof(indexstruct);
	if (lv > 0) {
	  hpointer = NULL;
	  if (xsize <= 0) {
	    list = sfopen(xname, FO_READ);
	    hpointer = &header;   /* bleibt ja gleich */

	  } else
	    list = nohandle;


	  for (k = 1; k <= lv; k++) {
	    if (k % 20 == 0)
	      dp_watchdog(2, 4711);

	    if (xsize <= 0)
	      read_index(list, k, &header);
	    else
	      hpointer = (indexstruct *)(&xpuffer[(k - 1) * sizeof(indexstruct)]);

	    if (check_hcs(*hpointer)) {
	      hp = st;
	      while (strcmp(hp->call, hpointer->dest) && hp->next != NULL)
		hp = hp->next;

	      if (!strcmp(hp->call, hpointer->dest)) {
		if (hpointer->deleted)
		  hp->d++;
		else {
		  if ((hpointer->pmode & TBIN) != 0)
		    hp->bin++;
		  if ((hpointer->msgflags & (MSG_LOCALHOLD | MSG_SFHOLD)) != 0) {
		    if ((hpointer->pmode & 1) != 0)
		      hp->uh++;
		    if ((hpointer->pmode & 2) != 0)
		      hp->bh++;
		  } else {
		    if ((hpointer->pmode & 1) != 0)
		      hp->u++;
		    if ((hpointer->pmode & 2) != 0)
		      hp->b++;
		  }



		  if ((hpointer->pmode & 4) != 0 ||
		      (hpointer->pmode & 16) != 0)
		    hp->s++;
		  else
		    hp->size += hpointer->size;
		}
	      }
	    }
	  }
	}

	sfclose(&list);
	if (xpuffer != NULL)
	  mymfreep(&xpuffer);

	ttuh = 0;
	ttbh = 0;
	ttu = 0;
	ttb = 0;
	tts = 0;
	tbn = 0;
	td = 0;
	ttsize = 0;
	idis(ident, unr);
	idis(ident, unr);
	wlnuser(unr, "waiting msgs in s&f:");
	wlnuser0(unr);
	idis(ident, unr);
	wlnuser(unr,
		"     P = Usermails  B = Bulletins  S = System-Mails");
	wlnuser0(unr);
	idis(ident, unr);
	wlnuser(unr,
		"Call       P     B     S   BIN   P(H)  B(H)    D     Size");

	idis(ident, unr);
	wlnuser(unr,
		"---------------------------------------------------------");

	hp = st;
	while (hp != NULL) {
	  ttuh += hp->uh;
	  ttbh += hp->bh;
	  ttu += hp->u;
	  ttb += hp->b;
	  tts += hp->s;
	  td += hp->d;
	  tbn += hp->bin;

	  ttsize += hp->size;

	  strcpy(w, hp->call);
	  rspacing(w, 6);
	  strcpy(hs, w);
	  sprintf(w, "%ld", hp->u);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->b);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->s);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->bin);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->uh);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->bh);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->d);
	  lspacing(w, 6);
	  strcat(hs, w);
	  sprintf(w, "%ld", hp->size);
	  lspacing(w, 9);
	  strcat(hs, w);
	  idis(ident, unr);
	  wlnuser(unr, hs);
	  hp = hp->next;
	}

	idis(ident, unr);
	wlnuser(unr,
		"---------------------------------------------------------");
	strcpy(w, "Total");
	rspacing(w, 6);
	strcpy(hs, w);
	sprintf(w, "%ld", ttu);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", ttb);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", tts);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", tbn);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", ttuh);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", ttbh);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", td);
	lspacing(w, 6);
	strcat(hs, w);
	sprintf(w, "%ld", ttsize);
	lspacing(w, 9);
	strcat(hs, w);
	idis(ident, unr);
	wlnuser(unr, hs);
      }

    }

    /* ---------------------------------------------------------------- */
  }


  get_word(eingabe, w1);

  if (readjust || (!strcmp(w1, "RESET") &&
		   (unr < 0 || boxrange(unr) && user[unr]->supervisor))) {
    get_word(eingabe, w);
    if (!strcmp(w, "ALL"))
      sfdelfile(bn);
    if (readjust || !strcmp(w, "ALL") || callsign(w)) {
      sprintf(xname, "%sM%c%s", indexdir, extsep, idx_e);
      lv = sfsize(xname) / sizeof(indexstruct);
      if (lv > 0) {
	list = sfopen(xname, FO_RW);
	if (list >= minhandle) {
	  for (k = 1; k <= lv; k++) {
	    read_index(list, k, &header);
	    if (check_hcs(header)) {
	      if (!header.deleted && header.size != 0) {
		convert_ufil(true, header, &rec);
		if (*rec.call != '\0') {
		  if (readjust) {
		    if (in_sfp(rec.call)) {
		      rec.dstat_rx_p = rec.sfstat_rx_p;
		      rec.dstat_rx_b = rec.sfstat_rx_b;
		      rec.dstat_rx_s = rec.sfstat_rx_s;
		      rec.dstat_rx_bytes = rec.srbytes;
		      rec.dstat_tx_p = rec.sfstat_tx_p;
		      rec.dstat_tx_b = rec.sfstat_tx_b;
		      rec.dstat_tx_s = rec.sfstat_tx_s;
		      rec.dstat_tx_bytes = rec.ssbytes;
		      rec.dlogins = rec.logins;
		      code_ufil(&rec, &header);
		      write_index(list, k, &header);
		      for (x = 1; x <= maxuser; x++) {
			if (user[x] != NULL) {
			  if (!strcmp(user[x]->call, rec.call)) {
			    user[x]->dstat_rx_p = rec.dstat_rx_p;

			    user[x]->dstat_rx_b = rec.dstat_rx_b;
			    user[x]->dstat_rx_s = rec.dstat_rx_s;
			    user[x]->dstat_rx_bytes = rec.dstat_rx_bytes;
			    user[x]->dstat_tx_p = rec.dstat_tx_p;
			    user[x]->dstat_tx_b = rec.dstat_tx_b;
			    user[x]->dstat_tx_s = rec.dstat_tx_s;
			    user[x]->dstat_tx_bytes = rec.dstat_tx_bytes;
			    user[x]->dlogins = rec.dlogins;
			  }
			}
		      }
		    }
		  } else if (!strcmp(w, "ALL") || !strcmp(rec.call, w)) {
		    rec.sfstat_tx_p = 0;
		    rec.sfstat_tx_b = 0;
		    rec.sfstat_tx_s = 0;
		    rec.ssbytes = 0;
		    rec.rbytes = 0;
		    rec.sbytes = 0;
		    rec.fstat_rx_p = 0;
		    rec.fstat_rx_b = 0;
		    rec.fstat_rx_s = 0;
		    rec.fstat_tx_p = 0;
		    rec.fstat_tx_b = 0;
		    rec.fstat_tx_s = 0;
		    rec.sfstat_rx_p = 0;
		    rec.sfstat_rx_b = 0;
		    rec.sfstat_rx_s = 0;
		    rec.srbytes = 0;
		    rec.logins = 0;

		    rec.dstat_rx_p = 0;
		    rec.dstat_rx_b = 0;
		    rec.dstat_rx_s = 0;
		    rec.dstat_rx_bytes = 0;
		    rec.dstat_tx_p = 0;
		    rec.dstat_tx_b = 0;
		    rec.dstat_tx_s = 0;
		    rec.dstat_tx_bytes = 0;
		    rec.dlogins = 0;

		    code_ufil(&rec, &header);
		    write_index(list, k, &header);
		    for (x = 1; x <= maxuser; x++) {
		      if (user[x] != NULL) {
			if (!strcmp(user[x]->call, rec.call)) {
			  user[x]->sfstat_tx_p = 0;
			  user[x]->sfstat_tx_b = 0;
			  user[x]->sfstat_tx_s = 0;
			  user[x]->ssbytes = 0;
			  user[x]->rbytes = 0;
			  user[x]->sbytes = 0;
			  user[x]->fstat_rx_p = 0;
			  user[x]->fstat_rx_b = 0;
			  user[x]->fstat_rx_s = 0;
			  user[x]->fstat_tx_p = 0;
			  user[x]->fstat_tx_b = 0;
			  user[x]->fstat_tx_s = 0;
			  user[x]->sfstat_rx_p = 0;
			  user[x]->sfstat_rx_b = 0;
			  user[x]->sfstat_rx_s = 0;
			  user[x]->srbytes = 0;
			  user[x]->logins = 0;

			  user[x]->dstat_rx_p = 0;
			  user[x]->dstat_rx_b = 0;
			  user[x]->dstat_rx_s = 0;
			  user[x]->dstat_rx_bytes = 0;
			  user[x]->dstat_tx_p = 0;
			  user[x]->dstat_tx_b = 0;
			  user[x]->dstat_tx_s = 0;
			  user[x]->dstat_tx_bytes = 0;
			  user[x]->dlogins = 0;
			}
		      }
		    }
		  }



		}

	      }
	    }
	  }
	  sfclose(&list);
	  init_ufcache();
	}
      }
    }
  } else if (!strcmp(w1, "+") || !strcmp(w1, "!")) {
    for (x = 1; x <= maxuser; x++) {
      if (user[x] != NULL && user[x]->f_bbs)
	save_userfile(user[x]);
    }

    ttu = 0;
    ttb = 0;
    tts = 0;
    ttsize = 0;
    rtu = 0;
    rtb = 0;
    rts = 0;
    rtsize = 0;
    tli = 0;
    urtsize = 0;
    uttsize = 0;
    utli = 0;

    tu = 0;
    urtsize2 = 0;
    uttsize2 = 0;
    utli2 = 0;

    xpuffer = NULL;

    if (unr > 0) {
      wlnuser0(unr);
      wlnuser0(unr);
      wlnuser0(unr);
      idis(ident, unr);
      wlnuser(unr, "       total of exchanged files since 00:00 UTC:");
      op(unr, &oh, "");
      op(unr, &oh,
	 "        -------- received from ---------   -------- transmitted to -------");
      op(unr, &oh,
	 "Call         P       B       S      Size       P       B       S      Size Conn");
      op(unr, &oh,
	 "-------------------------------------------------------------------------------");

      list = nohandle;
      sprintf(xname, "%sM%c%s", indexdir, extsep, idx_e);
      sfbread(false, xname, &xpuffer, &xsize);

      if (xsize <= 0) {
	lv = sfsize(xname) / sizeof(indexstruct);



      } else
	lv = xsize / sizeof(indexstruct);
      if (lv > 0) {
	hpointer = NULL;
	if (xsize <= 0) {
	  list = sfopen(xname, FO_READ);
	  hpointer = &header;   /* bleibt ja gleich */
	} else
	  list = nohandle;

	if (list >= minhandle || xsize > 0) {
	  for (k = 1; k <= lv; k++) {
	    if (k % 20 == 0)
	      dp_watchdog(2, 4711);

	    if (xsize <= 0)
	      read_index(list, k, &header);
	    else
	      hpointer = (indexstruct *)(&xpuffer[(k - 1) * sizeof(indexstruct)]);

	    if (check_hcs(*hpointer)) {
	      if (!hpointer->deleted && hpointer->size != 0) {
		convert_ufil(true, *hpointer, &rec);
		if (in_sfp(rec.call)) {
		  ttu += rec.sfstat_tx_p - rec.dstat_tx_p;
		  ttb += rec.sfstat_tx_b - rec.dstat_tx_b;
		  tts += rec.sfstat_tx_s - rec.dstat_tx_s;
		  ttsize += rec.ssbytes - rec.dstat_tx_bytes;
		  rtu += rec.sfstat_rx_p - rec.dstat_rx_p;
		  rtb += rec.sfstat_rx_b - rec.dstat_rx_b;
		  rts += rec.sfstat_rx_s - rec.dstat_rx_s;
		  rtsize += rec.srbytes - rec.dstat_rx_bytes;
		  tli += rec.logins - rec.dlogins;

		  strcpy(w, rec.call);
		  rspacing(w, 6);
		  strcpy(hs, w);
		  sprintf(w, "%ld", rec.sfstat_rx_p - rec.dstat_rx_p);
		  lspacing(w, 8);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.sfstat_rx_b - rec.dstat_rx_b);
		  lspacing(w, 8);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.sfstat_rx_s - rec.dstat_rx_s);
		  lspacing(w, 8);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.srbytes - rec.dstat_rx_bytes);
		  lspacing(w, 10);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.sfstat_tx_p - rec.dstat_tx_p);
		  lspacing(w, 8);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.sfstat_tx_b - rec.dstat_tx_b);
		  lspacing(w, 8);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.sfstat_tx_s - rec.dstat_tx_s);
		  lspacing(w, 8);
		  strcat(hs, w);
		  sprintf(w, "%ld", rec.ssbytes - rec.dstat_tx_bytes);
		  lspacing(w, 10);
		  strcat(hs, w);
		  if (rec.logins - rec.dlogins > 9999)
		    strcpy(w, ">>>>");
		  else
		    sprintf(w, "%ld", rec.logins - rec.dlogins);
		  lspacing(w, 5);
		  strcat(hs, w);
		  op(unr, &oh, hs);
		}


	      }
	    }
	  }

	} else
	  op(unr, &oh, "read error");
      }


      sfclose(&list);

      op(unr, &oh,
	 "-------------------------------------------------------------------------------");
      strcpy(w, "Total");
      rspacing(w, 6);
      strcpy(hs, w);
      sprintf(w, "%ld", rtu);
      lspacing(w, 8);
      strcat(hs, w);
      sprintf(w, "%ld", rtb);
      lspacing(w, 8);
      strcat(hs, w);
      sprintf(w, "%ld", rts);
      lspacing(w, 8);
      strcat(hs, w);
      sprintf(w, "%ld", rtsize);
      lspacing(w, 10);
      strcat(hs, w);
      sprintf(w, "%ld", ttu);
      lspacing(w, 8);
      strcat(hs, w);
      sprintf(w, "%ld", ttb);
      lspacing(w, 8);
      strcat(hs, w);
      sprintf(w, "%ld", tts);
      lspacing(w, 8);

      strcat(hs, w);
      sprintf(w, "%ld", ttsize);
      lspacing(w, 10);
      strcat(hs, w);
      if (tli > 9999)
	strcpy(w, ">>>>");
      else
	sprintf(w, "%ld", tli);
      lspacing(w, 5);
      strcat(hs, w);

      op(unr, &oh, hs);

      wlnuser0(unr);
      wlnuser0(unr);
      wlnuser0(unr);
      idis(ident, unr);

      wlnuser(unr, "         total of exchanged files this month:");
    } else {
      sprintf(STR1, "%sSFSTAT", tempdir);
      oh = sfcreate(STR1, FC_FILE);
      if (oh < minhandle)
	goto _L1;
      string_to_file(&oh,
	"                 total of exchanged files during the last month:",
	true);
    }

    op(unr, &oh, "");
    if (unr <= 0) {
      op(unr, &oh,
	 "                 P = Usermails  B = Bulletins  S = System-Mails");
      op(unr, &oh, "");
    }
    op(unr, &oh,
       "        -------- received from ---------   -------- transmitted to -------");
    op(unr, &oh,
      "Call         P       B       S      Size       P       B       S      Size Conn");
    op(unr, &oh,
      "-------------------------------------------------------------------------------");

    ttu = 0;
    ttb = 0;
    tts = 0;
    ttsize = 0;
    rtu = 0;
    rtb = 0;
    rts = 0;
    rtsize = 0;
    tli = 0;

    list = nohandle;
    sprintf(xname, "%sM%c%s", indexdir, extsep, idx_e);
    if (xpuffer == NULL)
      sfbread(false, xname, &xpuffer, &xsize);

    if (xsize <= 0)
      lv = sfsize(xname) / sizeof(indexstruct);
    else
      lv = xsize / sizeof(indexstruct);
    if (lv > 0) {
      hpointer = NULL;
      if (xsize <= 0) {
	list = sfopen(xname, FO_READ);
	hpointer = &header;   /* bleibt ja gleich */
      } else
	list = nohandle;

      if (list >= minhandle || xsize > 0) {
	for (k = 1; k <= lv; k++) {
	  if (k % 20 == 0)
	    dp_watchdog(2, 4711);

	  if (xsize <= 0)
	    read_index(list, k, &header);
	  else
	    hpointer = (indexstruct *)(&xpuffer[(k - 1) * sizeof(indexstruct)]);

	  if (check_hcs(*hpointer)) {
	    if (!hpointer->deleted && hpointer->size != 0) {
	      convert_ufil(false, *hpointer, &rec);
	      if (in_sfp(rec.call)) {
		ttu += rec.sfstat_tx_p;
		ttb += rec.sfstat_tx_b;
		tts += rec.sfstat_tx_s;
		ttsize += rec.ssbytes;
		rtu += rec.sfstat_rx_p;
		rtb += rec.sfstat_rx_b;
		rts += rec.sfstat_rx_s;
		rtsize += rec.srbytes;
		tli += rec.logins;
		uttsize2 += rec.sssbytes;
		urtsize2 += rec.ssrbytes;
		if (urtsize2 < 0 || uttsize2 < 0)
		  ttofl = true;
		utli2 += rec.sslogins;

		strcpy(w, rec.call);
		rspacing(w, 6);
		strcpy(hs, w);
		sprintf(w, "%ld", rec.sfstat_rx_p);
		lspacing(w, 8);
		strcat(hs, w);
		sprintf(w, "%ld", rec.sfstat_rx_b);
		lspacing(w, 8);
		strcat(hs, w);
		sprintf(w, "%ld", rec.sfstat_rx_s);
		lspacing(w, 8);
		strcat(hs, w);
		sprintf(w, "%ld", rec.srbytes);
		lspacing(w, 10);
		strcat(hs, w);
		sprintf(w, "%ld", rec.sfstat_tx_p);
		lspacing(w, 8);
		strcat(hs, w);
		sprintf(w, "%ld", rec.sfstat_tx_b);
		lspacing(w, 8);
		strcat(hs, w);
		sprintf(w, "%ld", rec.sfstat_tx_s);
		lspacing(w, 8);
		strcat(hs, w);
		sprintf(w, "%ld", rec.ssbytes);
		lspacing(w, 10);
		strcat(hs, w);
		if (rec.logins > 9999)
		  strcpy(w, ">>>>");
		else
		  sprintf(w, "%ld", rec.logins);
		lspacing(w, 5);
		strcat(hs, w);
		op(unr, &oh, hs);
	      } else {
		uttsize += rec.ssbytes;
		urtsize += rec.srbytes;
		utli += rec.logins;
		uttsize2 += rec.sssbytes;
		urtsize2 += rec.ssrbytes;
		if (urtsize2 < 0 || uttsize2 < 0)
		  ttofl = true;
		utli2 += rec.sslogins;
		if (rec.logins > 0)
		  tu++;
	      }

	    }
	  }
	}

      } else
	op(unr, &oh, "read error");
    }


    sfclose(&list);
    if (xpuffer != NULL)
      mymfreep(&xpuffer);


    op(unr, &oh,
      "-------------------------------------------------------------------------------");
    strcpy(w, "Total");
    rspacing(w, 6);
    strcpy(hs, w);
    sprintf(w, "%ld", rtu);
    lspacing(w, 8);
    strcat(hs, w);
    sprintf(w, "%ld", rtb);
    lspacing(w, 8);
    strcat(hs, w);
    sprintf(w, "%ld", rts);
    lspacing(w, 8);
    strcat(hs, w);
    sprintf(w, "%ld", rtsize);
    lspacing(w, 10);
    strcat(hs, w);
    sprintf(w, "%ld", ttu);
    lspacing(w, 8);
    strcat(hs, w);
    sprintf(w, "%ld", ttb);
    lspacing(w, 8);
    strcat(hs, w);
    sprintf(w, "%ld", tts);
    lspacing(w, 8);
    strcat(hs, w);
    sprintf(w, "%ld", ttsize);
    lspacing(w, 10);
    strcat(hs, w);
    if (tli > 9999) {
      strcpy(w, ">>>>");

    } else
      sprintf(w, "%ld", tli);
    lspacing(w, 5);
    strcat(hs, w);
    op(unr, &oh, hs);
    rtu += rtb + rts;
    ttu += ttb + tts;
    ttb = rtu + ttu;
    ttsize += rtsize;

    if (!strcmp(w1, "!")) {
      op(unr, &oh, "");
      op(unr, &oh, "");
      op(unr, &oh, "forward this month:");

      op(unr, &oh, "-------------------------------------");
      sprintf(w, "%ld", tli);
      lspacing(w, 11);
      sprintf(STR1, "Total connects in s&f   : %s", w);
      op(unr, &oh, STR1);
      sprintf(w, "%ld", rtu);
      lspacing(w, 11);
      sprintf(STR1, "Total received files    : %s", w);
      op(unr, &oh, STR1);

      sprintf(w, "%ld", ttu);
      lspacing(w, 11);
      sprintf(STR1, "Total transmitted files : %s", w);
      op(unr, &oh, STR1);
      sprintf(w, "%ld", ttb);
      lspacing(w, 11);
      sprintf(STR1, "Total exchanged files   : %s", w);
      op(unr, &oh, STR1);
      sprintf(w, "%ld", ttsize);
      lspacing(w, 11);
      sprintf(STR1, "Total exchanged bytes   : %s", w);
      op(unr, &oh, STR1);
      op(unr, &oh, "-------------------------------------");

      op(unr, &oh, "");
      op(unr, &oh, "users this month:");
      op(unr, &oh, "-------------------------------------");
      sprintf(w, "%ld", urtsize);
      lspacing(w, 11);
      sprintf(STR1, "Total rx from users     : %s", w);
      op(unr, &oh, STR1);
      sprintf(w, "%ld", uttsize);
      lspacing(w, 11);
      sprintf(STR1, "Total tx to users       : %s", w);
      op(unr, &oh, STR1);
      sprintf(w, "%ld", utli);
      lspacing(w, 11);
      sprintf(STR1, "Total logins of users   : %s", w);
      op(unr, &oh, STR1);
      sprintf(w, "%ld", tu);
      lspacing(w, 11);
      sprintf(STR1, "Total count of users    : %s", w);
      op(unr, &oh, STR1);
      op(unr, &oh, "-------------------------------------");

      op(unr, &oh, "");
      op(unr, &oh, "users and forward:");
      op(unr, &oh, "-------------------------------------");
      if (!ttofl) {
	sprintf(w, "%ld", urtsize2);
	lspacing(w, 11);
	sprintf(STR1, "Total rx since install. : %s", w);
	op(unr, &oh, STR1);
	sprintf(w, "%ld", uttsize2);
	lspacing(w, 11);
	sprintf(STR1, "Total tx since install. : %s", w);
	op(unr, &oh, STR1);
      }
      sprintf(w, "%ld", utli2);
      lspacing(w, 11);
      sprintf(STR1, "Total logins since ever : %s", w);
      op(unr, &oh, STR1);
      op(unr, &oh, "-------------------------------------");

      if (exist(bn)) {
	bf = sfopen(bn, FO_READ);
	op(unr, &oh, "");
	op(unr, &oh, "broadcast this month:");
	op(unr, &oh, "-------------------------------------");
	strcpy(w, "0");
	file_to_string(bf, w);
	lspacing(w, 11);
	sprintf(STR1, "Total transmitted bytes : %s", w);
	op(unr, &oh, STR1);
	strcpy(w, "0");
	file_to_string(bf, w);
	sfclose(&bf);
	lspacing(w, 11);
	sprintf(STR1, "Total transmitted files : %s", w);
	op(unr, &oh, STR1);
	op(unr, &oh, "-------------------------------------");
      }

      if (unr < 0)
	sfclose(&oh);
    }

  }


  /*alle pointer freigeben*/
_L1:
  hp = st;
  while (hp != NULL) {
    hp1 = hp;
    hp = hp1->next;
    Free(hp1);
  }

}


void generate_sfstat(short unr)
{
  Char STR1[81];
  Char STR2[256];

  create_sfstat(unr, "!");
  if (unr >= 0)
    return;
  sprintf(STR1, "monthly s&f-statistics of %s", Console_call);
  sprintf(STR2, "&%sSFSTAT", tempdir);
  send_sysmsg("STATISTI", Console_call, STR1, STR2, 0);
  create_sfstat(-1, "RESET ALL");
  sprintf(STR2, "&%sSFSTAT", tempdir);
  sfdelfile(STR2);
}


void readjust_dayly_sfcount(void)
{
  create_sfstat(-1, "-");
}


void do_config(short unr, Char *filename, Char *eingabe_)
{
  Char eingabe[256];
  Char key[256], zeile[256], replace[256], fn[256];
  Char STR1[256], STR7[256];

  strcpy(eingabe, eingabe_);
  get_word(eingabe, key);

  if (*key == '\0') {
    wlnuser(unr, "Usage: CONFIG <Filename> <Keyword> [<Replacement>]");
    wlnuser(unr, "       <Keyword> is the first word of a line");
    wlnuser(unr, "       if <Replacement> is <-d>, line will be deleted");
    wlnuser(unr, "       if no <Replacement> was added nothing will be changed");
    wlnuser(unr, "       <Filename> is automatically expanded to system/ or sf/");
    return;
  }

  strcpy(fn, filename);
  strdelete((void *)fn, 1, strlen(boxdir));
  sprintf(fn, "File: %s", strcpy(STR1, fn));
  wlnuser(unr, fn);
  wlnuser0(unr);
  upper(key);
  strcpy(replace, eingabe);
  if (get_keyline(filename, key, false, zeile)) {
    wlnuser(unr, "Key found:");
    wlnuser(unr, zeile);
  } else
    wlnuser(unr, "Key not found");

  if (*replace == '\0')
    return;
  wlnuser0(unr);
  if (strcmp(replace, "-"))
    sprintf(replace, "%s %s", key, strcpy(STR7, replace));
  else
    *replace = '\0';
  if (!replace_keyline(filename, key, false, replace)) {
    wlnuser(unr, "now added");
    return;
  }

  if (*replace == '\0')
    wlnuser(unr, "line deleted");
  else {
    wlnuser(unr, "added/changed:");
    wlnuser(unr, replace);
  }
}


void do_stripcr(short unr, Char *filename)
{
  Char fn[256];
  Char STR1[256];

  if (*filename == '\0') {
    wlnuser(unr, "Usage: STRIPCR <Filename>");
    wlnuser(unr,
	    "       <Filename> is automatically expanded to system/ or sf/");
    return;
  }

  strcpy(fn, filename);

  strdelete((void *)fn, 1, strlen(boxdir));
  sprintf(fn, "File: %s", strcpy(STR1, fn));
  wlnuser(unr, fn);
  wlnuser0(unr);
  stripcr(filename);
  wlnuser(unr, "OK, stripped <CR>");
}


void _box_sys_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  chmbxsemaphore = false;
  lastrunnum = 0;

}
