/* Output from p2c, the Pascal-to-C translator */
/* From input file "boxfserv.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/

/* Der Fileserver */


#include "defs.h"


#ifndef DPGLOBAL_H
#include "dpglobal.h"
#endif

#ifndef BOXGLOBL_H
#include "boxglobl.h"
#endif

#ifndef PASTRIX_H
#include "pastrix.h"
#endif

#define BOXFSERV_G
#include "boxfserv.h"

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif


Static void get_options(Char *eingabe, Char *options)
{
  Char w[256];

  *options = '\0';
  while (*eingabe != '\0' && eingabe[0] == '-') {
    get_word(eingabe, w);
    sprintf(options + strlen(options), "%s ", w);
  }
}


Static boolean expand_path(short unr, Char *path)
{
  boolean Result;
  Char w[256];
  Char STR1[256];

  Result = false;

  get_word(path, w);
  strcpy(path, w);

  if (insecure(path))
    return Result;

  if (*path == '\0' || path[0] != '/')
    sprintf(path, "%s%s", user[unr]->spath, strcpy(STR1, path));
  strdelete((void *)path, 1, 1);
  sprintf(path, "%s%s", fservdir, strcpy(STR1, path));
  return true;
}


Static short call_7plus(boolean priv, short unr, Char *fn, Char *options,
			Char *original1)
{
  short k, Result;
  boolean first;
  long pid, tct;
  unsigned short date, time;
  Char hs[256], sd[256], ld[256], ofi[256], w[256], bd[256];
  Char original[256], splockfile[256];

  Result = -1;
  if (*spluspath == '\0')
    return Result;

  Result = 0;
  pid = fork();
  if (pid > 0) {
    add_zombie(pid);
    return Result;
  }
  setsid();
  
  strcpy(splockfile, boxstatdir);
  strcat(splockfile, "7plock.box");
  
  first = true;
  tct = clock_.ixtime;
  do {
    if (!first)
      sleep(1);
    utc_clock;
    first = false;
  }
  while ((clock_.ixtime - tct < 120) && (exist(splockfile)));
  
  k = sfcreate(splockfile, FC_FILE);
  sfclose(&k);
  
  sprintf(hs, "%s %s", fn, options);
  del_lastblanks(hs);
  if (priv) {
    sprintf(sd, "%s%stemp7pl%c", boxdir, pservdir, dirsep);
    sprintf(bd, "%s%s", boxdir, pservdir);
  } else {
    sprintf(sd, "%s%stemp7pl%c", boxdir, fservdir, dirsep);
    sprintf(bd, "%s%snewbin%c", boxdir, fservdir, dirsep);
  }
  sprintf(ofi, "%s7plus.out", sd);
  sfgetdir(0, ld);
  sfchdir(sd);
  call_prg(spluspath, hs, "");
  sfchdir(ld);

  sfdelfile(splockfile);
  sfdelfile(ofi);
  if (exist(original1)) {
    get_ext(original1, w);
    upper(w);
    if (!strcmp(w, "COR") || !strcmp(w, "ERR")) {
      if (pid == 0)
	exit(0);
      else
	return Result;
    }
    ix2dostime(clock_.ixtime, &date, &time);
    sfsetdatime(original1, &date, &time);
	/* 7plus setzt selber das Originaldatum */
    strcpy(original, original1);
    del_path(original);
    *ofi = '\0';
    *ld = '\0';

    sprintf(ld, "%s%s", sd, original);
    sprintf(ofi, "%s%s", bd, original);
    sfrename(ld, ofi);
    sfdelfile(ld);

    new_ext(ld, "7mf");
    sfdelfile(ld);
    new_ext(ld, "7ix");
    sfdelfile(ld);

    new_ext(ld, "inf");
    new_ext(ofi, "inf");
    sfrename(ld, ofi);
    sfdelfile(ld);
    sprintf(ld, "%s.%s", sd, original);
    sprintf(ofi, "%s.%s", bd, original);
    sfrename(ld, ofi);
    sfdelfile(ld);
  }

  if (pid == 0)
    exit(0);
  return Result;
}


Static boolean expand_number(short unr, Char *fn)
{
  boolean Result;
  short nr;
  Char hs[256], s[256];
  Char STR7[256];
  void (*TEMP)(short unr, Char *s);

  Result = false;
  if (!boxrange(unr))
    return Result;
  if (!zahl(fn))
    return Result;
  strcpy(hs, fn);
  nr = Str2int(hs);
  if (nr <= 0)
    return Result;
  sprintf(s, "%ld", nr);
  sprintf(s, "-C%s -DATE", strcpy(STR7, s));
  *hs = '\0';
  if (!expand_path(unr, hs))
    return Result;
  sprintf(hs, "%s%s", boxdir, strcpy(STR7, hs));
  sprintf(hs + strlen(hs), "%c%c%c", allquant, extsep, allquant);
  TEMP = wlnuser;
  file_dir(user[unr]->supervisor, hs, s, unr, TEMP);
  if (*hs == '\0')
    return Result;
  strcpy(fn, hs);
  return true;
}


Static void create_dir(short unr, Char *eingabe_)
{
  Char eingabe[256];
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  if (!user[unr]->se_ok) {
    wln_btext(unr, 65);
    return;
  }

  if (!expand_path(unr, eingabe))
    return;

  sprintf(eingabe, "%s%s", boxdir, strcpy(STR1, eingabe));
  if (sfmakedir(eingabe) < 0)
    wlnuser(unr, "failed");
}


Static void remove_dir(short unr, Char *eingabe_)
{
  Char eingabe[256];
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  if (!user[unr]->se_ok) {
    wln_btext(unr, 65);
    return;
  }

  if (!expand_path(unr, eingabe))
    return;
  sprintf(eingabe, "%s%s", boxdir, strcpy(STR1, eingabe));
  if (sfremovedir(eingabe) < 0)
    wlnuser(unr, "failed");
}


Static void remove_file(short unr, Char *eingabe_)
{
  Char eingabe[256];
  short x, y;
  Char options[256], p[256];
  void (*TEMP)(short unr, Char *s);
  void (*TEMP1)(short unr, Char *s);

  strcpy(eingabe, eingabe_);
  if (!user[unr]->se_ok) {
    wln_btext(unr, 65);
    return;
  }

  get_options(eingabe, options);
  upper(options);
  expand_number(unr, eingabe);
  if (!expand_path(unr, eingabe))
    return;

  strcpy(p, eingabe);

  if (strpos2(options, "-Q", 1) > 0)
    x = -1;
  else
    x = unr;
  TEMP = wlnuser;
  file_delete(x, eingabe, TEMP);

  y = strlen(p);
  while (y > 1 && p[y - 1] != dirsep)
    y--;
  if (p[y] == '.')
    return;
  strinsert(".", (void *)p, y + 1);
  TEMP1 = wlnuser;
  file_delete(x, p, TEMP1);
}


Static void show_shelp(short unr)
{
  short x;

  wln_btext(unr, 150);
  wlnuser0(unr);
  for (x = 151; x <= 160; x++)
    wln_btext(unr, x);
  wlnuser0(unr);
  for (x = 161; x <= 170; x++)
    wln_btext(unr, x);
  wlnuser0(unr);
  for (x = 171; x <= 174; x++)
    wln_btext(unr, x);

  if (!user[unr]->supervisor)
    return;
  wlnuser0(unr);
  wln_btext(unr, 175);
  wlnuser0(unr);
  for (x = 176; x <= 181; x++)
    wln_btext(unr, x);
}


Static void copy_file(short unr, Char *eingabe_, boolean del_src)
{
  Char eingabe[256];
  short y, u, ret;
  Char options[256], arg1[256], arg2[256];
  Char root[256];
  Char STR1[256];
  void (*TEMP)(short unr, Char *s);
  void (*TEMP1)(short unr, Char *s);

  strcpy(eingabe, eingabe_);
  get_options(eingabe, options);
  upper(options);

  get_word(eingabe, arg1);
  get_word(eingabe, arg2);

  expand_number(unr, arg1);

  if (!strcmp(arg2, "."))
    *arg2 = '\0';

  if (!expand_path(unr, arg1) || !expand_path(unr, arg2))
    return;
  sprintf(arg1, "%s%s", boxdir, strcpy(STR1, arg1));
  sprintf(arg2, "%s%s", boxdir, strcpy(STR1, arg2));
  sprintf(root, "%s%s", boxdir, fservdir);
  if (strpos2(options, "-Q", 1) > 0)
    u = -1;
  else
    u = unr;

  TEMP = wlnuser;
  ret = filecp(arg1, arg2, root, del_src, u, TEMP);

  if (ret < 0) {
    wlnuser(unr, "failed");
    return;
  }

  y = strlen(arg1);
  while (y > 1 && arg1[y - 1] != dirsep)
    y--;
  if (arg1[y] == '.')
    return;
  strinsert(".", (void *)arg1, y + 1);

  if (ret != 1) {  /* arg2 was no directory */
    y = strlen(arg2);
    while (y > 1 && arg2[y - 1] != dirsep)
      y--;
    if (arg2[y] == '.')
      return;
    strinsert(".", (void *)arg2, y + 1);
  }

  TEMP1 = wlnuser;
  filecp(arg1, arg2, root, del_src, u, TEMP1);
}


Static void put_file2(short unr, Char *eingabe, short mode);


Static void add_ascii(short unr, Char *eingabe, boolean return_)
{
  Char hs[256], w[256];
  short x, ctrl_z;

  if (user[unr]->sendchan < minhandle) {
    user[unr]->action = 0;
    return;
  }
  ctrl_z = strpos2(eingabe, "\032", 1);
  if (ctrl_z > 0 || user[unr]->isfirstchar && return_ && !strcmp(eingabe, ".")) {
    if (*user[unr]->input2 != '\0') {
      string_to_file(&user[unr]->sendchan, user[unr]->input2, true);
      *user[unr]->input2 = '\0';
    }
    if (ctrl_z > 1) {
      cut(eingabe, ctrl_z - 1);
      string_to_file(&user[unr]->sendchan, eingabe, true);
    }
    if (sfseek(0, user[unr]->sendchan, SFSEEKEND) <= 0) {
      sfclosedel(&user[unr]->sendchan);
      wln_btext(unr, 11);
    } else {
      sfclose(&user[unr]->sendchan);
      wlnuser0(unr);
    }
    if (user[unr]->action != 94) {
      user[unr]->action = 0;
      wln_btext(unr, 6);
      return;
    }
    user[unr]->action = 0;
    wlnuser0(unr);
    put_file2(unr, user[unr]->sfilname, user[unr]->paging);
    return;
  }
  if (user[unr]->action != 95 && user[unr]->action != 94) {
    string_to_file(&user[unr]->sendchan, eingabe, return_);
    return;
  }
  del_leadblanks(eingabe);
  del_lastblanks(eingabe);
  del_mulblanks(eingabe);
  if (strlen(eingabe) + strlen(user[unr]->input2) >= 255) {
    string_to_file(&user[unr]->sendchan, user[unr]->input2, true);
    *user[unr]->input2 = '\0';
  }
  sprintf(hs, "%s%s", user[unr]->input2, eingabe);
  if (return_)
    strcat(hs, " ");
  while (strlen(hs) > 72) {
    x = 72;
    while (x > 1 && hs[x - 1] != ' ')
      x--;
    if (x == 1)
      x = 72;
    sprintf(w, "%.*s", x, hs);
    strdelete((void *)hs, 1, x);
    string_to_file(&user[unr]->sendchan, w, true);
  }
  strcpy(user[unr]->input2, hs);
}


Static void put_file2(short unr, Char *eingabe_, short mode)
{
  Char eingabe[256];
  Char fn[256], hs[256];
  short k;
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  if (!user[unr]->se_ok) {
    wln_btext(unr, 65);
    return;
  }

  get_word(eingabe, fn);

  if (*fn == '\0')
    return;
  if (!expand_path(unr, fn))
    return;

  if (!user[unr]->supervisor && strpos2(fn, "/incoming/", 1) == 0) {
    wln_btext(unr, 96);
    return;
  }

  strcpy(hs, fn);
  sprintf(hs, "%s%s", boxdir, strcpy(STR1, hs));
  if (exist(hs)) {
    wln_btext(unr, 97);
    return;
  }

  if (mode == 0) {  /* ascii */
    k = sfcreate(hs, FC_FILE);
    if (k < minhandle) {
      wln_btext(unr, 98);
      return;
    }
    wln_btext(unr, 99);
    user[unr]->sendchan = k;
    user[unr]->action = 92;
    return;
  }

  if (mode == 2)
    strcat(fn, " -Y");
  write_file(unr, fn);
}


Static void put_file(short unr, Char *eingabe_, short mode)
{
  Char eingabe[256];
  Char fn[256], hs[256], inp[256];
  short k, x;
  boolean is_upl, is_index;
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  if (!user[unr]->se_ok) {
    wln_btext(unr, 65);
    return;
  }

  strcpy(inp, eingabe);

  get_word(eingabe, fn);
  if (*fn == '\0')
    return;
  if (!expand_path(unr, fn))
    return;


  if (!user[unr]->supervisor && strpos2(fn, "/incoming/", 1) == 0) {
    wln_btext(unr, 96);
    return;
  }

  is_upl = false;
  is_index = false;
  strcpy(hs, fn);
  sprintf(hs, "%s%s", boxdir, strcpy(STR1, hs));
  if (exist(hs)) {
    if (!user[unr]->supervisor) {
      wln_btext(unr, 97);
      return;
    }
    sfdelfile(hs);
  }

  strcpy(fn, hs);
  del_path(fn);
  if (fn[0] == '.') {
    if (!user[unr]->supervisor) {
      wln_btext(unr, 100);
      return;
    }
    sfdelfile(hs);
    is_upl = (strcmp(fn, ".index") != 0);
    is_index = !is_upl;
  }
  x = strlen(hs);
  while (x > 1 && hs[x - 1] != dirsep)
    x--;
  if (hs[x] != '.')
    strinsert(".", (void *)hs, x + 1);

  if (is_index || exist(hs)) {
    put_file2(unr, inp, mode);
    return;
  }



  k = sfcreate(hs, FC_FILE);
  if (k < minhandle) {
    wln_btext(unr, 98);
    return;
  }

  wln_btext(unr, 101);
  strcpy(user[unr]->sfilname, inp);
  *user[unr]->input2 = '\0';
  user[unr]->paging = mode;
  user[unr]->sendchan = k;
  if (is_upl) {
    user[unr]->action = 95;
    return;
  }
  user[unr]->action = 94;
  if (!is_index) {
    sprintf(hs, "%s:", user[unr]->call);
    add_ascii(unr, hs, true);
  }

}


Static void page_file(short unr, Char *eingabe)
{
  short k;
  boolean abo;
  Char hs[256];

  k = nohandle;
  abo = (*eingabe != '\0' && upcase_(eingabe[0]) == 'C');



  if (!abo)
    k = sfopen(user[unr]->sfilname, FO_READ);

  if (abo || k < minhandle) {
    user[unr]->sseekp = 0;
    user[unr]->pagcount = 0;
    user[unr]->paging = 0;
    *user[unr]->sfilname = '\0';
    user[unr]->action = 0;
    if (!abo)
      wlnuser(unr, "read error");
  }

  sfseek(user[unr]->sseekp, k, SFSEEKSET);

  while (file_to_string(k, hs)) {
    wlnuser(unr, hs);
    user[unr]->pagcount++;
    if (user[unr]->pagcount < user[unr]->paging)
      continue;
    user[unr]->sseekp = sfseek(0, k, SFSEEKCUR);
    sfclose(&k);
    user[unr]->pagcount = 0;
    wln_btext(unr, 102);
    return;
  }

  sfclose(&k);
  user[unr]->sseekp = 0;
  user[unr]->pagcount = 0;
  user[unr]->paging = 0;

  *user[unr]->sfilname = '\0';
  user[unr]->action = 0;
}


Static void get_file(short unr, Char *eingabe_, short mode, boolean paging)
{
  Char eingabe[256];
  Char fn[256], hs[256], s[256];
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  if (!user[unr]->supervisor) {
    if ((user[unr]->maxread_day == 0 &&
	 all_maxread_day <= user[unr]->read_today) ||
	(user[unr]->maxread_day != 0 &&
	 user[unr]->maxread_day <= user[unr]->read_today)) {
      signalise_readlimit(unr, true, 0, "", 0, 0);
      return;
    }

  }

  get_word(eingabe, fn);
  expand_number(unr, fn);
  if (*fn == '\0')
    return;
  if (!expand_path(unr, fn))
    return;

  sprintf(hs, "%s%s", boxdir, fn);

  if (!user[unr]->supervisor &&
      uspos((sprintf(STR1, "%s%stemp7pl%c", boxdir, fservdir, dirsep), STR1),
	    hs) == 1) {
    wln_btext(unr, 7);
    return;
  }

  strcpy(s, fn);
  del_path(s);
  if (!user[unr]->supervisor && s[0] == '.') {
    wln_btext(unr, 7);
    return;
  }

  if (!user[unr]->supervisor)
    add_readday(unr, sfsize(hs));

  if (paging && mode == 0) {
    user[unr]->sseekp = 0;
    user[unr]->pagcount = 0;
    user[unr]->paging = 24;
    strcpy(user[unr]->sfilname, hs);
    user[unr]->action = 93;
    page_file(unr, "");
    return;
  }

  switch (mode) {

  case 0:   /* ascii     */
    strcat(fn, " -a");
    break;

  case 1:   /* autobin   */
    break;

  case 2:   /* yapp      */
    strcat(fn, " -y");
    break;
    
  default:
    return;
    break;
  }

  if (read_file(false, unr, fn)) {
    if (read_filepart(unr))
      user[unr]->action = 96;
  }

}


Static void show_dir(short unr, Char *eingabe_)
{
  Char eingabe[256];
  Char options[256];
  Char STR1[256];
  void (*TEMP)(short unr, Char *s);

  strcpy(eingabe, eingabe_);
  get_options(eingabe, options);
  upper(options);

  if (!expand_path(unr, eingabe)) {
    wln_btext(unr, 2);
    return;
  }

  sprintf(eingabe, "%s%s", boxdir, strcpy(STR1, eingabe));

  if (!user[unr]->supervisor &&
      uspos((sprintf(STR1, "%s%stemp7pl%c", boxdir, fservdir, dirsep), STR1),
	    eingabe) == 1) {
    wln_btext(unr, 7);
    return;
  }

  if (eingabe[strlen(eingabe) - 1] == dirsep)
    sprintf(eingabe + strlen(eingabe), "%c%c%c", allquant, extsep, allquant);

  if (strpos2(options, "-X", 1) > 0)
    strcat(options, " -DATE");

  if (user[unr]->changed_dir) {
    user[unr]->changed_dir = false;
    strcat(options, " -I");
  }

  TEMP = wlnuser;
  file_dir(user[unr]->supervisor, eingabe, options, unr, TEMP);
}


Static void change_spath(short unr, Char *eingabe)
{
  short x, y;
  Char oldp[256], newp[256];
  DTA dirinfo;
  userstruct *WITH;
  Char STR1[256], STR7[256];

  if (*eingabe == '\0')
    return;

  WITH = user[unr];
  if (strcmp(eingabe, "..") && insecure(eingabe))
    return;
  strcpy(oldp, WITH->spath);
  if (!strcmp(eingabe, "."))
    return;
  if (!strcmp(eingabe, "./"))
    return;
  if (!strcmp(eingabe, "..")) {
    y = strlen(WITH->spath);
    x = y - 1;
    while (x > 1 && WITH->spath[x - 1] != '/')
      x--;
    if (x < 1)
      x = 1;
    strdelete((void *)WITH->spath, x, y - x + 1);
  } else if (eingabe[0] == '/')
    strcpy(WITH->spath, eingabe);
  else if (strlen(eingabe) + strlen(WITH->spath) < 254)
    strcat(WITH->spath, eingabe);
  if (WITH->spath[strlen(WITH->spath) - 1] != '/')
    strcat(WITH->spath, "/");
  if (WITH->spath[0] != '/') {
    sprintf(STR1, "/%s", WITH->spath);
    strcpy(WITH->spath, STR1);
  }
  strcpy(newp, WITH->spath);
  strdelete((void *)newp, 1, 1);
  sprintf(newp, "%s%s%s", boxdir, fservdir, strcpy(STR7, newp));
  strdelete((void *)newp, strlen(newp), 1);
  x = sffirst(newp, 16, &dirinfo);
  if (x == 0 && dirinfo.d_attrib == 16) {
    WITH->changed_dir = true;
    return;
  }
  get_btext(unr, 103, newp);
  sprintf(newp, "%s: %s", WITH->spath, strcpy(STR1, newp));
  wlnuser(unr, newp);
  strcpy(WITH->spath, oldp);
}


void analyse_smode_command(short unr, Char *eingabe, boolean return_)
{
  boolean onlysys;
  short cnr;
  Char w[256];
  userstruct *WITH;
  Char STR1[256];

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  switch (WITH->action) {

  case 0:
    if (*eingabe != '\0')
      strcpy(WITH->lastcmd, eingabe);

    if (create_syslog && WITH->supervisor)
      append_syslog(unr);
    else if (create_userlog && !WITH->supervisor)
      append_userlog(unr);
    if (in_protocalls(WITH->call))
      append_protolog(unr);

    wlnuser0(unr);
    get_word(eingabe, w);
    upper(w);
    del_blanks(eingabe);

    if (compare(w, "HELP") || compare(w, "? "))
      show_shelp(unr);
    else if (compare(w, "TYPE"))
      get_file(unr, eingabe, 0, true);
    else if (compare(w, "CAT") || compare(w, "GET") || compare(w, "READ"))
      get_file(unr, eingabe, 0, false);
    else if (compare(w, "BGET"))
      get_file(unr, eingabe, 1, false);
    else if (compare(w, "YGET"))
      get_file(unr, eingabe, 2, false);
    else if (compare(w, "CD"))
      change_spath(unr, eingabe);
    else if (compare(w, "CD..")) /*typische Fehleingabe*/
      change_spath(unr, "..");
    else if (compare(w, "LIST")) {
      if (strlen(eingabe) < 250)
	sprintf(eingabe, "-X %s", strcpy(STR1, eingabe));
      show_dir(unr, eingabe);
    } else if (compare(w, "LS"))
      show_dir(unr, eingabe);
    else if (compare(w, "DIR")) {
      if (strlen(eingabe) < 250)
	sprintf(eingabe, "-L %s", strcpy(STR1, eingabe));
      show_dir(unr, eingabe);
    } else if (compare(w, "PUT") || compare(w, "WRITE"))
      put_file(unr, eingabe, 0);
    else if (compare(w, "BPUT"))
      put_file(unr, eingabe, 1);
    else if (compare(w, "YPUT"))
      put_file(unr, eingabe, 2);
    else if (WITH->supervisor) {
      if (compare(w, "MKDIR") || compare(w, "MD"))
	create_dir(unr, eingabe);
      else if (compare(w, "DEL") || compare(w, "RM") || compare(w, "ERASE"))
	remove_file(unr, eingabe);
      else if (compare(w, "RMDIR") || compare(w, "RD"))
	remove_dir(unr, eingabe);
      else if (compare(w, "CP") || compare(w, "COPY"))
	copy_file(unr, eingabe, false);
      else if (compare(w, "MV") || compare(w, "MOVE"))
	copy_file(unr, eingabe, true);
      else if (compare(w, "INDEX"))
	put_file(unr, ".index", 0);
      else if (compare(w, "EXIT") || compare(w, "QUIT") || compare(w, "BYE")) {
	wln_btext(unr, 104);
	WITH->smode = false;
      } else {
        cnr = (find_command(unr, w, &onlysys));
        switch (cnr) {
      
        case 98:
        case 99:
          lower(w);
          call_runprg(false, unr, w, eingabe, cnr == 99);
          break;
      
        default:
          wln_btext(unr, 105);
          break;
        }
      
      }
    } else if (compare(w, "EXIT") || compare(w, "QUIT") || compare(w, "BYE")) {
      wln_btext(unr, 104);
      WITH->smode = false;
      
    } else {
      
      cnr = (find_command(unr, w, &onlysys));
      switch (cnr) {
      
      case 98:
      case 99:
        lower(w);
        call_runprg(false, unr, w, eingabe, cnr == 99);
        break;
      
      default:
        wln_btext(unr, 105);
        break;
      }
      
    }
    
    break;

  case 80:
    talk_line(unr, eingabe);
    break;
    
  case 87:   /* wird auch in box.pas benutzt */
    write_file2(unr, eingabe);
    break;

  case 92:
  case 94:
  case 95:
    add_ascii(unr, eingabe, return_);
    break;

  case 96:
    if (WITH->bin == NULL && WITH->yapp == NULL)
      WITH->action = 0;
    else if (*eingabe == '\0' || strpos2(eingabe, "#ABORT#", 1) > 0) {
      wlnuser(unr, eingabe);
      abort_fileread(unr);
      abort_useroutput(unr);
      WITH->action = 0;
    }
    break;


  case 93:
    page_file(unr, eingabe);
    break;

  default:
    user[unr]->action = 0;
    break;
  }

  if (WITH->action == 0)
    show_prompt(unr);

}



void sig_7plus_incoming(boolean priv, Char *name, Char *original)
{
  Char hs[256], w[256];

  strcpy(hs, name);
  get_ext(hs, w);
  upper(w);
  if (!strcmp(w, "COR") || !strcmp(w, "7PL") || strlen(w) == 3 && w[0] == 'P') {
    del_ext(hs);
    call_7plus(priv, -1, hs, "-k -y -q -sysop", original);
  }
}


Static void clean_incoming(void)
{
  short result, x;
  DTA dirinfo;
  Char hs[256], w[256];
  Char STR7[256];
  void (*TEMP)(short unr, Char *s);
  void (*TEMP1)(short unr, Char *s);

  x = 0;
  do {
    sprintf(hs, "%s%s", boxdir, fservdir);
    switch (x) {

    case 0:
      sprintf(hs + strlen(hs), "temp7pl%c", dirsep);
      break;

    case 1:
      sprintf(hs + strlen(hs), "newbin%c", dirsep);
      break;

    case 2:
      sprintf(hs + strlen(hs), "incoming%c", dirsep);
      break;

    case 3:
      sprintf(hs, "%s%stemp7pl%c", boxdir, pservdir, dirsep);
      break;
    }

    sprintf(w, "%s%c%cerr", hs, allquant, extsep);
    strdelete((void *)w, 1, strlen(boxdir));
    TEMP = wlnuser;
    file_delete(-1, w, TEMP);
    new_ext(w, "ERR");
    TEMP1 = wlnuser;
    file_delete(-1, w, TEMP1);

    sprintf(STR7, "%s%c%c%c", hs, allquant, extsep, allquant);
    result = sffirst(STR7, 0, &dirinfo);
    while (result == 0) {
      if (strcmp(dirinfo.d_fname, ".index")) {
	if (clock_.ixtime - dos2ixtime(dirinfo.d_date, dirinfo.d_time) >
	    incominglifetime) {
	  sprintf(STR7, "%s%s", hs, dirinfo.d_fname);
	  sfdelfile(STR7);
	}
      }
      result = sfnext(&dirinfo);
    }
    x++;
  } while (x <= 3);
}


Static long lasttimer;


void smode_timer(short unr, long ticks)
{
  if (lasttimer == 0) {
    lasttimer = ticks;
    return;
  }

  if (ticks == 0 || ticks - lasttimer > 720000L || ticks - lasttimer < 0)
  {  /* > 60 Minuten */
    clean_incoming();
    lasttimer = ticks;
  }
}


void _boxfserv_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  lasttimer = 0;

}



/* End. */
