/* Header for module boxlocal, generated by p2c */
#ifndef BOXLOCAL_H
#define BOXLOCAL_H



#ifndef PASTRIX_H
#include "pastrix.h"
#endif

#ifndef DPGLOBAL_H
#include "dpglobal.h"
#endif

#ifndef BOXGLOBL_H
#include "boxglobl.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif


#ifdef BOXLOCAL_G
# define vextern
#else
# define vextern extern
#endif


#define idx_e           "IDX"
#define idx2_e          "IDL"
#define inf_e           "IFO"
#define gidx_e          "IDG"
#define ginf_e          "IFG"

#define headervn        20
#define magicconst      25431

#define maxuser         200	/* max. User in der Box                  */
#define maxufcache      100	/* so viele userinfos cachen             */
#define maxmsgnumarr    512	/* sollte 2^x sein                       */
#define maxfbbprops     5	/* don't change it...                    */

#define MaxReadBufDefault  100000L /* obsolet                            */

#define checkblocksize  500
#define maxreaddivisor  10000   /* faktor fuer maxread-berechnung        */
#define maxuserspool    10000   /* max. Anzahl Bytes in Ausgabepuffer    */

/* Konstanten fuer msgflags */
#define MSG_SFWAIT      1
#define MSG_PROPOSED    2
#define MSG_SFRX        4
#define MSG_SFTX        8
#define MSG_SFERR       16
#define MSG_SFNOFOUND   32
#define MSG_CUT         64
#define MSG_MINE        128
#define MSG_REJECTED    256
#define MSG_DOUBLE      512
#define MSG_BROADCAST   1024
#define MSG_BROADCAST_RX  2048
#define MSG_OWNHOLD     4096
#define MSG_LOCALHOLD   8192
#define MSG_SFHOLD      16384
#define MSG_OUTDATED    32768L

/* Konstanten fuer pmode  */
/* Achtung, ist nicht sauber durchkodiert. 1,2,4,8,16,128 werden in propose_sf_sending() */
/* speziell belegt                                                                       */

#define PM_NONE         0
#define PM_free         1
#define PM_HUFF2        4
#define TTEXT           0
#define TBIN            32
#define T7PLUS          64
#define THTML           128

/* Konstanten fuer pwmode */
#define PWM_MODEM_ACCESS  0
#define PWM_SEND_ERASE  1
#define PWM_MUST_PRIV   2	/* muss sich immer priv. fuer s/e */
/*   PWM_LOGIN       = 3;	   noch nicht benutzt... */
#define PWM_RSYSOP      8   	/* Rubrikensysop */
#define PWM_RSYSOPPRIV  9   	/* muss sich immer priv. fuer s/e */
#define PWM_SYSOP       10
#define PWM_SYSOPPRIV   11   	/* muss sich immer priv. fuer s/e */
#define maxpwmode       PWM_SYSOPPRIV

/* fuers setzen des flags wer das file geloescht hat */
#define EB_NONE         0
#define EB_SENDER       1
#define EB_RECEIVER     2
#define EB_SYSOP        4
#define EB_RSYSOP       5	/* kein Bitwert mehr... */
#define EB_DOUBLESYSOP  6	/* kein Bitwert mehr... */
#define EB_BIN27PLUS    7	/* kein Bitwert mehr... */
#define EB_LIFETIME     8
#define EB_SF           16
#define EB_REMOTE       32
#define EB_SFERR        64
#define EB_RETMAIL      66
#define EB_TRANSFER     128

#define msgnumoffset    10000   /* to distinguish between msgnums and LIST-nums */

#define THEBOX_ERRONEOUS_OFFSET 18000	/* timezone problem with TheBox-Software */

typedef struct bintype {
  short filefd;
  boolean write_, delete_, ascii;
  long maxfill, posi, total, touch;
  Char fname[256];
} bintype;

typedef struct _REC_msgnumarrtype {
  long msgnum, cpos;
} _REC_msgnumarrtype;

typedef struct mptrtype {
  uchar csum;
  Char call[7];
  short mpos;
  struct mptrtype *next;
} mptrtype;

typedef struct dirtytype {
  struct dirtytype *next;
  Char bad[41];
} dirtytype;

typedef struct rejecttype {
  struct rejecttype *next;
  Char what, msgtype;
  boolean msgtypeneg;
  Char from[7];
  boolean fromneg;
  Char tob[9];
  boolean tobneg;
  Char mbx[41];
  boolean mbxneg;
  Char bid[13];
  boolean bidneg;
  long maxsize;
  boolean maxsizeneg;
} rejecttype;

typedef struct sffortype {
  struct sffortype *next;
  Char pattern[41];
} sffortype;

typedef struct sfrubtype {
  struct sfrubtype *next;
  Char pattern[9];
} sfrubtype;

typedef struct sfnotfromtype {
  struct sfnotfromtype *next;
  Char pattern[7];
} sfnotfromtype;

typedef struct sfcpathtype {
  struct sfcpathtype *next;
  Char qrg[21];
  Char conpath[256];
} sfcpathtype;

typedef struct sfdeftype {
  struct sfdeftype *next;

  Char call[7];
  boolean in_routing;
  long lasttry;
  unsigned short tnc, bedingung;
  long intervall, pollifnone, maxbytes_b, maxbytes_u, maxbytes_p, startutc,
       endutc;

  sffortype *forp, *notforp;
  sfrubtype *rubrikp, *notrubrikp;
  sfnotfromtype *notfromp;
  sfcpathtype *cpathp;
} sfdeftype;

typedef struct convtittype {
  struct convtittype *next;
  Char fromboard[9], toboard[9];
  unsigned short newlt;
  Char title[81];
} convtittype;

typedef struct tcpiptype {
  struct tcpiptype *next;
  Char call[7];
  Char txt[81];
} tcpiptype;

typedef struct rsysoptype {
  struct rsysoptype *next;
  Char call[7];
  Char board[9];
} rsysoptype;

typedef struct bcommandtype {
  struct bcommandtype *next;
  Char command[11];
  short cnr;
  boolean sysop;
  short ulev;
} bcommandtype;

typedef struct transfertype {
  struct transfertype *next;
  Char board1[9], board2[9];
} transfertype;

typedef struct rubriktype {
  struct rubriktype *next;
  Char name[9];
  unsigned short lifetime, access;
} rubriktype;

typedef struct blogmem {
  struct blogmem *vor, *nach;
  long date, logidxct;
} blogmem;

typedef struct indexstruct {
  uchar hver;
  Char id[13];
  Char dest[9];
  Char absender[7];
  Char verbreitung[41];
  Char betreff[81];
  long rxdate, txdate;
  unsigned short lifetime, txlifetime;
  Char msgtype;
  uchar firstbyte;
  long start, packsize, size, rxqrg;
  Char rxfrom[7];
  boolean deleted;
  uchar pmode, level, fwdct;
  unsigned short msgflags;
  long erasetime, lastread;
  unsigned short readcount;
  Char readby[141];
  uchar eraseby;
  Char sendbbs[7];
  uchar reserved;
  long msgnum;
  unsigned short bcastchecksum, infochecksum, headerchecksum;
} indexstruct;

typedef struct boxlogstruct {
  long msgnum, date;
  unsigned short idxnr, lifetime, msgflags;
  long size;
  boolean deleted;
  Char msgtype;
  uchar pmode, level;
  Char brett[9], obrett[9];
  Char bid[13];
  Char absender[7];
  Char verbreitung[7];
  Char betreff[41];
} boxlogstruct;

typedef struct mybbstyp {
  Char call[7], bbs[7];	/* MyBBS                 */
  Char mode;            /* ab v5.03: ist der Eintrag geraten? */
  long ix_time;		/* aktualisiert wann?    */
} mybbstyp;

typedef uchar firstsixtype[6];

typedef struct binsftyp {
  long blockcounter, rxbytes, offset, validbytes;
  short wchan, fbbtitlelen;
  Char fbbtitle[81];
  Char wname[256];
  firstsixtype firstsix;
  unsigned short checksum;	/* laeuft als Checksumme mit  */
  unsigned short crcsum;	/* laeuft mit CRC mit         */
  unsigned short crc2, blockcrc;/* die CRC des aktuellen fbb-blocks */
} binsftyp;

typedef struct resumemem {
  struct resumemem *next;
  Char rbid[13];
  Char rcall[7];
  Char rfname[13];
  long rsize, rdate;
} resumemem;

typedef struct fbbproptype {
  Char line[81];
  Char brett[9];
  Char bid[13];
  Char rname[13];
  unsigned short nr, x_nr;
  boolean pack;
  unsigned short crc;
  boolean unpacked;
  Char mtype;
} fbbproptype;

typedef fbbproptype fbbproparrtype[maxfbbprops];

typedef struct newmailtype {
  struct newmailtype *next;
  short unr;
  Char pattern[256];
  Char rcall[256];
} newmailtype;

typedef struct boxintype {
  struct boxintype *next;
  boolean return_, block, in_begruessung;
  Char line[256];
} boxintype;

typedef struct userstruct {
  short magic1;

  uchar callcsum;
  Char call[7];
  Char mybbs[41];
  Char language[4];
  Char name[81];
  Char SID[21], MSID[21], FSID[21];
  Char sfpwdb[11];
  Char sfpwtn[33];
  Char brett[9], reply_brett[9];
  short reply_nr;
  boolean in_reply;
  Char tempbinname[81], password[81];
  Char input[256];
  Char input2[256];
  Char lastcmd[256];  	/* fuer Box-Activity - Anzeige   */
  Char resumebid[13];   /* damit ein Resume-Index ange-  */
			/* legt werden kann              */
  Char tempbid[13];  	/* wird belegt bei Umleitung von */
 			/* usermail im FBB-Mode          */
  Char lastsfcall[7];   /* fuer w0rli-sf, um immer nur eine Mail     */
  			/* desselben Absenders am Stueck zu senden   */
  Char promptmacro[256];
  Char logincommands[256];
  Char nocheckboards[256];
  Char wantcheckboards[256];

  Char tracefract[256];

  Char lastroption[256];

  fbbproparrtype fbbprop;

  short magic2;

  long lastdate;
  unsigned short level;
  long logindate, lastatime;
  boolean sfmd2pw;	/* using MD2 authentication for SF ? */
  boolean se_ok, hidden, console, supervisor, rsysop, ttl, undef;
  long processtime, rbytes, sbytes;
  short pchan;
  unsigned short pwmode;
  short fwdmode; /* 0..5 */

  indexstruct *sendheader;
  boolean lt_required;

  short tcon, action, sendchan, tell;
  unsigned short plevel;
  short sf_level;
  sfdeftype *sf_ptr;
  boolean f_bbs, sf_master;
  short errors;
  boolean laterflag;
  binsftyp *binsfptr;
  boolean print, lock_here, sf_to, isfirstchar;
      			/* damit die Box erkennen kann, ob eine  */
  			/* uebergebene Zeile vorher ein RETURN hatte */
  unsigned short umode;
  Char mybbsmode;       /* ist das MyBBS geraten? */
  long mybbsupd;   	/* timestamp des MyBBS */
  long lastcmdtime;   	/* timestamp letzter Eingabe */
  long pwsetat;   	/* timestamp Passwortaktivierung */
  unsigned short emblockct;   /* fuer blockweises Senden im THEBOX-Format  */
  boolean no_binpack;
  short M_pos;   	/* indexposition des zugehoerigen Userfiles in M */
  boolean fulltrace;
  short trace_to;
  long convchan;
  short talk_to;
  boolean is_authentic, newmsg;
  unsigned short msgselection;
  boolean in_begruessung, fbbmode, unproto_ok, hidebeacon;
  short readlock, paging;   /* Anzahl Zeilen bis Seitenstop  */
  short pagcount;   	/* Laufvariable Seitenstop       */

  long fstat_rx_p, fstat_rx_b, fstat_rx_s, fstat_tx_p, fstat_tx_b, fstat_tx_s;
  unsigned short logins;

  long sfstat_rx_p, sfstat_rx_b, sfstat_rx_s, sfstat_tx_p, sfstat_tx_b,
       sfstat_tx_s, srbytes, ssbytes, ssrbytes, sssbytes;
  unsigned short sslogins;
  short ssf_level;

  long dstat_rx_p, dstat_rx_b, dstat_rx_s;

  long dstat_rx_bytes, dstat_tx_p, dstat_tx_b, dstat_tx_s, dstat_tx_bytes;
  unsigned short dlogins;

  long maxread_day, read_today;

  boxintype *inputroot;	/* Pseudo-Multitasking-Verwaltung    */
  long cputime;   	/*   "                               */
  short lastprocnumber;	/*   "                               */
  short lastprocnumber2;/*   "                               */
  long lastprocnumber3; /*   "                               */
  long lastprocnumber4;	/*   "                               */
  long lastprocnumber5;	/*   "                               */
  long lastprocnumber6;	/*   "                               */
  long lastprocnumber7;	/*   "                               */
  short prochandle;	/*   "                               */
  uchar *procbuf;	/*   "                               */
  long procbufsize;	/*   "                               */
  long procbufseek;	/*   "                               */
  Char tellmbx[41];	/*   "                               */
  Char tellfname[256];

  boolean smode;   	/* User is in server mode            */
  Char spath[256];   	/* actual path in server mode        */
  Char sfilname[256];   /* file in paging mode               */
  long sseekp;   	/* seek position in paged file       */
  boolean changed_dir;	/* show .index file ?                */

  yapptype *yapp;
  bintype *bin;

  short pty, ptynum;
  Char ptyid[4];
  long ptytouch;
  boolean ptylfcrconv;
  short ptybuflen;
  Char ptybuffer[256];

  long wait_pid;   	/* pid of child process              */
  Char wait_file[256];	/* output file of child process      */

  Char conpath[81];

  short magic3;
} userstruct;

typedef userstruct *ufcachetyp[maxufcache + 1];

typedef userstruct *userptrarrtyp[maxuser + 1];

typedef Char fbb_montype[12][4];

typedef boolean bidchecktype[maxfbbprops];
typedef Char bidarrtype[maxfbbprops][13];

typedef struct protocalltype {
  struct protocalltype *next;
  Char call[7];
  uchar cs;
} protocalltype;

typedef struct tracetype {
  struct tracetype *next;
  Char call[7];
  short by;
} tracetype;

typedef _REC_msgnumarrtype msgnumarrtype[maxmsgnumarr + 1];

typedef struct unprotoportstype {
  struct unprotoportstype *next;
  Char port[21];
  Char path[256];
} unprotoportstype;

typedef struct unprotodeftype {
  unprotoportstype *ports;
  long maxback, interval;
  boolean fbb, dpbox, priv, sys;
} unprotodeftype;

typedef struct zombietype {
  struct zombietype *next;
  long pid;
} zombietype;


vextern zombietype *zombieroot;
vextern boolean immediate_extcheck;
vextern unsigned short maxerrors;
vextern rubriktype *rubrikroot;
vextern rejecttype *rejectroot;
vextern dirtytype *badwordroot;
vextern boolean tell_waiting, garbage_waiting, garbage_done;
vextern unsigned short boxtimect;
vextern long lastbalise, balisetime, laststartbalise;
vextern short baliseh1;
vextern long ttask, packmin, balisenumber;
vextern uchar *balisebuf;
vextern long balisesize;
vextern sfdeftype *sfdefs;
vextern boolean tpkbbs;
vextern transfertype *transferroot;
vextern bcommandtype *bcommandroot;
vextern boolean sf_allowed, m_filter, x_garbage_waiting;
vextern uchar *membidpuffer;
vextern long membidsize;

vextern ufcachetyp ufcache;
vextern userptrarrtyp user;

vextern Char default_prompt[80];
vextern Char sf_connect_call[7];
vextern Char connecttext[81];
vextern Char default_rubrik[9];
vextern Char default_tpkbbs[7];
vextern fbb_montype fbb_month;
vextern Char e_m_verteiler[9], pacsrv_verteiler[9];

vextern Char redlocal[9], redregion[9], rednation[9], reddefboard[9];
vextern short redlifetime;

vextern resumemem *resume_root;
vextern unsigned short resume_lifetime, y_lifetime;
vextern boolean bid_in_ram, garbramdisk;
vextern short debug_level;
vextern long debug_size;
vextern short usertimeout, sftimeout;
vextern long MaxReadBuf;
vextern tcpiptype *tcpiproot;
vextern long lastmailixtime;
vextern boolean ufilhide;
vextern unsigned short max_lt_inc;
vextern boolean create_wp, scan_all_wp, gesperrt;
vextern long erasewait;
vextern boolean create_syslog, create_userlog, create_usersflog,
		create_readlog, create_sflog, create_convlog,
		remoteerasecheck, holdownfiles, authentinfo, forwerr, gttl,
		add_ex, small_first, sort_props, create_acks,
		new_remote_erases, new_mybbs_data, valid_in_ram,
		xcheck_in_ram, check_sffor_in_ram, no_rline_if_exterior,
		smart_routing, request_lt, multi_master;
vextern long remerseekp, mybbsseekp;
vextern short usersftellmode, maxuserconnects, hiscore_connects, sub_bid;
vextern boolean ring_bbs, charge_bbs, convtit;
vextern convtittype *convltroot, *convtitroot;
vextern rsysoptype *rsysoproot;
vextern protocalltype *protocalls;
vextern tracetype *traces;
vextern mptrtype *mptrroot;
vextern long wpcreateinterval, lastwpcreate, holddelay, returntime,
	     bullsfwait, bullsfmaxage, all_maxread_day, badtimecount;
vextern short ufcr;
vextern long ufchit, ufcmiss;
vextern newmailtype *newmailroot;
vextern long incominglifetime;
vextern boolean reduce_lt_after_extract, auto7plusextract, autobinextract,
		allunproto, guess_mybbs;
vextern unprotodeftype *unprotodefroot;
vextern boolean unproto_list;
vextern long unproto_last, unproto_lasttime;
vextern long actmsgnum, firstmsgnum;
vextern short msgnumarrct;
vextern long msgnumarrblock;
vextern msgnumarrtype msgnumarr;


#undef vextern

#endif /*BOXLOCAL_H*/
