
/* file system access of dpbox */


#ifndef FILESYS_H
#define FILESYS_H

#include "defs.h" /* needed to keep track of the current os environment */

#include <fcntl.h>
#include "pastrix.h"




#ifdef dpmacos

/* this is the macintosh localisation for file/folder/path - resolving  */
/* a macintosh does not keep track of files by explicit access paths    */
/* but volume and directory reference ids, resolved at access time     */
/* lets see if we get that resolved in an efficient way so that unix    */
/* access conventions can be used with not too much overhead in         */
/* execution time                                                       */

#define allquant        '*'   /* *.*                           */
#define singlequant     '?'   /* *.HL?                         */
#define extsep          '.'   /* FILE.EXT                      */
#define drivesep        ':'   /* D:\...                        */
#define dirsep		':'
#define minhandle       1   /* kleinste gueltige Dateihandlenummer */
#define maxhandle       32767
#define nohandle        (-1)   /* ungueltiges Handle                 */

#define SFSEEKSET       SEEK_SET
#define SFSEEKCUR       SEEK_CUR
#define SFSEEKEND       SEEK_END

#define FO_READ O_RDONLY
#define FO_WRITE O_WRONLY
#define FO_RW O_RDWR
#define FO_CREATE O_CREAT|O_RDWR|O_TRUNC

#define FC_FILE         0x180   /* PARAMETER FUER FCREATE (NORMAL FILE) */

typedef struct DTA {
  char d_attrib;
  int d_time;
  int d_date;
  int d_length;
#ifdef dpmacos
  int d_lastindex;
  int d_volumeID;
  int d_dirID;
#endif
  char d_fname[256];
} DTA;

typedef DTA mysearchrec;

typedef void (*dispfilelistproc)(short x, Char *s);

extern int dup(int fd);
extern void mktemp(char *name);

#endif /* of dpmacos */










#ifdef dplinux

/* simply copied that widespread file access code of former dpbox code  */
/* in this single file. Not a real change to previous versions of the   */
/* code. lot of the code was written by Mark Wahl DL4YBG for the first  */
/* localisation of the dpbox code from Atari to Linux                   */

#define allquant        '*'   /* *.*                           */
#define singlequant     '?'   /* *.HL?                         */
#define extsep          '.'   /* FILE.EXT                      */
#define drivesep        ':'   /* D:\...                        */
#define dirsep          '/'
#define minhandle       0   /* kleinste gueltige Dateihandlenummer */
#define maxhandle       255
#define nohandle        (-1)   /* ungueltiges Handle                 */

#define SFSEEKSET       SEEK_SET
#define SFSEEKCUR       SEEK_CUR
#define SFSEEKEND       SEEK_END

#define FO_READ O_RDONLY
#define FO_WRITE O_WRONLY
#define FO_RW O_RDWR
#define FO_CREATE O_CREAT|O_RDWR|O_TRUNC

#define FC_FILE         0x180   /* PARAMETER FUER FCREATE (NORMAL FILE) */

typedef struct DTA {
  char d_reserved[21];
  char d_attrib;
  int d_time;
  int d_date;
  int d_length;
  char d_fname[256];
} DTA;

typedef DTA mysearchrec;

#endif /* of dplinux */

/* put further localisations in here                                    */








typedef void (*dispfilelistproc)(short x, Char *s);

#ifdef dplinux /* only for linux version. called at programs end */
extern void delete_dirlist();
#endif

/* these ones are coded different */

extern long DiskFree(int dummy);
extern boolean exist(Char *name);
extern long sfsize(Char *name);
extern short sfrename(Char *oldname, Char *newname);
extern short sfgetdatime(Char *name, unsigned short *date,
			 unsigned short *time);
extern short sfsetdatime(Char *name, unsigned short *date,
			 unsigned short *time);
extern short sffirst(Char *pfad, short attr, DTA *dirr);
extern short sfnext(DTA *dirr);
extern void sfgetdir(short d, Char *p);
extern short sfchdir(Char *p);
extern short sfmakedir(Char *name);
extern short sfremovedir(Char *name);
extern void del_ext(Char *s);
extern void get_ext(Char *s, Char *sext);
extern void new_ext(Char *s, Char *ext);
extern void get_path(Char *s);
extern void del_path(Char *s);
extern void del_blanks(Char *s);
extern boolean myeof(short handle);

/* these ones are coded common */

extern void del_dir(Char *name);
extern void app_file2(Char *filea, short k2, long ab, boolean del_source);
extern void filemove(Char *filea, Char *fileb);
extern void filecopy(Char *filea, Char *fileb);
extern void filecut(Char *filea, Char *fileb, long start, long size);
extern void filecut_nodel(Char *filea, Char *fileb, long start, long size);
extern void validate(Char *name);
extern void string_to_file(short *handle, Char *line, boolean crlf);
extern boolean file_to_string(short handle, Char *line);
extern long append(Char *name, Char *zeile, boolean crlf);
extern void handle2name(short handle, Char *name);
extern short dpsyscreate(char *fname, int flags, int mode);
extern short sfcreate(Char *name, short mode);
extern short sfopen(Char *name, short mode);
extern long sfseek(long count, short handle, short mode);
extern long sfread(short handle, long count, uchar *buf);
extern long sfwrite(short handle, long count, uchar *buf);
extern void sfclose(short *handle);
extern void sfclosedel(short *handle);
extern void sfdelfile(Char *name);
extern void sfdispfilelist(short x, dispfilelistproc outproc);
extern void chkopenfiles(long maxopen, Char *fn); /* maxopen in sekunden */

#define app_file(filea, k2, del_source) app_file2(filea, k2, 0, del_source)
#define drv2num(c) 0



#endif
