/* Output from p2c, the Pascal-to-C translator */
/* From input file "tools.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define TOOLS_G
#include "tools.h"


#ifndef PASTRIX_H
#include "pastrix.h"
#endif

#ifndef CRC_H
#include "crc.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif

#ifndef DPGLOBAL_H
#include "dpglobal.h"
#endif

#include <time.h>


/* dpglobal fuer file_delete */


Static long cpuspeed, cpuspeed2, cattime, cpudd;


void quick_speed(void)
{
  long x, z, erg;

  erg = statclock();
  z = 0;
  for (x = 1; x <= 50000L; x++)   /*100% ca. 45*/
    z += x;
  erg = statclock() - erg;
  fast_machine = (erg < 10);
  cpudd = z;
}


Static void utc_clock_test(void);


Static void calc_speed(void)
{
  long x, z, erg;

  erg = statclock();
  z = 0;
  for (x = 1; x <= 1000000L; x++)
    z += x;
  cpuspeed = statclock() - erg;
  erg = statclock();
  for (x = 1; x <= 600; x++)
    utc_clock_test();
  cpuspeed2 = statclock() - erg;
  if (cpuspeed == 0)
    cpuspeed = 1;
  if (cpuspeed2 == 0)
    cpuspeed2 = 1;
  cattime = clock_.ixtime;
  cpudd = z;
}


long get_cpu_speed(short mode)
{
  if (cpuspeed == 0 || clock_.ixtime - cattime > cpuspeed)
    calc_speed();
  switch (mode) {

  case 2:
    return (47000L / cpuspeed2);
    break;

  default:
    return (92800L / cpuspeed);
    break;
  }
}


boolean insecure(Char *s)
{
  Char hs[256];

  if (strpos2(s, "../", 1) > 0)
    return true;
  if (strpos2(s, "..*", 1) > 0)
    return true;
  if (strpos2(s, ".?/", 1) > 0)
    return true;
  if (strpos2(s, ".?*", 1) > 0)
    return true;
    
  strcpy(hs, s);
  get_path(hs);
  if (strpos2(hs, "*", 1) > 0)
    return true;
  if (strpos2(hs, "?", 1) > 0)
    return true;
  if (strpos2(hs, "~", 1) > 0)
    return true;
    
  strcpy(hs, s);
  del_path(hs);
  if (strpos2(hs, "~", 1) == 1)
    return true;
    
  return false;
}


short calc_prozent(long v1, long v2)
{
  if (v2 > 100000L)
    return (v1 / (v2 / 100));
  else if (v2 > 0)
    return (v1 * 100 / v2);
  else
    return 0;
}


void expand_tabs(Char *hs, short tabsize)
{
  short x, z;
  Char s1[256];

  do {
    x = strpos2(hs, "\t", 1);
    if (x > 0) {
      strdelete((void *)hs, x, 1);
      z = x;
      while (z % tabsize != 0)
	z++;
      z++; 
      *s1 = '\0';
      lspacing(s1, z - x);
      strinsert(s1, (void *)hs, x);
    }
  } while (x != 0);
}


Static void process_backspaces(Char *hs)
{
  short x, l;

  l = strlen(hs);
  if (l < 1 || l > 255)
    return;
  x = 1;
  while (x < l) {
    if (hs[x - 1] != '\b') {
      x++;
      continue;
    }
    strdelete((void *)hs, x, 1);
    l--;
    if (x > 1) {
      strdelete((void *)hs, x - 1, 1);
      l--;
      x--;
    }
  }
}


void give_cookie(short x, fdoutproctype outproc, Char *fname)
{
  long fs;
  short sph;
  long sp, faktor;
  short k, y, lc;
  boolean ok;
  short hiw;
  Char hs[256];

  fs = sfsize(fname);
  if (fs <= 0)
    return;

  if (fs > SHORT_MAX)
    faktor = fs / SHORT_MAX;
  else
    faktor = 1;
  hiw = (short)(fs / faktor);
  if (hiw == SHORT_MAX)
    hiw--;
  do {
    sph = dp_randomize(0, hiw);
    sp = (long)sph * faktor;
  } while ((unsigned long)sp >= fs);

  k = sfopen(fname, FO_READ);
  if (k < minhandle)
    return;


  ok = false;
  lc = 0;
  do {
    lc++;
    if (sfseek(sp, k, SFSEEKSET) == sp) {
      y = 0;
      while (file_to_string(k, hs) &&
	     (strpos2(hs, "-", 1) != 1 || strpos2(hs, "%", 1) != 1) &&
	     y < 400)
	y++;
      if (strpos2(hs, "-", 1) == 1) {
	y = 0;
	while (file_to_string(k, hs) && strpos2(hs, "-", 1) != 1 && y < 400) {
	  y++;
	  process_backspaces(hs);
	  expand_tabs(hs, 8);
	  outproc(x, hs);
	  ok = true;
	}
      } else if (strpos2(hs, "%", 1) == 1) {
	y = 0;
	while (file_to_string(k, hs) && strpos2(hs, "%", 1) != 1 && y < 400) {
	  y++;
	  process_backspaces(hs);
	  expand_tabs(hs, 8);
	  outproc(x, hs);
	  ok = true;
	}
      }
    }
    if (!ok)
      sp = 0;
  } while (!(ok || lc > 1));
  sfclose(&k);
}


Static void d0(Char *s)
{
  short k;
  Char STR1[256];

  k = strlen(s);
  while (k++ < 2)
    sprintf(s, "0%s", strcpy(STR1, s));
}


void calc_ixsecs_to_string(long l, Char *hs)
{
  long d, h, m, s;
  Char w[256];

  d = l / 86400L;
  l -= d * 86400L;
  h = l / 3600;
  l -= h * 3600;
  m = l / 60;
  s = l - m * 60;
  sprintf(w, "%ld", d);
  sprintf(hs, "%s days, ", w);
  sprintf(w, "%ld", h);
  d0(w);
  sprintf(hs + strlen(hs), "%s:", w);
  sprintf(w, "%ld", m);
  d0(w);
  sprintf(hs + strlen(hs), "%s:", w);
  sprintf(w, "%ld", s);
  d0(w);
  strcat(hs, w);
}


void file_delete(short x, Char *cmd, fdoutproctype outproc)
{
  DTA dirinfo;
  short result, ct, l;
  Char pa[256], dn[256], df[256];
  Char STR1[256];

  ct = 0;
  strcpy(pa, cmd);
  if (insecure(pa))
    outproc(x, "invalid path");
  else {
    sprintf(pa, "%s%s", boxdir, strcpy(STR1, pa));
    l = strlen(boxdir);
    strcpy(df, pa);
    del_path(df);
    get_path(pa);
    sprintf(STR1, "%s%s", pa, df);
    result = sffirst(STR1, 0, &dirinfo);   /* alle normalen Files suchen */
    while (result == 0) {
      sprintf(dn, "%s%s", pa, dirinfo.d_fname);
      sfdelfile(dn);
      ct++;
      strdelete((void *)dn, 1, l);
      if (x >= 0)
	outproc(x, dirinfo.d_fname);
      result = sfnext(&dirinfo);
    }
  }
  if (ct <= 0)
    return;
  sprintf(dn, "%ld", ct);
  strcat(dn, " file");
  if (ct != 1)
    strcat(dn, "s");
  strcat(dn, " deleted");
  if (x >= 0)
    outproc(x, dn);
}


boolean useq(Char *s1, Char *s2)
/* stolen from p2c.c of David Gillespie */
{
    unsigned char c1, c2;

    while (*s1) {
	if (*s1++ != *s2++) {
	    if (!s2[-1])
		return false;
	    c1 = upcase_(s1[-1]);
	    c2 = upcase_(s2[-1]);
	    if (c1 != c2)
		return false;
	}
    }
    if (*s2)
	return false;
    return true;
}

short uspos(Char *s1, Char *s2)
{
  Char b1[256], b2[256];

  strcpy(b1, s1);
  strcpy(b2, s2);
  upper(b1);
  upper(b2);
  return strpos2(b2, b1, 1);
}


Static void spdputs(short d, short m, short y, Char sep, Char *s)
{
  Char w[256];

  *s = '\0';
  sprintf(w, "%ld", d);
  d0(w);
  sprintf(s, "%s%c", w, sep);
  sprintf(w, "%ld", m);
  d0(w);
  sprintf(s + strlen(s), "%s%c", w, sep);
  sprintf(w, "%ld", y);
  d0(w);
  strcat(s, w);
}


Static void conc_date(Char sep, unsigned short date, Char *s)
{
  short d, m, y;

  if (sep == '/')
    Get_DDate(date, &d, &m, &y);
  else
    Get_DTime(date, &d, &m, &y);
  spdputs(d, m, y, sep, s);
}


Static void make_sortdate(unsigned short date, unsigned short time, Char *s)
{
  short x, l;
  Char STR1[256];

  sprintf(s, "%ld", dos2ixtime(date, time));
  l = strlen(s) + 1;
  for (x = l; x <= 10; x++)
    sprintf(s, "0%s", strcpy(STR1, s));
}


Static void make_sortsize(long size, Char *s)
{
  short x, l;
  Char STR1[256];

  sprintf(s, "%ld", size);
  l = strlen(s) + 1;
  for (x = l; x <= 10; x++)
    sprintf(s, "0%s", strcpy(STR1, s));
}


Static void make_sortext(Char *ins, Char *s)
{
  get_ext(ins, s);
  rspacing(s, 10);
  cut(s, 10);
}


Static void shorten_dirstring(Char *hs, short maxct)
{
  short x, y, todel;

  x = strlen(hs);
  if (x <= maxct)
    return;

  todel = x - maxct + 2;
  y = 1;
  while (y < x && hs[y - 1] != extsep)
    y++;
  if (y > todel + 2) {
    strdelete((void *)hs, y - todel + 1, todel);
    strinsert("..", (void *)hs, y - todel + 1);
  } else {
    cut(hs, maxct - 2);
    strcat(hs, "..");
  }
}


#define sbufsize        32767
#define SBNAME          0
#define SBDATE          1
#define SBSIZE          2
#define SBEXT           3


void file_dir(boolean supervisor, Char *path, Char *options, short x,
	      fdoutproctype outproc)
{

  DTA dirinfo;
  short result, l;
  boolean longdir, xdir, fnums, count;
  short sortby, countfor;
  uchar *sbuf;
  short maxc, sct;
  long sbs, rbs;
  short h, ct, cct;
  Char hs[256], dn[256], s[256], ds[256];
  Char pn[256];
  Char STR1[256], STR7[256];
  Char STR13[8];

  sbuf = Malloc(sbufsize);
  if (sbuf == NULL)
    return;

  sbs = 0;
  maxc = 0;
  count = false;
  countfor = 0;

  strcpy(ds, options);
  upper(ds);
  
  h = strpos2(ds, "-C", 1);
  if (h > 0) {
    strcpy(s, ds);
    strdelete((void *)s, 1, h + 1);
    get_word(s, pn);
    countfor = Str2int(pn);
    count = true;
  }

  if (strpos2(ds, "-DATE", 1) > 0)
    sortby = SBDATE;
  else if (strpos2(ds, "-SIZE", 1) > 0)
    sortby = SBSIZE;
  else if (strpos2(ds, "-EXT", 1) > 0)
    sortby = SBEXT;
  else
    sortby = SBNAME;

  xdir = (count || strpos2(ds, "-X", 1) > 0 && x >= 0);
  longdir = (xdir || strpos2(ds, "-L", 1) > 0);

  strcpy(pn, path);
  get_path(pn);

  if (!count) {
    if (x >= 0 && strpos2(ds, "-I", 1) > 0) {
      sprintf(hs, "%s.index", pn);
      h = sfopen(hs, FO_READ);
      if (h >= minhandle) {
	while (file_to_string(h, hs))
	  outproc(x, hs);
	sfclose(&h);
	outproc(x, "");
      }
    }

    result = sffirst(path, 16, &dirinfo);   /* alle Subdirectories suchen */
    while (result == 0) {
      if (dirinfo.d_attrib == 16)
      {  /* es handelt sich um einen Directoryeintrag */
	strcpy(hs, dirinfo.d_fname);
	if (longdir) {
	  shorten_dirstring(hs, 24);
	  sprintf(hs, "  * %s/", strcpy(STR7, hs));
	  rspacing(hs, 29);
	  strcat(hs, "           ");
	  conc_date('/', dirinfo.d_date, s);
	  strcat(hs, s);
	  conc_date(':', dirinfo.d_time, s);
	  sprintf(hs + strlen(hs), "  %s", s);
	} else {
	  strcat(hs, "/");
	  l = strlen(hs);
	  if (l > maxc)
	    maxc = l;
	}

	switch (sortby) {

	case SBDATE:
	  make_sortdate(dirinfo.d_date, dirinfo.d_time, ds);
	  break;

	case SBSIZE:
	  make_sortsize(dirinfo.d_length, ds);
	  break;

	case SBEXT:
	  make_sortext(dirinfo.d_fname, ds);
	  break;

	default:
	  *ds = '\0';
	  break;
	}
	sprintf(hs, "%s%s", ds, strcpy(STR7, hs));
	if (sbs + strlen(hs) + 1 < sbufsize)
	  put_line(sbuf, &sbs, hs);
      }
      result = sfnext(&dirinfo);
    }

    if (longdir) {
      sort_mem(sbuf, &sbs);
      rbs = 0;
      while (rbs < sbs) {
	get_line(sbuf, &rbs, sbs, hs);
	if (sortby != SBNAME)
	  strdelete((void *)hs, 1, 10);
	outproc(x, hs);
      }

      if (xdir && sbs > 0)
	outproc(x, "");

      sbs = 0;
    }

  }

  result = sffirst(path, 0, &dirinfo);   /* alle normalen Files suchen */
  while (result == 0) {
    if (dirinfo.d_attrib != 16) {
      strcpy(dn, dirinfo.d_fname);
      if (supervisor && !xdir || dn[0] != '.') {
	if (longdir) {
	  shorten_dirstring(dn, 25);
	  rspacing(dn, 25);
	  sprintf(dn, "    %s", strcpy(STR7, dn));
	  sprintf(hs, "%ld", dirinfo.d_length);
	  lspacing(hs, 8);
	  sprintf(hs, "%s %s", dn, strcpy(STR1, hs));
	  rspacing(hs, 40);
	  conc_date('/', dirinfo.d_date, s);
	  strcat(hs, s);
	  conc_date(':', dirinfo.d_time, s);
	  sprintf(hs + strlen(hs), "  %s", s);
	} else {
	  strcpy(hs, dn);
	  l = strlen(hs);
	  if (l > maxc)
	    maxc = l;
	}

	switch (sortby) {

	case SBDATE:
	  make_sortdate(dirinfo.d_date, dirinfo.d_time, ds);
	  break;

	case SBSIZE:
	  make_sortsize(dirinfo.d_length, ds);
	  break;

	case SBEXT:
	  make_sortext(dirinfo.d_fname, ds);
	  break;

	default:
	  *ds = '\0';
	  break;
	  
	}
	sprintf(hs, "%s%s", ds, strcpy(STR7, hs));

	if (sbs + strlen(hs) + 1 < sbufsize)
	  put_line(sbuf, &sbs, hs);

      }
    }
    result = sfnext(&dirinfo);
  }

  sort_mem(sbuf, &sbs);

  rbs = 0;
  sct = 0;

  if (!longdir) {
    *s = '\0';
    if (maxc > 78)
      maxc = 78;
  }

  cct = 0;
  fnums = (xdir &&
	   strpos2(path, (sprintf(STR13, "%c%c%c%c",
				  dirsep, allquant, extsep,
				  allquant), STR13), 1) == strlen(path) - 3);

  while (rbs < sbs) {
    get_line(sbuf, &rbs, sbs, hs);
    if (sortby != SBNAME)
      strdelete((void *)hs, 1, 10);
    if (!longdir) {
      rspacing(hs, maxc);
      if (sct + maxc > 78) {
	outproc(x, s);
	sct = maxc;
	strcpy(s, hs);
	continue;
      }
      if (sct == 0) {
	strcpy(s, hs);
	sct = maxc;
      } else {
	sprintf(s + strlen(s), "  %s", hs);
	sct += maxc + 2;
      }
      continue;
    }

    if (count) {
      cct++;
      if (cct == countfor) {
	strdelete((void *)hs, 1, 4);
	get_word(hs, path);
	mymfreep(&sbuf);
	return;
      }
      continue;
    }

    if (fnums) {
      cct++;
      strdelete((void *)hs, 1, 3);
      sprintf(s, "%ld", cct);
      lspacing(s, 3);
      sprintf(hs, "%s%s", s, strcpy(STR1, hs));
    }

    outproc(x, hs);

    if (!xdir)
      continue;

    strdelete((void *)hs, 1, 4);
    get_word(hs, s);
    if (s[0] == '.')
      continue;

    sprintf(hs, "%s.%s", pn, s);
    h = sfopen(hs, FO_READ);
    if (h < minhandle)
      continue;
    for (ct = 1; ct <= 4; ct++) {
      if (file_to_string(h, hs)) {
	sprintf(hs, "    %s", strcpy(STR7, hs));
	outproc(x, hs);
      }
    }
    sfclose(&h);
    outproc(x, "");
  }

  if (!longdir && sct > 0)
    outproc(x, s);

  if (count)
    *path = '\0';
  mymfreep(&sbuf);
}

#undef sbufsize
#undef SBNAME
#undef SBDATE
#undef SBSIZE
#undef SBEXT


short filecp(Char *filea, Char *fileb, Char *root, boolean del_source,
	     short x, fdoutproctype outproc)
{
  short Result;
  short err;
  boolean dest_set_dir, dest_is_dir;
  DTA dirinfo;
  short result, loopct;
  Char fpath[256], fa[256], fb[256], fx[256];
  Result = -1;
  err = 0;

  if (*root != '\0') {
    if (insecure(filea))
      err = -1;
    else if (insecure(fileb))
      err = -1;
    else if (strpos2(filea, root, 1) != 1)
      err = -1;
    else if (strpos2(fileb, root, 1) != 1)
      err = -1;

    if (err != 0) {
      if (x >= 0)
	outproc(x, "no permission");
      return Result;
    }
  }

  strcpy(fx, fileb);
  if (fx[strlen(fx) - 1] == dirsep) {
    strdelete((void *)fx, strlen(fx), 1);
    dest_set_dir = true;
  } else
    dest_set_dir = false;

  dest_is_dir = (sffirst(fx, 16, &dirinfo) == 0 && dirinfo.d_attrib == 16);

  if (dest_set_dir && !dest_is_dir) {
    if (x >= 0)
      outproc(x, "destination is not a directory");
    return Result;
  }

  strcpy(fpath, filea);
  get_path(fpath);

  if (dest_is_dir) {
    sprintf(fb, "%s%c", fx, dirsep);
    if (!strcmp(fb, fpath)) {
      if (x >= 0)
	outproc(x, "invalid operation");
      return Result;
    }
  }

  loopct = 0;
  result = sffirst(filea, 0, &dirinfo);
  while (result == 0 && (loopct == 0 || dest_is_dir)) {
    if (dirinfo.d_attrib != 16) {
      sprintf(fa, "%s%s", fpath, dirinfo.d_fname);
      if (dest_is_dir)
	sprintf(fb, "%s%c%s", fx, dirsep, dirinfo.d_fname);
      else
	strcpy(fb, fx);

      if (x >= 0)
	outproc(x, dirinfo.d_fname);

      if (del_source)
	filemove(fa, fb);
      else
	filecopy(fa, fb);

      if (dest_is_dir)
	Result = 1;
      else
	Result = 0;
      loopct++;
    }
    result = sfnext(&dirinfo);
  }
  return Result;
}


/* Errechnet eine Checksumme ueber einen String       */

uchar calccs(Char *s)
{
  uchar erg;

  erg = 0;

  while (*s != '\0')
    erg += *s++;

  return erg;
}

/* Kopiert und errechnet eine Checksumme ueber einen String       */

uchar strcpycs(register char *s2, register char *s1)
{
  register uchar erg;
  register char ch;

  erg = 0;

  do {
    ch = *s1++;
    erg += ch;
    *s2++ = ch;
  } while (ch != '\0');

  return erg;
}


#define blocksize       8192L

/* Errechnet eine CRC ueber ein File                 */

unsigned short file_crc(short methode, Char *name, unsigned short preload,
			long start, long size)
{
  unsigned short crc;
  short k;
  long fsize, done, cstep, psize, hsize;
  uchar *buf;

  crc = preload;
  fsize = sfsize(name);

  if (size > 0)
    fsize = size;
  if (start > 0) {
    if (size == 0)
      fsize -= start;
  }

  if (fsize <= 0)
    return crc;

  psize = blocksize;
  if (psize > fsize)
    psize = fsize;
  dpgetmem(&buf, psize);
  if (buf == NULL) {
    hsize = maxavail__();
    if (hsize > 0) {
      if (hsize > psize)   /* darf nicht vorkommen */
	hsize = psize;
      psize = hsize;
      dpgetmem(&buf, psize);
    }
  }
  if (buf == NULL)
    return crc;
  k = sfopen(name, FO_READ);
  if (k >= minhandle) {
    if (start > 0)
      sfseek(start, k, SFSEEKSET);
    done = 0;
    cstep = 1;
    while (done < fsize && cstep > 0) {
      cstep = sfread(k, psize, buf);
      if (cstep <= 0)
	break;
      done += cstep;

      switch (methode) {

      case 0:
	crcfcs_buf(buf, cstep, &crc);
	break;

      case 1:
	crc_16_buf(buf, cstep, &crc);
	break;

      case 2:
	crcthp_buf(buf, cstep, &crc);
	break;

      case 3:
	crcfbb_buf(buf, cstep, &crc);
	break;

      case 4:
	checksum8_buf(buf, cstep, &crc);
	break;

      case 5:
	checksum16_buf(buf, cstep, &crc);
	break;

      }
    }
    sfclose(&k);
  }
  dpfreemem(&buf, psize);
  return crc;
}

#undef blocksize


void wochentag(Char *lan, short d, short m, short y, Char *s)
{
  Char hs[256];

  get_language(week_day(d, m, y) + 66, langmemroot, lan, hs);
  cut(hs, 10);
  strcpy(s, hs);
}

boolean compare(Char *w, Char *cmd)
{
  return (strpos2(cmd, w, 1) == 1);
}


void del_tnc3port(Char *callin, Char *callout)
{
  Char h[256];

  if (callin[1] == ':') {
    strcpy(h, callin);   /* mit Absicht Umweg ueber eine  */
    strsub(callout, h, 3, strlen(h) - 2);
	/* dritte Variable !             */
  } else
    strcpy(callout, callin);
  cut(callout, 9);
}


void del_callextender(Char *callin, Char *callout)
{
  short k;
  Char h[256];

  strcpy(h, callin);   /* auch hier mit Absicht Umweg   */
  k = strpos2(h, "-", 1);   /* ueber eiine dritte Variable   */
  if (k > 0)
    cut(h, k - 1);
  if (h[1] == ':')
    strdelete((void *)h, 1, 2);
  cut(h, 6);
  strcpy(callout, h);
}


void get_callextender(Char *callin, Char *callout)
{
  short k;
  Char h[256];

  k = strpos2(callin, "-", 1);
  if (k <= 0) {
    callout[0] = '\0';
    return;
  }
  strcpy(h, callin);   /* und auch hier mit Absicht...  */
  strsub(callout, h, k + 1, strlen(h) - k);
  cut(callout, 2);
}


Static short iscalpha(Char c)
{
  if (isupper(c))
    return 1;
  else if (isdigit(c))
    return 0;
  else if (islower(c))
    return 1;
  else
    return -1;
}


boolean callsign(Char *rubrik)
{
  short l;

  l = strlen(rubrik);
  if (l < 4 || l > 6)
    return false;

  switch (iscalpha(rubrik[0])) {

  case 0:  /* N */
    switch (iscalpha(rubrik[1])) {

    case 0:   /* NN */
      return false;
      break;

    case 1:  /* NA */
      switch (iscalpha(rubrik[2])) {

      case 0:  /* NAN */
	switch (iscalpha(rubrik[3])) {

	case 0:   /* NANN */
	  return false;
	  break;

	case 1:   /* NANA */
	  break;
	}
	break;

      case 1:   /* NAA */
	return false;
	break;

      default:
	return false;
	break;
      }
      break;

    default:
      return false;
      break;
    }
    break;

  case 1:  /* A */
    switch (iscalpha(rubrik[1])) {

    case 0:  /* AN */
      switch (iscalpha(rubrik[2])) {

      case 0:  /* ANN */
	switch (iscalpha(rubrik[3])) {

	case 0:   /* ANNN */
	  return false;
	  break;

	case 1:   /* ANNA */
	  break;

	default:
	  return false;
	  break;
	}
	break;

      case 1:  /* ANA */
	switch (iscalpha(rubrik[3])) {

	case 0:   /* ANAN */
	  return false;
	  break;

	case 1:   /* ANAA */
	  break;

	default:
	  return false;
	  break;
	}
	break;

      default:
	return false;
	break;
      }
      break;

    case 1:  /* AA */
      switch (iscalpha(rubrik[2])) {

      case 0:  /* AAN */
	switch (iscalpha(rubrik[3])) {

	case 0:   /* AANN */
	  return false;
	  break;

	case 1:   /* AANA */
	  break;

	default:
	  return false;
	  break;
	}
	break;

      case 1:
	if (rubrik[2] == 'Q' || rubrik[2] == 'q')
	  return (uspos("REQ", rubrik) == 1);
	return false;   /* AAA */
	break;

      default:
	return false;
	break;
      }
      break;

    default:
      return false;
      break;
    }
    break;

  default:
    return false;
    break;
  }

  if (l >= 5 && iscalpha(rubrik[4]) != 1)
    return false;
  if (l == 6 && iscalpha(rubrik[5]) != 1)
    return false;

  return true;
}


void datum22string(short day, short mon, short year, Char *datestring)
{
  Char hs[256];
  Char STR1[256];

  sprintf(datestring, "%ld", day);
  if (day < 10)
    sprintf(datestring, "0%s", strcpy(STR1, datestring));
  sprintf(hs, "%ld", mon);
  if (mon < 10)
    sprintf(datestring + strlen(datestring), ".0%s", hs);
  else
    sprintf(datestring + strlen(datestring), ".%s", hs);

  sprintf(hs, "%ld", year);
  if (year < 10)
    sprintf(datestring + strlen(datestring), ".0%s", hs);
  else
    sprintf(datestring + strlen(datestring), ".%s", hs);
  cut(datestring, 8);
}

void datum2string(unsigned short datum, Char *datestring)
{
  short day, mon, year;

  Get_DDate(datum, &day, &mon, &year);
  datum22string(day, mon, year, datestring);
}

void ixdatum2string(long datum, Char *datestring)
{
  uchar d, m, y, h, min, s;

  decode_ixtime(datum, &d, &m, &y, &h, &min, &s);
  datum22string(d, m, y, datestring);
}

void zeit22string(short hour, short min, short sec, Char *timestring)
{
  Char hs[256];
  Char STR1[256];

  sprintf(timestring, "%ld", hour);
  if (hour < 10)
    sprintf(timestring, "0%s", strcpy(STR1, timestring));
  sprintf(hs, "%ld", min);
  if (min < 10)
    sprintf(timestring + strlen(timestring), ":0%s", hs);
  else
    sprintf(timestring + strlen(timestring), ":%s", hs);
  sprintf(hs, "%ld", sec);
  if (sec < 10)
    sprintf(timestring + strlen(timestring), ":0%s", hs);
  else
    sprintf(timestring + strlen(timestring), ":%s", hs);
  cut(timestring, 8);
}

void zeit2string(unsigned short zeit, Char *timestring)
{
  short hour, min, sec;

  Get_DTime(zeit, &hour, &min, &sec);
  zeit22string(hour, min, sec, timestring);
}

void ixzeit2string(long zeit, Char *timestring)
{
  uchar d, m, y, h, min, s;

  decode_ixtime(zeit, &d, &m, &y, &h, &min, &s);
  zeit22string(h, min, s, timestring);
}

void ix2string(long zeit, Char *timestring)
{
  uchar d, m, y, h, min, s;
  Char hs[256];

  decode_ixtime(zeit, &d, &m, &y, &h, &min, &s);
  zeit22string(h, min, s, hs);
  datum22string(d, m, y, timestring);
  strcat(timestring, " ");
  strcat(timestring, hs);
}


unsigned short str2datum(Char *datestring)
{
  short day, mon, year, x;
  boolean reverse;
  Char sep;
  Char hs[256];
  Char STR1[256];
  
  reverse = false;
  x = strpos2(datestring, ".", 1);
  if (x == 0) {
    x = strpos2(datestring, "/", 1);
    if (x == 0) {
      x = strpos2(datestring, "-", 1);
      if (x == 3) {
	reverse = true;
	sep = '-';
      } else
	sep = '\0';
    } else
      sep = '/';
  } else
    sep = '.';
  if ((unsigned)x < 32 && ((1L << x) & 0xc) != 0) {
    sprintf(hs, "%.*s", x - 1, datestring);
    day = Str2int(hs);
    strdelete((void *)datestring, 1, x);
    sprintf(STR1, "%c", sep);
    x = strpos2(datestring, STR1, 1);
    if ((unsigned)x < 32 && ((1L << x) & 0xc) != 0) {
      sprintf(hs, "%.*s", x - 1, datestring);
      mon = Str2int(hs);

      strdelete((void *)datestring, 1, x);
      sprintf(STR1, "%.2s", datestring);
      if (!strcmp(STR1, "19"))
	strsub(hs, datestring, 3, 2);
      else
	sprintf(hs, "%.2s", datestring);
      year = Str2int(hs);
      if (year >= 80 && year <= 99) {
	if (reverse) {
	  x = day;
	  day = mon;
	  mon = x;
	}
	if (mon > 12 && day <= 12) {
	  x = day;
	  day = mon;
	  mon = x;
	}
	if ((unsigned)mon < 32 && ((1L << mon) & 0x1ffe) != 0 &&
	    (unsigned)day < 32 && ((1L << day) & 0xfffffffe) != 0)
	  return (Make_DDate(day, mon, year));
	else
	  return 0;
      } else
	return 0;
    } else
      return 0;
  } else
    return 0;
}


unsigned short str2zeit(Char *timestring)
{
  short hour, min, sec, x;
  Char sep;
  Char hs[256];
  Char STR1[256];
  
  x = strpos2(timestring, ":", 1);
  if (x == 0) {
    x = strpos2(timestring, ".", 1);
    if (x == 0) {
      x = strpos2(timestring, "/", 1);
      if (x == 0) {
	x = strpos2(timestring, "-", 1);
	if (x == 3)
	  sep = '-';
	else
	  sep = '\0';
      } else
	sep = '/';
    } else
      sep = '.';
  } else
    sep = ':';

  if ((unsigned)x < 32 && ((1L << x) & 0xc) != 0) {
    sprintf(hs, "%.*s", x - 1, timestring);
    hour = Str2int(hs);
    strdelete((void *)timestring, 1, x);
    sprintf(STR1, "%c", sep);
    x = strpos2(timestring, STR1, 1);
    if (x == 0)
      x = 3;
    if ((unsigned)x < 32 && ((1L << x) & 0xc) != 0) {
      sprintf(hs, "%.*s", x - 1, timestring);
      min = Str2int(hs);
      strdelete((void *)timestring, 1, x);
      if (strlen(timestring) >= 2) {
	sprintf(hs, "%.2s", timestring);
	sec = Str2int(hs);
      } else
	sec = 0;
      if ((unsigned)hour < 32 && ((1L << hour) & 0xffffffL) != 0 &&
	  (unsigned)min <= 59 && (unsigned)sec <= 59)
	return (Make_DTime(hour, min, sec));
      else
	return 0;
    } else
      return 0;
  } else
    return 0;

}


/******************************************************************** */


long daydiff(unsigned short date1, unsigned short time1, unsigned short date2,
	     unsigned short time2)
{
  short d1, m1, y1, h1, min1, s1, d2, m2, y2, h2, min2, s2;
  long it1, it2;

  Get_DDate(date1, &d1, &m1, &y1);
  Get_DDate(date2, &d2, &m2, &y2);
  Get_DTime(time1, &h1, &min1, &s1);
  Get_DTime(time2, &h2, &min2, &s2);
  it1 = calc_ixtime(d1, m1, y1, h1, min1, s1);

  it2 = calc_ixtime(d2, m2, y2, h2, min2, s2);
  return (it2 - it1);
}

Static long ix_ytable[68] = {
  0, 31536000L, 63072000L, 94694400L, 126230400L, 157766400L, 189302400L,
  220924800L, 252460800L, 283996800L, 315532800L, 347155200L, 378691200L,
  410227200L, 441763200L, 473385600L, 504921600L, 536457600L, 567993600L,
  599616000L, 631152000L, 662688000L, 694224000L, 725846400L, 757382400L,
  788918400L, 820454400L, 852076800L, 883612800L, 915148800L, 946684800L,
  978220800L, 1009756800L, 1041292800L, 1072828800L, 1104451200L, 1135987200L,
  1167523200L, 1199059200L, 1230681600L, 1262217600L, 1293753600L,
  1325289600L, 1356912000L, 1388448000L, 1419984000L, 1451520000L,
  1483142400L, 1514678400L, 1546214400L, 1577750400L, 1609372800L,
  1640908800L, 1672444800L, 1703980800L, 1735603200L, 1767139200L,
  1798675200L, 1830211200L, 1861833600L, 1893369600L, 1924905600L,
  1956441600L, 1988064000L, 2019600000L, 2051136000L, 2082672000L, 2114294400L
};

Static long ix_mtable[12] = {
  0, 2678400L, 5097600L, 7776000L, 10368000L, 13046400L, 15638400L, 18316800L,
  20995200L, 23587200L, 26265600L, 28857600L
};


long calc_ixtime(uchar d, uchar m, uchar y, uchar h, uchar mi, uchar s)
{
  long erg;

  if (y < 80 || y > 137)
    return 0;

  if (m < 1 || m > 12)
    return 0;

  erg = ix_ytable[y - 70] + ix_mtable[m - 1] + (d - 1) * 86400L +
	(long)h * 3600 + (long)mi * 60 + (long)s;

  if (m > 2 && (y & 3) == 0 && y != 100)
    erg += 86400L;

  return erg;
}


void decode_ixtime(long ix, uchar *d, uchar *m, uchar *y, uchar *h,
		   uchar *min, uchar *s)
{
  long zsum, offset;

  if (ix > 0) {
    *y = 137;
    while (ix_ytable[*y - 70] > ix)
      (*y)--;

    zsum = ix - ix_ytable[*y - 70];
    *m = 12;
    offset = 0;

    if (zsum > 5097600L && ((*y) & 3) == 0 && *y != 100) {
      zsum -= 86400L;
      offset = 86400L;
    }

    while (ix_mtable[*m - 1] > zsum)
      (*m)--;

    if (*m == 2)
      zsum += offset - ix_mtable[*m - 1];
    else
      zsum -= ix_mtable[*m - 1];

    *d = zsum / 86400L + 1;

    zsum %= 86400L;

    *h = zsum / 3600;
    *min = zsum % 3600 / 60;
    *s = zsum % 60;

    return;
  }

  *d = 1;
  *m = 1;
  *y = 70;
  *h = 0;
  *min = 0;
  *s = 0;
}


long calcfdate(unsigned short date, unsigned short time)
{
  short d, m, y, h, min, s;

  Get_DDate(date, &d, &m, &y);
  Get_DTime(time, &h, &min, &s);
  return (calc_ixtime(d, m, y, h, min, s));
}


long dos2ixtime(unsigned short ddate, unsigned short dtime)
{
  return (calcfdate(ddate, dtime));
}


void ix2dostime(long ix, unsigned short *ddate, unsigned short *dtime)
{
  uchar d, m, y, h, min, s;

  decode_ixtime(ix, &d, &m, &y, &h, &min, &s);
  *ddate = Make_DDate(d, m, y);
  *dtime = Make_DTime(h, min, s);
}


long string2ixtime(Char *ds, Char *ts)
{
  return (dos2ixtime(str2datum(ds), str2zeit(ts)));
}


Static long last_ixtime;
Static uchar last_day, last_mon, last_year;


void utc_clock(void)
{
  clock_.ixtime = sys_ixtime();
  if (last_ixtime == clock_.ixtime)
    return;
  last_ixtime = clock_.ixtime;

  decode_ixtime(clock_.ixtime, &clock_.day, &clock_.mon, &clock_.year,
		&clock_.hour, &clock_.min, &clock_.sec);
  zeit22string(clock_.hour, clock_.min, clock_.sec, clock_.zeit);

  if (last_day == clock_.day && last_mon == clock_.mon &&
      last_year == clock_.year)
    return;

  last_day = clock_.day;
  last_mon = clock_.mon;
  last_year = clock_.year;

  datum22string(clock_.day, clock_.mon, clock_.year, clock_.datum);
  if (wtag_rsc_call != NULL)
    wtag_rsc_call(clock_.day, clock_.mon, clock_.year, clock_.wochentag);
  else
    *clock_.wochentag = '\0';

}


Static void utc_clock_test(void)
{
  unsigned short ddate, dtime;
  clocktype clock2;
  
  /* nur noch zum Testen der CPU-Speed ... */
  clock2.ixtime = sys_ixtime();
  decode_ixtime(clock2.ixtime, &clock2.day, &clock2.mon, &clock2.year,
		&clock2.hour, &clock2.min, &clock2.sec);
  ddate = Make_DDate(clock2.day, clock2.mon, clock2.year);
  dtime = Make_DTime(clock2.hour, clock2.min, clock2.sec);
  datum2string(ddate, clock2.datum);
  zeit2string(dtime, clock2.zeit);

  if (wtag_rsc_call != NULL)
    wtag_rsc_call(clock2.day, clock2.mon, clock2.year, clock2.wochentag);
  else
    *clock2.wochentag = '\0';
}

void get_language(short nr, languagetyp *root, Char *which, Char *s)
{
  languagetyp *lptr;
  boolean found;
  long rp;
  Char w2[9];

  if (nr <= 0 || nr > maxlanguagelinedefs) {
    strcpy(s, "error: invalid line number");
    return;
  }

  sprintf(w2, "%.3s", which);
  upper(w2);

  if (root == NULL) {
    strcpy(s, "error: no languages loaded");
    return;
  }

  do {

    found = false;
    lptr = root;

    while (lptr != NULL && strcmp(lptr->sprache, w2))
      lptr = lptr->next;

    if (lptr == NULL && !strcmp(w2, "G"))
      lptr = root;

    if (lptr != NULL) {
      rp = 0;
      found = false;
      if (lptr->lct[nr - 1].p != NULL) {
	get_line(lptr->lct[nr - 1].p, &rp, lptr->lct[nr - 1].s, s);
	found = true;
      }
    }

    if (!found) {
      if (!strcmp(w2, "G")) {
	strcpy(s, "error: incorrect language definitions");
	found = true;
      } else
	strcpy(w2, "G");
    }

  } while (!found);

}


/*Loescht geladene Sprachen*/

void free_languages(languagetyp **root)
{
  languagetyp *hptr, *hp2;

  hptr = *root;
  while (hptr != NULL) {
    if (hptr->puffer != NULL)
      mymfreep(&hptr->puffer);
    hp2 = hptr;
    hptr = hptr->next;
    Free(hp2);
  }
  *root = NULL;
}


/* Ordnet ein Call einer Sprachanpassung zu */

void user_language(uchar **root, long *size, Char *fname, Char *call_,
		   Char *lan)
{
  Char call[256];
  long lz;
  boolean found;
  Char zl[256], w[256];

  strcpy(call, call_);
  upper(call);
  strcpy(lan, "G");
  if (*root == NULL)
    sfbread(true, fname, root, size);
  if (*root == NULL)
    return;
  lz = 0;
  found = false;
  while (found == false && lz < *size) {
    get_line(*root, &lz, *size, zl);
    get_word(zl, w);
    upper(w);
    found = (strpos2(call, w, 1) == 1);
  }
  if (found)
    get_word(zl, lan);
  upper(lan);
}


void load_languages(languagetyp **root, Char *pfad)
{
  short x;
  long sz, l;
  uchar *p1;
  languagetyp *hptr, *lptr;
  short result;
  DTA dirinfo;
  Char hs[256], w[256];
  Char sprache[256];
  Char pfad2[256];
  Char extension[256];
  Char STR1[256];

  free_languages(root);
  lptr = NULL;
  strcpy(pfad2, pfad);
  get_path(pfad2);
  result = sffirst(pfad, 0, &dirinfo);
  while (result == 0) {
    strcpy(sprache, dirinfo.d_fname);
    get_ext(sprache, extension);
    del_ext(sprache);
    hptr = Malloc(sizeof(languagetyp));
    if (*root == NULL)
      *root = hptr;
    hptr->next = NULL;
    if (lptr != NULL)
      lptr->next = hptr;
    sprintf(STR1, "%s%s.%s", pfad2, sprache, extension);
    sfbread(true, STR1, &hptr->puffer, &hptr->psize);
    if (hptr->puffer != NULL) {
      cut(sprache, 3);   /*da der user auch nicht mehr angeben kann...*/
      upper(sprache);
      strcpy(hptr->sprache, sprache);
      lptr = hptr;

      for (x = 0; x < maxlanguagelinedefs; x++)
	hptr->lct[x].p = NULL;

      sz = 0;
      while (sz < hptr->psize) {
	p1 = (uchar *)(&hptr->puffer[sz]);
	l = sz;
	get_line(hptr->puffer, &sz, hptr->psize, hs);
	get_word(hs, w);
	x = Str2int(w);
	if (x > 0 && x <= maxlanguagelinedefs && *hs != '\0') {
	  l = hptr->psize - l - strlen(w) - 1;
	  if (l > 0) {
	    hptr->lct[x - 1].p = (uchar *)(&p1[strlen(w) + 1]);
	    hptr->lct[x - 1].s = l;
	  }
	}
      }

    } else
      Free(hptr);
    result = sfnext(&dirinfo);
  }
}


void stripcr(Char *fn)
{
  short k, h;
  Char l[256], fn2[256];
  boolean bin, ok;
  uchar *p;
  long ps, err, fp1, fp2;

  ok = false;

  strcpy(fn2, fn);
  validate(fn2);

  k = sfopen(fn, FO_READ);
  if (k < minhandle)
    return;
  h = sfcreate(fn2, FC_FILE);
  if (h >= minhandle) {
    bin = false;
    ok = true;

    while (!bin && file_to_string(k, l)) {
      bin = (strpos2(l, "#BIN#", 1) == 1);
      string_to_file(&h, l, true);
    }

    if (bin) {
      fp1 = sfseek(0, k, SFSEEKCUR);
      fp2 = sfseek(0, k, SFSEEKEND);
      ps = fp2 - fp1 + 1;
      sfseek(fp1, k, SFSEEKSET);
      p = Malloc(ps);
      if (p != NULL) {
	err = sfread(k, ps, p);
	sfwrite(h, err, p);
	mymfree(&p);
      } else
	ok = false;
    }

    sfclose(&h);
  }

  sfclose(&k);

  if (ok) {
    sfdelfile(fn);
    sfrename(fn2, fn);
  }

}


boolean get_fileline(Char *fn, short line, Char *l)
{
  boolean Result;
  short k, c;

  Result = false;
  *l = '\0';
  k = sfopen(fn, FO_READ);
  if (k < minhandle)
    return Result;
  c = 1;
  while (file_to_string(k, l) && c < line)
    c++;
  Result = (c == line);
  sfclose(&k);
  return Result;
}


boolean get_keyline(Char *fn, Char *key, boolean casesense, Char *l)
{
  boolean Result;
  short k;
  boolean ok;
  Char l1[256], l2[256], k1[256];

  Result = false;
  *l = '\0';
  k = sfopen(fn, FO_READ);
  if (k < minhandle)
    return Result;
  if (casesense) {
    while (file_to_string(k, l) && strpos2(l, key, 1) != 1) ;
    Result = (strpos2(l, key, 1) == 1);
  } else {
    strcpy(k1, key);
    upper(k1);
    ok = false;
    while (!ok && file_to_string(k, l)) {
      strcpy(l1, l);
      upper(l1);
      get_word(l1, l2);
      ok = (strcmp(k1, l2) == 0);
    }
    Result = ok;

  }
  sfclose(&k);
  return Result;
}


boolean replace_keyline(Char *fn, Char *key, boolean casesense, Char *e)
{
  boolean Result;
  short k, h;
  boolean ok;
  Char l[256], l1[256], l2[256], k1[256];
  Char fn2[256];

  Result = false;

  strcpy(fn2, fn);
  validate(fn2);

  k = sfopen(fn, FO_READ);
  if (k < minhandle)
    return Result;
  h = sfcreate(fn2, FC_FILE);
  if (h >= minhandle) {
    if (casesense) {
      while (file_to_string(k, l) && strpos2(l, key, 1) != 1)
	string_to_file(&h, l, true);
      Result = (strpos2(l, key, 1) == 1);
      string_to_file(&h, e, true);
      while (file_to_string(k, l))
	string_to_file(&h, l, true);
    } else {
      strcpy(k1, key);
      upper(k1);
      ok = false;
      while (!ok && file_to_string(k, l)) {
	strcpy(l1, l);
	upper(l1);
	get_word(l1, l2);
	ok = (strcmp(k1, l2) == 0);
	if (!ok)
	  string_to_file(&h, l, true);
      }
      Result = ok;
      string_to_file(&h, e, true);
      while (file_to_string(k, l))
	string_to_file(&h, l, true);
    }
    sfclose(&h);
  }
  sfclose(&k);
  if (exist(fn2)) {
    sfdelfile(fn);
    sfrename(fn2, fn);
  }
  return Result;
}




/* ----------------------------------------- MD2 computation ----------------------------------------------- */



/* ------- start of RSA copyrighted code --------- */

/* some changes were made by Joachim Schurig 28/04/96 to encapsulate
   the code in PASCAL */

/*  Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
    rights reserved.

    License to copy and use this software is granted for
    non-commercial Internet Privacy-Enhanced Mail provided that it is
    identified as the "RSA Data Security, Inc. MD2 Message Digest
    Algorithm" in all material mentioning or referencing this software
    or this function.

    RSA Data Security, Inc. makes no representations concerning either
    the merchantability of this software or the suitability of this
    software for any particular purpose. It is provided "as is"
    without express or implied warranty of any kind.

    These notices must be retained in any copies of any part of this
    documentation and/or software.
  */


typedef uchar MD2barr16[16];

typedef struct MD2_CTX {
  MD2barr16 state, checksum;
  long count;
  MD2barr16 buffer;
} MD2_CTX;


/*
 *  Permutation of 0..255 constructed from the digits of pi. It gives a
 *  "random" nonlinear byte substitution operation.
 */


typedef uchar PI_SUBSTTYPE[256];


typedef MD2barr16 PADDINGTYPE[17];


Static PI_SUBSTTYPE PI_SUBST = {
  41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98,
  167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30,
  155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78,
  196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169,
  104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127,
  93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48,
  179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56,
  210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112,
  89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173,
  174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221,
  81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40,
  132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193,
  171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99,
  232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88,
  208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237,
  31, 26, 219, 153, 141, 51, 159, 17, 131, 20
};

Static PADDINGTYPE PADDING;
Static boolean PADDINGOK;
/* must be initialized with FALSE at program startup (Joachim Schurig) */

/*
 *  initializes the padding tab, cannot be assigned directly in PASCAL code
 *  added by Joachim Schurig
 */

Static void init_padding(void)
{
  short x, y;

  PADDING[0][0] = 0;

  for (x = 1; x <= 16; x++) {
    for (y = 0; y < x; y++)
      PADDING[x][y] = x;
  }

  PADDINGOK = true;
}

/* MD2 initialization. Begins an MD2 operation, writing a new context. */

Static void MD2Init(MD2_CTX *context)
{
  if (!PADDINGOK)   /* added for PASCAL */
    init_padding();
  context->count = 0;
  memset(context->state, 0, sizeof(MD2barr16));
  memset(context->checksum, 0, sizeof(MD2barr16));
}

/* MD2 basic transformation. Transforms state and updates checksum based on block. */

Static void MD2Transform(uchar *state, uchar *checksum, uchar *block)
{
  long i, j, t;
  uchar x[48];

  /* Form encryption block from state, block, state ^ block. */
  memcpy(x, state, 16);
  memcpy(&x[16], block, 16);
  for (i = 0; i <= 15; i++)
    x[i + 32] = state[i] ^ block[i];

  /* Encrypt block (18 rounds). */
  t = 0;
  for (i = 0; i <= 17; i++) {
    for (j = 0; j <= 47; j++) {
      t = x[j] ^ PI_SUBST[t];
      x[j] = t;
    }
    t = (t + i) & 0xff;
  }

  /* Save new state */
  memcpy(state, x, 16);

  /* Update checksum. */
  t = checksum[15];
  for (i = 0; i <= 15; i++) {
    t = checksum[i] ^ PI_SUBST[block[i] ^ t];
    checksum[i] = t;
  }

  /* Zeroize sensitive information. */
  memset(x, 0, sizeof(uchar) * 48);
}

/*
 *  MD2 block update operation. Continues an MD2 message-digest
 *  operation, processing another message block, and updating the
 *  context.
 */

Static void MD2Update(MD2_CTX *context, uchar *input, long inputLen)
{
  long i, index, partLen;

  /* Update number of bytes mod 16 */
  index = context->count;
  context->count = (index + inputLen) & 0xf;

  partLen = 16 - index;

  /* Transform as many times as possible. */
  if (inputLen >= partLen) {
    memcpy(&context->buffer[index], input, partLen);
    MD2Transform(context->state, context->checksum, context->buffer);

    i = partLen;
    while (i + 15 < inputLen) {
      MD2Transform(context->state, context->checksum, (uchar *)(&input[i]));
      i += 16;
    }

    index = 0;
  } else
    i = 0;

  /* Buffer remaining input */
  memcpy(&context->buffer[index], (uchar *)(&input[i]), inputLen - i);
}

/*
 *  MD2 finalization. Ends an MD2 message-digest operation, writing the
 *  message digest and zeroizing the context.
 */

Static void MD2Final(uchar *digest, MD2_CTX *context)
{
  long index, padLen;

  /* Pad out to multiple of 16 */
  index = context->count;
  padLen = 16 - index;
  MD2Update(context, PADDING[padLen], padLen);

  /* Extend with checksum */
  MD2Update(context, context->checksum, 16);

  /* Store state in digest */
  memcpy(digest, context->state, 16);

  /* Zeroize sensitive information */
  memset((uchar *)context, 0, sizeof(MD2_CTX));
}

/* ------- end of RSA copyrighted code ------- */



void calc_MD2_pw(Char *MD2prompt, Char *MD2pw, Char *MD2result)
{
  MD2_CTX context;
  MD2barr16 digest;
  short i, n, len;
  long bc;
  Char c1, c2;
  uchar *buffp;
  Char buff[256];
  short FORLIM;

  buffp = buff;
  bc = 0;
  FORLIM = strlen(MD2prompt);
  for (i = 0; i < FORLIM; i++) {
    buffp[bc] = MD2prompt[i];
    bc++;
  }
  FORLIM = strlen(MD2pw);
  for (i = 0; i < FORLIM; i++) {
    buffp[bc] = MD2pw[i];
    bc++;
  }

  buffp[bc] = 0;

  MD2Init(&context);
  len = bc;

  i = 0;

  while (i < len) {
    if (len - i > 16)
      n = 16;
    else
      n = len - i;
    MD2Update(&context, (uchar *)(&buffp[i]), n);
    i += 16;
  }
  MD2Final(digest, &context);

  MD2result[0] = '\0';
  for (i = 0; i <= 15; i++) {
    int2hchar(digest[i], &c1, &c2);
    sprintf(MD2result + strlen(MD2result), "%c%c", c1, c2);
  }
  lower(MD2result);
}


void calc_MD2_prompt(Char *MD2prompt)
{
  short x;
  Char c;

  MD2prompt[0] = '\0';
  for (x = 1; x <= 10; x++) {
    do {
      c = dp_randomize(48, 122);
    } while (!isalnum(c));
    sprintf(MD2prompt + strlen(MD2prompt), "%c", c);
  }
}


/* -------------------------------------------------------------------------------------------- */



void _tools_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  cpuspeed = 0;
  last_ixtime = 0;
  last_day = 0;
  PADDINGOK = false;   /* MD2 */
}
