/* Header for module tools, generated by p2c */
#ifndef TOOLS_H
#define TOOLS_H


#ifndef PASTRIX_H
#include "pastrix.h"
#endif


#ifdef TOOLS_G
# define vextern
#else
# define vextern extern
#endif


#define maxlanguagelinedefs  200


typedef struct clocktype {
  uchar day, mon, year, hour, min, sec;
  long ixtime, korrektur;
  Char zeit[9];
  Char datum[9];
  Char wochentag[21];
} clocktype;

typedef struct _REC_lct {
  uchar *p;
  long s;
} _REC_lct;

typedef struct languagetyp {
  struct languagetyp *next;
  Char sprache[9];
  uchar *puffer;
  long psize;
  _REC_lct lct[maxlanguagelinedefs];
} languagetyp;

typedef void (*wtag_rsc_type)(short x, short y, short z, Char *ret);


typedef void (*fdoutproctype)(short x, Char *s);


vextern languagetyp *langmemroot;
vextern clocktype clock_;
vextern wtag_rsc_type wtag_rsc_call;
vextern boolean fast_machine;


extern void calc_MD2_pw(Char *MD2prompt, Char *MD2pw, Char *MD2result);
extern void calc_MD2_prompt(Char *MD2prompt);
extern short calc_prozent(long v1, long v2);
extern void stripcr(Char *fn);
extern boolean insecure(Char *s);
extern boolean useq(Char *s1, Char *s2);
extern short uspos(Char *s1, Char *s2);
extern boolean get_fileline(Char *fn, short line, Char *l);
extern boolean get_keyline(Char *fn, Char *key, boolean casesense, Char *l);
extern boolean replace_keyline(Char *fn, Char *key, boolean casesense,
			       Char *e);
extern void expand_tabs(Char *hs, short tabsize);
extern void give_cookie(short x, fdoutproctype outproc, Char *fname);
extern void calc_ixsecs_to_string(long l, Char *hs);
extern void quick_speed(void);
extern long get_cpu_speed(short mode);
extern short filecp(Char *filea, Char *fileb, Char *root, boolean del_source,
		    short x, fdoutproctype outproc);
extern void file_delete(short x, Char *cmd, fdoutproctype outproc);
extern void file_dir(boolean supervisor, Char *path, Char *options, short x,
		     fdoutproctype outproc);
extern uchar calccs(Char *s);
extern uchar strcpycs(register char *s2, register char *s1);
extern long calcfdate(unsigned short date, unsigned short time);
extern long calc_ixtime(uchar d, uchar m, uchar y, uchar h, uchar mi, uchar s);
extern void decode_ixtime(long ix, uchar *d, uchar *m, uchar *y, uchar *h,
			  uchar *min, uchar *s);
extern void free_languages(languagetyp **root);
extern void user_language(uchar **root, long *size, Char *fname, Char *call,
			  Char *lan);
extern void load_languages(languagetyp **root, Char *pfad);
extern void get_language(short nr, languagetyp *root, Char *which, Char *s);
extern void wochentag(Char *lan, short d, short m, short y, Char *s);
extern void datum2string(unsigned short datum, Char *datestring);
extern void datum22string(short day, short mon, short year, Char *datestring);
extern void ixdatum2string(long datum, Char *datestring);
extern void zeit2string(unsigned short zeit, Char *timestring);
extern void zeit22string(short hour, short min, short sec, Char *timestring);
extern void ixzeit2string(long zeit, Char *timestring);
extern void ix2string(long zeit, Char *timestring);
extern long dos2ixtime(unsigned short ddate, unsigned short dtime);
extern void ix2dostime(long ix, unsigned short *ddate, unsigned short *dtime);
extern long string2ixtime(Char *ds, Char *ts);
extern unsigned short str2datum(Char *datestring);
extern unsigned short str2zeit(Char *timestring);
extern boolean compare(Char *w, Char *cmd);

extern void del_tnc3port(Char *callin, Char *callout);
extern void del_callextender(Char *callin, Char *callout);
extern void get_callextender(Char *callin, Char *callout);
extern boolean callsign(Char *rubrik);
extern void utc_clock(void);
extern long daydiff(unsigned short date1, unsigned short time1,
		    unsigned short date2, unsigned short time2);
extern unsigned short file_crc(short methode, Char *name,
			       unsigned short preload, long start, long size);


#undef vextern

#define sys_ixtime() time(NULL)

#endif /*TOOLS_H*/
