
# line 46 "../../amd/conf_parse.y"
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>

extern char *yytext;
extern int yylineno;
extern int yylex(void);

static int yyerror(const char *s);
static int retval;
static char *header_section = NULL; /* start with no header section */

#define YYDEBUG 1

#define PARSE_DEBUG 0

#if PARSE_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), yylineno, (s))
# define amu_return(v)
#else
# define dprintf(f,s)
# define amu_return(v) return((v))
#endif /* PARSE_DEBUG */


# line 74 "../../amd/conf_parse.y"
typedef union  {
char *strtype;
} YYSTYPE;
#ifdef __cplusplus
#  include <stdio.h>
#  include <yacc.h>
#endif	/* __cplusplus */ 
# define LEFT_BRACKET 257
# define RIGHT_BRACKET 258
# define EQUAL 259
# define NEWLINE 260
# define NONWS_STRING 261
# define NONWSEQ_STRING 262
# define QUOTED_NONWSEQ_STRING 263
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 149 "../../amd/conf_parse.y"


static int
yyerror(const char *s)
{
  fprintf(stderr, "AMDCONF: %s on line %d (section %s)\n",
	  s, yylineno,
	  (header_section ? header_section : "null"));
  exit(1);
  return 1;	/* to full compilers that insist on a return statement */
}
__YYSCLASS yytabelem yyexca[] ={
-1, 0,
	260, 1,
	-2, 3,
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 17
# define YYLAST 30
__YYSCLASS yytabelem yyact[]={

    21,    22,    23,    16,    15,    17,    27,    26,    25,    24,
     5,    19,    20,     9,    13,     6,     4,    14,     8,     7,
    10,     3,    11,    12,     2,     1,     0,     0,     0,    18 };
__YYSCLASS yytabelem yypact[]={

 -3000, -3000,  -250,  -244,  -244,  -250, -3000,  -244,  -257,  -256,
 -3000, -3000, -3000, -3000,  -257,  -248, -3000,  -246, -3000,  -261,
  -251,  -252,  -253,  -254, -3000, -3000, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,    25,    24,    16,    15,    21,    19,    18,    14,    17 };
__YYSCLASS yytabelem yyr1[]={

     0,     2,     1,     5,     1,     3,     3,     4,     4,     6,
     7,     8,     8,     9,     9,     9,     9 };
__YYSCLASS yytabelem yyr2[]={

     0,     1,     6,     1,     4,     2,     4,     2,     4,     4,
     9,     2,     4,     9,     9,     9,     2 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -1,    -2,    -5,    -3,   260,    -4,    -6,    -7,   257,
    -4,    -3,    -4,    -8,    -9,   261,   260,   261,    -8,   259,
   258,   261,   262,   263,   260,   260,   260,   260 };
__YYSCLASS yytabelem yydef[]={

    -2,    -2,     0,     0,     0,     5,     4,     7,     0,     0,
     2,     6,     8,     9,    11,     0,    16,     0,    12,     0,
     0,     0,     0,     0,    10,    13,    14,    15 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"LEFT_BRACKET",	257,
	"RIGHT_BRACKET",	258,
	"EQUAL",	259,
	"NEWLINE",	260,
	"NONWS_STRING",	261,
	"NONWSEQ_STRING",	262,
	"QUOTED_NONWSEQ_STRING",	263,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"file : /* empty */",
	"file : newlines map_sections",
	"file : /* empty */",
	"file : map_sections",
	"newlines : NEWLINE",
	"newlines : NEWLINE newlines",
	"map_sections : map_section",
	"map_sections : map_section map_sections",
	"map_section : sec_header kv_pairs",
	"sec_header : LEFT_BRACKET NONWS_STRING RIGHT_BRACKET NEWLINE",
	"kv_pairs : kv_pair",
	"kv_pairs : kv_pair kv_pairs",
	"kv_pair : NONWS_STRING EQUAL NONWS_STRING NEWLINE",
	"kv_pair : NONWS_STRING EQUAL NONWSEQ_STRING NEWLINE",
	"kv_pair : NONWS_STRING EQUAL QUOTED_NONWSEQ_STRING NEWLINE",
	"kv_pair : NEWLINE",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/

#ifdef YYREENTRANT
__thread int yydebug;		/* set to 1 to get debugging */
#else
int yydebug;			/* set to 1 to get debugging */
#endif

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH

#   ifdef YYREENTRANT
__thread __YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];  /* value stack */
__thread __YYSCLASS int yys[ YYMAXDEPTH ];      /* state stack */
#   else
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];           /* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];               /* state stack */
#   endif

# else

#  ifdef YYREENTRANT
__thread __YYSCLASS YYSTYPE *yyv;               /* pointer to malloc'ed stack st
value stack */
__thread __YYSCLASS int *yys;                   /* pointer to malloc'ed stack st
ack */
#  else
__YYSCLASS YYSTYPE *yyv;                        /* pointer to malloc'ed value st
ack */
__YYSCLASS int *yys;                            /* pointer to malloc'ed stack stack */
#  endif

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;


#ifdef YYREENTRANT

__thread __YYSCLASS YYSTYPE *yypv;      /* top of value stack */
__thread __YYSCLASS int *yyps;          /* top of state stack */

__thread __YYSCLASS int yystate;        /* current state */
__thread __YYSCLASS int yytmp;          /* extra var (lasts between blocks) */

__thread int yynerrs;                   /* number of errors */
__thread __YYSCLASS int yyerrflag;      /* error recovery flag */
__thread int yychar;                    /* current input token number */

__thread extern int yyinit_key;           /* init TLS data once */
extern int TLS_INIT; 

#else

__YYSCLASS YYSTYPE *yypv;               /* top of value stack */
__YYSCLASS int *yyps;                   /* top of state stack */

__YYSCLASS int yystate;                 /* current state */
__YYSCLASS int yytmp;                   /* extra var (lasts between blocks) */

int yynerrs;                            /* number of errors */
__YYSCLASS int yyerrflag;               /* error recovery flag */
int yychar;
#endif


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
l*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */


        /*
        ** Initialize externals - yyparse may be called more than once
        */

#ifdef YYREENTRANT
        if (yyinit_key != TLS_INIT)
        {
            yyinit_key = TLS_INIT; 
            yyinit_tls();
        }
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( (nl_msg(30003,"syntax error")) );
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 88 "../../amd/conf_parse.y"
{ yydebug = PARSE_DEBUG; } break;
case 3:
# line 89 "../../amd/conf_parse.y"
{ yydebug = PARSE_DEBUG; } break;
case 10:
# line 104 "../../amd/conf_parse.y"
{
		  if (yydebug)
		    fprintf(stderr, "sec_header1 = \"%s\"\n", yypvt[-2].strtype);
		  header_section = yypvt[-2].strtype;
		} break;
case 13:
# line 116 "../../amd/conf_parse.y"
{
		  if (yydebug)
		    fprintf(stderr,"parse1: key=\"%s\", val=\"%s\"\n", yypvt[-3].strtype, yypvt[-1].strtype);
		  retval = set_conf_kv(header_section, yypvt[-3].strtype, yypvt[-1].strtype);
		  if (retval != 0) {
		    yyerror("syntax error");
		    YYABORT;
		  }
		} break;
case 14:
# line 126 "../../amd/conf_parse.y"
{
		  if (yydebug)
		    fprintf(stderr,"parse2: key=\"%s\", val=\"%s\"\n", yypvt[-3].strtype, yypvt[-1].strtype);
		  retval = set_conf_kv(header_section, yypvt[-3].strtype, yypvt[-1].strtype);
		  if (retval != 0) {
		    yyerror("syntax error");
		    YYABORT;
		  }
		} break;
case 15:
# line 136 "../../amd/conf_parse.y"
{
		  if (yydebug)
		    fprintf(stderr,"parse3: key=\"%s\", val=\"%s\"\n", yypvt[-3].strtype, yypvt[-1].strtype);
		  retval = set_conf_kv(header_section, yypvt[-3].strtype, yypvt[-1].strtype);
		  if (retval != 0) {
		    yyerror("syntax error");
		    YYABORT;
		  }
		} break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

