# include "stdio.h"
#if defined(__cplusplus)
   extern "C" {
#endif
#if (defined(__cplusplus) || defined(__STDC__))
     extern int conf_reject();
     extern int conf_wrap();
     extern int conf_look();
     extern int conf_back(int *, int);
     extern int conf_input();
     extern void conf_output(int);
     extern void conf_unput(int);
     extern int conf_lex();
     extern int conf_less(int);
#ifdef LEXDEBUG
     extern void allprint();
     extern void sprint();
#endif
#if defined(__cplusplus)
   }
#endif
#endif	/* __cplusplus or __STDC__ */
# define U(x) x
# define NLSTATE conf_previous=YYNEWLINE
# define BEGIN conf_bgin = conf_svec + 1 +
# define INITIAL 0
# define YYLERR conf_svec
# define YYSTATE (conf_estate-conf_svec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,conf_out)
# define input() (((conf_tchar=conf_sptr>conf_sbuf?U(*--conf_sptr):getc(conf_in))==10?(conf_lineno++,conf_tchar):conf_tchar)==EOF?0:conf_tchar)
# define unput(c) {conf_tchar= (c);if(conf_tchar=='\n')conf_lineno--;*conf_sptr++=conf_tchar;}
# define conf_more() (conf_morfg=1)
# define ECHO fprintf(conf_out, "%s",conf_text)
# define REJECT { nstr = conf_reject(); goto conf_fussy;}
long conf_leng;
long conf_lenguc;
extern unsigned char conf_textarr[];
# ifdef YYCHAR_ARRAY
extern char conf_text[];
# else
extern unsigned char conf_text[];
# endif
int conf_posix_point=0;
int conf_nls16=0;
int conf_nls_wchar=0;
char *conf_locale = "C C C C C C";
int conf_morfg;
extern unsigned char *conf_sptr, conf_sbuf[];
int conf_tchar;
FILE *conf_in = {stdin}, *conf_out = {stdout};
extern int conf_lineno;
struct conf_svf { 
	int conf_stoff;
	struct conf_svf *conf_other;
	int *conf_stops;};
struct conf_svf *conf_estate;
extern struct conf_svf conf_svec[], *conf_bgin;
/*
 * Copyright (c) 1997-2006 Erez Zadok
 * Copyright (c) 1989 Jan-Simon Pendry
 * Copyright (c) 1989 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * File: am-utils/amd/conf_tok.l
 *
 */

/*
 * Lexical analyzer for AMD configuration parser.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
/*
 * Some systems include a definition for the macro ECHO in <sys/ioctl.h>,
 * and their (bad) version of lex defines it too at the very beginning of
 * the generated lex.conf_.c file (before it can be easily undefined),
 * resulting in a conflict.  So undefine it here before needed.
 * Luckily, it does not appear that this macro is actually used in the rest
 * of the generated lex.conf_.c file.
 */
#ifdef ECHO
# undef ECHO
#endif /* ECHO */
#include <am_defs.h>
#include <amd.h>
#include <conf_parse.h>
/* and once again undefine this, just in case */
#ifdef ECHO
# undef ECHO
#endif /* ECHO */

/*
 * There are some things that need to be defined only if using GNU flex.
 * These must not be defined if using standard lex
 */
#ifdef FLEX_SCANNER
# ifndef ECHO
#  define ECHO (void) fwrite( conf_text, conf_leng, 1, conf_out )
# endif /* not ECHO */
#endif /* FLEX_SCANNER */

int aconf_lineno = 0;

int conf_lex(void);
/*
 * some systems such as DU-4.x have a different GNU flex in /usr/bin
 * which automatically generates conf_wrap macros and symbols.  So I must
 * distinguish between them and when conf_wrap is actually needed.
 */
#ifndef conf_wrap
int conf_wrap(void);
#endif /* not conf_wrap */

#define TOK_DEBUG 0

#if TOK_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), aconf_lineno, (s))
# define amu_return(v)
#else /* not TOK_DEBUG */
# define dprintf(f,s)
# define amu_return(v) return((v))
#endif /* not TOK_DEBUG */

/* no need to use conf_wrap() */
#define YY_SKIP_YYWRAP

# define YYNEWLINE 10
conf_lex(){
   int nstr; extern int conf_previous;
   while((nstr = conf_look()) >= 0)
conf_fussy: switch(nstr){
case 0:
   if(conf_wrap()) return(0); break;
case 1:
		{
			aconf_lineno++;
			amu_return(NEWLINE);
			}
break;
case 2:
		{
			dprintf("%8d: Left bracket \"%s\"\n", conf_text);
			conf_lval.strtype = strdup((char *)conf_text);
			amu_return(LEFT_BRACKET);
			}
break;
case 3:
		{
			dprintf("%8d: Right bracket \"%s\"\n", conf_text);
			conf_lval.strtype = strdup((char *)conf_text);
			amu_return(RIGHT_BRACKET);
			}
break;
case 4:
		{
			dprintf("%8d: Equal \"%s\"\n", conf_text);
			conf_lval.strtype = strdup((char *)conf_text);
			amu_return(EQUAL);
			}
break;
case 5:
		{
			dprintf("%8d: Whitespace \"%s\"\n", conf_text);
			}
break;
case 6:
	{
			/* a comment line includes the terminating \n */
			aconf_lineno++;
			conf_text[strlen((char *)conf_text)-1] = '\0';
			dprintf("%8d: Comment \"%s\"\n", conf_text);
			}
break;
case 7:
{
			dprintf("%8d: Non-WS string \"%s\"\n", conf_text);
			conf_lval.strtype = strdup((char *)conf_text);
			amu_return(NONWS_STRING);
			}
break;
case 8:
{
			dprintf("%8d: QUOTED-Non-WS-EQ string \"%s\"\n", conf_text);
			/* must strip quotes */
			conf_text[strlen((char *)conf_text)-1] = '\0';
			conf_lval.strtype = strdup((char *)&conf_text[1]);
			amu_return(QUOTED_NONWSEQ_STRING);
			}
break;
case 9:
{
			dprintf("%8d: Non-WS-EQ string \"%s\"\n", conf_text);
			conf_lval.strtype = strdup((char *)conf_text);
			amu_return(NONWSEQ_STRING);
			}
break;
case -1:
break;
default:
   fprintf(conf_out,"bad switch conf_look %d",nstr);
} return(0); }
/* end of conf_lex */

#ifndef __cplusplus
static void __conf___unused() { main(); }
#endif

/*
 * some systems such as DU-4.x have a different GNU flex in /usr/bin
 * which automatically generates conf_wrap macros and symbols.  So I must
 * distinguish between them and when conf_wrap is actually needed.
 */
#ifndef conf_wrap
int conf_wrap(void)
{
  return 1;
}
#endif /* not conf_wrap */
int conf_vstop[] = {
0,

5,
0,

5,
0,

7,
9,
0,

5,
0,

1,
0,

7,
9,
0,

7,
9,
0,

4,
9,
0,

2,
0,

3,
0,

9,
0,

7,
9,
0,

9,
0,

6,
0,

9,
0,

7,
8,
9,
0,

8,
0,

8,
9,
0,
0};
# define YYTYPE unsigned char
struct conf_work { YYTYPE verify, advance; } conf_crank[] = {
{0,0},	{0,0},	{1,3},	{0,0},	
{0,0},	{0,0},	{0,0},	{3,3},	
{0,0},	{13,13},	{1,4},	{1,5},	
{6,12},	{14,14},	{7,7},	{3,0},	
{3,0},	{8,11},	{4,4},	{15,15},	
{6,13},	{6,13},	{7,15},	{7,16},	
{11,11},	{8,0},	{8,0},	{17,17},	
{18,0},	{18,0},	{0,0},	{0,0},	
{11,0},	{11,0},	{0,0},	{1,6},	
{1,7},	{2,7},	{3,0},	{12,18},	
{3,3},	{4,4},	{13,19},	{0,0},	
{0,0},	{6,3},	{14,20},	{7,7},	
{8,0},	{0,0},	{8,11},	{18,0},	
{15,15},	{0,0},	{0,0},	{11,0},	
{20,11},	{11,11},	{0,0},	{0,0},	
{17,17},	{0,0},	{1,8},	{0,0},	
{20,0},	{20,0},	{0,0},	{3,11},	
{0,0},	{13,13},	{0,0},	{0,0},	
{6,14},	{0,0},	{7,17},	{0,0},	
{0,0},	{0,0},	{0,0},	{15,15},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{20,0},	
{0,0},	{20,11},	{0,0},	{0,0},	
{1,9},	{0,0},	{1,10},	{2,10},	
{0,0},	{3,0},	{0,0},	{3,0},	
{0,0},	{0,0},	{6,13},	{0,0},	
{7,15},	{0,0},	{0,0},	{8,0},	
{0,0},	{8,0},	{18,0},	{0,0},	
{18,0},	{0,0},	{11,0},	{0,0},	
{11,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{0,0},	{0,0},	
{0,0},	{0,0},	{20,0},	{0,0},	
{20,0},	{0,0},	{0,0},	{0,0},	
{0,0}};
struct conf_svf conf_svec[] = {
{0,	0,	0},
{-1,	0,		conf_vstop+1},
{-2,	conf_svec+1,	conf_vstop+3},
{-6,	0,		conf_vstop+5},
{9,	0,		conf_vstop+8},
{0,	0,		conf_vstop+10},
{-11,	0,		conf_vstop+12},
{-13,	0,		conf_vstop+15},
{-16,	conf_svec+3,	conf_vstop+18},
{0,	0,		conf_vstop+21},
{0,	0,		conf_vstop+23},
{-23,	conf_svec+3,	conf_vstop+25},
{-5,	conf_svec+6,	conf_vstop+27},
{-8,	conf_svec+6,	0},	
{-12,	conf_svec+6,	conf_vstop+30},
{-18,	conf_svec+7,	0},	
{0,	0,		conf_vstop+32},
{-26,	conf_svec+7,	conf_vstop+34},
{-19,	conf_svec+3,	conf_vstop+36},
{0,	0,		conf_vstop+40},
{-55,	conf_svec+3,	conf_vstop+42},
{0,	0,	0}};
struct conf_work *conf_top = conf_crank+148;
struct conf_svf *conf_bgin = conf_svec+1;
unsigned char conf_match[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,'=' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,'[' ,01  ,'[' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char conf_extra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/* @(#) A.11.20.00 HP C LANGUAGE TOOL (NCFORM) 010501 $      */
#ifdef YYREENTRANT
__thread int conf_lineno;
#else
int conf_lineno = 1;
#endif   /* reentrant */

# define YYU(x) x
# define NLSTATE conf_previous=YYNEWLINE
 
#ifdef YYNLS16_WCHAR
#  ifdef YYREENTRANT
__thread unsigned char conf_textuc[YYLMAX * sizeof(wchar_t)];
#  else
unsigned char conf_textuc[YYLMAX * sizeof(wchar_t)];
#  endif   /* reentrant */

# ifdef YY_PCT_POINT /* for %pointer */
#   ifdef YYREENTRANT
__thread wchar_t conf_textarr[YYLMAX];
__thread wchar_t *conf_text;
#   else
wchar_t conf_textarr[YYLMAX];
wchar_t *conf_text;
#   endif            /* reentrant */
# else               /* %array */
#   ifdef YYREENTRANT
__thread wchar_t conf_textarr[YYLMAX];
__thread wchar_t conf_text[YYLMAX];
#   else
wchar_t conf_textarr[YYLMAX];
wchar_t conf_text[YYLMAX];
#   endif            /* reentrant */
# endif              /* YY_PCT_POINT */
#else

#  ifdef YYREENTRANT
__thread unsigned char conf_textuc;
#  else
unsigned char conf_textuc;
#  endif             /* reentrant */
# ifdef YY_PCT_POINT /* for %pointer */
#   ifdef YYREENTRANT
__thread unsigned char conf_textarr[YYLMAX];
__thread unsigned char *conf_text;
#   else
unsigned char conf_textarr[YYLMAX];
unsigned char *conf_text;
#   endif            /* reentrant */
# else               /* %array */
#   ifdef YYREENTRANT
__thread unsigned char conf_textarr[YYLMAX];
#   else
unsigned char conf_textarr[YYLMAX];
#   endif            /* reentrant */

# ifdef YYCHAR_ARRAY
#   ifdef YYREENTRANT
__thread char conf_text[YYLMAX];
#   else
char conf_text[YYLMAX];
#   endif            /* reentrant */
# else
#   ifdef YYREENTRANT
__thread unsigned char conf_text[YYLMAX];
#   else
unsigned char conf_text[YYLMAX];
#   endif            /* reentrant */
# endif              /* YYCHAR_ARRAY */
# endif              /* YY_PCT_POINT */
#endif               /* YYNLS16_WCHAR */


#ifdef YYREENTRANT
__thread struct conf_svf *conf_lstate[YYLMAX], **conf_lsp, **conf_olsp;
__thread unsigned char conf_sbuf[YYLMAX];

__thread unsigned char *conf_sptr;  /*  = conf_sbuf; */
__thread int *conf_fnd;
__thread extern struct conf_svf *conf_estate;
#else
struct conf_svf *conf_lstate [YYLMAX], **conf_lsp, **conf_olsp;
unsigned char conf_sbuf[YYLMAX];

unsigned char *conf_sptr = conf_sbuf; 
int *conf_fnd;
extern struct conf_svf *conf_estate;
#endif

#ifdef YYREENTRANT
__thread int conf_previous;  /* YYNEWLINE; */
#else
int conf_previous = YYNEWLINE; 
#endif



#ifdef YYREENTRANT
/*
 * initialize tls data.  These were global data and were init 
 * when declared.  Lex will always generate this function 
 * but invoke it only once.  
 */
conf_init_tls()
{
  conf_lineno = 1;
  conf_sptr = conf_sbuf;
  conf_previous = YYNEWLINE; 

  if (!conf_in) conf_in = stdin;
  if (!conf_out) conf_out = stdout; 
}
#endif

conf_look(){
	register struct conf_svf *conf_state, **lsp;
	register struct conf_work *conf_t;
	struct conf_svf *conf_z;
	int conf_ch, conf_first;
	struct conf_work *conf_r;
# ifdef LEXDEBUG
	int debug;
# endif
/*	char *conf_lastch;
 * ***** nls8 ***** */
	unsigned char *conf_lastch, sec, third, fourth;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	conf_first=1;
	if (!conf_morfg)
#ifdef YYNLS16_WCHAR
		conf_lastch = conf_textuc;
#else
# ifdef YYCHAR_ARRAY
		conf_lastch = (unsigned char *)conf_text;
# else
		conf_lastch = conf_text;
# endif
#endif
	else {
		conf_morfg=0;
#ifdef YYNLS16_WCHAR
		conf_lastch = conf_textuc+conf_lenguc;
#else
# ifdef YYCHAR_ARRAY
		conf_lastch = (unsigned char *)conf_text+conf_leng;
# else
		conf_lastch = conf_text+conf_leng;
# endif
#endif
		}
	for(;;){
		lsp = conf_lstate;
		conf_estate = conf_state = conf_bgin;
		if (conf_previous==YYNEWLINE) conf_state++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(conf_out,"state %d\n",conf_state-conf_svec-1);
# endif
			conf_t = &conf_crank[conf_state->conf_stoff];
			if(conf_t == conf_crank && !conf_first){  /* may not be any transitions */
				conf_z = conf_state->conf_other;
				if(conf_z == 0)break;
				if(conf_z->conf_stoff == 0)break;
				}
			*conf_lastch++ = conf_ch = input();
			conf_first=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(conf_out,"char ");
				allprint(conf_ch);
				putchar('\n');
				}
# endif
			conf_r = conf_t;

			if ((long)conf_t > (long)conf_crank){

				conf_t = conf_r + conf_ch;
				if (conf_t <= conf_top && conf_t->verify+conf_svec == conf_state){
					if(conf_t->advance+conf_svec == YYLERR)	/* error transitions */
						{unput(*--conf_lastch);break;}
					*lsp++ = conf_state = conf_t->advance+conf_svec;
					goto contin;
					}
				}
# ifdef YYOPTIM

			else if((long)conf_t < (long)conf_crank) {  /* r < conf_crank */

				conf_t = conf_r = conf_crank+(conf_crank-conf_t);
# ifdef LEXDEBUG
				if(debug)fprintf(conf_out,"compressed state\n");
# endif
				conf_t = conf_t + conf_ch;
				if(conf_t <= conf_top && conf_t->verify+conf_svec == conf_state){
					if(conf_t->advance+conf_svec == YYLERR)	/* error transitions */
						{unput(*--conf_lastch);break;}
					*lsp++ = conf_state = conf_t->advance+conf_svec;
					goto contin;
					}
				conf_t = conf_r + YYU(conf_match[conf_ch]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(conf_out,"try fall back character ");
					allprint(YYU(conf_match[conf_ch]));
					putchar('\n');
					}
# endif
				if(conf_t <= conf_top && conf_t->verify+conf_svec == conf_state){
					if(conf_t->advance+conf_svec == YYLERR)	/* error transition */
						{unput(*--conf_lastch);break;}
					*lsp++ = conf_state = conf_t->advance+conf_svec;
					goto contin;
					}
				}
			if ((conf_state = conf_state->conf_other) && (conf_t = &conf_crank[conf_state->conf_stoff]) != conf_crank){
# ifdef LEXDEBUG
				if(debug)fprintf(conf_out,"fall back to state %d\n",conf_state-conf_svec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--conf_lastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(conf_out,"state %d char ",conf_state-conf_svec-1);
				allprint(conf_ch);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(conf_out,"stopped at %d with ",*(lsp-1)-conf_svec-1);
			allprint(conf_ch);
			putchar('\n');
			}
# endif
		while (lsp-- > conf_lstate){
			*conf_lastch-- = 0;
			if (*lsp != 0 && (conf_fnd= (*lsp)->conf_stops) && *conf_fnd > 0){
				conf_olsp = lsp;
				if(conf_extra[*conf_fnd]){		/* must backup */
					while(conf_back((*lsp)->conf_stops,-*conf_fnd) != 1 && lsp > conf_lstate){
						lsp--;
						unput(*conf_lastch--);
						}
					}
				conf_previous = YYU(*conf_lastch);
				conf_lsp = lsp;
#ifdef YYNLS16_WCHAR
				conf_lenguc = conf_lastch-conf_textuc+1;
				conf_textuc[conf_lenguc] = 0;
#else
# ifdef YYCHAR_ARRAY
				conf_leng = conf_lastch-(unsigned char*)conf_text+1;
# else
				conf_leng = conf_lastch-conf_text+1;
# endif
				conf_text[conf_leng] = 0;
#endif
# ifdef LEXDEBUG
				if(debug){
					fprintf(conf_out,"\nmatch ");
#ifdef YYNLS16_WCHAR
					sprint(conf_textuc);
#else
					sprint(conf_text);
#endif
					fprintf(conf_out," action %d\n",*conf_fnd);
					}
# endif
				return(*conf_fnd++);
				}
			unput(*conf_lastch);
			}
#ifdef YYNLS16_WCHAR
		if (conf_textuc[0] == 0  /* && feof(conf_in) */)
#else
		if (conf_text[0] == 0  /* && feof(conf_in) */)
#endif
			{
			conf_sptr=conf_sbuf;
			return(0);
			}
#ifdef YYNLS16_WCHAR
		conf_previous = conf_textuc[0] = input();
#else
		conf_previous = conf_text[0] = input();
#endif
		if (conf_previous>0) {
			output(conf_previous);
#ifdef YYNLS16
                        if (conf_nls16) {
			int noBytes;
                        sec = input();
                        third = input();
                        fourth = input();
#ifdef YYNLS16_WCHAR
                        noBytes = MultiByte(conf_textuc[0],sec,third,fourth);
#else 
                        noBytes = MultiByte(conf_text[0],sec,third,fourth);
#endif          
     					switch(noBytes) {
     					case 2:
#ifdef YYNLS16_WCHAR
 						output(conf_previous=conf_textuc[0]=sec);
#else
 						output(conf_previous=conf_text[0]=sec);
#endif
                                                 unput(fourth);
                                                 unput(third);
                                                 break;
     					case 3:
#ifdef YYNLS16_WCHAR
 						output(conf_previous=conf_textuc[0]=sec);
 						output(conf_previous=conf_textuc[0]=third);
#else
 						output(conf_previous=conf_text[0]=sec);
 						output(conf_previous=conf_text[0]=third);
#endif
                                                 unput(fourth);
                                                 break; 
                                         case 4:
#ifdef YYNLS16_WCHAR
 						output(conf_previous=conf_textuc[0]=sec);
 						output(conf_previous=conf_textuc[0]=third);
 						output(conf_previous=conf_textuc[0]=fourth);
#else
 						output(conf_previous=conf_text[0]=sec);
 						output(conf_previous=conf_text[0]=third);
 						output(conf_previous=conf_text[0]=fourth);
#endif
                                                 break;                                                                                            
					default:
					        unput(fourth);
					        unput(third);
						unput(sec);
						break;
						}
					}
#endif
                }
#ifdef YYNLS16_WCHAR
		conf_lastch=conf_textuc;
#else
# ifdef YYCHAR_ARRAY
		conf_lastch=(unsigned char*)conf_text;
# else
		conf_lastch=conf_text;
# endif
#endif
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}

# ifdef __cplusplus
conf_back(int *p, int m)
# else
conf_back(p, m)
	int *p;
# endif
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
conf_input(){
	return(input());
	
	}

#if (defined(__cplusplus) || defined(__STDC__))
void conf_output(int c)
#else
conf_output(c)
  int c;
# endif
{
	output(c);
}

#if (defined(__cplusplus) || defined(__STDC__))
void conf_unput(int c)
#else
conf_unput(c)
   int c;
#endif
{
	unput(c);
}
