/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.SecretClientAuth;
import eu.unicore.uftp.client.UFTPProgressListener;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.DPCClient;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.jparss.PSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public abstract class AbstractUFTPClient
implements Runnable {
    public static final int SYNERR = 1;
    public static final int HOSTERR = 2;
    public static final int BUFFSIZE = 16384;
    private final InetAddress[] servers;
    private final int port;
    private int timeout = 3000;
    private int authtimeout = 0;
    private String secret;
    private int bufferSize = 131072;
    protected byte[] key;
    protected boolean compress = false;
    protected int numcons = 1;
    protected UFTPProgressListener progressListener = null;
    protected final DPCClient client = new DPCClient();
    protected Socket socket = null;
    protected InputStream reader = null;
    protected OutputStream writer = null;

    public AbstractUFTPClient(InetAddress[] servers, int port) {
        this.servers = servers;
        this.port = port;
    }

    public void connect() throws IOException, AuthorizationFailureException {
        this.client.setTimeout(this.timeout);
        this.client.setAuthTimeout(this.authtimeout);
        this.client.connect(this.servers, this.port, new SecretClientAuth(this.secret));
        this.socket = this.createSocket(this.numcons, this.client, this.key, this.compress);
    }

    protected void prepareGet(OutputStream localTarget) throws IOException {
        if (this.numcons == 1) {
            this.reader = this.key != null ? Utils.getDecryptStream(this.socket.getInputStream(), this.key) : this.socket.getInputStream();
            if (this.compress) {
                this.reader = Utils.getDecompressStream(this.reader);
            }
        } else {
            this.reader = this.socket.getInputStream();
        }
        this.writer = localTarget;
    }

    protected void preparePut(InputStream localSource) throws IOException {
        this.writer = this.socket.getOutputStream();
        if (this.numcons == 1) {
            if (this.key != null) {
                this.writer = Utils.getEncryptStream(this.writer, this.key);
            }
            if (this.compress) {
                this.writer = Utils.getCompressStream(this.writer);
            }
        }
        this.reader = localSource;
    }

    protected Socket createSocket(int numConnections, DPCClient client, byte[] key, boolean compress) throws IOException {
        Socket localSocket;
        if (numConnections > 1) {
            Socket[] dataCons = client.openDataConnections(numConnections);
            PSocket parallelSocket = new PSocket(key, compress);
            parallelSocket.init(1, dataCons.length);
            for (Socket dataCon : dataCons) {
                parallelSocket.addSocketStream(dataCon);
            }
            localSocket = parallelSocket;
        } else {
            localSocket = client.openDataConnections(1)[0];
        }
        return localSocket;
    }

    protected void cleanup() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNumConnections(int num) {
        if (num < 1) {
            throw new IllegalArgumentException();
        }
        this.numcons = num;
    }

    public int getNumConnections() {
        return this.numcons;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthtimeout() {
        return this.authtimeout;
    }

    public void setAuthtimeout(int authtimeout) {
        this.authtimeout = authtimeout;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getKey() {
        return this.key;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public UFTPProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(UFTPProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public InetAddress[] getServerList() {
        return this.servers;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }
}

