/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.indexer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassSession;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.entities.EntityInformation;
import org.compass.gps.device.hibernate.indexer.HibernateIndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class PaginationHibernateIndexEntitiesIndexer
implements HibernateIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog(PaginationHibernateIndexEntitiesIndexer.class);
    private HibernateGpsDevice device;

    public void setHibernateGpsDevice(HibernateGpsDevice device) {
        this.device = device;
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        block7: for (IndexEntity entity : entities) {
            EntityInformation entityInfo = (EntityInformation)entity;
            int fetchCount = this.device.getFetchCount();
            int current = 0;
            while (this.device.isRunning()) {
                Session hibernateSession = this.device.getSessionFactory().openSession();
                hibernateSession.setCacheMode(CacheMode.IGNORE);
                Transaction hibernateTransaction = null;
                try {
                    List values;
                    Criteria criteria;
                    hibernateTransaction = hibernateSession.beginTransaction();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)this.device.buildMessage("Indexing entity [" + entityInfo.getName() + "] range [" + current + "-" + (current + fetchCount) + "]"));
                    }
                    if ((criteria = entityInfo.getQueryProvider().createCriteria((org.hibernate.Session)hibernateSession, entityInfo)) != null) {
                        values = criteria.list();
                    } else {
                        Query query = entityInfo.getQueryProvider().createQuery((org.hibernate.Session)hibernateSession, entityInfo).setFirstResult(current).setMaxResults(fetchCount);
                        values = query.list();
                    }
                    for (Object value : values) {
                        session.create(value);
                    }
                    session.evictAll();
                    hibernateTransaction.commit();
                    session.close();
                    current += fetchCount;
                    if (values.size() >= fetchCount) continue;
                    continue block7;
                }
                catch (Exception e) {
                    log.error((Object)this.device.buildMessage("Failed to index the database"), (Throwable)e);
                    if (hibernateTransaction != null) {
                        try {
                            hibernateTransaction.rollback();
                        }
                        catch (Exception e1) {
                            log.warn((Object)"Failed to rollback Hibernate", (Throwable)e1);
                        }
                    }
                    if (!(e instanceof HibernateGpsDeviceException)) {
                        throw new HibernateGpsDeviceException(this.device.buildMessage("Failed to index the database"), e);
                    }
                    throw (HibernateGpsDeviceException)e;
                }
                finally {
                    hibernateSession.close();
                    continue;
                }
                break;
            }
            return;
        }
    }
}

