/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.accountprovisioning.provisioner;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.airavata.accountprovisioning.ConfigParam;
import org.apache.airavata.accountprovisioning.InvalidUsernameException;
import org.apache.airavata.accountprovisioning.SSHAccountManager;
import org.apache.airavata.accountprovisioning.SSHAccountProvisioner;
import org.apache.airavata.accountprovisioning.provisioner.IULdapSSHAccountProvisionerProvider;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IULdapSSHAccountProvisioner
implements SSHAccountProvisioner {
    private static final Logger logger = LoggerFactory.getLogger(SSHAccountManager.class);
    public static final String LDAP_PUBLIC_KEY_OBJECT_CLASS = "ldapPublicKey";
    public static final String SSH_PUBLIC_KEY_ATTRIBUTE_NAME = "sshPublicKey";
    public static final String GROUP_MEMBER_ATTRIBUTE_NAME = "memberUid";
    private String ldapHost;
    private String ldapUsername;
    private String ldapPassword;
    private String ldapBaseDN;
    private String canonicalScratchLocation;
    private String cybergatewayGroupDN;
    private int ldapPort;

    @Override
    public void init(Map<ConfigParam, String> config) {
        this.ldapHost = config.get(IULdapSSHAccountProvisionerProvider.LDAP_HOST);
        this.ldapPort = Integer.valueOf(config.get(IULdapSSHAccountProvisionerProvider.LDAP_PORT));
        this.ldapUsername = config.get(IULdapSSHAccountProvisionerProvider.LDAP_USERNAME);
        this.ldapPassword = config.get(IULdapSSHAccountProvisionerProvider.LDAP_PASSWORD);
        this.ldapBaseDN = config.get(IULdapSSHAccountProvisionerProvider.LDAP_BASE_DN);
        this.canonicalScratchLocation = config.get(IULdapSSHAccountProvisionerProvider.CANONICAL_SCRATCH_LOCATION);
        this.cybergatewayGroupDN = config.get(IULdapSSHAccountProvisionerProvider.CYBERGATEWAY_GROUP_DN);
    }

    @Override
    public boolean hasAccount(String userId) throws InvalidUsernameException {
        String username = this.getUsername(userId);
        boolean result = this.withLdapConnection(ldapConnection -> {
            try {
                return this.hasClusterAccount((LdapConnection)ldapConnection, username);
            }
            catch (LdapException e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    private boolean hasClusterAccount(LdapConnection ldapConnection, String username) throws LdapException {
        return ldapConnection.exists("uid=" + username + "," + this.ldapBaseDN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInCybergatewayGroup(LdapConnection ldapConnection, String username) throws LdapException {
        String filter = "(memberUid=" + username + ")";
        try (EntryCursor entryCursor = ldapConnection.search(this.cybergatewayGroupDN, filter, SearchScope.OBJECT, new String[0]);){
            int count = 0;
            for (Entry entry : entryCursor) {
                ++count;
                logger.info("Found {} in cybergateway group", (Object)username);
            }
            boolean bl = count == 1;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createAccount(String userId, String sshPublicKey) throws InvalidUsernameException {
        throw new UnsupportedOperationException("IULdapSSHAccountProvisioner does not support creating cluster accounts at this time.");
    }

    @Override
    public boolean isSSHAccountProvisioningComplete(String userId, String sshPublicKey) throws InvalidUsernameException {
        String username = this.getUsername(userId);
        boolean result = this.withLdapConnection(ldapConnection -> {
            try {
                return this.hasClusterAccount((LdapConnection)ldapConnection, username) && this.isInCybergatewayGroup((LdapConnection)ldapConnection, username) && this.isSSHKeyInstalled((LdapConnection)ldapConnection, username, sshPublicKey);
            }
            catch (LdapException e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    public boolean isSSHKeyInstalled(LdapConnection ldapConnection, String username, String sshPublicKey) throws LdapException {
        String ldapPublicKey = this.getLdapPublicKey(ldapConnection, username);
        return ldapPublicKey != null && ldapPublicKey.equals(sshPublicKey.trim());
    }

    @Override
    public String installSSHKey(String userId, String sshPublicKey) throws InvalidUsernameException {
        String username = this.getUsername(userId);
        String finalSSHPublicKey = sshPublicKey.trim();
        boolean success = this.withLdapConnection(ldapConnection -> {
            try {
                if (!this.isSSHKeyInstalled((LdapConnection)ldapConnection, username, finalSSHPublicKey)) {
                    this.installLdapPublicKey((LdapConnection)ldapConnection, username, finalSSHPublicKey);
                }
                if (!this.isInCybergatewayGroup((LdapConnection)ldapConnection, username)) {
                    this.addUserToCybergatewayGroup((LdapConnection)ldapConnection, username);
                }
                return true;
            }
            catch (LdapException e) {
                throw new RuntimeException(e);
            }
        });
        return username;
    }

    private void addUserToCybergatewayGroup(LdapConnection ldapConnection, String username) throws LdapException {
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(new Dn(new String[]{this.cybergatewayGroupDN}));
        modifyRequest.addModification((Attribute)new DefaultAttribute(GROUP_MEMBER_ATTRIBUTE_NAME, new String[]{username}), ModificationOperation.ADD_ATTRIBUTE);
        ModifyResponse modifyResponse = ldapConnection.modify((ModifyRequest)modifyRequest);
        if (modifyResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            logger.warn("add member to cybergateway group ldap operation reported not being successful: " + modifyResponse);
        } else {
            logger.debug("add member to cybergateway group ldap operation was successful: " + modifyResponse);
        }
    }

    private void installLdapPublicKey(LdapConnection ldapConnection, String username, String finalSSHPublicKey) throws LdapException {
        String dn = "uid=" + username + "," + this.ldapBaseDN;
        String ldapPublicKey = this.getLdapPublicKey(ldapConnection, username);
        Entry entry = ldapConnection.lookup(dn);
        if (entry == null) {
            throw new RuntimeException("User [" + username + "] has no entry for " + dn);
        }
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(new Dn(new String[]{dn}));
        if (ldapPublicKey == null) {
            modifyRequest.addModification((Attribute)new DefaultAttribute("objectclass", new String[]{LDAP_PUBLIC_KEY_OBJECT_CLASS}), ModificationOperation.ADD_ATTRIBUTE);
            modifyRequest.addModification((Attribute)new DefaultAttribute(SSH_PUBLIC_KEY_ATTRIBUTE_NAME, new String[]{finalSSHPublicKey}), ModificationOperation.ADD_ATTRIBUTE);
        } else if (!ldapPublicKey.equals(finalSSHPublicKey)) {
            modifyRequest.addModification((Attribute)new DefaultAttribute(SSH_PUBLIC_KEY_ATTRIBUTE_NAME, new String[]{finalSSHPublicKey}), ModificationOperation.REPLACE_ATTRIBUTE);
        }
        ModifyResponse modifyResponse = ldapConnection.modify((ModifyRequest)modifyRequest);
        if (modifyResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
            logger.warn("installSSHKey ldap operation reported not being successful: " + modifyResponse);
        } else {
            logger.debug("installSSHKey ldap operation was successful: " + modifyResponse);
        }
    }

    private String getLdapPublicKey(LdapConnection ldapConnection, String username) throws LdapException {
        String dn = "uid=" + username + "," + this.ldapBaseDN;
        Entry entry = ldapConnection.lookup(dn);
        if (entry == null) {
            throw new RuntimeException("User [" + username + "] has no entry for " + dn);
        }
        boolean hasLdapPublicKey = entry.hasObjectClass(new String[]{LDAP_PUBLIC_KEY_OBJECT_CLASS});
        return hasLdapPublicKey ? entry.get(SSH_PUBLIC_KEY_ATTRIBUTE_NAME).getString() : null;
    }

    @Override
    public String getScratchLocation(String userId) throws InvalidUsernameException {
        String username = this.getUsername(userId);
        String scratchLocation = this.canonicalScratchLocation.replace("${username}", username);
        return scratchLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R withLdapConnection(Function<LdapConnection, R> function) {
        try (LdapNetworkConnection connection = new LdapNetworkConnection(this.ldapHost, this.ldapPort, true);){
            connection.bind(this.ldapUsername, this.ldapPassword);
            R result = function.apply((LdapConnection)connection);
            connection.unBind();
            R r = result;
            return r;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }

    private String getUsername(String userId) throws InvalidUsernameException {
        int atSignIndex = userId.indexOf("@");
        if (atSignIndex < 0) {
            throw new InvalidUsernameException("userId is not an email address: " + userId);
        }
        return userId.substring(0, atSignIndex);
    }

    public static void main(String[] args) throws InvalidUsernameException {
        String ldapPassword = args[0];
        IULdapSSHAccountProvisioner sshAccountProvisioner = new IULdapSSHAccountProvisioner();
        HashMap<ConfigParam, String> config = new HashMap<ConfigParam, String>();
        config.put(IULdapSSHAccountProvisionerProvider.LDAP_HOST, "bazooka.hps.iu.edu");
        config.put(IULdapSSHAccountProvisionerProvider.LDAP_PORT, "9000");
        config.put(IULdapSSHAccountProvisionerProvider.LDAP_USERNAME, "cn=sgrcusr,dc=rt,dc=iu,dc=edu");
        config.put(IULdapSSHAccountProvisionerProvider.LDAP_PASSWORD, ldapPassword);
        config.put(IULdapSSHAccountProvisionerProvider.LDAP_BASE_DN, "ou=bigred2-sgrc,dc=rt,dc=iu,dc=edu");
        config.put(IULdapSSHAccountProvisionerProvider.CANONICAL_SCRATCH_LOCATION, "/N/dc2/scratch/${username}/iu-gateway");
        config.put(IULdapSSHAccountProvisionerProvider.CYBERGATEWAY_GROUP_DN, "cn=cybergateway,ou=Group,dc=rt,dc=iu,dc=edu");
        sshAccountProvisioner.init(config);
        String userId = "machrist@iu.edu";
        System.out.println("hasAccount=" + sshAccountProvisioner.hasAccount(userId));
        System.out.println("scratchLocation=" + sshAccountProvisioner.getScratchLocation(userId));
        String sshPublicKey = "foobar12345";
        boolean sshAccountProvisioningComplete = sshAccountProvisioner.isSSHAccountProvisioningComplete(userId, sshPublicKey);
        System.out.println("isSSHAccountProvisioningComplete=" + sshAccountProvisioningComplete);
        if (!sshAccountProvisioningComplete) {
            sshAccountProvisioner.installSSHKey(userId, sshPublicKey);
            sshAccountProvisioningComplete = sshAccountProvisioner.isSSHAccountProvisioningComplete(userId, sshPublicKey);
            System.out.println("isSSHAccountProvisioningComplete=" + sshAccountProvisioningComplete);
        }
    }
}

