/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.util.PoolException;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class Pool<T> {
    int INFINITY = -1;
    int MAX_SIZE = 1000;
    List<T> stack = new LinkedList<T>();
    static int inUse = 0;
    static int maxStackSize = 0;
    static int stopValue = 0;

    public abstract T create();

    public abstract void destroy(T var1);

    public Pool(int maximumSize) {
        this.MAX_SIZE = maximumSize;
    }

    public Pool() {
    }

    protected int maxStackSize() {
        if (maxStackSize < this.stack.size()) {
            maxStackSize = this.stack.size();
        }
        return maxStackSize;
    }

    public T pop() {
        T t = null;
        try {
            if (!this.stack.isEmpty()) {
                t = this.stack.remove(0);
            }
        }
        catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
            // empty catch block
        }
        if (t == null) {
            t = this.realCreate();
        }
        ++inUse;
        return t;
    }

    protected T realCreate() {
        if (this.MAX_SIZE == this.INFINITY || inUse < this.MAX_SIZE) {
            T t = this.create();
            this.maxStackSize();
            return t;
        }
        throw new PoolException("Error: Maximum capacity of " + this.MAX_SIZE + " elements has been exceeded");
    }

    public void realDestroy(T t) {
        this.destroy(t);
        --inUse;
    }

    public void push(T t) {
        if (this.MAX_SIZE <= this.stack.size()) {
            this.realDestroy(t);
            return;
        }
        if (this.stack.contains(t)) {
            throw new PoolException("Error: This element has already been checked into the pool");
        }
        this.stack.add(0, t);
        --inUse;
    }

    public boolean clear() {
        boolean ok = true;
        while (!this.stack.isEmpty()) {
            try {
                this.destroy(this.pop());
                --inUse;
            }
            catch (Exception x) {
                ok = false;
            }
        }
        return ok;
    }
}

