/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class MyXmlWriteApp {
    private static final String NAMESPACE = "http://www.megginson.com/ns/exp/poetry";

    public static void main(String[] args) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        XmlSerializer serializer = factory.newSerializer();
        System.out.println("serializer implementation class is " + serializer.getClass());
        boolean addNewLine = false;
        for (int argPos = 0; argPos < args.length; ++argPos) {
            String arg = args[argPos];
            if ("-n".equals(arg)) {
                addNewLine = true;
                continue;
            }
            if (!"-i".equals(arg)) continue;
            String s = args[++argPos];
            int indentSize = Integer.parseInt(s);
            StringBuffer buf = new StringBuffer(indentSize);
            for (int i = 0; i < indentSize; ++i) {
                buf.append(' ');
            }
            String indent = buf.toString();
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", indent);
        }
        serializer.setOutput(new PrintWriter(System.out));
        serializer.startDocument(null, null);
        serializer.ignorableWhitespace("\n\n");
        serializer.setPrefix("", NAMESPACE);
        serializer.startTag(NAMESPACE, "poem");
        if (addNewLine) {
            serializer.text("\n");
        }
        serializer.startTag(NAMESPACE, "title");
        serializer.text("Roses are Red");
        serializer.endTag(NAMESPACE, "title");
        if (addNewLine) {
            serializer.text("\n");
        }
        serializer.startTag(NAMESPACE, "l").text("Roses are red,").endTag(NAMESPACE, "l");
        if (addNewLine) {
            serializer.text("\n");
        }
        serializer.startTag(NAMESPACE, "l").text("Violets are blue;").endTag(NAMESPACE, "l");
        if (addNewLine) {
            serializer.text("\n");
        }
        MyXmlWriteApp.writeLine(serializer, "Sugar is sweet,", addNewLine);
        MyXmlWriteApp.writeLine(serializer, "And I love you.,", addNewLine);
        serializer.endTag(NAMESPACE, "poem");
        serializer.endDocument();
    }

    private static void writeLine(XmlSerializer serializer, String line, boolean addNewLine) throws IOException {
        serializer.startTag(NAMESPACE, "l");
        serializer.text(line);
        serializer.endTag(NAMESPACE, "l");
        if (addNewLine) {
            serializer.text("\n");
        }
    }
}

