/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import java.util.Date;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;

public class OCSPResult {
    public static final String[] REASONS = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};
    private Status status;
    private Date revocationTime;
    private String revocationReason;

    public OCSPResult(Status status) {
        this.status = status;
        if (status == Status.revoked) {
            throw new IllegalArgumentException("Can not create OCSPStatus object with revoked status without an OCSP reply");
        }
    }

    public OCSPResult(SingleResp resp) {
        CertificateStatus rStatus = resp.getCertStatus();
        if (rStatus == null) {
            this.status = Status.good;
        } else if (rStatus instanceof UnknownStatus) {
            this.status = Status.unknown;
        } else {
            this.status = Status.revoked;
            RevokedStatus revStatus = (RevokedStatus)rStatus;
            this.revocationTime = revStatus.getRevocationTime();
            this.revocationReason = revStatus.hasRevocationReason() ? REASONS[revStatus.getRevocationReason()] : REASONS[0];
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getRevocationTime() {
        return this.revocationTime;
    }

    public String getRevocationReason() {
        return this.revocationReason;
    }

    public String toString() {
        if (this.status != Status.revoked) {
            return this.status.toString();
        }
        return "revoked at " + this.revocationTime + (this.revocationReason != null ? " (" + this.revocationReason + ")" : "");
    }

    public static enum Status {
        good,
        revoked,
        unknown;

    }
}

