/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy;

import edu.uiuc.ncsa.myproxy.MPCProvider;
import edu.uiuc.ncsa.myproxy.MyProxyLogon;
import edu.uiuc.ncsa.myproxy.ServiceFacadeConfiguration;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.ssl.SSLKeystoreConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;

public class MyProxyServiceFacade {
    SSLKeystoreConfiguration sslKeystoreConfiguration;
    ServiceFacadeConfiguration facadeConfiguration;
    static KeyManagerFactory keyManagerFactory;

    protected int getLOAPort(String id) {
        if (id == null || id.length() == 0 || this.facadeConfiguration.loas == null || this.facadeConfiguration.loas.isEmpty()) {
            return this.facadeConfiguration.getPort();
        }
        Integer x = this.facadeConfiguration.loas.get(id);
        if (x == null) {
            return this.facadeConfiguration.getPort();
        }
        return x;
    }

    public MyProxyServiceFacade(ServiceFacadeConfiguration facadeConfiguration) {
        this.facadeConfiguration = facadeConfiguration;
        this.sslKeystoreConfiguration = new SSLKeystoreConfiguration();
        this.sslKeystoreConfiguration.setUseDefaultJavaKeyStore(true);
    }

    public MyProxyServiceFacade(ServiceFacadeConfiguration facadeConfiguration, SSLKeystoreConfiguration sslKeystoreConfiguration) {
        this.facadeConfiguration = facadeConfiguration;
        this.sslKeystoreConfiguration = sslKeystoreConfiguration;
    }

    public ServiceFacadeConfiguration getFacadeConfiguration() {
        return this.facadeConfiguration;
    }

    public SSLKeystoreConfiguration getSslKeystoreConfiguration() {
        return this.sslKeystoreConfiguration;
    }

    public boolean hasSSL() {
        return this.sslKeystoreConfiguration != null;
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, String password, int port, byte[] derCertRequest) throws IOException, GeneralSecurityException {
        return this.getCerts(userDN, password, port, 0L, derCertRequest);
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, int port, long lifetime, byte[] derCertRequest) throws IOException, GeneralSecurityException {
        return this.getCerts(userDN, null, port, lifetime, derCertRequest);
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, String password, int port, long lifetime, byte[] derCertRequest) throws IOException, GeneralSecurityException {
        MyProxyLogon myproxy = new MyProxyLogon();
        myproxy.setUsername(userDN);
        if (port < 0) {
            myproxy.setPort(this.getFacadeConfiguration().getPort());
        } else {
            myproxy.setPort(port);
        }
        myproxy.setHost(this.getFacadeConfiguration().getHostname());
        if (password == null) {
            myproxy.setPassphrase("");
        } else {
            myproxy.setPassphrase(password);
        }
        if (lifetime != 0L) {
            myproxy.setLifetime((int)(lifetime / 1000L));
        }
        myproxy.setKeyManagerFactory(this.getKeyManagerFactory());
        myproxy.connect();
        myproxy.logon();
        myproxy.getCredentials(derCertRequest);
        myproxy.disconnect();
        if (myproxy.getCertificates() == null || myproxy.getCertificates().isEmpty()) {
            throw new GeneralException("Error: MyProxy did not return a certificate");
        }
        return myproxy.getCertificates();
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, String password, long lifetime, byte[] derCertRequest, String loa) throws IOException, GeneralSecurityException {
        int port = 0;
        port = this.getLOAPort(loa);
        return this.getCerts(userDN, password, port, lifetime, derCertRequest);
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, String password, long lifetime, byte[] derCertRequest) throws IOException, GeneralSecurityException {
        return this.getCerts(userDN, password, this.getFacadeConfiguration().getPort(), lifetime, derCertRequest);
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, String password, byte[] derCertRequest, long lifetime) throws IOException, GeneralSecurityException {
        return this.getCerts(userDN, password, this.getFacadeConfiguration().getPort(), lifetime, derCertRequest);
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, byte[] derCertRequest, long lifetime, String loa) throws IOException, GeneralSecurityException {
        return this.getCerts(userDN, null, lifetime, derCertRequest, loa);
    }

    public synchronized Collection<X509Certificate> getCerts(String userDN, long lifetime, byte[] derCertRequest, String loa) throws IOException, GeneralSecurityException {
        return this.getCerts(userDN, null, lifetime, derCertRequest, loa);
    }

    protected KeyManagerFactory getKeyManagerFactory() throws IOException, GeneralSecurityException {
        if (keyManagerFactory == null) {
            keyManagerFactory = KeyManagerFactory.getInstance(this.getSslKeystoreConfiguration().getKeyManagerFactory());
            KeyStore ks = KeyStore.getInstance(this.getSslKeystoreConfiguration().getKeystoreType());
            FileInputStream fis = new FileInputStream(this.getSslKeystoreConfiguration().getKeystore());
            ks.load(fis, this.getSslKeystoreConfiguration().getKeystorePasswordChars());
            keyManagerFactory.init(ks, this.getSslKeystoreConfiguration().getKeystorePasswordChars());
        }
        return keyManagerFactory;
    }

    public MPCProvider getMPCProvider(String username, String password, String loa, long lifetime) throws IOException, GeneralSecurityException {
        return new MPCProvider(username, password, this.getFacadeConfiguration().getHostname(), this.getLOAPort(loa), lifetime, this.getKeyManagerFactory());
    }
}

