/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaDerivationMethod;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceContextOwner;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;

public class XmlSchema
extends XmlSchemaAnnotated
implements NamespaceContextOwner {
    private static final String UTF_8_ENCODING = "UTF-8";
    static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    XmlSchemaForm attributeFormDefault;
    XmlSchemaForm elementFormDefault;
    XmlSchemaObjectTable attributeGroups;
    XmlSchemaObjectTable attributes;
    XmlSchemaObjectTable elements;
    XmlSchemaObjectTable groups;
    XmlSchemaObjectTable notations;
    XmlSchemaObjectTable schemaTypes;
    XmlSchemaDerivationMethod blockDefault;
    XmlSchemaDerivationMethod finalDefault;
    XmlSchemaObjectCollection includes;
    XmlSchemaObjectCollection items;
    boolean isCompiled;
    String syntacticalTargetNamespace;
    String logicalTargetNamespace;
    String version;
    String schema_ns_prefix = "";
    XmlSchemaCollection parent;
    private NamespacePrefixList namespaceContext;
    private String inputEncoding;

    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    public XmlSchema(XmlSchemaCollection parent) {
        this(null, null, parent);
    }

    public XmlSchema() {
        this(null, null, null);
    }

    public XmlSchema(String namespace, String systemId, XmlSchemaCollection parent) {
        this.parent = parent;
        this.attributeFormDefault = new XmlSchemaForm("unqualified");
        this.elementFormDefault = new XmlSchemaForm("unqualified");
        this.blockDefault = new XmlSchemaDerivationMethod("none");
        this.finalDefault = new XmlSchemaDerivationMethod("none");
        this.items = new XmlSchemaObjectCollection();
        this.includes = new XmlSchemaObjectCollection();
        this.elements = new XmlSchemaObjectTable();
        this.attributeGroups = new XmlSchemaObjectTable();
        this.attributes = new XmlSchemaObjectTable();
        this.groups = new XmlSchemaObjectTable();
        this.notations = new XmlSchemaObjectTable();
        this.schemaTypes = new XmlSchemaObjectTable();
        this.syntacticalTargetNamespace = this.logicalTargetNamespace = namespace;
        if (this.logicalTargetNamespace == null) {
            this.logicalTargetNamespace = "";
        }
        if (parent != null) {
            XmlSchemaCollection.SchemaKey schemaKey = new XmlSchemaCollection.SchemaKey(this.logicalTargetNamespace, systemId);
            if (parent.containsSchema(schemaKey)) {
                throw new XmlSchemaException("Schema name conflict in collection");
            }
            parent.addSchema(schemaKey, this);
        }
    }

    public XmlSchema(String namespace, XmlSchemaCollection parent) {
        this(namespace, namespace, parent);
    }

    public XmlSchemaForm getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setAttributeFormDefault(XmlSchemaForm value) {
        this.attributeFormDefault = value;
    }

    public XmlSchemaObjectTable getAttributeGroups() {
        return this.attributeGroups;
    }

    public XmlSchemaObjectTable getAttributes() {
        return this.attributes;
    }

    public XmlSchemaDerivationMethod getBlockDefault() {
        return this.blockDefault;
    }

    public void setBlockDefault(XmlSchemaDerivationMethod blockDefault) {
        this.blockDefault = blockDefault;
    }

    public XmlSchemaForm getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(XmlSchemaForm elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public XmlSchemaObjectTable getElements() {
        return this.elements;
    }

    protected XmlSchemaElement getElementByName(QName name, boolean deep, Stack schemaStack) {
        if (schemaStack != null && schemaStack.contains(this)) {
            return null;
        }
        XmlSchemaElement element = (XmlSchemaElement)this.elements.getItem(name);
        if (deep) {
            if (element == null) {
                Iterator includedItems = this.includes.getIterator();
                while (includedItems.hasNext()) {
                    XmlSchema schema = this.getSchema(includedItems.next());
                    if (schema == null) continue;
                    if (schemaStack == null) {
                        schemaStack = new Stack<XmlSchema>();
                    }
                    schemaStack.push(this);
                    element = schema.getElementByName(name, deep, schemaStack);
                    if (element == null) continue;
                    return element;
                }
            } else {
                return element;
            }
        }
        return element;
    }

    protected XmlSchemaAttribute getAttributeByName(QName name, boolean deep, Stack schemaStack) {
        if (schemaStack != null && schemaStack.contains(this)) {
            return null;
        }
        XmlSchemaAttribute attribute = (XmlSchemaAttribute)this.attributes.getItem(name);
        if (deep) {
            if (attribute == null) {
                Iterator includedItems = this.includes.getIterator();
                while (includedItems.hasNext()) {
                    XmlSchema schema = this.getSchema(includedItems.next());
                    if (schema == null) continue;
                    if (schemaStack == null) {
                        schemaStack = new Stack<XmlSchema>();
                    }
                    schemaStack.push(this);
                    attribute = schema.getAttributeByName(name, deep, schemaStack);
                    if (attribute == null) continue;
                    return attribute;
                }
            } else {
                return attribute;
            }
        }
        return attribute;
    }

    public XmlSchemaElement getElementByName(String name) {
        QName nameToSearchFor = new QName(this.getTargetNamespace(), name);
        return this.getElementByName(nameToSearchFor, false, null);
    }

    public XmlSchemaElement getElementByName(QName name) {
        return this.getElementByName(name, true, null);
    }

    public XmlSchemaAttribute getAttributeByName(QName name) {
        return this.getAttributeByName(name, true, null);
    }

    protected XmlSchemaType getTypeByName(QName name, boolean deep, Stack schemaStack) {
        if (schemaStack != null && schemaStack.contains(this)) {
            return null;
        }
        XmlSchemaType type = (XmlSchemaType)this.schemaTypes.getItem(name);
        if (deep) {
            if (type == null) {
                Iterator includedItems = this.includes.getIterator();
                while (includedItems.hasNext()) {
                    XmlSchema schema = this.getSchema(includedItems.next());
                    if (schema == null) continue;
                    if (schemaStack == null) {
                        schemaStack = new Stack<XmlSchema>();
                    }
                    schemaStack.push(this);
                    type = schema.getTypeByName(name, deep, schemaStack);
                    if (type == null) continue;
                    return type;
                }
            } else {
                return type;
            }
        }
        return type;
    }

    public XmlSchemaType getTypeByName(QName name) {
        return this.getTypeByName(name, true, null);
    }

    public XmlSchemaType getTypeByName(String name) {
        QName nameToSearchFor = new QName(this.getTargetNamespace(), name);
        return this.getTypeByName(nameToSearchFor, false, null);
    }

    private XmlSchema getSchema(Object includeOrImport) {
        XmlSchema schema = includeOrImport instanceof XmlSchemaImport ? ((XmlSchemaImport)includeOrImport).getSchema() : (includeOrImport instanceof XmlSchemaInclude ? ((XmlSchemaInclude)includeOrImport).getSchema() : null);
        return schema;
    }

    public XmlSchemaDerivationMethod getFinalDefault() {
        return this.finalDefault;
    }

    public void setFinalDefault(XmlSchemaDerivationMethod finalDefault) {
        this.finalDefault = finalDefault;
    }

    public XmlSchemaObjectTable getGroups() {
        return this.groups;
    }

    public XmlSchemaObjectCollection getIncludes() {
        return this.includes;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public XmlSchemaObjectCollection getItems() {
        return this.items;
    }

    public XmlSchemaObjectTable getNotations() {
        return this.notations;
    }

    public XmlSchemaObjectTable getSchemaTypes() {
        return this.schemaTypes;
    }

    public String getTargetNamespace() {
        return this.syntacticalTargetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        if (!targetNamespace.equals("")) {
            this.syntacticalTargetNamespace = this.logicalTargetNamespace = targetNamespace;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void compile(ValidationEventHandler eh) {
    }

    public void write(OutputStream out) {
        try {
            if (this.inputEncoding != null && !"".equals(this.inputEncoding)) {
                this.write(new OutputStreamWriter(out, this.inputEncoding));
            } else {
                this.write(new OutputStreamWriter(out, UTF_8_ENCODING));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.write(new OutputStreamWriter(out));
        }
    }

    public void write(OutputStream out, Map options) {
        try {
            if (this.inputEncoding != null && !"".equals(this.inputEncoding)) {
                this.write(new OutputStreamWriter(out, this.inputEncoding), options);
            } else {
                this.write(new OutputStreamWriter(out, UTF_8_ENCODING), options);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.write(new OutputStreamWriter(out));
        }
    }

    public void write(Writer writer, Map options) {
        this.serialize_internal(this, writer, options);
    }

    public void write(Writer writer) {
        this.serialize_internal(this, writer, null);
    }

    public Document[] getAllSchemas() {
        try {
            XmlSchemaSerializer xser = new XmlSchemaSerializer();
            xser.setExtReg(this.parent.getExtReg());
            return xser.serializeSchema(this, true);
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    private void serialize_internal(XmlSchema schema, Writer out, Map options) {
        try {
            XmlSchemaSerializer xser = new XmlSchemaSerializer();
            xser.setExtReg(this.parent.getExtReg());
            Document[] serializedSchemas = xser.serializeSchema(schema, false);
            TransformerFactory trFac = TransformerFactory.newInstance();
            try {
                trFac.setAttribute("indent-number", "4");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            DOMSource source = new DOMSource(serializedSchemas[0]);
            StreamResult result = new StreamResult(out);
            Transformer tr = trFac.newTransformer();
            if (schema.inputEncoding != null && !"".equals(schema.inputEncoding)) {
                tr.setOutputProperty("encoding", schema.inputEncoding);
            }
            if (options == null) {
                options = new HashMap();
                this.loadDefaultOptions(options);
            }
            Iterator keys = options.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                tr.setOutputProperty((String)key, (String)options.get(key));
            }
            tr.transform(source, result);
            out.flush();
        }
        catch (TransformerConfigurationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (IOException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    private void loadDefaultOptions(Map options) {
        options.put("omit-xml-declaration", "yes");
        options.put("indent", "yes");
    }

    public void addType(XmlSchemaType type) {
        QName qname = type.getQName();
        if (this.schemaTypes.contains(qname)) {
            throw new XmlSchemaException(" Schema for namespace '" + this.syntacticalTargetNamespace + "' already contains type '" + qname.getLocalPart() + "'");
        }
        this.schemaTypes.add(qname, type);
    }

    public NamespacePrefixList getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespacePrefixList namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public boolean equals(Object what) {
        if (what == this) {
            return true;
        }
        if (!super.equals(what)) {
            return false;
        }
        if (!(what instanceof XmlSchema)) {
            return false;
        }
        XmlSchema xs = (XmlSchema)what;
        if (this.id != null ? !this.id.equals(xs.id) : xs.id != null) {
            return false;
        }
        return !(this.syntacticalTargetNamespace != null ? !this.syntacticalTargetNamespace.equals(xs.syntacticalTargetNamespace) : xs.syntacticalTargetNamespace != null);
    }

    public Document getSchemaDocument() throws XmlSchemaSerializer.XmlSchemaSerializerException {
        XmlSchemaSerializer xser = new XmlSchemaSerializer();
        xser.setExtReg(this.parent.getExtReg());
        return xser.serializeSchema(this, false)[0];
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String toString() {
        return super.toString() + "[" + this.logicalTargetNamespace + "]";
    }
}

