/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.airavata.registry.core.experiment.catalog.model.Process;
import org.apache.airavata.registry.core.experiment.catalog.model.TaskError;
import org.apache.airavata.registry.core.experiment.catalog.model.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="TASK")
public class Task {
    private static final Logger logger = LoggerFactory.getLogger(Task.class);
    private String taskId;
    private String taskType;
    private String parentProcessId;
    private Timestamp creationTime;
    private Timestamp lastUpdateTime;
    private String taskDetail;
    private byte[] setSubTaskModel;
    private Process process;
    private Collection<TaskError> taskErrors;
    private Collection<TaskStatus> taskStatuses;

    @Id
    @Column(name="TASK_ID")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Column(name="TASK_TYPE")
    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Column(name="PARENT_PROCESS_ID")
    public String getParentProcessId() {
        return this.parentProcessId;
    }

    public void setParentProcessId(String parentProcessId) {
        this.parentProcessId = parentProcessId;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Column(name="LAST_UPDATE_TIME")
    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Lob
    @Column(name="TASK_DETAIL")
    public String getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(String taskDetail) {
        this.taskDetail = taskDetail;
    }

    @Column(name="SUB_TASK_MODEL")
    public byte[] getSetSubTaskModel() {
        return this.setSubTaskModel;
    }

    public void setSetSubTaskModel(byte[] taskInternalStore) {
        this.setSubTaskModel = taskInternalStore;
    }

    @ManyToOne
    @JoinColumn(name="PARENT_PROCESS_ID", referencedColumnName="PROCESS_ID")
    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process processByParentProcessId) {
        this.process = processByParentProcessId;
    }

    @OneToMany(mappedBy="task")
    public Collection<TaskError> getTaskErrors() {
        return this.taskErrors;
    }

    public void setTaskErrors(Collection<TaskError> taskErrorsByTaskId) {
        this.taskErrors = taskErrorsByTaskId;
    }

    @OneToMany(mappedBy="task")
    public Collection<TaskStatus> getTaskStatuses() {
        return this.taskStatuses;
    }

    public void setTaskStatuses(Collection<TaskStatus> taskStatusesByTaskId) {
        this.taskStatuses = taskStatusesByTaskId;
    }
}

