/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal.permission.update;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.internal.permission.update.PermissionUpdateAxis2ConfigurationContextObserver;
import org.wso2.carbon.core.internal.permission.update.PermissionUpdateTask;
import org.wso2.carbon.core.internal.permission.update.PermissionUpdater;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class PermissionUpdateServiceComponent {
    private static Log log = LogFactory.getLog(PermissionUpdateServiceComponent.class);
    private static final long JOB_INTERVAL_SECS = 60L;
    private static final ScheduledExecutorService permUpdater = Executors.newScheduledThreadPool(1);
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    protected void activate(ComponentContext ctxt) {
        ctxt.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new PermissionUpdateAxis2ConfigurationContextObserver(), null);
        PermissionUpdater.update(-1234);
        try {
            if ("true".equals(this.dataHolder.getRealmService().getBootstrapRealmConfiguration().getAuthorizationPropertyValue("UpdatePermissionTreePeriodically"))) {
                permUpdater.scheduleAtFixedRate(new PermissionUpdateTask(), 60L, 60L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when retrieving the realm service for enabling the permission updater task. Disabling the periodic permission update task", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"********************* PermissionUpdateServiceComponent is activated..************");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        permUpdater.shutdownNow();
        if (log.isDebugEnabled()) {
            log.debug((Object)"PermissionUpdateServiceComponent is deactivated.");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry Service is set for PermissionUpdateServiceComponent.");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.dataHolder.setMainServerConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.dataHolder.setMainServerConfigContext(null);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                permUpdater.shutdownNow();
            }
        });
    }
}

