/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.Krb5AndCertsSslSocketConnector;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DFSck
extends Configured
implements Tool {
    private final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();

    public DFSck(Configuration conf) throws IOException {
        super(conf);
    }

    static void printUsage() {
        System.err.println("Usage: DFSck <path> [-move | -delete | -openforwrite] [-files [-blocks [-locations | -racks]]]");
        System.err.println("\t<path>\tstart checking from this path");
        System.err.println("\t-move\tmove corrupted files to /lost+found");
        System.err.println("\t-delete\tdelete corrupted files");
        System.err.println("\t-files\tprint out files being checked");
        System.err.println("\t-openforwrite\tprint out files opened for write");
        System.err.println("\t-blocks\tprint out block report");
        System.err.println("\t-locations\tprint out locations for every block");
        System.err.println("\t-racks\tprint out network topology for data-node locations");
        System.err.println("\t\tBy default fsck ignores files opened for write, use -openforwrite to report such files. They are usually  tagged CORRUPT or HEALTHY depending on their block allocation status");
        ToolRunner.printGenericCommandUsage(System.err);
    }

    @Override
    public int run(final String[] args) throws IOException {
        if (args.length == 0) {
            DFSck.printUsage();
            return -1;
        }
        try {
            return UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer run() throws Exception {
                    int idx;
                    if (SecurityUtil.useKsslAuth()) {
                        System.setProperty("https.cipherSuites", Krb5AndCertsSslSocketConnector.KRB5_CIPHER_SUITES.get(0));
                    }
                    StringBuffer url = new StringBuffer(NameNode.getHttpUriScheme() + "://");
                    url.append(NameNode.getInfoServer(DFSck.this.getConf())).append("/fsck?ugi=").append(DFSck.this.ugi.getShortUserName()).append("&path=");
                    String dir = "/";
                    for (idx = 0; idx < args.length; ++idx) {
                        if (args[idx].startsWith("-")) continue;
                        dir = args[idx];
                        break;
                    }
                    url.append(URLEncoder.encode(dir, "UTF-8"));
                    for (idx = 0; idx < args.length; ++idx) {
                        if (args[idx].equals("-move")) {
                            url.append("&move=1");
                            continue;
                        }
                        if (args[idx].equals("-delete")) {
                            url.append("&delete=1");
                            continue;
                        }
                        if (args[idx].equals("-files")) {
                            url.append("&files=1");
                            continue;
                        }
                        if (args[idx].equals("-openforwrite")) {
                            url.append("&openforwrite=1");
                            continue;
                        }
                        if (args[idx].equals("-blocks")) {
                            url.append("&blocks=1");
                            continue;
                        }
                        if (args[idx].equals("-locations")) {
                            url.append("&locations=1");
                            continue;
                        }
                        if (!args[idx].equals("-racks")) continue;
                        url.append("&racks=1");
                    }
                    URL path = new URL(url.toString());
                    URLConnection connection = SecurityUtil.openSecureHttpConnection(path);
                    InputStream stream = connection.getInputStream();
                    BufferedReader input = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    String line = null;
                    String lastLine = null;
                    int errCode = -1;
                    try {
                        while ((line = input.readLine()) != null) {
                            System.out.println(line);
                            lastLine = line;
                        }
                    }
                    finally {
                        input.close();
                    }
                    if (lastLine.endsWith("is HEALTHY")) {
                        errCode = 0;
                    } else if (lastLine.endsWith("is CORRUPT")) {
                        errCode = 1;
                    } else if (lastLine.endsWith("does not exist")) {
                        errCode = 0;
                    }
                    return errCode;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        int res = -1;
        if (args.length == 0 || "-files".equals(args[0])) {
            DFSck.printUsage();
        } else {
            res = ToolRunner.run(new DFSck(new Configuration()), args);
        }
        System.exit(res);
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
    }
}

