/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.bolt;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import storm.starter.tools.NthLastModifiedTimeTracker;
import storm.starter.tools.SlidingWindowCounter;
import storm.starter.util.TupleHelpers;

public class RollingCountBolt
extends BaseRichBolt {
    private static final long serialVersionUID = 5537727428628598519L;
    private static final Logger LOG = Logger.getLogger(RollingCountBolt.class);
    private static final int NUM_WINDOW_CHUNKS = 5;
    private static final int DEFAULT_SLIDING_WINDOW_IN_SECONDS = 300;
    private static final int DEFAULT_EMIT_FREQUENCY_IN_SECONDS = 60;
    private static final String WINDOW_LENGTH_WARNING_TEMPLATE = "Actual window length is %d seconds when it should be %d seconds (you can safely ignore this warning during the startup phase)";
    private final SlidingWindowCounter<Object> counter;
    private final int windowLengthInSeconds;
    private final int emitFrequencyInSeconds;
    private OutputCollector collector;
    private NthLastModifiedTimeTracker lastModifiedTracker;

    public RollingCountBolt() {
        this(300, 60);
    }

    public RollingCountBolt(int windowLengthInSeconds, int emitFrequencyInSeconds) {
        this.windowLengthInSeconds = windowLengthInSeconds;
        this.emitFrequencyInSeconds = emitFrequencyInSeconds;
        this.counter = new SlidingWindowCounter(this.deriveNumWindowChunksFrom(this.windowLengthInSeconds, this.emitFrequencyInSeconds));
    }

    private int deriveNumWindowChunksFrom(int windowLengthInSeconds, int windowUpdateFrequencyInSeconds) {
        return windowLengthInSeconds / windowUpdateFrequencyInSeconds;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        this.lastModifiedTracker = new NthLastModifiedTimeTracker(this.deriveNumWindowChunksFrom(this.windowLengthInSeconds, this.emitFrequencyInSeconds));
    }

    public void execute(Tuple tuple) {
        if (TupleHelpers.isTickTuple(tuple)) {
            LOG.debug((Object)"Received tick tuple, triggering emit of current window counts");
            this.emitCurrentWindowCounts();
        } else {
            this.countObjAndAck(tuple);
        }
    }

    private void emitCurrentWindowCounts() {
        Map<Object, Long> counts = this.counter.getCountsThenAdvanceWindow();
        int actualWindowLengthInSeconds = this.lastModifiedTracker.secondsSinceOldestModification();
        this.lastModifiedTracker.markAsModified();
        if (actualWindowLengthInSeconds != this.windowLengthInSeconds) {
            LOG.warn((Object)String.format(WINDOW_LENGTH_WARNING_TEMPLATE, actualWindowLengthInSeconds, this.windowLengthInSeconds));
        }
        this.emit(counts, actualWindowLengthInSeconds);
    }

    private void emit(Map<Object, Long> counts, int actualWindowLengthInSeconds) {
        for (Map.Entry<Object, Long> entry : counts.entrySet()) {
            Object obj = entry.getKey();
            Long count = entry.getValue();
            this.collector.emit((List)new Values(new Object[]{obj, count, actualWindowLengthInSeconds}));
        }
    }

    private void countObjAndAck(Tuple tuple) {
        Object obj = tuple.getValue(0);
        this.counter.incrementCount(obj);
        this.collector.ack(tuple);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"obj", "count", "actualWindowLengthInSeconds"}));
    }

    public Map<String, Object> getComponentConfiguration() {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.tick.tuple.freq.secs", this.emitFrequencyInSeconds);
        return conf;
    }
}

