/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.tools;

import java.io.Serializable;
import java.util.Map;
import storm.starter.tools.SlotBasedCounter;

public final class SlidingWindowCounter<T>
implements Serializable {
    private static final long serialVersionUID = -2645063988768785810L;
    private SlotBasedCounter<T> objCounter;
    private int headSlot;
    private int tailSlot;
    private int windowLengthInSlots;

    public SlidingWindowCounter(int windowLengthInSlots) {
        if (windowLengthInSlots < 2) {
            throw new IllegalArgumentException("Window length in slots must be at least two (you requested " + windowLengthInSlots + ")");
        }
        this.windowLengthInSlots = windowLengthInSlots;
        this.objCounter = new SlotBasedCounter(this.windowLengthInSlots);
        this.headSlot = 0;
        this.tailSlot = this.slotAfter(this.headSlot);
    }

    public void incrementCount(T obj) {
        this.objCounter.incrementCount(obj, this.headSlot);
    }

    public Map<T, Long> getCountsThenAdvanceWindow() {
        Map<T, Long> counts = this.objCounter.getCounts();
        this.objCounter.wipeZeros();
        this.objCounter.wipeSlot(this.tailSlot);
        this.advanceHead();
        return counts;
    }

    private void advanceHead() {
        this.headSlot = this.tailSlot;
        this.tailSlot = this.slotAfter(this.tailSlot);
    }

    private int slotAfter(int slot) {
        return (slot + 1) % this.windowLengthInSlots;
    }
}

