/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.aries.blueprint.plugin.model.JavaxTransactionFactory;
import org.apache.aries.blueprint.plugin.model.Matcher;
import org.apache.aries.blueprint.plugin.model.Property;
import org.apache.aries.blueprint.plugin.model.PropertyWriter;
import org.apache.aries.blueprint.plugin.model.SpringTransactionFactory;
import org.apache.aries.blueprint.plugin.model.TransactionalDef;
import org.springframework.stereotype.Component;

public class Bean
implements Comparable<Bean> {
    public String id;
    public Class<?> clazz;
    public String initMethod;
    public String destroyMethod;
    public SortedSet<Property> properties;
    public Field[] persistenceFields;
    public TransactionalDef transactionDef;

    public Bean(Class<?> clazz) {
        this.clazz = clazz;
        this.id = Bean.getBeanName(clazz);
        for (Method method : clazz.getDeclaredMethods()) {
            PreDestroy preDestroy;
            PostConstruct postConstruct = Bean.getEffectiveAnnotation(method, PostConstruct.class);
            if (postConstruct != null) {
                this.initMethod = method.getName();
            }
            if ((preDestroy = Bean.getEffectiveAnnotation(method, PreDestroy.class)) == null) continue;
            this.destroyMethod = method.getName();
        }
        this.persistenceFields = this.getPersistenceFields();
        this.transactionDef = new JavaxTransactionFactory().create(clazz);
        if (this.transactionDef == null) {
            this.transactionDef = new SpringTransactionFactory().create(clazz);
        }
        this.properties = new TreeSet<Property>();
    }

    private Field[] getPersistenceFields() {
        Field[] fields;
        ArrayList<Field> persistenceFields = new ArrayList<Field>();
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            PersistenceContext persistenceContext = field.getAnnotation(PersistenceContext.class);
            PersistenceUnit persistenceUnit = field.getAnnotation(PersistenceUnit.class);
            if (persistenceContext == null && persistenceUnit == null) continue;
            persistenceFields.add(field);
        }
        return persistenceFields.toArray(new Field[0]);
    }

    public void resolve(Matcher matcher) {
        for (Class<?> curClass = this.clazz; curClass != Object.class; curClass = curClass.getSuperclass()) {
            this.resolveProperties(matcher, curClass);
        }
    }

    private void resolveProperties(Matcher matcher, Class<?> curClass) {
        for (Field field : curClass.getDeclaredFields()) {
            Property prop = Property.create(matcher, field);
            if (prop == null) continue;
            this.properties.add(prop);
        }
    }

    public static String getBeanName(Class<?> clazz) {
        Component component = clazz.getAnnotation(Component.class);
        Named named = clazz.getAnnotation(Named.class);
        if (component != null && !"".equals(component.value())) {
            return component.value();
        }
        if (named != null && !"".equals(named.value())) {
            return named.value();
        }
        String name = clazz.getSimpleName();
        return Bean.getBeanNameFromSimpleName(name);
    }

    private static String getBeanNameFromSimpleName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
    }

    private static <T extends Annotation> T getEffectiveAnnotation(Method method, Class<T> annotationClass) {
        T annotation;
        Class<?> methodClass = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        T rootAnnotation = method.getAnnotation(annotationClass);
        if (rootAnnotation != null) {
            return rootAnnotation;
        }
        Class<?> superclass = methodClass.getSuperclass();
        if (superclass != null && (annotation = Bean.getMethodAnnotation(superclass, name, params, annotationClass)) != null) {
            return annotation;
        }
        for (Class<?> intfs : methodClass.getInterfaces()) {
            T annotation2 = Bean.getMethodAnnotation(intfs, name, params, annotationClass);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    private static <T extends Annotation> T getMethodAnnotation(Class<?> searchClass, String name, Class<?>[] params, Class<T> annotationClass) {
        try {
            Method method = searchClass.getMethod(name, params);
            return Bean.getEffectiveAnnotation(method, annotationClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean matches(Class<?> destType, String destId) {
        boolean assignable = destType.isAssignableFrom(this.clazz);
        return assignable && (destId == null || this.id.equals(destId));
    }

    @Override
    public int compareTo(Bean other) {
        return this.clazz.getName().compareTo(other.clazz.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.getName().hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public String toString() {
        return this.clazz.getName();
    }

    public void writeProperties(PropertyWriter writer) {
        for (Property property : this.properties) {
            writer.writeProperty(property);
        }
    }
}

