/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.frames;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ISlotManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.ophelpers.SlotOffTupleOff;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public abstract class TreeIndexNSMFrame
implements ITreeIndexFrame {
    protected static final int PAGE_LSN_OFFSET = 9;
    protected static final int TOTAL_FREE_SPACE_OFFSET = 17;
    protected static final int FLAG_OFFSET = 21;
    protected static final int RESERVED_HEADER_SIZE = 22;
    protected static final byte SMALL_FLAG_BIT = 1;
    protected static final byte LARGE_FLAG_BIT = 2;
    protected ICachedPage page = null;
    protected ByteBuffer buf = null;
    protected ISlotManager slotManager;
    protected ITreeIndexTupleWriter tupleWriter;
    protected ITreeIndexTupleReference frameTuple;

    public TreeIndexNSMFrame(ITreeIndexTupleWriter tupleWriter, ISlotManager slotManager) {
        this.tupleWriter = tupleWriter;
        this.frameTuple = tupleWriter.createTupleReference();
        this.slotManager = slotManager;
        this.slotManager.setFrame(this);
    }

    @Override
    public void initBuffer(byte level) {
        this.buf.putLong(9, 0L);
        this.buf.putInt(0, 0);
        this.resetSpaceParams();
        this.buf.put(8, level);
        this.buf.put(21, (byte)0);
    }

    @Override
    public int getMaxTupleSize(int pageSize) {
        return (pageSize - this.getPageHeaderSize()) / 2;
    }

    @Override
    public boolean isLeaf() {
        return this.buf.get(8) == 0;
    }

    public boolean getSmFlag() {
        return (this.buf.get(21) & 1) != 0;
    }

    public void setSmFlag(boolean smFlag) {
        if (smFlag) {
            this.buf.put(21, (byte)(this.buf.get(21) | 1));
        } else {
            this.buf.put(21, (byte)(this.buf.get(21) & 0xFFFFFFFE));
        }
    }

    public void setLargeFlag(boolean largeFlag) {
        if (largeFlag) {
            this.buf.put(21, (byte)(this.buf.get(21) | 2));
        } else {
            this.buf.put(21, (byte)(this.buf.get(21) & 0xFFFFFFFD));
        }
    }

    public boolean getLargeFlag() {
        return (this.buf.get(21) & 2) != 0;
    }

    @Override
    public boolean isInterior() {
        return this.buf.get(8) > 0;
    }

    @Override
    public byte getLevel() {
        return this.buf.get(8);
    }

    @Override
    public void setLevel(byte level) {
        this.buf.put(8, level);
    }

    @Override
    public int getFreeSpaceOff() {
        return this.buf.getInt(4);
    }

    @Override
    public void setFreeSpaceOff(int freeSpace) {
        this.buf.putInt(4, freeSpace);
    }

    @Override
    public void setPage(ICachedPage page) {
        this.page = page;
        this.buf = page.getBuffer();
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.page.getBuffer();
    }

    @Override
    public ICachedPage getPage() {
        return this.page;
    }

    @Override
    public boolean compact() {
        int i;
        this.resetSpaceParams();
        int tupleCount = this.buf.getInt(0);
        int freeSpace = this.buf.getInt(4);
        ArrayList<SlotOffTupleOff> sortedTupleOffs = new ArrayList<SlotOffTupleOff>();
        sortedTupleOffs.ensureCapacity(tupleCount);
        for (i = 0; i < tupleCount; ++i) {
            int slotOff = this.slotManager.getSlotOff(i);
            int tupleOff = this.slotManager.getTupleOff(slotOff);
            sortedTupleOffs.add(new SlotOffTupleOff(i, slotOff, tupleOff));
        }
        Collections.sort(sortedTupleOffs);
        for (i = 0; i < sortedTupleOffs.size(); ++i) {
            int tupleOff = ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleOff;
            this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
            int tupleEndOff = this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1);
            int tupleLength = tupleEndOff - tupleOff;
            System.arraycopy(this.buf.array(), tupleOff, this.buf.array(), freeSpace, tupleLength);
            this.slotManager.setSlot(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff, freeSpace);
            freeSpace += tupleLength;
        }
        this.buf.putInt(4, freeSpace);
        this.buf.putInt(17, this.buf.capacity() - freeSpace - tupleCount * this.slotManager.getSlotSize());
        return false;
    }

    @Override
    public void delete(ITupleReference tuple, int tupleIndex) {
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
        int tupleSize = this.tupleWriter.bytesRequired(this.frameTuple);
        int slotStartOff = this.slotManager.getSlotEndOff();
        int length = slotOff - slotStartOff;
        System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        this.buf.putInt(0, this.buf.getInt(0) - 1);
        this.buf.putInt(17, this.buf.getInt(17) + tupleSize + this.slotManager.getSlotSize());
    }

    @Override
    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) throws HyracksDataException {
        int bytesRequired = this.tupleWriter.bytesRequired(tuple);
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.capacity() - this.buf.getInt(4) - this.buf.getInt(0) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.getInt(17)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    @Override
    public FrameOpSpaceStatus hasSpaceUpdate(ITupleReference newTuple, int oldTupleIndex) {
        this.frameTuple.resetByTupleIndex(this, oldTupleIndex);
        int oldTupleBytes = this.frameTuple.getTupleSize();
        int newTupleBytes = this.tupleWriter.bytesRequired(newTuple);
        return this.hasSpaceUpdate(oldTupleBytes, newTupleBytes);
    }

    protected FrameOpSpaceStatus hasSpaceUpdate(int oldTupleBytes, int newTupleBytes) {
        int additionalBytesRequired = newTupleBytes - oldTupleBytes;
        if (additionalBytesRequired <= 0) {
            return FrameOpSpaceStatus.SUFFICIENT_INPLACE_SPACE;
        }
        if (newTupleBytes <= this.buf.capacity() - this.buf.getInt(4) - this.buf.getInt(0) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (additionalBytesRequired <= this.buf.getInt(17)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    protected void resetSpaceParams() {
        this.buf.putInt(4, this.getPageHeaderSize());
        this.buf.putInt(17, this.buf.capacity() - this.getPageHeaderSize());
    }

    @Override
    public void insert(ITupleReference tuple, int tupleIndex) {
        this.slotManager.insertSlot(tupleIndex, this.buf.getInt(4));
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf.array(), this.buf.getInt(4));
        this.buf.putInt(0, this.buf.getInt(0) + 1);
        this.buf.putInt(4, this.buf.getInt(4) + bytesWritten);
        this.buf.putInt(17, this.buf.getInt(17) - bytesWritten - this.slotManager.getSlotSize());
    }

    @Override
    public void update(ITupleReference newTuple, int oldTupleIndex, boolean inPlace) {
        this.frameTuple.resetByTupleIndex(this, oldTupleIndex);
        int oldTupleBytes = this.frameTuple.getTupleSize();
        int slotOff = this.slotManager.getSlotOff(oldTupleIndex);
        int bytesWritten = 0;
        if (inPlace) {
            bytesWritten = this.tupleWriter.writeTuple(newTuple, this.buf.array(), this.buf.getInt(slotOff));
        } else {
            int newTupleOff = this.buf.getInt(4);
            bytesWritten = this.tupleWriter.writeTuple(newTuple, this.buf.array(), newTupleOff);
            this.buf.putInt(slotOff, newTupleOff);
            this.buf.putInt(4, newTupleOff + bytesWritten);
        }
        this.buf.putInt(17, this.buf.getInt(17) + oldTupleBytes - bytesWritten);
    }

    @Override
    public String printHeader() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("pageLsnOff:        9\n");
        strBuilder.append("tupleCountOff:     0\n");
        strBuilder.append("freeSpaceOff:      4\n");
        strBuilder.append("totalFreeSpaceOff: 17\n");
        strBuilder.append("levelOff:          8\n");
        strBuilder.append("flagOff:           21\n");
        return strBuilder.toString();
    }

    @Override
    public int getTupleCount() {
        return this.buf.getInt(0);
    }

    @Override
    public ISlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public int getTupleOffset(int slotNum) {
        return this.slotManager.getTupleOff(this.slotManager.getSlotStartOff() - slotNum * this.slotManager.getSlotSize());
    }

    @Override
    public long getPageLsn() {
        return this.buf.getLong(9);
    }

    @Override
    public void setPageLsn(long pageLsn) {
        this.buf.putLong(9, pageLsn);
    }

    @Override
    public int getTotalFreeSpace() {
        return this.buf.getInt(17);
    }

    @Override
    public boolean compress() {
        return false;
    }

    @Override
    public int getSlotSize() {
        return this.slotManager.getSlotSize();
    }

    @Override
    public ITreeIndexTupleWriter getTupleWriter() {
        return this.tupleWriter;
    }

    @Override
    public ITreeIndexTupleReference createTupleReference() {
        return this.tupleWriter.createTupleReference();
    }

    public int getFreeContiguousSpace() {
        return this.buf.capacity() - this.getFreeSpaceOff() - this.getTupleCount() * this.slotManager.getSlotSize();
    }

    @Override
    public ITupleReference getLeftmostTuple() {
        int tupleCount = this.getTupleCount();
        if (tupleCount == 0) {
            return null;
        }
        this.frameTuple.resetByTupleIndex(this, 0);
        return this.frameTuple;
    }

    @Override
    public ITupleReference getRightmostTuple() {
        int tupleCount = this.getTupleCount();
        if (tupleCount == 0) {
            return null;
        }
        this.frameTuple.resetByTupleIndex(this, tupleCount - 1);
        return this.frameTuple;
    }
}

